/*
* @category    Store usuarios Sistema
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridUsuariosSist = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridUsuariosSist.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridUsuariosSist',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/usuariossit/controlador_usuariosist.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR"},
            autoload: false,
            reader: new Ext.data.JsonReader({
                root: 'results'
            },
            [
                { name: 'IdEmpresa' },
                { name: 'IdUsuario' },
                { name: 'CodUsuario' },
                { name: 'ClaveUsuario' },
                { name: 'Descripcion' },
                { name: 'IdPerfil' },
                { name: 'IdProfesionalHC' },
                { name: 'Activo' },
                { name: 'NomProfesional' }
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridUsuariosSist();
