/*
* @category    Store usuarios Sistema
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridUsuariosSistxBodegas = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridUsuariosSistxBodegas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridUsuariosSistxBodegas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/usuariossit/controlador_usuariosist.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_USRxBODEGA"},
            autoload: false,
            reader: new Ext.data.JsonReader({
                root: 'results'
            },
            [
                { name: 'IdUsuario' },
                { name: 'IdBodega' },
                { name: 'Descripcion' }
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridUsuariosSistxBodegas();
