/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmVerAgenda = Ext.extend(winFrmVerAgendaUi, {
    initComponent: function() {
        winFrmVerAgenda.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('nomusuario');
        NOM_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        ID_PROGRAMA = 0;
        wURL = "";
        wNomImagen = "";
        winImgxPac = "";
        winDocxPac = "";
        paramOpcion = "Nuevo";
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        Ext.getCmp('sysProfeAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pUsuario: ID_USUARIO
            }
        }); 
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        wAsignarProximaCita = 0;
        
        searchStoreExaCVM = new Ext.data.Store({
            //id: 'dsSolExaIPS002',
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/asistencial/controlador_oficlinic_solexa.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, 
            [
                {name: 'Codigo'},
                {name: 'Descripcion'},
                {name: 'TipoEstudio'},
                {name: 'Tarifa'},
                {name: 'TipoAutoriza'},
                {name: 'EsCX'}
            ])
        });
        
        var sysProfesionalAgenda = Ext.getCmp('sysProfeAgenda').on("select",this.CargaUbicacionAgenda,this);
        var sysUbicacionAgenda = Ext.getCmp('sysUbicacionAgenda').on("select",this.CargaFechasAgenda,this);
        var sysFechaAgenda = Ext.getCmp('sysFechaAgenda').on("select",this.CargaDetalleAgenda,this);
        
        //var btnLegalizarCita = Ext.getCmp('btnLegalizarCita').on("click",this.LegalizarCita,this);
        //var btnCancelarCita = Ext.getCmp('btnCancelarCita').on("click",this.CancelarCita,this);
        var btnInasistenciaCita = Ext.getCmp('btnInasistenciaCita').on("click",this.InasistenciaCita,this);
        var btnActualizarAgenda = Ext.getCmp('btnActualizarAgenda').on("click",this.ActualizarAgenda,this);
        var btnEvolucionar = Ext.getCmp('btnEvolucionar').on("click",this.EvolucionarPaciente,this);
        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
    },
    LegalizarCita: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.YaLegalizado == '0' && (selections[0].json.MarcaExenta == '1' || selections[0].json.MarcaExenta == 't')){
                xCAS = selections[0].json.CAS;
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea legalizar la cita exenta de pago?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            Ext.Ajax.request(
                            {
                                url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                params:{
                                    PROCESO: 'LegalizarExentaCita',
                                    pCAS: xCAS,
                                    pEmpresa: ID_EMPRESA,
                                    pIPS: ID_IPS,
                                    pUsuario: ID_USUARIO
                                },
                                success: function(response,options)
                                {
                                    var Respuesta = response.responseText;
                                    var Contenido = Respuesta.split('^');
                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                        Ext.MessageBox.show({
                                            title: 'eOfiClinic',
                                            msg: 'Ocurrio un error al legalizar la orden de servicios.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    } else {
                                        Ext.getCmp('gridFormulario').store.reload();
                                    }
                                },
                                failure: function(response,options){
                                    Ext.MessageBox.show({
                                        title: 'eOfiClinic',
                                        msg: 'Ocurrio un error al legalizar la orden de servicios o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                },
                                scope:this
                            });
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'La Cita Ya Esta Legalizada o No Se Marco como Exenta',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    EvolucionarPaciente: function(){
        wAsignarProximaCita = 0;
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if(parseInt(selections[0].json.YaEvolucionado) === 1){
                //*********************************************
                var totalRegistros = -1;
                stCIE10 = new StoreCIE10();
                objMX = "NA";
                objMXADD = "NA";
                objEXA = "NA";
                objEXAADD = "NA";
                objREM = "NA";
                objREMADD = "NA";
                wPaciente = selections[0].json.Paciente;
                wCAS = selections[0].json.CAS;
                wAsignarProximaCita = 1;
                wNomPac = selections[0].json.TipDoc + "-" + selections[0].json.Documento + " " + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido;
                if(selections[0].json.RutaFrmMx !== null && selections[0].json.RutaFrmMx !== ""){
                    ScriptMgr.loadJs({
                        scripts : selections[0].json.RutaFrmMx,
                        callback : function(){
                            objMX = selections[0].json.NomObjetoMx;
                            ScriptMgr.loadJs({
                                scripts : selections[0].json.RutaFrmAddMx,
                                callback : function(){
                                    objMXADD = selections[0].json.NomObjetoAddMx;
                                }
                            });
                        }
                    });
                }
                if(selections[0].json.RutaFrmExa !== null && selections[0].json.RutaFrmExa !== ""){
                    ScriptMgr.loadJs({
                        scripts : selections[0].json.RutaFrmExa,
                        callback : function(){
                            objEXA = selections[0].json.NomObjetoExa;
                            ScriptMgr.loadJs({
                                scripts : selections[0].json.RutaFrmAddExa,
                                callback : function(){
                                    objEXAADD = selections[0].json.NomObjetoAddExa;
                                }
                            });
                        }
                    });
                }
                if(selections[0].json.RutaFrmRem !== null && selections[0].json.RutaFrmRem !== ""){
                    ScriptMgr.loadJs({
                        scripts : selections[0].json.RutaFrmRem,
                        callback : function(){
                            objREM = selections[0].json.NomObjetoRem;
                            ScriptMgr.loadJs({
                                scripts : selections[0].json.RutaFrmAddRem,
                                callback : function(){
                                    objREMADD = selections[0].json.NomObjetoAddRem;
                                }
                            });
                        }
                    });
                }
                if(selections[0].json.UsaTestBarthel !== null && selections[0].json.UsaTestBarthel !== "" && selections[0].json.UsaTestBarthel === "1"){
                    ScriptMgr.loadJs({
                        scripts : '../../../app/frm_js/asistencial/ofimedical/wintestbarthel.ui.js'
                    });
                }
                if(selections[0].json.UsaTestHachinski !== null && selections[0].json.UsaTestHachinski !== "" && selections[0].json.UsaTestHachinski === "1"){
                    ScriptMgr.loadJs({
                        scripts : '../../../app/frm_js/asistencial/ofimedical/wintesthachinski.ui.js'
                    });
                }
                if(selections[0].json.UsaTestFolstein !== null && selections[0].json.UsaTestFolstein !== "" && selections[0].json.UsaTestFolstein === "1"){
                    ScriptMgr.loadJs({
                        scripts : '../../../app/frm_js/asistencial/ofimedical/wintestfolstein.ui.js'
                    });
                }
                if(selections[0].json.UsaTestLawton !== null && selections[0].json.UsaTestLawton !== "" && selections[0].json.UsaTestLawton === "1"){
                    ScriptMgr.loadJs({
                        scripts : '../../../app/frm_js/asistencial/ofimedical/wintestlawton.ui.js'
                    });
                }
                if(selections[0].json.UsaTestYesavage !== null && selections[0].json.UsaTestYesavage !== "" && selections[0].json.UsaTestYesavage === "1"){
                    ScriptMgr.loadJs({
                        scripts : '../../../app/frm_js/asistencial/ofimedical/wintestyesavage.ui.js'
                    });
                }

                //alert("Plantilla: " + selections[0].json.IdPlantilla);
                // ***** CARGAR LOS COMPONENTES ASOCIADOS A LA PLANTILLA
                var dsComponentesPlantilla = new Ext.data.Store({
                    id: 'dsComponentesPlantilla',
                    proxy: new Ext.data.HttpProxy({
                        url: '../../controlador/asistencial/controlador_plantillashc.php',
                        method: 'POST'
                    }),
                    baseParams: {
                        task: "LISTAR_COMPONENTES",
                        pPlantilla: selections[0].json.IdPlantilla
                    },
                    loadMask: {msg:"Cargando Registros, por favor espere..."},
                    autoload: false,
                    reader: new Ext.data.JsonReader({
                        root: 'results',
                        totalProperty: 'total',
                        id: 'id'
                      },[
                        {name: 'RutaComponente'},
                        {name: 'NomComponente'},
                        {name: 'Tipo'}
                     ])
                });

                dsComponentesPlantilla.load({
                    callback: function(){
                        var totalRegistros = dsComponentesPlantilla.getTotalCount();
                        var i = 0;
                        if(totalRegistros !== 0 && totalRegistros !== -1){
                            dsComponentesPlantilla.each(function(record){
                                ScriptMgr.loadJs({
                                    scripts : record.get('RutaComponente'),
                                    callback: function(){
                                        i++;
                                        //alert("componente: " + record.get('NomComponente'));
                                        //cargarFormularioHC(i,totalRegistros, selections[0].json.RutaPlantilla,selections[0].json.NomObjeto,selections[0].json.NomPlantilla, selections[0].json.IdPlantilla, selections[0].json.RutaRptHC, selections[0].json.RutaRptMx, selections[0].json.RutaRptExa, selections[0].json.RutaRptRem);
                                        if(i === totalRegistros){
                                            //alert("Se cargo el frm");
                                            ScriptMgr.loadJs({
                                                scripts : selections[0].json.RutaPlantilla,
                                                waitMsg: 'Por favor Espere...',
                                                callback : function(){
                                                    wPaciente = selections[0].json.Paciente;
                                                    wCAS = selections[0].json.CAS;
                                                    paramOpcion = "Modificar";
                                                    var winHC = eval(selections[0].json.NomObjeto);//new winHCUi();
                                                    var infGenero = "";
                                                    if(selections[0].json.Genero === "M"){
                                                        infGenero = "MASCULINO";
                                                    }else{
                                                        infGenero = "FEMENINO";
                                                    }
                                                    winHC.setTitle(winHC.title + ' - <span style="color:red;"><b>' + PonerAcentosMayusculas(selections[0].json.TipDoc + '-' + selections[0].json.Documento + ' ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido) + ' - Genero: ' + infGenero + '</b></span>');
                                                    
                                                    Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.NomPlantilla));
                                                    
                                                    Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                                                    Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                                                    Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                                                    Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                                                    Ext.getCmp('sysProfesionalHC').setValue(Ext.getCmp('sysProfeAgenda').getValue()); 
                                                    Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                                                    Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                                                    Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                                                    Ext.getCmp('sysProfesionalAgendaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgenda').getRawValue()));
                                                    Ext.getCmp('sysFechaHC').setValue(selections[0].json.FechaAtencion);
                                                    Ext.getCmp('sysHoraHC').setValue(selections[0].json.HoraApertura);
                                                    Ext.getCmp('sysLegalizaHC').setValue(selections[0].json.HoraAtencion);
                                                    Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(wNomPac));
                                                    Ext.getCmp('sysAperturaHC').setValue(selections[0].json.HoraApertura);
                                                    Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
                                                    Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.idCliente);
                                                    Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
                                                    Ext.getCmp('sysIdCodPlantillaHC').setValue(selections[0].json.IdPlantilla);

                                                    try {
                                                        var campo2 = Ext.getCmp('sysRutaRptHC');
                                                        if ( campo2 !== null ) {
                                                            Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptHC));
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campo3 = Ext.getCmp('sysRutaRptMx');
                                                        if ( campo3 !== null ) {
                                                            Ext.getCmp('sysRutaRptMx').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptMx));
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campo4 = Ext.getCmp('sysRutaRptExa');
                                                        if ( campo4 !== null ) {
                                                            Ext.getCmp('sysRutaRptExa').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptExa));
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campo5 = Ext.getCmp('sysRutaRptRem');
                                                        if ( campo5 !== null ) {
                                                            Ext.getCmp('sysRutaRptRem').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptRem));
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try { 
                                                        var campo6 = Ext.getCmp('sysInfoPacHCEdad');
                                                        if ( campo6 !== null ) {
                                                            if (selections[0].json.FecNac !== null && selections[0].json.FecNac !== ""){
                                                                var xfecnac = Array();
                                                                xfecnac = selections[0].json.FecNac.split('/');
                                                                var dianac = xfecnac[0];
                                                                var mesnac = (xfecnac[1].length < 2)?'0':'';
                                                                mesnac += xfecnac[1];
                                                                var anonac = xfecnac[2];
                                                                var newFecNac = anonac + "/" + mesnac + "/" + dianac;
                                                                newEdad = MostrarEdadCompleta(selections[0].json.FechaCita,newFecNac);
                                                                Ext.getCmp('sysInfoPacHCEdad').setValue(newEdad);
                                                            }
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campo9 = Ext.getCmp('sysInfoPacHCDireccion');
                                                        if ( campo9 !== null ) {
                                                            Ext.getCmp('sysInfoPacHCDireccion').setValue(selections[0].json.Direccion);
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campo10 = Ext.getCmp('sysInfoPacHCTelefonos');
                                                        if ( campo10 !== null ) {
                                                            Ext.getCmp('sysInfoPacHCTelefonos').setValue(selections[0].json.Telefono + " - " + selections[0].json.Telefono1);
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        if(selections[0].json.Genero !== null){
                                                            var campo3_1 = Ext.getCmp('sysGeneroPacHC');
                                                            if(selections[0].json.Genero === "M"){
                                                                Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                                            }else{
                                                                Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                                            }
                                                        }
                                                    }catch(ex) {
                                                    }

                                                    //OJO OMAR
                                                    try {
                                                        if(selections[0].json.Genero !== null){
                                                            var campo3_2 = Ext.getCmp('sysGeneroPacHC');
                                                            if(selections[0].json.Genero === "M"){
                                                                Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
                                                            }else{
                                                                Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
                                                            }
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campo5_2 = Ext.getCmp('sysFechaNac');
                                                        if ( campo5_2 !== null ) {
                                                            Ext.getCmp('sysFechaNac').setValue(selections[0].json.FecNac);
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campo4_2 = Ext.getCmp('sysEdadHC');
                                                        if ( campo4_2 !== null ) {
                                                            if (selections[0].json.FecNac !== null && selections[0].json.FecNac !== ""){
                                                                var xfecnac = Array();
                                                                xfecnac = selections[0].json.FecNac.split('/');
                                                                var dianac = xfecnac[0];
                                                                var mesnac = (xfecnac[1].length < 2)?'0':'';
                                                                mesnac += xfecnac[1];
                                                                var anonac = xfecnac[2];
                                                                var newFecNac = anonac + "/" + mesnac + "/" + dianac;
                                                                newEdad = MostrarEdadCompleta(selections[0].json.FechaCita,newFecNac);
                                                                Ext.getCmp('sysEdadHC').setValue(newEdad);
                                                            }
                                                        }
                                                    }catch(ex) {
                                                    }    
                                                    //FIN OMAR


                                                    try {
                                                        var campo4_1 = Ext.getCmp('sysEdadPacHC');
                                                        if ( campo4_1 !== null ) {
                                                            if (selections[0].json.FecNac !== null && selections[0].json.FecNac !== ""){
                                                                var xfecnac = Array();
                                                                xfecnac = selections[0].json.FecNac.split('/');
                                                                var dianac = xfecnac[0];
                                                                var mesnac = (xfecnac[1].length < 2)?'0':'';
                                                                mesnac += xfecnac[1];
                                                                var anonac = xfecnac[2];
                                                                var newFecNac = anonac + "/" + mesnac + "/" + dianac;
                                                                newEdad = MostrarEdadCompleta(selections[0].json.FechaCita,newFecNac);
                                                                Ext.getCmp('sysEdadPacHC').setValue(newEdad);
                                                            }
                                                        }
                                                    }catch(ex) {
                                                    }    
                                                    try {
                                                        var campo5_1 = Ext.getCmp('sysFecNacPacHC');
                                                        if ( campo5_1 !== null ) {
                                                            Ext.getCmp('sysFecNacPacHC').setValue(selections[0].json.FecNac);
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    winHC.show();
                                                    CargarDataHC(selections[0].json.Evolucion);
                                                    CargarDataHC(selections[0].json.Barthel);
                                                    CargarDataHC(selections[0].json.Hachinski);
                                                    CargarDataHC(selections[0].json.Lawton);
                                                    CargarDataHC(selections[0].json.Folstein);
                                                    CargarDataHC(selections[0].json.Yesavage);
                                                    CargarDataHC(selections[0].json.MNA);
                                                    Ext.getCmp('sysYaGuardoHC').setValue(1);
                                                    try {
                                                        var campoDiagppal = Ext.getCmp('sysDiagPpalHC');
                                                        if ( campoDiagppal !== null ) {
                                                            Ext.getCmp('sysDiagPpalHC').setValue(selections[0].json.Diagppal);
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: selections[0].json.Diagppal.toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                        // Nada
                                                                    } else {
                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    //nada
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campoDiagrel1 = Ext.getCmp('sysDiagRel1HC');
                                                        if ( campoDiagrel1 !== null ) {
                                                            Ext.getCmp('sysDiagRel1HC').setValue(selections[0].json.Diagrel1);
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: selections[0].json.Diagrel1.toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                        // Nada
                                                                    } else {
                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    //nada
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campoDiagrel2 = Ext.getCmp('sysDiagRel2HC');
                                                        if ( campoDiagrel2 !== null ) {
                                                            Ext.getCmp('sysDiagRel2HC').setValue(selections[0].json.DiagRel2);
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: selections[0].json.DiagRel2.toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                        // Nada
                                                                    } else {
                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    //nada
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campoDiagrel3 = Ext.getCmp('sysDiagRel3HC');
                                                        if ( campoDiagrel3 !== null ) {
                                                            Ext.getCmp('sysDiagRel3HC').setValue(selections[0].json.DiagRel3);
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: selections[0].json.DiagRel3.toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                        // Nada
                                                                    } else {
                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    //nada
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campoTipodiag = Ext.getCmp('sysTipoDiagosticoHC');
                                                        if ( campoTipodiag !== null ) {
                                                            Ext.getCmp('sysTipoDiagosticoHC').setValue(selections[0].json.Tipodiag);
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campoFinalidad = Ext.getCmp('sysFinalidadConsultaHC');
                                                        if ( campoFinalidad !== null ) {
                                                            Ext.getCmp('sysFinalidadConsultaHC').setValue(selections[0].json.Finalidad);
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    try {
                                                        var campoCausaExterna = Ext.getCmp('sysCausaExternaHC');
                                                        if ( campoCausaExterna !== null ) {
                                                            Ext.getCmp('sysCausaExternaHC').setValue(selections[0].json.CausaExterna);
                                                        }
                                                    }catch(ex) {
                                                    }
                                                    //Aqui deberia ir el mostrar el contenido de la hc
                                                }
                                            });
                                        }
                                    }
                                });
                            });
                        }else{
                            ScriptMgr.loadJs({
                                scripts : selections[0].json.RutaPlantilla,
                                waitMsg: 'Por favor Espere...',
                                callback : function(){
                                    wPaciente = selections[0].json.Paciente;
                                    wCAS = selections[0].json.CAS;
                                    paramOpcion = "Modificar";
                                    var winHC = eval(selections[0].json.NomObjeto);//new winHCUi();
                                    
                                    var infGenero = "";
                                    if(selections[0].json.Genero === "M"){
                                        infGenero = "MASCULINO";
                                    }else{
                                        infGenero = "FEMENINO";
                                    }
                                    winHC.setTitle(winHC.title + ' - <span style="color:red;"><b>' + PonerAcentosMayusculas(selections[0].json.TipDoc + '-' + selections[0].json.Documento + ' ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido) + ' - Genero: ' + infGenero + '</b></span>');
                                    Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.NomPlantilla));

                                    Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                                    Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                                    Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                                    Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                                    Ext.getCmp('sysProfesionalHC').setValue(Ext.getCmp('sysProfeAgenda').getValue()); 
                                    Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                                    Ext.getCmp('sysClienteHC').setValue(selections[0].json.Cliente);
                                    Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                                    Ext.getCmp('sysProfesionalAgendaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgenda').getRawValue()));
                                    Ext.getCmp('sysFechaHC').setValue(selections[0].json.FechaAtencion);
                                    Ext.getCmp('sysHoraHC').setValue(selections[0].json.HoraApertura);
                                    Ext.getCmp('sysLegalizaHC').setValue(selections[0].json.HoraAtencion);
                                    Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(wNomPac));
                                    Ext.getCmp('sysAperturaHC').setValue(selections[0].json.HoraApertura);
                                    Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoDetalle);
                                    Ext.getCmp('sysIdClienteHC').setValue(selections[0].json.idCliente);
                                    Ext.getCmp('sysIdContratoHC').setValue(selections[0].json.idContrato);
                                    Ext.getCmp('sysIdCodPlantillaHC').setValue(selections[0].json.IdPlantilla);

                                    try {
                                        var campo2 = Ext.getCmp('sysRutaRptHC');
                                        if ( campo2 !== null ) {
                                            Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptHC));
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campo3 = Ext.getCmp('sysRutaRptMx');
                                        if ( campo3 !== null ) {
                                            Ext.getCmp('sysRutaRptMx').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptMx));
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campo4 = Ext.getCmp('sysRutaRptExa');
                                        if ( campo4 !== null ) {
                                            Ext.getCmp('sysRutaRptExa').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptExa));
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campo5 = Ext.getCmp('sysRutaRptRem');
                                        if ( campo5 !== null ) {
                                            Ext.getCmp('sysRutaRptRem').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptRem));
                                        }
                                    }catch(ex) {
                                    }
                                    try { 
                                        var campo6 = Ext.getCmp('sysInfoPacHCEdad');
                                        if ( campo6 !== null ) {
                                            Ext.getCmp('sysInfoPacHCEdad').setValue(selections[0].json.Edad);
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campo9 = Ext.getCmp('sysInfoPacHCDireccion');
                                        if ( campo9 !== null ) {
                                            Ext.getCmp('sysInfoPacHCDireccion').setValue(selections[0].json.Direccion);
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campo10 = Ext.getCmp('sysInfoPacHCTelefonos');
                                        if ( campo10 !== null ) {
                                            Ext.getCmp('sysInfoPacHCTelefonos').setValue(selections[0].json.Telefono + " - " + selections[0].json.Telefono1);
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        if(selections[0].json.Genero !== null){
                                            var campo3_1 = Ext.getCmp('sysGeneroPacHC');
                                            if(selections[0].json.Genero === "M"){
                                                Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                            }else{
                                                Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                            }
                                        }
                                    }catch(ex) {
                                    }

                                    //OJO OMAR
                                    try {
                                        if(selections[0].json.Genero !== null){
                                            var campo3_2 = Ext.getCmp('sysGeneroPacHC');
                                            if(selections[0].json.Genero === "M"){
                                                Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
                                            }else{
                                                Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
                                            }
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campo5_2 = Ext.getCmp('sysFechaNac');
                                        if ( campo5_2 !== null ) {
                                            Ext.getCmp('sysFechaNac').setValue(selections[0].json.FecNac);
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campo4_2 = Ext.getCmp('sysEdadHC');
                                        var campo4_2 = Ext.getCmp('sysEdadHC');
                                        if ( campo4_2 !== null ) {
                                            if (selections[0].json.FecNac !== null && selections[0].json.FecNac !== ""){
                                                var xfecnac = Array();
                                                xfecnac = selections[0].json.FecNac.split('/');
                                                var dianac = xfecnac[0];
                                                var mesnac = (xfecnac[1].length < 2)?'0':'';
                                                mesnac += xfecnac[1];
                                                var anonac = xfecnac[2];
                                                var newFecNac = anonac + "/" + mesnac + "/" + dianac;
                                                newEdad = MostrarEdadCompleta(selections[0].json.FechaCita,newFecNac);
                                                Ext.getCmp('sysEdadHC').setValue(newEdad);
                                            }
                                        }
                                    }catch(ex) {
                                    }    
                                    //FIN OMAR
                                    try {
                                        var campo4_1 = Ext.getCmp('sysEdadPacHC');
                                        if ( campo4_1 !== null ) {
                                            if (selections[0].json.FecNac !== null && selections[0].json.FecNac !== ""){
                                                var xfecnac = Array();
                                                xfecnac = selections[0].json.FecNac.split('/');
                                                var dianac = xfecnac[0];
                                                var mesnac = (xfecnac[1].length < 2)?'0':'';
                                                mesnac += xfecnac[1];
                                                var anonac = xfecnac[2];
                                                var newFecNac = anonac + "/" + mesnac + "/" + dianac;
                                                newEdad = MostrarEdadCompleta(selections[0].json.FechaCita,newFecNac);
                                                Ext.getCmp('sysEdadPacHC').setValue(newEdad);
                                            }
                                        }
                                    }catch(ex) {
                                    }    
                                    try {
                                        var campo5_1 = Ext.getCmp('sysFecNacPacHC');
                                        if ( campo5_1 !== null ) {
                                            Ext.getCmp('sysFecNacPacHC').setValue(selections[0].json.FecNac);
                                        }
                                    }catch(ex) {
                                    }
                                    winHC.show();
                                    //Aqui deberia ir el mostrar el contenido de la hc
                                    CargarDataHC(selections[0].json.Evolucion);
                                    CargarDataHC(selections[0].json.Barthel);
                                    CargarDataHC(selections[0].json.Hachinski);
                                    CargarDataHC(selections[0].json.Lawton);
                                    CargarDataHC(selections[0].json.Folstein);
                                    CargarDataHC(selections[0].json.Yesavage);
                                    CargarDataHC(selections[0].json.MNA);
                                    Ext.getCmp('sysYaGuardoHC').setValue(1);
                                    try {
                                        var campoDiagppal = Ext.getCmp('sysDiagPpalHC');
                                        if ( campoDiagppal !== null ) {
                                            Ext.getCmp('sysDiagPpalHC').setValue(selections[0].json.Diagppal);
                                            Ext.Ajax.request({
                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                params:{
                                                    task: 'BUSCAR',
                                                    pCodigo: selections[0].json.Diagppal.toUpperCase()
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); // get the LOG
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        // Nada
                                                    } else {
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                    }
                                                },
                                                failure: function(response,options){
                                                    //nada
                                                },
                                                scope:this //bind the callbacks
                                            });
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campoDiagrel1 = Ext.getCmp('sysDiagRel1HC');
                                        if ( campoDiagrel1 !== null ) {
                                            Ext.getCmp('sysDiagRel1HC').setValue(selections[0].json.Diagrel1);
                                            Ext.Ajax.request({
                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                params:{
                                                    task: 'BUSCAR',
                                                    pCodigo: selections[0].json.Diagrel1.toUpperCase()
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); // get the LOG
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        // Nada
                                                    } else {
                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                    }
                                                },
                                                failure: function(response,options){
                                                    //nada
                                                },
                                                scope:this //bind the callbacks
                                            });
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campoDiagrel2 = Ext.getCmp('sysDiagRel2HC');
                                        if ( campoDiagrel2 !== null ) {
                                            Ext.getCmp('sysDiagRel2HC').setValue(selections[0].json.DiagRel2);
                                            Ext.Ajax.request({
                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                params:{
                                                    task: 'BUSCAR',
                                                    pCodigo: selections[0].json.DiagRel2.toUpperCase()
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); // get the LOG
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        // Nada
                                                    } else {
                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                    }
                                                },
                                                failure: function(response,options){
                                                    //nada
                                                },
                                                scope:this //bind the callbacks
                                            });
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campoDiagrel3 = Ext.getCmp('sysDiagRel3HC');
                                        if ( campoDiagrel3 !== null ) {
                                            Ext.getCmp('sysDiagRel3HC').setValue(selections[0].json.DiagRel3);
                                            Ext.Ajax.request({
                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                params:{
                                                    task: 'BUSCAR',
                                                    pCodigo: selections[0].json.DiagRel3.toUpperCase()
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); // get the LOG
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        // Nada
                                                    } else {
                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                    }
                                                },
                                                failure: function(response,options){
                                                    //nada
                                                },
                                                scope:this //bind the callbacks
                                            });
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campoTipodiag = Ext.getCmp('sysTipoDiagosticoHC');
                                        if ( campoTipodiag !== null ) {
                                            Ext.getCmp('sysTipoDiagosticoHC').setValue(selections[0].json.Tipodiag);
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campoFinalidad = Ext.getCmp('sysFinalidadConsultaHC');
                                        if ( campoFinalidad !== null ) {
                                            Ext.getCmp('sysFinalidadConsultaHC').setValue(selections[0].json.Finalidad);
                                        }
                                    }catch(ex) {
                                    }
                                    try {
                                        var campoCausaExterna = Ext.getCmp('sysCausaExternaHC');
                                        if ( campoCausaExterna !== null ) {
                                            Ext.getCmp('sysCausaExternaHC').setValue(selections[0].json.CausaExterna);
                                        }
                                    }catch(ex) {
                                    }
                                }
                            });
                        }
                    }
                });
                //hasta aqui
            }else{
                var wActividad = selections[0].json.Actividad;
                //if (parseInt(selections[0].json.YaLegalizado) === 1 || wActividad.indexOf("ODONTOLO") > 0){
                if (selections[0].json.YaLegalizado == '1'){
                    if (selections[0].json.PendientePago !== '1'){
                        ID_PROGRAMA = selections[0].json.IdPrograma;
                        var winSeleccionPlantillaOpenHC = new winSeleccionPlantillaOpenHCUi();
                        Ext.getCmp('sysEmpresaPlantillaHC').setValue(ID_EMPRESA);
                        Ext.getCmp('sysSedePlantillaHC').setValue(ID_SEDE);
                        Ext.getCmp('sysIPSPlantillaHC').setValue(ID_IPS);
                        Ext.getCmp('sysUsuarioPlantillaHC').setValue(ID_USUARIO);
                        Ext.getCmp('sysProfesionalPlantillaHC').setValue(Ext.getCmp('sysProfeAgenda').getValue());
                        Ext.getCmp('sysPacientePlantillaHC').setValue(selections[0].json.Paciente);
                        Ext.getCmp('sysUbicacionPlantillaHC').setValue(Ext.getCmp('sysUbicacionAgenda').getValue());
                        Ext.getCmp('sysCASPlantillaHC').setValue(selections[0].json.CAS);
                        Ext.getCmp('sysConsecutivoDetalle_HC').setValue(selections[0].json.ConsecutivoDetalle);
                        Ext.getCmp('sysNomProfesionalPlantillaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgenda').getRawValue()));
                        Ext.getCmp('sysConsultorioPlantillaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysUbicacionAgenda').getRawValue()));
                        Ext.getCmp('sysFechaPlantillaHC').setValue(selections[0].json.FechaCita);
                        Ext.getCmp('sysHoraPlantillaHC').setValue(selections[0].json.HoraAgenda);
                        Ext.getCmp('sysHoraEstimadaPlantillaHC').setValue(selections[0].json.HoraAtencion);
                        Ext.getCmp('sysFechaLegalizaPlantillaHC').setValue(selections[0].json.FechaLegaliza);
                        Ext.getCmp('sysClientePlantillaHC').setValue(selections[0].json.Cliente);
                        Ext.getCmp('sysActividadPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                        Ext.getCmp('sysNomPacientePlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.TipDoc + '-' + selections[0].json.Documento + ' ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido));
                        Ext.getCmp('sysGeneroPaciente_HC').setValue(selections[0].json.Genero);
                        Ext.getCmp('sysEdadPaciente_HC').setValue(selections[0].json.Edad);
                        Ext.getCmp('sysFecNacPaciente_HC').setValue(selections[0].json.FecNac);
                        Ext.getCmp('sysIdCliente_HC').setValue(selections[0].json.idCliente);
                        Ext.getCmp('sysIdPlan_HC').setValue(selections[0].json.idPlan);
                        Ext.getCmp('sysIdSubPlan_HC').setValue(selections[0].json.idSubPlan);
                        Ext.getCmp('sysIdContrato_HC').setValue(selections[0].json.idContrato);

                        winSeleccionPlantillaOpenHC.show();
                    }else{
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'El Paciente: " ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + '", Tiene saldos pendientes de tratamientos o multas, por favor verificar esta informacion.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }else{
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'El Paciente: " ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + '", No ha legalizado la cita.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    },
    ActualizarAgenda: function(){
        Ext.getCmp('gridFormulario').store.reload();
    },
    InasistenciaCita: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            //if (selections[0].json.YaLegalizado == '0'){
                xCAS = selections[0].json.CAS;
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'ATENCIÓN: Recuerde Actualizar la Agenda para estar seguro que desea marcar inasistente la cita Nro. ' + xCAS + ' ?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            ScriptMgr.loadJs({
                                scripts : '../../frm_js/barraservicios/wininasistenciacita.ui.js',
                                callback : function(){
                                    var winInasistenciaCitas = new winInasistenciaCitaUi();
                                    Ext.getCmp('sysPantalla').setValue("AgendaCitas");
                                    Ext.getCmp('sysEmpresa').setValue(ID_EMPRESA);
                                    Ext.getCmp('sysIPS').setValue(ID_IPS);
                                    Ext.getCmp('sysCAS').setValue(xCAS);
                                    Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                                    Ext.getCmp('sysProfesionalAgenda').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgenda').getRawValue()));
                                    Ext.getCmp('sysConsultorioAgenda').setValue(PonerAcentosMayusculas(Ext.getCmp('sysUbicacionAgenda').getRawValue()));
                                    Ext.getCmp('sysFecha').setValue(selections[0].json.FechaCita);
                                    Ext.getCmp('sysHora').setValue(selections[0].json.HoraAgenda);
                                    winInasistenciaCitas.show();
                                }
                            });
                        }
                    }
                });
            //}
        }
    },
    CancelarCita: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.YaLegalizado == '0'){
                xCAS = selections[0].json.CAS;
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'ATENCIÓN: Recuerde Actualizar la Agenda para estar seguro que desea cancelar la cita Nro. ' + xCAS + ' ?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            ScriptMgr.loadJs({
                                scripts : '../../frm_js/barraservicios/wincancelacita.ui.js',
                                callback : function(){
                                    var winCancelaCitas = new winCancelarCitaUi();
                                    Ext.getCmp('sysPantalla').setValue("AgendaCitas");
                                    Ext.getCmp('sysEmpresa').setValue(ID_EMPRESA);
                                    Ext.getCmp('sysIPS').setValue(ID_IPS);
                                    Ext.getCmp('sysCAS').setValue(xCAS);
                                    Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                                    Ext.getCmp('sysProfesionalAgenda').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgenda').getRawValue()));
                                    Ext.getCmp('sysConsultorioAgenda').setValue(PonerAcentosMayusculas(Ext.getCmp('sysUbicacionAgenda').getRawValue()));
                                    Ext.getCmp('sysFecha').setValue(selections[0].json.FechaCita);
                                    Ext.getCmp('sysHora').setValue(selections[0].json.HoraAgenda);
                                    winCancelaCitas.show();
                                }
                            });
                        }
                    }
                });
            }
        }
    },
    CargaDetalleAgenda: function(cmb, rec, idx) {
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pAgenda: cmb.getValue()
            }
        }); 
    },
    CargaFechasAgenda: function(cmb, rec, idx) {
        Ext.getCmp('sysFechaAgenda').clearValue();
        Ext.getCmp('sysFechaAgenda').enable();
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pAgenda: 0
            }
        }); 
        Ext.getCmp('sysFechaAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pProfesional: Ext.getCmp('sysProfeAgenda').getValue(),
                pConsultorio: cmb.getValue()
            }
        }); 
    },
    CargaUbicacionAgenda: function(cmb, rec, idx) {
        Ext.getCmp('sysUbicacionAgenda').clearValue();
        Ext.getCmp('sysUbicacionAgenda').enable();
        Ext.getCmp('sysFechaAgenda').clearValue();
        Ext.getCmp('sysFechaAgenda').disable();
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pAgenda: 0
            }
        }); 
        Ext.getCmp('sysUbicacionAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pProfesional: cmb.getValue()
            }
        }); 
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfesionalesUi').close();
                }
            }
        });
    }
});

