/*
* @category    Solicitud Consentimientos Informados
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

GridActividadesAdicionalesUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
               
        var stGrid = new StoreGridActividadesAdicionales();
        stGrid.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        this.items = [
            {
                xtype: 'grid',
                title: ' ',
                id: 'gridActividadesAdicionales',
                store: stGrid,
                anchor: "100%",
                height: 290,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([                    
                    {
                        header: 'Fecha',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'FechaAtencion',
                        align: 'center',
                        width: 104,
                        hideable: false
                    },
                    {
                        header: 'CUPS',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'CUPS',
                        align: 'center',
                        width: 120,
                        hideable: false
                    },
                    {
                        header: 'Procedimiento',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Procedimiento',
                        align: 'left',
                        width: 300,
                        hideable: false
                    },
                    {
                        header: 'Cliente',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Cliente',
                        align: 'Cliente',
                        width: 150,
                        hideable: false
                    },
                    {
                        header: 'Profesional',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Profesional',
                        align: 'center',
                        width: 200,
                        hideable: false
                    }
                    
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.ux.grid.LockingGridView(),
                columnLines: true,
                bbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'button',
                            text: 'Actualizar',
                            iconCls: 'btnActualizarGrid',
                            listeners: {
                                click: function(){
                                    try {
                                        var campoIdPaciente = Ext.getCmp('intIdPaciente');
                                        if ( campoIdPaciente !== null ) {
                                            Ext.getCmp('gridActividadesAdicionales').store.load({
                                                params: {
                                                    pPaciente: Ext.getCmp('intIdPaciente').getValue()
                                                }
                                            });
                                        }
                                    }catch(ex) {
                                        Ext.getCmp('gridActividadesAdicionales').store.reload();
                                    }
                                }
                            }
                        }
                    ]
                }, 
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar',
                                iconCls: 'btnAddRow',
                                listeners: {
                                    click : function() {
                                        try {
                                            var campoIdPaciente = Ext.getCmp('intIdPaciente');
                                            if ( campoIdPaciente !== null ) {
                                                wPaciente = Ext.getCmp('intIdPaciente').getValue();
                                            }
                                        }catch(ex) {
                                            //Ext.getCmp('gridConsentimientosInformadosxPac').store.reload();
                                        }    
                                        if(parseInt(wPaciente) !== 0){
                                            var winAddEvolucion001 = new winAddEvolucion001Ui();
                                            Ext.getCmp('sysPacienteActividadesAdicionales').setValue(wPaciente);
                                            Ext.getCmp('sysUsuarioActividadesAdicionales').setValue(ID_USUARIO);
                                            Ext.getCmp('sysCASRef').setValue(Ext.getCmp('sysCASHC').getValue());
                                            Ext.getCmp('sysProfesionalActividadesAdicionales').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                            Ext.getCmp('sysIdCliente_Adicionales').setValue(Ext.getCmp('sysIdClienteHC').getValue());
                                            Ext.getCmp('sysIdProcedimientoActividadesAdicionales').store.load({
                                                params:{
                                                    pIPS: ID_IPS,
                                                    pCliente: Ext.getCmp('sysIdClienteHC').getValue()
                                                }
                                            });
                                            winAddEvolucion001.show();
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        GridActividadesAdicionalesUi.superclass.initComponent.call(this);
    }
});
