/*
* @category    Panel Alteraciones Adulto
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnAlteracionesAdultoUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnAlteracionesAdulto',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 260,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Alteraciones del Adulto?',
                        name: 'Registrar HC Alteraciones del Adulto?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        value: "NO",
                        id: 'strRegistrarAlteracionesAdulto',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsAlteracionesAdulto').setVisible(false);
                                    Ext.getCmp('fecALTADULCita').allowBlank = true;
                                    Ext.getCmp('strALTADULProfesionalAtiende').allowBlank = true;
                                    Ext.getCmp('bolALTADULFumador').allowBlank = true;
                                    Ext.getCmp('bolALTADULAlcohol').allowBlank = true;
                                    Ext.getCmp('bolALTADULSustPsicoa').allowBlank = true;
                                    Ext.getCmp('bolALTADULDietaSaludable').allowBlank = true;
                                    Ext.getCmp('bolALTADULActFisica').allowBlank = true;
                                    Ext.getCmp('bolALTADULManejoStress').allowBlank = true;
                                    Ext.getCmp('memALTADULPlan').allowBlank = true;
                                    Ext.getCmp('sysALTADULDiag').allowBlank = true;
                                    Ext.getCmp('strALTADULUroanalisis').allowBlank = true;
                                    Ext.getCmp('intALTADULCreatinina').allowBlank = true;
                                    Ext.getCmp('intALTADULGlicemia').allowBlank = true;
                                    Ext.getCmp('intALTADULColesterolHDL').allowBlank = true;
                                    Ext.getCmp('intALTADULTrigliceridos').allowBlank = true;
                                    Ext.getCmp('fecALTADULCita').setValue(null);
                                    Ext.getCmp('strALTADULProfesionalAtiende').setValue(null);
                                    Ext.getCmp('sysALTADULDiag').setValue(null);
                                    Ext.getCmp('bolALTADULFumador').setValue(null);
                                    Ext.getCmp('bolALTADULAlcohol').setValue(null);
                                    Ext.getCmp('bolALTADULSustPsicoa').setValue(null);
                                    Ext.getCmp('bolALTADULDietaSaludable').setValue(null);
                                    Ext.getCmp('bolALTADULActFisica').setValue(null);
                                    Ext.getCmp('bolALTADULManejoStress').setValue(null);
                                    Ext.getCmp('memALTADULPlan').setValue(null);
                                    Ext.getCmp('strALTADULUroanalisis').setValue(null);
                                    Ext.getCmp('intALTADULCreatinina').setValue(null);
                                    Ext.getCmp('intALTADULGlicemia').setValue(null);
                                    Ext.getCmp('intALTADULColesterolHDL').setValue(null);
                                    Ext.getCmp('intALTADULTrigliceridos').setValue(null);
                                    Ext.getCmp('fecALTADULCita').disable();
                                    Ext.getCmp('strALTADULProfesionalAtiende').disable();
                                    Ext.getCmp('bolALTADULFumador').disable();
                                    Ext.getCmp('bolALTADULAlcohol').disable();
                                    Ext.getCmp('bolALTADULSustPsicoa').disable();
                                    Ext.getCmp('bolALTADULDietaSaludable').disable();
                                    Ext.getCmp('bolALTADULActFisica').disable();
                                    Ext.getCmp('bolALTADULManejoStress').disable();
                                    Ext.getCmp('memALTADULPlan').disable();
                                    Ext.getCmp('sysALTADULDiag').disable();
                                    Ext.getCmp('strALTADULUroanalisis').disable();
                                    Ext.getCmp('intALTADULCreatinina').disable();
                                    Ext.getCmp('intALTADULGlicemia').disable();
                                    Ext.getCmp('intALTADULColesterolHDL').disable();
                                    Ext.getCmp('intALTADULTrigliceridos').disable();
                                    Ext.getCmp('sysALTADULDiag').clearInvalid();
                                    Ext.getCmp('bolALTADULFumador').clearInvalid();
                                    Ext.getCmp('bolALTADULAlcohol').clearInvalid();
                                    Ext.getCmp('bolALTADULSustPsicoa').clearInvalid();
                                    Ext.getCmp('bolALTADULDietaSaludable').clearInvalid();
                                    Ext.getCmp('bolALTADULActFisica').clearInvalid();
                                    Ext.getCmp('bolALTADULManejoStress').clearInvalid();
                                    Ext.getCmp('memALTADULPlan').clearInvalid();
                                    Ext.getCmp('strALTADULUroanalisis').clearInvalid();
                                    Ext.getCmp('intALTADULCreatinina').clearInvalid();
                                    Ext.getCmp('intALTADULGlicemia').clearInvalid();
                                    Ext.getCmp('intALTADULColesterolHDL').clearInvalid();
                                    Ext.getCmp('intALTADULTrigliceridos').clearInvalid();
                                    Ext.getCmp('fecALTADULCita').clearInvalid();
                                    Ext.getCmp('strALTADULProfesionalAtiende').clearInvalid();
                                }else{
                                    Ext.getCmp('fsAlteracionesAdulto').setVisible(true);
                                    Ext.getCmp('fecALTADULCita').allowBlank =false;
                                    Ext.getCmp('strALTADULProfesionalAtiende').allowBlank =false;
                                    Ext.getCmp('bolALTADULFumador').allowBlank =false;
                                    Ext.getCmp('bolALTADULAlcohol').allowBlank =false;
                                    Ext.getCmp('bolALTADULSustPsicoa').allowBlank =false;
                                    Ext.getCmp('bolALTADULDietaSaludable').allowBlank =false;
                                    Ext.getCmp('bolALTADULActFisica').allowBlank =false;
                                    Ext.getCmp('bolALTADULManejoStress').allowBlank =false;
                                    Ext.getCmp('memALTADULPlan').allowBlank =false;
                                    Ext.getCmp('sysALTADULDiag').allowBlank =false;
                                    Ext.getCmp('strALTADULUroanalisis').allowBlank =false;
                                    Ext.getCmp('intALTADULCreatinina').allowBlank =false;
                                    Ext.getCmp('intALTADULGlicemia').allowBlank =false;
                                    Ext.getCmp('intALTADULColesterolHDL').allowBlank =false;
                                    Ext.getCmp('intALTADULTrigliceridos').allowBlank =false;
                                    Ext.getCmp('fecALTADULCita').enable();
                                    Ext.getCmp('strALTADULProfesionalAtiende').enable();
                                    Ext.getCmp('sysALTADULDiag').enable();
                                    Ext.getCmp('bolALTADULFumador').enable();
                                    Ext.getCmp('bolALTADULAlcohol').enable();
                                    Ext.getCmp('bolALTADULSustPsicoa').enable();
                                    Ext.getCmp('bolALTADULDietaSaludable').enable();
                                    Ext.getCmp('bolALTADULActFisica').enable();
                                    Ext.getCmp('bolALTADULManejoStress').enable();
                                    Ext.getCmp('memALTADULPlan').enable();
                                    Ext.getCmp('strALTADULUroanalisis').enable();
                                    Ext.getCmp('intALTADULCreatinina').enable();
                                    Ext.getCmp('intALTADULGlicemia').enable();
                                    Ext.getCmp('intALTADULColesterolHDL').enable();
                                    Ext.getCmp('intALTADULTrigliceridos').enable();
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PROGRAMA: ALTERACIONES DEL ADULTO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id: 'fsAlteracionesAdulto',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'Factores de Riesgo',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        fieldLabel: 'Fumador',
                                        name: 'Fumador',
                                        value: 'false',
                                        id: 'bolALTADULFumador'
                                    },
                                    {
                                        html: 'Alcohol:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Alcohol',
                                        value: 'false',
                                        id: 'bolALTADULAlcohol'
                                    },
                                    {
                                        html: 'Sust. Psicoa.:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Sust. Psicoa.',
                                        value: 'false',
                                        id: 'bolALTADULSustPsicoa'
                                    },
                                    {
                                        html: 'Dieta Saludable:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Dieta Saludable',
                                        value: 'false',
                                        id: 'bolALTADULDietaSaludable'
                                    },
                                    {
                                        html: 'Act. Fisica:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Act. Fisica',
                                        value: 'false',
                                        id: 'bolALTADULActFisica'
                                    },
                                    {
                                        html: 'Manejo Stress:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Manejo Stress',
                                        value: 'false',
                                        id: 'bolALTADULManejoStress'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Laboratorios Ingreso',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Uroanalisis',
                                        fieldLabel: 'Uroanalisis',
                                        width: 105,
                                        allowBlank: true,
                                        store: stResultadoCitologia,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strALTADULUroanalisis'
                                    },
                                    {
                                        html: 'Creatinina'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Creatinina',
                                        emptyText: 'Rango 0,2 - 25',
                                        width: 60,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'intALTADULCreatinina'
                                    },
                                    {
                                        html: 'Glicemia'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Glicemia',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 60,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'intALTADULGlicemia'
                                    },
                                    {
                                        html: 'Colesterol HDL'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Colesterol HDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 60,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'intALTADULColesterolHDL'
                                    },
                                    {
                                        html: 'Trigliceridos'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Trigliceridos',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 60,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'intALTADULTrigliceridos'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 100,
                        allowBlank: true,
                        id: 'memALTADULPlan'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                                {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: true,
                                fieldLabel: 'Diagnostico',
                                id: 'sysALTADULDiag',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                        {
                                            if (f.getValue() != "" && f.getValue() != null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                            Ext.getCmp('sysALTADULDiag').setValue(null);
                                                            Ext.getCmp('sysALTADULDiagNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysALTADULDiag').setValue(Contenido[0]);
                                                            Ext.getCmp('sysALTADULDiagNom').setValue(Contenido[1]);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysALTADULDiag').setValue(null);
                                                        Ext.getCmp('sysALTADULDiagNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysALTADULDiag').setValue(null);
                                                Ext.getCmp('sysALTADULDiagNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 625,
                                height: 22,
                                id: 'sysALTADULDiagNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysALTADULDiag','sysALTADULDiagNom');
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'datefield',
                        width: 120,
                        fieldLabel: 'Fecha Probable Proxima Cita',
                        name: 'Fecha Probable Proxima Cita',
                        allowBlank: true,
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecALTADULCita'
                    },
                    {
                        html: 'Profesional que Atiende'
                    },
                    {
                        xtype: 'combo',
                        name: 'Profesional que Atiende',
                        width: 250,
                        allowBlank: true,
                        store: stProfesionalAtiende,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strALTADULProfesionalAtiende'
                    }
                ]
            }
        ];
        pnAlteracionesAdultoUi.superclass.initComponent.call(this);
    }
});
