/*
* @category    Panel Recien Nacido
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnRecienNacidoUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnRecienNacido',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 260,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Recien Nacido?',
                        name: 'Registrar HC Recien Nacido?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRecienNacido',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsRecienNacido').setVisible(false);
                                    Ext.getCmp('strRECNACGenero').allowBlank = true;
                                    Ext.getCmp('fecRECNACNacimiento').allowBlank = true;
                                    Ext.getCmp('intRECNACPeso').allowBlank = true;
                                    Ext.getCmp('intRECNACPerCefalico').allowBlank = true;
                                    Ext.getCmp('intRECNACTalla').allowBlank = true;
                                    Ext.getCmp('intRECNACEdadGestNac').allowBlank = true;
                                    Ext.getCmp('strRECNACReanimacion').allowBlank = true;
                                    Ext.getCmp('strRECNACTipReanimacion').allowBlank = true;
                                    Ext.getCmp('strRECNACCongenitos').allowBlank = true;
                                    Ext.getCmp('strRECNACMeconio').allowBlank = true;
                                    Ext.getCmp('strRECNACBocaArriba').allowBlank = true;
                                    Ext.getCmp('strRECNACVitK').allowBlank = true;
                                    Ext.getCmp('strRECNACVDRL').allowBlank = true;
                                    Ext.getCmp('strRECNACTSH').allowBlank = true;
                                    Ext.getCmp('strRECNACHb').allowBlank = true;
                                    Ext.getCmp('strRECNACAudicion').allowBlank = true;
                                    Ext.getCmp('strRECNACBilir').allowBlank = true;
                                    Ext.getCmp('strRECNACHemoclasificacion').allowBlank = true;
                                    Ext.getCmp('intRECNACTASistolica').allowBlank = true;
                                    Ext.getCmp('intRECNACTADiastolica').allowBlank = true;
                                    Ext.getCmp('intRECNACTemp').allowBlank = true;
                                    Ext.getCmp('intRECNACFC').allowBlank = true;
                                    Ext.getCmp('intRECNACFR').allowBlank = true;
                                    Ext.getCmp('memRECNACPlan').allowBlank = true;
                                    Ext.getCmp('strRECNACTamano').allowBlank = true;
                                    Ext.getCmp('strRECNACTamano').setValue(null);
                                    Ext.getCmp('strRECNACGenero').setValue(null);
                                    Ext.getCmp('fecRECNACNacimiento').setValue(null);
                                    Ext.getCmp('intRECNACPeso').setValue(null);
                                    Ext.getCmp('intRECNACPerCefalico').setValue(null);
                                    Ext.getCmp('intRECNACTalla').setValue(null);
                                    Ext.getCmp('intRECNACEdadGestNac').setValue(null);
                                    Ext.getCmp('strRECNACReanimacion').setValue(null);
                                    Ext.getCmp('strRECNACTipReanimacion').setValue(null);
                                    Ext.getCmp('strRECNACCongenitos').setValue(null);
                                    Ext.getCmp('strRECNACMeconio').setValue(null);
                                    Ext.getCmp('strRECNACBocaArriba').setValue(null);
                                    Ext.getCmp('strRECNACVitK').setValue(null);
                                    Ext.getCmp('strRECNACVDRL').setValue(null);
                                    Ext.getCmp('strRECNACTSH').setValue(null);
                                    Ext.getCmp('strRECNACHb').setValue(null);
                                    Ext.getCmp('strRECNACAudicion').setValue(null);
                                    Ext.getCmp('strRECNACBilir').setValue(null);
                                    Ext.getCmp('strRECNACHemoclasificacion').setValue(null);
                                    Ext.getCmp('intRECNACTASistolica').setValue(null);
                                    Ext.getCmp('intRECNACTADiastolica').setValue(null);
                                    Ext.getCmp('intRECNACTemp').setValue(null);
                                    Ext.getCmp('intRECNACFC').setValue(null);
                                    Ext.getCmp('intRECNACFR').setValue(null);
                                    Ext.getCmp('memRECNACPlan').setValue(null);
                                    Ext.getCmp('strRECNACGenero').disable();
                                    Ext.getCmp('fecRECNACNacimiento').disable();
                                    Ext.getCmp('intRECNACPeso').disable();
                                    Ext.getCmp('intRECNACPerCefalico').disable();
                                    Ext.getCmp('intRECNACTalla').disable();
                                    Ext.getCmp('intRECNACEdadGestNac').disable();
                                    Ext.getCmp('strRECNACReanimacion').disable();
                                    Ext.getCmp('strRECNACTipReanimacion').disable();
                                    Ext.getCmp('strRECNACCongenitos').disable();
                                    Ext.getCmp('strRECNACMeconio').disable();
                                    Ext.getCmp('strRECNACBocaArriba').disable();
                                    Ext.getCmp('strRECNACVitK').disable();
                                    Ext.getCmp('strRECNACVDRL').disable();
                                    Ext.getCmp('strRECNACTSH').disable();
                                    Ext.getCmp('strRECNACHb').disable();
                                    Ext.getCmp('strRECNACAudicion').disable();
                                    Ext.getCmp('strRECNACBilir').disable();
                                    Ext.getCmp('strRECNACHemoclasificacion').disable();
                                    Ext.getCmp('intRECNACTASistolica').disable();
                                    Ext.getCmp('intRECNACTADiastolica').disable();
                                    Ext.getCmp('intRECNACTemp').disable();
                                    Ext.getCmp('intRECNACFC').disable();
                                    Ext.getCmp('intRECNACFR').disable();
                                    Ext.getCmp('memRECNACPlan').disable();
                                    Ext.getCmp('strRECNACTamano').disable();
                                    Ext.getCmp('strRECNACTamano').clearInvalid();
                                    Ext.getCmp('strRECNACGenero').clearInvalid();
                                    Ext.getCmp('fecRECNACNacimiento').clearInvalid();
                                    Ext.getCmp('intRECNACPeso').clearInvalid();
                                    Ext.getCmp('intRECNACPerCefalico').clearInvalid();
                                    Ext.getCmp('intRECNACTalla').clearInvalid();
                                    Ext.getCmp('intRECNACEdadGestNac').clearInvalid();
                                    Ext.getCmp('strRECNACReanimacion').clearInvalid();
                                    Ext.getCmp('strRECNACTipReanimacion').clearInvalid();
                                    Ext.getCmp('strRECNACCongenitos').clearInvalid();
                                    Ext.getCmp('strRECNACMeconio').clearInvalid();
                                    Ext.getCmp('strRECNACBocaArriba').clearInvalid();
                                    Ext.getCmp('strRECNACVitK').clearInvalid();
                                    Ext.getCmp('strRECNACVDRL').clearInvalid();
                                    Ext.getCmp('strRECNACTSH').clearInvalid();
                                    Ext.getCmp('strRECNACHb').clearInvalid();
                                    Ext.getCmp('strRECNACAudicion').clearInvalid();
                                    Ext.getCmp('strRECNACBilir').clearInvalid();
                                    Ext.getCmp('strRECNACHemoclasificacion').clearInvalid();
                                    Ext.getCmp('intRECNACTASistolica').clearInvalid();
                                    Ext.getCmp('intRECNACTADiastolica').clearInvalid();
                                    Ext.getCmp('intRECNACTemp').clearInvalid();
                                    Ext.getCmp('intRECNACFC').clearInvalid();
                                    Ext.getCmp('intRECNACFR').clearInvalid();
                                    Ext.getCmp('memRECNACPlan').clearInvalid();
                                }else{
                                    Ext.getCmp('fsRecienNacido').setVisible(true);
                                    Ext.getCmp('strRECNACGenero').allowBlank = false;
                                    Ext.getCmp('fecRECNACNacimiento').allowBlank = false;
                                    Ext.getCmp('intRECNACPeso').allowBlank = false;
                                    Ext.getCmp('intRECNACPerCefalico').allowBlank = false;
                                    Ext.getCmp('intRECNACTalla').allowBlank = false;
                                    Ext.getCmp('intRECNACEdadGestNac').allowBlank = false;
                                    Ext.getCmp('strRECNACReanimacion').allowBlank = false;
                                    Ext.getCmp('strRECNACTipReanimacion').allowBlank = false;
                                    Ext.getCmp('strRECNACCongenitos').allowBlank = false;
                                    Ext.getCmp('strRECNACMeconio').allowBlank = false;
                                    Ext.getCmp('strRECNACBocaArriba').allowBlank = false;
                                    Ext.getCmp('strRECNACVitK').allowBlank = false;
                                    Ext.getCmp('strRECNACVDRL').allowBlank = false;
                                    Ext.getCmp('strRECNACTSH').allowBlank = false;
                                    Ext.getCmp('strRECNACHb').allowBlank = false;
                                    Ext.getCmp('strRECNACAudicion').allowBlank = false;
                                    Ext.getCmp('strRECNACBilir').allowBlank = false;
                                    Ext.getCmp('strRECNACHemoclasificacion').allowBlank = false;
                                    Ext.getCmp('intRECNACTASistolica').allowBlank = false;
                                    Ext.getCmp('intRECNACTADiastolica').allowBlank = false;
                                    Ext.getCmp('intRECNACTemp').allowBlank = false;
                                    Ext.getCmp('intRECNACFC').allowBlank = false;
                                    Ext.getCmp('intRECNACFR').allowBlank = false;
                                    Ext.getCmp('memRECNACPlan').allowBlank = false;
                                    Ext.getCmp('strRECNACTamano').allowBlank = false;
                                    Ext.getCmp('strRECNACTamano').enable();
                                    Ext.getCmp('strRECNACGenero').enable();
                                    Ext.getCmp('fecRECNACNacimiento').enable();
                                    Ext.getCmp('intRECNACPeso').enable();
                                    Ext.getCmp('intRECNACPerCefalico').enable();
                                    Ext.getCmp('intRECNACTalla').enable();
                                    Ext.getCmp('intRECNACEdadGestNac').enable();
                                    Ext.getCmp('strRECNACReanimacion').enable();
                                    Ext.getCmp('strRECNACTipReanimacion').enable();
                                    Ext.getCmp('strRECNACCongenitos').enable();
                                    Ext.getCmp('strRECNACMeconio').enable();
                                    Ext.getCmp('strRECNACBocaArriba').enable();
                                    Ext.getCmp('strRECNACVitK').enable();
                                    Ext.getCmp('strRECNACVDRL').enable();
                                    Ext.getCmp('strRECNACTSH').enable();
                                    Ext.getCmp('strRECNACHb').enable();
                                    Ext.getCmp('strRECNACAudicion').enable();
                                    Ext.getCmp('strRECNACBilir').enable();
                                    Ext.getCmp('strRECNACHemoclasificacion').enable();
                                    Ext.getCmp('intRECNACTASistolica').enable();
                                    Ext.getCmp('intRECNACTADiastolica').enable();
                                    Ext.getCmp('intRECNACTemp').enable();
                                    Ext.getCmp('intRECNACFC').enable();
                                    Ext.getCmp('intRECNACFR').enable();
                                    Ext.getCmp('memRECNACPlan').enable();
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PROGRAMA: RECIEN NACIDO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id: 'fsRecienNacido',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                name: 'Genero',
                                fieldLabel: 'Genero',
                                width: 120,
                                allowBlank: true,
                                store: 'StoreGenero',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRECNACGenero'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Nacimiento',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRECNACNacimiento'
                            },
                            {
                                html: 'Edad Gest. Nac.:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                name: 'Edad Gest. Nac.',
                                minValue: 1,
                                allowBlank: true,
                                style: 'text-align:center;',
                                id: 'intRECNACEdadGestNac'
                            },
                            {
                                html: 'Per. Cefalico:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                name: 'Per. Cefalico',
                                minValue: 1,
                                allowBlank: true,
                                style: 'text-align:center;',
                                id: 'intRECNACPerCefalico'
                            },
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 60,
                                name: 'Peso al Nacer',
                                fieldLabel: 'Peso al Nacer',
                                minValue: 1,
                                allowBlank: true,
                                emptyText: '(gr)',
                                style: 'text-align:center;',
                                id: 'intRECNACPeso'
                            },
                            {
                                html: 'Tamano'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tamano',
                                width: 120,
                                allowBlank: true,
                                store: stTamano,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRECNACTamano'
                            },
                            {
                                html: 'TALLA'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 250,
                                decimalPrecision: 2,
                                allowBlank: true,
                                emptyText: '(cm)',
                                name:"TALLA (cm)",
                                emptyText: '(cm)',
                                id: 'intRECNACTalla'
                            },
                            {
                                html: 'Vit. K:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Vit. K',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRECNACVitK'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Reanimacion',
                                name: 'Reanimacion',
                                width: 50,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRECNACReanimacion',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('strRECNACTipReanimacion').allowBlank = true;
                                            Ext.getCmp('strRECNACTipReanimacion').setValue(null);
                                            Ext.getCmp('strRECNACTipReanimacion').disable();
                                            Ext.getCmp('strRECNACTipReanimacion').clearInvalid();
                                        }else{
                                            Ext.getCmp('strRECNACTipReanimacion').enable();
                                            Ext.getCmp('strRECNACTipReanimacion').allowBlank = false;
                                        }
                                    }
                                }
                            },
                            {
                                html: '-'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tipo Reanimacion',
                                width: 130,
                                allowBlank: true,
                                store: stReanimacion,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRECNACTipReanimacion'
                            },
                            {
                                html: 'Defectos Congenitos:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Defectos Congenitos',
                                width: 120,
                                allowBlank: true,
                                store: stCongenitos,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRECNACCongenitos'
                            },
                            {
                                html: 'Meconio 1er dia:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Meconio 1er dia',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRECNACMeconio'
                            },
                            {
                                html: 'Boca Arriba:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Boca Arriba',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRECNACBocaArriba'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Tamizaje Neonatal',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'VDRL',
                                        fieldLabel: 'VDRL',
                                        width: 120,
                                        allowBlank: true,
                                        store: stResultadosRN,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRECNACVDRL'
                                    },
                                    {
                                        html: 'TSH:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'TSH',
                                        width: 120,
                                        allowBlank: true,
                                        store: stResultadosRN,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRECNACTSH'
                                    },

                                    {
                                        html: 'Hb:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Hb',
                                        width: 120,
                                        allowBlank: true,
                                        store: stResultadosRN,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRECNACHb'
                                    },
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Audicion',
                                        fieldLabel: 'Audicion',
                                        width: 120,
                                        allowBlank: true,
                                        store: stResultadosRN,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRECNACAudicion'
                                    },
                                    {
                                        html: 'Bilir.:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Bilir.',
                                        width: 120,
                                        allowBlank: true,
                                        store: stResultadosRN,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRECNACBilir'
                                    },
                                    {
                                        html: 'Hemoclasificacion:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Hemoclasificacion',
                                        width: 120,
                                        allowBlank: true,
                                        store: stHemoclasificacion,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strRECNACHemoclasificacion'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'T.A.',
                                name: 'T.A.Sistolica',
                                width: 70,
                                minValue: 0,
                                maxValue: 300,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intRECNACTASistolica'
                            },
                            {
                                html: '/'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'T.A. Diastolica',
                                width: 70,
                                minValue: 0,
                                maxValue: 300,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intRECNACTADiastolica'
                            },
                            {
                                html: 'Temp:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                decimalPrecision: 2,
                                name: 'Temp',
                                allowBlank: true,
                                id: 'intRECNACTemp'
                            },
                            {
                                html: 'F.C.'
                            },                                                            
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                decimalPrecision: 2,
                                name: 'PA',
                                allowBlank: true,
                                id: 'intRECNACFC'
                            },
                            {
                                html: 'F.R.'
                            },                                                            
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                decimalPrecision: 2,
                                name: 'FR',
                                allowBlank: true,
                                id: 'intRECNACFR'
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 880,
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 100,
                        allowBlank: true,
                        id: 'memRECNACPlan'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: true,
                                fieldLabel: 'Diagnostico',
                                id: 'sysRECNACDiag',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                        {
                                            if (f.getValue() != "" && f.getValue() != null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                            Ext.getCmp('sysRECNACDiag').setValue(null);
                                                            Ext.getCmp('sysRECNACDiagNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysRECNACDiag').setValue(Contenido[0]);
                                                            Ext.getCmp('sysRECNACDiagNom').setValue(Contenido[1]);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysRECNACDiag').setValue(null);
                                                        Ext.getCmp('sysRECNACDiagNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysRECNACDiag').setValue(null);
                                                Ext.getCmp('sysRECNACDiagNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 625,
                                height: 22,
                                id: 'sysRECNACDiagNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysRECNACDiag','sysRECNACDiagNom');
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        pnRecienNacidoUi.superclass.initComponent.call(this);
    }
});
