/*
* @category    Formulario Modelo Plantilla HC Programas Especiales (HTA - Diabetes Mellitus - Nefroproteccion)
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCProgramasEspeciales001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Programas Especiales (HTA - Diabetes Mellitus - Nefroproteccion) ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCProgEsp01',
    initComponent: function() {
        
        infoHTBLCronicos = '<hr><br><table border="1"><tr><td colspan="4">ESTRATIFICACION DEL RIESGO</td></tr>';
        infoHTBLCronicos += '<tr><td>Tensión Arterial</td><td>Estadio I</td><td>Estadio II</td><td>Estadio III</td></tr>'; 
        infoHTBLCronicos += '<tr><td>Factores de Riego</td><td>PAS 140 - 159 o PAD 90 - 99</td><td>PAS 160 - 179 o PAD 100 - 109</td><td>PAS > 179 o PAD > 109</td></tr>'; 
        infoHTBLCronicos += '<tr><td>Sin FR</td><td>Riesgo Bajo</td><td>Riesgo Moderado</td><td>Riesgo Alto</td></tr>'; 
        infoHTBLCronicos += '<tr><td>1 a 2 FR</td><td>Riesgo Moderado</td><td>Riesgo Moderado</td><td>Riesgo Muy Alto</td></tr>'; 
        infoHTBLCronicos += '<tr><td>3 o mas FR o LOB o Diabetes</td><td>Riesgo Alto</td><td>Riesgo Alto</td><td>Riesgo Muy Alto</td></tr>'; 
        infoHTBLCronicos += '<tr><td>Condiciones Clínicas Asociadas</td><td>Riesgo Muy Alto</td><td>Riesgo Muy Alto</td><td>Riesgo Muy Alto</td></tr>'; 
        infoHTBLCronicos += '</table><hr>';
        
        function VerInfoProxCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return 'CAS: ' + record.get('CAS') + '</br>' + record.get('Profesional') + '</br>Fecha:' + record.get('FechaAtencion');
        }
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        //var pnProgramasEspeciales = new pnProgramasEspecialesUi();
        
        
        var stReporteParaclinicos = new StoreGridReporteParaclinicos();
        stReporteParaclinicos.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        function renderClasificacionReporte(val, x, store){
            switch(val){
                case "A":
                    return '<span style="color:#F00">Anormal</span>';
                    break;
                case "N":
                    return '<span style="color:#090">Normal</span>';
                    break;
                default:
                    break;
            }
        }
        function renderValorReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            if(record.get('ReporteVal') !== "" && record.get('ReporteVal') !== null){
                return value + "<br><hr>Valor: " + record.get('ReporteVal');  
            }else{
                return value;  
            }
        }
        function renderObservaReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }

        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    task: 'MX_IPS_BASICA',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
       
        var dataProgramaCronicos = [
            ['PROGRAMA DIABETES'],
            ['PROGRAMA HIPERTENSION'],
            ['PROGRAMA NEFROPROTECCION']
        ];
        var stProgramaCronicos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProgramaCronicos.loadData(dataProgramaCronicos);
        
        var dataEnfermedadActual = [
            ['HIPERTENSION'],
            ['DIABETES'],
            ['PROGRAMA NEFROPROTECCION']
        ];
        var stEnfermedadActual = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEnfermedadActual.loadData(dataEnfermedadActual);
        
        var dataSeguimientoPrograma = [
            [1,'MENSUAL'],
            [3,'TRIMESTRAL'],
            [6,'SEMESTRAL']
        ];
        var stSeguimientoPrograma = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stSeguimientoPrograma.loadData(dataSeguimientoPrograma);
        
        var dataProfesionalTratante = [
            ['MEDICINA GENERAL'],
            ['MEDICINA INTERNA'],
            ['NEFROLOGIA']
        ];
        var stProfesionalTratante = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProfesionalTratante.loadData(dataProfesionalTratante);
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaAsignoCitaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysSolicitaCitologia'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysSolicitaMamografia'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysSolicitaBaciloscopia'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaOrdenamientosHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHCProgEsp01',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'Acompañante - Responsable',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Vive Solo',
                                                        name: 'Vive Solo',
                                                        width: 60,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strViveSolo'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Acompañante',
                                                                name: 'Acompañante',
                                                                width: 350,
                                                                allowBlank: false,
                                                                id: 'strAcompanante'
                                                            },
                                                            {
                                                                html: '   Parentesco:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Parentezco',
                                                                width: 322,
                                                                allowBlank: true,
                                                                store: stParentesco,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strParentescoAcompanante'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Responsable',
                                                        name: 'Responsable',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strResponsable'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Direccion',
                                                                name: 'Direccion',
                                                                width: 350,
                                                                allowBlank: true,
                                                                id: 'strDireccionResponsable'
                                                            },
                                                            {
                                                                html: 'Telefono'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Telefono',
                                                                width: 340,
                                                                allowBlank: true,
                                                                id: 'strTelefonoResponsable'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        value: 'PACIENTE QUE ASISTE A CONTROL DEL PROGRAMA DE RIESGO CARDIOVASCULAR CON EL FIN DE SER EVALUADO Y ANAIZADOS LOS FACTORES DE RIESGO Y ASI PODER REALIZAR NUEVAMENTE LA CLASIFICACION DEL RIESGO Y CONDUCTA A SEGUIR',
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'T.A. (Sentado)',
                                                                name: 'T.A. (Sentado) Sistolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                emptyText: 'Sistolica',
                                                                id: 'intEXAFISTASentadoSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (Sentado) Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                emptyText: 'Diastolica',
                                                                id: 'intEXAFISTASentadoDiastolica'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'T.A. (de Pie)',
                                                                name: 'T.A. (de Pie)',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                emptyText: 'Sistolica',
                                                                id: 'intEXAFISTAdePieSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (de Pie) Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                emptyText: 'Diastolica',
                                                                id: 'intEXAFISTAdePieDiastolica'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEXAFISTalla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFISTalla').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                       if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                                }else{
                                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                                    }else{
                                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                        Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPeso',
                                                                value: 'PESO (Kg) '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEXAFISPeso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFISPeso').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                                }else{
                                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                                    }else{
                                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                        Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISIMC',
                                                                value: 'IMC '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEXAFISIMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEXAFISIMCClasificacon'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPA',
                                                                value: 'P. Abd.'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Perimetro Abdominal',
                                                                allowBlank: false,
                                                                id: 'strEXAFISPA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Fondo de Ojo',
                                                        name: 'Fondo de Ojo',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        id: 'strEXAFISFondoOjo'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Pie Diabetico',
                                                        name: 'Pie Diabetico',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        id: 'strEXAFISPieDiabetico'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DATOS DEL PROGRAMA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsProgramasEspeciales',
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Datos del Programa',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        labelSeparator: '',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                border: true,
                                                                html: infoHTBLCronicos
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Nivel de Riesgo HTA Seguimiento',
                                                                fieldLabel: 'Riesgo HTA',
                                                                width: 70,
                                                                allowBlank: true,
                                                                store: stDatProgNivelRiesgo,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPROGESPENivelRiesgoHTASeguimiento'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Nivel de Riesgo DM Seguimiento',
                                                                        fieldLabel: 'Riesgo DM:',
                                                                        width: 70,
                                                                        allowBlank: true,
                                                                        store: stDatProgNivelRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPENivelRiesgoDMSeguimiento'
                                                                    },
                                                                    {
                                                                        html:'Tipo DM:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Tipo de DM Seguimiento',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stDatProgTipoDM,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPETipoDMSeguimiento'
                                                                    },
                                                                    {
                                                                        html:'Tipo Insulina:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Tipo Insulina',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stDatProgTipoInsulina,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPETipoDMInsulinaSeguimiento'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Nivel de Riesgo Nefroproteccion Seguimiento',
                                                                        fieldLabel: 'Riesgo Nefroproteccion:',
                                                                        width: 70,
                                                                        allowBlank: true,
                                                                        store: stDatProgNivelRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPENivelRiesgoNefroProteccionSeguimiento'
                                                                    },
                                                                    {
                                                                        html:'Estadio Nefroproteccion:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Estadio Nefroproteccion Seguimiento',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stDatProgEstadioNefroProteccion,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPEEstadioNefroProteccionSeguimiento'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 70,
                                                                        fieldLabel: 'Riesgo Cardio Vascular',
                                                                        name: '% Riesgo Cardio Vascular',
                                                                        emptyText: '%',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: false,
                                                                        style: 'text-align:center;',
                                                                        id: 'intRiesgoCardioVascular'
                                                                    },
                                                                    {
                                                                        html: 'Clasificacion'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Clasificacion Riesgo Cardio Vascular',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        store: stDatProgNivelRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strClasificacionRiesgoCardioVascular'
                                                                    },
                                                                    {
                                                                        html: 'Framingham'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                anchor: '100%',
                                                                fieldLabel: 'Confrmacion Programa',
                                                                name: 'Confrmacion Programa',
                                                                displayField: 'Descripcion',
                                                                valueField: 'Descripcion',
                                                                forceSelection: true,
                                                                mode: 'local',
                                                                store: stProgramaCronicos,
                                                                triggerAction: 'all',
                                                                allowBlank: false,
                                                                id: 'strConfirmacionPrograma'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {   
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Parcial de Orina',
                                                                        name: 'Parcial de Orina',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPESeguimientoTraeParcialorina',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank = true;
                                                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank = true;
                                                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').setValue(null);
                                                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').setValue(null);
                                                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').disable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').disable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').clearInvalid();
                                                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').enable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').enable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank = false;
                                                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html:'Fecha:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecPROGESPESeguimientoParcialorina'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 200,
                                                                        name: 'Resultado Pacial Orina',
                                                                        emptyText: 'Resultado',
                                                                        allowBlank: true,
                                                                        id: 'strPROGESPESeguimientoParcialorinaRes'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {   
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Colesterol Total',
                                                                        name: 'Colesterol Total',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPESeguimientoTraeColesterolTotal',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank = true;
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank = true;
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').setValue(null);
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').setValue(null);
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').disable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').disable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').clearInvalid();
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').enable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').enable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank = false;
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html:'Fecha:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecPROGESPESeguimientoColesterolTotal'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Resultado Colesterol Total',
                                                                        emptyText: 'Rango 20 - 700',
                                                                        width: 200,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'strPROGESPESeguimientoColesterolTotalRes'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {   
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Colesterol HDL',
                                                                        name: 'Colesterol HDL',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPESeguimientoTraeColesterolHDL',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank = true;
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank = true;
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').setValue(null);
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').setValue(null);
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').disable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').disable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').clearInvalid();
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').enable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').enable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank = false;
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html:'Fecha:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecPROGESPESeguimientoColesterolHDL'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Resultado Colesterol HDL',
                                                                        emptyText: 'Rango 10 - 500',
                                                                        width: 200,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'strPROGESPESeguimientoColesterolHDLRes'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {   
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Colesterol LDL',
                                                                        name: 'Colesterol LDL',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPESeguimientoTraeColesterolLDL',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank = true;
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank = true;
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').setValue(null);
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').setValue(null);
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').disable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').disable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').clearInvalid();
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').enable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').enable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank = false;
                                                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html:'Fecha:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecPROGESPESeguimientoColesterolLDL'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Resultado Colesterol LDL',
                                                                        emptyText: 'Rango 10 - 500',
                                                                        width: 200,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'strPROGESPESeguimientoColesterolLDLRes'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {   
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Trigliceridos',
                                                                        name: 'Trigliceridos',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPESeguimientoTraeTrigliceridos',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank = true;
                                                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank = true;
                                                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').setValue(null);
                                                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').setValue(null);
                                                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').disable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').disable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').clearInvalid();
                                                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').enable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').enable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank = false;
                                                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html:'Fecha:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecPROGESPESeguimientoTrigliceridos'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Resultado Trigliceridos',
                                                                        emptyText: 'Rango 20 - 1000',
                                                                        width: 200,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'strPROGESPESeguimientoTrigliceridosRes'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {   
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Hb Glicosilada',
                                                                        name: 'Hb Glicosilada',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPESeguimientoTraeHemoglobinaGlicosilada',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank = true;
                                                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank = true;
                                                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').setValue(null);
                                                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').setValue(null);
                                                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').disable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').disable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').clearInvalid();
                                                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').enable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').enable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank = false;
                                                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html:'Fecha:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecPROGESPESeguimientoHemoglobinaGlicosilada'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Resultado Hb Glicosilada',
                                                                        emptyText: 'Rango 5 - 20',
                                                                        width: 200,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'strPROGESPESeguimientoHemoglobinaGlicosiladaRes'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {   
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Glicemia',
                                                                        name: 'Glicemia',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPESeguimientoTraeGlicemia',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank = true;
                                                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank = true;
                                                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').setValue(null);
                                                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').setValue(null);
                                                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').disable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').disable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').clearInvalid();
                                                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').enable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').enable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank = false;
                                                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html:'Fecha:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecPROGESPESeguimientoGlicemia'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Resultado Glicemia',
                                                                        emptyText: 'Rango 20 - 1000',
                                                                        width: 200,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'strPROGESPESeguimientoGlicemiaRes'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {   
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Micro Albuminuria',
                                                                        name: 'Micro Albuminuria',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPESeguimientoTraeMicroAlbuminuria',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank = true;
                                                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank = true;
                                                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').setValue(null);
                                                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').setValue(null);
                                                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').disable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').disable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').clearInvalid();
                                                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').enable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').enable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank = false;
                                                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html:'Fecha:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecPROGESPESeguimientoMicroAlbuminuria'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Resultado Micro Albuminuria',
                                                                        emptyText: 'Rango 0 - 700',
                                                                        width: 200,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'strPROGESPESeguimientoMicroAlbuminuriaRes'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {   
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Creatinina',
                                                                        name: 'Creatinina',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPROGESPESeguimientoTraeCreatinina',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "NO"){
                                                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank = true;
                                                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank = true;
                                                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').setValue(null);
                                                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').setValue(null);
                                                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').disable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').disable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').clearInvalid();
                                                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').enable();
                                                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').enable();
                                                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank = false;
                                                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html:'Fecha:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecPROGESPESeguimientoCreatinina'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Resultado Creatinina',
                                                                        emptyText: 'Rango 0,2 - 25',
                                                                        width: 200,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        id: 'strPROGESPESeguimientoCreatininaRes',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew === null || pNew === 0){
                                                                                    Ext.getCmp('strPROGESPETFGSeguimiento').setValue(null);
                                                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue(null);
                                                                                }else{
                                                                                    var resultadoTFGIngreso = ((140 - AniosCumplidos) * Ext.getCmp('intEXAFISPeso').getValue()) / (72 * Ext.getCmp('strPROGESPESeguimientoCreatininaRes').getValue())

                                                                                    if(Ext.getCmp('sysGeneroHC').getValue() === "FEMENINO"){
                                                                                        Ext.getCmp('strPROGESPETFGSeguimiento').setValue(resultadoTFGIngreso * 0.85);
                                                                                    }else{
                                                                                        Ext.getCmp('strPROGESPETFGSeguimiento').setValue(resultadoTFGIngreso);
                                                                                    }

                                                                                    if(resultadoTFGIngreso < 15){
                                                                                        Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio V");
                                                                                    }else{
                                                                                        if(resultadoTFGIngreso < 30){
                                                                                            Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio IV");
                                                                                        }else{
                                                                                            if(resultadoTFGIngreso < 60){
                                                                                                Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio III");
                                                                                            }else{
                                                                                                if(resultadoTFGIngreso < 90){
                                                                                                    Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio II");
                                                                                                }else{
                                                                                                    Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').setValue("Estadio I");
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'T.F.G Seguimiento',
                                                                        fieldLabel: 'T.F.G Seguimiento',
                                                                        emptyText: 'Resultado',
                                                                        width: 120,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        id: 'strPROGESPETFGSeguimiento'
                                                                    },
                                                                    {
                                                                        html: '-'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        name: 'TFG CLASIFICACION',
                                                                        id: 'strPROGESPETFGSeguimientoCalsifica'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            //has aqui
                                            {
                                                xtype: 'fieldset',
                                                title: 'SEGUIMIENTO DEL PACIENTE',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Actualmnte quien lo esta tratando',
                                                        name: 'Actualmnte quien lo esta tratando',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stProfesionalTratante,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'sysEspecialidadSeguimiento'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Se Debe Realizar Segumiento',
                                                        name: 'Se Debe Realizar Segumiento',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stSeguimientoPrograma,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'sysFormulacion'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 120,
                                                        fieldLabel: 'Fecha Formulacion apartir de',
                                                        name: 'Fecha Formulacion apartir de',
                                                        allowBlank: true,
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'sysFechaFormula'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 120,
                                                        fieldLabel: 'Fecha Realizacion Paraclinicos',
                                                        name: 'Fecha Realizacion Paraclinicos',
                                                        allowBlank: true,
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'sysFechaParaclinicos'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Se Descarta Patologia?',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strSegtoSeDescartaPatologia',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if (cmb.getValue() === "SI"){
                                                                            Ext.getCmp('strSegtoSeDescartaPatologiaObs').setReadOnly(false);
                                                                            Ext.getCmp('strSegtoSeDescartaPatologiaObs').allowBlank = false;
                                                                        }else{
                                                                            Ext.getCmp('strSegtoSeDescartaPatologiaObs').setValue('');
                                                                            Ext.getCmp('strSegtoSeDescartaPatologiaObs').setReadOnly(true);
                                                                            Ext.getCmp('strSegtoSeDescartaPatologiaObs').allowBlank = true;
                                                                            Ext.getCmp('strSegtoSeDescartaPatologiaObs').clearInvalid();
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                width: 550,
                                                                id: 'strSegtoSeDescartaPatologiaObs'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Paciente Desiste del Programa?',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strSegtoDesistePrograma',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if (cmb.getValue() === "SI"){
                                                                            Ext.getCmp('strSegtoDesisteProgramaObs').setReadOnly(false);
                                                                            Ext.getCmp('strSegtoDesisteProgramaObs').allowBlank = false;
                                                                        }else{
                                                                            Ext.getCmp('strSegtoDesisteProgramaObs').setValue('');
                                                                            Ext.getCmp('strSegtoDesisteProgramaObs').setReadOnly(true);
                                                                            Ext.getCmp('strSegtoDesisteProgramaObs').allowBlank = true;
                                                                            Ext.getCmp('strSegtoDesisteProgramaObs').clearInvalid();
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                width: 550,
                                                                id: 'strSegtoDesisteProgramaObs'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            fsDiagnosticosConsulta
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Reporte de Paraclinicos y/o Examenes',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaParaclinicos',
                                layout: 'form',
                                items: [
                                     {
                                        xtype: 'grid',
                                        title: ' ',
                                        id: 'gridReporteParaclinicos',
                                        store: stReporteParaclinicos,
                                        anchor: "100%",
                                        height: 320,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoReporte'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Descripcion',
                                                sortable: false,
                                                width: 300,
                                                dataIndex: 'DescProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Solicitud',
                                                sortable: false,
                                                width: 90,
                                                dataIndex: 'FechaSolicitud'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Realiza',
                                                sortable: false,
                                                width: 120,
                                                dataIndex: 'FechaRealizacion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Reporte',
                                                sortable: false,
                                                width: 150,
                                                renderer: renderValorReporte,
                                                dataIndex: 'ReporteTxt'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Observaciones',
                                                sortable: false,
                                                width: 150,
                                                renderer: renderObservaReporte,
                                                dataIndex: 'Observaciones'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Clasificacion',
                                                sortable: false,
                                                width: 80,
                                                renderer: renderClasificacionReporte,
                                                dataIndex: 'Clasificacion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Solicitante',
                                                sortable: false,
                                                width: 150,
                                                dataIndex: 'Solicitante'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        viewConfig: {
                                            getRowClass: function(record, index) {
                                                if (record.get('Estado') === 'S')
                                                    return 'Negado';
                                                else
                                                    return;
                                            }
                                        },
                                        iconCls:'icon-grid',
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar',
                                                        iconCls: 'btnAddRow',
                                                        listeners: {
                                                            click : function() {
                                                                var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(0);
                                                                winReporteParaclinicos.show();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Reportar',
                                                        iconCls: 'btnEditRow',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridReporteParaclinicos').selModel.getCount() === 1){
                                                                    var selections = Ext.getCmp('gridReporteParaclinicos').selModel.getSelections();
                                                                    if(parseInt(selections[0].json.CASReporte) === parseInt(wCAS)){
                                                                        var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                        Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                        Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                        Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                        Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(selections[0].json.IdConsecutivoReporte);
                                                                        Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.IdProced);
                                                                        Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.DescProced);
                                                                        Ext.getCmp('strNomQuienSolicitaReporteParaclin').setValue(selections[0].json.Solicitante);
                                                                        Ext.getCmp('fecFecSolicitudReporteParaclin').setValue(selections[0].json.FechaSolicitud);
                                                                        Ext.getCmp('fecFecRealizacionReporteParaclin').setValue(selections[0].json.FechaRealizacion);
                                                                        Ext.getCmp('strResultadoReporteParaclin').setValue(selections[0].json.ReporteTxt);
                                                                        Ext.getCmp('intValorReporteParaclin').setValue(selections[0].json.ReporteVal);
                                                                        Ext.getCmp('strClasificacionReporteParaclin').setValue(selections[0].json.Clasificacion);
                                                                        Ext.getCmp('strObservacionesReporteParaclin').setValue(selections[0].json.Observaciones);
                                                                        Ext.getCmp('sysSearchReporteParaclin').setVisible(false);
                                                                        winReporteParaclinicos.show();
                                                                    }else{
                                                                        if(selections[0].json.Estado === "S"){
                                                                            var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                            Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                            Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                            Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                            Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(selections[0].json.IdConsecutivoReporte);
                                                                            Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.IdProced);
                                                                            Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.DescProced);
                                                                            Ext.getCmp('strNomQuienSolicitaReporteParaclin').setValue(selections[0].json.Solicitante);
                                                                            //Ext.getCmp('strNomQuienSolicitaReporteParaclin').setReadOnly(true);
                                                                            Ext.getCmp('fecFecSolicitudReporteParaclin').setValue(selections[0].json.FechaSolicitud);
                                                                            Ext.getCmp('fecFecRealizacionReporteParaclin').setValue(selections[0].json.FechaRealizacion);
                                                                            Ext.getCmp('sysSearchReporteParaclin').setVisible(false);
                                                                            winReporteParaclinicos.show();
                                                                        }else{
                                                                            Ext.MessageBox.show({
                                                                                title: 'Error',
                                                                                msg: 'El registro no esta disponible para ser reportado',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar',
                                                        iconCls: 'btnDelRow',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridReporteParaclinicos').selModel.getCount() === 1){
                                                                    var selections = Ext.getCmp('gridReporteParaclinicos').selModel.getSelections();
                                                                    if((selections[0].json.CAS === null || selections[0].json.CAS === "") && selections[0].json.Estado === "S" && parseInt(selections[0].json.Usuario) === parseInt(Ext.getCmp('sysUsuarioHC').getValue())){
                                                                        Ext.Msg.show({
                                                                            title: 'Reporte Paraclinicos',
                                                                            msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DescProced + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn){
                                                                                if(btn ==="yes"){
                                                                                    fnEliminarRegistrosReporteParaclinicos001("../../controlador/asistencial/evolucionhc2013.php",{task: "ELIMINAR_REPORTEEXA", pIdReporte: selections[0].json.IdConsecutivoReporte}, 'gridReporteParaclinicos');
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'No podemos eliminar los registro en estos momentos',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    '->',
                                                    new Ext.app.SearchField({
                                                        id: 'qryReporteParaclin',
                                                        store: stReporteParaclinicos,
                                                        ValparamP1: wPaciente,
                                                        emptyText: 'Escriba el criterio que desea buscar',
                                                        width: 120,
                                                        pLoadGrid: false,
                                                        pGrid: 'gridReporteParaclinicos',
                                                        parrParam: {params:{pPaciente: wPaciente}}
                                                    })
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCProgEsp01').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCProgEsp01').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Informacion Adicional',
                            iconCls: 'btnVerHC',
                            listeners:{
                                click : function(){ 
                                    verInfoActividadesxPaciente(Ext.getCmp('sysIdPacienteHC').getValue(),Ext.getCmp('sysPacienteHC').getValue() + " - Genero: " + Ext.getCmp('sysGeneroHC').getValue() + " - Edad: " + Ext.getCmp('sysEdadHC').getValue());
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosProgEsp01();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosProgEsp01();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    if(paramOpcion === "Nuevo"){ 
                        var frm = Ext.getCmp('frmHCProgEsp01').getForm();
                        frm.doAction('load', {
                            url: '../../controlador/asistencial/ipsbasica/evolucionhc201601.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarCronicosGrupalMed'
                            },
                            failure: function(response,options){
                                importarcronicos('frmHCProgEsp01', myCAS, Ext.getCmp('sysIdPacienteHC').getValue(),"CRONICOS_GRUPAL_MED");
                            },
                            success:function(form, action) {
                                importarcronicos('frmHCProgEsp01', myCAS, Ext.getCmp('sysIdPacienteHC').getValue(),"CRONICOS_GRUPAL_MED");
                            }
                        });
                    }
                    
                }
            }
        });
        winHCProgramasEspeciales001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosProgEsp01(){
    var frm = Ext.getCmp('frmHCProgEsp01').getForm();
    if (frm.isValid()){
        var pFechaFormula = "";
        var pFechaOrdenamientos = "";
        if(Ext.getCmp('sysFechaFormula').getValue() !== "" && Ext.getCmp('sysFechaFormula').getValue() !== null){
            pFechaFormula = Ext.getCmp('sysFechaFormula').getValue().format('Y-m-d');
        }
        if(Ext.getCmp('sysFechaParaclinicos').getValue() !== "" && Ext.getCmp('sysFechaParaclinicos').getValue() !== null){
            pFechaOrdenamientos = Ext.getCmp('sysFechaParaclinicos').getValue().format('Y-m-d');
        }
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
           url: '../../controlador/asistencial/ipsbasica/evolucionhc201601.php',
            params:{
                task: 'guardar_cronicogrupmed',
                //task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa:Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS:Ext.getCmp('sysIPSHC').getValue(),
                pPaciente:Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional:Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS:Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC:Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion:Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura:Ext.getCmp('sysAperturaHC').getValue(),
                pActividad:Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla:Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC:Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx:Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa:Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem:Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal:Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1:Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2:Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3:Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag:Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad:Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa:Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario:Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente:Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan:Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan:Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato:Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle:Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion:Ext.getCmp('sysFormulacion').getValue(),
                pTASIS:Ext.getCmp('intEXAFISTASentadoSistolica').getValue(),
                pTADIAS:Ext.getCmp('intEXAFISTASentadoDiastolica').getValue(),
                pTensionArterialSistolicaPie:Ext.getCmp('intEXAFISTAdePieSistolica').getValue(),
                pTensionArterialDiastolicaPie:Ext.getCmp('intEXAFISTAdePieDiastolica').getValue(),
                pTalla:Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso:Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC:Ext.getCmp('intEXAFISIMC').getValue(),
                pIMCClasifica:Ext.getCmp('strEXAFISIMCClasificacon').getValue(),
                pPerimetroAbdominal:Ext.getCmp('strEXAFISPA').getValue(),
                pAcompanante:Ext.getCmp('strAcompanante').getValue(),
                pParentescoAcompanante:Ext.getCmp('strParentescoAcompanante').getValue(),
                pResponsable:Ext.getCmp('strResponsable').getValue(),
                pResponsableDireccion:Ext.getCmp('strDireccionResponsable').getValue(),
                pResponsableTelefono:Ext.getCmp('strTelefonoResponsable').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisFec:Ext.getCmp('fecPROGESPESeguimientoParcialorina').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisRes:Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalFec:Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalRes:Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').getValue(),
                pProgramasEspecialesSeguimientoHDLFec:Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').getValue(),
                pProgramasEspecialesSeguimientoHDLRes:Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').getValue(),
                pProgramasEspecialesSeguimientoLDLFec:Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').getValue(),
                pProgramasEspecialesSeguimientoLDLRes:Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosFec:Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosRes:Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaFec:Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaRes:Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaFec:Ext.getCmp('fecPROGESPESeguimientoGlicemia').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaRes:Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaFec:Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaRes:Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').getValue(),
                pProgramasEspecialesSeguimientoCreatininaFec:Ext.getCmp('fecPROGESPESeguimientoCreatinina').getValue(),
                pProgramasEspecialesSeguimientoCreatininaRes:Ext.getCmp('strPROGESPESeguimientoCreatininaRes').getValue(),
                pProgramasEspecialesSeguimientoTFG:Ext.getCmp('strPROGESPETFGSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTFGEstadio:Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').getValue(),
                pProgramasEspecialesSeguimientoRiesgoHTA:Ext.getCmp('strPROGESPENivelRiesgoHTASeguimiento').getValue(),
                pProgramasEspecialesSeguimientoRiesgoDM:Ext.getCmp('strPROGESPENivelRiesgoDMSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTipoDM:Ext.getCmp('strPROGESPETipoDMSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTipoInsulina:Ext.getCmp('strPROGESPETipoDMInsulinaSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoRiesgoNefro:Ext.getCmp('strPROGESPENivelRiesgoNefroProteccionSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoEstadioNefro:Ext.getCmp('strPROGESPEEstadioNefroProteccionSeguimiento').getValue(),
                pProgramasEspecialesRiesgoCardioVascular:Ext.getCmp('intRiesgoCardioVascular').getValue(),
                pProgramasEspecialesRiesgoCardioVascularClasificacion:Ext.getCmp('strClasificacionRiesgoCardioVascular').getValue(),
                pProgramasEspecialesViveSolo:Ext.getCmp('strViveSolo').getValue(),
                pProgramasEspecialesAcompanante:Ext.getCmp('strAcompanante').getValue(),
                pProgramasEspecialesParentescoAcompanante:Ext.getCmp('strParentescoAcompanante').getValue(),
                pProgramasEspecialesSeguimiento:Ext.getCmp('sysFormulacion').getValue(),
                pProgramasEspecialesProfeSeguimiento:Ext.getCmp('sysEspecialidadSeguimiento').getValue(),
                pProgramasEspecialesFechaFormula:pFechaFormula,
                pProgramasEspecialesFechaOrdenamientos:pFechaOrdenamientos,
                pProgramasEspecialesDescartaPatologia:Ext.getCmp('strSegtoSeDescartaPatologia').getValue(),
                pProgramasEspecialesDescartaPatologiaObs:Ext.getCmp('strSegtoSeDescartaPatologiaObs').getValue(),
                pProgramasEspecialesDescartaDesiste:Ext.getCmp('strSegtoDesistePrograma').getValue(),
                pProgramasEspecialesDescartaDesisteObs:Ext.getCmp('strSegtoDesisteProgramaObs').getValue(),
                pProgramasEspecialesProgramaActual : Ext.getCmp('strConfirmacionPrograma').getValue(), 
                pSolicitarCitologia:0,
                pSolicitarMamografia:0,
                pSolicitarBaciloscopia:0,
                pGuardarSignos:"SI",
                pGuardarAntecedentes:"NO",
                pGuardarCronicos:"SI"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosProgEsp01(){
    var frm = Ext.getCmp('frmHCProgEsp01').getForm();
    if (frm.isValid()){
        var pFechaFormula = "";
        var pFechaOrdenamientos = "";
        if(Ext.getCmp('sysFechaFormula').getValue() !== "" && Ext.getCmp('sysFechaFormula').getValue() !== null){
            pFechaFormula = Ext.getCmp('sysFechaFormula').getValue().format('Y-m-d');
        }
        if(Ext.getCmp('sysFechaParaclinicos').getValue() !== "" && Ext.getCmp('sysFechaParaclinicos').getValue() !== null){
            pFechaOrdenamientos = Ext.getCmp('sysFechaParaclinicos').getValue().format('Y-m-d');
        }
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/ipsbasica/evolucionhc201601.php',
            params:{
                task: 'modificar_cronicogrupmed',
                //task: 'modificar',
                CAMPOS: listacampos,
                pIPS:Ext.getCmp('sysIPSHC').getValue(),
                pPaciente:Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional:Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS:Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC:Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion:Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura:Ext.getCmp('sysAperturaHC').getValue(),
                pActividad:Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla:Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC:Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx:Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa:Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem:Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal:Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1:Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2:Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3:Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag:Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad:Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa:Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario:Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente:Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan:Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan:Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato:Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle:Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion:Ext.getCmp('sysFormulacion').getValue(),
                pTASIS:Ext.getCmp('intEXAFISTASentadoSistolica').getValue(),
                pTADIAS:Ext.getCmp('intEXAFISTASentadoDiastolica').getValue(),
                pTensionArterialSistolicaPie:Ext.getCmp('intEXAFISTAdePieSistolica').getValue(),
                pTensionArterialDiastolicaPie:Ext.getCmp('intEXAFISTAdePieDiastolica').getValue(),
                pTalla:Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso:Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC:Ext.getCmp('intEXAFISIMC').getValue(),
                pIMCClasifica:Ext.getCmp('strEXAFISIMCClasificacon').getValue(),
                pPerimetroAbdominal:Ext.getCmp('strEXAFISPA').getValue(),
                pAcompanante:Ext.getCmp('strAcompanante').getValue(),
                pParentescoAcompanante:Ext.getCmp('strParentescoAcompanante').getValue(),
                pResponsable:Ext.getCmp('strResponsable').getValue(),
                pResponsableDireccion:Ext.getCmp('strDireccionResponsable').getValue(),
                pResponsableTelefono:Ext.getCmp('strTelefonoResponsable').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisFec:Ext.getCmp('fecPROGESPESeguimientoParcialorina').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisRes:Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalFec:Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalRes:Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').getValue(),
                pProgramasEspecialesSeguimientoHDLFec:Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').getValue(),
                pProgramasEspecialesSeguimientoHDLRes:Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').getValue(),
                pProgramasEspecialesSeguimientoLDLFec:Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').getValue(),
                pProgramasEspecialesSeguimientoLDLRes:Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosFec:Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosRes:Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaFec:Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaRes:Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaFec:Ext.getCmp('fecPROGESPESeguimientoGlicemia').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaRes:Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaFec:Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaRes:Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').getValue(),
                pProgramasEspecialesSeguimientoCreatininaFec:Ext.getCmp('fecPROGESPESeguimientoCreatinina').getValue(),
                pProgramasEspecialesSeguimientoCreatininaRes:Ext.getCmp('strPROGESPESeguimientoCreatininaRes').getValue(),
                pProgramasEspecialesSeguimientoTFG:Ext.getCmp('strPROGESPETFGSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTFGEstadio:Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').getValue(),
                pProgramasEspecialesSeguimientoRiesgoHTA:Ext.getCmp('strPROGESPENivelRiesgoHTASeguimiento').getValue(),
                pProgramasEspecialesSeguimientoRiesgoDM:Ext.getCmp('strPROGESPENivelRiesgoDMSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTipoDM:Ext.getCmp('strPROGESPETipoDMSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTipoInsulina:Ext.getCmp('strPROGESPETipoDMInsulinaSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoRiesgoNefro:Ext.getCmp('strPROGESPENivelRiesgoNefroProteccionSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoEstadioNefro:Ext.getCmp('strPROGESPEEstadioNefroProteccionSeguimiento').getValue(),
                pProgramasEspecialesRiesgoCardioVascular:Ext.getCmp('intRiesgoCardioVascular').getValue(),
                pProgramasEspecialesRiesgoCardioVascularClasificacion:Ext.getCmp('strClasificacionRiesgoCardioVascular').getValue(),
                pProgramasEspecialesViveSolo:Ext.getCmp('strViveSolo').getValue(),
                pProgramasEspecialesAcompanante:Ext.getCmp('strAcompanante').getValue(),
                pProgramasEspecialesParentescoAcompanante:Ext.getCmp('strParentescoAcompanante').getValue(),
                pProgramasEspecialesSeguimiento:Ext.getCmp('sysFormulacion').getValue(),
                pProgramasEspecialesProfeSeguimiento:Ext.getCmp('sysEspecialidadSeguimiento').getValue(),
                pProgramasEspecialesFechaFormula:pFechaFormula,
                pProgramasEspecialesFechaOrdenamientos:pFechaOrdenamientos,
                pProgramasEspecialesDescartaPatologia:Ext.getCmp('strSegtoSeDescartaPatologia').getValue(),
                pProgramasEspecialesDescartaPatologiaObs:Ext.getCmp('strSegtoSeDescartaPatologiaObs').getValue(),
                pProgramasEspecialesDescartaDesiste:Ext.getCmp('strSegtoDesistePrograma').getValue(),
                pProgramasEspecialesDescartaDesisteObs:Ext.getCmp('strSegtoDesisteProgramaObs').getValue(),
                pProgramasEspecialesProgramaActual : Ext.getCmp('strConfirmacionPrograma').getValue(), 
                pSolicitarCitologia:0,
                pSolicitarMamografia:0,
                pSolicitarBaciloscopia:0,
                pGuardarSignos:"SI",
                pGuardarAntecedentes:"NO",
                pGuardarCronicos:"SI"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}

function solicitarOrdenamientosProgramaCronicos(){
    var wTask = "";
}

function calculoEstadioHTA(){
   if(Ext.getCmp('intEXAFISTASentadoSistolica').getValue() >= 160 || Ext.getCmp('intEXAFISTASentadoDiastolica').getValue() >= 100 || Ext.getCmp('intEXAFISTAdePieSistolica').getValue() >= 160 || Ext.getCmp('intEXAFISTAdePieDiastolica').getValue() >= 100){
       Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("ESTADIO II");
   }else{
       if(Ext.getCmp('intEXAFISTASentadoSistolica').getValue() >= 140 || Ext.getCmp('intEXAFISTASentadoDiastolica').getValue() >= 90 || Ext.getCmp('intEXAFISTAdePieSistolica').getValue() >= 140 || Ext.getCmp('intEXAFISTAdePieDiastolica').getValue() >= 90){
           Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("ESTADIO I");
       }else{
           if(Ext.getCmp('intEXAFISTASentadoSistolica').getValue() >= 120 || Ext.getCmp('intEXAFISTASentadoDiastolica').getValue() >= 80 || Ext.getCmp('intEXAFISTAdePieSistolica').getValue() >= 120 || Ext.getCmp('intEXAFISTAdePieDiastolica').getValue() >= 80){
               Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("PREHIPERTENSION")
           }else{
               Ext.getCmp('strPROGESPEDxHTAEstadio').setValue("NORMAL")
           }
       }
   }
}