/*
* @category    Panel Programas Especiales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var CalculadoraTotal = 0;
var CalculadoraEdad = 0;
var CalculadoraColesterolTotal = 0;
var CalculadoraColesterolHDL = 0;
var CalculadoraPresionArterial = 0;
var CalculadoraDiabetes = 0;
var CalculadoraTabaquismo = 0;

pnProgramasEspeciales01Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnProgramasEspeciales01',
    initComponent: function() {
        
        var dataTipoDxRCV18 = [
            ['1','SI'],
            ['0','NO']
        ];
        var storeTipoDxRCV18 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        storeTipoDxRCV18.loadData(dataTipoDxRCV18);
        
        var dataAniosDxRCV18 = [
            ['999','SIN DEFINIR'],
            ['0.1','1 MES'],
            ['0.2','2 MESES'],
            ['0.3','3 MESES'],
            ['0.4','4 MESES'],
            ['0.5','5 MESES'],
            ['0.6','6 MESES'],
            ['0.7','7 MESES'],
            ['0.8','8 MESES'],
            ['0.9','9 MESES'],
            ['0.1','10 MESES'],
            ['0.11','11 MESES'],
            ['1','1 AÑO'],
            ['2','2 AÑOS'],
            ['3','3 AÑOS'],
            ['4','4 AÑOS'],
            ['5','5 AÑOS'],
            ['6','6 AÑOS'],
            ['7','7 AÑOS'],
            ['8','8 AÑOS'],
            ['9','9 AÑOS'],
            ['10','10 AÑOS'],
            ['11','11 AÑOS'],
            ['12','12 AÑOS'],
            ['13','13 AÑOS'],
            ['14','14 AÑOS'],
            ['15','15 AÑOS'],
            ['16','16 AÑOS'],
            ['17','17 AÑOS'],
            ['18','18 AÑOS'],
            ['19','19 AÑOS'],
            ['20','20 AÑOS'],
            ['21','21 AÑOS'],
            ['22','22 AÑOS'],
            ['23','23 AÑOS'],
            ['24','24 AÑOS'],
            ['25','25 AÑOS'],
            ['26','26 AÑOS'],
            ['27','27 AÑOS'],
            ['28','28 AÑOS'],
            ['29','29 AÑOS'],
            ['30','30 AÑOS'],
            ['31','31 AÑOS'],
            ['32','32 AÑOS'],
            ['33','33 AÑOS'],
            ['34','34 AÑOS'],
            ['35','35 AÑOS'],
            ['36','36 AÑOS'],
            ['37','37 AÑOS'],
            ['38','38 AÑOS'],
            ['39','39 AÑOS'],
            ['40','40 AÑOS'],
            ['41','41 AÑOS'],
            ['42','42 AÑOS'],
            ['43','43 AÑOS'],
            ['44','44 AÑOS'],
            ['45','45 AÑOS'],
            ['46','46 AÑOS'],
            ['47','47 AÑOS'],
            ['48','48 AÑOS'],
            ['49','49 AÑOS'],
            ['50','50 AÑOS'],
            ['51','51 AÑOS'],
            ['52','52 AÑOS'],
            ['53','53 AÑOS'],
            ['54','54 AÑOS'],
            ['55','55 AÑOS'],
            ['56','56 AÑOS'],
            ['57','57 AÑOS'],
            ['58','58 AÑOS'],
            ['59','59 AÑOS'],
            ['60','60 AÑOS'],
            ['61','61 AÑOS'],
            ['62','62 AÑOS'],
            ['63','63 AÑOS'],
            ['64','64 AÑOS'],
            ['65','65 AÑOS'],
            ['66','66 AÑOS'],
            ['67','67 AÑOS'],
            ['68','68 AÑOS'],
            ['69','69 AÑOS'],
            ['70','70 AÑOS'],
            ['71','71 AÑOS'],
            ['72','72 AÑOS'],
            ['73','73 AÑOS'],
            ['74','74 AÑOS'],
            ['75','75 AÑOS'],
            ['76','76 AÑOS'],
            ['77','77 AÑOS'],
            ['78','78 AÑOS'],
            ['79','79 AÑOS'],
            ['80','80 AÑOS']
        ];
        var storeAniosDxRCV18 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        storeAniosDxRCV18.loadData(dataAniosDxRCV18);
        
        var dataTipoDMRCV18 = [
            ['10','TIPO 1'],
            ['20','TIPO 2'],
            ['21','TIPO 2 - INSULINOREQUIRIENTE']
        ];
        var storeTipoDMRCV18 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        storeTipoDMRCV18.loadData(dataTipoDMRCV18);
        
        var dataEstadioRenalRCV18 = [
            ['1','1'],
            ['2','2'],
            ['3','3'],
            ['4','4'],
            ['5','5'],
            ['99','NO SE TIENE EL DATO']
        ];
        var storeEstadioRenalRCV18 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        storeEstadioRenalRCV18.loadData(dataEstadioRenalRCV18);
        
        var dataRiesgoRCV18 = [
            ['ALTO','ALTO'],
            ['MEDIO','MEDIO'],
            ['BAJO','BAJO']
        ];
        var storeRiesgoRCV18 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        storeRiesgoRCV18.loadData(dataRiesgoRCV18);
        
        var dataSeguimientoRCV18 = [
            ['M','MENSUAL POR MEDICINA GENERAL'],
            ['T','TRIMESTRAL POR MEDICINA GENERAL'],
            ['S','SEMESTRAL POR MEDICINA GENERAL']
        ];
        var storeSeguimientoRCV18 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        storeSeguimientoRCV18.loadData(dataSeguimientoRCV18);
        
        this.items = [
            {
                xtype: 'fieldset',
                title: 'INFORMACION PROGRAMAS ESPECIALES INGRESO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id: 'fsProgramasEspeciales01',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Telefono',
                                name: 'Telefono',
                                emptyText: 'Telefono del Paciente',
                                width: 130,
                                minLength: 7,
                                maxLength: 10,
                                allowBlank: false,
                                id: 'strRCV18_Telefono'
                            },
                            {
                                html: ' - Direccion: '
                            },
                            {
                                xtype: 'textfield',
                                name: 'Direccion',
                                emptyText: 'Direccion del Paciente',
                                width: 530,
                                allowBlank: false,
                                id: 'strRCV18_Direccion'
                            }
                        ]
                    },
                    {
                        html: '<hr><br>'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Via de Captacion',
                        name: 'Via de Captacion',
                        width: 150,
                        allowBlank: false,
                        store: stViaCaptacion,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRCV18_ViaCaptacion'
                    },
                    {
                        html: '<hr><br>'
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Fuma?',
                                name: 'Fuma?',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRCV18_Fuma',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue === "NO"){
                                            CalculadoraTabaquismo = 0;
                                        }else{
                                            if(newValue === "SI" && Ext.getCmp('sysGeneroPacHC').getValue() === "MASCULINO"){
                                                CalculadoraTabaquismo = 2;
                                            }else{
                                                if(newValue === "SI" && Ext.getCmp('sysGeneroPacHC').getValue() === "FEMENINO"){
                                                    CalculadoraTabaquismo = 2;
                                                }else{
                                                    CalculadoraTabaquismo = 0;
                                                }
                                            }
                                        }
                                        calculadoraRiesgo();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Diagnostico de HTA?',
                        name: 'Diagnostico de HTA?',
                        //anchor: '100%',
                        width: 60,
                        allowBlank: false,
                        store: storeTipoDxRCV18,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRCV18_DxHTA',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue !== "" && newValue !== null){
                                    if(newValue === "1"){
                                         Ext.getCmp('strRCV18_DxHTAAnios').allowBlank = false;
                                    }else{
                                        Ext.getCmp('strRCV18_DxHTAAnios').allowBlank = true;
                                        Ext.getCmp('strRCV18_DxHTAAnios').setValue('999');
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Años Diagnostico de HTA?',
                                name: 'Años Diagnostico de HTA?',
                                width: 150,
                                allowBlank: false,
                                store: storeAniosDxRCV18,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRCV18_DxHTAAnios'
                            },
                            {
                                html:' - Año Dx:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Año',
                                width: 90,
                                minValue: 1900,
                                maxValue: 2199,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intRCV18_DxHTAElAnio'
                            },
                            {
                                html:' - Mes:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Mes',
                                width: 50,
                                minValue: 1,
                                maxValue: 12,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intRCV18_DxHTAElMes'
                            }
                        ]
                    },
                    {
                        html: '<hr><br>'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Diagnostico de DM?',
                        name: 'Diagnostico de DM?',
                        //anchor: '100%',
                        width: 60,
                        allowBlank: false,
                        store: storeTipoDxRCV18,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRCV18_DxDM',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue !== "" && newValue !== null){
                                    if(newValue === "1"){
                                        Ext.getCmp('strRCV18_DxDMAnios').allowBlank = false;
                                        Ext.getCmp('strRCV18_TipoDM').allowBlank = false;
                                        if(newValue === "1" && Ext.getCmp('sysGeneroPacHC').getValue() === "MASCULINO"){
                                            CalculadoraDiabetes = 2;
                                        }else{
                                            if(newValue === "1" && Ext.getCmp('sysGeneroPacHC').getValue() === "FEMENINO"){
                                                CalculadoraDiabetes = 4;
                                            }else{
                                                CalculadoraDiabetes = 0;
                                            }
                                        }
                                    }else{
                                        Ext.getCmp('strRCV18_DxDMAnios').allowBlank = true;
                                        Ext.getCmp('strRCV18_DxDMAnios').setValue('999');
                                        Ext.getCmp('strRCV18_TipoDM').allowBlank = true;
                                        Ext.getCmp('strRCV18_TipoDM').setValue(null);
                                        CalculadoraDiabetes = 0;
                                    }
                                }
                                calculadoraRiesgo();
                            }
                        }
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Años Diagnostico de DM?',
                                name: 'Años Diagnostico de DM?',
                                //anchor: '100%',
                                width: 150,
                                allowBlank: false,
                                store: storeAniosDxRCV18,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRCV18_DxDMAnios'
                            },
                            {
                                html:' - Año Dx:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Año',
                                width: 90,
                                minValue: 1900,
                                maxValue: 2199,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intRCV18_DxDMElAnio'
                            },
                            {
                                html:' - Mes:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Mes',
                                width: 50,
                                minValue: 1,
                                maxValue: 12,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intRCV18_DxDMElMes'
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Tipo de DM?',
                        name: 'Tipo de DM?',
                        anchor: '100%',
                        allowBlank: false,
                        store: storeTipoDMRCV18,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRCV18_TipoDM'
                    },
                    {
                        html: '<hr><br>'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Diagnostico de ERC?',
                        name: 'Diagnostico de ERC?',
                        //anchor: '100%',
                        width: 60,
                        allowBlank: false,
                        store: storeTipoDxRCV18,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRCV18_DxERC',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue !== "" && newValue !== null){
                                    if(newValue === "1"){
                                         Ext.getCmp('strRCV18_DxERCAAnios').allowBlank = false;
                                    }else{
                                        Ext.getCmp('strRCV18_DxERCAnios').allowBlank = true;
                                        Ext.getCmp('strRCV18_DxERCAnios').setValue('999');
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Años Diagnostico de ERC?',
                                name: 'Años Diagnostico de ERC?',
                                //anchor: '100%',
                                width: 150,
                                allowBlank: false,
                                store: storeAniosDxRCV18,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRCV18_DxERCAnios'
                            },
                            {
                                html:' - Año Dx:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Año',
                                width: 90,
                                minValue: 1900,
                                maxValue: 2199,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intRCV18_DxERCElAnio'
                            },
                            {
                                html:' - Mes:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Mes',
                                width: 50,
                                minValue: 1,
                                maxValue: 12,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intRCV18_DxERCElMes'
                            }
                        ]
                    },
                    {
                        html: '<hr><br>'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Programa Actual',
                        name: 'Programa Actual',
                        anchor: '100%',
                        allowBlank: false,
                        store: stProgramaCronicos,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRCV18_ProgramaActual'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 70,
                                fieldLabel: 'Riesgo Cardio Vascular',
                                name: '% Riesgo Cardio Vascular',
                                emptyText: '%',
                                minValue: 0,
                                maxValue: 100,
                                allowBlank: false,
                                style: 'text-align:center;',
                                id: 'intRCV18_PorcentajeRCV'
                            },
                            {
                                html: 'Clasificacion'
                            },
                            {
                                xtype: 'combo',
                                name: 'Clasificacion Riesgo Cardio Vascular',
                                width: 120,
                                allowBlank: false,
                                store: storeRiesgoRCV18,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRCV18_ClasificacionRCV'
                            },
                            {
                                html: 'Segumiento'
                            },
                            {
                                xtype: 'combo',
                                name: 'Seguimiento Riesgo Cardio Vascular',
                                width: 415,
                                allowBlank: false,
                                store: storeSeguimientoRCV18,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRCV18_SeguimientoRCV',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            if(Ext.getCmp('strRCV18_SeguimientoRCV').getValue() === "M"){
                                                Ext.getCmp('sysFormulacion').setValue(1);
                                            }else{
                                                if(Ext.getCmp('strRCV18_SeguimientoRCV').getValue() === "T"){
                                                    Ext.getCmp('sysFormulacion').setValue(3);
                                                }else{
                                                    if(Ext.getCmp('strRCV18_SeguimientoRCV').getValue() === "S"){
                                                        Ext.getCmp('sysFormulacion').setValue(6);
                                                    }else{
                                                        Ext.getCmp('sysFormulacion').setValue(1);
                                                    }
                                                }
                                            }
                                        }else{
                                            Ext.getCmp('sysFormulacion').setValue(1);
                                        }
                                        txtFormula = "1 Mes";
                                        if(Ext.getCmp('sysFormulacion').getValue() === "1"){
                                            txtFormula = "1 Mes";
                                        }else{
                                            txtFormula = Ext.getCmp('sysFormulacion').getValue() + " Meses";
                                        }
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'La Formula Medica sera por ' + txtFormula,
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.INFO
                                        });
                                    }
                                }
                                
                            }
                        ]
                    },
                    {
                        html: '<hr><br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 100,
                                minValue: 0,
                                maxValue: 250,
                                decimalPrecision: 0,
                                allowBlank: false,
                                fieldLabel: 'Talla (cm)',
                                name:"Talla (cm)",
                                emptyText: '(cm)',
                                id: 'intRCV18_Talla',
                                listeners:{
                                    focus: function(t){
                                        Ext.getCmp('intRCV18_Talla').setValue(Ext.getCmp('intEXAFISTalla').getValue());
                                        Ext.getCmp('intRCV18_Peso').setValue(Ext.getCmp('intEXAFISPeso').getValue());
                                        Ext.getCmp('intRCV18_IMC').setValue(Ext.getCmp('intEXAFISIMC').getValue());
                                        Ext.getCmp('intRCV18_CircunferenciaAbd').setValue(Ext.getCmp('strEXAFISPA').getValue());
                                        
                                        if(parseInt(Ext.getCmp('intRCV18_IMC').getValue()) >= 25){
                                            if(parseInt(Ext.getCmp('intRCV18_Peso').getValue()) >= parseInt(Ext.getCmp('sysEXAFISPesoAnt').getValue())){
                                                Ext.Msg.show({
                                                    title: 'NO CUMPLE META TERAPEUTICA',
                                                    msg: 'El paciente no evidencia perdida en el peso, verifique el peso y/o de indicaciones claras al paciente para seguir las recomensaciones nutricionales',
                                                    buttons: Ext.Msg.OK,
                                                    icon: Ext.Msg.ERROR
                                                });
                                            }
                                        }else{
                                            if(parseInt(Ext.getCmp('intRCV18_Peso').getValue()) > parseInt(Ext.getCmp('sysEXAFISPesoAnt').getValue())){
                                                Ext.Msg.show({
                                                    title: 'NO CUMPLE META TERAPEUTICA',
                                                    msg: 'El paciente no evidencia perdida en el peso, verifique el peso y/o de indicaciones claras al paciente para seguir las recomensaciones nutricionales',
                                                    buttons: Ext.Msg.OK,
                                                    icon: Ext.Msg.ERROR
                                                });
                                            }
                                        }
                                        calculoMetasIni2018();
                                    }
                                }
                            },
                            {
                                html: ' - Peso (Kg) '
                            },
                            {
                                xtype: 'numberfield',
                                width: 100,
                                minValue: 0,
                                maxValue: 250,
                                decimalPrecision: 0,
                                allowBlank: false,
                                readOnly: true,
                                emptyText: '(Kg)',
                                name:"PESO (Kg)",
                                id: 'intRCV18_Peso',
                                listeners:{
                                    focus: function(t){
                                        Ext.getCmp('intRCV18_Talla').setValue(Ext.getCmp('intEXAFISTalla').getValue());
                                        Ext.getCmp('intRCV18_Peso').setValue(Ext.getCmp('intEXAFISPeso').getValue());
                                        Ext.getCmp('intRCV18_IMC').setValue(Ext.getCmp('intEXAFISIMC').getValue());
                                        Ext.getCmp('intRCV18_CircunferenciaAbd').setValue(Ext.getCmp('strEXAFISPA').getValue());
                                        
                                        if(parseInt(Ext.getCmp('intRCV18_IMC').getValue()) >= 25){
                                            if(parseInt(Ext.getCmp('intRCV18_Peso').getValue()) >= parseInt(Ext.getCmp('sysEXAFISPesoAnt').getValue())){
                                                Ext.Msg.show({
                                                    title: 'NO CUMPLE META TERAPEUTICA',
                                                    msg: 'El paciente no evidencia perdida en el peso, verifique el peso y/o de indicaciones claras al paciente para seguir las recomensaciones nutricionales',
                                                    buttons: Ext.Msg.OK,
                                                    icon: Ext.Msg.ERROR
                                                });
                                            }
                                        }else{
                                            if(parseInt(Ext.getCmp('intRCV18_Peso').getValue()) > parseInt(Ext.getCmp('sysEXAFISPesoAnt').getValue())){
                                                Ext.Msg.show({
                                                    title: 'NO CUMPLE META TERAPEUTICA',
                                                    msg: 'El paciente no evidencia perdida en el peso, verifique el peso y/o de indicaciones claras al paciente para seguir las recomensaciones nutricionales',
                                                    buttons: Ext.Msg.OK,
                                                    icon: Ext.Msg.ERROR
                                                });
                                            }
                                        }
                                        calculoMetasIni2018();
                                    }
                                }
                            },
                            {
                                html: ' - IMC.'
                            },
                            {
                                xtype: 'numberfield',
                                width: 100,
                                minValue: 0,
                                maxValue: 250,
                                decimalPrecision: 2,
                                allowBlank: false,
                                readOnly: true,
                                name:"IMC",
                                id: 'intRCV18_IMC',
                                listeners:{
                                    focus: function(t){
                                        Ext.getCmp('intRCV18_Talla').setValue(Ext.getCmp('intEXAFISTalla').getValue());
                                        Ext.getCmp('intRCV18_Peso').setValue(Ext.getCmp('intEXAFISPeso').getValue());
                                        Ext.getCmp('intRCV18_IMC').setValue(Ext.getCmp('intEXAFISIMC').getValue());
                                        Ext.getCmp('intRCV18_CircunferenciaAbd').setValue(Ext.getCmp('strEXAFISPA').getValue());
                                        
                                        if(parseInt(Ext.getCmp('intRCV18_IMC').getValue()) >= 25){
                                            if(parseInt(Ext.getCmp('intRCV18_Peso').getValue()) >= parseInt(Ext.getCmp('sysEXAFISPesoAnt').getValue())){
                                                Ext.Msg.show({
                                                    title: 'NO CUMPLE META TERAPEUTICA',
                                                    msg: 'El paciente no evidencia perdida en el peso, verifique el peso y/o de indicaciones claras al paciente para seguir las recomensaciones nutricionales',
                                                    buttons: Ext.Msg.OK,
                                                    icon: Ext.Msg.ERROR
                                                });
                                            }
                                        }else{
                                            if(parseInt(Ext.getCmp('intRCV18_Peso').getValue()) > parseInt(Ext.getCmp('sysEXAFISPesoAnt').getValue())){
                                                Ext.Msg.show({
                                                    title: 'NO CUMPLE META TERAPEUTICA',
                                                    msg: 'El paciente no evidencia perdida en el peso, verifique el peso y/o de indicaciones claras al paciente para seguir las recomensaciones nutricionales',
                                                    buttons: Ext.Msg.OK,
                                                    icon: Ext.Msg.ERROR
                                                });
                                            }
                                        }
                                        calculoMetasIni2018();
                                    }
                                }
                            },
                            {
                                html: ' - Circunferencia Abd.'
                            },
                            {
                                xtype: 'numberfield',
                                width: 100,
                                minValue: 30,
                                decimalPrecision: 2,
                                name: 'Circunferencia Abdominal',
                                allowBlank: false,
                                emptyText: '(cm)',
                                id: 'intRCV18_CircunferenciaAbd',
                                listeners:{
                                    focus: function(t){
                                        Ext.getCmp('intRCV18_Talla').setValue(Ext.getCmp('intEXAFISTalla').getValue());
                                        Ext.getCmp('intRCV18_Peso').setValue(Ext.getCmp('intEXAFISPeso').getValue());
                                        Ext.getCmp('intRCV18_IMC').setValue(Ext.getCmp('intEXAFISIMC').getValue());
                                        Ext.getCmp('intRCV18_CircunferenciaAbd').setValue(Ext.getCmp('strEXAFISPA').getValue());
                                        calculoMetasIni2018();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'T.A. (Sentado)',
                                name: 'T.A. (Sentado) Sistolica',
                                width: 70,
                                minValue: 0,
                                maxValue: 300,
                                decimalPrecision: 0,
                                allowBlank: false,
                                readOnly: true,
                                emptyText: 'Sistolica',
                                id: 'intRCV18_Sistolica',
                                listeners:{
                                    focus: function(t){
                                        Ext.getCmp('intRCV18_Sistolica').setValue(Ext.getCmp('intEXAFISTASentadoSistolica').getValue());
                                        Ext.getCmp('intRCV18_Diastolica').setValue(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue());
                                        if((parseInt(Ext.getCmp('intRCV18_Sistolica').getValue()) - parseInt(Ext.getCmp('intRCV18_Diastolica').getValue())) < 20){
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Debe haber una diferencia minimo de 20 MMH/HG con respecto a la Diastolica',
                                                buttons: Ext.Msg.OK,
                                                icon: Ext.Msg.ERROR
                                            });
                                            Ext.getCmp('intRCV18_Sistolica').setValue(null);
                                            Ext.getCmp('intEXAFISTASentadoSistolica').setValue(null);
                                        }
                                        calculoMetasIni2018();
                                        if(Ext.getCmp('sysGeneroPacHC').getValue() === "MASCULINO"){
                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 120){
                                                CalculadoraPresionArterial = 0;
                                            }else{
                                                if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 120 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 129){
                                                    CalculadoraPresionArterial = 0;
                                                }else{
                                                    if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 130 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) <  139){
                                                        CalculadoraPresionArterial = 1;
                                                    }else{
                                                        if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 140 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 159){
                                                            CalculadoraPresionArterial = 2;
                                                        }else{
                                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 160){
                                                                CalculadoraPresionArterial = 3;
                                                            }else{
                                                                CalculadoraPresionArterial = 0;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }else{
                                            if(Ext.getCmp('sysGeneroPacHC').getValue() === "FEMENINO"){
                                                if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 120){
                                                    CalculadoraPresionArterial = -3;
                                                }else{
                                                    if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 120 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 129){
                                                        CalculadoraPresionArterial = 0;
                                                    }else{
                                                        if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 130 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 139){
                                                            CalculadoraPresionArterial = 0;
                                                        }else{
                                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 140 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 140){
                                                                CalculadoraPresionArterial = 2;
                                                            }else{
                                                                if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 160){
                                                                    CalculadoraPresionArterial = 3;
                                                                }else{
                                                                    CalculadoraPresionArterial = 0;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }else{
                                                CalculadoraPresionArterial = 0;
                                            }
                                        }
                                        calculadoraRiesgo();
                                    }
                                }
                            },
                            {
                                html: ' - Diastolica: '
                            },
                            {
                                xtype: 'numberfield',
                                name: 'T.A. (Sentado) Diastolica',
                                width: 70,
                                minValue: 0,
                                maxValue: 300,
                                decimalPrecision: 0,
                                allowBlank: false,
                                readOnly: true,
                                emptyText: 'Diastolica',
                                id: 'intRCV18_Diastolica',
                                listeners:{
                                    focus: function(t){
                                        Ext.getCmp('intRCV18_Sistolica').setValue(Ext.getCmp('intEXAFISTASentadoSistolica').getValue());
                                        Ext.getCmp('intRCV18_Diastolica').setValue(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue());
                                        if((parseInt(Ext.getCmp('intRCV18_Sistolica').getValue()) - parseInt(Ext.getCmp('intRCV18_Diastolica').getValue())) < 20){
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Debe haber una diferencia minimo de 20 MMH/HG con respecto a la Siastolica',
                                                buttons: Ext.Msg.OK,
                                                icon: Ext.Msg.ERROR
                                            });
                                            Ext.getCmp('intRCV18_Diastolica').setValue(null);
                                            Ext.getCmp('intEXAFISTASentadoDiastolica').setValue(null);
                                        }
                                        calculoMetasIni2018();
                                        if(Ext.getCmp('sysGeneroPacHC').getValue() === "MASCULINO"){
                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 80){
                                                CalculadoraPresionArterial = 0;
                                            }else{
                                                if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 80 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 84){
                                                    CalculadoraPresionArterial = 0;
                                                }else{
                                                    if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 85 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 89){
                                                        CalculadoraPresionArterial = 1;
                                                    }else{
                                                        if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 90 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 99){
                                                            CalculadoraPresionArterial = 2;
                                                        }else{
                                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 100){
                                                                CalculadoraPresionArterial = 3;
                                                            }else{
                                                                CalculadoraPresionArterial = 0;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }else{
                                            if(Ext.getCmp('sysGeneroPacHC').getValue() === "FEMENINO"){
                                                if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 80){
                                                    CalculadoraPresionArterial = -3;
                                                }else{
                                                    if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 80 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 84){
                                                        CalculadoraPresionArterial = 0;
                                                    }else{
                                                        if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 85 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 89){
                                                            CalculadoraPresionArterial = 0;
                                                        }else{
                                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 90 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 99){
                                                                CalculadoraPresionArterial = 2;
                                                            }else{
                                                                if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 100){
                                                                    CalculadoraPresionArterial = 3;
                                                                }else{
                                                                    CalculadoraPresionArterial = 0;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }else{
                                                CalculadoraPresionArterial = 0;
                                            }
                                        }
                                        calculadoraRiesgo();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        html: '<hr><br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Parcial Orina',
                                fieldLabel: 'Parcial Orina',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV18_0Parcialorina',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('strRCV18_0ParcialorinaRes').allowBlank = false;
                                            Ext.getCmp('strRCV18_0ParcialorinaRes').clearInvalid();
                                        }else{
                                            Ext.getCmp('strRCV18_0ParcialorinaRes').allowBlank = true;
                                            Ext.getCmp('strRCV18_0ParcialorinaRes').clearInvalid();
                                        }
                                    }
                                }
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'textfield',
                                width: 200,
                                name: 'Resultado Pacial Orina',
                                emptyText: 'Resultado',
                                allowBlank: true,
                                id: 'strRCV18_0ParcialorinaRes',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('fecRCV18_0Parcialorina').allowBlank = false;
                                            Ext.getCmp('fecRCV18_0Parcialorina').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecRCV18_0Parcialorina').allowBlank = true;
                                            Ext.getCmp('fecRCV18_0Parcialorina').clearInvalid();
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Colesterol Total',
                                fieldLabel: 'Colesterol Total',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV18_0ColesterolTotal',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('intRCV18_0ColesterolTotalRes').allowBlank = false;
                                            Ext.getCmp('intRCV18_0ColesterolTotalRes').clearInvalid();
                                        }else{
                                            Ext.getCmp('intRCV18_0ColesterolTotalRes').allowBlank = true;
                                            Ext.getCmp('intRCV18_0ColesterolTotalRes').clearInvalid();
                                        }
                                    }
                                }
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Resultado Colesterol Total',
                                emptyText: 'Rango 20 - 700',
                                width: 200,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'intRCV18_0ColesterolTotalRes',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('fecRCV18_0ColesterolTotal').allowBlank = false;
                                            Ext.getCmp('fecRCV18_0ColesterolTotal').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecRCV18_0ColesterolTotal').allowBlank = true;
                                            Ext.getCmp('fecRCV18_0ColesterolTotal').clearInvalid();
                                        }
                                        calculoMetasIni2018();
                                        if(Ext.getCmp('sysGeneroPacHC').getValue() === "MASCULINO"){
                                            if(newValue < 160){
                                                CalculadoraColesterolTotal = -3;
                                            }else{
                                                if(newValue > 160 && newValue < 199){
                                                    CalculadoraColesterolTotal = 0;
                                                }else{
                                                    if(newValue > 200 && newValue < 239){
                                                        CalculadoraColesterolTotal = 1;
                                                    }else{
                                                        if(newValue > 240 && newValue < 279){
                                                            CalculadoraColesterolTotal = 2;
                                                        }else{
                                                            if(newValue > 280){
                                                                CalculadoraColesterolTotal = 3;
                                                            }else{
                                                                CalculadoraColesterolTotal = 0;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }else{
                                            if(Ext.getCmp('sysGeneroPacHC').getValue() === "FEMENINO"){
                                                if(newValue < 160){
                                                    CalculadoraColesterolTotal = -2;
                                                }else{
                                                    if(newValue > 160 && newValue < 199){
                                                        CalculadoraColesterolTotal = 0;
                                                    }else{
                                                        if(newValue > 200 && newValue < 239){
                                                            CalculadoraColesterolTotal = 1;
                                                        }else{
                                                            if(newValue > 240 && newValue < 279){
                                                                CalculadoraColesterolTotal = 1;
                                                            }else{
                                                                if(newValue > 280){
                                                                    CalculadoraColesterolTotal = 3;
                                                                }else{
                                                                    CalculadoraColesterolTotal = 0;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }else{
                                                CalculadoraColesterolTotal = 0;
                                            }
                                        }
                                        calculadoraRiesgo();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Colesterol HDL',
                                fieldLabel: 'Colesterol HDL',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV18_0ColesterolHDL',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('intRCV18_0ColesterolHDLRes').allowBlank = false;
                                            Ext.getCmp('intRCV18_0ColesterolHDLRes').clearInvalid();
                                        }else{
                                            Ext.getCmp('intRCV18_0ColesterolHDLRes').allowBlank = true;
                                            Ext.getCmp('intRCV18_0ColesterolHDLRes').clearInvalid();
                                        }
                                        if(Ext.getCmp('sysGeneroPacHC').getValue() === "MASCULINO"){
                                            if(newValue < 35){
                                                CalculadoraColesterolHDL = 2;
                                            }else{
                                                if(newValue > 35 && newValue < 44){
                                                    CalculadoraColesterolHDL = 1;
                                                }else{
                                                    if(newValue > 45 && newValue < 49){
                                                        CalculadoraColesterolHDL = 0;
                                                    }else{
                                                        if(newValue > 50 && newValue < 59){
                                                            CalculadoraColesterolHDL = 0;
                                                        }else{
                                                            if(newValue > 60){
                                                                CalculadoraColesterolHDL = -2;
                                                            }else{
                                                                CalculadoraColesterolHDL = 0;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }else{
                                            if(Ext.getCmp('sysGeneroPacHC').getValue() === "FEMENINO"){
                                                if(newValue < 35){
                                                    CalculadoraColesterolHDL = 5;
                                                }else{
                                                    if(newValue > 35 && newValue < 44){
                                                        CalculadoraColesterolHDL = 2;
                                                    }else{
                                                        if(newValue > 45 && newValue < 49){
                                                            CalculadoraColesterolHDL = 1;
                                                        }else{
                                                            if(newValue > 50 && newValue < 59){
                                                                CalculadoraColesterolHDL = 0;
                                                            }else{
                                                                if(newValue > 60){
                                                                    CalculadoraColesterolHDL = -3;
                                                                }else{
                                                                    CalculadoraColesterolHDL = 0;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }else{
                                                CalculadoraColesterolHDL = 0;
                                            }
                                        }
                                        calculadoraRiesgo();
                                    }
                                }
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Resultado Colesterol HDL',
                                emptyText: 'Rango 10 - 500',
                                width: 200,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'intRCV18_0ColesterolHDLRes',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('fecRCV18_0ColesterolHDL').allowBlank = false;
                                            Ext.getCmp('fecRCV18_0ColesterolHDL').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecRCV18_0ColesterolHDL').allowBlank = true;
                                            Ext.getCmp('fecRCV18_0ColesterolHDL').clearInvalid();
                                        }
                                        calculoMetasIni2018();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Colesterol LDL',
                                fieldLabel: 'Colesterol LDL',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV18_0ColesterolLDL',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('intRCV18_0ColesterolLDLRes').allowBlank = false;
                                            Ext.getCmp('intRCV18_0ColesterolLDLRes').clearInvalid();
                                        }else{
                                            Ext.getCmp('intRCV18_0ColesterolLDLRes').allowBlank = true;
                                            Ext.getCmp('intRCV18_0ColesterolLDLRes').clearInvalid();
                                        }
                                    }
                                }
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Resultado Colesterol LDL',
                                emptyText: 'Rango 10 - 500',
                                width: 200,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'intRCV18_0ColesterolLDLRes',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('fecRCV18_0ColesterolLDL').allowBlank = false;
                                            Ext.getCmp('fecRCV18_0ColesterolLDL').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecRCV18_0ColesterolLDL').allowBlank = true;
                                            Ext.getCmp('fecRCV18_0ColesterolLDL').clearInvalid();
                                        }
                                        calculoMetasIni2018();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Trigliceridos',
                                fieldLabel: 'Trigliceridos',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV18_0Trigliceridos',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('intRCV18_0TrigliceridosRes').allowBlank = false;
                                            Ext.getCmp('intRCV18_0TrigliceridosRes').clearInvalid();
                                        }else{
                                            Ext.getCmp('intRCV18_0TrigliceridosRes').allowBlank = true;
                                            Ext.getCmp('intRCV18_0TrigliceridosRes').clearInvalid();
                                        }
                                    }
                                }
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Resultado Trigliceridos',
                                emptyText: 'Rango 20 - 1000',
                                width: 200,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'intRCV18_0TrigliceridosRes',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('fecRCV18_0Trigliceridos').allowBlank = false;
                                            Ext.getCmp('fecRCV18_0Trigliceridos').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecRCV18_0Trigliceridos').allowBlank = true;
                                            Ext.getCmp('fecRCV18_0Trigliceridos').clearInvalid();
                                        }
                                        calculoMetasIni2018();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Hb Glicosilada',
                                fieldLabel: 'Hb Glicosilada',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV18_0HemoglobinaGlicosilada',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('intRCV18_0HemoglobinaGlicosiladaRes').allowBlank = false;
                                            Ext.getCmp('intRCV18_0HemoglobinaGlicosiladaRes').clearInvalid();
                                        }else{
                                            Ext.getCmp('intRCV18_0HemoglobinaGlicosiladaRes').allowBlank = true;
                                            Ext.getCmp('intRCV18_0HemoglobinaGlicosiladaRes').clearInvalid();
                                        }
                                    }
                                }
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Resultado Hb Glicosilada',
                                emptyText: 'Rango 5 - 20',
                                width: 200,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'intRCV18_0HemoglobinaGlicosiladaRes',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('fecRCV18_0HemoglobinaGlicosilada').allowBlank = false;
                                            Ext.getCmp('fecRCV18_0HemoglobinaGlicosilada').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecRCV18_0HemoglobinaGlicosilada').allowBlank = true;
                                            Ext.getCmp('fecRCV18_0HemoglobinaGlicosilada').clearInvalid();
                                        }
                                        calculoMetasIni2018();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Glicemia',
                                fieldLabel: 'Glicemia',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV18_0Glicemia',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('intRCV18_0GlicemiaRes').allowBlank = false;
                                            Ext.getCmp('intRCV18_0GlicemiaRes').clearInvalid();
                                        }else{
                                            Ext.getCmp('intRCV18_0GlicemiaRes').allowBlank = true;
                                            Ext.getCmp('intRCV18_0GlicemiaRes').clearInvalid();
                                        }
                                    }
                                }
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Resultado Glicemia',
                                emptyText: 'Rango 20 - 1000',
                                width: 200,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intRCV18_0GlicemiaRes',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('fecRCV18_0Glicemia').allowBlank = false;
                                            Ext.getCmp('fecRCV18_0Glicemia').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecRCV18_0Glicemia').allowBlank = true;
                                            Ext.getCmp('fecRCV18_0Glicemia').clearInvalid();
                                        }
                                        calculoMetasIni2018();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Micro Albuminuria',
                                fieldLabel: 'Micro Albuminuria',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV18_0MicroAlbuminuria',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').allowBlank = false;
                                            Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').clearInvalid();
                                        }else{
                                            Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').allowBlank = true;
                                            Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').clearInvalid();
                                        }
                                    }
                                }
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Resultado Micro Albuminuria',
                                emptyText: 'Rango 0 - 700',
                                width: 200,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'intRCV18_0MicroAlbuminuriaRes',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('fecRCV18_0MicroAlbuminuria').allowBlank = false;
                                            Ext.getCmp('fecRCV18_0MicroAlbuminuria').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecRCV18_0MicroAlbuminuria').allowBlank = true;
                                            Ext.getCmp('fecRCV18_0MicroAlbuminuria').clearInvalid();
                                        }
                                        calculoMetasIni2018();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Proteinas 24 horas',
                                fieldLabel: 'Proteinas 24 horas',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV18_0Proteinas',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('intRCV18_0ProteinasRes').allowBlank = false;
                                            Ext.getCmp('intRCV18_0ProteinasRes').clearInvalid();
                                        }else{
                                            Ext.getCmp('intRCV18_0ProteinasRes').allowBlank = true;
                                            Ext.getCmp('intRCV18_0ProteinasRes').clearInvalid();
                                        }
                                    }
                                }
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Resultado Proteinas 24 horas',
                                emptyText: 'Resultado',
                                width: 200,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'intRCV18_0ProteinasRes',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('fecRCV18_0Proteinas').allowBlank = false;
                                            Ext.getCmp('fecRCV18_0Proteinas').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecRCV18_0Proteinas').allowBlank = true;
                                            Ext.getCmp('fecRCV18_0Proteinas').clearInvalid();
                                        }
                                        calculoMetasIni2018();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Ecografia Renal',
                                fieldLabel: 'Ecografia Renal',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV18_0EcografiaRenal',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('strRCV18_0EcografiaRenalRes').allowBlank = false;
                                            Ext.getCmp('strRCV18_0EcografiaRenalRes').clearInvalid();
                                        }else{
                                            Ext.getCmp('strRCV18_0EcografiaRenalRes').allowBlank = true;
                                            Ext.getCmp('strRCV18_0EcografiaRenalRes').clearInvalid();
                                        }
                                    }
                                }
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'textfield',
                                name: 'Resultado Ecografia Renal',
                                emptyText: 'Resultado',
                                width: 200,
                                allowBlank: true,
                                id: 'strRCV18_0EcografiaRenalRes',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('fecRCV18_0EcografiaRenal').allowBlank = false;
                                            Ext.getCmp('fecRCV18_0EcografiaRenal').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecRCV18_0EcografiaRenal').allowBlank = true;
                                            Ext.getCmp('fecRCV18_0EcografiaRenal').clearInvalid();
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Fecha Creatinina',
                                fieldLabel: 'Creatinina',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecRCV18_0Creatinina',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('intRCV18_0CreatininaRes').allowBlank = false;
                                            Ext.getCmp('intRCV18_0CreatininaRes').clearInvalid();
                                        }else{
                                            Ext.getCmp('intRCV18_0CreatininaRes').allowBlank = true;
                                            Ext.getCmp('intRCV18_0CreatininaRes').clearInvalid();
                                        }
                                    }
                                }
                            },
                            {
                                html: ' - '
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Resultado Creatinina',
                                emptyText: 'Rango 0,2 - 25',
                                width: 200,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'intRCV18_0CreatininaRes',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue !== "" && newValue !== null){
                                            Ext.getCmp('fecRCV18_0Creatinina').allowBlank = false;
                                            Ext.getCmp('fecRCV18_0Creatinina').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecRCV18_0Creatinina').allowBlank = true;
                                            Ext.getCmp('fecRCV18_0Creatinina').clearInvalid();
                                        }
                                        if(newValue === null || newValue === 0){
                                            Ext.getCmp('intRCV18_TFG0').setValue(null);
                                            Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue(null);
                                        }else{
                                            var resultadoTFGIngreso = ((140 - AniosCumplidos) * Ext.getCmp('intRCV18_Peso').getValue()) / (72 * Ext.getCmp('intRCV18_0CreatininaRes').getValue())

                                            if(Ext.getCmp('sysGeneroHC').getValue() === "FEMENINO"){
                                                Ext.getCmp('intRCV18_TFG0').setValue(resultadoTFGIngreso * 0.85);
                                            }else{
                                                Ext.getCmp('intRCV18_TFG0').setValue(resultadoTFGIngreso);
                                            }
                                            calculoMetasIni2018();
                                            /*
                                            if(resultadoTFGIngreso < 15){
                                                Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio V");
                                            }else{
                                                if(resultadoTFGIngreso < 30){
                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio IV");
                                                }else{
                                                    if(resultadoTFGIngreso < 60){
                                                        Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio III");
                                                    }else{
                                                        if(resultadoTFGIngreso < 90){
                                                            Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio II");
                                                        }else{
                                                            Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio I");
                                                        }
                                                    }
                                                }
                                            }
                                            */
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 100,
                                minValue: 0,
                                decimalPrecision: 2,
                                allowBlank: false,
                                fieldLabel: 'TFG - Registrada',
                                name:"TFG - Registrada",
                                id: 'intRCV18_TFG0'
                            },  
                            {
                                html: ' - Estadio: '
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Estadio Renal registrado en HC?',
                                name: 'Estadio Renal registrado en HC?',
                                anchor: '100%',
                                allowBlank: false,
                                store: storeEstadioRenalRCV18,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRCV18_EstadioRenalRegistradoHC',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        calculoMetasIni2018();
                                    }
                                }
                            }
                        ]
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'CALCULADORA DE RIESGO CARDIOVASCULAR - SCORE',
                        layout: 'form',
                        collapsible: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        fieldLabel: 'Puntaje',
                                        name: 'Puntaje',
                                        width: 70,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'intPuntaje'
                                    },
                                    {
                                        html: 'Porcentaje Riesgo Accidente Cardiovascular'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 200,
                                        name: 'Porcentaje Riesgo Accidente Cardiovascular',
                                        allowBlank: true,
                                        id: 'strPorcentajeRiesgo'
                                    }
                                ]
                            }
                        ]
                    },
                    /*{
                        xtype: 'fieldset',
                        title: 'CALCULADORA DE RIESGO CARDIOVASCULAR - FRAMINGHAM',
                        layout: 'form',
                        collapsible: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        tbar:[
                            {
                                xtype: 'button',
                                text: 'Calcular',
                                iconCls: 'btnProgramarAgenda',
                                listeners:{
                                    click : function(){
                                        calculadoraFramingham();
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ],
                        items: [
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Riesgo 10 Años',
                                name: 'Riesgo 10 Años',
                                width: 70,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'sysRiesgo10Anios'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Riesgo 5 Años',
                                name: 'Riesgo 5 Años',
                                width: 70,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'sysRiesgo5Anios'
                            },
                            {
                                html: '<hr>Riesgo 10 Años<br>'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'No Fuma',
                                name: 'No Fuma',
                                width: 70,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'sysRiesgoNoFuma'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Colesterol/HDL',
                                name: 'Colesterol/HDL',
                                width: 70,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'sysRiesgoColesterol'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'P. Arterial 120',
                                name: 'P. Arterial 120',
                                width: 70,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'sysRiesgoPA'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Todos Anteriores',
                                name: 'Todos Anteriores',
                                width: 70,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'sysRiesgoTodosAnt'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Colesterol HDL',
                                name: 'Colesterol HDL',
                                width: 70,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'sysRiesgoColesterolHDL'
                            },
                            {
                                html: '<span style= "font-size: xx-small; align:right; color:blue;">Fuente: www.formulaframingham.com.ar</span>' 
                            }
                        ]
                    },*/
                    {
                        html: '<hr><br>'
                    },
                    {
                        xtype: 'panel',
                        title: 'RESUMEN METAS TERAPEUTICAS',
                        collapsible: false,
                        titleCollapse: false,
                        autoScroll: true,
                        closable: false,
                        anchor: '100%',
                        autoHeight: true,
                        style: 'background:transparent;',
                        id: 'viewResumenMetasTerapeuticas'
                    },
                    {
                        xtype: 'hidden',
                        fieldLabel: 'RESUMEN METAS TERAPEUTICAS',
                        name: 'RESUMEN METAS TERAPEUTICAS',
                        allowBlank: true,
                        id: 'memMetasTerapeuticas'
                    },
                    {
                        html: '<hr><br>'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Recomendaciones Metas Terapeuticas',
                        layout: 'table',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        items: [
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Recomendaciones Metas Terapeuticas',
                                name: 'Recomendaciones Metas Terapeuticas',
                                width: 800,
                                allowBlank: true,
                                id: 'memRecomendacionesMetasTerapeuticas'
                            }
                        ]
                    }
                ]
            }
        ];
        pnProgramasEspeciales01Ui.superclass.initComponent.call(this);
    }
});

function calculoMetasIni2018(){
    pPrograma = "";
    switch(Ext.getCmp('strRCV18_ProgramaActual').getValue()){
        case "PROGRAMA HIOPERTENSION":
            pPrograma = "HTA";
            break;
        case "PROGRAMA HIPERTENSION ARTERIAL":
            pPrograma = "HTA";
            break;
        case "PROGRAMA DIABETES":
            pPrograma = "DM";
            break;
        case "PROGRAMA DIABETES MELLITUS":
            pPrograma = "DM";
            break;
        case "PROGRAMA NEFROPROTECCION":
            pPrograma = "ERC";
            break;
        default:
            break;
    }
    Puntaje = 0;
    html = '<table width="100%" border="1" cellpading="3" cellspacing="3">';
    switch(pPrograma){
        case "HTA":
            if(Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== "" && Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) >= 60) && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) <= 100)){
                Puntaje += 5;
                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
            }
            
            if(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue()) <= 100)){
                Puntaje += 25;
                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
            }
            
            if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) > 40){
                    Puntaje += 5;
                    html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                }else{
                    html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                }
            }else{
                if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) <= 50){
                    Puntaje += 5;
                    html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                }else{
                    html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                }
            }
            
            if(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== "" && Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue()) <= 150)){
                Puntaje += 5;
                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
            }
            
            if(parseInt(AniosCumplidos) < 60){
                if(Ext.getCmp('intRCV18_Sistolica').getValue() !== "" && Ext.getCmp('intRCV18_Sistolica').getValue() !== null && Ext.getCmp('intRCV18_Diastolica').getValue() !== "" && Ext.getCmp('intRCV18_Diastolica').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_Sistolica').getValue()) < 140) && (parseInt(Ext.getCmp('intRCV18_Diastolica').getValue()) < 90)){
                    Puntaje += 25;
                    html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                }else{
                    html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                }
            }else{
                if(Ext.getCmp('intRCV18_Sistolica').getValue() !== "" && Ext.getCmp('intRCV18_Sistolica').getValue() !== null && Ext.getCmp('intRCV18_Diastolica').getValue() !== "" && Ext.getCmp('intRCV18_Diastolica').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_Sistolica').getValue()) < 150) && (parseInt(Ext.getCmp('intRCV18_Diastolica').getValue()) < 90)){
                    Puntaje += 25;
                    html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                }else{
                    html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                }
            }
            
            if(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== "" && Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue()) < 30)){
                Puntaje += 25;
                html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
            }
            
            if(Ext.getCmp('intRCV18_IMC').getValue() !== "" && Ext.getCmp('intRCV18_IMC').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_IMC').getValue()) < 25)){
                Puntaje += 5;
                html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
            }
            
            if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 94){
                    Puntaje += 5;
                    html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                }else{
                    html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                }
            }else{
                if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 90){
                    Puntaje += 5;
                    html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                }else{
                    html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                }
            }
            
            break;
            
        case "DM":
            if(Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== "" && Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) >= 70) && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) <= 130)){
                Puntaje += 4;
                html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
            }
            
            if(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue()) <= 100)){
                Puntaje += 20;
                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
            }
            
            if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) > 40){
                    Puntaje += 4;
                    html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                }else{
                    html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                }
            }else{
                if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) <= 50){
                    Puntaje += 4;
                    html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                }else{
                    html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                }
            }
            
            if(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== "" && Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue()) <= 150)){
                Puntaje += 4;
                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
            }
            
            if(Ext.getCmp('intRCV18_Sistolica').getValue() !== "" && Ext.getCmp('intRCV18_Sistolica').getValue() !== null && Ext.getCmp('intRCV18_Diastolica').getValue() !== "" && Ext.getCmp('intRCV18_Diastolica').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_Sistolica').getValue()) < 140) && (parseInt(Ext.getCmp('intRCV18_Diastolica').getValue()) < 90)){
                Puntaje += 20;
                html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
            }
            
            
            if(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== "" && Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue()) < 30)){
                Puntaje += 20;
                html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
            }
            
            if(Ext.getCmp('intRCV18_IMC').getValue() !== "" && Ext.getCmp('intRCV18_IMC').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_IMC').getValue()) < 25)){
                Puntaje += 4;
                html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
            }
            
            if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 94){
                    Puntaje += 4;
                    html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                }else{
                    html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                }
            }else{
                if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 90){
                    Puntaje += 4;
                    html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                }else{
                    html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                }
            }
            
            if((parseInt(Ext.getCmp('intRCV18_0HemoglobinaGlicosiladaRes').getValue()) <= 8)){
                Puntaje += 20;
                html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>HEMOGLOBINA GLICOSILADA A1C</b></span></td></tr>';
            }else{
                html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>HEMOGLOBINA GLICOSILADA A1C</b></span></td></tr>';
            }
            
            break;
        
        case "ERC":
            if(Ext.getCmp('strRCV18_DxDM').getValue() == "1"){
                //DM = SI - Estadio 1,2,3
                if(Ext.getCmp('strRCV18_EstadioRenalRegistradoHC').getValue() == "1" || Ext.getCmp('strRCV18_EstadioRenalRegistradoHC').getValue() == "2" || Ext.getCmp('strRCV18_EstadioRenalRegistradoHC').getValue() == "3"){
                    
                    if(Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== "" && Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) >= 70) && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) <= 130)){
                        Puntaje += 4;
                        html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
                    }

                    if(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue()) <= 100)){
                        Puntaje += 20;
                        html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
                    }

                    if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                        if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) > 40){
                            Puntaje += 4;
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                        }
                    }else{
                        if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) <= 50){
                            Puntaje += 4;
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                        }
                    }

                    if(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== "" && Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue()) <= 150)){
                        Puntaje += 4;
                        html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
                    }

                    if(Ext.getCmp('intRCV18_Sistolica').getValue() !== "" && Ext.getCmp('intRCV18_Sistolica').getValue() !== null && Ext.getCmp('intRCV18_Diastolica').getValue() !== "" && Ext.getCmp('intRCV18_Diastolica').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_Sistolica').getValue()) < 140) && (parseInt(Ext.getCmp('intRCV18_Diastolica').getValue()) < 90)){
                        Puntaje += 20;
                        html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                    }


                    if(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== "" && Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue()) < 30)){
                        Puntaje += 20;
                        html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
                    }

                    if(Ext.getCmp('intRCV18_IMC').getValue() !== "" && Ext.getCmp('intRCV18_IMC').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_IMC').getValue()) < 25)){
                        Puntaje += 4;
                        html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
                    }

                    if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                        if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 94){
                            Puntaje += 4;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                        }
                    }else{
                        if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 90){
                            Puntaje += 4;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                        }
                    }

                    if((parseInt(Ext.getCmp('intRCV18_0HemoglobinaGlicosiladaRes').getValue()) <= 8)){
                        Puntaje += 20;
                        html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>HEMOGLOBINA GLICOSILADA A1C</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>HEMOGLOBINA GLICOSILADA A1C</b></span></td></tr>';
                    }
            
                }else{
                    //DM = SI - Estadio 4
                    if(Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== "" && Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) >= 70) && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) <= 130)){
                        Puntaje += 5;
                        html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
                    }

                    if(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue()) <= 100)){
                        Puntaje += 0;
                        html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
                    }

                    if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                        if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) > 40){
                            Puntaje += 5;
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                        }
                    }else{
                        if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) <= 50){
                            Puntaje += 5;
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                        }
                    }

                    if(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== "" && Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue()) <= 150)){
                        Puntaje += 5;
                        html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
                    }

                    if(Ext.getCmp('intRCV18_Sistolica').getValue() !== "" && Ext.getCmp('intRCV18_Sistolica').getValue() !== null && Ext.getCmp('intRCV18_Diastolica').getValue() !== "" && Ext.getCmp('intRCV18_Diastolica').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_Sistolica').getValue()) < 140) && (parseInt(Ext.getCmp('intRCV18_Diastolica').getValue()) < 90)){
                        Puntaje += 30;
                        html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                    }


                    if(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== "" && Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue()) < 30)){
                        Puntaje += 15;
                        html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
                    }

                    if(Ext.getCmp('intRCV18_IMC').getValue() !== "" && Ext.getCmp('intRCV18_IMC').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_IMC').getValue()) < 25)){
                        Puntaje += 5;
                        html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
                    }

                    if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                        if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 94){
                            Puntaje += 5;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                        }
                    }else{
                        if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 90){
                            Puntaje += 5;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                        }
                    }

                    if((parseInt(Ext.getCmp('intRCV18_0HemoglobinaGlicosiladaRes').getValue()) <= 8)){
                        Puntaje += 30;
                        html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>HEMOGLOBINA GLICOSILADA A1C</b></span></td></tr>';
                    }else{
                        html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>HEMOGLOBINA GLICOSILADA A1C</b></span></td></tr>';
                    }
                }
            }else{
                if(Ext.getCmp('strRCV18_DxHTA').getValue() == "1"){
                    //DM = SI - Estadio 1,2,3
                    if(Ext.getCmp('strRCV18_EstadioRenalRegistradoHC').getValue() == "1" || Ext.getCmp('strRCV18_EstadioRenalRegistradoHC').getValue() == "2" || Ext.getCmp('strRCV18_EstadioRenalRegistradoHC').getValue() == "3"){

                        if(Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== "" && Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) >= 70) && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) <= 130)){
                            Puntaje += 5;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
                        }

                        if(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue()) <= 100)){
                            Puntaje += 25;
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
                        }

                        if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                            if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) > 40){
                                Puntaje += 5;
                                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                            }else{
                                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                            }
                        }else{
                            if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) <= 50){
                                Puntaje += 5;
                                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                            }else{
                                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                            }
                        }

                        if(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== "" && Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue()) <= 150)){
                            Puntaje += 5;
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
                        }

                        if(Ext.getCmp('intRCV18_Sistolica').getValue() !== "" && Ext.getCmp('intRCV18_Sistolica').getValue() !== null && Ext.getCmp('intRCV18_Diastolica').getValue() !== "" && Ext.getCmp('intRCV18_Diastolica').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_Sistolica').getValue()) < 140) && (parseInt(Ext.getCmp('intRCV18_Diastolica').getValue()) < 90)){
                            Puntaje += 25;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                        }


                        if(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== "" && Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue()) < 30)){
                            Puntaje += 25;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
                        }

                        if(Ext.getCmp('intRCV18_IMC').getValue() !== "" && Ext.getCmp('intRCV18_IMC').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_IMC').getValue()) < 25)){
                            Puntaje += 5;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
                        }

                        if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                            if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 94){
                                Puntaje += 5;
                                html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                            }else{
                                html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                            }
                        }else{
                            if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 90){
                                Puntaje += 5;
                                html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                            }else{
                                html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                            }
                        }

                        if((parseInt(Ext.getCmp('intRCV18_0HemoglobinaGlicosiladaRes').getValue()) <= 8)){
                            Puntaje += 0;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>HEMOGLOBINA GLICOSILADA A1C</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>HEMOGLOBINA GLICOSILADA A1C</b></span></td></tr>';
                        }

                    }else{
                        //DM = SI - Estadio 4
                        if(Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== "" && Ext.getCmp('intRCV18_0GlicemiaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) >= 70) && (parseInt(Ext.getCmp('intRCV18_0GlicemiaRes').getValue()) <= 130)){
                            Puntaje += 10;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>GLICEMIA</b></span></td></tr>';
                        }

                        if(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0ColesterolLDLRes').getValue()) <= 100)){
                            Puntaje += 0;
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL LDL</b></span></td></tr>';
                        }

                        if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                            if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) > 40){
                                Puntaje += 10;
                                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                            }else{
                                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                            }
                        }else{
                            if(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== "" && Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue() !== null && parseInt(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue()) <= 50){
                                Puntaje += 10;
                                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                            }else{
                                html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>COLESTEROL HDL</b></span></td></tr>';
                            }
                        }

                        if(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== "" && Ext.getCmp('intRCV18_0TrigliceridosRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0TrigliceridosRes').getValue()) <= 150)){
                            Puntaje += 10;
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkgreen;"><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>TRIGLICERIDOS</b></span></td></tr>';
                        }

                        if(Ext.getCmp('intRCV18_Sistolica').getValue() !== "" && Ext.getCmp('intRCV18_Sistolica').getValue() !== null && Ext.getCmp('intRCV18_Diastolica').getValue() !== "" && Ext.getCmp('intRCV18_Diastolica').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_Sistolica').getValue()) < 140) && (parseInt(Ext.getCmp('intRCV18_Diastolica').getValue()) < 90)){
                            Puntaje += 40;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PRESION ARTERIAL</b></span></td></tr>';
                        }


                        if(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== "" && Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_0MicroAlbuminuriaRes').getValue()) < 30)){
                            Puntaje += 10;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>MICROALBUMINURIA</b></span></td></tr>';
                        }

                        if(Ext.getCmp('intRCV18_IMC').getValue() !== "" && Ext.getCmp('intRCV18_IMC').getValue() !== null && (parseInt(Ext.getCmp('intRCV18_IMC').getValue()) < 25)){
                            Puntaje += 10;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>IMC</b></span></td></tr>';
                        }

                        if(Ext.getCmp('sysGeneroHC').getValue() == "M") {
                            if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 94){
                                Puntaje += 10;
                                html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                            }else{
                                html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                            }
                        }else{
                            if(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== "" && Ext.getCmp('intRCV18_CircunferenciaAbd').getValue() !== null && parseInt(Ext.getCmp('intRCV18_CircunferenciaAbd').getValue()) < 90){
                                Puntaje += 10;
                                html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                            }else{
                                html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>PERIMETRO ABDOMINAL</b></span></td></tr>';
                            }
                        }

                        if((parseInt(Ext.getCmp('intRCV18_0HemoglobinaGlicosiladaRes').getValue()) <= 8)){
                            Puntaje += 0;
                            html += '<tr><td><span style="color: darkgreen;">SI CUMPLE META TERAPEUTICA - <b>HEMOGLOBINA GLICOSILADA A1C</b></span></td></tr>';
                        }else{
                            html += '<tr><td><span style="color: darkred;">NO CUMPLE META TERAPEUTICA - <b>HEMOGLOBINA GLICOSILADA A1C</b></span></td></tr>';
                        }
                    }
                }
            }
            break;
            
        default:
            break;
    }
    html += '<tr><td><span>PUNTAJE TOTAL META TERAPEUTICA - <b>' + Puntaje + '</b> de 100</span></td></tr>';
    html += '</table>';
    console.log(html);
    Ext.getCmp('viewResumenMetasTerapeuticas').update('<br>');
    Ext.getCmp('viewResumenMetasTerapeuticas').update(html);
    Ext.getCmp('memMetasTerapeuticas').setValue(html);
}

function calculadoraRiesgo(){
    // CALCULADORA EDAD
    if(Ext.getCmp('sysGeneroPacHC').getValue() === "MASCULINO"){
        if(MesesCumplidos >= 360 && MesesCumplidos <= 419){
            CalculadoraEdad = -1;
        }else{
            if(MesesCumplidos >= 420 && MesesCumplidos <= 479){
                CalculadoraEdad = 0;
            }else{
                if(MesesCumplidos >= 480 && MesesCumplidos <= 539){
                    CalculadoraEdad = 1;
                }else{
                    if(MesesCumplidos >= 540 && MesesCumplidos <= 599){
                        CalculadoraEdad = 2;
                    }else{
                        if(MesesCumplidos >= 600 && MesesCumplidos <= 659){
                            CalculadoraEdad = 3;
                        }else{
                            if(MesesCumplidos >= 660 && MesesCumplidos <= 719){
                                CalculadoraEdad = 4;
                            }else{
                                if(MesesCumplidos >= 720 && MesesCumplidos <= 779){
                                    CalculadoraEdad = 5;
                                }else{
                                    if(MesesCumplidos >= 780 && MesesCumplidos <= 839){
                                        CalculadoraEdad = 6;
                                    }else{
                                        if(MesesCumplidos >= 840 && MesesCumplidos <= 899){
                                            CalculadoraEdad = 7;
                                        }else{
                                            CalculadoraEdad = 0;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }else{
        if(Ext.getCmp('sysGeneroPacHC').getValue() === "FEMENINO"){
            if(MesesCumplidos >= 360 && MesesCumplidos <= 419){
                CalculadoraEdad = -9;
            }else{
                if(MesesCumplidos >= 420 && MesesCumplidos <= 479){
                    CalculadoraEdad = -4;
                }else{
                    if(MesesCumplidos >= 480 && MesesCumplidos <= 539){
                        CalculadoraEdad = 0;
                    }else{
                        if(MesesCumplidos >= 540 && MesesCumplidos <= 599){
                            CalculadoraEdad = 3;
                        }else{
                            if(MesesCumplidos >= 600 && MesesCumplidos <= 659){
                                CalculadoraEdad = 6;
                            }else{
                                if(MesesCumplidos >= 660 && MesesCumplidos <= 719){
                                    CalculadoraEdad = 7;
                                }else{
                                    if(MesesCumplidos >= 720 && MesesCumplidos <= 779){
                                        CalculadoraEdad = 8;
                                    }else{
                                        if(MesesCumplidos >= 780 && MesesCumplidos <= 839){
                                            CalculadoraEdad = 8;
                                        }else{
                                            if(MesesCumplidos >= 840 && MesesCumplidos <= 899){
                                                CalculadoraEdad = 8;
                                            }else{
                                                CalculadoraEdad = 0;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }else{
            CalculadoraEdad = 0;
        }
    }
    
    CalculadoraTotal = CalculadoraEdad + CalculadoraColesterolTotal + CalculadoraColesterolHDL + CalculadoraPresionArterial + CalculadoraDiabetes + CalculadoraTabaquismo; 
    Ext.getCmp('intPuntaje').setValue(CalculadoraTotal);
    
    if(Ext.getCmp('sysGeneroPacHC').getValue() === "MASCULINO"){
        if(CalculadoraTotal < -2){
            Ext.getCmp('strPorcentajeRiesgo').setValue("2%")
        }else{
            if(CalculadoraTotal == -1){
                Ext.getCmp('strPorcentajeRiesgo').setValue("2%")
            }else{
                if(CalculadoraTotal == 0){
                    Ext.getCmp('strPorcentajeRiesgo').setValue("3%")
                }else{
                    if(CalculadoraTotal == 1){
                        Ext.getCmp('strPorcentajeRiesgo').setValue("3%")
                    }else{
                        if(CalculadoraTotal == 2){
                            Ext.getCmp('strPorcentajeRiesgo').setValue("4%")
                        }else{
                            if(CalculadoraTotal == 3){
                                Ext.getCmp('strPorcentajeRiesgo').setValue("5%")
                            }else{
                                if(CalculadoraTotal == 4){
                                    Ext.getCmp('strPorcentajeRiesgo').setValue("7%")
                                }else{
                                    if(CalculadoraTotal == 5){
                                        Ext.getCmp('strPorcentajeRiesgo').setValue("8%")
                                    }else{
                                        if(CalculadoraTotal == 6){
                                            Ext.getCmp('strPorcentajeRiesgo').setValue("10%")
                                        }else{
                                            if(CalculadoraTotal == 7){
                                                Ext.getCmp('strPorcentajeRiesgo').setValue("13%")
                                            }else{
                                                if(CalculadoraTotal == 8){
                                                    Ext.getCmp('strPorcentajeRiesgo').setValue("16%")
                                                }else{
                                                    if(CalculadoraTotal == 9){
                                                        Ext.getCmp('strPorcentajeRiesgo').setValue("20%")
                                                    }else{
                                                        if(CalculadoraTotal == 10){
                                                            Ext.getCmp('strPorcentajeRiesgo').setValue("25%")
                                                        }else{
                                                            if(CalculadoraTotal == 11){
                                                                Ext.getCmp('strPorcentajeRiesgo').setValue("31%")
                                                            }else{
                                                                if(CalculadoraTotal == 12){
                                                                    Ext.getCmp('strPorcentajeRiesgo').setValue("37%")
                                                                }else{
                                                                    if(CalculadoraTotal == 13){
                                                                        Ext.getCmp('strPorcentajeRiesgo').setValue("45%")
                                                                    }else{
                                                                        if(CalculadoraTotal == 14){
                                                                            Ext.getCmp('strPorcentajeRiesgo').setValue(">53%")
                                                                        }else{
                                                                            if(CalculadoraTotal == 15){
                                                                                Ext.getCmp('strPorcentajeRiesgo').setValue(">53%")
                                                                            }else{
                                                                                if(CalculadoraTotal == 16){
                                                                                    Ext.getCmp('strPorcentajeRiesgo').setValue(">53%")
                                                                                }else{
                                                                                    if(CalculadoraTotal > 17){
                                                                                        Ext.getCmp('strPorcentajeRiesgo').setValue(">53%")
                                                                                    }else{
                                                                                        Ext.getCmp('strPorcentajeRiesgo').setValue("0%")
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } 
            } 
        } 
    }else{
       if(Ext.getCmp('sysGeneroPacHC').getValue() === "FEMENINO"){
           if(CalculadoraTotal < -2){
                Ext.getCmp('strPorcentajeRiesgo').setValue("1%")
            }else{
                if(CalculadoraTotal == -1){
                    Ext.getCmp('strPorcentajeRiesgo').setValue("2%")
                }else{
                    if(CalculadoraTotal == 0){
                        Ext.getCmp('strPorcentajeRiesgo').setValue("2%")
                    }else{
                        if(CalculadoraTotal == 1){
                            Ext.getCmp('strPorcentajeRiesgo').setValue("2%")
                        }else{
                            if(CalculadoraTotal == 2){
                                Ext.getCmp('strPorcentajeRiesgo').setValue("3%")
                            }else{
                                if(CalculadoraTotal == 3){
                                    Ext.getCmp('strPorcentajeRiesgo').setValue("3%")
                                }else{
                                    if(CalculadoraTotal == 4){
                                        Ext.getCmp('strPorcentajeRiesgo').setValue("4%")
                                    }else{
                                        if(CalculadoraTotal == 5){
                                            Ext.getCmp('strPorcentajeRiesgo').setValue("4%")
                                        }else{
                                            if(CalculadoraTotal == 6){
                                                Ext.getCmp('strPorcentajeRiesgo').setValue("5%")
                                            }else{
                                                if(CalculadoraTotal == 7){
                                                    Ext.getCmp('strPorcentajeRiesgo').setValue("6%")
                                                }else{
                                                    if(CalculadoraTotal == 8){
                                                        Ext.getCmp('strPorcentajeRiesgo').setValue("7%")
                                                    }else{
                                                        if(CalculadoraTotal == 9){
                                                            Ext.getCmp('strPorcentajeRiesgo').setValue("8%")
                                                        }else{
                                                            if(CalculadoraTotal == 10){
                                                                Ext.getCmp('strPorcentajeRiesgo').setValue("10%")
                                                            }else{
                                                                if(CalculadoraTotal == 11){
                                                                    Ext.getCmp('strPorcentajeRiesgo').setValue("11%")
                                                                }else{
                                                                    if(CalculadoraTotal == 12){
                                                                        Ext.getCmp('strPorcentajeRiesgo').setValue("13%")
                                                                    }else{
                                                                        if(CalculadoraTotal == 13){
                                                                            Ext.getCmp('strPorcentajeRiesgo').setValue("15%")
                                                                        }else{
                                                                            if(CalculadoraTotal == 14){
                                                                                Ext.getCmp('strPorcentajeRiesgo').setValue("18%")
                                                                            }else{
                                                                                if(CalculadoraTotal == 15){
                                                                                    Ext.getCmp('strPorcentajeRiesgo').setValue("20%")
                                                                                }else{
                                                                                    if(CalculadoraTotal == 16){
                                                                                        Ext.getCmp('strPorcentajeRiesgo').setValue("24%")
                                                                                    }else{
                                                                                        if(CalculadoraTotal > 17){
                                                                                            Ext.getCmp('strPorcentajeRiesgo').setValue(">27%")
                                                                                        }else{
                                                                                            Ext.getCmp('strPorcentajeRiesgo').setValue("0%")
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } 
                } 
            }
        }else{
            Ext.getCmp('strPorcentajeRiesgo').setValue("0%");
        } 
    }
}


function retornarLogaritmo(nom){
    return Math.log(nom);
}

function calcularColesterolRat(hdl, chol){
    if (hdl > 0){
        Ext.getCmp('sysRiesgoColesterolHDL').setValue((Math.round((chol * 10) / hdl)) / 10);
    }
}

function calculadoraFramingham(){
    //rafael
    var sbp = parseFloat(Ext.getCmp('intRCV18_Sistolica').getValue());
    var hdl = parseFloat(Ext.getCmp('intRCV18_0ColesterolHDLRes').getValue());
    var chol = parseFloat(Ext.getCmp('intRCV18_0ColesterolTotalRes').getValue());
    calcularColesterolRat(hdl, chol);
    if (chol > 0){
        if (hdl > 0){
           var cholrat = chol / hdl;
       }
    }
    if (hdl === 0) { gato
        var cholrat = chol;
        Ext.getCmp('sysRiesgoColesterolHDL').setValue(cholrat);
    }
    if (chol === 0) {
        var cholrat = 5;
        Ext.getCmp('sysRiesgoColesterolHDL').setValue(5);
    }
    if (Ext.getCmp('trRCV18_Fuma').getValue() === "SI"){
        var smoker = 1;
    }else{
        var smoker = 0;
    }
    xsysRiesgo10Anios = calcularRiesgoFramingham(10, smoker, cholrat, sbp);
    xsysRiesgo5Anios = calcularRiesgoFramingham(5, smoker, cholrat, sbp);
    xsysRiesgoTodosAnt = calcularRiesgoFramingham(10, 0, 4, 120);
    xsysRiesgoNoFuma = calcularRiesgoFramingham(10, 0, cholrat, sbp);
    xsysRiesgoColesterol = calcularRiesgoFramingham(10, smoker, 4, sbp);
    xsysRiesgoPA = calcularRiesgoFramingham(10, smoker, cholrat, 120);
    xsysRiesgoColesterolHDL = Ext.getCmp('sysRiesgoColesterolHDL').getValue();
    
    Ext.getCmp('sysRiesgo10Anios').setValue(xsysRiesgo10Anios);
    Ext.getCmp('sysRiesgo5Anios').setValue(xsysRiesgo5Anios);
    Ext.getCmp('sysRiesgoTodosAnt').setValue(xsysRiesgoTodosAnt);
    Ext.getCmp('sysRiesgoNoFuma').setValue(xsysRiesgoNoFuma);
    Ext.getCmp('sysRiesgoColesterol').setValue(xsysRiesgoColesterol);
    Ext.getCmp('sysRiesgoPA').setValue(xsysRiesgoPA);
    Ext.getCmp('sysRiesgoColesterolHDL').setValue(xsysRiesgoColesterolHDL);
    
    mostrarAlarmas();
    
    /*Ext.getCmp('sysRiesgo10Anios').setValue(xsysRiesgo10Anios);
    Ext.getCmp('sysRiesgo5Anios').setValue(xsysRiesgo5Anios);
    Ext.getCmp('sysRiesgoTodosAnt').setValue(xsysRiesgoTodosAnt);
    Ext.getCmp('sysRiesgoNoFuma').setValue(xsysRiesgoNoFuma);
    Ext.getCmp('sysRiesgoColesterol').setValue(xsysRiesgoColesterol);
    Ext.getCmp('sysRiesgoPA').setValue(xsysRiesgoPA);
    Ext.getCmp('sysRiesgoColesterolHDL').setValue(xsysRiesgoColesterolHDL);*/
}

function calcularRiesgoFramingham(years, smoker, chdl, bloodpres){
    with (Math){ 
        var age1 = AniosCumplidos;
	var risk = 0;
	var co1 = 0.9145;
	var co2 = -0.2784;
	var co3 = 15.5305;
	var fem = 28.4441;
	var logage = -1.4792;
	var lagef = -14.4588;
	var lagef2 = 1.8515;
	var lsbp = -0.9119;
	var cigs = -0.2767;
	var logchol = -0.7181;
	var diab = -0.1759;
	var diabf = -0.1999;
	var cvrisk = 0;
    }
    cvrisk = co3;
    if (Ext.getCmp('sysGeneroPacHC').setValue() === "FEMENINO"){
        cvrisk += fem;
        cvrisk += (retornarLogaritmo(age1) * lagef);
        cvrisk += (retornarLogaritmo(age1) * retornarLogaritmo(age1) * lagef2);
    }
    cvrisk += (retornarLogaritmo(age1) * logage);
    cvrisk += (retornarLogaritmo(bloodpres) * lsbp);
    if (smoker === 1){
        cvrisk += cigs;
    }
    cvrisk += (retornarLogaritmo(chdl) * logchol);
    switch(Ext.getCmp('strRCV18_ProgramaActual').getValue()){
        case "PROGRAMA DIABETES":
            cvrisk += diab;
            break;
        case "PROGRAMA DIABETES MELLITUS":
            cvrisk += diab;
            break;
        default:
            break;
    }
    var la = (co1 + (co2 * cvrisk));
    la = Math.exp(la);
    la = ((retornarLogaritmo(years) - cvrisk) / la);
    cvrisk = Math.round(1000*(1 - Math.exp(-Math.exp(la))))/10;
    return cvrisk;
}

function mostrarAlarmas() {
    var alarm_on=15;
    var warn_on=10;
    if (parseInt(Ext.getCmp('sysRiesgo10Anios').getValue()) >= alarm_on){
        Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgo10Anios').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgo10Anios').getValue()) >= warn_on) {
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgo10Anios').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgo10Anios').addClass('fondoRiesgoVerde');
        }
    }
    if (parseInt(Ext.getCmp('sysRiesgo5Anios').getValue()) >= alarm_on) {
        Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgo5Anios').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgo5Anios').getValue()) >= warn_on) {
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgo5Anios').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgo5Anios').addClass('fondoRiesgoVerde');
        }
    }
    
    if (parseInt(Ext.getCmp('sysRiesgoTodosAnt').getValue()) >= alarm_on){
        Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgoTodosAnt').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgoTodosAnt').getValue()) >= warn_on) {
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoTodosAnt').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoTodosAnt').addClass('fondoRiesgoVerde');
        }
    }
   
    if (parseInt(Ext.getCmp('sysRiesgoNoFuma').getValue()) >= alarm_on){
        Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgoNoFuma').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgoNoFuma').getValue()) >= warn_on) {
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoNoFuma').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoNoFuma').addClass('fondoRiesgoVerde');
        }
    }
    
    if (parseInt(Ext.getCmp('sysRiesgoColesterol').getValue()) >= alarm_on){
        Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgoColesterol').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgoColesterol').getValue()) >= warn_on) {
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoColesterol').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoColesterol').addClass('fondoRiesgoVerde');
        }
    }

    if (parseInt(Ext.getCmp('sysRiesgoPA').getValue()) >= alarm_on){
        Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgoPA').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgoPA').getValue()) >= warn_on) {
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoPA').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoPA').addClass('fondoRiesgoVerde');
        }
    }

    if (parseInt(Ext.getCmp('sysRiesgoColesterolHDL').getValue()) >= 5.5){
        Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgoColesterolHDL').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgoColesterolHDL').getValue()) >= 4.1) {
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoColesterolHDL').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoColesterolHDL').addClass('fondoRiesgoVerde');
        }
    }
}