/*
* @category    Formulario Modelo Kardex CLAP 2010
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winCrecimientoDesarrolloUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .: Crecimiento y Desarrollo ::.',
    width: 990,
    autoHeigth: 606,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        
        //Store Locales
        var dataValoracionDesarrolloCyD = [
            [0,'NO'],
            [1,'SI']
        ];
        var stValoracionDesarrolloCyD = new Ext.data.ArrayStore({
            fields: [
                {name: 'Valor'},
                {name: 'Descripcion'}
            ]
        });
        stValoracionDesarrolloCyD.loadData(dataValoracionDesarrolloCyD);
        
        var itemEscala1a3 = new fsEVALDESA1a3Ui();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
            {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'hidden',
                        allowBlank: true,
                        readOnly: true,
                        width: 100,
                        id: 'sysLegalizaHC'
                    },
                    {
                                                        xtype: 'hidden',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'Paciente',
                                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                                        id: 'sysPacienteHC'
                                                    },
                    {
                                                        xtype: 'hidden',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'Cliente',
                                                        id: 'sysClienteHC'
                                                    },

                                                            {
                                                                xtype: 'hidden',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                fieldLabel: 'CAS',
                                                                id: 'sysCASHC'
                                                            },
                                                            {
                                                                xtype: 'hidden',
                                                                id: 'sysAIEPI_0',
                                                                value: 'Fecha: '
                                                            },
                                                            {
                                                                xtype: 'hidden',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                width: 100,
                                                                id: 'sysFechaHC'
                                                            },
                                                            {
                                                                xtype: 'hidden',
                                                                id: 'sysAIEPI_1',
                                                                value: 'Hora: '
                                                            },
                                                            {
                                                                xtype: 'hidden',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                width: 90,
                                                                id: 'sysHoraHC'
                                                            },

                                                            {
                                                                xtype: 'hidden',
                                                                id: 'sysAIEPI_2',
                                                                value: 'Nro Autorización: '
                                                            },
                                                            {
                                                                xtype: 'hidden',
                                                                width: 110,
                                                                allowBlank: true,
                                                                style: 'color:brown;',
                                                                readOnly: true,
                                                                id: 'sysNroAutorizacionHC'
                                                            },
                {
                    xtype:'tabpanel',
                    activeTab:0,
                    anchor:'99%',
                    heigth:615,
                    items:[
                        { 
                            xtype: 'panel',
                            frame: true,
                            anchor: '100%',
                            id: 'panelCD',
                            padding: 10,
                            title:'Formato',
                            border: false,
                            height: 550,
                            autoScroll: true,
                            layout: 'form',
                            style: 'background:transparent;',
                            items: [  
                                {
                                    xtype: 'panel',
                                    layout: 'table',
                                    anchor: '100%',
                                    layoutConfig: {
                                        columns: 4
                                    }, 
                                    items: [
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            title:'<center>ANTECEDENTES FAMILIARES</center>',
                                            width:230,
                                            height:300,
                                            padding: 7,
                                            items: [
                                                { 
                                                    xtype: 'fieldset',
                                                    layout: 'form',
                                                    collapsible: false,
                                                    titleCollapse: false,
                                                    width:220,
                                                    padding: 5,
                                                    items: [
                                                        {
                                                            xtype: 'textfield',
                                                            name:'Hermanos Desnutrios Menores de 5 Años',
                                                            fieldLabel: '1. Hermanos Desnutrios Menores de 5 Años',
                                                            allowBlank: false,
                                                            width:80,
                                                            id: 'intHerDesMenoresCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            name:'Numero De Hermanos Vivos',
                                                            width:80,
                                                            fieldLabel: '2. Nro De Hermanos Vivos',
                                                            allowBlank: false,
                                                            id: 'intNumHerVivosCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            name:'Numero De Hermanos Vivos',
                                                            fieldLabel: '3. Nro De Hermanos Muertos Menores De 5 Años',
                                                            allowBlank: false,
                                                            width:80,
                                                            id: 'intNumHerMuertosCYD'
                                                        },
                                                        {
                                                            xtype: 'textarea',
                                                            name:'Numero De Hermanos Vivos',
                                                            fieldLabel: 'Causas',
                                                            width:80,
                                                            allowBlank: false,
                                                            id: 'strCausasCYD'
                                                        }
                                                    ]
                                                }
                                            ]
                                        },
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            width:220,
                                            title:'ANTECEDENTES OBSTETRICOS',
                                            height:300,
                                            padding: 7,
                                            items: [
                                                {
                                                    xtype: 'fieldset',
                                                    layout: 'form',
                                                    collapsible: false,
                                                    titleCollapse: false,
                                                    width:210,
                                                    height:265,
                                                    padding: 5,
                                                    items: [
                                                        {

                                                            xtype: 'combo',
                                                            width: 70,
                                                            fieldLabel: '1. Atencion Prenatal',
                                                            name: 'Atencion Prenatal',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strAtenPrenatalCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 70,
                                                            fieldLabel: '2. Embarazo Normal',
                                                            name: 'Embarazo Normal',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strEmbNormalCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Edad De La Madre Al Nacer',
                                                            fieldLabel: '3. Edad De La Madre Al Nacer El Hijo(Años)',
                                                            allowBlank: false,
                                                            id: 'intEdaMadNacHijoCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Edad Del  Embarazo Al Nacer EL Hijo',
                                                            fieldLabel: '4. Edad Del  Embarazo Al Nacer EL Hijo(Meses)',
                                                            allowBlank: false,
                                                            id: 'intEdaEmbNacHijoCYD'
                                                        }
                                                    ]
                                                }
                                            ] 
                                        },
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            width: '220',
                                            title:'ANTECEDENTES DE NACIMIENTO',
                                            height:300,
                                            padding: 7,
                                            items: [
                                                {
                                                    xtype: 'fieldset',
                                                    layout: 'form',
                                                    collapsible: false,
                                                    titleCollapse: false,
                                                    width:210,
                                                    height:265,
                                                    padding: 5,
                                                    items: [
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: '1. Parto Institucional',
                                                            name: 'Parto Institucional',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strParInstitucionalCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: '2. Parto Espontaneo',
                                                            name: 'Parto Espontaneo',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strParEspontaneoCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: '3. Presentacion Cefalica',
                                                            name: 'Parto Espontaneo',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPreCefalicaCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: '4. Producto Unico',
                                                            name: 'Producto Unico',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strProUnicoCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 60,
                                                            name:'Peso Al Nacer',
                                                            fieldLabel: '5. Peso Al Nacer (grms)',
                                                            allowBlank: false,
                                                            id: 'intPesNacerCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 60,
                                                            name:'Talla Al Nacer',
                                                            fieldLabel: '6. Talla Al Nacer (cms)',
                                                            allowBlank: false,
                                                            id: 'intTalNacerCYD'
                                                        }
                                                    ]
                                                }
                                            ]
                                        },
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            width: '220',
                                            height:300,
                                            padding: 7,
                                            items: [
                                                {  
                                                    xtype: 'fieldset',
                                                    layout: 'form',
                                                    collapsible: false,
                                                    titleCollapse: false,
                                                    width:210,
                                                    height:290,
                                                    padding: 5,
                                                    items:[
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Total Moticidad Gruesa',
                                                            fieldLabel: 'Total Moticidad Gruesa',
                                                            allowBlank: false,
                                                            id: 'intTotMotGruesaCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Total Motriz Fino Adaptado',
                                                            fieldLabel: 'Total Motriz Fino Adaptado',
                                                            allowBlank: false,
                                                            id: 'intTotMotFinAdaptadoCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Total Audicion Lenguaje',
                                                            fieldLabel: 'Total Audicion Lenguaje',
                                                            allowBlank: false,
                                                            id: 'intTotAudLenguajeCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Total Audicion Lenguaje',
                                                            fieldLabel: 'Total Personal Social',
                                                            allowBlank: false,
                                                            id: 'intTotPerSocialCYD'
                                                        }
                                                    ]
                                                }
                                            ] 
                                        },
                                    ]
                                },
                                {
                                    xtype: 'fieldset',
                                    layout: 'form',
                                    title:'ANTECEDENTES DEL DESARROLLO',
                                    collapsible: false,
                                    titleCollapse:false,
                                    width:500,
                                    padding: 5,
                                    items: [
                                        { 
                                            xtype: 'panel',
                                            layout: 'table',
                                            width:490,
                                            padding: 7,
                                            layoutConfig: {
                                                columns: 2
                                            },
                                            items: [
                                                {
                                                    xtype: 'panel',
                                                    layout: 'form',
                                                    width: '220',
                                                    padding: 7,
                                                    items:[
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Sostuvo la cabeza',
                                                            fieldLabel: 'Sostuvo La Cabeza (Meses)',
                                                            allowBlank: false,
                                                            id: 'intSosCabezaCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Agarro Objetos',
                                                            fieldLabel: 'Agarro Objetos(Meses)',
                                                            allowBlank: false,
                                                            id: 'intAgaObjetosCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Se Sonrio',
                                                            fieldLabel: 'Se Sonrio (Meses)',
                                                            allowBlank: false,
                                                            id: 'intSonrioCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Se Sento',
                                                            fieldLabel: 'Se Sento (Meses)',
                                                            allowBlank: false,
                                                            id: 'intSentoCYD'
                                                        }
                                                    ]
                                                },
                                                {
                                                    xtype: 'panel',
                                                    layout: 'form',
                                                    width: '220',
                                                    padding: 7,
                                                    items:[
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Primer Diente',
                                                            fieldLabel: 'Primer Diente (Meses)',
                                                            allowBlank: false,
                                                            id: 'intPriDienteCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Gateo',
                                                            fieldLabel: 'Gateo (Meses)',
                                                            allowBlank: false,
                                                            id: 'intGateoCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Primera Palabra',
                                                            fieldLabel: 'Primera Palabra (Meses)',
                                                            allowBlank: false,
                                                            id: 'intPriPalabraCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 70,
                                                            name:'Camino',
                                                            fieldLabel: 'Camino (Meses)',
                                                            allowBlank: false,
                                                            id: 'intCaminoCYD'
                                                        }
                                                    ]
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    xtype: 'panel',
                                    layout: 'table',
                                    anchor: '100%',
                                    height:370,
                                    padding: 7,
                                    layoutConfig: {
                                        columns: 3
                                    }, 
                                    items: [
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            padding: 7,
                                            height:400,
                                            title:'ANTECEDENTES ALIMENTARIOS',
                                            items:[
                                                {
                                                    xtype: 'fieldset',
                                                    layout: 'form',
                                                    collapsible: false,
                                                    titleCollapse:false,
                                                    width:230,
                                                    height:320,
                                                    padding: 5,
                                                    items:[
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: '1. Lactancia Materna',
                                                            name: 'Lactancia Materna',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strAntLacMaternaCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: '2. Otras Leches',
                                                            name: 'Otras Leches',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strAntOtrLechesCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: '3. Alimentacion Complementaria',
                                                            name: 'Alimentacion Complementaria',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strAntAliComplementariaCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 60,
                                                            name:'Edad Del Niño Al Destete',
                                                            fieldLabel: '4. Edad Del Niño Al Destete (Meses)',
                                                            allowBlank: false,
                                                            id: 'intAntEdaNinDesteteCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 60,
                                                            name:'Edad Del Niño Al Inicar Otras Leches ',
                                                            fieldLabel: '5. Edad Del Niño Al Inicar Otras Leches (Meses)',
                                                            allowBlank: false,
                                                            id: 'intAntEdaNinOtrLechesCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 60,
                                                            name:'Cuales Leches',
                                                            fieldLabel: '6. Cuales Leches',
                                                            allowBlank: false,
                                                            id: 'strAntCuaLechesCYD'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width: 60,
                                                            name:'Edad Del Niño Al Iniciar Alimentacion Complementaria',
                                                            fieldLabel: '7. Edad Del Niño Al Iniciar Alimentacion Complementaria (Meses)',
                                                            allowBlank: false,
                                                            id: 'intAntEdadNinIniComplementariaCYD'
                                                        }
                                                    ]
                                                }
                                            ]
                                        },
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            height:400,
                                            padding: 7,
                                            title:'ANTECEDENTES PATOLOGICOS',
                                            items:[
                                                {
                                                    xtype: 'fieldset',
                                                    layout: 'form',
                                                    collapsible: false,
                                                    titleCollapse:false,
                                                    width:230,
                                                    height:320,
                                                    padding: 5,
                                                    items:[
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'SARAMPION',
                                                            name: 'sarampion',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPaSarampionCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'DIPTERIA',
                                                            name: 'dipteria',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPaDipteriaCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'POLIO',
                                                            name: 'polio',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPaPolioCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'PAROTIDITIS',
                                                            name: 'Parotiditis',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPaParotiditisCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'DIARREA',
                                                            name: 'Diarrea',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPaDiarreaCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'DIARREA',
                                                            name: 'Diarrea',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPaDiarreaCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'ENFERMEDADES RESPIRATORIAS',
                                                            name: 'Enfermedades Respiratorias',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPaEnfRespiratoriasCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'SINDROMES CONVULSIVOS',
                                                            name: 'Sindromes Convulsivos',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPaSindConvulsivosCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'TRAUMATICOS',
                                                            name: 'Traumanticos',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPaTraumaticosCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'OTROS',
                                                            name: 'otros',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPaOtrosCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'ANTECEDENTES QUIRURGICOS',
                                                            name: 'Antecedentes Quirurgicos',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strPaAntQuirurgicosCYD'
                                                        }
                                                    ]
                                                }
                                            ] 
                                        },
                                        {
                                            xtype: 'panel',
                                            height:400,
                                            layout: 'form',
                                            items:[
                                                {
                                                    xtype: 'fieldset',
                                                    layout: 'table',
                                                    title:'OBSERVACIONES',
                                                    collapsible: false,
                                                    titleCollapse:false,
                                                    width:400,
                                                    height:340,
                                                    padding: 5,
                                                    items:[
                                                        {
                                                            xtype: 'textarea',
                                                            width: 370,
                                                            height:300,
                                                            id: 'memObservacionesCYD'
                                                        }
                                                    ]
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    xtype: 'panel',
                                    layout: 'table',
                                    anchor: '100%',
                                    height:275,
                                    padding: 7,
                                    layoutConfig: {
                                        columns: 3
                                    }, 
                                    items: [
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            height:270,
                                            padding: 7,
                                            title:'VALORACION POR CONDUCTA',
                                            items:[
                                                {
                                                    xtype: 'fieldset',
                                                    layout: 'form',
                                                    collapsible: false,
                                                    titleCollapse:false,
                                                    width:280,
                                                    height:220,
                                                    padding: 5,
                                                    items:[
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'Motora',
                                                            name: 'ConMotora',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strConMotoraCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'Adaptativa',
                                                            name: 'ConAdaptativa',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strConAdaptativaCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'Lenguaje',
                                                            name: 'ConLenguaje',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strConLenguajeCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'Persona Social',
                                                            name: 'ConPerSocial',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strConPerSocialCYD'
                                                        }
                                                    ]
                                                }
                                            ] 
                                        },
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            height:270,
                                            padding: 7,
                                            title:'VALORACION CRECIMIENTO',
                                            items:[
                                                {
                                                    xtype: 'fieldset',
                                                    layout: 'form',
                                                    collapsible: false,
                                                    titleCollapse:false,
                                                    width:280,
                                                    height:220,
                                                    padding: 5,
                                                    items:[
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'Curva Peso - Satisfactorio',
                                                            name: 'CreCurPesSatis',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strCreCurPesSatisCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'Curva Peso - No Satisfactorio',
                                                            name: 'CreNoCurPesSatis',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strCreNoCurPesSatisCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'Curva Talla - Satisfactorio',
                                                            name: 'ConCurTalSatis',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strConCurTalSatisCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'Curva Talla -No Satisfactorio',
                                                            name: 'ConNoCurTalSatis',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strConNoCurTalSatisCYD'
                                                        }
                                                    ]
                                                }
                                            ]
                                        },
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            height:270,
                                            padding: 7,
                                            title:'VALORACION NUTRICIONAL',
                                            items:[
                                                {
                                                    xtype: 'fieldset',
                                                    layout: 'form',
                                                    collapsible: false,
                                                    titleCollapse:false,
                                                    width:280,
                                                    height:220,
                                                    padding: 5,
                                                    items:[
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'Normal',
                                                            name: 'NutNormal',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strNutNormalCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'Exceso De Peso',
                                                            name: 'NutExcPeso',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strNutExcPesoCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'A Riesgo De Desnutricion',
                                                            name: 'NutRieDesnutricion',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strNutRieDesnutricionCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'Desnutricion Aguda',
                                                            name: 'NutDesAguda',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strNutDesAgudaCYD'
                                                        },
                                                        {
                                                            xtype: 'combo',
                                                            width: 60,
                                                            fieldLabel: 'XXXXXREPETIDA',
                                                            name: 'NutDesAguda',
                                                            allowBlank: false,
                                                            store: 'StoreSiNo',
                                                            valueField: 'Descripcion',
                                                            displayField: 'Descripcion',
                                                            mode: 'local',
                                                            forceSelection: true,
                                                            typeAhead: true,
                                                            typeAheadDelay: 10,
                                                            triggerAction: 'all',
                                                            value: "NO",
                                                            id: 'strNutDesAguda1CYD'
                                                        }
                                                    ]
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    xtype: 'fieldset',
                                    layout: 'table',
                                    title:'Observaciones',
                                    collapsible: false,
                                    titleCollapse:false,
                                    width:870,
                                    height:140,
                                    padding: 5,
                                    items:[
                                        {
                                            xtype: 'textarea',
                                            width: 840,
                                            height:100,
                                            id: 'memObservaciones1CYD'
                                        }
                                    ]
                                },
                                {
                                    xtype: 'panel',
                                    layout: 'form',
                                    title: '<center>EVALUACION DEL DESARROLLO</center>',
                                    collapsible: false,
                                    titleCollapse: false,
                                    anchor: '100%',
                                    autoHeight: true,
                                    items:[
                                        itemEscala1a3
                                    ]
                                }
                                
                            ]
                        }
                        ],
                        bbar:{
                            items: [
                            {
                                xtype: 'tbfill'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Salir',
                                iconCls: 'btnSalir',
                                id: 'btnSalirEvolucion',
                                listeners:{
                                    click : function(){
                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Esta seguro que desea cerrar la ventana?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn)
                                                {
                                                    if(btn=="yes")
                                                    {
                                                        if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                            Ext.getCmp('gridFormulario').store.reload();
                                                        }
                                                        Ext.getCmp('winHC').close();
                                                    }
                                                }
                                            });
                                        else{
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn)
                                                {
                                                    if(btn=="yes")
                                                    {
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                        Ext.getCmp('winHC').close();
                                                    }
                                                }
                                            });
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    tbar:{
                        items: [
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Ver Historia Clínica',
                                iconCls: 'btnVerHC',
                                id: 'btnVerHC',
                                listeners:{
                                    click : function(){
                                        var cmpResumenHC = new winFrmVerHistorialHC({
                                            renderTo: Ext.getBody()
                                        });
                                        Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                        Ext.getCmp('gridHistorialEvoluciones').store.load({
                                            params: {
                                                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                            }
                                        });
                                        cmpResumenHC.show();
                                    }
                                }
                            },
                            {
                                xtype: 'tbfill'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Guardar Evolución',
                                iconCls: 'btnGuardar',
                                id: 'btnGuardarEvolucion',
                                listeners:{
                                    click : function(){
                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                        {
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Esta seguro que desea guardar la evolución, si hace esto ya no podra realizar ningun cambio?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn)
                                                {
                                                    if(btn=="yes")
                                                    {
                                                        fnGuardarRegistros();
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'La evolución ya se guardo y no podra ser modificada nuevamente',
                                                buttons: Ext.Msg.OK,
                                                icon: Ext.Msg.ERROR
                                            });
                                        }
                                    }
                                }
                            }
                        ]
                    }
                }
                ]
            }
        ];
        winCrecimientoDesarrolloUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
