/*
* @category    Fieldset Antecedentes Personales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsAntecedentesPersonales2022Ui = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'ANTECEDENTES PERSONALES',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsAntecedentesPersonales',
    initComponent: function() {
        this.items = [
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Patologicos',
                name: 'Patologicos',
                allowBlank: false,
                id: 'memANTPERSOPatologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOPatologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Farmacologicos',
                name: 'Farmacologicos',
                allowBlank: false,
                id: 'memANTPERSOFarmacologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOFarmacologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Quirurgicos',
                name: 'Quirurgicos',
                allowBlank: false,
                id: 'memANTPERSOQuirurgicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOQuirurgicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Traumatologicos',
                name: 'Traumatologicos',
                allowBlank: false,
                id: 'memANTPERSOTraumatologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOTraumatologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Toxicologicos',
                name: 'Toxicologicos',
                allowBlank: false,
                id: 'memANTPERSOToxicologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOToxicologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Alergicos',
                name: 'Alergicos',
                allowBlank: false,
                id: 'memANTPERSOAlergicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOAlergicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Biopsicosociales',
                name: 'Biopsicosociales',
                allowBlank: false,
                id: 'memANTPERSOBiopsicosociales',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOBiopsicosociales').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'checkbox',
                fieldLabel: 'VIH',
                name: 'VIH',
                anchor: '100%',
                value: 'false',
                id: 'bolANTPERSOVIH'
            },
            {
                xtype: 'checkbox',
                fieldLabel: 'Cancer',
                name: 'Cancer',
                anchor: '100%',
                value: 'false',
                id: 'bolANTPERSOCancer'
            },
            {
                html: '<br>'
            },
            {
                xtype: 'fieldset',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelSeparator: '',
                id: 'fsMamografia',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Se a realizado la Mamografia en los dos ultimos años',
                                name: 'Se a realizado la Mamografia en los dos ultimos años',
                                width: 60,
                                allowBlank: false,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOMamografia',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue === "NO"){
                                            Ext.getCmp('fecANTGINECOMamografia').disable();
                                            Ext.getCmp('fecANTGINECOMamografia').clearInvalid();
                                            Ext.getCmp('fecANTGINECOMamografia').setValue(null);
                                            Ext.getCmp('fecANTGINECOMamografia').allowBlank = true;
                                            Ext.getCmp('strANTGINECOMamografiaRes').disable();
                                            Ext.getCmp('strANTGINECOMamografiaRes').clearInvalid();
                                            Ext.getCmp('strANTGINECOMamografiaRes').setValue(null);
                                            Ext.getCmp('strANTGINECOMamografiaRes').allowBlank = true;

                                            //Adicionar Solicitud de la mamografia
                                            if(parseInt(Ext.getCmp('sysSolicitaMamografia').getValue()) === 0){
                                                Ext.getCmp('sysSolicitaMamografia').setValue(1);
                                            }
                                        }else{  
                                            Ext.getCmp('fecANTGINECOMamografia').enable();
                                            Ext.getCmp('strANTGINECOMamografiaRes').enable();
                                            Ext.getCmp('fecANTGINECOMamografia').allowBlank = false;
                                            Ext.getCmp('strANTGINECOMamografiaRes').allowBlank = false;

                                            // Borrar Solicitud de la mamografia
                                            Ext.Ajax.request({
                                                url: '../../controlador/asistencial/evolucionhc2015.php',
                                                params:{
                                                    task: 'BORRAR_SERVICIOS_ANTECEDENTES',
                                                    pCodProced: "876802",
                                                    pCAS: Ext.getCmp('sysCASHC').getValue()
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); // get the LOG
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        //
                                                    } else {
                                                        Ext.getCmp('gridExamenesHC').store.reload();
                                                        Ext.getCmp('sysSolicitaMamografia').setValue(0);
                                                    }
                                                },
                                                failure: function(response,options){
                                                    //
                                                },
                                                scope:this
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                html: 'Fecha Ultima Mamografia:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Ultima Mamografia',
                                allowBlank: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOMamografia'
                            },
                            {
                                html: 'Resultado:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Resultado Mamografia',
                                width: 300,
                                allowBlank: true,
                                store: stResultadoMamografia,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOMamografiaRes'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'ANTECEDENTES GINECO-OBSTETRICOS',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelSeparator: '',
                autoHeight: true,
                id: 'fsANTGINECO',
                items: [
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                html: 'G'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'G',
                                fieldLabel: 'Embarazos',
                                emptyText: 'Gestaciones',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOG',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue <= 1 && Ext.getCmp('intANTGINECOP').getValue() === 0 && Ext.getCmp('intANTGINECOA').getValue() === 0){
                                            Ext.getCmp('fecANTGINECOFup').setValue(null);
                                            Ext.getCmp('fecANTGINECOFup').disable();
                                            Ext.getCmp('fecANTGINECOFup').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecANTGINECOFup').enable();
                                        }
                                        if(newValue === 0){
                                            Ext.getCmp('intANTGINECOP').disable();
                                            Ext.getCmp('intANTGINECOPV').disable();
                                            Ext.getCmp('intANTGINECOPC').disable();
                                            Ext.getCmp('intANTGINECOA').disable();
                                            Ext.getCmp('intANTGINECOVivos').disable();
                                            Ext.getCmp('intANTGINECOMuertos').disable();
                                            Ext.getCmp('intANTGINECOP').allowBlank = true;
                                            Ext.getCmp('intANTGINECOPV').allowBlank = true;
                                            Ext.getCmp('intANTGINECOPC').allowBlank = true;
                                            Ext.getCmp('intANTGINECOA').allowBlank = true;
                                            Ext.getCmp('intANTGINECOVivos').allowBlank = true;
                                            Ext.getCmp('intANTGINECOMuertos').allowBlank = true;
                                            Ext.getCmp('intANTGINECOP').clearInvalid();
                                            Ext.getCmp('intANTGINECOPV').clearInvalid();
                                            Ext.getCmp('intANTGINECOPC').clearInvalid();
                                            Ext.getCmp('intANTGINECOA').clearInvalid();
                                            Ext.getCmp('intANTGINECOVivos').clearInvalid();
                                            Ext.getCmp('intANTGINECOMuertos').clearInvalid();
                                        }else{
                                            Ext.getCmp('intANTGINECOP').enable();
                                            Ext.getCmp('intANTGINECOPV').enable();
                                            Ext.getCmp('intANTGINECOPC').enable();
                                            Ext.getCmp('intANTGINECOA').enable();
                                            Ext.getCmp('intANTGINECOVivos').enable();
                                            Ext.getCmp('intANTGINECOMuertos').enable();
                                            Ext.getCmp('intANTGINECOP').allowBlank = false;
                                            Ext.getCmp('intANTGINECOPV').allowBlank = false;
                                            Ext.getCmp('intANTGINECOPC').allowBlank = false;
                                            Ext.getCmp('intANTGINECOA').allowBlank = false;
                                            Ext.getCmp('intANTGINECOVivos').allowBlank = false;
                                            Ext.getCmp('intANTGINECOMuertos').allowBlank = false;
                                        }
                                    }
                                }
                            },
                            {
                                html: 'P'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'P',
                                emptyText: 'Partos',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOP',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue === 0 && Ext.getCmp('intANTGINECOG').getValue() <= 1 && Ext.getCmp('intANTGINECOA').getValue() === 0){
                                            Ext.getCmp('fecANTGINECOFup').setValue(null);
                                            Ext.getCmp('fecANTGINECOFup').disable();
                                            Ext.getCmp('fecANTGINECOFup').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecANTGINECOFup').enable();
                                        }
                                    }
                                }
                            },
                            {
                                html: 'P.V'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'PV',
                                emptyText: 'Vaginales',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOPV'
                            },
                            {
                                html: 'P.C'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'PC',
                                emptyText: 'Cesarea',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOPC'
                            },
                            {
                                html: 'A'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'A',
                                emptyText: 'Abortos',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOA',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue === 0 && Ext.getCmp('intANTGINECOG').getValue() <= 1 && Ext.getCmp('intANTGINECOP').getValue() === 0){
                                            Ext.getCmp('fecANTGINECOFup').setValue(null);
                                            Ext.getCmp('fecANTGINECOFup').disable();
                                            Ext.getCmp('fecANTGINECOFup').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecANTGINECOFup').enable();
                                        }
                                    }
                                }
                            },
                            {
                                html: 'Vivos'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'V',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOVivos'
                            },
                            {
                                html: 'Muertos'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'M',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOMuertos'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                html: 'Mola'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Mola',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTGINECOMola'
                            },
                            {
                                html: 'Embarazo Ectopico'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Embarazo Ectopico',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTGINECOEmbEctopico'
                            },
                            {
                                html: 'Preclampsia'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Preclampsia',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOPreclampsia'
                            },
                            {
                                html: 'Eclampsia'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Eclampsia',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOEclampsia'
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'datefield',
                        width: 120,
                        name: 'FUP',
                        fieldLabel: 'FUP',
                        allowBlank: true,
                        disabledDates: '',
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecANTGINECOFup'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Menarquia',
                                name: 'Menarquia',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOMenarquiaPreg',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue === "NO"){
                                            Ext.getCmp('fecANTGINECOFum').disable();
                                            Ext.getCmp('fecANTGINECOFum').clearInvalid();
                                            Ext.getCmp('fecANTGINECOFum').setValue(null);
                                            Ext.getCmp('strANTGINECOMenarquia').disable();
                                            Ext.getCmp('strANTGINECOMenarquia').clearInvalid();
                                            Ext.getCmp('strANTGINECOMenarquia').setValue(null);
                                        }else{  
                                            Ext.getCmp('fecANTGINECOFum').enable();
                                            Ext.getCmp('strANTGINECOMenarquia').enable();
                                        }
                                    }
                                }
                            },
                            {
                                html: '-'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Menarquia Descripcion',
                                width: 370,
                                allowBlank: true,
                                id: 'strANTGINECOMenarquia'
                            },
                            {
                                html: 'FUM'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'FUM',
                                allowBlank: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOFum'
                            }
                        ]
                    },
                    {
                        html: '<br><hr><br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Se a realizado la Citologia en el ultimo año',
                                name: 'Se a realizado la Citologia en el ultimo año',
                                width: 60,
                                allowBlank: false,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOFuc',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue === "NO"){
                                            Ext.getCmp('fecANTGINECOFuc').disable();
                                            Ext.getCmp('fecANTGINECOFuc').clearInvalid();
                                            Ext.getCmp('fecANTGINECOFuc').setValue(null);
                                            Ext.getCmp('fecANTGINECOFuc').allowBlank = true;
                                            Ext.getCmp('strANTGINECOFucRes').disable();
                                            Ext.getCmp('strANTGINECOFucRes').clearInvalid();
                                            Ext.getCmp('strANTGINECOFucRes').setValue(null);
                                            Ext.getCmp('strANTGINECOFucRes').allowBlank = true;
                                            
                                            if(parseInt(Ext.getCmp('sysSolicitaCitologia').getValue()) === 0){
                                                Ext.getCmp('sysSolicitaCitologia').setValue(1);
                                            }
                                        }else{  
                                            Ext.getCmp('fecANTGINECOFuc').enable();
                                            Ext.getCmp('strANTGINECOFucRes').enable();
                                            Ext.getCmp('fecANTGINECOFuc').allowBlank = false;
                                            Ext.getCmp('strANTGINECOFucRes').allowBlank = false;
                                            // Borrar Solicitud de la Citologia
                                            Ext.Ajax.request({
                                                url: '../../controlador/asistencial/evolucionhc2015.php',
                                                params:{
                                                    task: 'BORRAR_SERVICIOS_ANTECEDENTES',
                                                    pCodProced: "892901",
                                                    pCAS: Ext.getCmp('sysCASHC').getValue()
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); // get the LOG
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        //
                                                    } else {
                                                        Ext.getCmp('gridExamenesHC').store.reload();
                                                        Ext.getCmp('sysSolicitaCitologia').setValue(0);
                                                    }
                                                },
                                                failure: function(response,options){
                                                    //
                                                },
                                                scope:this
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                html: 'Fecha Ultima Citologia:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Ultima Citologia',
                                allowBlank: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOFuc'
                            },
                            {
                                html: 'Resultado:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Resultado',
                                width: 150,
                                allowBlank: true,
                                store: stResultadoCitologia,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOFucRes'
                            }
                        ]
                    },
                    {
                        html: '<br><hr><br>'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Metodo Planificacion',
                        name: 'Metodo Planificacion',
                        anchor: '100%',
                        allowBlank: true,
                        store: stSuministroMetodoPlanificacion,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        value: "REGISTRO NO EVALUADO",
                        id: 'strANTGINECOMetodoPlanifica'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Actividad Sexual',
                                name: 'Actividad Sexual',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOActividadSexual'
                            },
                            {
                                html: 'Edad - Inicio: '
                            },
                            {
                                xtype: 'textfield',
                                width: 40,
                                name: 'Edad Inicio Actividad Sexual',
                                allowBlank: true,
                                id: 'strANTGINECOInicioActividadSexual'
                            },
                            {
                                html: 'Compañeros: '
                            },
                            {
                                xtype: 'textfield',
                                width: 40,
                                name: 'Numero Compañeros Sexuales',
                                allowBlank: true,
                                id: 'strANTGINECONroCompanerosSexual'
                            },
                            {
                                html: 'ETS: '
                            },
                            {
                                xtype: 'textfield',
                                width: 400,
                                name: 'ETS',
                                allowBlank: true,
                                id: 'strANTGINECOETS'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Patologias Relacionadas Emb.',
                        name: 'Patologias Relacionadas Emb.',
                        allowBlank: true,
                        id: 'strANTGINECOPatologiaEmbarazo',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strANTGINECOPatologiaEmbarazo').setValue("Negativo");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Menopausia',
                        name: 'Menopausia',
                        allowBlank: true,
                        id: 'strANTGINECOMenopausia',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strANTGINECOMenopausia').setValue("Negativo");
                                });
                            }
                        }
                    }
                ]
            }
        ];
        fsAntecedentesPersonales2022Ui.superclass.initComponent.call(this);
    }
});