/*
* @category    Fieldset Neonatal
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsRES202Neonatal2022Ui = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: '** RECIEN NACIDO **',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    labelWidth: 150,
    titleCollapse: true,
    padding: 0,
    id: 'fsRES202Neonatal',
    initComponent: function() {
        
        var dataRES202NeonatalTamizajeAuditivo = [
            ['0','0 - No aplica'],
            ['4','4 - No paso'],
            ['5','5 - Paso'],
            ['21','21 - Riesgo no evaluado']
        ];
        var stRES202NeonatalTamizajeAuditivo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stRES202NeonatalTamizajeAuditivo.loadData(dataRES202NeonatalTamizajeAuditivo);
        
        var dataRES202NeonatalTamizajeVisual = [
            ['0','0 - No aplica'],
            ['4','4 - Alterado'],
            ['5','5 - Normal'],
            ['21','21 - Riesgo no evaluado']
        ];
        var stRES202NeonatalTamizajeVisual = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stRES202NeonatalTamizajeVisual.loadData(dataRES202NeonatalTamizajeVisual);
        
        var dataRES202NeonatalAyuda = [
            ['No se tiene el dato'],
            ['No se realiza por una tradición'],
            ['No se realiza por una condición de salud registrar'],
            ['No se realiza por una negación del usuario'],
            ['No se realiza por otras razones']
        ];
        var stRES202NeonatalAyuda = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRES202NeonatalAyuda.loadData(dataRES202NeonatalAyuda);
        

        this.items = [
            {
                xtype: 'fieldset',
                title: 'Tamizaje Auditivo',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                items: [
                    {
                        xtype: 'hidden',
                        fieldLabel: 'Fecha Tamizaje Auditivo',
                        allowBlank: true,
                        id: 'sysNeonatalTamizaAuditivoFec'
                    },
                    {
                        xtype: 'hidden',
                        fieldLabel: 'Resultado Tamizaje Auditivo',
                        allowBlank: true,
                        id: 'sysNeonatalTamizaAuditivoRes'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'No se Realiza',
                        name: 'RECIEN NACIDO - TAMIZAJE AUDITIVO - NO SE REALIZA',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202NeonatalAyuda,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strNeonatalTamizajeAuditivoNoSeRealiza',
                        listeners: {
                            change: function( t, newValue, oldValue ){
                                if(newValue === "" || newValue === null){
                                    Ext.getCmp('fecNeonatalTamizajeAuditivo69').setValue(null);
                                    Ext.getCmp('strNeonatalTamizajeAuditivo37').setValue(null);
                                }else{
                                    if(newValue === "No se tiene el dato"){
                                        Ext.getCmp('fecNeonatalTamizajeAuditivo69').setValue("01/01/1800");
                                        Ext.getCmp('strNeonatalTamizajeAuditivo37').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una tradición"){
                                        Ext.getCmp('fecNeonatalTamizajeAuditivo69').setValue("01/01/1805");
                                        Ext.getCmp('strNeonatalTamizajeAuditivo37').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una condición de salud registrar"){
                                        Ext.getCmp('fecNeonatalTamizajeAuditivo69').setValue("01/01/1810");
                                        Ext.getCmp('strNeonatalTamizajeAuditivo37').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una negación del usuario"){
                                        Ext.getCmp('fecNeonatalTamizajeAuditivo69').setValue("01/01/1825");
                                        Ext.getCmp('strNeonatalTamizajeAuditivo37').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por otras razones"){
                                        Ext.getCmp('fecNeonatalTamizajeAuditivo69').setValue("01/01/1835");
                                        Ext.getCmp('strNeonatalTamizajeAuditivo37').setValue("21 - Riesgo no evaluado");
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'datefield',
                        fieldLabel: 'Fecha Valoracion',
                        name: 'RECIEN NACIDO - TAMIZAJE AUDITIVO - FECHA VALORACION',
                        width: 110,
                        allowBlank: true,
                        //value: new Date().format('d/m/Y'),
                        disabledDates: '',
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecNeonatalTamizajeAuditivo69'
                    },
                    
                    {
                        xtype: 'combo',
                        fieldLabel: 'Resultado',
                        name: 'RECIEN NACIDO - TAMIZAJE AUDITIVO - RESULTADO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202NeonatalTamizajeAuditivo,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strNeonatalTamizajeAuditivo37'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'Tamizaje Visual',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                items: [
                    {
                        xtype: 'hidden',
                        fieldLabel: 'Fecha Tamizaje Visual',
                        allowBlank: true,
                        id: 'sysNeonatalTamizaVisualFec'
                    },
                    {
                        xtype: 'hidden',
                        fieldLabel: 'Resultado Tamizaje Visual',
                        allowBlank: true,
                        id: 'sysNeonatalTamizaVisualRes'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'No se Realiza',
                        name: 'RECIEN NACIDO - TAMIZAJE VISUAL - NO SE REALIZA',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202NeonatalAyuda,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strNeonatalTamizajeVisualNoSeRealiza',
                        listeners: {
                            change: function( t, newValue, oldValue ){
                                if(newValue === "" || newValue === null){
                                    Ext.getCmp('fecNeonatalTamizajeAuditivo69').setValue(null);
                                    Ext.getCmp('strNeonatalTamizajeAuditivo37').setValue(null);
                                }else{
                                    if(newValue === "No se tiene el dato"){
                                        Ext.getCmp('fecNeonatalTamizajeVisual75').setValue("01/01/1800");
                                        Ext.getCmp('strNeonatalTamizajeVisual38').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una tradición"){
                                        Ext.getCmp('fecNeonatalTamizajeVisual75').setValue("01/01/1805");
                                        Ext.getCmp('strNeonatalTamizajeVisual38').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una condición de salud registrar"){
                                        Ext.getCmp('fecNeonatalTamizajeVisual75').setValue("01/01/1810");
                                        Ext.getCmp('strNeonatalTamizajeVisual38').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una negación del usuario"){
                                        Ext.getCmp('fecNeonatalTamizajeVisual75').setValue("01/01/1825");
                                        Ext.getCmp('strNeonatalTamizajeVisual38').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por otras razones"){
                                        Ext.getCmp('fecNeonatalTamizajeVisual75').setValue("01/01/1835");
                                        Ext.getCmp('strNeonatalTamizajeVisual38').setValue("21 - Riesgo no evaluado");
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'datefield',
                        fieldLabel: 'Fecha Valoracion',
                        name: 'RECIEN NACIDO - TAMIZAJE VISUAL - FECHA VALORACION',
                        width: 110,
                        allowBlank: true,
                        //value: new Date().format('d/m/Y'),
                        disabledDates: '',
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecNeonatalTamizajeVisual75'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Resultado',
                        name: 'RECIEN NACIDO - TAMIZAJE VISUAL - RESULTADO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202NeonatalTamizajeVisual,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strNeonatalTamizajeVisual38'
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    /*var MyDate = new Date();
                    MyDate.setDate(MyDate.getDate() - 360);
                    Ext.getCmp('fecNeonatalValoracion').setMinValue(MyDate.format("d/m/Y"));
                    Ext.getCmp('fecNeonatalValoracion').setMaxValue(new Date().format("d/m/Y"));*/
                }
            }
        });
        fsRES202Neonatal2022Ui.superclass.initComponent.call(this);
    }
});
