/*
* @category    Fieldset PrimeraInfancia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsRES202PrimeraInfancia2022Ui = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: '** PRIMERA INFANCIA **',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    labelWidth: 150,
    titleCollapse: true,
    padding: 0,
    id: 'fsRES202PrimeraInfancia',
    initComponent: function() {
        //const myTimeout = setTimeout(obtainMG, 10000);
        this.items = [
            {
                html: '<br>'
            },
            {
                xtype: 'numberfield',
                width: 60,
                minValue: 0,
                decimalPrecision: 2,
                fieldLabel: 'Perimetro Cefalico',
                name: 'PRIMERA INFANCIA - PERIMETRO CEFALICO',
                allowBlank: true,
                id: 'strPrimeraInfanciaPC'
            },
            {
                xtype: 'numberfield',
                width: 60,
                minValue: 0,
                decimalPrecision: 2,
                fieldLabel: 'Perimetro Toracico',
                name: 'PRIMERA INFANCIA - PERIMETRO TORACICO',
                allowBlank: true,
                id: 'strPrimeraInfanciaPT'
            },
            {
                xtype: 'fieldset',
                title: 'VALE',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsPrimeraInfanciaVale',
                tbar: [
                    {
                        xtype: 'button',
                        text: 'VALE',
                        iconCls: 'btnEvolucionar1',
                        listeners:{
                            click : function(){
                                //alert("Error al tratar de abrir la ruta '../../../rias/anexos/vale.js'");
                                //window.open ('http://localhost:3000/vale?cas=' + wCAS,"VALE");
                            }
                        }
                    },
                    {
                        xtype: 'tbseparator'
                    }
                ],
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'No se Realiza',
                        name: 'PRIMERA INFANCIA - VALE - NO SE REALIZA',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202NoRealiza,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strPrimeraInfanciaValeNoSeRealiza',
                        listeners: {
                            change: function( t, newValue, oldValue ){
                                if(newValue === "" || newValue === null){
                                    Ext.getCmp('fecPrimeraInfanciaVale63').setValue(null);
                                    Ext.getCmp('strPrimeraInfanciaVale40').setValue(null);
                                }else{
                                    if(newValue === "No se tiene el dato"){
                                        Ext.getCmp('fecPrimeraInfanciaVale63').setValue("01/01/1800");
                                        Ext.getCmp('strPrimeraInfanciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una tradición"){
                                        Ext.getCmp('fecPrimeraInfanciaVale63').setValue("01/01/1805");
                                        Ext.getCmp('strPrimeraInfanciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una condición de salud registrar"){
                                        Ext.getCmp('fecPrimeraInfanciaVale63').setValue("01/01/1810");
                                        Ext.getCmp('strPrimeraInfanciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una negación del usuario"){
                                        Ext.getCmp('fecPrimeraInfanciaVale63').setValue("01/01/1825");
                                        Ext.getCmp('strPrimeraInfanciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por otras razones"){
                                        Ext.getCmp('fecPrimeraInfanciaVale63').setValue("01/01/1835");
                                        Ext.getCmp('strPrimeraInfanciaVale40').setValue("21 - Riesgo no evaluado");
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'datefield',
                        fieldLabel: 'Fecha Valoracion',
                        name: 'PRIMERA INFANCIA - VALE - FECHA VALORACION',
                        width: 110,
                        allowBlank: true,
                        //value: new Date().format('d/m/Y'),
                        disabledDates: '',
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecPrimeraInfanciaVale63',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strPrimeraInfanciaValeNoSeRealiza').setValue(null);
                                    Ext.getCmp('fecPrimeraInfanciaVale63').setValue(localStorage.getItem('fecVALE'));
                                    Ext.getCmp('strPrimeraInfanciaVale40').setValue(localStorage.getItem('resVALE'));
                                });
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Resultado',
                        name: 'PRIMERA INFANCIA - VALE - RESULTADO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202VALE,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strPrimeraInfanciaVale40',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strPrimeraInfanciaValeNoSeRealiza').setValue(null);
                                    Ext.getCmp('fecPrimeraInfanciaVale63').setValue(localStorage.getItem('fecVALE'));
                                    Ext.getCmp('strPrimeraInfanciaVale40').setValue(localStorage.getItem('resVALE'));
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Observaciones',
                        name: 'PRIMERA INFANCIA - VALE - OBSERVACIONES',
                        anchor: '100%',
                        allowBlank: true,
                        id: 'memPrimeraInfanciaVale'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'EAD-3',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsPrimeraInfanciaEAD',
                tbar: [
                    {
                        xtype: 'button',
                        text: 'VALE',
                        iconCls: 'btnEvolucionar1',
                        listeners:{
                            click : function(){
                                //alert("Error al tratar de abrir la ruta '../../../rias/anexos/vale.js'");
                                //window.open ('http://localhost:3000/vale?cas=' + wCAS,"VALE");
                            }
                        }
                    },
                    {
                        xtype: 'tbseparator'
                    },
                    '->',
                    {
                        xtype: 'button',
                        text: 'Actualizar Resultados',
                        iconCls: 'btnActualizarGrid',
                        listeners:{
                            click : function(){
                                Ext.getCmp('strPrimeraInfanciaEAD43').setValue('5 -Desarrollo esperado para la edad');
                                Ext.getCmp('strPrimeraInfanciaEAD44').setValue('4 -Riesgo de problemas de desarrollo');
                                Ext.getCmp('strPrimeraInfanciaEAD45').setValue('3 -Sospecha de problemas de desarrollo');
                                Ext.getCmp('strPrimeraInfanciaEAD46').setValue('5 -Desarrollo esperado para la edad');
                            }
                        }
                    }
                ],
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Motricidad Gruesa',
                        name: 'PRIMERA INFANCIA - EAD3 - MOTRICIDAD GRUESA',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202EAD3,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        value: '21 - Riesgo no evaluado',
                        id: 'strPrimeraInfanciaEAD43',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strPrimeraInfanciaEAD43').setValue(localStorage.getItem('resEADMotricidadGruesa'));
                                    Ext.getCmp('strPrimeraInfanciaEAD44').setValue(localStorage.getItem('resEADMotricidadFina'));
                                    Ext.getCmp('strPrimeraInfanciaEAD45').setValue(localStorage.getItem('resEADPersonalSocial'));
                                    Ext.getCmp('strPrimeraInfanciaEAD46').setValue(localStorage.getItem('resEADPersonalLenguaje'));
                                });
                            },
                            select : function(cmb, rec, idx){
                                //alert(Ext.getCmp('strPrimeraInfanciaEAD43').getValue());
                                if(Ext.getCmp('strPrimeraInfanciaEAD43').getValue() === "21 - Riesgo no evaluado"){
                                    Ext.getCmp('strPrimeraInfanciaEAD43').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD44').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD45').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD46').setValue('21 - Riesgo no evaluado');
                                }
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Motricidad Finoadaptativa',
                        name: 'PRIMERA INFANCIA - EAD3 - MOTRICIDAD FINO-ADAPTATIVA',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202EAD3,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        value: '21 - Riesgo no evaluado',
                        id: 'strPrimeraInfanciaEAD44',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strPrimeraInfanciaEAD43').setValue(localStorage.getItem('resEADMotricidadGruesa'));
                                    Ext.getCmp('strPrimeraInfanciaEAD44').setValue(localStorage.getItem('resEADMotricidadFina'));
                                    Ext.getCmp('strPrimeraInfanciaEAD45').setValue(localStorage.getItem('resEADPersonalSocial'));
                                    Ext.getCmp('strPrimeraInfanciaEAD46').setValue(localStorage.getItem('resEADPersonalLenguaje'));
                                });
                            },
                            select : function(cmb, rec, idx){
                                if(Ext.getCmp('strPrimeraInfanciaEAD44').getValue() === "21 - Riesgo no evaluado"){
                                    Ext.getCmp('strPrimeraInfanciaEAD43').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD44').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD45').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD46').setValue('21 - Riesgo no evaluado');
                                }
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Personal Social',
                        name: 'PRIMERA INFANCIA - EAD3 - PERSONAL SOCIAL',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202EAD3,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        value: '21 - Riesgo no evaluado',
                        id: 'strPrimeraInfanciaEAD45',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strPrimeraInfanciaEAD43').setValue(localStorage.getItem('resEADMotricidadGruesa'));
                                    Ext.getCmp('strPrimeraInfanciaEAD44').setValue(localStorage.getItem('resEADMotricidadFina'));
                                    Ext.getCmp('strPrimeraInfanciaEAD45').setValue(localStorage.getItem('resEADPersonalSocial'));
                                    Ext.getCmp('strPrimeraInfanciaEAD46').setValue(localStorage.getItem('resEADPersonalLenguaje'));
                                });
                            },
                            select : function(cmb, rec, idx){
                                if(Ext.getCmp('strPrimeraInfanciaEAD45').getValue() === "21 - Riesgo no evaluado"){
                                    Ext.getCmp('strPrimeraInfanciaEAD43').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD44').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD45').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD46').setValue('21 - Riesgo no evaluado');
                                }
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Audicion Lenguaje',
                        name: 'PRIMERA INFANCIA - EAD3 - AUDICION LENGUAJE',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202EAD3,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        value: '21 - Riesgo no evaluado',
                        id: 'strPrimeraInfanciaEAD46',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strPrimeraInfanciaEAD43').setValue(localStorage.getItem('resEADMotricidadGruesa'));
                                    Ext.getCmp('strPrimeraInfanciaEAD44').setValue(localStorage.getItem('resEADMotricidadFina'));
                                    Ext.getCmp('strPrimeraInfanciaEAD45').setValue(localStorage.getItem('resEADPersonalSocial'));
                                    Ext.getCmp('strPrimeraInfanciaEAD46').setValue(localStorage.getItem('resEADPersonalLenguaje'));
                                });
                            },
                            select : function(cmb, rec, idx){
                                if(Ext.getCmp('strPrimeraInfanciaEAD46').getValue() === "21 - Riesgo no evaluado"){
                                    Ext.getCmp('strPrimeraInfanciaEAD43').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD44').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD45').setValue('21 - Riesgo no evaluado');
                                    Ext.getCmp('strPrimeraInfanciaEAD46').setValue('21 - Riesgo no evaluado');
                                }
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Observaciones',
                        name: 'PRIMERA INFANCIA - EAD3 - OBSERVACIONES',
                        anchor: '100%',
                        allowBlank: true,
                        id: 'memPrimeraInfanciaEAD3'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PREGUNTAR SI SE SUMINISTRAN MICRO-NUTRIENTES',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsPIMicronutrientes',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Fortificacion casera',
                        name: 'PRIMERA INFANCIA - FORTIFICACION CASERA - SUMINISTRO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202Suministro,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        value: '21 - Riesgo no evaluado',
                        id: 'strPrimeraInfanciaFortificacionCasera70'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Vitamina A',
                        name: 'PRIMERA INFANCIA - VITAMINA A - SUMINISTRO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202Suministro,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        value: '21 - Riesgo no evaluado',
                        id: 'strPrimeraInfanciaVitaminaA71'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Hierro',
                        name: 'PRIMERA INFANCIA - HIERRO - SUMINISTRO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202Suministro,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        value: '21 - Riesgo no evaluado',
                        id: 'strPrimeraInfanciaHierro77'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'TEST MCHAT',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Test MChat',
                        name: 'PRIMERA INFANCIA - TEST MCHAT',
                        width: 830,
                        allowBlank: true,
                        id: 'memPrimeraInfanciaTestMChat'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'FAMILIOGRAMA',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Familiograma',
                        name: 'PRIMERA INFANCIA - FAMILIOGRAMA',
                        width: 830,
                        allowBlank: true,
                        id: 'memPrimeraInfanciaFamiliograma'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'ECOMAPA',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Ecomapa',
                        name: 'PRIMERA INFANCIA - ECOMAPA',
                        width: 830,
                        allowBlank: true,
                        id: 'memPrimeraInfanciaEcomapa'
                    }
                ]
            },
            {
                xtype: 'textarea',
                fieldLabel: 'Observaciones',
                name: 'PRIMERA INFANCIA - OBSERVACIONES',
                anchor: '100%',
                allowBlank: true,
                id: 'memPrimeraInfanciaObservaciones'
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    /*var MyDate = new Date();
                    MyDate.setDate(MyDate.getDate() - 360);
                    Ext.getCmp('fecPrimeraInfanciaValoracion').setMinValue(MyDate.format("d/m/Y"));
                    Ext.getCmp('fecPrimeraInfanciaValoracion').setMaxValue(new Date().format("d/m/Y"));*/
                }
            }
        });
        fsRES202PrimeraInfancia2022Ui.superclass.initComponent.call(this);
    }
});
