/*
* @category    Verificador de Datos Basicos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

VerificarDatosBasicosPaciente001Ui = Ext.extend(Ext.Window, {
    title: '.:: Verificación Datos Basicos ::.',
    id: 'winFrmDatosBasicos',
    width: 990,
    autoHeight: true,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    initComponent: function() {
        searchStoreOcupacion202 = new Ext.data.Store({
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/res202/controlador_ocupacion.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, 
            [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ])
        });
        
        this.items = [
            {
                xtype: 'hidden',
                allowBlank: true,
                id: 'sysCASDatosBasicos'
            },
            {
                xtype: 'hidden',
                allowBlank: true,
                id: 'sysPacienteDatosBasicos'
            },
            {
                xtype: 'hidden',
                fieldLabel: 'Plantilla',
                //xtype: 'hidden',
                allowBlank: true,
                id: 'sysIdPlantillaHCDatosBasicos'
            },
            {
                xtype: 'hidden',
                fieldLabel: 'Profesional',
                allowBlank: true,
                id: 'sysProfesionalDatosBasicos'
            },
            {
                xtype: 'hidden',
                fieldLabel: 'Especialidad',
                allowBlank: true,
                //value: 'MEDICINA',
                id: 'sysEspecialidadRIAS'
            },
            {
                xtype: 'hidden',
                allowBlank: true,
                id: 'sysHoyDatosBasicos'
            },
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                padding: 5,
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                id: 'frmPacienteVerificaDatosBasicos',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Genero',
                        anchor: '100%',
                        allowBlank: false,
                        store: 'StoreGenero',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        emptyText: 'Seleccione Genero....',
                        forceSelection: true,
                        id: 'sysGeneroDatosBasicos'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        items: [
                            {
                                xtype: 'datefield',
                                fieldLabel: 'Fecha Nacimiento',
                                width: 110,
                                name: 'txtFecNac',
                                allowBlank: false,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'sysFecNacDatosBasicos',
                                listeners: {
                                    change: function( t, newValue, oldValue ){
                                        if(newValue === "" || newValue === null){
                                            Ext.getCmp('sysFecNacDatosBasicos').setValue(oldValue);
                                        }else{
                                            Ext.getCmp('sysEdadDatosBasicos').setValue(CalcularEdad2022(Ext.getCmp('sysHoyDatosBasicos').getValue(), Ext.getCmp('sysFecNacDatosBasicos').getValue().format("Y/m/d"),"F"));
                                            localStorage.setItem('Anios',-1);
                                            localStorage.setItem('Anios',CalcularEdad2022(Ext.getCmp('sysHoyDatosBasicos').getValue(), Ext.getCmp('sysFecNacDatosBasicos').getValue().format("Y/m/d"),"A"));
                                            localStorage.setItem('Meses',-1);
                                            localStorage.setItem('Meses',CalcularEdad2022(Ext.getCmp('sysHoyDatosBasicos').getValue(), Ext.getCmp('sysFecNacDatosBasicos').getValue().format("Y/m/d"),"M"));
                                            localStorage.setItem('Dias',-1);
                                            localStorage.setItem('Dias',CalcularEdad2022(Ext.getCmp('sysHoyDatosBasicos').getValue(), Ext.getCmp('sysFecNacDatosBasicos').getValue().format("Y/m/d"),"D"));
                                        }
                                    }
                                }
                            },
                            {
                                html: ' - Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 500,
                                allowBlank: true,
                                readOnly: true,
                                emptyText: 'edad (años, messe, dias)',
                                id: 'sysEdadDatosBasicos'
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Pais',
                        anchor: '100%',
                        allowBlank: false,
                        store: stPais4505,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        emptyText: 'Seleccione Pais....',
                        forceSelection: true,
                        id: 'sysPaisDatosBasicos'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Etnia',
                        anchor: '100%',
                        allowBlank: false,
                        store: stEtnia4505,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        emptyText: 'Seleccione Etnia....',
                        forceSelection: true,
                        id: 'sysEtniaDatosBasicos'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Escolaridad',
                        anchor: '100%',
                        allowBlank: false,
                        store: stEscolaridad4505,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        emptyText: 'Seleccione Escolaridad....',
                        forceSelection: true,
                        id: 'sysEscolaridadDatosBasicos'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysCodigoOcupacionDatosBasicos',
                        allowBlank: true
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Ocupacion',
                                store: searchStoreOcupacion202,
                                displayField: 'Descripcion',
                                typeAhead: false,
                                loadingText: 'Buscando...',
                                width: 250,
                                listWidth: 740,
                                hideTrigger: true,
                                minChars: 4,
                                emptyText:'Buscar ocupacion, min 4 letras',
                                id: 'sysSearchOcupacion',
                                onSelect: function(record){ // override default onSelect to do redirect
                                    Ext.getCmp('sysCodigoOcupacionDatosBasicos').setValue(null);
                                    Ext.getCmp('sysCodigoOcupacionDatosBasicos').setValue(record.data.Codigo);
                                    Ext.getCmp('sysOcupacionDatosBasicos').setValue(null);
                                    Ext.getCmp('sysOcupacionDatosBasicos').setValue(record.data.Descripcion);
                                    Ext.getCmp('sysSearchOcupacion').clearValue();
                                    Ext.getCmp('sysSearchOcupacion').collapse();
                                },
                                listeners: {
                                    render: function( p ) {
                                        p.getEl().on('dblclick', function (){
                                            if(Ext.getCmp('sysCodigoOcupacionDatosBasicos').getValue() === "9998"){
                                                Ext.getCmp('sysCodigoOcupacionDatosBasicos').setValue("9999");
                                                Ext.getCmp('sysOcupacionDatosBasicos').setValue("9999 - EN LOS CASOS EN QUE NO SE TIENE ESTA INFORMACION REGISTRAR");
                                            }else{
                                                Ext.getCmp('sysCodigoOcupacionDatosBasicos').setValue("9998");
                                                Ext.getCmp('sysOcupacionDatosBasicos').setValue("9998 - JUBILADO, DESEMPLEADO, AMA DE CASA, ESTUDIANTE, DEDICACION AL HOGAR, MENOR DE EDAD");
                                            }
                                        });
                                    }
                                }
                            },
                            {
                                xtype: 'textfield',
                                id: 'sysOcupacionDatosBasicos',
                                width: 590,
                                emptyText:'Ocupacion del paciente',
                                readOnly: true,
                                allowBlank: false
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        fieldLabel: 'Direccion',
                        anchor: '100%',
                        allowBlank: false,
                        mode: 'local',
                        emptyText: 'Direccion del Paciente',
                        id: 'sysDireccionDatosBasicos'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        labelWidth: 150,
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Teléfono Contacto',
                                width: 160,
                                emptyText:'Telefono contacto del paciente',
                                allowBlank: false,
                                minLength: 10, 
                                maxLength: 10, 
                                id: 'sysTelefonoDatosBasicos'
                            },
                            {
                                html: 'Email:'
                            },
                            {
                                xtype: 'textfield',
                                vtype: 'email',
                                width: 270,
                                emptyText:'Correo Electronico de contacto del paciente',
                                allowBlank: false,
                                id: 'sysEmailDatosBasicos',
                                listeners: {
                                    render: function( p ) {
                                        p.getEl().on('dblclick', function (){
                                            Ext.getCmp('sysEmailDatosBasicos').setValue("sincorreo@na.com");
                                        });
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'toolbar',
                        items: [
                            '->',
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Guardar Datos Basicos',
                                iconCls: 'btnAceptar',
                                tooltip: 'Guardar Datos Basicos',
                                //disabled: true, 
                                id: 'btnGuardarDBHC',
                                listeners: {
                                    click: function(){
                                        fnGardarVerificarDatosBasicosPaciente();
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Ajax.request({
                        url: '../../controlador/asistencial/controlador_2022.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pProfesional: Ext.getCmp('sysProfesionalDatosBasicos').getValue(),
                            task: 'VerificarEspecialidadProfesional'
                        },
                        success: function(result, request){
                            var jsonData = Ext.util.JSON.decode(result.responseText);
                            Ext.getCmp('sysEspecialidadRIAS').setValue(jsonData.data.EspecialidadRes202);
                        },
                        scope:this
                    });
                    Ext.Ajax.request({
                        url: '../../controlador/asistencial/controlador_2022.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pPaciente: wPaciente,
                            task: 'VerificarDatosBasicosLoad'
                        },
                        success: function(result, request){
                            var jsonData = Ext.util.JSON.decode(result.responseText);
                            Ext.getCmp('sysGeneroDatosBasicos').setValue(jsonData.data.Genero);
                            Ext.getCmp('sysFecNacDatosBasicos').setValue(jsonData.data.FecNac);
                            Ext.getCmp('sysEtniaDatosBasicos').setValue(jsonData.data.res202_etnia);
                            Ext.getCmp('sysEscolaridadDatosBasicos').setValue(jsonData.data.res202_niveleducativo);
                            if(jsonData.data.TipDoc === "RC" || jsonData.data.TipDoc === "TI" || jsonData.data.TipDoc === "CC" || jsonData.data.TipDoc === "AS" || jsonData.data.TipDoc === "MS" || jsonData.data.TipDoc === "CN"){
                                Ext.getCmp('sysPaisDatosBasicos').setValue(170);
                            }else{
                                Ext.getCmp('sysPaisDatosBasicos').setValue(jsonData.data.res202_pais);
                            }
                            Ext.getCmp('sysHoyDatosBasicos').setValue(jsonData.data.Hoy);
                            Ext.getCmp('sysEdadDatosBasicos').setValue(CalcularEdad2022(jsonData.data.Hoy, jsonData.data.FecNac1,"F"));
                            localStorage.setItem('Anios',-1);
                            localStorage.setItem('Anios',CalcularEdad2022(jsonData.data.Hoy, jsonData.data.FecNac1,"A"));
                            localStorage.setItem('Meses',-1);
                            localStorage.setItem('Meses',CalcularEdad2022(jsonData.data.Hoy, jsonData.data.FecNac1,"M"));
                            localStorage.setItem('Dias',-1);
                            localStorage.setItem('Dias',CalcularEdad2022(jsonData.data.Hoy, jsonData.data.FecNac1,"D"));
                            
                            Ext.getCmp('sysCodigoOcupacionDatosBasicos').setValue(jsonData.data.res202_ocupacion);
                            Ext.getCmp('sysOcupacionDatosBasicos').setValue(jsonData.data.Ocupacion);
                            Ext.getCmp('sysDireccionDatosBasicos').setValue(jsonData.data.Direccion);
                            Ext.getCmp('sysTelefonoDatosBasicos').setValue(jsonData.data.Telefono1);
                            Ext.getCmp('sysEmailDatosBasicos').setValue(jsonData.data.Email);
                            
                            try {
                                var campoX = Ext.getCmp('sysres202_ControlAgudezaVisual');
                                if ( campoX !== null ) {
                                    Ext.getCmp('sysres202_ControlAgudezaVisual').setValue(jsonData.data.res202_ControlAgudezaVisual);
                                }
                            }catch(ex) {
                            }
                            
                            Ext.getCmp('frmPacienteVerificaDatosBasicos').setDisabled(false);
                            //Ext.getCmp('btnGuardarDBHC').setDisabled(false);
                        },
                        scope:this
                    });
                }
            }
        });
        VerificarDatosBasicosPaciente001Ui.superclass.initComponent.call(this);
    }
});



function fnGardarVerificarDatosBasicosPaciente(){
    var frm = Ext.getCmp('frmPacienteVerificaDatosBasicos').getForm();
    if (frm.isValid()){
        Ext.Ajax.request({
            waitMsg: 'Por favor Espere...',
            url: '../../controlador/asistencial/controlador_2022.php',
            params:{
                task: 'VerificarDatosBasicosSave',
                pPaciente: wPaciente,
                pGenero: Ext.getCmp('sysGeneroDatosBasicos').getValue(),
                pFecNac: Ext.getCmp('sysFecNacDatosBasicos').getValue(),
                pEdad: Ext.getCmp('sysEdadDatosBasicos').getValue(),
                pPais: Ext.getCmp('sysPaisDatosBasicos').getValue(),
                pEtnia: Ext.getCmp('sysEtniaDatosBasicos').getValue(),
                pEscolaridad: Ext.getCmp('sysEscolaridadDatosBasicos').getValue(),
                pOcupacion: Ext.getCmp('sysCodigoOcupacionDatosBasicos').getValue(),
                pDireccion: Ext.getCmp('sysDireccionDatosBasicos').getValue(),
                pTelefono: Ext.getCmp('sysTelefonoDatosBasicos').getValue(),
                pEmail: Ext.getCmp('sysEmailDatosBasicos').getValue()
            },
            success: function(response){
                Ext.MessageBox.show({
                    title: 'OfiClinic',
                    msg: 'Se guardaron los datos basicos con exito.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.INFO
                });
                try {
                    var campoX = Ext.getCmp('sysEdadHC');
                    if ( campoX !== null ) {
                        Ext.getCmp('sysEdadHC').setValue(Ext.getCmp('sysEdadDatosBasicos').getValue());
                    }
                }catch(ex) {
                }
                try {
                    var campoX = Ext.getCmp('sysFechaNac');
                    if ( campoX !== null ) {
                        Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNacDatosBasicos').getValue().format("d/m/Y"));
                    }
                }catch(ex) {
                }
                
                localStorage.setItem('Genero','NA');
                localStorage.setItem('Genero',Ext.getCmp('sysGeneroDatosBasicos').getValue());
                if(Ext.getCmp('sysGeneroDatosBasicos').getValue() === "M"){
                    try {
                    var campoX = Ext.getCmp('sysGeneroHC');
                        if ( campoX !== null ) {
                            Ext.getCmp('sysGeneroHC').setValue("MASCULINO");
                        }
                    }catch(ex) {
                    }
                }else{
                    try {
                    var campoX = Ext.getCmp('sysGeneroHC');
                        if ( campoX !== null ) {
                            Ext.getCmp('sysGeneroHC').setValue("FEMENINO");
                        }
                    }catch(ex) {
                    }
                }
                if(Ext.getCmp('sysIdPlantillaHCDatosBasicos').getValue() === "1500"){
                    importarfactoresriesgo4505('frmHCMedGen', Ext.getCmp('sysCASDatosBasicos').getValue(), Ext.getCmp('sysPacienteDatosBasicos').getValue(),"MORBILIDAD");
                }
                //establecerCamposAntecedentes();
                
                if(Ext.getCmp('sysIdPlantillaHCDatosBasicos').getValue() === "1500"){
                    ocultarCamposRuta();
                    establecerRutaHC();
                }else{
                    Ext.getCmp('winFrmDatosBasicos').close();
                }
                
            },
            failure: function(response){
                var result = response.responseText;
                Ext.MessageBox.show({
                    title: 'Error Base Datos',
                    msg: 'No podemos guardar los datos basicos en estos momentos',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function establecerRutaHC(){
    
    let RUTA_ACTUAL = "NA";
    let TIPOATENCION_ACTUAL = "NA";
    let RANGO_ACTUAL = "NA";
    let YA_HIZO_ATENCION = 0;
    let RECOMENDACIONES = "";
   
    let mesesTotal = (parseInt(localStorage.getItem('Anios')) * 12) + parseInt(localStorage.getItem('Meses'));
            
    if(mesesTotal === 1){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - MEDICINA GENERAL Y/O PEDIATRIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RANGO_ACTUAL = "1 MES";
            RECOMENDACIONES = "";
        }
    }else if(mesesTotal <= 3){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            RANGO_ACTUAL = "2-3 MESES";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(mesesTotal <= 5){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - MEDICINA GENERAL Y/O PEDIATRIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            RANGO_ACTUAL = "4-5 MESES";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(mesesTotal <= 8){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            RANGO_ACTUAL = "6-8 MESES";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(mesesTotal <= 11){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            RANGO_ACTUAL = "9-11 MESES";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(mesesTotal <= 18){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - MEDICINA GENERAL Y/O PEDIATRIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            RANGO_ACTUAL = "12-18 MESES";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(mesesTotal <= 23){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            RANGO_ACTUAL = "19-23 MESES";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(mesesTotal <= 29){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - MEDICINA GENERAL Y/O PEDIATRIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            RANGO_ACTUAL = "24-29 MESES";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(mesesTotal <= 35){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            RANGO_ACTUAL = "30-35 MESES";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 3){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - MEDICINA GENERAL Y/O PEDIATRIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            RANGO_ACTUAL = "3 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 4){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            RANGO_ACTUAL = "4 ANIOS";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 5){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA PRIMERA INFANCIA - MEDICINA GENERAL Y/O PEDIATRIA";
        }else{
            RUTA_ACTUAL = "PRIMERA INFANCIA";
            RANGO_ACTUAL = "5 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 6){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA INFANCIA - MEDICINA GENERAL Y/O PEDIATRIA";
        }else{
            RUTA_ACTUAL = "INFANCIA";
            RANGO_ACTUAL = "6 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 7){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA INFANCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "INFANCIA";
            RANGO_ACTUAL = "7 ANIOS";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 8){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA INFANCIA - MEDICINA GENERAL Y/O PEDIATRIA";
        }else{
            RUTA_ACTUAL = "INFANCIA";
            RANGO_ACTUAL = "8 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 9){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA INFANCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "INFANCIA";
            RANGO_ACTUAL = "9 ANIOS";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 10){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA INFANCIA - MEDICINA GENERAL Y/O PEDIATRIA";
        }else{
            RUTA_ACTUAL = "INFANCIA";
            RANGO_ACTUAL = "10 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 11){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA INFANCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "INFANCIA";
            RANGO_ACTUAL = "11 ANIOS";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 12){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADOLESCENCIA - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "ADOLESCENCIA";
            RANGO_ACTUAL = "12 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 13){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADOLESCENCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "ADOLESCENCIA";
            RANGO_ACTUAL = "13 ANIOS";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 14){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADOLESCENCIA - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "ADOLESCENCIA";
            RANGO_ACTUAL = "14 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 15){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADOLESCENCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "ADOLESCENCIA";
            RANGO_ACTUAL = "15 ANIOS";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 16){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADOLESCENCIA - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "ADOLESCENCIA";
            RANGO_ACTUAL = "16 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 17){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "ENFERMERIA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADOLESCENCIA - ENFERMERIA";
        }else{
            RUTA_ACTUAL = "ADOLESCENCIA";
            RANGO_ACTUAL = "17 ANIOS";
            TIPOATENCION_ACTUAL = "ENFERMERIA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 18){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA JUVENTUD - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "JUVENTUD";
            RANGO_ACTUAL = "18 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 19){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA JUVENTUD - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "JUVENTUD";
            RANGO_ACTUAL = "19 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 20){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA JUVENTUD - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "JUVENTUD";
            RANGO_ACTUAL = "20 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 21){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA JUVENTUD - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "JUVENTUD";
            RANGO_ACTUAL = "21 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 22){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA JUVENTUD - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "JUVENTUD";
            RANGO_ACTUAL = "22 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 23){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA JUVENTUD - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "JUVENTUD";
            RANGO_ACTUAL = "23 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 24){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA JUVENTUD - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "JUVENTUD";
            RANGO_ACTUAL = "24 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 25){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA JUVENTUD - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "JUVENTUD";
            RANGO_ACTUAL = "25 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 26){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA JUVENTUD - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "JUVENTUD";
            RANGO_ACTUAL = "26 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 27){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA JUVENTUD - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "JUVENTUD";
            RANGO_ACTUAL = "27 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) === 28){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA JUVENTUD - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "JUVENTUD";
            RANGO_ACTUAL = "28 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 34){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADULTEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "ADULTEZ";
            RANGO_ACTUAL = "29-34 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 39){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADULTEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "ADULTEZ";
            RANGO_ACTUAL = "35-39 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 44){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADULTEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "ADULTEZ";
            RANGO_ACTUAL = "40-44 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 49){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADULTEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "ADULTEZ";
            RANGO_ACTUAL = "45-49 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 54){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADULTEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "ADULTEZ";
            RANGO_ACTUAL = "50-54 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 59){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA ADULTEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "ADULTEZ";
            RANGO_ACTUAL = "55-59 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 63){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA VEJEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "VEJEZ";
            RANGO_ACTUAL = "60-63 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 65){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA VEJEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "VEJEZ";
            RANGO_ACTUAL = "64-65 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 68){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA VEJEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "VEJEZ";
            RANGO_ACTUAL = "66-68 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 71){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA VEJEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "VEJEZ";
            RANGO_ACTUAL = "69-71 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 74){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA VEJEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "VEJEZ";
            RANGO_ACTUAL = "72-74 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 77){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA VEJEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "VEJEZ";
            RANGO_ACTUAL = "75-77 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) <= 79){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA VEJEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "VEJEZ";
            RANGO_ACTUAL = "75-79 ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }else if(parseInt(localStorage.getItem('Anios')) >= 80){
        if(Ext.getCmp('sysEspecialidadRIAS').getValue() !== "MEDICINA"){
            RUTA_ACTUAL = "NA";
            TIPOATENCION_ACTUAL = "NA";
            RANGO_ACTUAL = "NA";
            RECOMENDACIONES = "REMITIR PARA SER VALORADO POR LA RUTA VEJEZ - MEDICINA GENERAL";
        }else{
            RUTA_ACTUAL = "VEJEZ";
            RANGO_ACTUAL = "80-MAS ANIOS";
            TIPOATENCION_ACTUAL = "MEDICINA";
            RECOMENDACIONES = "";
        }
    }
    
    //Validacion Ruta Agudeza Visual
    validarAgudezaVisual();
    
    //Validar Atenciones de acuerdo a la ruta
    if(RUTA_ACTUAL !== "NA"){
        Ext.Ajax.request({
            url: '../../controlador/asistencial/controlador_2022.php',
            waitMsg: 'Cargando Información...',
            params:{
                pPaciente: wPaciente,
                task: 'ValidaAtencionRuta',
                pRuta: RUTA_ACTUAL,
                pTipoAtencion: TIPOATENCION_ACTUAL,
                pRango: RANGO_ACTUAL
            },
            success: function(result, request){
                var jsonData = Ext.util.JSON.decode(result.responseText);
                const resp = jsonData.map( item => {
                    return {
                        ...item
                    };
                });
                
                resp.forEach(item => {
                    if(parseInt(item.Paciente) > 0){
                        YA_HIZO_ATENCION = 1;
                    }
                });
                
                Ext.getCmp('fsImagenesRES20201').setVisible(false);
                Ext.getCmp('fsImagenesRES20202').setVisible(false);
                
                if( YA_HIZO_ATENCION === 0 ){
                    rango = RANGO_ACTUAL.replace("ANIOS", "AÑOS");
                    Ext.getCmp('sysTxtRUTA').setValue("** RUTA: " + RUTA_ACTUAL + " - " + rango + " **");
                    Ext.getCmp('sysRUTA_ACTUAL').setValue(RUTA_ACTUAL);
                    Ext.getCmp('sysTIPOATENCION_ACTUAL').setValue(TIPOATENCION_ACTUAL);
                    Ext.getCmp('sysRANGO_ACTUAL').setValue(RANGO_ACTUAL);
                
                    if(RUTA_ACTUAL === "PRIMERA INFANCIA"){
                        Ext.getDom('viewimgRES2021').src = + Ext.BLANK_IMAGE_URL;
                        Ext.getDom('viewimgRES2021').src = "../../../resources/rias/RIA_PRIMERAINFANCIA.jpg";
                        Ext.getDom('viewimgRES2022').src = + Ext.BLANK_IMAGE_URL;
                        Ext.getDom('viewimgRES2022').src = "../../../resources/rias/VACUNA_PRIMERAINFANCIA.jpg";
                        Ext.getCmp('fsImagenesRES20201').setVisible(true);
                        Ext.getCmp('fsImagenesRES20202').setVisible(true);
                    }else if(RUTA_ACTUAL === "INFANCIA"){
                        Ext.getDom('viewimgRES2021').src = + Ext.BLANK_IMAGE_URL;
                        Ext.getDom('viewimgRES2021').src = "../../../resources/rias/RIA_INFANCIA.jpg";
                        Ext.getCmp('fsImagenesRES20201').setVisible(true);
                        if(parseInt(localStorage.getItem('Anios')) >= 9){
                            Ext.getDom('viewimgRES2022').src = + Ext.BLANK_IMAGE_URL;
                            Ext.getDom('viewimgRES2022').src = "../../../resources/rias/VACUNA_INFANCIA.jpg";
                            Ext.getCmp('fsImagenesRES20202').setVisible(true);
                        }
                    }else if(RUTA_ACTUAL === "ADOLESCENCIA"){
                        Ext.getDom('viewimgRES2021').src = + Ext.BLANK_IMAGE_URL;
                        Ext.getDom('viewimgRES2021').src = "../../../resources/rias/RIA_ADOLESCENCIA.jpg";
                        Ext.getCmp('fsImagenesRES20201').setVisible(true);
                    }else if(RUTA_ACTUAL === "JUVENTUD"){
                        Ext.getDom('viewimgRES2021').src = + Ext.BLANK_IMAGE_URL;
                        Ext.getDom('viewimgRES2021').src = "../../../resources/rias/RIA_JUVENTUD.jpg";
                        //Ext.getDom('viewimgRES2022').src = + Ext.BLANK_IMAGE_URL;
                        //Ext.getDom('viewimgRES2022').src = "../../../resources/rias/VACUNA_JUVENTUD.jpg";
                        Ext.getCmp('fsImagenesRES20201').setVisible(true);
                        //Ext.getCmp('fsImagenesRES20202').setVisible(true);
                    }else if(RUTA_ACTUAL === "ADULTEZ"){
                        Ext.getDom('viewimgRES2021').src = + Ext.BLANK_IMAGE_URL;
                        Ext.getDom('viewimgRES2021').src = "../../../resources/rias/RIA_ADULTEZ.jpg";
                        Ext.getCmp('fsImagenesRES20201').setVisible(true);
                    }else if(RUTA_ACTUAL === "VEJEZ"){
                        Ext.getDom('viewimgRES2021').src = + Ext.BLANK_IMAGE_URL;
                        Ext.getDom('viewimgRES2021').src = "../../../resources/rias/RIA_VEJEZ.jpg";
                        Ext.getDom('viewimgRES2022').src = + Ext.BLANK_IMAGE_URL;
                        Ext.getDom('viewimgRES2022').src = "../../../resources/rias/VACUNA_VEJEZ.jpg";
                        Ext.getCmp('fsImagenesRES20201').setVisible(true);
                        Ext.getCmp('fsImagenesRES20202').setVisible(true);
                    }
                    
                    //Establecer campos obligatorios de acuerdo a la ruta
                    establecerCamposRuta(wPaciente, RUTA_ACTUAL, TIPOATENCION_ACTUAL, RANGO_ACTUAL);
                } else {
                    Ext.getCmp('sysTxtRUTA').setValue("");
                    Ext.getCmp('sysRUTA_ACTUAL').setValue("NA");
                    Ext.getCmp('sysTIPOATENCION_ACTUAL').setValue("NA");
                    Ext.getCmp('sysRANGO_ACTUAL').setValue("NA");
                }
                
            },
            scope:this
        });
    }else if(RECOMENDACIONES !== ""){
        Ext.getCmp('fsImagenesRES20201').setVisible(false);
        Ext.getCmp('fsImagenesRES20202').setVisible(false);
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: RECOMENDACIONES,
            buttons: Ext.Msg.OK,
            icon: Ext.Msg.WARNING
        });
        alert("ATENCION: " + RECOMENDACIONES);
    }
    Ext.getCmp('winFrmDatosBasicos').close();
}

function validarAgudezaVisual(){
    if(parseInt(localStorage.getItem('Anios')) >= 3){
        Ext.getCmp('fsRES202AgudezaVisual').setVisible(true);
        Ext.getCmp('fecAgudezaVisualValoracion62').allowBlank = false;
        Ext.getCmp('strAgudezaVisualOjoIzquierdo27').allowBlank = false;
        Ext.getCmp('strAgudezaVisualOjoDerecho28').allowBlank = false;
        Ext.getCmp('sysres202_ControlAgudezaVisual').setValue(21);
        Ext.getCmp('sysAgudezaVisualValoracion').setValue("1800-01-01");
        Ext.getCmp('sysAgudezaVisualOjoIzquierdo').setValue("21 - Riesgo no evaluado");
        Ext.getCmp('sysAgudezaVisualOjoDerecho').setValue("21 - Riesgo no evaluado");
        
        Ext.Ajax.request({
            url: '../../controlador/asistencial/controlador_2022.php',
            waitMsg: 'Cargando Información...',
            params:{
                pPaciente: wPaciente,
                task: 'UltimaAtencionAgudezaVisual'
            },
            success: function(result, request){
                var jsonData = Ext.util.JSON.decode(result.responseText);
                const resp = jsonData.map( item => {
                    return {
                        ...item
                    };
                });
                
                resp.forEach(item => {
                    if(parseInt(item.Dias) >= 365){
                        Ext.getCmp('fsRES202AgudezaVisual').setVisible(true);
                        Ext.getCmp('fecAgudezaVisualValoracion62').setValue(null);
                        Ext.getCmp('strAgudezaVisualOjoIzquierdo27').setValue(null);
                        Ext.getCmp('strAgudezaVisualOjoDerecho28').setValue(null);
                        Ext.getCmp('sysres202_ControlAgudezaVisual').setValue(21);
                        Ext.getCmp('sysAgudezaVisualValoracion').setValue("1800-01-01");
                        Ext.getCmp('sysAgudezaVisualOjoIzquierdo').setValue("21 - Riesgo no evaluado");
                        Ext.getCmp('sysAgudezaVisualOjoDerecho').setValue("21 - Riesgo no evaluado");
                    }else{
                        Ext.getCmp('fsRES202AgudezaVisual').setVisible(false);
                        Ext.getCmp('fecAgudezaVisualValoracion62').allowBlank = true;
                        Ext.getCmp('fecAgudezaVisualValoracion62').setValue(null);
                        Ext.getCmp('strAgudezaVisualOjoIzquierdo27').allowBlank = true;
                        Ext.getCmp('strAgudezaVisualOjoIzquierdo27').setValue(null);
                        Ext.getCmp('strAgudezaVisualOjoDerecho28').allowBlank = true;
                        Ext.getCmp('strAgudezaVisualOjoDerecho28').setValue(null);
                        Ext.getCmp('sysres202_ControlAgudezaVisual').setValue(1);
                        Ext.getCmp('sysAgudezaVisualValoracion').setValue( null);
                        Ext.getCmp('sysAgudezaVisualOjoIzquierdo').setValue( null );
                        Ext.getCmp('sysAgudezaVisualOjoDerecho').setValue( null);
                    }
                });
            },
            scope:this
        });
    }else{
        Ext.getCmp('fsRES202AgudezaVisual').setVisible(false);
        Ext.getCmp('fecAgudezaVisualValoracion62').setValue(null);
        Ext.getCmp('fecAgudezaVisualValoracion62').allowBlank = true;
        Ext.getCmp('strAgudezaVisualOjoIzquierdo27').allowBlank = true;
        Ext.getCmp('strAgudezaVisualOjoDerecho28').allowBlank = true;
        Ext.getCmp('sysres202_ControlAgudezaVisual').setValue(0);
        Ext.getCmp('sysAgudezaVisualValoracion').setValue("1845-01-01");
        Ext.getCmp('sysAgudezaVisualOjoIzquierdo').setValue("0 - No aplica");
        Ext.getCmp('sysAgudezaVisualOjoDerecho').setValue("0 - No aplica");
    }
}

function establecerCamposRuta(pPaciente, pRuta, pTipoAtencion, pRango){
    
    mostrarApgar();
    
    if(pRuta === "PRIMERA INFANCIA"){
        Ext.getCmp('fsRES202PrimeraInfancia').setVisible(true);
        Ext.getCmp('fsPrimeraInfanciaVale').setVisible(true);
        Ext.getCmp('fsPrimeraInfanciaEAD').setVisible(true);
        Ext.getCmp('fsPIMicronutrientes').setVisible(true);
        Ext.getCmp('strPrimeraInfanciaValeNoSeRealiza').allowBlank = true;
        Ext.getCmp('fecPrimeraInfanciaVale63').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaVale40').allowBlank = false;
        Ext.getCmp('memPrimeraInfanciaVale').allowBlank = true;
        Ext.getCmp('strPrimeraInfanciaEAD43').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaEAD44').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaEAD45').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaEAD46').allowBlank = false;
        Ext.getCmp('memPrimeraInfanciaEAD3').allowBlank = true;
        Ext.getCmp('fsPIMicronutrientes').setVisible(true);
        /*Ext.getCmp('strPrimeraInfanciaFortificacionCasera70').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaVitaminaA71').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaHierro77').allowBlank = false;
        Ext.getCmp('memPrimeraInfanciaObservaciones').allowBlank = false;
        */
        
        Ext.getCmp('intEXAFISTASentadoSistolica').allowBlank = true;
        Ext.getCmp('intEXAFISTASentadoDiastolica').allowBlank = true;
        
        /*
        Ext.getCmp('fsEFPresionArterial').setVisible(false);
        
        
        Ext.getCmp('fsEFPresionArterialP').setVisible(false);
        Ext.getCmp('intEXAFISTAdePieSistolica').allowBlank = true;
        Ext.getCmp('intEXAFISTAdePieDiastolica').allowBlank = true;
        
        Ext.getCmp('sysEXAFISPA').setVisible(false);
        Ext.getCmp('strEXAFISPA').setVisible(false);
        Ext.getCmp('strEXAFISPA').allowBlank = true;
        
        Ext.getCmp('strEXAFISPC').setVisible(true);
        Ext.getCmp('strEXAFISPT').setVisible(true);
        Ext.getCmp('strEXAFISPC').allowBlank = false;
        Ext.getCmp('strEXAFISPT').allowBlank = false;
        */
       
        //Ext.getCmp('fsEAD3').setVisible(true);
    }else if(pRuta === "INFANCIA"){
        Ext.getCmp('fsRES202Infancia').setVisible(true);
        Ext.getCmp('fsInfanciaVale').setVisible(true);
        Ext.getCmp('fsInfanciaRQC').setVisible(true);
        Ext.getCmp('strInfanciaValeNoSeRealiza').allowBlank = false;
        Ext.getCmp('fecInfanciaVale63').allowBlank = false;
        Ext.getCmp('strInfanciaVale40').allowBlank = false;
        Ext.getCmp('memInfanciaVale').allowBlank = true;
        if(localStorage.getItem('Genero') === "M"){
            Ext.getCmp('fsInfanciaTannerMujer').setVisible(false);
            Ext.getCmp('strInfanciaTannerMujerMama').allowBlank = true;
            Ext.getCmp('strInfanciaTannerMujerVello').allowBlank = true;
            
            Ext.getCmp('fsInfanciaTannerHombre').setVisible(true);
            Ext.getCmp('strInfanciaTannerHombrGenital').allowBlank = false;
            Ext.getCmp('strInfanciaTannerHombreVello').allowBlank = false;
        }else if(localStorage.getItem('Genero') === "F"){
            Ext.getCmp('fsInfanciaTannerMujer').setVisible(true);
            Ext.getCmp('strInfanciaTannerMujerMama').allowBlank = false;
            Ext.getCmp('strInfanciaTannerMujerVello').allowBlank = false;
            
            Ext.getCmp('fsInfanciaTannerHombre').setVisible(false);
            Ext.getCmp('strInfanciaTannerHombrGenital').allowBlank = true;
            Ext.getCmp('strInfanciaTannerHombreVello').allowBlank = true;
        }
        Ext.getCmp('strInfanciaRQC1').allowBlank = false;
        Ext.getCmp('strInfanciaRQC2').allowBlank = false;
        Ext.getCmp('strInfanciaRQC3').allowBlank = false;
        Ext.getCmp('strInfanciaRQC4').allowBlank = false;
        Ext.getCmp('strInfanciaRQC5').allowBlank = false;
        Ext.getCmp('strInfanciaRQC6').allowBlank = false;
        Ext.getCmp('strInfanciaRQC7').allowBlank = false;
        Ext.getCmp('strInfanciaRQC8').allowBlank = false;
        Ext.getCmp('strInfanciaRQC9').allowBlank = false;
        Ext.getCmp('strInfanciaRQC10').allowBlank = false;
        Ext.getCmp('memInfanciaObservaciones').allowBlank = false;
        
        Ext.getCmp('strInfanciaValeNoSeRealiza').allowBlank = true;
        
        Ext.getCmp('intEXAFISTASentadoSistolica').allowBlank = true;
        Ext.getCmp('intEXAFISTASentadoDiastolica').allowBlank = true;
        
        /*
        Ext.getCmp('fsEFPresionArterial').setVisible(false);
        Ext.getCmp('intEXAFISTASentadoSistolica').allowBlank = true;
        Ext.getCmp('intEXAFISTASentadoDiastolica').allowBlank = true;
        
        Ext.getCmp('fsEFPresionArterialP').setVisible(false);
        Ext.getCmp('intEXAFISTAdePieSistolica').allowBlank = true;
        Ext.getCmp('intEXAFISTAdePieDiastolica').allowBlank = true;
        
        Ext.getCmp('sysEXAFISPA').setVisible(false);
        Ext.getCmp('strEXAFISPA').setVisible(false);
        Ext.getCmp('strEXAFISPA').allowBlank = true;
        
        Ext.getCmp('strEXAFISPC').setVisible(true);
        Ext.getCmp('strEXAFISPT').setVisible(true);
        Ext.getCmp('strEXAFISPC').allowBlank = false;
        Ext.getCmp('strEXAFISPT').allowBlank = false;
        */
       
    }else if(pRuta === "ADOLESCENCIA"){
        Ext.getCmp('fsRES202Adolescencia').setVisible(true);
        Ext.getCmp('fsAdolescenciaVale').setVisible(true);
        Ext.getCmp('fsAdolescenciaRQC').setVisible(true);
        Ext.getCmp('fsAdolescenciaSRQ').setVisible(true);
        if(localStorage.getItem('Genero') === "M"){
            Ext.getCmp('fsAdolescenciaTannerMujer').setVisible(false);
            Ext.getCmp('strAdolescenciaTannerMujerMama').allowBlank = true;
            Ext.getCmp('strAdolescenciaTannerMujerVello').allowBlank = true;
            
            Ext.getCmp('fsAdolescenciaTannerHombre').setVisible(true);
            Ext.getCmp('strAdolescenciaTannerHombrGenital').allowBlank = false;
            Ext.getCmp('strAdolescenciaTannerHombreVello').allowBlank = false;
        }else if(localStorage.getItem('Genero') === "F"){
            Ext.getCmp('fsAdolescenciaTannerMujer').setVisible(true);
            Ext.getCmp('strAdolescenciaTannerMujerMama').allowBlank = false;
            Ext.getCmp('strAdolescenciaTannerMujerVello').allowBlank = false;
            
            Ext.getCmp('fsAdolescenciaTannerHombre').setVisible(false);
            Ext.getCmp('strAdolescenciaTannerHombrGenital').allowBlank = true;
            Ext.getCmp('strAdolescenciaTannerHombreVello').allowBlank = true;
        }
        Ext.getCmp('strAdolescenciaValeNoSeRealiza').allowBlank = true;
        Ext.getCmp('fecAdolescenciaVale63').allowBlank = false;
        Ext.getCmp('strAdolescenciaVale40').allowBlank = false;
        Ext.getCmp('memAdolescenciaVale').allowBlank = true;
        
        Ext.getCmp('strAdolecenciaRQC1').allowBlank = false;
        Ext.getCmp('strAdolecenciaRQC2').allowBlank = false;
        Ext.getCmp('strAdolecenciaRQC3').allowBlank = false;
        Ext.getCmp('strAdolecenciaRQC4').allowBlank = false;
        Ext.getCmp('strAdolecenciaRQC5').allowBlank = false;
        Ext.getCmp('strAdolecenciaRQC6').allowBlank = false;
        Ext.getCmp('strAdolecenciaRQC7').allowBlank = false;
        Ext.getCmp('strAdolecenciaRQC8').allowBlank = false;
        Ext.getCmp('strAdolecenciaRQC9').allowBlank = false;
        Ext.getCmp('strAdolecenciaRQC10').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ1').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ2').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ3').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ4').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ5').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ6').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ7').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ8').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ9').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ10').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ11').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ12').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ13').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ14').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ15').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ16').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ17').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ18').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ19').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ20').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ21').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ22').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ23').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ24').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ25').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ26').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ27').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ28').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ29').allowBlank = false;
        Ext.getCmp('strAdolecenciaSRQ30').allowBlank = false;
        
        Ext.getCmp('memAdolescenciaObservaciones').allowBlank = false;
        if(parseInt(localStorage.getItem('Anios')) > 12){ 
            mostrarTabaquismo();
        }
    }else if(pRuta === "JUVENTUD"){
        Ext.getCmp('fsRES202Juventud').setVisible(true);
        Ext.getCmp('memJuventudObservaciones').allowBlank = false;
        if(parseInt(localStorage.getItem('Anios')) > 12){ 
            mostrarTabaquismo();
        }
        mostrarFindRisk();
    }else if(pRuta === "ADULTEZ"){
        Ext.getCmp('fsRES202Adultez').setVisible(true);
        Ext.getCmp('memAdultezObservaciones').allowBlank = false;
        if(parseInt(localStorage.getItem('Anios')) >= 40 && localStorage.getItem('Genero') == "M"){ 
            mostrarTactoRectal();
        }
        if(parseInt(localStorage.getItem('Anios')) > 12){ 
            mostrarTabaquismo();
        }
        mostrarFindRisk();
        mostrarFramingham();
        //mostrarBarthel();
        //mostrarLawton();
        //mostrarMinimental();
    }else if(pRuta === "VEJEZ"){
        Ext.getCmp('fsRES202Vejez').setVisible(true);
        Ext.getCmp('memVejezObservaciones').allowBlank = false;
        if(parseInt(localStorage.getItem('Anios')) >= 40 && localStorage.getItem('Genero') == "M"){ 
            mostrarTactoRectal();
        }
        if(parseInt(localStorage.getItem('Anios')) > 12){ 
            mostrarTabaquismo();
        }
        mostrarFindRisk();
        mostrarFramingham();
        mostrarBarthel();
        mostrarLawton();
        mostrarMinimental();
    }
}

function mostrarTabaquismo(){
    // TABAQUISMO
    Ext.getCmp('fsRES202Tabaquismo').setVisible(true);
    Ext.getCmp('strResultadoConsumoTabaco').allowBlank = true;
    Ext.getCmp('memConsumoTabacoObservaciones').allowBlank = true;
}

function mostrarTactoRectal(){
    //TACTO RECTAL
    Ext.getCmp('fsRES202TactoRectal').setVisible(true);
    //TACTO RECTAL
}

function mostrarFramingham(){
    Ext.getCmp('fsFramingham').setVisible(true);
    Ext.getCmp('strFRAMINGHAMPuntuacion').allowBlank = true;
    Ext.getCmp('strFRAMINGHAMRiesgo').allowBlank = true;
}

function mostrarFindRisk(){
    Ext.getCmp('fsFindRisk').setVisible(true);
    Ext.getCmp('strFINDRISCRangoEdad').allowBlank = true;
    Ext.getCmp('strFINDRISCIMC').allowBlank = true;
    Ext.getCmp('strFINDRISCPC').allowBlank = true;
    Ext.getCmp('strFINDRISCEjercicio').allowBlank = true;
    Ext.getCmp('strFINDRISCConsumoVejetales').allowBlank = true;
    Ext.getCmp('strFINDRISCMedicamentosHTA').allowBlank = true;
    Ext.getCmp('strFINDRISCGlucosaAlterada').allowBlank = true;
    Ext.getCmp('strFINDRISCAntecedentesDM').allowBlank = true;
    Ext.getCmp('strFINDRISCPuntajeTotal').allowBlank = true;
}

function mostrarBarthel(){
    Ext.getCmp('fsBarthel').setVisible(true);
    Ext.getCmp('strBarthelComer').allowBlank = true;
    Ext.getCmp('intBarthelComerPto').allowBlank = true;
    Ext.getCmp('strBarthelComerDes').allowBlank = true;
    Ext.getCmp('strBarthelLavarse').allowBlank = true;
    Ext.getCmp('intBarthelLavarsePto').allowBlank = true;
    Ext.getCmp('strBarthelLavarseDes').allowBlank = true;
    Ext.getCmp('strBarthelVestirse').allowBlank = true;
    Ext.getCmp('intBarthelVestirsePto').allowBlank = true;
    Ext.getCmp('strBarthelVestirseDes').allowBlank = true;
    Ext.getCmp('strBarthelArreglarse').allowBlank = true;
    Ext.getCmp('intBarthelArreglarsePto').allowBlank = true;
    Ext.getCmp('strBarthelArreglarseDes').allowBlank = true;
    Ext.getCmp('strBarthelDeposiciones').allowBlank = true;
    Ext.getCmp('intBarthelDeposicionesPto').allowBlank = true;
    Ext.getCmp('strBarthelDeposicionesDes').allowBlank = true;
    Ext.getCmp('strBarthelMiccion').allowBlank = true;
    Ext.getCmp('intBarthelMiccionPto').allowBlank = true;
    Ext.getCmp('strBarthelMiccionDes').allowBlank = true;
    Ext.getCmp('strBarthelRetrete').allowBlank = true;
    Ext.getCmp('intBarthelRetretePto').allowBlank = true;
    Ext.getCmp('strBarthelRetreteDes').allowBlank = true;
    Ext.getCmp('strBarthelTraslado').allowBlank = true;
    Ext.getCmp('intBarthelTrasladoPto').allowBlank = true;
    Ext.getCmp('strBarthelTrasladoDes').allowBlank = true;
    Ext.getCmp('strBarthelDeambular').allowBlank = true;
    Ext.getCmp('intBarthelDeambularPto').allowBlank = true;
    Ext.getCmp('strBarthelDeambularDes').allowBlank = true;
    Ext.getCmp('strBarthelEscalones').allowBlank = true;
    Ext.getCmp('intBarthelEscalonesPto').allowBlank = true;
    Ext.getCmp('strBarthelEscalonesDes').allowBlank = true;
    Ext.getCmp('intBarthelTotal').allowBlank = true;
    Ext.getCmp('sysvCalsifica').allowBlank = true;
    Ext.getCmp('strBarthelValoracion').allowBlank = true;
}

function mostrarLawton(){
    Ext.getCmp('fsLawton').setVisible(true);
    Ext.getCmp('syspn1').allowBlank = false;
    Ext.getCmp('syspn2').allowBlank = false;
    Ext.getCmp('syspn3').allowBlank = false;
    Ext.getCmp('syspn4').allowBlank = false;
    Ext.getCmp('syspn5').allowBlank = false;
    Ext.getCmp('bolLawton1NoHace').allowBlank = false;
    Ext.getCmp('bolLawton1SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton1ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton1ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton1NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton2NoHace').allowBlank = false;
    Ext.getCmp('bolLawton2SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton2ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton2ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton2NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton3NoHace').allowBlank = false;
    Ext.getCmp('bolLawton3SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton3ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton3ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton3NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton4NoHace').allowBlank = false;
    Ext.getCmp('bolLawton4SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton4ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton4ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton4NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton5NoHace').allowBlank = false;
    Ext.getCmp('bolLawton5SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton5ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton5ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton5NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton6NoHace').allowBlank = false;
    Ext.getCmp('bolLawton6SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton6ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton6ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton6NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton7NoHace').allowBlank = false;
    Ext.getCmp('bolLawton7SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton7ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton7ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton7NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton8NoHace').allowBlank = false;
    Ext.getCmp('bolLawton8SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton8ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton8ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton8NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton9NoHace').allowBlank = false;
    Ext.getCmp('bolLawton9SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton9ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton9ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton9NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton10NoHace').allowBlank = false;
    Ext.getCmp('bolLawton10SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton10ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton10ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton10NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton11NoHace').allowBlank = false;
    Ext.getCmp('bolLawton11SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton11ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton11ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton11NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton12NoHace').allowBlank = false;
    Ext.getCmp('bolLawton12SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton12ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton12ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton12NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton13NoHace').allowBlank = false;
    Ext.getCmp('bolLawton13SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton13ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton13ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton13NoEvaluable').allowBlank = false;
    Ext.getCmp('bolLawton14NoHace').allowBlank = false;
    Ext.getCmp('bolLawton14SinDificultad').allowBlank = false;
    Ext.getCmp('bolLawton14ConDificultad').allowBlank = false;
    Ext.getCmp('bolLawton14ConAyuda').allowBlank = false;
    Ext.getCmp('bolLawton14NoEvaluable').allowBlank = false;
    Ext.getCmp('intLawtonTotalNoHace').allowBlank = false;
    Ext.getCmp('intLawtonTotalSinDificultad').allowBlank = false;
    Ext.getCmp('intLawtonTotalConDificultad').allowBlank = false;
    Ext.getCmp('intLawtonTotalConAyuda').allowBlank = false;
    Ext.getCmp('intLawtonTotalNoEvaluable').allowBlank = false;
    Ext.getCmp('strLawtonValoracion').allowBlank = true;
}

function mostrarMinimental(){
    Ext.getCmp('fsMiniMental').setVisible(true);
    Ext.getCmp('fsOrientacion').setVisible(true);
    Ext.getCmp('fsFijacion').setVisible(true);
    Ext.getCmp('fsAteCalculo').setVisible(true);
    Ext.getCmp('fsMemoria').setVisible(true);
    Ext.getCmp('fsLenPraxias').setVisible(true);
    Ext.getCmp('intMinimentalOriFecha').allowBlank = true;
    Ext.getCmp('intMinimentalOriDiaSemana').allowBlank = true;
    Ext.getCmp('intMinimentalOriDiaSemana').allowBlank = true;
    Ext.getCmp('intMinimentalOriDiaSemana').allowBlank = true;
    Ext.getCmp('intMinimentalOriAno').allowBlank = true;
    Ext.getCmp('intMinimentalOriManTarde').allowBlank = true;
    Ext.getCmp('intMinimentalOriPais').allowBlank = true;
    Ext.getCmp('intMinimentalOriDepartamento').allowBlank = true;
    Ext.getCmp('intMinimentalOriCiudad').allowBlank = true;
    Ext.getCmp('intMinimentalOriCenAteAmbulatoria').allowBlank = true;
    Ext.getCmp('intMinimentalOriServicio').allowBlank = true;
    Ext.getCmp('intMinimentalOriManTarde').allowBlank = true;
    Ext.getCmp('intMinimentalFijSilla').allowBlank = true;
    Ext.getCmp('intMinimentalFijSilla').allowBlank = true;
    Ext.getCmp('intMinimentalFijPared').allowBlank = true;
    Ext.getCmp('intMinimentalFijNumIntentos').allowBlank = true;
    Ext.getCmp('intMinimentalAteCalCuaQuedan').allowBlank = true;
    Ext.getCmp('intMinimentalAteCalMunReves').allowBlank = true;
    Ext.getCmp('intMinimentalMemRecTrePalabras').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraMuesPacLapReloj').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraTigConTig').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraEjeOrdTrePasos').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraLeaObeSigOrden').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraEscFrase').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraCopDibujo').allowBlank = true;

}

function mostrarApgar(){
    //APGAR FAMILIAR
    Ext.getCmp('fsApgarFamiliar').setVisible(true);
    Ext.getCmp('strApgarFamiliar1').allowBlank = true;
    Ext.getCmp('strApgarFamiliar1').setValue(null);
    Ext.getCmp('strApgarFamiliar2').allowBlank = true;
    Ext.getCmp('strApgarFamiliar2').setValue(null);
    Ext.getCmp('strApgarFamiliar3').allowBlank = true;
    Ext.getCmp('strApgarFamiliar3').setValue(null);
    Ext.getCmp('strApgarFamiliar4').allowBlank = true;
    Ext.getCmp('strApgarFamiliar4').setValue(null);
    Ext.getCmp('strApgarFamiliar5').allowBlank = true;
    Ext.getCmp('strApgarFamiliar5').setValue(null);
    Ext.getCmp('strApgarFamiliar6').allowBlank = true;
    Ext.getCmp('strApgarFamiliar6').setValue(null);
    Ext.getCmp('strApgarFamiliar7').allowBlank = true;
    Ext.getCmp('strApgarFamiliar7').setValue(null);
    Ext.getCmp('strApgarFamiliar8').allowBlank = true;
    Ext.getCmp('strApgarFamiliar8').setValue(null);
    Ext.getCmp('strApgarFamiliar9').allowBlank = true;
    Ext.getCmp('strApgarFamiliar9').setValue(null);
}

function ocultarCamposRuta(){
    
    /*
    Ext.getCmp('intEXAFISTAdePieSistolica').allowBlank = true;
    Ext.getCmp('intEXAFISTAdePieSistolica').readOnly=true;
    Ext.getCmp('intEXAFISTAdePieDiastolica').allowBlank = true;
    Ext.getCmp('intEXAFISTAdePieDiastolica').readOnly=true;
    
    
    Ext.getCmp('strEXAFISPC').allowBlank = true;
    Ext.getCmp('strEXAFISPT').allowBlank = true;
    Ext.getCmp('strEXAFISPC').setVisible(false);
    Ext.getCmp('strEXAFISPT').setVisible(false);

    if(localStorage.getItem('Genero') === "M"){
        Ext.getCmp('fsMamografia').setVisible(false);
        Ext.getCmp('strANTGINECOMamografia').allowBlank = true;
        Ext.getCmp('fecANTGINECOMamografia').allowBlank = true;
        Ext.getCmp('strANTGINECOMamografiaRes').allowBlank = true;
        Ext.getCmp('fsANTGINECO').setVisible(false);
        Ext.getCmp('intANTGINECOG').allowBlank = true;
        Ext.getCmp('intANTGINECOP').allowBlank = true;
        Ext.getCmp('intANTGINECOPV').allowBlank = true;
        Ext.getCmp('intANTGINECOPC').allowBlank = true;
        Ext.getCmp('intANTGINECOA').allowBlank = true;
        Ext.getCmp('intANTGINECOVivos').allowBlank = true;
        Ext.getCmp('intANTGINECOMuertos').allowBlank = true;
        Ext.getCmp('bolANTGINECOMola').allowBlank = true;
        Ext.getCmp('bolANTGINECOEmbEctopico').allowBlank = true;
        Ext.getCmp('bolANTPERSOPreclampsia').allowBlank = true;
        Ext.getCmp('bolANTPERSOEclampsia').allowBlank = true;
        Ext.getCmp('fecANTGINECOFup').allowBlank = true;
        Ext.getCmp('strANTGINECOMenarquiaPreg').allowBlank = true;
        Ext.getCmp('strANTGINECOMenarquia').allowBlank = true;
        Ext.getCmp('fecANTGINECOFum').allowBlank = true;
        Ext.getCmp('strANTGINECOFuc').allowBlank = true;
        Ext.getCmp('fecANTGINECOFuc').allowBlank = true;
        Ext.getCmp('strANTGINECOFucRes').allowBlank = true;
        Ext.getCmp('strANTGINECOMetodoPlanifica').allowBlank = true;
        Ext.getCmp('strANTGINECOActividadSexual').allowBlank = true;
        Ext.getCmp('strANTGINECOInicioActividadSexual').allowBlank = true;
        Ext.getCmp('strANTGINECONroCompanerosSexual').allowBlank = true;
        Ext.getCmp('strANTGINECOETS').allowBlank = true;
        Ext.getCmp('strANTGINECOPatologiaEmbarazo').allowBlank = true;
        Ext.getCmp('strANTGINECOMenopausia').allowBlank = true;
    }else {
        //alert("Edad: " + parseInt(localStorage.getItem('Anios')) + " - Genero: " + localStorage.getItem('Genero'));
        
        Ext.getCmp('fsMamografia').setVisible(true);
        Ext.getCmp('strANTGINECOMamografia').allowBlank = false;
        Ext.getCmp('fecANTGINECOMamografia').allowBlank = false;
        Ext.getCmp('strANTGINECOMamografiaRes').allowBlank = false;
        Ext.getCmp('fsANTGINECO').setVisible(true);
        Ext.getCmp('intANTGINECOG').allowBlank = false;
        Ext.getCmp('intANTGINECOP').allowBlank = false;
        Ext.getCmp('intANTGINECOPV').allowBlank = false;
        Ext.getCmp('intANTGINECOPC').allowBlank = false;
        Ext.getCmp('intANTGINECOA').allowBlank = false;
        Ext.getCmp('intANTGINECOVivos').allowBlank = false;
        Ext.getCmp('intANTGINECOMuertos').allowBlank = false;
        Ext.getCmp('bolANTGINECOMola').allowBlank = false;
        Ext.getCmp('bolANTGINECOEmbEctopico').allowBlank = false;
        Ext.getCmp('bolANTPERSOPreclampsia').allowBlank = false;
        Ext.getCmp('bolANTPERSOEclampsia').allowBlank = false;
        Ext.getCmp('fecANTGINECOFup').allowBlank = false;
        Ext.getCmp('strANTGINECOMenarquiaPreg').allowBlank = false;
        Ext.getCmp('strANTGINECOMenarquia').allowBlank = false;
        Ext.getCmp('fecANTGINECOFum').allowBlank = false;
        Ext.getCmp('strANTGINECOFuc').allowBlank = false;
        Ext.getCmp('fecANTGINECOFuc').allowBlank = false;
        Ext.getCmp('strANTGINECOFucRes').allowBlank = false;
        Ext.getCmp('strANTGINECOMetodoPlanifica').allowBlank = false;
        Ext.getCmp('strANTGINECOActividadSexual').allowBlank = false;
        Ext.getCmp('strANTGINECOInicioActividadSexual').allowBlank = false;
        Ext.getCmp('strANTGINECONroCompanerosSexual').allowBlank = false;
        Ext.getCmp('strANTGINECOETS').allowBlank = false;
        Ext.getCmp('strANTGINECOPatologiaEmbarazo').allowBlank = false;
        Ext.getCmp('strANTGINECOMenopausia').allowBlank = false;
        
        if(parseInt(localStorage.getItem('Anios')) < 14){ 
            Ext.getCmp('fsMamografia').setVisible(false);
            Ext.getCmp('strANTGINECOMamografia').allowBlank = true;
            Ext.getCmp('fecANTGINECOMamografia').allowBlank = true;
            Ext.getCmp('strANTGINECOMamografiaRes').allowBlank = true;
            Ext.getCmp('fsANTGINECO').setVisible(false);
            Ext.getCmp('intANTGINECOG').allowBlank = true;
            Ext.getCmp('intANTGINECOP').allowBlank = true;
            Ext.getCmp('intANTGINECOPV').allowBlank = true;
            Ext.getCmp('intANTGINECOPC').allowBlank = true;
            Ext.getCmp('intANTGINECOA').allowBlank = true;
            Ext.getCmp('intANTGINECOVivos').allowBlank = true;
            Ext.getCmp('intANTGINECOMuertos').allowBlank = true;
            Ext.getCmp('bolANTGINECOMola').allowBlank = true;
            Ext.getCmp('bolANTGINECOEmbEctopico').allowBlank = true;
            Ext.getCmp('bolANTPERSOPreclampsia').allowBlank = true;
            Ext.getCmp('bolANTPERSOEclampsia').allowBlank = true;
            Ext.getCmp('fecANTGINECOFup').allowBlank = true;
            Ext.getCmp('strANTGINECOMenarquiaPreg').allowBlank = true;
            Ext.getCmp('strANTGINECOMenarquia').allowBlank = true;
            Ext.getCmp('fecANTGINECOFum').allowBlank = true;
            Ext.getCmp('strANTGINECOFuc').allowBlank = true;
            Ext.getCmp('fecANTGINECOFuc').allowBlank = true;
            Ext.getCmp('strANTGINECOFucRes').allowBlank = true;
            Ext.getCmp('strANTGINECOMetodoPlanifica').allowBlank = true;
            Ext.getCmp('strANTGINECOActividadSexual').allowBlank = true;
            Ext.getCmp('strANTGINECOInicioActividadSexual').allowBlank = true;
            Ext.getCmp('strANTGINECONroCompanerosSexual').allowBlank = true;
            Ext.getCmp('strANTGINECOETS').allowBlank = true;
            Ext.getCmp('strANTGINECOPatologiaEmbarazo').allowBlank = true;
            Ext.getCmp('strANTGINECOMenopausia').allowBlank = true;
        }else if(parseInt(localStorage.getItem('Anios')) < 50){ 
            Ext.getCmp('fsMamografia').setVisible(false);
            Ext.getCmp('strANTGINECOMamografia').allowBlank = true;
            Ext.getCmp('fecANTGINECOMamografia').allowBlank = true;
            Ext.getCmp('strANTGINECOMamografiaRes').allowBlank = true;
        }
    }
    */
    //APGAR FAMILIAR
    Ext.getCmp('fsApgarFamiliar').setVisible(false);
    Ext.getCmp('strApgarFamiliar1').allowBlank = true;
    Ext.getCmp('strApgarFamiliar1').setValue(null);
    Ext.getCmp('strApgarFamiliar2').allowBlank = true;
    Ext.getCmp('strApgarFamiliar2').setValue(null);
    Ext.getCmp('strApgarFamiliar3').allowBlank = true;
    Ext.getCmp('strApgarFamiliar3').setValue(null);
    Ext.getCmp('strApgarFamiliar4').allowBlank = true;
    Ext.getCmp('strApgarFamiliar4').setValue(null);
    Ext.getCmp('strApgarFamiliar5').allowBlank = true;
    Ext.getCmp('strApgarFamiliar5').setValue(null);
    Ext.getCmp('strApgarFamiliar6').allowBlank = true;
    Ext.getCmp('strApgarFamiliar6').setValue(null);
    Ext.getCmp('strApgarFamiliar7').allowBlank = true;
    Ext.getCmp('strApgarFamiliar7').setValue(null);
    Ext.getCmp('strApgarFamiliar8').allowBlank = true;
    Ext.getCmp('strApgarFamiliar8').setValue(null);
    Ext.getCmp('strApgarFamiliar9').allowBlank = true;
    Ext.getCmp('strApgarFamiliar9').setValue(null);
    
    //PRIMERA INFANCIA
    Ext.getCmp('fsRES202PrimeraInfancia').setVisible(false);
    Ext.getCmp('fsPrimeraInfanciaVale').setVisible(false);
    Ext.getCmp('fsPrimeraInfanciaEAD').setVisible(false);
    Ext.getCmp('strPrimeraInfanciaValeNoSeRealiza').allowBlank = true;
    Ext.getCmp('fecPrimeraInfanciaVale63').allowBlank = true;
    Ext.getCmp('strPrimeraInfanciaVale40').allowBlank = true;
    Ext.getCmp('memPrimeraInfanciaVale').allowBlank = true;
    Ext.getCmp('strPrimeraInfanciaEAD43').allowBlank = true;
    Ext.getCmp('strPrimeraInfanciaEAD44').allowBlank = true;
    Ext.getCmp('strPrimeraInfanciaEAD45').allowBlank = true;
    Ext.getCmp('strPrimeraInfanciaEAD46').allowBlank = true;
    Ext.getCmp('memPrimeraInfanciaEAD3').allowBlank = true;
    Ext.getCmp('strPrimeraInfanciaFortificacionCasera70').allowBlank = true;
    Ext.getCmp('strPrimeraInfanciaVitaminaA71').allowBlank = true;
    Ext.getCmp('strPrimeraInfanciaHierro77').allowBlank = true;
    Ext.getCmp('memPrimeraInfanciaObservaciones').allowBlank = true;
    Ext.getCmp('strPrimeraInfanciaValeNoSeRealiza').setValue(null);
    Ext.getCmp('fecPrimeraInfanciaVale63').setValue(null);
    Ext.getCmp('strPrimeraInfanciaVale40').setValue(null);
    Ext.getCmp('memPrimeraInfanciaVale').setValue(null);
    Ext.getCmp('strPrimeraInfanciaEAD43').setValue(null);
    Ext.getCmp('strPrimeraInfanciaEAD44').setValue(null);
    Ext.getCmp('strPrimeraInfanciaEAD45').setValue(null);
    Ext.getCmp('strPrimeraInfanciaEAD46').setValue(null);
    Ext.getCmp('memPrimeraInfanciaEAD3').setValue(null);
    Ext.getCmp('fsPIMicronutrientes').setVisible(false);
    Ext.getCmp('strPrimeraInfanciaFortificacionCasera70').setValue(null);
    Ext.getCmp('strPrimeraInfanciaVitaminaA71').setValue(null);
    Ext.getCmp('strPrimeraInfanciaHierro77').setValue(null);
    Ext.getCmp('memPrimeraInfanciaObservaciones').setValue(null);
    // FIN PRIMERA INFANCIA
    
    //PRIMERA INFANCIA
    Ext.getCmp('fsRES202Infancia').setVisible(false);
    Ext.getCmp('fsInfanciaVale').setVisible(false);
    Ext.getCmp('fsInfanciaTannerMujer').setVisible(false);
    Ext.getCmp('fsInfanciaTannerHombre').setVisible(false);
    Ext.getCmp('fsInfanciaRQC').setVisible(false);
    Ext.getCmp('strInfanciaValeNoSeRealiza').allowBlank = true;
    Ext.getCmp('fecInfanciaVale63').allowBlank = true;
    Ext.getCmp('strInfanciaVale40').allowBlank = true;
    Ext.getCmp('memInfanciaVale').allowBlank = true;
    Ext.getCmp('strInfanciaTannerMujerMama').allowBlank = true;
    Ext.getCmp('strInfanciaTannerMujerVello').allowBlank = true;
    Ext.getCmp('strInfanciaTannerHombrGenital').allowBlank = true;
    Ext.getCmp('strInfanciaTannerHombreVello').allowBlank = true;
    Ext.getCmp('strInfanciaRQC1').allowBlank = true;
    Ext.getCmp('strInfanciaRQC2').allowBlank = true;
    Ext.getCmp('strInfanciaRQC3').allowBlank = true;
    Ext.getCmp('strInfanciaRQC4').allowBlank = true;
    Ext.getCmp('strInfanciaRQC5').allowBlank = true;
    Ext.getCmp('strInfanciaRQC6').allowBlank = true;
    Ext.getCmp('strInfanciaRQC7').allowBlank = true;
    Ext.getCmp('strInfanciaRQC8').allowBlank = true;
    Ext.getCmp('strInfanciaRQC9').allowBlank = true;
    Ext.getCmp('strInfanciaRQC10').allowBlank = true;
    Ext.getCmp('memInfanciaObservaciones').allowBlank = true;
    Ext.getCmp('strInfanciaValeNoSeRealiza').setValue(null);
    Ext.getCmp('fecInfanciaVale63').setValue(null);
    Ext.getCmp('strInfanciaVale40').setValue(null);
    Ext.getCmp('memInfanciaVale').setValue(null);
    Ext.getCmp('strInfanciaTannerMujerMama').setValue(null);
    Ext.getCmp('strInfanciaTannerMujerVello').setValue(null);
    Ext.getCmp('strInfanciaTannerHombrGenital').setValue(null);
    Ext.getCmp('strInfanciaTannerHombreVello').setValue(null);
    Ext.getCmp('strInfanciaRQC1').setValue(null);
    Ext.getCmp('strInfanciaRQC2').setValue(null);
    Ext.getCmp('strInfanciaRQC3').setValue(null);
    Ext.getCmp('strInfanciaRQC4').setValue(null);
    Ext.getCmp('strInfanciaRQC5').setValue(null);
    Ext.getCmp('strInfanciaRQC6').setValue(null);
    Ext.getCmp('strInfanciaRQC7').setValue(null);
    Ext.getCmp('strInfanciaRQC8').setValue(null);
    Ext.getCmp('strInfanciaRQC9').setValue(null);
    Ext.getCmp('strInfanciaRQC10').setValue(null);
    Ext.getCmp('memInfanciaObservaciones').setValue(null);
    // FIN INFANCIA
    
    // TABAQUISMO
    Ext.getCmp('fsRES202Tabaquismo').setVisible(false);
    Ext.getCmp('strResultadoConsumoTabaco').allowBlank = true;
    Ext.getCmp('strResultadoConsumoTabaco').setValue(null);
    Ext.getCmp('memConsumoTabacoObservaciones').allowBlank = true;
    Ext.getCmp('memConsumoTabacoObservaciones').setValue(null);
    
    //ADOLESCENCIA
    Ext.getCmp('fsRES202Adolescencia').setVisible(false);
    Ext.getCmp('fsAdolescenciaVale').setVisible(false);
    Ext.getCmp('fsAdolescenciaTannerMujer').setVisible(false);
    Ext.getCmp('fsAdolescenciaTannerHombre').setVisible(false);
    Ext.getCmp('fsAdolescenciaRQC').setVisible(false);
    Ext.getCmp('fsAdolescenciaSRQ').setVisible(false);
    Ext.getCmp('strAdolescenciaValeNoSeRealiza').allowBlank = true;
    Ext.getCmp('fecAdolescenciaVale63').allowBlank = true;
    Ext.getCmp('strAdolescenciaVale40').allowBlank = true;
    Ext.getCmp('memAdolescenciaVale').allowBlank = true;
    Ext.getCmp('strAdolescenciaTannerMujerMama').allowBlank = true;
    Ext.getCmp('strAdolescenciaTannerMujerVello').allowBlank = true;
    Ext.getCmp('strAdolescenciaTannerHombrGenital').allowBlank = true;
    Ext.getCmp('strAdolescenciaTannerHombreVello').allowBlank = true;
    Ext.getCmp('strAdolecenciaRQC1').allowBlank = true;
    Ext.getCmp('strAdolecenciaRQC2').allowBlank = true;
    Ext.getCmp('strAdolecenciaRQC3').allowBlank = true;
    Ext.getCmp('strAdolecenciaRQC4').allowBlank = true;
    Ext.getCmp('strAdolecenciaRQC5').allowBlank = true;
    Ext.getCmp('strAdolecenciaRQC6').allowBlank = true;
    Ext.getCmp('strAdolecenciaRQC7').allowBlank = true;
    Ext.getCmp('strAdolecenciaRQC8').allowBlank = true;
    Ext.getCmp('strAdolecenciaRQC9').allowBlank = true;
    Ext.getCmp('strAdolecenciaRQC10').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ1').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ2').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ3').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ4').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ5').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ6').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ7').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ8').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ9').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ10').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ11').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ12').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ13').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ14').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ15').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ16').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ17').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ18').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ19').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ20').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ21').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ22').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ23').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ24').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ25').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ26').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ27').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ28').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ29').allowBlank = true;
    Ext.getCmp('strAdolecenciaSRQ30').allowBlank = true;
    Ext.getCmp('memAdolescenciaObservaciones').allowBlank = true;
    Ext.getCmp('strAdolescenciaValeNoSeRealiza').setValue(null);
    Ext.getCmp('fecAdolescenciaVale63').setValue(null);
    Ext.getCmp('strAdolescenciaVale40').setValue(null);
    Ext.getCmp('memAdolescenciaVale').setValue(null);
    Ext.getCmp('strAdolescenciaTannerMujerMama').setValue(null);
    Ext.getCmp('strAdolescenciaTannerMujerVello').setValue(null);
    Ext.getCmp('strAdolescenciaTannerHombrGenital').setValue(null);
    Ext.getCmp('strAdolescenciaTannerHombreVello').setValue(null);
    Ext.getCmp('strAdolecenciaRQC1').setValue(null);
    Ext.getCmp('strAdolecenciaRQC2').setValue(null);
    Ext.getCmp('strAdolecenciaRQC3').setValue(null);
    Ext.getCmp('strAdolecenciaRQC4').setValue(null);
    Ext.getCmp('strAdolecenciaRQC5').setValue(null);
    Ext.getCmp('strAdolecenciaRQC6').setValue(null);
    Ext.getCmp('strAdolecenciaRQC7').setValue(null);
    Ext.getCmp('strAdolecenciaRQC8').setValue(null);
    Ext.getCmp('strAdolecenciaRQC9').setValue(null);
    Ext.getCmp('strAdolecenciaRQC10').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ1').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ2').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ3').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ4').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ5').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ6').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ7').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ8').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ9').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ10').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ11').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ12').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ13').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ14').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ15').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ16').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ17').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ18').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ19').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ20').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ21').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ22').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ23').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ24').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ25').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ26').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ27').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ28').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ29').setValue(null);
    Ext.getCmp('strAdolecenciaSRQ30').setValue(null);
    Ext.getCmp('memAdolescenciaObservaciones').setValue(null);
    //FIN ADOLESCENCIA
    
    //JUVENTUD
    Ext.getCmp('fsRES202Juventud').setVisible(false);
    Ext.getCmp('memJuventudObservaciones').allowBlank = true;
    Ext.getCmp('memJuventudObservaciones').setValue(null);
    //FIN JUVENTUD
    
    //ADULTEZ
    Ext.getCmp('fsRES202Adultez').setVisible(false);
    Ext.getCmp('memAdultezObservaciones').allowBlank = true;
    Ext.getCmp('memAdultezObservaciones').setValue(null);
    //FIN ADULTEZ
    
    //VEJEZ
    Ext.getCmp('fsRES202Vejez').setVisible(false);
    Ext.getCmp('memVejezObservaciones').allowBlank = true;
    Ext.getCmp('memVejezObservaciones').setValue(null);
    //FIN VEJEZ
    
    //TACTO RECTAL
    Ext.getCmp('fsRES202TactoRectal').setVisible(false);
    Ext.getCmp('strResultadoTactoRectal').allowBlank = true;
    Ext.getCmp('strResultadoTactoRectal').setValue(null);
    Ext.getCmp('memTactoRectalObservaciones').allowBlank = true;
    Ext.getCmp('memTactoRectalObservaciones').setValue(null);
    //TACTO RECTAL
    
    //FINDRISK
    Ext.getCmp('fsFindRisk').setVisible(false);
    Ext.getCmp('strFINDRISCRangoEdad').allowBlank = true;
    Ext.getCmp('strFINDRISCIMC').allowBlank = true;
    Ext.getCmp('strFINDRISCPC').allowBlank = true;
    Ext.getCmp('strFINDRISCEjercicio').allowBlank = true;
    Ext.getCmp('strFINDRISCConsumoVejetales').allowBlank = true;
    Ext.getCmp('strFINDRISCMedicamentosHTA').allowBlank = true;
    Ext.getCmp('strFINDRISCGlucosaAlterada').allowBlank = true;
    Ext.getCmp('strFINDRISCAntecedentesDM').allowBlank = true;
    Ext.getCmp('strFINDRISCPuntajeTotal').allowBlank = true;
    Ext.getCmp('strFINDRISCRangoEdad').setValue(null);
    Ext.getCmp('strFINDRISCIMC').setValue(null);
    Ext.getCmp('strFINDRISCPC').setValue(null);
    Ext.getCmp('strFINDRISCEjercicio').setValue(null);
    Ext.getCmp('strFINDRISCConsumoVejetales').setValue(null);
    Ext.getCmp('strFINDRISCMedicamentosHTA').setValue(null);
    Ext.getCmp('strFINDRISCGlucosaAlterada').setValue(null);
    Ext.getCmp('strFINDRISCAntecedentesDM').setValue(null);
    Ext.getCmp('strFINDRISCPuntajeTotal').setValue(null);
    //FIN FINDRISK
    
    //FRAMINGHAM
    Ext.getCmp('fsFramingham').setVisible(false);
    Ext.getCmp('strFRAMINGHAMPuntuacion').allowBlank = true;
    Ext.getCmp('strFRAMINGHAMRiesgo').allowBlank = true;
    Ext.getCmp('strFRAMINGHAMPuntuacion').setValue(null);
    Ext.getCmp('strFRAMINGHAMRiesgo').setValue(null);
    // FIN FRAMINGHAM
    
    //BARTHEL
    Ext.getCmp('fsBarthel').setVisible(false);
    Ext.getCmp('strBarthelComer').allowBlank = true;
    Ext.getCmp('intBarthelComerPto').allowBlank = true;
    Ext.getCmp('strBarthelComerDes').allowBlank = true;
    Ext.getCmp('strBarthelLavarse').allowBlank = true;
    Ext.getCmp('intBarthelLavarsePto').allowBlank = true;
    Ext.getCmp('strBarthelLavarseDes').allowBlank = true;
    Ext.getCmp('strBarthelVestirse').allowBlank = true;
    Ext.getCmp('intBarthelVestirsePto').allowBlank = true;
    Ext.getCmp('strBarthelVestirseDes').allowBlank = true;
    Ext.getCmp('strBarthelArreglarse').allowBlank = true;
    Ext.getCmp('intBarthelArreglarsePto').allowBlank = true;
    Ext.getCmp('strBarthelArreglarseDes').allowBlank = true;
    Ext.getCmp('strBarthelDeposiciones').allowBlank = true;
    Ext.getCmp('intBarthelDeposicionesPto').allowBlank = true;
    Ext.getCmp('strBarthelDeposicionesDes').allowBlank = true;
    Ext.getCmp('strBarthelMiccion').allowBlank = true;
    Ext.getCmp('intBarthelMiccionPto').allowBlank = true;
    Ext.getCmp('strBarthelMiccionDes').allowBlank = true;
    Ext.getCmp('strBarthelRetrete').allowBlank = true;
    Ext.getCmp('intBarthelRetretePto').allowBlank = true;
    Ext.getCmp('strBarthelRetreteDes').allowBlank = true;
    Ext.getCmp('strBarthelTraslado').allowBlank = true;
    Ext.getCmp('intBarthelTrasladoPto').allowBlank = true;
    Ext.getCmp('strBarthelTrasladoDes').allowBlank = true;
    Ext.getCmp('strBarthelDeambular').allowBlank = true;
    Ext.getCmp('intBarthelDeambularPto').allowBlank = true;
    Ext.getCmp('strBarthelDeambularDes').allowBlank = true;
    Ext.getCmp('strBarthelEscalones').allowBlank = true;
    Ext.getCmp('intBarthelEscalonesPto').allowBlank = true;
    Ext.getCmp('strBarthelEscalonesDes').allowBlank = true;
    Ext.getCmp('intBarthelTotal').allowBlank = true;
    Ext.getCmp('sysvCalsifica').allowBlank = true;
    Ext.getCmp('strBarthelValoracion').allowBlank = true;
    Ext.getCmp('strBarthelComer').setValue(null);
    Ext.getCmp('intBarthelComerPto').setValue(null);
    Ext.getCmp('strBarthelComerDes').setValue(null);
    Ext.getCmp('strBarthelLavarse').setValue(null);
    Ext.getCmp('intBarthelLavarsePto').setValue(null);
    Ext.getCmp('strBarthelLavarseDes').setValue(null);
    Ext.getCmp('strBarthelVestirse').setValue(null);
    Ext.getCmp('intBarthelVestirsePto').setValue(null);
    Ext.getCmp('strBarthelVestirseDes').setValue(null);
    Ext.getCmp('strBarthelArreglarse').setValue(null);
    Ext.getCmp('intBarthelArreglarsePto').setValue(null);
    Ext.getCmp('strBarthelArreglarseDes').setValue(null);
    Ext.getCmp('strBarthelDeposiciones').setValue(null);
    Ext.getCmp('intBarthelDeposicionesPto').setValue(null);
    Ext.getCmp('strBarthelDeposicionesDes').setValue(null);
    Ext.getCmp('strBarthelMiccion').setValue(null);
    Ext.getCmp('intBarthelMiccionPto').setValue(null);
    Ext.getCmp('strBarthelMiccionDes').setValue(null);
    Ext.getCmp('strBarthelRetrete').setValue(null);
    Ext.getCmp('intBarthelRetretePto').setValue(null);
    Ext.getCmp('strBarthelRetreteDes').setValue(null);
    Ext.getCmp('strBarthelTraslado').setValue(null);
    Ext.getCmp('intBarthelTrasladoPto').setValue(null);
    Ext.getCmp('strBarthelTrasladoDes').setValue(null);
    Ext.getCmp('strBarthelDeambular').setValue(null);
    Ext.getCmp('intBarthelDeambularPto').setValue(null);
    Ext.getCmp('strBarthelDeambularDes').setValue(null);
    Ext.getCmp('strBarthelEscalones').setValue(null);
    Ext.getCmp('intBarthelEscalonesPto').setValue(null);
    Ext.getCmp('strBarthelEscalonesDes').setValue(null);
    Ext.getCmp('intBarthelTotal').setValue(null);
    Ext.getCmp('sysvCalsifica').setValue(null);
    Ext.getCmp('strBarthelValoracion').setValue(null);
    //FIN BARTHEL
    
    //FIN LAWTON
    Ext.getCmp('fsLawton').setVisible(false);
    Ext.getCmp('syspn1').allowBlank = true;
    Ext.getCmp('syspn2').allowBlank = true;
    Ext.getCmp('syspn3').allowBlank = true;
    Ext.getCmp('syspn4').allowBlank = true;
    Ext.getCmp('syspn5').allowBlank = true;
    Ext.getCmp('bolLawton1NoHace').allowBlank = true;
    Ext.getCmp('bolLawton1SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton1ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton1ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton1NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton2NoHace').allowBlank = true;
    Ext.getCmp('bolLawton2SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton2ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton2ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton2NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton3NoHace').allowBlank = true;
    Ext.getCmp('bolLawton3SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton3ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton3ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton3NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton4NoHace').allowBlank = true;
    Ext.getCmp('bolLawton4SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton4ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton4ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton4NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton5NoHace').allowBlank = true;
    Ext.getCmp('bolLawton5SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton5ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton5ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton5NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton6NoHace').allowBlank = true;
    Ext.getCmp('bolLawton6SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton6ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton6ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton6NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton7NoHace').allowBlank = true;
    Ext.getCmp('bolLawton7SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton7ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton7ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton7NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton8NoHace').allowBlank = true;
    Ext.getCmp('bolLawton8SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton8ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton8ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton8NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton9NoHace').allowBlank = true;
    Ext.getCmp('bolLawton9SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton9ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton9ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton9NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton10NoHace').allowBlank = true;
    Ext.getCmp('bolLawton10SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton10ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton10ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton10NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton11NoHace').allowBlank = true;
    Ext.getCmp('bolLawton11SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton11ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton11ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton11NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton12NoHace').allowBlank = true;
    Ext.getCmp('bolLawton12SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton12ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton12ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton12NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton13NoHace').allowBlank = true;
    Ext.getCmp('bolLawton13SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton13ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton13ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton13NoEvaluable').allowBlank = true;
    Ext.getCmp('bolLawton14NoHace').allowBlank = true;
    Ext.getCmp('bolLawton14SinDificultad').allowBlank = true;
    Ext.getCmp('bolLawton14ConDificultad').allowBlank = true;
    Ext.getCmp('bolLawton14ConAyuda').allowBlank = true;
    Ext.getCmp('bolLawton14NoEvaluable').allowBlank = true;
    Ext.getCmp('intLawtonTotalNoHace').allowBlank = true;
    Ext.getCmp('intLawtonTotalSinDificultad').allowBlank = true;
    Ext.getCmp('intLawtonTotalConDificultad').allowBlank = true;
    Ext.getCmp('intLawtonTotalConAyuda').allowBlank = true;
    Ext.getCmp('intLawtonTotalNoEvaluable').allowBlank = true;
    Ext.getCmp('strLawtonValoracion').allowBlank = true;
    Ext.getCmp('syspn1').setValue(null);
    Ext.getCmp('syspn2').setValue(null);
    Ext.getCmp('syspn3').setValue(null);
    Ext.getCmp('syspn4').setValue(null);
    Ext.getCmp('syspn5').setValue(null);
    Ext.getCmp('bolLawton1NoHace').setValue(null);
    Ext.getCmp('bolLawton1SinDificultad').setValue(null);
    Ext.getCmp('bolLawton1ConDificultad').setValue(null);
    Ext.getCmp('bolLawton1ConAyuda').setValue(null);
    Ext.getCmp('bolLawton1NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton2NoHace').setValue(null);
    Ext.getCmp('bolLawton2SinDificultad').setValue(null);
    Ext.getCmp('bolLawton2ConDificultad').setValue(null);
    Ext.getCmp('bolLawton2ConAyuda').setValue(null);
    Ext.getCmp('bolLawton2NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton3NoHace').setValue(null);
    Ext.getCmp('bolLawton3SinDificultad').setValue(null);
    Ext.getCmp('bolLawton3ConDificultad').setValue(null);
    Ext.getCmp('bolLawton3ConAyuda').setValue(null);
    Ext.getCmp('bolLawton3NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton4NoHace').setValue(null);
    Ext.getCmp('bolLawton4SinDificultad').setValue(null);
    Ext.getCmp('bolLawton4ConDificultad').setValue(null);
    Ext.getCmp('bolLawton4ConAyuda').setValue(null);
    Ext.getCmp('bolLawton4NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton5NoHace').setValue(null);
    Ext.getCmp('bolLawton5SinDificultad').setValue(null);
    Ext.getCmp('bolLawton5ConDificultad').setValue(null);
    Ext.getCmp('bolLawton5ConAyuda').setValue(null);
    Ext.getCmp('bolLawton5NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton6NoHace').setValue(null);
    Ext.getCmp('bolLawton6SinDificultad').setValue(null);
    Ext.getCmp('bolLawton6ConDificultad').setValue(null);
    Ext.getCmp('bolLawton6ConAyuda').setValue(null);
    Ext.getCmp('bolLawton6NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton7NoHace').setValue(null);
    Ext.getCmp('bolLawton7SinDificultad').setValue(null);
    Ext.getCmp('bolLawton7ConDificultad').setValue(null);
    Ext.getCmp('bolLawton7ConAyuda').setValue(null);
    Ext.getCmp('bolLawton7NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton8NoHace').setValue(null);
    Ext.getCmp('bolLawton8SinDificultad').setValue(null);
    Ext.getCmp('bolLawton8ConDificultad').setValue(null);
    Ext.getCmp('bolLawton8ConAyuda').setValue(null);
    Ext.getCmp('bolLawton8NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton9NoHace').setValue(null);
    Ext.getCmp('bolLawton9SinDificultad').setValue(null);
    Ext.getCmp('bolLawton9ConDificultad').setValue(null);
    Ext.getCmp('bolLawton9ConAyuda').setValue(null);
    Ext.getCmp('bolLawton9NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton10NoHace').setValue(null);
    Ext.getCmp('bolLawton10SinDificultad').setValue(null);
    Ext.getCmp('bolLawton10ConDificultad').setValue(null);
    Ext.getCmp('bolLawton10ConAyuda').setValue(null);
    Ext.getCmp('bolLawton10NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton11NoHace').setValue(null);
    Ext.getCmp('bolLawton11SinDificultad').setValue(null);
    Ext.getCmp('bolLawton11ConDificultad').setValue(null);
    Ext.getCmp('bolLawton11ConAyuda').setValue(null);
    Ext.getCmp('bolLawton11NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton12NoHace').setValue(null);
    Ext.getCmp('bolLawton12SinDificultad').setValue(null);
    Ext.getCmp('bolLawton12ConDificultad').setValue(null);
    Ext.getCmp('bolLawton12ConAyuda').setValue(null);
    Ext.getCmp('bolLawton12NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton13NoHace').setValue(null);
    Ext.getCmp('bolLawton13SinDificultad').setValue(null);
    Ext.getCmp('bolLawton13ConDificultad').setValue(null);
    Ext.getCmp('bolLawton13ConAyuda').setValue(null);
    Ext.getCmp('bolLawton13NoEvaluable').setValue(null);
    Ext.getCmp('bolLawton14NoHace').setValue(null);
    Ext.getCmp('bolLawton14SinDificultad').setValue(null);
    Ext.getCmp('bolLawton14ConDificultad').setValue(null);
    Ext.getCmp('bolLawton14ConAyuda').setValue(null);
    Ext.getCmp('bolLawton14NoEvaluable').setValue(null);
    Ext.getCmp('intLawtonTotalNoHace').setValue(null);
    Ext.getCmp('intLawtonTotalSinDificultad').setValue(null);
    Ext.getCmp('intLawtonTotalConDificultad').setValue(null);
    Ext.getCmp('intLawtonTotalConAyuda').setValue(null);
    Ext.getCmp('intLawtonTotalNoEvaluable').setValue(null);
    Ext.getCmp('strLawtonValoracion').setValue(null);
    //FIN LAWTON
    
    //MINIMENTAL
    Ext.getCmp('fsMiniMental').setVisible(false);
    Ext.getCmp('fsOrientacion').setVisible(false);
    Ext.getCmp('fsFijacion').setVisible(false);
    Ext.getCmp('fsAteCalculo').setVisible(false);
    Ext.getCmp('fsMemoria').setVisible(false);
    Ext.getCmp('fsLenPraxias').setVisible(false);
    Ext.getCmp('intMinimentalOriFecha').allowBlank = true;
    Ext.getCmp('intMinimentalOriDiaSemana').allowBlank = true;
    Ext.getCmp('intMinimentalOriDiaSemana').allowBlank = true;
    Ext.getCmp('intMinimentalOriDiaSemana').allowBlank = true;
    Ext.getCmp('intMinimentalOriAno').allowBlank = true;
    Ext.getCmp('intMinimentalOriManTarde').allowBlank = true;
    Ext.getCmp('intMinimentalOriPais').allowBlank = true;
    Ext.getCmp('intMinimentalOriDepartamento').allowBlank = true;
    Ext.getCmp('intMinimentalOriCiudad').allowBlank = true;
    Ext.getCmp('intMinimentalOriCenAteAmbulatoria').allowBlank = true;
    Ext.getCmp('intMinimentalOriServicio').allowBlank = true;
    Ext.getCmp('intMinimentalOriManTarde').allowBlank = true;
    Ext.getCmp('intMinimentalFijSilla').allowBlank = true;
    Ext.getCmp('intMinimentalFijSilla').allowBlank = true;
    Ext.getCmp('intMinimentalFijPared').allowBlank = true;
    Ext.getCmp('intMinimentalFijNumIntentos').allowBlank = true;
    Ext.getCmp('intMinimentalAteCalCuaQuedan').allowBlank = true;
    Ext.getCmp('intMinimentalAteCalMunReves').allowBlank = true;
    Ext.getCmp('intMinimentalMemRecTrePalabras').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraMuesPacLapReloj').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraTigConTig').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraEjeOrdTrePasos').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraLeaObeSigOrden').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraEscFrase').allowBlank = true;
    Ext.getCmp('intMinimentalLenPraCopDibujo').allowBlank = true;
    Ext.getCmp('intMinimentalOriFecha').setValue(null);
    Ext.getCmp('intMinimentalOriDiaSemana').setValue(null);
    Ext.getCmp('intMinimentalOriDiaSemana').setValue(null);
    Ext.getCmp('intMinimentalOriDiaSemana').setValue(null);
    Ext.getCmp('intMinimentalOriAno').setValue(null);
    Ext.getCmp('intMinimentalOriManTarde').setValue(null);
    Ext.getCmp('intMinimentalOriPais').setValue(null);
    Ext.getCmp('intMinimentalOriDepartamento').setValue(null);
    Ext.getCmp('intMinimentalOriCiudad').setValue(null);
    Ext.getCmp('intMinimentalOriCenAteAmbulatoria').setValue(null);
    Ext.getCmp('intMinimentalOriServicio').setValue(null);
    Ext.getCmp('intMinimentalOriManTarde').setValue(null);
    Ext.getCmp('intMinimentalFijSilla').setValue(null);
    Ext.getCmp('intMinimentalFijSilla').setValue(null);
    Ext.getCmp('intMinimentalFijPared').setValue(null);
    Ext.getCmp('intMinimentalFijNumIntentos').setValue(null);
    Ext.getCmp('intMinimentalAteCalCuaQuedan').setValue(null);
    Ext.getCmp('intMinimentalAteCalMunReves').setValue(null);
    Ext.getCmp('intMinimentalMemRecTrePalabras').setValue(null);
    Ext.getCmp('intMinimentalLenPraMuesPacLapReloj').setValue(null);
    Ext.getCmp('intMinimentalLenPraTigConTig').setValue(null);
    Ext.getCmp('intMinimentalLenPraEjeOrdTrePasos').setValue(null);
    Ext.getCmp('intMinimentalLenPraLeaObeSigOrden').setValue(null);
    Ext.getCmp('intMinimentalLenPraEscFrase').setValue(null);
    Ext.getCmp('intMinimentalLenPraCopDibujo').setValue(null);
    //FIN MINIMENTAL
}

function validarNeonatal(){
    if(parseInt(parseInt(localStorage.getItem('Anios'))) === 0 && parseInt(localStorage.getItem('Meses')) <= 30){
        Ext.getCmp('fsRES202Neonatal').setVisible(true);
        Ext.getCmp('fecNeonatalTamizajeAuditivo69').allowBlank = false;
        Ext.getCmp('strNeonatalTamizajeAuditivo37').allowBlank = false;
        Ext.getCmp('fecNeonatalTamizajeVisual75').allowBlank = false;
        Ext.getCmp('strNeonatalTamizajeVisual38').allowBlank = false;
        Ext.getCmp('sysres202_ControlRecienNacido').setValue(21);
        Ext.getCmp('sysNeonatalTamizaAuditivoFec').setValue("1800-01-01");
        Ext.getCmp('sysNeonatalTamizaAuditivoRes').setValue("21 - Riesgo no evaluado");
        Ext.getCmp('sysNeonatalTamizaVisualFec').setValue("1800-01-01");
        Ext.getCmp('sysNeonatalTamizaVisualRes').setValue("21 - Riesgo no evaluado");
        
        Ext.Ajax.request({
            url: '../../controlador/asistencial/controlador_2022.php',
            waitMsg: 'Cargando Información...',
            params:{
                pPaciente: wPaciente,
                task: 'UltimaAtencionRecienNacido'
            },
            success: function(result, request){
                var jsonData = Ext.util.JSON.decode(result.responseText);
                const resp = jsonData.map( item => {
                    return {
                        ...item
                    };
                });
                
                resp.forEach(item => {
                    if(parseInt(item.Dias) > 30){
                        Ext.getCmp('fsRES202Neonatal').setVisible(false);
                        Ext.getCmp('fecNeonatalTamizajeAuditivo69').allowBlank = true;
                        Ext.getCmp('strNeonatalTamizajeAuditivo37').allowBlank = true;
                        Ext.getCmp('fecNeonatalTamizajeVisual75').allowBlank = true;
                        Ext.getCmp('strNeonatalTamizajeVisual38').allowBlank = true;
                        Ext.getCmp('fecNeonatalTamizajeAuditivo69').setValue(null);
                        Ext.getCmp('strNeonatalTamizajeAuditivo37').setValue(null);
                        Ext.getCmp('fecNeonatalTamizajeVisual75').setValue(null);
                        Ext.getCmp('strNeonatalTamizajeVisual38').setValue(null);
                        Ext.getCmp('sysres202_ControlRecienNacido').setValue(0);
                        Ext.getCmp('sysNeonatalTamizaAuditivoFec').setValue("1845-01-01");
                        Ext.getCmp('sysNeonatalTamizaAuditivoRes').setValue("0 - No aplica");
                        Ext.getCmp('sysNeonatalTamizaVisualFec').setValue("1845-01-01");
                        Ext.getCmp('sysNeonatalTamizaVisualRes').setValue("0 - No aplica");
                        exit;
                    }
                });
            },
            scope:this
        });
        
    }else{
        Ext.getCmp('fsRES202Neonatal').setVisible(false);
        Ext.getCmp('fecNeonatalTamizajeAuditivo69').allowBlank = true;
        Ext.getCmp('strNeonatalTamizajeAuditivo37').allowBlank = true;
        Ext.getCmp('fecNeonatalTamizajeVisual75').allowBlank = true;
        Ext.getCmp('strNeonatalTamizajeVisual38').allowBlank = true;
        Ext.getCmp('fecNeonatalTamizajeAuditivo69').setValue(null);
        Ext.getCmp('strNeonatalTamizajeAuditivo37').setValue(null);
        Ext.getCmp('fecNeonatalTamizajeVisual75').setValue(null);
        Ext.getCmp('strNeonatalTamizajeVisual38').setValue(null);
        Ext.getCmp('sysres202_ControlRecienNacido').setValue(0);
        Ext.getCmp('sysNeonatalTamizaAuditivoFec').setValue("1845-01-01");
        Ext.getCmp('sysNeonatalTamizaAuditivoRes').setValue("0 - No aplica");
        Ext.getCmp('sysNeonatalTamizaVisualFec').setValue("1845-01-01");
        Ext.getCmp('sysNeonatalTamizaVisualRes').setValue("0 - No aplica");
    }
}

function validarPrimeraInfancia(){
    if(parseInt(parseInt(localStorage.getItem('Anios'))) <= 5){
        Ext.getCmp('fsRES202PrimeraInfancia').setVisible(true);  
        Ext.getCmp('strPrimeraInfanciaValeNoSeRealiza').allowBlank = false;
        Ext.getCmp('fecPrimeraInfanciaVale63').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaVale40').allowBlank = false;
        Ext.getCmp('memPrimeraInfanciaVale').allowBlank = false;
        Ext.getCmp('fsPrimeraInfanciaEAD').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaEAD43').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaEAD44').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaEAD45').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaEAD46').allowBlank = false;
        Ext.getCmp('memPrimeraInfanciaEAD3').allowBlank = false;
        Ext.getCmp('fsPIMicronutrientes').setVisible(true);  
        Ext.getCmp('strPrimeraInfanciaFortificacionCasera70').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaVitaminaA71').allowBlank = false;
        Ext.getCmp('strPrimeraInfanciaHierro77').allowBlank = false;
        Ext.getCmp('memPrimeraInfanciaObservaciones').allowBlank = false;
    }else{
        Ext.getCmp('fsRES202PrimeraInfancia').setVisible(false);  
        Ext.getCmp('strPrimeraInfanciaValeNoSeRealiza').allowBlank = true;
        Ext.getCmp('strPrimeraInfanciaValeNoSeRealiza').setValue(null);
        Ext.getCmp('fecPrimeraInfanciaVale63').allowBlank = true;
        Ext.getCmp('fecPrimeraInfanciaVale63').setValue(null);
        Ext.getCmp('strPrimeraInfanciaVale40').allowBlank = true;
        Ext.getCmp('strPrimeraInfanciaVale40').setValue(null);
        Ext.getCmp('memPrimeraInfanciaVale').allowBlank = true;
        Ext.getCmp('memPrimeraInfanciaVale').setValue(null);
        Ext.getCmp('strPrimeraInfanciaEAD43').allowBlank = true;
        Ext.getCmp('strPrimeraInfanciaEAD43').setValue(null);
        Ext.getCmp('strPrimeraInfanciaEAD44').allowBlank = true;
        Ext.getCmp('strPrimeraInfanciaEAD44').setValue(null);
        Ext.getCmp('strPrimeraInfanciaEAD45').allowBlank = true;
        Ext.getCmp('strPrimeraInfanciaEAD45').setValue(null);
        Ext.getCmp('strPrimeraInfanciaEAD46').allowBlank = true;
        Ext.getCmp('strPrimeraInfanciaEAD46').setValue(null);
        Ext.getCmp('memPrimeraInfanciaEAD3').allowBlank = true;
        Ext.getCmp('memPrimeraInfanciaEAD3').setValue(null);
        Ext.getCmp('fsPIMicronutrientes').setVisible(false);  
        Ext.getCmp('strPrimeraInfanciaFortificacionCasera70').allowBlank = true;
        Ext.getCmp('strPrimeraInfanciaFortificacionCasera70').setValue(null);
        Ext.getCmp('strPrimeraInfanciaVitaminaA71').allowBlank = true;
        Ext.getCmp('strPrimeraInfanciaVitaminaA71').setValue(null);
        Ext.getCmp('strPrimeraInfanciaHierro77').allowBlank = true;
        Ext.getCmp('strPrimeraInfanciaHierro77').setValue(null);
        Ext.getCmp('memPrimeraInfanciaObservaciones').allowBlank = true;
        Ext.getCmp('memPrimeraInfanciaObservaciones').setValue(null);
    }

}
