/*
* @category    Formulario Grid Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmVerAgendaUi = Ext.extend(Ext.Window, {
    //title: 'OfiClinic© Web..! .:: Agenda por Profesional ::.',
    id: 'winFrmVerAgenda',
    closable:false,
    draggable : false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    padding: 5,
    frame: true,
    layout: 'form',
    initComponent: function() {
        function VerHoraLegaliza(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            return '<p style="color: red; font-weight:bold; text-decoration:blink; text-align:center;">'+value + '</p>Hora Estimada Atención: </br>' + record.get('HoraAtencion');
	}
        
        function VerPaciente(value, metaData, record, rowIndex, colIndex, store){  
            //metaData.attr = 'style="white-space:normal"';  
            //return '<p>' + record.get('TipDoc') + '-' + record.get('Documento') + '</br>' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre') + ' ' + record.get('PrimerApellido') + ' ' + record.get('SegundoApellido') + '</br>Genero: ' + record.get('Genero') + ' FecNac: ' + record.get('FecNac') + '</br>' + record.get('Edad');  
            var newEdad = "";
            if (record.get('FecNac') !== null && record.get('FecNac') !== ""){
                var xfecnac = Array();
                xfecnac = record.get('FecNac').split('/');
                var dianac = xfecnac[0];
                var mesnac = (xfecnac[1].length < 2)?'0':'';
                mesnac += xfecnac[1];
                var anonac = xfecnac[2];
                var newFecNac = anonac + "/" + mesnac + "/" + dianac;
                newEdad = MostrarEdadCompleta(record.get('FechaCita'),newFecNac);
                //alert("Fecha Cita: " + record.get('FechaCita') + " - FechaNac: " + newFecNac);
            }
            metaData.attr = 'style="white-space:normal"';  
            return '<p>' + record.get('TipDoc') + '-' + record.get('Documento') + '</br>' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre') + ' ' + record.get('PrimerApellido') + ' ' + record.get('SegundoApellido') + '</br>Genero: ' + record.get('Genero') + ' FecNac: ' + record.get('FecNac') + '</br>' + newEdad;  
        }
        
        function VerCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('DescAdiHora');  
        }
        
        function VerCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('Cliente') + '</br>' + record.get('Actividad') + '</br>Programa: ' + record.get('Programa');  
        }
        
        var mybbar = new utilBbarUi();
        var stGrid = new StoreGridCitasxEvolucionar();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'combo',
                fieldLabel: 'Profesional',
                allowBlank: true,
                store: 'StoreVerAgendaProfesionales',
                forceSelection: true,
                triggerAction: 'all',
                mode: 'local',
                typeAhead: true,
                typeAheadDelay: 50,
                emptyText: 'Seleccione Profesional....',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                anchor: '100%',
                submitValue: true,
                id: 'sysProfeAgenda'
            },
            {
                xtype: 'combo',
                fieldLabel: 'Ubicación',
                allowBlank: true,
                store: 'StoreVerUbicacionAgenda',
                forceSelection: true,
                triggerAction: 'all',
                mode: 'local',
                typeAhead: true,
                typeAheadDelay: 50,
                emptyText: 'Seleccione Ubicacion....',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                anchor: '100%',
                submitValue: true,
                disabled: true,
                id: 'sysUbicacionAgenda'
            },
            {
                xtype: 'combo',
                fieldLabel: 'Fecha Agenda',
                allowBlank: true,
                store: 'StoreVerFechasAgenda',
                forceSelection: true,
                triggerAction: 'all',
                mode: 'local',
                typeAhead: true,
                typeAheadDelay: 50,
                emptyText: 'Seleccione Fecha....',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                anchor: '100%',
                submitValue: true,
                disabled: true,
                id: 'sysFechaAgenda'
            },
            {
                xtype: 'grid',
                id: 'gridFormulario',
                store: stGrid,
                anchor: "100%",
                height: 335,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        header: 'CAS',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'CAS',
                        width: 100,
                        hideable: false
                    },
                    {
                        header: 'Hora',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'HoraAgenda',
                        renderer: VerCita,
                        width: 110,
                        hideable: false
                    },
                    {
                        header: 'Hora Legalización',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'FechaLegaliza',
                        width: 130,
                        renderer: VerHoraLegaliza,
                        hideable: false
                    },
                    {
                        header: 'Paciente',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Paciente',
                        width: 330,
                        renderer: VerPaciente,
                        hideable: false
                    },
                    {
                        header: 'Cliente',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Cliente',
                        width: 250,
                        renderer: VerCliente,
                        hideable: false
                    }
                ]),
                //selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                //view: new Ext.ux.grid.LockingGridView(),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.ux.grid.LockingGridView({
                    getRowClass: function(record, index, rowParams, store){
                        var estado = record.data.YaEvolucionado;
                        switch(estado){
                            case "1":
                                return "Apto";
                                break;
                            default:
                                //return "NoActivo";
                                break;
                        }
                    }
                }),
                columnLines: true,
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Actualizar Agenda',
                                iconCls: 'btnActualizarGrid',
                                tooltip: 'Actualizar Agenda',
                                id: 'btnActualizarAgenda'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'tbfill'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Legalizar Cita',
                                iconCls: 'btnAsignarCita',
                                tooltip: 'Legalizar la Cita Seleccionada',
                                id: 'btnLegalizarCita'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Cancelar Cita',
                                iconCls: 'btnAsignarCita',
                                tooltip: 'Cancelar la Cita Seleccionada',
                                id: 'btnCancelarCita'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Marcar Cita Inasistente',
                                iconCls: 'btnAsignarCita',
                                tooltip: 'Marcar Inasistente la Cita Seleccionada',
                                id: 'btnInasistenciaCita'
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    },
                bbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Evolucionar Paciente',
                                iconCls: 'btnEvolucionar',
                                tooltip: 'Evolucionar Paciente',
                                id: 'btnEvolucionar'
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        winFrmVerAgendaUi.superclass.initComponent.call(this);
    }
});
