/*
* @category    Panel Control PostParto
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnControlPostPartoUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnControlPostParto',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 260,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Control Postparto?',
                        name: 'Registrar HC Control Postparto?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRegistrarControlPostparto',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsControlPostparto').setVisible(false);
                                    Ext.getCmp('fecPOSTPARFechaParto').allowBlank = true;
                                    Ext.getCmp('strPOSTPARHoraParto').allowBlank = true;
                                    Ext.getCmp('intPOSTPAREdadGest').allowBlank = true;
                                    Ext.getCmp('strPOSTPARRuptMembranas').allowBlank = true;
                                    Ext.getCmp('strPOSTPARIniioTP').allowBlank = true;
                                    Ext.getCmp('fecPOSTPARFecRuptura').allowBlank = true;
                                    Ext.getCmp('strPOSTPARHoraRuptura').allowBlank = true;
                                    Ext.getCmp('strPOSTPARHorasRupturayParto').allowBlank = true;
                                    Ext.getCmp('strPOSTPARPresentacion').allowBlank = true;
                                    Ext.getCmp('strPOSTPARAcompanante').allowBlank = true;
                                    Ext.getCmp('strPOSTPARNacimiento').allowBlank = true;
                                    Ext.getCmp('strPOSTPARFetos').allowBlank = true;
                                    Ext.getCmp('strPOSTPAROcitocicos').allowBlank = true;
                                    Ext.getCmp('strPOSTPARDesgarros').allowBlank = true;
                                    Ext.getCmp('strPOSTPARPlacenta').allowBlank = true;
                                    Ext.getCmp('strPOSTPARLigaduraCordon').allowBlank = true;
                                    Ext.getCmp('intPOSTPARTDias').allowBlank = true;
                                    Ext.getCmp('strPOSTPARLoquios').allowBlank = true;
                                    Ext.getCmp('strPOSTPARPerine').allowBlank = true;
                                    Ext.getCmp('sysPOSTPARDiag').allowBlank = true;
                                    Ext.getCmp('strRegistrarIndiceRiesgoReproductivo').allowBlank = true;
                                    Ext.getCmp('strRegistrarIndiceRiesgoReproductivo').setValue(null);
                                    Ext.getCmp('sysPOSTPARDiag').setValue(null);
                                    Ext.getCmp('fecPOSTPARFechaParto').setValue(null);
                                    Ext.getCmp('strPOSTPARHoraParto').setValue(null);
                                    Ext.getCmp('intPOSTPAREdadGest').setValue(null);
                                    Ext.getCmp('strPOSTPARRuptMembranas').setValue(null);
                                    Ext.getCmp('strPOSTPARIniioTP').setValue(null);
                                    Ext.getCmp('fecPOSTPARFecRuptura').setValue(null);
                                    Ext.getCmp('strPOSTPARHoraRuptura').setValue(null);
                                    Ext.getCmp('strPOSTPARHorasRupturayParto').setValue(null);
                                    Ext.getCmp('strPOSTPARPresentacion').setValue(null);
                                    Ext.getCmp('strPOSTPARAcompanante').setValue(null);
                                    Ext.getCmp('strPOSTPARNacimiento').setValue(null);
                                    Ext.getCmp('strPOSTPARFetos').setValue(null);
                                    Ext.getCmp('strPOSTPARDesgarros').setValue(null);
                                    Ext.getCmp('strPOSTPAROcitocicos').setValue(null);
                                    Ext.getCmp('strPOSTPARPlacenta').setValue(null);
                                    Ext.getCmp('strPOSTPARLigaduraCordon').setValue(null);
                                    Ext.getCmp('intPOSTPARTDias').setValue(null);
                                    Ext.getCmp('strPOSTPARLoquios').setValue(null);
                                    Ext.getCmp('strPOSTPARPerine').setValue(null);
                                    Ext.getCmp('fecPOSTPARFechaParto').disable();
                                    Ext.getCmp('strPOSTPARHoraParto').disable();
                                    Ext.getCmp('intPOSTPAREdadGest').disable();
                                    Ext.getCmp('strPOSTPARRuptMembranas').disable();
                                    Ext.getCmp('strPOSTPARIniioTP').disable();
                                    Ext.getCmp('fecPOSTPARFecRuptura').disable();
                                    Ext.getCmp('strPOSTPARHoraRuptura').disable();
                                    Ext.getCmp('strPOSTPARHorasRupturayParto').disable();
                                    Ext.getCmp('strPOSTPARPresentacion').disable();
                                    Ext.getCmp('strPOSTPARAcompanante').disable();
                                    Ext.getCmp('strPOSTPARNacimiento').disable();
                                    Ext.getCmp('strPOSTPARFetos').disable();
                                    Ext.getCmp('strPOSTPARDesgarros').disable();
                                    Ext.getCmp('strPOSTPAROcitocicos').disable();
                                    Ext.getCmp('strPOSTPARPlacenta').disable();
                                    Ext.getCmp('strPOSTPARLigaduraCordon').disable();
                                    Ext.getCmp('intPOSTPARTDias').disable();
                                    Ext.getCmp('strPOSTPARLoquios').disable();
                                    Ext.getCmp('strPOSTPARPerine').disable();
                                    Ext.getCmp('sysPOSTPARDiag').disable();
                                    Ext.getCmp('strRegistrarIndiceRiesgoReproductivo').disable();
                                    Ext.getCmp('strRegistrarIndiceRiesgoReproductivo').clearInvalid();
                                    Ext.getCmp('sysPOSTPARDiag').clearInvalid();
                                    Ext.getCmp('fecPOSTPARFechaParto').clearInvalid();
                                    Ext.getCmp('strPOSTPARHoraParto').clearInvalid();
                                    Ext.getCmp('intPOSTPAREdadGest').clearInvalid();
                                    Ext.getCmp('strPOSTPARRuptMembranas').clearInvalid();
                                    Ext.getCmp('strPOSTPARIniioTP').clearInvalid();
                                    Ext.getCmp('fecPOSTPARFecRuptura').clearInvalid();
                                    Ext.getCmp('strPOSTPARHoraRuptura').clearInvalid();
                                    Ext.getCmp('strPOSTPARHorasRupturayParto').clearInvalid();
                                    Ext.getCmp('strPOSTPARPresentacion').clearInvalid();
                                    Ext.getCmp('strPOSTPARAcompanante').clearInvalid();
                                    Ext.getCmp('strPOSTPARNacimiento').clearInvalid();
                                    Ext.getCmp('strPOSTPARFetos').clearInvalid();
                                    Ext.getCmp('strPOSTPARDesgarros').clearInvalid();
                                    Ext.getCmp('strPOSTPAROcitocicos').clearInvalid();
                                    Ext.getCmp('strPOSTPARPlacenta').clearInvalid();
                                    Ext.getCmp('strPOSTPARLigaduraCordon').clearInvalid();
                                    Ext.getCmp('intPOSTPARTDias').clearInvalid();
                                    Ext.getCmp('strPOSTPARLoquios').clearInvalid();
                                    Ext.getCmp('strPOSTPARPerine').clearInvalid();
                                }else{
                                    Ext.getCmp('fsControlPostparto').setVisible(true);
                                    Ext.getCmp('fecPOSTPARFechaParto').allowBlank = false;
                                    Ext.getCmp('strPOSTPARHoraParto').allowBlank = true;
                                    Ext.getCmp('intPOSTPAREdadGest').allowBlank = false;
                                    Ext.getCmp('strPOSTPARRuptMembranas').allowBlank = true;
                                    Ext.getCmp('strPOSTPARIniioTP').allowBlank = true;
                                    Ext.getCmp('fecPOSTPARFecRuptura').allowBlank = true;
                                    Ext.getCmp('strPOSTPARHoraRuptura').allowBlank = true;
                                    Ext.getCmp('strPOSTPARHorasRupturayParto').allowBlank = true;
                                    Ext.getCmp('strPOSTPARPresentacion').allowBlank = true;
                                    Ext.getCmp('strPOSTPARAcompanante').allowBlank = true;
                                    Ext.getCmp('strPOSTPARNacimiento').allowBlank = true;
                                    Ext.getCmp('strPOSTPARFetos').allowBlank = true;
                                    Ext.getCmp('strPOSTPARDesgarros').allowBlank = true;
                                    Ext.getCmp('strPOSTPAROcitocicos').allowBlank = true;
                                    Ext.getCmp('strPOSTPARPlacenta').allowBlank = true;
                                    Ext.getCmp('strPOSTPARLigaduraCordon').allowBlank = true;
                                    Ext.getCmp('intPOSTPARTDias').allowBlank = false;
                                    Ext.getCmp('strPOSTPARLoquios').allowBlank = false;
                                    Ext.getCmp('strPOSTPARPerine').allowBlank = true;
                                    Ext.getCmp('sysPOSTPARDiag').allowBlank = false;
                                    Ext.getCmp('strRegistrarIndiceRiesgoReproductivo').allowBlank = false;
                                    Ext.getCmp('strRegistrarIndiceRiesgoReproductivo').enable();
                                    Ext.getCmp('sysPOSTPARDiag').enable();
                                    Ext.getCmp('fecPOSTPARFechaParto').enable();
                                    Ext.getCmp('strPOSTPARHoraParto').enable();
                                    Ext.getCmp('intPOSTPAREdadGest').enable();
                                    Ext.getCmp('strPOSTPARRuptMembranas').enable();
                                    Ext.getCmp('strPOSTPARIniioTP').enable();
                                    Ext.getCmp('fecPOSTPARFecRuptura').enable();
                                    Ext.getCmp('strPOSTPARHoraRuptura').enable();
                                    Ext.getCmp('strPOSTPARHorasRupturayParto').enable();
                                    Ext.getCmp('strPOSTPARPresentacion').enable();
                                    Ext.getCmp('strPOSTPARAcompanante').enable();
                                    Ext.getCmp('strPOSTPARNacimiento').enable();
                                    Ext.getCmp('strPOSTPARFetos').enable();
                                    Ext.getCmp('strPOSTPARDesgarros').enable();
                                    Ext.getCmp('strPOSTPAROcitocicos').enable();
                                    Ext.getCmp('strPOSTPARPlacenta').enable();
                                    Ext.getCmp('strPOSTPARLigaduraCordon').enable();
                                    Ext.getCmp('intPOSTPARTDias').enable();
                                    Ext.getCmp('strPOSTPARLoquios').enable();
                                    Ext.getCmp('strPOSTPARPerine').enable();
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PROGRAMA: CONTROL POSTPARTO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id: 'fsControlPostparto',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'Informacion del Parto',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'Fecha Parto',
                                        name: 'Fecha Parto',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPOSTPARFechaParto'
                                    },
                                    {
                                        html: 'Hora Parto:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        allowBlank: true,
                                        emptyText: 'hh:mm',
                                        id: 'strPOSTPARHoraParto'
                                    },
                                    {
                                        html: 'Edad Gest:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 50,
                                        name: 'Edad Gestacion',
                                        minValue: 1,
                                        allowBlank: true,
                                        style: 'text-align:center;',
                                        id: 'intPOSTPAREdadGest'
                                    },
                                    {
                                        html: 'Inicio de Trabajo de Parto'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Inicio de Trabajo de Parto',
                                        width: 120,
                                        allowBlank: true,
                                        store: stInicioTP,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARIniioTP'
                                    },
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                        {
                                        xtype: 'combo',
                                        name: 'Ruptura de Membranas',
                                        fieldLabel: 'Ruptura de Membranas Anteparto',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARRuptMembranas',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPOSTPARFecRuptura').allowBlank = true;
                                                    Ext.getCmp('strPOSTPARHoraRuptura').allowBlank = true;
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').allowBlank = true;
                                                    Ext.getCmp('fecPOSTPARFecRuptura').setValue(null);
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').setValue(null);
                                                    Ext.getCmp('strPOSTPARHoraRuptura').setValue(null);
                                                    Ext.getCmp('fecPOSTPARFecRuptura').disable();
                                                    Ext.getCmp('strPOSTPARHoraRuptura').disable();
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').disable();
                                                    Ext.getCmp('fecPOSTPARFecRuptura').clearInvalid();
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').clearInvalid();
                                                    Ext.getCmp('strPOSTPARHoraRuptura').clearInvalid();
                                                    }else{
                                                    Ext.getCmp('fecPOSTPARFecRuptura').enable();
                                                    Ext.getCmp('strPOSTPARHoraRuptura').enable();
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').enable();
                                                    Ext.getCmp('fecPOSTPARFecRuptura').allowBlank = true;
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').allowBlank = true;
                                                    Ext.getCmp('strPOSTPARHoraRuptura').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Fecha Ruptura:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Ruptura Membranas',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPOSTPARFecRuptura'
                                    },
                                    {
                                        html: 'Hora Ruptura:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        allowBlank: true,
                                        emptyText: 'hh:mm',
                                        id: 'strPOSTPARHoraRuptura'
                                    },
                                    {
                                        html: 'Horas Entre Ruptura y Parto:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        allowBlank: true,
                                        emptyText: 'horas',
                                        id: 'strPOSTPARHorasRupturayParto'
                                    }
                                ]
                            },
                            {
                            xtype: 'compositefield',
                            style: 'background:transparent;',
                            items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Presentacion',
                                        fieldLabel: 'Presentacion',
                                        width: 90,
                                        allowBlank: true,
                                        store: stPresentacion,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARPresentacion'
                                    },
                                    {
                                        html: 'Acompanante TP'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Acompa�ante en TP',
                                        width: 90,
                                        allowBlank: true,
                                        store: stAcompanante,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARAcompanante'
                                    },
                                    {
                                        html: 'Estado RN'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Nacimiento',
                                        width: 90,
                                        allowBlank: true,
                                        store: stNacimiento,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARNacimiento'
                                    },
                                    {
                                        html: 'Fetos:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Fetos',
                                        width: 90,
                                        allowBlank: true,
                                        store: stFetos,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARFetos'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Cantidad Fetos',
                                        width: 50,
                                        minValue: 1,
                                        style: 'text-align:center;',
                                        emptyText: 'Cant',
                                        allowBlank: true,
                                        id: 'intPOSTPARCantidadFetos'
                                    }
                                ]
                            },
                            {
                            xtype: 'compositefield',
                            style: 'background:transparent;',
                            items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Desgarros',
                                        fieldLabel: 'Desgarros',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARDesgarros'
                                    },
                                    {
                                        html: 'Ocitocicos en Alumbramiento:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Ocitocicos',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPAROcitocicos'
                                    },
                                    {
                                        html: 'Placenta:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Fetos',
                                        width: 120,
                                        allowBlank: true,
                                        store: stPlacenta,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARPlacenta'
                                    },
                                    {
                                        html: 'Ligadura de Cordon:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Ligadura de Cordon',
                                        width: 120,
                                        allowBlank: true,
                                        store: stLigaduraCordon,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARLigaduraCordon'
                                    },
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 50,
                                fieldLabel: 'Dias PostParto',
                                name: 'Dias PostParto',
                                minValue: 1,
                                allowBlank: true,
                                style: 'text-align:center;',
                                id: 'intPOSTPARTDias'
                            },
                            {
                                html: 'Loquios'
                            },
                            {
                                xtype: 'combo',
                                name: 'Loquios',
                                width: 150,
                                allowBlank: true,
                                store: stLoquios,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPOSTPARLoquios'
                            },
                            {
                                html: 'Perine o Herida Quirurgica'
                            },
                            {
                                xtype: 'textfield',
                                width: 150,
                                allowBlank: true,
                                name: 'Perine o Herida Quirurgica',
                                id: 'strPOSTPARPerine'
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'panel',
                        anchor: '100%',
                        autoHeight: true,
                        layout: 'form',
                        labelWidth: 260,
                        padding: 5,
                        items: [
                            {
                                xtype: 'combo',
                                labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                                fieldLabel: 'Registrar Indice de Riesgo Reproductivo?',
                                name: 'Registrar Indice de Riesgo Reproductivo?',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strRegistrarIndiceRiesgoReproductivo',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('fsIndiceRiesgoReproductivo').setVisible(false);
                                            Ext.getCmp('strPOSTPAREdadMujer').allowBlank = true;
                                            Ext.getCmp('strPOSTPARParidad').allowBlank = true;
                                            Ext.getCmp('strPOSTPARSocioEconomico').allowBlank = true;
                                            Ext.getCmp('strPOSTPARIntervaloEmbarazos').allowBlank = true;
                                            Ext.getCmp('strPOSTPARAbortos').allowBlank = true;
                                            Ext.getCmp('strPOSTPARCesarea').allowBlank = true;
                                            Ext.getCmp('strPOSTPARMortinato').allowBlank = true;
                                            Ext.getCmp('strPOSTPARPrematuros').allowBlank = true;
                                            Ext.getCmp('strPOSTPARHipertension').allowBlank = true;
                                            Ext.getCmp('strPOSTPARPreclampsia').allowBlank = true;
                                            Ext.getCmp('strPOSTPARCardiopatia').allowBlank = true;
                                            Ext.getCmp('strPOSTPAROtraPatologia').allowBlank = true;
                                            Ext.getCmp('strPOSTPARRiesgoTotal').allowBlank = true;
                                            Ext.getCmp('strPOSTPAREdadMujer').setValue(null);
                                            Ext.getCmp('strPOSTPARParidad').setValue(null);
                                            Ext.getCmp('strPOSTPARSocioEconomico').setValue(null);
                                            Ext.getCmp('strPOSTPARIntervaloEmbarazos').setValue(null);
                                            Ext.getCmp('strPOSTPARAbortos').setValue(null);
                                            Ext.getCmp('strPOSTPARCesarea').setValue(null);
                                            Ext.getCmp('strPOSTPARMortinato').setValue(null);
                                            Ext.getCmp('strPOSTPARPrematuros').setValue(null);
                                            Ext.getCmp('strPOSTPARHipertension').setValue(null);
                                            Ext.getCmp('strPOSTPARPreclampsia').setValue(null);
                                            Ext.getCmp('strPOSTPARCardiopatia').setValue(null);
                                            Ext.getCmp('strPOSTPAROtraPatologia').setValue(null);
                                            Ext.getCmp('strPOSTPARRiesgoTotal').setValue(null);
                                            Ext.getCmp('strPOSTPAREdadMujer').disable();
                                            Ext.getCmp('strPOSTPARParidad').disable();
                                            Ext.getCmp('strPOSTPARSocioEconomico').disable();
                                            Ext.getCmp('strPOSTPARIntervaloEmbarazos').disable();
                                            Ext.getCmp('strPOSTPARAbortos').disable();
                                            Ext.getCmp('strPOSTPARCesarea').disable();
                                            Ext.getCmp('strPOSTPARMortinato').disable();
                                            Ext.getCmp('strPOSTPARPrematuros').disable();
                                            Ext.getCmp('strPOSTPARHipertension').disable();
                                            Ext.getCmp('strPOSTPARPreclampsia').disable();
                                            Ext.getCmp('strPOSTPARCardiopatia').disable();
                                            Ext.getCmp('strPOSTPAROtraPatologia').disable();
                                            Ext.getCmp('strPOSTPARRiesgoTotal').disable();
                                            Ext.getCmp('strPOSTPAREdadMujer').clearInvalid();
                                            Ext.getCmp('strPOSTPARParidad').clearInvalid();
                                            Ext.getCmp('strPOSTPARSocioEconomico').clearInvalid();
                                            Ext.getCmp('strPOSTPARIntervaloEmbarazos').clearInvalid();
                                            Ext.getCmp('strPOSTPARAbortos').clearInvalid();
                                            Ext.getCmp('strPOSTPARCesarea').clearInvalid();
                                            Ext.getCmp('strPOSTPARMortinato').clearInvalid();
                                            Ext.getCmp('strPOSTPARPrematuros').clearInvalid();
                                            Ext.getCmp('strPOSTPARHipertension').clearInvalid();
                                            Ext.getCmp('strPOSTPARPreclampsia').clearInvalid();
                                            Ext.getCmp('strPOSTPARCardiopatia').clearInvalid();
                                            Ext.getCmp('strPOSTPAROtraPatologia').clearInvalid();
                                            Ext.getCmp('strPOSTPARRiesgoTotal').clearInvalid();
                                        }else{
                                            Ext.getCmp('fsIndiceRiesgoReproductivo').setVisible(true);
                                            Ext.getCmp('strPOSTPAREdadMujer').allowBlank = false;
                                            Ext.getCmp('strPOSTPARParidad').allowBlank = false;
                                            Ext.getCmp('strPOSTPARSocioEconomico').allowBlank = false;
                                            Ext.getCmp('strPOSTPARIntervaloEmbarazos').allowBlank = false;
                                            Ext.getCmp('strPOSTPARAbortos').allowBlank = false;
                                            Ext.getCmp('strPOSTPARCesarea').allowBlank = false;
                                            Ext.getCmp('strPOSTPARMortinato').allowBlank = false;
                                            Ext.getCmp('strPOSTPARPrematuros').allowBlank = false;
                                            Ext.getCmp('strPOSTPARHipertension').allowBlank = false;
                                            Ext.getCmp('strPOSTPARPreclampsia').allowBlank = false;
                                            Ext.getCmp('strPOSTPARCardiopatia').allowBlank = false;
                                            Ext.getCmp('strPOSTPAROtraPatologia').allowBlank = false;
                                            Ext.getCmp('strPOSTPARRiesgoTotal').allowBlank = false;
                                            Ext.getCmp('strPOSTPAREdadMujer').enable();
                                            Ext.getCmp('strPOSTPARParidad').enable();
                                            Ext.getCmp('strPOSTPARSocioEconomico').enable();
                                            Ext.getCmp('strPOSTPARIntervaloEmbarazos').enable();
                                            Ext.getCmp('strPOSTPARAbortos').enable();
                                            Ext.getCmp('strPOSTPARCesarea').enable();
                                            Ext.getCmp('strPOSTPARMortinato').enable();
                                            Ext.getCmp('strPOSTPARPrematuros').enable();
                                            Ext.getCmp('strPOSTPARHipertension').enable();
                                            Ext.getCmp('strPOSTPARPreclampsia').enable();
                                            Ext.getCmp('strPOSTPARCardiopatia').enable();
                                            Ext.getCmp('strPOSTPAROtraPatologia').enable();
                                            Ext.getCmp('strPOSTPARRiesgoTotal').enable();
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Indice de Riesgo Reproductivo',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsIndiceRiesgoReproductivo',
                        items: [
                                {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                        {
                                        xtype: 'combo',
                                        name: 'Edad de la Mujer',
                                        fieldLabel: 'Edad de la Mujer',
                                        width: 150,
                                        allowBlank: true,
                                        store: stEdadMujer,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPAREdadMujer',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    },
                                    {
                                        html:'Paridad:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Paridad',
                                        width: 150,
                                        allowBlank: true,
                                        store: stParidad,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARParidad',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    },
                                    {
                                        html:'Socio-Economico:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Socio-Economico',
                                        width: 200,
                                        allowBlank: true,
                                        store: stSocioEconomico,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARSocioEconomico',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    },
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Intervalo Emb',
                                        fieldLabel: 'Intervalo Emb',
                                        width: 150,
                                        allowBlank: true,
                                        store: stIntervaloEmbarazos,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARIntervaloEmbarazos',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    },
                                    {
                                        html:'Abortos:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Abortos',
                                        width: 75,
                                        allowBlank: true,
                                        store: stAbortos,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARAbortos',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    },
                                    {
                                        html:'Cesarea:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Cesarea',
                                        width: 75,
                                        allowBlank: true,
                                        store: stCesarea,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARCesarea',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    },
                                    {
                                        html:'Mortinato:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Cesarea',
                                        width: 75,
                                        allowBlank: true,
                                        store: stMortinato,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARMortinato',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    },
                                    {
                                        html:'Prematuros:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Prematuros',
                                        width: 75,
                                        allowBlank: true,
                                        store: stPrematuros,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARPrematuros',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Hipertension',
                                        fieldLabel: 'Hipertension',
                                        width: 80,
                                        allowBlank: true,
                                        store: stHipertension,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARHipertension',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    },
                                    {
                                        html:'Preclampsia:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Preclampsia',
                                        width: 80,
                                        allowBlank: true,
                                        store: stPreclampsia,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARPreclampsia',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    },
                                    {
                                        html:'Cardiopatia:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Cardiopatia',
                                        width: 80,
                                        allowBlank: true,
                                        store: stCardiopatia,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARCardiopatia',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    },
                                    {
                                        html:'Otra Patologia:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Otra Patologia',
                                        width: 80,
                                        allowBlank: true,
                                        store: stOtraPatologia,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPAROtraPatologia',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                calculoRiesgoReproductivo()
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Riesgo Total',
                                name: 'Riesgo Total',
                                width: 200,
                                readOnly: true,
                                id: 'strPOSTPARRiesgoTotal'
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 880,
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 100,
                        allowBlank: true,
                        id: 'memPOSTPARPlan'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: true,
                                fieldLabel: 'Diagnostico',
                                id: 'sysPOSTPARDiag',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                        {
                                            if (f.getValue() != "" && f.getValue() != null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                            Ext.getCmp('sysPOSTPARDiag').setValue(null);
                                                            Ext.getCmp('sysPOSTPARDiagNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysPOSTPARDiag').setValue(Contenido[0]);
                                                            Ext.getCmp('sysPOSTPARDiagNom').setValue(Contenido[1]);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysPOSTPARDiag').setValue(null);
                                                        Ext.getCmp('sysPOSTPARDiagNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysPOSTPARDiag').setValue(null);
                                                Ext.getCmp('sysPOSTPARDiagNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 625,
                                height: 22,
                                id: 'sysPOSTPARDiagNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysPOSTPARDiag','sysPOSTPARDiagNom');
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        pnControlPostPartoUi.superclass.initComponent.call(this);
    }
});
