/*
* @category    Panel Control PostParto
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnControlPostPartoUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnControlPostParto',
    initComponent: function() {
        this.items = [
            {
                xtype: 'fieldset',
                title: 'INFORMACION PROGRAMA',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id: 'fsControlPostparto',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'Informacion del Parto',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'Fecha Parto',
                                        name: 'Fecha Parto',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPOSTPARFechaParto'
                                    },
                                    {
                                        html: 'Hora Parto:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        allowBlank: true,
                                        emptyText: 'hh:mm',
                                        id: 'strPOSTPARHoraParto'
                                    },
                                    {
                                        html: 'Edad Gest:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 50,
                                        name: 'Edad Gestacion',
                                        minValue: 1,
                                        allowBlank: true,
                                        style: 'text-align:center;',
                                        id: 'intPOSTPAREdadGest'
                                    },
                                    {
                                        html: 'Inicio de Trabajo de Parto'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Inicio de Trabajo de Parto',
                                        width: 120,
                                        allowBlank: true,
                                        store: stInicioTP,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARIniioTP'
                                    },
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                        {
                                        xtype: 'combo',
                                        name: 'Ruptura de Membranas',
                                        fieldLabel: 'R.T.M.',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPOSTPARRuptMembranas',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPOSTPARFecRuptura').allowBlank = true;
                                                    Ext.getCmp('strPOSTPARHoraRuptura').allowBlank = true;
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').allowBlank = true;
                                                    Ext.getCmp('fecPOSTPARFecRuptura').setValue(null);
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').setValue(null);
                                                    Ext.getCmp('strPOSTPARHoraRuptura').setValue(null);
                                                    Ext.getCmp('fecPOSTPARFecRuptura').disable();
                                                    Ext.getCmp('strPOSTPARHoraRuptura').disable();
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').disable();
                                                    Ext.getCmp('fecPOSTPARFecRuptura').clearInvalid();
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').clearInvalid();
                                                    Ext.getCmp('strPOSTPARHoraRuptura').clearInvalid();
                                                    }else{
                                                    Ext.getCmp('fecPOSTPARFecRuptura').enable();
                                                    Ext.getCmp('strPOSTPARHoraRuptura').enable();
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').enable();
                                                    Ext.getCmp('fecPOSTPARFecRuptura').allowBlank = true;
                                                    Ext.getCmp('strPOSTPARHorasRupturayParto').allowBlank = true;
                                                    Ext.getCmp('strPOSTPARHoraRuptura').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Fecha Ruptura:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Ruptura Membranas',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPOSTPARFecRuptura'
                                    },
                                    {
                                        html: 'Hora Ruptura:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        allowBlank: true,
                                        emptyText: 'hh:mm',
                                        id: 'strPOSTPARHoraRuptura'
                                    },
                                    {
                                        html: 'Horas Entre Ruptura y Parto:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        allowBlank: true,
                                        emptyText: 'horas',
                                        id: 'strPOSTPARHorasRupturayParto'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                        {
                                            xtype: 'combo',
                                            name: 'Presentacion',
                                            fieldLabel: 'Presentacion',
                                            width: 90,
                                            allowBlank: true,
                                            store: stPresentacion,
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'strPOSTPARPresentacion'
                                        },
                                        {
                                            html: 'Acompanante TP'
                                        },
                                        {
                                            xtype: 'combo',
                                            name: 'Acompañante en TP',
                                            width: 90,
                                            allowBlank: true,
                                            store: stAcompanante,
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'strPOSTPARAcompanante'
                                        },
                                        {
                                            html: 'Estado RN'
                                        },
                                        {
                                            xtype: 'combo',
                                            name: 'Estado RN',
                                            width: 90,
                                            allowBlank: true,
                                            store: stNacimiento,
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'strPOSTPARNacimiento'
                                        },
                                        {
                                            html: 'Fetos:'
                                        },
                                        {
                                            xtype: 'combo',
                                            name: 'Fetos',
                                            width: 90,
                                            allowBlank: true,
                                            store: stFetos,
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'strPOSTPARFetos'
                                        },
                                        {
                                            xtype: 'numberfield',
                                            name: 'Cantidad Fetos',
                                            width: 50,
                                            minValue: 1,
                                            style: 'text-align:center;',
                                            emptyText: 'Cant',
                                            allowBlank: true,
                                            id: 'intPOSTPARCantidadFetos'
                                        }
                                    ]
                                },
                                {
                                    xtype: 'compositefield',
                                    style: 'background:transparent;',
                                    items: [
                                        {
                                            xtype: 'combo',
                                            name: 'Desgarros',
                                            fieldLabel: 'Desgarros',
                                            width: 60,
                                            allowBlank: true,
                                            store: 'StoreSiNo',
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'strPOSTPARDesgarros'
                                        },
                                        {
                                            html: 'Ocitocicos en Alumbramiento:'
                                        },
                                        {
                                            xtype: 'combo',
                                            name: 'Ocitocicos',
                                            width: 60,
                                            allowBlank: true,
                                            store: 'StoreSiNo',
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'strPOSTPAROcitocicos'
                                        },
                                        {
                                            html: 'Placenta:'
                                        },
                                        {
                                            xtype: 'combo',
                                            name: 'Placenta',
                                            width: 120,
                                            allowBlank: true,
                                            store: stPlacenta,
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'strPOSTPARPlacenta'
                                        },
                                        {
                                            html: 'Ligadura de Cordon:'
                                        },
                                        {
                                            xtype: 'combo',
                                            name: 'Ligadura de Cordon',
                                            width: 120,
                                            allowBlank: true,
                                            store: stLigaduraCordon,
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'strPOSTPARLigaduraCordon'
                                        },
                                    ]
                                }
                            ]
                        },
                        {
                            xtype: 'compositefield',
                            style: 'background:transparent;',
                            items: [
                                {
                                    xtype: 'numberfield',
                                    width: 50,
                                    fieldLabel: 'Dias PostParto',
                                    name: 'Dias PostParto',
                                    minValue: 1,
                                    allowBlank: true,
                                    style: 'text-align:center;',
                                    id: 'intPOSTPARTDias'
                                },
                                {
                                    html: 'Loquios'
                                },
                                {
                                    xtype: 'combo',
                                    name: 'Loquios',
                                    width: 150,
                                    allowBlank: true,
                                    store: stLoquios,
                                    valueField: 'Descripcion',
                                    displayField: 'Descripcion',
                                    mode: 'local',
                                    forceSelection: true,
                                    typeAhead: true,
                                    typeAheadDelay: 10,
                                    triggerAction: 'all',
                                    id: 'strPOSTPARLoquios'
                                },
                                {
                                    html: 'Perine o Herida Quirurgica'
                                },
                                {
                                    xtype: 'textfield',
                                    width: 150,
                                    allowBlank: true,
                                    name: 'Perine o Herida Quirurgica',
                                    id: 'strPOSTPARPerine'
                                }
                            ]
                        },
                        {
                            html: '<br>'
                        },
                        {
                            xtype: 'panel',
                            anchor: '100%',
                            autoHeight: true,
                            layout: 'form',
                            labelWidth: 260,
                            padding: 5,
                            items: [
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Registrar Indice de Riesgo Reproductivo?',
                                    name: 'Registrar Indice de Riesgo Reproductivo?',
                                    width: 60,
                                    allowBlank: true,
                                    store: 'StoreSiNo',
                                    valueField: 'Descripcion',
                                    displayField: 'Descripcion',
                                    mode: 'local',
                                    forceSelection: true,
                                    typeAhead: true,
                                    typeAheadDelay: 10,
                                    triggerAction: 'all',
                                    id: 'strRegistrarIndiceRiesgoReproductivo',
                                    listeners:{
                                        change : function( t, newValue, oldValue){
                                            if(newValue == "NO"){
                                                Ext.getCmp('fsIndiceRiesgoReproductivo').setVisible(false);
                                                Ext.getCmp('strPOSTPAREdadMujer').allowBlank = true;
                                                Ext.getCmp('strPOSTPARParidad').allowBlank = true;
                                                Ext.getCmp('strPOSTPARSocioEconomico').allowBlank = true;
                                                Ext.getCmp('strPOSTPARIntervaloEmbarazos').allowBlank = true;
                                                Ext.getCmp('strPOSTPARAbortos').allowBlank = true;
                                                Ext.getCmp('strPOSTPARCesarea').allowBlank = true;
                                                Ext.getCmp('strPOSTPARMortinato').allowBlank = true;
                                                Ext.getCmp('strPOSTPARPrematuros').allowBlank = true;
                                                Ext.getCmp('strPOSTPARHipertension').allowBlank = true;
                                                Ext.getCmp('strPOSTPARPreclampsia').allowBlank = true;
                                                Ext.getCmp('strPOSTPARCardiopatia').allowBlank = true;
                                                Ext.getCmp('strPOSTPAROtraPatologia').allowBlank = true;
                                                Ext.getCmp('strPOSTPARRiesgoTotal').allowBlank = true;
                                                Ext.getCmp('strPOSTPAREdadMujer').setValue(null);
                                                Ext.getCmp('strPOSTPARParidad').setValue(null);
                                                Ext.getCmp('strPOSTPARSocioEconomico').setValue(null);
                                                Ext.getCmp('strPOSTPARIntervaloEmbarazos').setValue(null);
                                                Ext.getCmp('strPOSTPARAbortos').setValue(null);
                                                Ext.getCmp('strPOSTPARCesarea').setValue(null);
                                                Ext.getCmp('strPOSTPARMortinato').setValue(null);
                                                Ext.getCmp('strPOSTPARPrematuros').setValue(null);
                                                Ext.getCmp('strPOSTPARHipertension').setValue(null);
                                                Ext.getCmp('strPOSTPARPreclampsia').setValue(null);
                                                Ext.getCmp('strPOSTPARCardiopatia').setValue(null);
                                                Ext.getCmp('strPOSTPAROtraPatologia').setValue(null);
                                                Ext.getCmp('strPOSTPARRiesgoTotal').setValue(null);
                                                Ext.getCmp('strPOSTPAREdadMujer').disable();
                                                Ext.getCmp('strPOSTPARParidad').disable();
                                                Ext.getCmp('strPOSTPARSocioEconomico').disable();
                                                Ext.getCmp('strPOSTPARIntervaloEmbarazos').disable();
                                                Ext.getCmp('strPOSTPARAbortos').disable();
                                                Ext.getCmp('strPOSTPARCesarea').disable();
                                                Ext.getCmp('strPOSTPARMortinato').disable();
                                                Ext.getCmp('strPOSTPARPrematuros').disable();
                                                Ext.getCmp('strPOSTPARHipertension').disable();
                                                Ext.getCmp('strPOSTPARPreclampsia').disable();
                                                Ext.getCmp('strPOSTPARCardiopatia').disable();
                                                Ext.getCmp('strPOSTPAROtraPatologia').disable();
                                                Ext.getCmp('strPOSTPARRiesgoTotal').disable();
                                                Ext.getCmp('strPOSTPAREdadMujer').clearInvalid();
                                                Ext.getCmp('strPOSTPARParidad').clearInvalid();
                                                Ext.getCmp('strPOSTPARSocioEconomico').clearInvalid();
                                                Ext.getCmp('strPOSTPARIntervaloEmbarazos').clearInvalid();
                                                Ext.getCmp('strPOSTPARAbortos').clearInvalid();
                                                Ext.getCmp('strPOSTPARCesarea').clearInvalid();
                                                Ext.getCmp('strPOSTPARMortinato').clearInvalid();
                                                Ext.getCmp('strPOSTPARPrematuros').clearInvalid();
                                                Ext.getCmp('strPOSTPARHipertension').clearInvalid();
                                                Ext.getCmp('strPOSTPARPreclampsia').clearInvalid();
                                                Ext.getCmp('strPOSTPARCardiopatia').clearInvalid();
                                                Ext.getCmp('strPOSTPAROtraPatologia').clearInvalid();
                                                Ext.getCmp('strPOSTPARRiesgoTotal').clearInvalid();
                                            }else{
                                                Ext.getCmp('fsIndiceRiesgoReproductivo').setVisible(true);
                                                Ext.getCmp('strPOSTPAREdadMujer').allowBlank = false;
                                                Ext.getCmp('strPOSTPARParidad').allowBlank = false;
                                                Ext.getCmp('strPOSTPARSocioEconomico').allowBlank = false;
                                                Ext.getCmp('strPOSTPARIntervaloEmbarazos').allowBlank = false;
                                                Ext.getCmp('strPOSTPARAbortos').allowBlank = false;
                                                Ext.getCmp('strPOSTPARCesarea').allowBlank = false;
                                                Ext.getCmp('strPOSTPARMortinato').allowBlank = false;
                                                Ext.getCmp('strPOSTPARPrematuros').allowBlank = false;
                                                Ext.getCmp('strPOSTPARHipertension').allowBlank = false;
                                                Ext.getCmp('strPOSTPARPreclampsia').allowBlank = false;
                                                Ext.getCmp('strPOSTPARCardiopatia').allowBlank = false;
                                                Ext.getCmp('strPOSTPAROtraPatologia').allowBlank = false;
                                                Ext.getCmp('strPOSTPARRiesgoTotal').allowBlank = false;
                                                Ext.getCmp('strPOSTPAREdadMujer').enable();
                                                Ext.getCmp('strPOSTPARParidad').enable();
                                                Ext.getCmp('strPOSTPARSocioEconomico').enable();
                                                Ext.getCmp('strPOSTPARIntervaloEmbarazos').enable();
                                                Ext.getCmp('strPOSTPARAbortos').enable();
                                                Ext.getCmp('strPOSTPARCesarea').enable();
                                                Ext.getCmp('strPOSTPARMortinato').enable();
                                                Ext.getCmp('strPOSTPARPrematuros').enable();
                                                Ext.getCmp('strPOSTPARHipertension').enable();
                                                Ext.getCmp('strPOSTPARPreclampsia').enable();
                                                Ext.getCmp('strPOSTPARCardiopatia').enable();
                                                Ext.getCmp('strPOSTPAROtraPatologia').enable();
                                                Ext.getCmp('strPOSTPARRiesgoTotal').enable();
                                            }
                                        }
                                    }
                                }
                            ]
                        },
                        {
                            xtype: 'fieldset',
                            title: 'Indice de Riesgo Reproductivo',
                            layout: 'form',
                            collapseFirst: false,
                            collapsible: true,
                            animCollapse: true,
                            titleCollapse: true,
                            anchor: '100%',
                            autoHeight: true,
                            padding: 5,
                            id: 'fsIndiceRiesgoReproductivo',
                            items: [
                                {
                                    xtype: 'panel',
                                    layout: 'table',
                                    anchor: '100%',
                                    padding: 0,
                                    layoutConfig: {
                                        columns: 2
                                    },
                                    autoHeight: true,
                                    items: [
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            width: 350,
                                            autoHeight: true,
                                            labelSeparator: '',
                                            labelStyle: 'color:blue;',
                                            items: [
                                                {
                                                    xtype: 'combo',
                                                    name: 'Edad de la Mujer',
                                                    fieldLabel: 'Edad de la Mujer',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stEdadMujer,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPAREdadMujer',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'combo',
                                                    name: 'Paridad',
                                                    fieldLabel: 'Paridad',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stParidad,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPARParidad',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'combo',
                                                    name: 'Socio-Economico',
                                                    fieldLabel: 'Socio-Economico',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stSocioEconomico,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPARSocioEconomico',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'combo',
                                                    name: 'Intervalo Emb',
                                                    fieldLabel: 'Intervalo Emb',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stIntervaloEmbarazos,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPARIntervaloEmbarazos',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'combo',
                                                    name: 'Abortos',
                                                    fieldLabel: 'Abortos',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stAbortos,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPARAbortos',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'combo',
                                                    name: 'Cesarea',
                                                    fieldLabel: 'Cesarea',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stCesarea,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPARCesarea',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                }
                                            ]
                                        },
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            width: 350,
                                            autoHeight: true,
                                            labelSeparator: '',
                                            labelStyle: 'color:blue;',
                                            items: [
                                                {
                                                    xtype: 'combo',
                                                    name: 'Cesarea',
                                                    fieldLabel: 'Cesarea',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stMortinato,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPARMortinato',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'combo',
                                                    name: 'Prematuros',
                                                    fieldLabel: 'Prematuros',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stPrematuros,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPARPrematuros',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'combo',
                                                    name: 'Hipertension',
                                                    fieldLabel: 'Hipertension',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stHipertension,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPARHipertension',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'combo',
                                                    name: 'Preclampsia',
                                                    fieldLabel: 'Preclampsia',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stPreclampsia,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPARPreclampsia',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'combo',
                                                    name: 'Cardiopatia',
                                                    fieldLabel: 'Cardiopatia',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stCardiopatia,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPARCardiopatia',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'combo',
                                                    name: 'Otra Patologia',
                                                    fieldLabel: 'Otra Patologia',
                                                    width: 200,
                                                    allowBlank: true,
                                                    store: stOtraPatologia,
                                                    valueField: 'Codigo',
                                                    displayField: 'Descripcion',
                                                    mode: 'local',
                                                    forceSelection: true,
                                                    typeAhead: true,
                                                    typeAheadDelay: 10,
                                                    triggerAction: 'all',
                                                    id: 'strPOSTPAROtraPatologia',
                                                    listeners:{
                                                        change : function(f,pNew, pOld){
                                                            calculoRiesgoReproductivo()
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    html: '<br>'
                                },
                                {
                                    xtype: 'textfield',
                                    fieldLabel: 'Riesgo Total',
                                    name: 'Riesgo Total',
                                    width: 200,
                                    readOnly: true,
                                    id: 'strPOSTPARRiesgoTotal'
                                }
                            ]
                        }
                    ]
                }
            ];
            pnControlPostPartoUi.superclass.initComponent.call(this);
        }
    });
