/*
* @category    Fieldset Examen Fisico
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsExamenFisicoUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'EXAMEN FISICO',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsExamenFisico',
    initComponent: function() {
        this.items = [
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'T.A. (Sentado)',
                        name: 'T.A. (Sentado) Sistolica',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: false,
                        id: 'intEXAFISTASentadoSistolica'
                    },
                    {
                        html: '/'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'T.A. (Sentado) Diastolica',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: false,
                        id: 'intEXAFISTASentadoDiastolica'
                    },
                    {
                        html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;'
                    },
                    {
                        html: 'T.A. (Acostado):'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'T.A. (Acostado) Sistolica',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: false,
                        id: 'intEXAFISTAAcostadoSistolica'
                    },
                    {
                        html: '/'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'T.A. (Acostado) Diastolica',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: false,
                        id: 'intEXAFISTAAcostadoDiastolica'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 250,
                        decimalPrecision: 2,
                        allowBlank: true,
                        fieldLabel: 'TALLA (cm)',
                        name:"TALLA (cm)",
                        emptyText: '(cm)',
                        id: 'intEXAFISTalla',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == 0){
                                    Ext.getCmp('intEXAFISTalla').setValue(null);
                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                }else{
                                    if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                    }else{
                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                    }
                                }
                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                }else{
                                    if(Ext.getCmp('intEXAFISIMC').getValue()<24.9){
                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("ACEPTABLE");
                                    }else{
                                        if(Ext.getCmp('intEXAFISIMC').getValue()<29.9){
                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("SOBREPESO");
                                        }else{
                                            Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESIDAD");
                                        }

                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'displayfield',
                        id: 'sysEXAFISPeso',
                        value: 'PESO (Kg): '
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 250,
                        decimalPrecision: 2,
                        allowBlank: true,
                        emptyText: '(Kg)',
                        name:"PESO (Kg)",
                        id: 'intEXAFISPeso',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == 0){
                                    Ext.getCmp('intEXAFISPeso').setValue(null);
                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                }else{
                                    //peso [kg]/ estatura [m2]
                                    if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                    }else{
                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                    }
                                }
                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                }else{
                                    if(Ext.getCmp('intEXAFISIMC').getValue()<24.9){
                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("ACEPTABLE");
                                    }else{
                                        if(Ext.getCmp('intEXAFISIMC').getValue()<29.9){
                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("SOBREPESO");
                                        }else{
                                            Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESIDAD");
                                        }

                                    }
                                }
                                // CALCULO TFG
                                if(Ext.getCmp('strPROGESPECreatininaRes').getValue() !== "" && Ext.getCmp('strPROGESPECreatininaRes').getValue() !== null){
                                    if((Ext.getCmp('sysFechaHC').getValue() !== "" && Ext.getCmp('sysFechaNac').getValue() !== "" && Ext.getCmp('sysFechaHC').getValue() !== null && Ext.getCmp('sysFechaNac').getValue() !== null)){
                                        var pFec1 = Ext.getCmp('sysFechaHC').getValue();
                                        var pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
                                        var pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
                                        if(pFec2Mes.length===1){
                                            pFec2Mes = "0" + pFec2Mes;
                                        }
                                        var pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
                                        if(pFec2Dia.length===1){
                                            pFec2Dia = "0" + pFec1Dia;
                                        }
                                        var pFec2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;
                                        var AniosCumplidos = MostrarEdadAnios(pFec1, pFec2);
                                        var ResTFG = ((140 - AniosCumplidos) * pNew) / (72 * Ext.getCmp('strPROGESPECreatininaRes').getValue());
                                        if(Ext.getCmp('sysGeneroHC').getValue().substr(0,1) === "F"){
                                            ResTFG = ResTFG * 0.85;
                                        }
                                        Ext.getCmp('intPROGESPETFGIngreso').setValue(ResTFG);
                                        if(ResTFG < 15){
                                            Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio V");
                                        }else{
                                            if(ResTFG < 30){
                                                Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio IV");
                                            }else{
                                                if(ResTFG < 60){
                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio III");
                                                }else{
                                                    if(ResTFG < 90){
                                                        Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio II");
                                                    }else{
                                                        Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio I");
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'displayfield',
                        id: 'sysEXAFISIMC',
                        value: 'IMC: '
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        allowBlank: true,
                        readOnly: true,
                        name: "IMC",
                        id: 'intEXAFISIMC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        name: "IMC - CLASIFICACION",
                        id: 'strEXAFISIMCClasificacon'
                    },
                    {
                        xtype: 'displayfield',
                        id: 'sysEXAFISPA',
                        value: 'P. Abd: '
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'PA',
                        allowBlank: true,
                        id: 'strEXAFISPA'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'Temp:',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'Temp',
                        allowBlank: true,
                        id: 'intEXAFISTemp'
                    },
                    {
                        html: 'F.C.'
                    },                                                            
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'PA',
                        allowBlank: true,
                        id: 'intEXAFISFC'
                    },
                    {
                        html: 'F.R.'
                    },                                                            
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'PA',
                        allowBlank: true,
                        id: 'intEXAFISFR'
                    }
                ]
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Condiciones Generales',
                name: 'Condiciones Generales',
                allowBlank: false,
                id: 'strEXAFISCondicionesGenerales',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISCondicionesGenerales').setValue("No Evaluado");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Cabeza',
                name: 'Cabeza',
                allowBlank: false,
                id: 'strEXAFISCabeza',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISCabeza').setValue("No Evaluado");
                        });
                    }
                }

            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Ojos',
                name: 'Ojos',
                allowBlank: false,
                id: 'strEXAFISOjos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISOjos').setValue("No Evaluado");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Nariz',
                name: 'Nariz',
                allowBlank: false,
                id: 'strEXAFISNariz',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISNariz').setValue("No Evaluado");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Orofaringe',
                name: 'Orofaringe',
                allowBlank: false,
                id: 'strEXAFISOrofaringe',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISOrofaringe').setValue("No Evaluado");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Cuello',
                name: 'Cuello',
                allowBlank: false,
                id: 'strEXAFISCuello',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISCuello').setValue("No Evaluado");
                        });
                    }
                }
            },
            {
                xtype: 'fieldset',
                title: 'Valoracion Mamaria',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items:[
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Aspecto',
                        name: 'Aspecto',
                        allowBlank: false,
                        id: 'strEXAFISMamaAspecto',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaAspecto').setValue("No Evaluado");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Ganglios',
                        name: 'Ganglios',
                        allowBlank: false,
                        id: 'strEXAFISMamaGanglios',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaGanglios').setValue("No Evaluado");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Malestar',
                        name: 'Malestar',
                        allowBlank: false,
                        id: 'strEXAFISMamaMalestar',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaMalestar').setValue("No Evaluado");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Dolores',
                        name: 'Dolores',
                        allowBlank: false,
                        id: 'strEXAFISMamaDolor',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaDolor').setValue("No Evaluado");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Descargas',
                        name: 'Descargas',
                        allowBlank: false,
                        id: 'strEXAFISMamaDescargas',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaDescargas').setValue("No Evaluado");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Masas o Bultos',
                        name: 'Masas o Bultos',
                        allowBlank: false,
                        id: 'strEXAFISMamaMasas',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strEXAFISMamaMasas').setValue("No Evaluado");
                                });
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Dorso',
                name: 'Dorso',
                allowBlank: false,
                id: 'strEXAFISDorso',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISDorso').setValue("No Evaluado");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Cardiaco',
                name: 'Cardiaco',
                allowBlank: false,
                id: 'strEXAFISCardiaco',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISCardiaco').setValue("No Evaluado");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Pulmonar',
                name: 'Pulmonar',
                allowBlank: false,
                id: 'strEXAFISPulmonar',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISPulmonar').setValue("No Evaluado");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Abdomen',
                name: 'Abdomen',
                allowBlank: false,
                id: 'strEXAFISAbdomen',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISAbdomen').setValue("No Evaluado");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Genitales',
                name: 'Genitales',
                allowBlank: false,
                id: 'strEXAFISGenitales',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISGenitales').setValue("No Evaluado");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Extremidades',
                name: 'Extremidades',
                allowBlank: false,
                id: 'strEXAFISExtremidades',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISExtremidades').setValue("No Evaluado");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Neurologico',
                name: 'Neurologico',
                allowBlank: false,
                id: 'strEXAFISNeurologico',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISNeurologico').setValue("No Evaluado");
                        });
                    }
                }
            }
        ];
        fsExamenFisicoUi.superclass.initComponent.call(this);
    }
});
