/*
* @category    Formulario Modelo Evolucion Historia Clinica
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCCronicos002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var stGrid = new StoreGridHistorialMedicamentos();
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        //
        var dataMotivoConsulta = [
            ['Consulta  médica de inscripción DM'],
            ['Consulta  médica de inscripción HTA'],
            ['Consulta médica de inscripción HTA y DM'],
            ['Control HTA'],
            ['Control DM tipo 1'],
            ['Control DM tipo 2'],
            ['Control de HTA y DM']
        ];
        var stMotivoConsulta = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stMotivoConsulta.loadData(dataMotivoConsulta);

        var dataResultadoCitologia = [
            ['Negativa para lesión intraepitelial'],
            ['Infeccion (bacterias, hongos, otros)'],
            ['Cambios celulares reactivos asociados a inflamación'], 
            ['Cambios celulares reactivos asociados a radiación'],
            ['Celulas endometriales (despues de los 40)'], 
            ['Cambios celulares asociados a DIU'],
            ['Celulas glandulares posthisterectomia'],
            ['Atrofia'],
            ['Atipias en celulas escamosas de significado indeterminado (ASC -US)'],
            ['Atipias en celulas escamosas de significado indeterminado sugestivo de LEI de alto grado (ASC- H)'],
            ['Lesión intraepitelial escamosa bajo grado. LEI bg (cambios asociados a infección por VPH o displasia)'],
            ['Lesión intraepitelial de alto grado LEI ag (NIC II, NIC III, Carcinoma in Situ)'],
            ['Lesión escamosa intraepitelial de algo grado sospechosa de infiltración'],
            ['Carcinoma escamocelular invasivo'], 
            ['Celulas endocervicales atipicas sin ningun otro significado'],
            ['Celulas endometriales atipicas sin ningun otro significado'],
            ['Celulas glandulares  atipicas sin ningun otro significado'],
            ['Celulas endocervicales atipicas sospechosas de malignidad'],
            ['Celulas glandulares atipicas sospechosas de malignidad'],
            ['Adenocarcinoma endocervical in situ'],
            ['Adenocarcinoma endocervical infiltrante'],
            ['Adenocarcinoma endometrial'],
            ['Adenocarcinoma extrauterino'],
            ['Adenocarcinoma no especificado'],
            ['Otras neoplasias']
        ];
        var stResultadoCitologia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stResultadoCitologia.loadData(dataResultadoCitologia);
        
        var dataMetodoPlanificacion = [
            ['Ninguno'],
            ['Orales'],
            ['Barrera'],
            ['Inyectable'], 
            ['Pomeroy'],
            ['Otros']
        ];
        var stMetodoPlanificacion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stMetodoPlanificacion.loadData(dataMetodoPlanificacion);
        
        var dataRiesgo = [
            ['SI'],
            ['NO'],
            ['MODIFICADO']
        ];
        var stRiesgo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRiesgo.loadData(dataRiesgo);
        
        var dataTipoMaltrato = [
            ['Físico'],
            ['Psicológico'],
            ['Emocional'],
            ['Sexual'],
            ['Verbal'], 
            ['Otro'] 
        ];
        var stTipoMaltrato = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoMaltrato.loadData(dataTipoMaltrato);
        
        var dataParentezcoMaltrato = [
            ['Padre'], 
            ['Madre'],
            ['Padres'],
            ['Compañero sentimental'],
            ['Familiar cercano'],
            ['Compañero de trabajo o estudio'],
            ['Otro'] 
        ];
        var stParentezcoMaltrato = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stParentezcoMaltrato.loadData(dataParentezcoMaltrato);
        
        var dataConclusion = [
            ['CONTROLADO'],
            ['NO CONTROLADO']
        ];
        var stConclusion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stConclusion.loadData(dataConclusion);
        
        var dataEstratificacionRiesgo = [
            ['RIESGO BAJO'],
            ['RIESGO MEDIO'],
            ['RIESGO ALTO'],
            ['RIESGO MUY ALTO']
        ];
        var stEstratificacionRiesgo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEstratificacionRiesgo.loadData(dataEstratificacionRiesgo);
               
        
        var dataParentesco = [
            ['CONYUGUE O COMPANERO PERMANENTE'],
            ['HIJO - HIJA'],
            ['PADRE - MADRE'],
            ['OTRO MIEMBRO DE LA FAMILIA'],
            ['OTRO NO PERTENECIENTE A LA FAMILIA']
        ];
        var stParentesco = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stParentesco.loadData(dataParentesco);
        
        
        var dataProfesionalAtiende = [
            ['Medico General'],
            ['Medico Especialista'],
            ['Medico Subespecialista'],
            ['Nutricionista'],
            ['Psicologia'],
            ['Enfermera']
        ];
        var stProfesionalAtiende = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProfesionalAtiende.loadData(dataProfesionalAtiende);
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'INFORMACION',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 96,
                                                allowBlank: false,
                                                fieldLabel: 'Ocupacion',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 695,
                                                height: 22,
                                                id: 'sysOcupacionHCNom'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Ocupacion',
                                                id: 'btnSearchOcupacionHC',
                                                listeners:{
                                                    click : function(){
                                                        buscarciuo('sysOcupacionHC','sysOcupacionHCNom');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Etnia',
                                                name: 'Etnia',
                                                width: 370,
                                                allowBlank: false,
                                                store: 'StoreEtnia4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Escolaridad',
                                                width: 380,
                                                allowBlank: false,
                                                store: 'StoreEscolaridad4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Estado Civil',
                                                id: 'sysEstadoCivilHC'
                                            },
                                            {
                                                html: 'Discapacidad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysDiscapacidadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Dirección',
                                                id: 'sysDireccionHC'
                                            },
                                            {
                                                html: 'Telefono:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysTelefonoHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: true,
                                                        id: 'strDATINGPROGAcompanante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 350,
                                                        allowBlank: true,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATINGPROGParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: stMotivoConsulta,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'HISTORIAL MEDICAMENTOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        id: 'gridHistorialMedicamentos',
                                                        store: stGrid,
                                                        anchor: "100%",
                                                        height: 200,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        stripeRows: true,
                                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                                            {
                                                                header: 'FechaAtencion',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'FechaAtencion',
                                                                width: 100,
                                                                align: 'center',
                                                                hideable: false
                                                            },
                                                            {
                                                                header: 'DxPpal',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'DxPpal',
                                                                width: 60,
                                                                align: 'center',
                                                                hideable: false
                                                            },
                                                            {
                                                                header: 'DescripcionDx',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'DescripcionDx',
                                                                width: 300,
                                                                align: 'center',
                                                                hideable: false
                                                            },
                                                            {
                                                                header: 'Medicamento',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'Medicamento',
                                                                width: 300,
                                                                align: 'center',
                                                                hideable: false
                                                            },
                                                            {
                                                                header: 'Cantidad',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'Cantidad',
                                                                width: 70,
                                                                align: 'center',
                                                                hideable: false
                                                            },
                                                            {
                                                                header: 'Posologia',
                                                                readOnly: true,
                                                                sortable: false,
                                                                dataIndex: 'Posologia',
                                                                width: 200,
                                                                align: 'center',
                                                                hideable: false
                                                            }
                                                        ]),
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        view: new Ext.ux.grid.LockingGridView(),
                                                        columnLines: true,
                                                        tbar:
                                                        {
                                                            xtype: 'toolbar',
                                                            anchor:'100%',
                                                            items:[
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Actualizar',
                                                                    iconCls: 'btnActualizarGrid',
                                                                    tooltip: 'Actualizar',
                                                                    id: 'btnActualizar'
                                                                },
                                                            ]
                                                        }
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 400,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'El usuario manifies reacciones adversas o secundarias con su uso?',
                                                                fieldLabel: 'El usuario manifies reacciones adversas o secundarias con su uso?',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strReaccionMedicamento'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Especificar',
                                                        fieldLabel: 'Especificar',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strReaccionMedicamentoEspecificar'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 200,
                                                                height: 500,
                                                                labelWidth: 80,
                                                                labelSeparator: '',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Insuficiencia Cardiaca',
                                                                        name: 'Insuficiencia Cardiaca',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strInsuficienciaCardiaca'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Arritmias<br>&nbsp;',
                                                                        name: 'Arritmias',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strArritmias'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Valvulopatias<br>&nbsp;',
                                                                        name: 'Valvulopatias',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strValvulopatias'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Cardiopatia<br>&nbsp;',
                                                                        name: 'Cardiopatia',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strCardiopatia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Transtornos Neurologicos',
                                                                        name: 'Transtornos Neurologicos',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strTranstornosNeurologicos'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Hipertension Arterial',
                                                                        name: 'Hipertension Arterial',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strHipertensionArterial'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Diabetes<br>&nbsp;',
                                                                        name: 'Diabetes',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strDiabetes'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Dislipidemias<br>&nbsp;',
                                                                        name: 'Dislipidemias',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strDislipidemias'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Hipertiroidismo<br>&nbsp;',
                                                                        name: 'Hipertiroidismo',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strHipertiroidismo'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Retinopatia<br>&nbsp;',
                                                                        name: 'Retinopatia',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strRetinopatia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Glaucoma<br>&nbsp;',
                                                                        name: 'Glaucoma',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strGlaucoma'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Nefropatia<br>&nbsp;',
                                                                        name: 'Nefropatia',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strNefropatia'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 200,
                                                                height: 500,
                                                                labelWidth: 80,
                                                                labelSeparator: '',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Evento Cerebrovascular',
                                                                        name: 'Evento Cerebro Vascular',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strEventoCerebroVascular'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Enfermedad Coronaria',
                                                                        name: 'Enfermedad Coronaria',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strEnfermedadCoronaria'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Hipotiroidismo<br>&nbsp;',
                                                                        name: 'Hipotiroidismo',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strHipotiroidismo'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Coma Diabetico',
                                                                        name: 'Coma Diabetico',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strComaDiabetico'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Cetoacedosis<br>&nbsp;',
                                                                        name: 'Cetoacedosis',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strCetoacedosis'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Hipoglicemias<br>&nbsp;',
                                                                        name: 'Hipoglicemias',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strCetoacedosis'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Diabetes Gestacional',
                                                                        name: 'Diabetes Gestacional',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strDiabetesGestacional'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Preclampsia<br>&nbsp;',
                                                                        name: 'Preclampsia',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strPreclampsia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Transtornos Hormonales',
                                                                        name: 'Transtornos Hormonales',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strTranstornosHormonales'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Litiasis Renal<br>&nbsp;',
                                                                        name: 'Litiasis Renal',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strLitiasisRenal'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Hiperuricemia<br>&nbsp;',
                                                                        name: 'Hiperuricemia',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strHiperuricemia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Enfermedad Vascular Periferica',
                                                                        name: 'Enfermedad Vascular Periferica',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strEnfermedadVascularPeriferica'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 400,
                                                                height: 500,
                                                                labelWidth: 80,
                                                                labelSeparator: '',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Menopausia<br>&nbsp;',
                                                                        name: 'Menopausia',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strMenopausia'
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Alergicos<br>&nbsp;',
                                                                                name: 'Alergicos',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strAlergicos'
                                                                            },
                                                                            {
                                                                                html: 'Especifique:'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name: 'Alergicos Descripcion',
                                                                                width: 100,
                                                                                allowBlank: true,
                                                                                id: 'strAlergicosDescripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Quirurgicos<br>&nbsp;',
                                                                                name: 'Quirurgicos',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strQuirurgicos'
                                                                            },
                                                                            {
                                                                                html: 'Especifique:'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name: 'Quirurgicos Descripcion',
                                                                                width: 100,
                                                                                allowBlank: true,
                                                                                id: 'strQuirurgicosDescripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Hospitalizaciones<br>&nbsp;',
                                                                                name: 'Hospitalizaciones',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strQuirurgicos'
                                                                            },
                                                                            {
                                                                                html: 'Especifique:'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name: 'Hospitalizaciones Descripcion',
                                                                                width: 100,
                                                                                allowBlank: true,
                                                                                id: 'strHospitalizacionesDescripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Traumaticos<br>&nbsp;',
                                                                                name: 'Traumaticos',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strTraumaticos'
                                                                            },
                                                                            {
                                                                                html: 'Especifique:'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name: 'Traumaticos Descripcion',
                                                                                width: 100,
                                                                                allowBlank: true,
                                                                                id: 'strTraumaticosDescripcion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Otros<br>&nbsp;',
                                                                                name: 'Otros',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strOtros'
                                                                            },
                                                                            {
                                                                                html: 'Especifique:'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name: 'Otros Descripcion',
                                                                                width: 100,
                                                                                allowBlank: true,
                                                                                id: 'strOtrosDescripcion'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memObservacionesAntecedentesPersonales'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES GINECOLOGICOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelWidth: 150,
                                                autoHeight: true,
                                                padding: 7,
                                                id: 'fsAntecedentesGinecologicos',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Ultima Mestruacion',
                                                                name: 'Fecha Ultima Mestruacion',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFechaUltimaMestruacion'
                                                            },
                                                            {
                                                                html: 'Fecha Ultimo Parto'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha Ultimo Parto',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFechaUltimoParto'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 250,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Se ha realizado una citologia alguna vez',
                                                                        name: 'Se ha realizado una citologia alguna vez',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strCitologia'
                                                                    },
                                                                    {
                                                                        html: 'Fecha Ultima Citologia'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Ultima Citologia',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaUltimaCitologia'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Resultado Citologia',
                                                                fieldLabel: 'Resultado Citologia',
                                                                width: 400,
                                                                allowBlank: true,
                                                                store: stResultadoCitologia,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strResultadoCitologia'
                                                            },
                                                            {
                                                                html: 'Fecha Proxima Citologia'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha Proxima Citologia',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFechaProximaCitologia'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Procedimientos anteriores en Cuello Uterino',
                                                        name: 'Procedimientos anteriores en Cuello Uterino',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memProcedimientosCuelloUterino'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Sabe realizarse el Autoexamen de Mama',
                                                                name: 'Sabe realizarse el Autoexamen de Mama',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strAutoexamenMama'
                                                            },
                                                            {
                                                                html: 'Cada cuanto lo hace'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Cada cuanto lo hace',
                                                                id: 'strAutoexamenMamaTiempo'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 450,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Siente que tiene el conocimiento que le permita practicarselo adecuadamente',
                                                                fieldLabel: 'Siente que tiene el conocimiento que le permita practicarselo adecuadamente',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strAutoexamenMamaConocimiento'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 120,
                                                        name: 'Fecha Ultima Mamografia',
                                                        fieldLabel: 'Fecha Ultima Mamografia',
                                                        allowBlank: true,
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecFechaUltimaMamografia'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Ciclos Regulares',
                                                                fieldLabel: 'Ciclos Regulares',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strCiclosRegulares'
                                                            },
                                                            {
                                                                html: 'Dismenorrea'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Dismenorrea',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strDismenorrea'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Flujo patológico o secreción uretral',
                                                                fieldLabel: 'Flujo patológico o secreción uretral',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strFlujoPatologicoGinecologico'
                                                            },
                                                            {
                                                                html: 'Infecciones transmitidas sexualmente'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Infecciones transmitidas sexualmente',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strInfeccionTransmisionSexual'
                                                            },
                                                            {
                                                                html: 'Anticoncepcion'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Anticoncepcion',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strAnticoncepcionGinecologico'
                                                            },
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES ANDROLOGICOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelWidth: 150,
                                                autoHeight: true,
                                                padding: 7,
                                                id: 'fsAntecedentesAndrologicos',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 450,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Sabe realizarse el Autoexamen de testiculo',
                                                                name: 'Sabe realizarse el Autoexamen de testiculo',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strAutoexamenTesticulo'
                                                            },
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Siente que tiene el conocimiento que le permita practicarselo adecuadamente',
                                                                fieldLabel: 'Siente que tiene el conocimiento que le permita practicarselo adecuadamente',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strAutoexamenTesticuloConocimiento'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha PSA',
                                                                fieldLabel: 'Fecha PSA',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFechaPSA'
                                                            },
                                                            {
                                                                html: 'Resultado'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Resultado PSA',
                                                                id: 'strResultadoPSA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 250,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Flujo patológico o secreción uretral',
                                                                        fieldLabel: 'Flujo patológico o secreción uretral',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strFlujoPatologicoAndrologico'
                                                                    },
                                                                    {
                                                                        html: 'Anticoncepcion'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Anticoncepcion',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strAnticoncepcionAndrologico'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'METODOS DE PLANIFICACION',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Metodo Actual',
                                                                fieldLabel: 'Metodo Actual',
                                                                width: 400,
                                                                allowBlank: true,
                                                                store: stMetodoPlanificacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strMetodoPlanificacion'
                                                            },
                                                            {
                                                                html: 'Nombre'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                name: 'Nombre',
                                                                id: 'strNombreMetodoPlanificacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Tiempo de Uso',
                                                                fieldLabel: 'Tiempo de Uso',
                                                                id: 'strMetodoPlanificacionTiempoUso'
                                                            },
                                                            {
                                                                html: 'Fecha Inicio'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha Inicio',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFechaInicioMetodoPlanificacion'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 200,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Satisfaccion Metodo',
                                                                        fieldLabel: 'Satisfaccion Metodo',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strMetodoSatisfaccionMetodo'
                                                                    },
                                                                    {
                                                                        html: 'Problemas Metodo'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 300,
                                                                        allowBlank: true,
                                                                        name: 'Problemas Metodo',
                                                                        id: 'strMetodoPlanificacionProblemasMetodo'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 300,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Remisión a programa de planificación familiar?',
                                                                fieldLabel: 'Remisión a programa de planificación familiar?',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRemisionPlanificacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 300,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Remisión a mamografia o patologia de mama?',
                                                                fieldLabel: 'Remisión a mamografia o patologia de mama?',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRemisionMamografia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 300,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Remisión a toma de citologia cervico uterina?',
                                                                fieldLabel: 'Remisión a toma de citologia cervico uterina?',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRemisionCitologia'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 420,
                                                                height: 280,
                                                                labelWidth: 80,
                                                                labelSeparator: '',
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Hipertension',
                                                                                fieldLabel: 'Hipertension<br>&nbsp;',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strHipertensionFamiliar'
                                                                            },
                                                                            {
                                                                                html: 'Parentezco'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                name: 'Parentezco Hipertension',
                                                                                id: 'strHipertensionFamiliarParentezco'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Enfermedad Coronaria',
                                                                                fieldLabel: 'Enfermedad Coronaria',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strEnfermedadCoronariaFamiliar'
                                                                            },
                                                                            {
                                                                                html: 'Parentezco'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                name: 'Parentezco Enfermedad Coronaria',
                                                                                id: 'strEnfermedadCoronariaFamiliarParentezco'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Muerte menor 60 años',
                                                                                fieldLabel: 'Muerte menor 60 años',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strMuerteMenorFamiliar'
                                                                            },
                                                                            {
                                                                                html: 'Parentezco'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                name: 'Parentezco Muerte en menores de 60 años',
                                                                                id: 'strMuerteMenorFamiliarParentezco'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Dislipidemias',
                                                                                fieldLabel: 'Dislipidemias<br>&nbsp;',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strDislipidemiasFamiliar'
                                                                            },
                                                                            {
                                                                                html: 'Parentezco'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                name: 'Parentezco Dislipidemias',
                                                                                id: 'strDislipidemiasFamiliarParentezco'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'ECV',
                                                                                fieldLabel: 'ECV<br>&nbsp;',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strECVFamiliar'
                                                                            },
                                                                            {
                                                                                html: 'Parentezco'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                name: 'Parentezco ECV',
                                                                                id: 'strECVFamiliarParentezco'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Obesos',
                                                                                fieldLabel: 'Obesos<br>&nbsp;',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strObesosFamiliar'
                                                                            },
                                                                            {
                                                                                html: 'Parentezco'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                name: 'Parentezco Obesos',
                                                                                id: 'strObesosFamiliarParentezco'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 420,
                                                                height: 280,
                                                                labelWidth: 80,
                                                                labelSeparator: '',
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Diabetes',
                                                                                fieldLabel: 'Diabetes<br>&nbsp;',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strDiabetesFamiliar'
                                                                            },
                                                                            {
                                                                                html: 'Parentezco'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                name: 'Parentezco Diabetes',
                                                                                id: 'strDiabetesFamiliarParentezco'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Enfermedad Mental',
                                                                                fieldLabel: 'Enfermedad Mental',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strEnfermedadMentalFamiliar'
                                                                            },
                                                                            {
                                                                                html: 'Parentezco'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                name: 'Parentezco Enfermedad Mental',
                                                                                id: 'strEnfermedadMentalFamiliarParentezco'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Cancer',
                                                                                fieldLabel: 'Cancer<br>&nbsp;',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strCancerFamiliar'
                                                                            },
                                                                            {
                                                                                html: 'Parentezco'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                name: 'Parentezco Cancer',
                                                                                id: 'strCancerFamiliarParentezco'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Hematologicos',
                                                                                fieldLabel: 'Hematologicos<br>&nbsp;',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strHematologicosFamiliar'
                                                                            },
                                                                            {
                                                                                html: 'Parentezco'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                name: 'Parentezco Hematologicos',
                                                                                id: 'strHematologicosFamiliarParentezco'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Nefropatias',
                                                                                fieldLabel: 'Nefropatias<br>&nbsp;',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strNefropatiasFamiliar'
                                                                            },
                                                                            {
                                                                                html: 'Parentezco'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 150,
                                                                                allowBlank: true,
                                                                                name: 'Parentezco Nefropatias',
                                                                                id: 'strNefropatiasFamiliarParentezco'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memObservacionesAntecedentesFamiliar'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'VALORACIÓN Y EVOLUCIÓN DE LOS FACTORES DE RIESGO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        html: 'Consumo de grasa saturada y colesterol; señalar "SI", si el consumo es mayor a dos veces por semana<br>&nbsp;'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 420,
                                                                height: 250,
                                                                labelWidth: 80,
                                                                labelSeparator: '',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Fritos',
                                                                        fieldLabel: 'Fritos<br>&nbsp;',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRiesgoFritos'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Carnes Frias',
                                                                        fieldLabel: 'Carnes Frias<br>&nbsp;',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRiesgoCarnesFrias'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Fritanga',
                                                                        fieldLabel: 'Fritanga<br>&nbsp;',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRiesgoFritanga'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Carne gorda',
                                                                        fieldLabel: 'Carne gorda<br>&nbsp;',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRiesgoCarneGorda'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Comidas Rapidas',
                                                                        fieldLabel: 'Comidas Rapidas',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRiesgoComidasRapidas'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Yema Huevo',
                                                                        fieldLabel: 'Yema Huevo<br>&nbsp;',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRiesgoYemaHuevo'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 420,
                                                                height: 250,
                                                                labelWidth: 80,
                                                                labelSeparator: '',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Mantequilla o Margarina',
                                                                        fieldLabel: 'Mantequilla o Margarina',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRiesgoMantequilla'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Visceras',
                                                                        fieldLabel: 'Visceras<br>&nbsp;',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRiesgoVisceras'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Tocinos',
                                                                        fieldLabel: 'Tocinos<br>&nbsp;',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRiesgoTocinos'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Leche y Queso',
                                                                        fieldLabel: 'Leche y Queso',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRiesgoLeche'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Chicharron',
                                                                        fieldLabel: 'Chicharron<br>&nbsp;',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strRiesgoChicharron'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: 'Consumo de fibra soluble y micronutrientes; señalar "NO" si su consumo es menor a cuatro veces por semana<br>&nbsp;'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Frutos',
                                                        fieldLabel: 'Frutos',
                                                        width: 100,
                                                        allowBlank: true,
                                                        store: stRiesgo,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strRiesgoFrutos'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Verduras',
                                                        fieldLabel: 'Verduras',
                                                        width: 100,
                                                        allowBlank: true,
                                                        store: stRiesgo,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strRiesgoVerduras'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Leguminosas',
                                                        fieldLabel: 'Leguminosas',
                                                        width: 100,
                                                        allowBlank: true,
                                                        store: stRiesgo,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strRiesgoLeguminosas'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 450,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Actividad Física (señalar "NO" si su práctica diaria es menor a 40 minutos y/o es realizada menos de 4 veces a la semana)',
                                                                fieldLabel: 'Actividad Física (señalar "NO" si su práctica diaria es menor a 40 minutos y/o es realizada menos de 4 veces a la semana)',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRiesgoActividadFisica'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Licor',
                                                                fieldLabel: 'Licor',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRiesgoLicor'
                                                            },
                                                            {
                                                                html: 'Frecuencia'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Frecuencia',
                                                                id: 'strRiesgoLicorFrecuencia'
                                                            },
                                                            {
                                                                html: 'Tipo Licor'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Tipo Licor',
                                                                id: 'strRiesgoLicorTipoLicor'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Tabaquismo',
                                                                fieldLabel: 'Tabaquismo',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRiesgoTabaquismo'
                                                            },
                                                            {
                                                                html: 'Frecuencia'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Frecuencia',
                                                                id: 'strRiesgoTabaquismoFrecuencia'
                                                            },
                                                            {
                                                                html: 'Exfumador'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Exfumador',
                                                                id: 'strRiesgoTabaquismoExfumador'
                                                            },
                                                            {
                                                                html: 'Tiempo'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Tiempo',
                                                                id: 'strRiesgoTabaquismoTiempo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 200,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Alguien Fuma en tu Familia',
                                                                fieldLabel: 'Alguien Fuma en tu Familia',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRiesgoTabaquismoFamilia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Sustancais Psicoactivas',
                                                                fieldLabel: 'Sustancais Psicoactivas',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRiesgoSustancaisPsicoactivas'
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Cual',
                                                                id: 'strRiesgoSustancaisPsicoactivasCual'
                                                            },
                                                            {
                                                                html: 'Veces Dia'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Veces Dia',
                                                                id: 'strRiesgoSustancaisPsicoactivasVecesDia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Otros',
                                                                fieldLabel: 'Otros',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRiesgoOtros'
                                                            },
                                                            {
                                                                html: 'Especifique'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Especifique',
                                                                id: 'strRiesgoOtrosEspecifique'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'FACTORES DE RIESGO PSICOSOCIAL',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Con quien Vive',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '100%',
                                                                padding: 0,
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 200,
                                                                        height: 120,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Esposo',
                                                                                name: 'Esposo',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolViveEsposo'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Hijos',
                                                                                name: 'Hijos',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolViveHijos'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Padre',
                                                                                name: 'Padre',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolVivePadre'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Suegros',
                                                                                name: 'Suegros',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolViveSuegros'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 400,
                                                                        height: 120,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Padrastro',
                                                                                name: 'Padrastro',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolVivePadrastro'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Madrastra',
                                                                                name: 'Madrastra',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolViveMadrastra'
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'checkbox',
                                                                                        fieldLabel: 'Otros',
                                                                                        name: 'Otros',
                                                                                        anchor: '100%',
                                                                                        value: 'false',
                                                                                        id: 'bolViveOtros'
                                                                                    },
                                                                                    {
                                                                                        html: 'Cual'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        width: 200,
                                                                                        allowBlank: true,
                                                                                        name: 'Cual',
                                                                                        id: 'strViveOtrosCual'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Cuando tiene dificultades recibe apoyo por',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '100%',
                                                                padding: 0,
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 200,
                                                                        height: 120,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Esposo',
                                                                                name: 'Esposo',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolDificultadesEsposo'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Hijos',
                                                                                name: 'Hijos',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolDificultadesHijos'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Padre',
                                                                                name: 'Padre',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolDificultadesPadre'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Suegros',
                                                                                name: 'Suegros',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolDificultadesSuegros'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 400,
                                                                        height: 120,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Padrastro',
                                                                                name: 'Padrastro',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolDificultadesPadrastro'
                                                                            },
                                                                            {
                                                                                xtype: 'checkbox',
                                                                                fieldLabel: 'Madrastra',
                                                                                name: 'Madrastra',
                                                                                anchor: '100%',
                                                                                value: 'false',
                                                                                id: 'bolDificultadesMadrastra'
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'checkbox',
                                                                                        fieldLabel: 'Otros',
                                                                                        name: 'Otros',
                                                                                        anchor: '100%',
                                                                                        value: 'false',
                                                                                        id: 'bolDificultadesOtros'
                                                                                    },
                                                                                    {
                                                                                        html: 'Cual'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        width: 200,
                                                                                        allowBlank: true,
                                                                                        name: 'Cual',
                                                                                        id: 'strDificultadesOtrosCual'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Ha sido ó es víctima de violencia',
                                                                fieldLabel: 'Ha sido ó es víctima de violencia',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRiesgoOtros'
                                                            },
                                                            {
                                                                html: 'De que Tipo?'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'De que Tipo?',
                                                                width: 120,
                                                                allowBlank: true,
                                                                store: stTipoMaltrato,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strTipoMaltrato'
                                                            },
                                                            {
                                                                html: 'Parentezco Maltratador'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Parentezco Maltratador?',
                                                                width: 200,
                                                                allowBlank: true,
                                                                store: stParentezcoMaltrato,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strParentezcoMaltratador'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Exposición a estresores (último año)',
                                                                fieldLabel: 'Exposición a estresores (último año)',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRiesgoEstresores'
                                                            },
                                                            {
                                                                html: 'Especifique'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 200,
                                                                allowBlank: true,
                                                                name: 'Especifique',
                                                                id: 'strRiesgoEstresoresEspecifique'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Signos o sintomas de depresión?',
                                                                fieldLabel: 'Signos o sintomas de depresión?',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRiesgoDepresion'
                                                            },
                                                            {
                                                                html: 'Signos o sintomas de ansiedad?'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Signos o sintomas de ansiedad?',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRiesgoAnsiedad'
                                                            },
                                                            {
                                                                html: 'Especifique'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 200,
                                                                allowBlank: true,
                                                                name: 'Especifique',
                                                                id: 'strRiesgoAnsiedadEspecifique'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Trastornos alimenticios?',
                                                        fieldLabel: 'Trastornos alimenticios?',
                                                        width: 100,
                                                        forceSelection: true,
                                                        emptyText: 'SI/NO',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        listEmptyText: '',
                                                        triggerAction: 'all',
                                                        store:'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        id: 'strRiesgoTrastornosAlimenticios'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PRESENCIA DE SÍNTOMAS GUÍA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 400,
                                                                labelWidth: 80,
                                                                labelSeparator: '',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Cefalea',
                                                                        fieldLabel: 'Cefalea<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasCefalea'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Lipotimia',
                                                                        fieldLabel: 'Lipotimia<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasLipotimia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Convulsiones',
                                                                        fieldLabel: 'Convulsiones<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasConvulsiones'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Trastornos de Consciencia',
                                                                        fieldLabel: 'Trastornos de Consciencia',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasTrastornosConsciencia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Vertigo',
                                                                        fieldLabel: 'Vertigo<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasVertigo'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Tinitus',
                                                                        fieldLabel: 'Tinitus<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasTinitus'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Cambios Visuales',
                                                                        fieldLabel: 'Cambios Visuales',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasCambiosVisuales'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Precordialgia',
                                                                        fieldLabel: 'Precordialgia<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasPrecordialgia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Disnea Paroxistica',
                                                                        fieldLabel: 'Disnea Paroxistica',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasDisneaParoxistica'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 400,
                                                                labelWidth: 80,
                                                                labelSeparator: '',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Disnea de Esfuerzo',
                                                                        fieldLabel: 'Disnea de Esfuerzo',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasDisneaEsfuerzo'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Ortopnea',
                                                                        fieldLabel: 'Ortopnea<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasOrtopnea'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Debilidad',
                                                                        fieldLabel: 'Debilidad<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasDebilidad'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Taquicardias',
                                                                        fieldLabel: 'Taquicardias<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasTaquicardias'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Polidipsia',
                                                                        fieldLabel: 'Polidipsia<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasPolidipsia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Polifagia',
                                                                        fieldLabel: 'Polifagia<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasPolifagia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Poliuria',
                                                                        fieldLabel: 'Poliuria<br>&nbsp;',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasPoliuria'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Disfunsión erectil',
                                                                        fieldLabel: 'Disfunsión erectil',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasDisfunsiónErectil'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Hematuria',
                                                                        fieldLabel: 'Hematuria',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasHematuria'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 350,
                                                                height: 400,
                                                                labelWidth: 80,
                                                                labelSeparator: '',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Claudicación de MM',
                                                                        fieldLabel: 'Claudicación de MM',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasClaudicaciónMM'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Pérdida de peso',
                                                                        fieldLabel: 'Pérdida de peso',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasPerdidaPeso'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Ganancia de peso',
                                                                        fieldLabel: 'Ganancia de peso',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasGananciaPeso'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Lesiones en piel',
                                                                        fieldLabel: 'Lesiones en piel',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasLesionesPiel'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Heridas en pies',
                                                                        fieldLabel: 'Heridas en pies',
                                                                        width: 100,
                                                                        forceSelection: true,
                                                                        emptyText: 'SI/NO',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strSintomasHeridasPies'
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Otros',
                                                                                fieldLabel: 'Otros',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strSintomasOtros'
                                                                            },
                                                                            {
                                                                                html: 'Cual'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                width: 100,
                                                                                allowBlank: true,
                                                                                name: 'Cual',
                                                                                id: 'strSintomasOtrosCual'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memObservacionesSintomas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'FACTORES PROTECTORES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Que Hacen en Tiempo Libre',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '100%',
                                                                padding: 0,
                                                                layoutConfig: {
                                                                    columns: 2
                                                                },
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 250,
                                                                        height: 120,
                                                                        labelWidth: 80,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Deportes',
                                                                                fieldLabel: 'Deportes',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strTiempoLibreDeportes'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Televisión',
                                                                                fieldLabel: 'Televisión',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strTiempoLibreTelevision'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Fiestas',
                                                                                fieldLabel: 'Fiestas',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strTiempoLibreFiestas'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Juegos de barrio',
                                                                                fieldLabel: 'Juegos de barrio',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strTiempoLibreJuegosBarrio'
                                                                            },
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 250,
                                                                        height: 120,
                                                                        labelWidth: 80,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Arte',
                                                                                fieldLabel: 'Arte',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strTiempoLibreArte'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Lectura',
                                                                                fieldLabel: 'Lectura',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strTiempoLibreLectura'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Internet',
                                                                                fieldLabel: 'Internet',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strTiempoLibreInternet'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                name: 'Juegos electronicos',
                                                                                fieldLabel: 'Juegos electronicos',
                                                                                width: 100,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                id: 'strTiempoLibreJuegosElectronicos'
                                                                            },
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memObservacionesFactoresProtectores'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEXAFISTalla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFISTalla').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                       if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DESGADEZ SEVERA");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                                }else{
                                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                                    }else{
                                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                        Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPeso',
                                                                value: 'PESO (Kg) '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEXAFISPeso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFISPeso').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DESGADEZ SEVERA");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                                }else{
                                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                                    }else{
                                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                        Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISIMC',
                                                                value: 'IMC '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEXAFISIMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEXAFISIMCClasificacon'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPA',
                                                                value: 'Per. Abd.'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Perimetro Abdominal',
                                                                allowBlank: true,
                                                                id: 'strEXAFISPA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'Temp',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Temperatura',
                                                                allowBlank: true,
                                                                id: 'intEXAFISTemp'
                                                            },
                                                            {
                                                                html: 'F.C.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Frecuencia Cardiaca',
                                                                allowBlank: true,
                                                                id: 'intEXAFISFC'
                                                            },
                                                            {
                                                                html: 'F.R.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Frecuencia Respiratoria',
                                                                allowBlank: true,
                                                                id: 'intEXAFISFR'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 250,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        fieldLabel: 'T.A. (Sentado) Derecha',
                                                                        name: 'T.A. (Sentado) Sistolica Derecha',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 300,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEXAFISTASentadoSistolicaDerecha'
                                                                    },
                                                                    {
                                                                        html: '/'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'T.A. (Sentado) Diastolica Derecha',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 300,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEXAFISTASentadoDiastolicaDerecha'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        fieldLabel: 'T.A. (Sentado) Izquierda',
                                                                        name: 'T.A. (Sentado) Sistolica Izquierda',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 300,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEXAFISTASentadoSistolicaIzquierda'
                                                                    },
                                                                    {
                                                                        html: '/'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'T.A. (Sentado) Diastolica Izquierda',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 300,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEXAFISTASentadoDiastolicaIzquierda'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        fieldLabel: 'T.A. (en Pie)',
                                                                        name: 'T.A. (en Pie) Sistolica',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 300,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEXAFISTAPieSistolica'
                                                                    },
                                                                    {
                                                                        html: '/'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'T.A. (en Pie) Diastolica',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 300,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEXAFISTAPieDiastolica'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        fieldLabel: 'Val maximo T.A.',
                                                                        name: 'Val maximo T.A. Sistolica',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 300,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEXAFISTAValSistolica'
                                                                    },
                                                                    {
                                                                        html: '/'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Val maximo T.A. Diastolica',
                                                                        width: 70,
                                                                        minValue: 0,
                                                                        maxValue: 300,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEXAFISTAValDiastolica'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Apariencia',
                                                        name: 'Apariencia',
                                                        allowBlank: true,
                                                        id: 'strEXAFISApariencia'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Neurologico',
                                                        name: 'Neurologico',
                                                        allowBlank: true,
                                                        id: 'strEXAFISNeurologico'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'Agudeza OD',
                                                                width: 60,
                                                                name: 'Agudeza OD',
                                                                emptyText: 'sobre 20',
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intAgudezaOD'
                                                            },
                                                            {
                                                                html: 'Agudeza OI'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                name: 'Agudeza OI',
                                                                emptyText: 'sobre 20',
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intAgudezaOI'
                                                            },
                                                            {
                                                                html: 'Fondo Ojo'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Fondo Ojo',
                                                                id: 'strFondoOjo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Retinopatia Hipertensiva',
                                                                fieldLabel: 'Retinopatia Hipertensiva',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRetinopatiaHipertensiva'
                                                            },
                                                            {
                                                                html: 'Retinopatia Diabetica'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Retinopatia Diabetica',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strRetinopatiaDiabetica'
                                                            },
                                                            {
                                                                html: 'Otros Hallazgos'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                name: 'Otros Hallazgos',
                                                                id: 'strOtrosHallazgos'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Remision Agudeza Visual',
                                                        fieldLabel: 'Remision Agudeza Visual',
                                                        width: 100,
                                                        forceSelection: true,
                                                        emptyText: 'SI/NO',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        listEmptyText: '',
                                                        triggerAction: 'all',
                                                        store:'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        id: 'strRemisionAgudezaVisual'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                name: 'Oidos',
                                                                fieldLabel: 'Oidos',
                                                                id: 'strOidos'
                                                            },
                                                            {
                                                                html: 'Nariz'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                name: 'Nariz',
                                                                id: 'strNariz'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 200,
                                                                allowBlank: true,
                                                                name: 'Boca',
                                                                fieldLabel: 'Boca',
                                                                id: 'strBoca'
                                                            },
                                                            {
                                                                html: 'Fecha Ultima Consulta Odontologia'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha Ultima Consulta Odontologia',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFechaUltimaConsultaOdontologia'
                                                            },
                                                            {
                                                                html: 'Referencia Salud Oral'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Referencia Salud Oral',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strReferenciaSaludOral'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Masas en Cuello',
                                                                fieldLabel: 'Masas en Cuello',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strMasasCuello'
                                                            },
                                                            {
                                                                html: 'Descripcion'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Descripcion',
                                                                id: 'strMasasCuelloDescripcion'
                                                            },
                                                            {
                                                                html: 'Tiroides'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Tiroides',
                                                                id: 'strTiroides'
                                                            },
                                                            {
                                                                html: 'Ingurgitación Yugular'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Ingurgitación Yugular',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strIngurgitacionYugular'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 250,
                                                        allowBlank: true,
                                                        name: 'Mamas',
                                                        fieldLabel: 'Mamas',
                                                        id: 'strMamas'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                name: 'Corazon',
                                                                fieldLabel: 'Corazon',
                                                                id: 'strCorazon'
                                                            },
                                                            {
                                                                html: 'RsCs'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'RsCs',
                                                                id: 'strRsCs'
                                                            },
                                                            {
                                                                html: 'Soplos'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Soplos',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strSoplos'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                name: 'Pulmones',
                                                                fieldLabel: 'Pulmones',
                                                                id: 'strPulmones'
                                                            },
                                                            {
                                                                html: 'Sintomático Respiratorio?'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Sintomático Respiratorio?',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strSintomáticoRespiratorio'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                name: 'Abdomen',
                                                                fieldLabel: 'Abdomen',
                                                                id: 'strAbdomen'
                                                            },
                                                            {
                                                                html: 'Masas'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Masas',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strAbdomenMasas'
                                                            },
                                                            {
                                                                html: 'Megalias'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Megalias',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strAbdomenMegalias'
                                                            },
                                                            {
                                                                html: 'Soplos'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Soplos',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strAbdomenSoplos'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Ascitis',
                                                                fieldLabel: 'Ascitis',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strAbdomenAscitis'
                                                            },
                                                            {
                                                                html: 'Tacto Rectal'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Tacto Rectal',
                                                                id: 'strAbdomenTactoRectal'
                                                            },
                                                            {
                                                                html: 'Otros'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Otros',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strAbdomenOtros'
                                                            },
                                                            {
                                                                html: 'Especifique'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Especifique',
                                                                id: 'strAbdomenEspecifique'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 250,
                                                        allowBlank: true,
                                                        name: 'Genitales',
                                                        fieldLabel: 'Genitales',
                                                        id: 'strGenitales'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Edemas Extremidades',
                                                                fieldLabel: 'Edemas Extremidades',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strEdemasExtremidades'
                                                            },
                                                            {
                                                                html: 'Especifique'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Especifique',
                                                                id: 'strEdemasExtremidadesEspecifique'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Pulsos Pedios Pie Derecho',
                                                                fieldLabel: 'Pulsos Pedios Pie Derecho',
                                                                id: 'strPulsosPediosPieDerecho'
                                                            },
                                                            {
                                                                html: 'Pulsos Pedios Pie Izquierdo'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Pulsos Pedios Pie Izquierdo',
                                                                id: 'strPulsosPediosPieIzquierdo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Pulsos Tibial Pos. MID',
                                                                fieldLabel: 'Pulsos Tibial Pos. MID',
                                                                id: 'strPulsosTibialPosMID'
                                                            },
                                                            {
                                                                html: 'Pulsos Tibial Pos. MII'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Pulsos Tibial Pos. MII',
                                                                id: 'strPulsosTibialPosMID'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                fieldLabel: 'Sensibilidad Sup. Der.',
                                                                name: 'Sensibilidad Superficial Derecha',
                                                                id: 'strSensibilidadSuperficialDerecha'
                                                            },
                                                            {
                                                                html: 'Sensibilidad Sup. Izq.'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Sensibilidad Superficial Izqueirda',
                                                                id: 'strSensibilidadSuperficialIzqueirda'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                name: 'Piel y Faneras',
                                                                fieldLabel: 'Piel y Faneras',
                                                                id: 'strPielFaneras'
                                                            },
                                                            {
                                                                html: 'Sintomatico Piel'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Sintomatico Piel',
                                                                width: 100,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                id: 'strSintomaticoPiel'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'OsteoArticular',
                                                                fieldLabel: 'OsteoArticular',
                                                                id: 'strOsteoArticular'
                                                            },
                                                            {
                                                                html: 'Fuerza'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Fuerza',
                                                                id: 'strFuerza'
                                                            },
                                                            {
                                                                html: 'Reflejos Osteotendinosos'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Reflejos Osteotendinosos',
                                                                id: 'strReflejosOsteotendinosos'
                                                            },
                                                            {
                                                                html: 'Pares Craneales'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Pares Craneales',
                                                                id: 'strParesCraneales'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 250,
                                                        allowBlank: true,
                                                        name: 'Otros',
                                                        fieldLabel: 'Otros',
                                                        id: 'strOtrosExamenFisico'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SEGUIMIENTO A RESULTADOS DE AYUDAS DIAGNÓSTICAS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 6
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 200,
                                                                height: 600,
                                                                labelWidth: 180,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>Apoyos Dx</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Colesterol Total',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Colesterol HDL',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaB'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Colesterol LDL',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaC'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Trigliceridos',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaD'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Glicemia Ayunas',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaE'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Glicemia PostPrandial',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaF'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Hematocrito',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaG'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Hemoglobina',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaH'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'TSH',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaI'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Potasio Serico',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaJ'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Acido Urico',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaK'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Parcial de Orina',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaL'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Rx Torax',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaM'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'HB A1c %',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaN'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Proteinuria en 24 horas',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaO'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Creatinina',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaP'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Proteina C Reactiva',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaQ'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Microproteinuria',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaR'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'EKG',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaS'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Ecocardiograma',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaT'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Ecografia Renal',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaU'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Tasa de Filtración Glomerular',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaV'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 130,
                                                                height: 600,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>Fecha Solicitud</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Colesterol Total',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudColesterolTotal'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Colesterol HDL',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudColesterolHDL'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Colesterol LDL',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudColesterolLDL'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Trigliceridos',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudTrigliceridos'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Glicemia Ayunas',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudGlicemiaAyunas'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Glicemia PostPrandial',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudGlicemiaPostPrandial'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Hematocrito',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudHematocrito'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Hemoglobina',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudHemoglobina'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud TSH',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudTSH'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Potasio Serico',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudPotasioSerico'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Acido Urico',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudAcidoUrico'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Parcial de Orina',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudParcialOrina'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Rx Torax',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudRxTorax'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud HB A1c %',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudHBA1C'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Proteinuria en 24 horas',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudProteinuria'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Creatinina',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudCreatinina'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Proteina C Reactiva',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudPCR'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Microproteinuria',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudMicroproteinuria'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud EKG',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudEKG'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Ecocardiograma',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudEcocardiograma'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Ecografia Renal',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudEcografiaRenal'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Solicitud Tasa de Filtración Glomerular',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaSolicitudTFG'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 130,
                                                                height: 600,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>Fecha Resultado</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Colesterol Total',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoColesterolTotal'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Colesterol HDL',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoColesterolHDL'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Colesterol LDL',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoColesterolLDL'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Trigliceridos',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoTrigliceridos'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Glicemia Ayunas',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoGlicemiaAyunas'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Glicemia PostPrandial',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoGlicemiaPostPrandial'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Hematocrito',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoHematocrito'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Hemoglobina',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoHemoglobina'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado TSH',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoTSH'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Potasio Serico',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoPotasioSerico'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Acido Urico',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoAcidoUrico'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Parcial de Orina',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoParcialOrina'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Rx Torax',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoRxTorax'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado HB A1c %',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoHBA1C'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Proteinuria en 24 horas',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoProteinuria'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Creatinina',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoCreatinina'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Proteina C Reactiva',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoPCR'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Microproteinuria',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoMicroproteinuria'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado EKG',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoEKG'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Ecocardiograma',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoEcocardiograma'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Ecografia Renal',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoEcografiaRenal'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha Resultado Tasa de Filtración Glomerular',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecFechaResultadoTFG'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 130,
                                                                height: 600,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>Resultado</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Colesterol Total',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoColesterolTotal'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Colesterol HDL',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoColesterolHDL'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Colesterol LDL',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoColesterolLDL'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Trigliceridos',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoTrigliceridos'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Glicemia Ayunas',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoGlicemiaAyunas'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Glicemia PostPrandial',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoGlicemiaPostPrandial'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Hematocrito',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoHematocrito'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Hemoglobina',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoHemoglobina'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado TSH',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoTSH'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Potasio Serico',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoPotasioSerico'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Acido Urico',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoAcidoUrico'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Parcial de Orina',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoParcialOrina'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Rx Torax',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoRxTorax'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado HB A1c %',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoHBA1C'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Proteinuria en 24 horas',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoProteinuria'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Creatinina',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoCreatinina'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Proteina C Reactiva',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoPCR'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Microproteinuria',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoMicroproteinuria'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado EKG',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoEKG'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Ecocardiograma',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoEcocardiograma'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Ecografia Renal',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoEcografiaRenal'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name: 'Resultado Tasa de Filtración Glomerular',
                                                                        allowBlank: true,
                                                                        id: 'strResultadoTFG'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 200,
                                                                height: 600,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>Observaciones</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Colesterol Total',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesColesterolTotal'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Colesterol HDL',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesColesterolHDL'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Colesterol LDL',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesColesterolLDL'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Trigliceridos',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesTrigliceridos'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Glicemia Ayunas',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesGlicemiaAyunas'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Glicemia PostPrandial',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesGlicemiaPostPrandial'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Hematocrito',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesHematocrito'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Hemoglobina',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesHemoglobina'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones TSH',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesTSH'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Potasio Serico',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesPotasioSerico'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Acido Urico',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesAcidoUrico'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Parcial de Orina',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesParcialOrina'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Rx Torax',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesRxTorax'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones HB A1c %',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesHBA1C'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Proteinuria en 24 horas',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesProteinuria'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Creatinina',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesCreatinina'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Proteina C Reactiva',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesPCR'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Microproteinuria',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesMicroproteinuria'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones EKG',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesEKG'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Ecocardiograma',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesEcocardiograma'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Ecografia Renal',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesEcografiaRenal'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 190,
                                                                        name: 'Observaciones Tasa de Filtración Glomerular',
                                                                        allowBlank: true,
                                                                        id: 'strObservacionesTFG'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONCLUSIONES DE CONTROL',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        labelWidth: 350,
                                                        labelSeparator: '',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Paciente controlado según metas de perfil lipidico?',
                                                                fieldLabel: 'Paciente controlado según metas de perfil lipidico?',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stConclusion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPacienteControladoPerfilLipidico'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Paciente controlado según metas de tensión arterial?',
                                                                fieldLabel: 'Paciente controlado según metas de tensión arterial?',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stConclusion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPacienteControladoTensionArterial'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Paciente controlado según metas de HbAC1 y/o glicemia?',
                                                                fieldLabel: 'Paciente controlado según metas de HbAC1 y/o glicemia?',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stConclusion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPacienteControladoGlicemia'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Estratificacion del Riesgo',
                                                                fieldLabel: 'Estratificacion del Riesgo',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stEstratificacionRiesgo,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strEstratificacionRiesgo'
                                                            },
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'IMPRESION DIAGNOSTICA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'IMPRESION DIAGNOSTICA',
                                                        name: 'IMPRESION DIAGNOSTICA',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memImpresionDiagnostica'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PLAN DE MANEJO',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'PLAN DE MANEJO',
                                                        name: 'PLAN DE MANEJO',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memPlanManejo'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'REMISIONES A PROGRAMAS',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'REMISIONES A PROGRAMAS',
                                                        name: 'REMISIONES A PROGRAMAS',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memRemisionesProgramas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'REMISIONES A ESPECIALISTAS',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'REMISIONES A ESPECIALISTAS',
                                                        name: 'REMISIONES A ESPECIALISTAS',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memRemisionesEspecialistas'
                                                    }
                                                ]
                                            },
                                            
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION PROXIMA CITA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                        {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable Proxima Cita',
                                                                name: 'Fecha Probable Proxima Cita',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecPROXCITACita'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPROXCITAProfesionalAtiende'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observacion',
                                                        name: 'Observacion',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memPROXCITAObservacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() == null || Ext.getCmp('fecDesdeIncapacidad').getValue() == ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'))
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue()==null || Ext.getCmp('sysDiagPpalHCNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() != "" && Ext.getCmp('sysDiagPpalHC').getValue() != null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue == null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() != "" && Ext.getCmp('sysDiagRel1HC').getValue() != null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue == null || Ext.getCmp('sysDiagRel2HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() != "" && Ext.getCmp('sysDiagRel2HC').getValue() != null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue == null || Ext.getCmp('sysDiagRel3HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() != "" && Ext.getCmp('sysDiagRel3HC').getValue() != null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == 0){
                                                                    Ext.getCmp('sysFinalidadConsultaInicialHC').setValue(null);
                                                                }else{
                                                                    Ext.getCmp('sysFinalidadConsultaInicialHC').setValue(Ext.getCmp('sysFinalidadConsultaHC').getValue())
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == 0){
                                                                    Ext.getCmp('sysCausaExternaInicialHC').setValue(null);
                                                                }else{
                                                                    Ext.getCmp('sysCausaExternaInicialHC').setValue(Ext.getCmp('sysCausaExternaHC').getValue())
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    
                    //EVALUA ANTECEDENTES GINOECO-OBSTETrICOS
                    if(Ext.getCmp('sysGeneroHC').getValue()=="MASCULINO"){
                        Ext.getCmp('fsAntecedentesAndrologicos').setVisible(true);
                        Ext.getCmp('fsAntecedentesGinecologicos').setVisible(false);
                    }else{
                        if(Ext.getCmp('sysGeneroHC').getValue()=="FEMENINO"){
                            Ext.getCmp('fsAntecedentesAndrologicos').setVisible(false);
                            Ext.getCmp('fsAntecedentesGinecologicos').setVisible(true);
                        }else{
                            Ext.getCmp('fsAntecedentesAndrologicos').setVisible(false);
                            Ext.getCmp('fsAntecedentesGinecologicos').setVisible(false);
                        }
                    }
                    
                }
            }
        });
        winHCCronicos002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
