/*
* @category    Formulario Modelo Historia Clinica Odontologia Primera Vez
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCOdontologia001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Historia Clinica Odontologia Primera Vez 2016 ::.',
    width: 1010,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCOdontologia001',
    initComponent: function() {
           
        //NUEVO 2014
        //Consentimientos Informados
        var xConsentimientosInformados = new GridConsentimientosInformadosUi();
        //Consentimientos Informados
        var xEventosAdversos = new GridEventosAdversosUi();
        //KardexProgramas
        var xKardexProgramas = new GridKardexxPacUi();
        // Carta dental
        var xCartaDental = new CartaDental001Ui();
        // Diagrama Control de Placa
        var xControlPlaca = new ControlPlaca001Ui();
        // Actividades Realizdas
        var xActividadesRealizdas = new ActividadesRealizdas201401Ui();
        //Guias Atencion
        var xGuiasAtencion = new GridGuiasAtencionUi();
        //Reporte Paraclinicos
        var stReporteParaclinicos = new StoreGridReporteParaclinicos();
        stReporteParaclinicos.load({
            params: {
                pPaciente: wPaciente
            }
        });
        //Alertas Medicas
        var xAlertasxPaciente = new AlertasxPaciente001Ui();
        Ext.getCmp('gridAlertasPacientes').store.baseParams = {
            task: 'LISTAR_ALERTAS',
            pPaciente: wPaciente,
            pIPS: ID_IPS
        };
        Ext.getCmp('gridAlertasPacientes').store.load({
            params: {
                pPaciente: wPaciente
            }
        });
        function renderClasificacionReporte(val, x, store){
            switch(val){
                case "A":
                    return '<span style="color:#F00">Anormal</span>';
                    break;
                case "N":
                    return '<span style="color:#090">Normal</span>';
                    break;
                default:
                    break;
            }
        }
        function renderValorReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            if(record.get('ReporteVal') !== "" && record.get('ReporteVal') !== null){
                return value + "<br><hr>Valor: " + record.get('ReporteVal');  
            }else{
                return value;  
            }
        }
        function renderObservaReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        Ext.util.Format.Currency = function(v){
            return FormatoMoneda(v);
        };
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        var stGridOdontogramasxPaciente = new StoreGridOdontogramasxPaciente();
        stGridOdontogramasxPaciente.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        function VerInfoOdontograma(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('Profesional') + '</br>Tipo Odontograma:' + record.get('TipoOdontograma') + '</br>Tipo Denticion:' + record.get('TipoDenticion');
        }
        
        function VerInfoProxCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return 'CAS: ' + record.get('CAS') + '</br>' + record.get('Profesional') + '</br>Fecha:' + record.get('FechaAtencion');
        }
                
        /*var OdontogramaInical = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/frm/odontograma/odontograma002.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS,
                scripts:true,
                scope:this
            },
            id:'OdontogramaInical',
            //renderTo: Ext.getBody(),
            height: 480,
            autoScroll:true,
            closable:false
        });*/
        
        //Store Locales
        var dataTipoDenticion = [
            ['TEMPORAL'],
            ['PERMANENTE'],
            ['MIXTA']
        ];
        var stTipoDenticion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoDenticion.loadData(dataTipoDenticion);
        
        var dataHigiene = [
            ['BUENO'],
            ['REGULAR'],
            ['MALO']
        ];
        var stHigiene = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stHigiene.loadData(dataHigiene);
        
        var dataRiesgo = [
            ['ALTO'],
            ['MEDIO'],
            ['BAJO']
        ];
        var stRiesgo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRiesgo.loadData(dataRiesgo);  
        
        
        var dataTipoPaciente = [
            ['PACIENTE INICIO TRATAMIENTO'],
            ['PACIENTE INICIO TRATAMIENTO Y CONTROLADO']
        ];
        var stTipoPaciente = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoPaciente.loadData(dataTipoPaciente);        
        
        var dataTipoAtencionOdo = [
            ['PRIMERA VEZ'],
            ['CONTROL'],
            ['URGENCIAS']
        ];
        var stTipoAtencionOdo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoAtencionOdo.loadData(dataTipoAtencionOdo);
        
        var dataTipoAfiliadoOdo = [
            ['COTIZANTE'],
            ['BENEFICIARIO']
        ];
        var stTipoAfiliadoOdo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoAfiliadoOdo.loadData(dataTipoAfiliadoOdo);
        
        var ConvencionesOdontograma = new winConvencionesOdontogramaUi();
        var ViewOdontogramas = new winViewOdontogramasUi();
        
        //Asignar Proxima Cita
        var xAsignarProximaCita = new fsAsignarProximaCita001Ui();
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                //anchor: '100%',
                width: 1000,
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'panel',
                        title: 'Datos Basicos',
                        autoHeight: true,
                        autoScroll: true,
                        width: 1005,
                        frame: true,
                        border: false,
                        id: 'fichaIdentifica',
                        layout: 'form',
                        items:[
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                value: 0,
                                id: 'sysYaAsignoCitaHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysIdCodPlantillaHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                value: 1,
                                id: 'sysUsaGridSalida'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                value: 0,
                                id: 'sysYaGuardoHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysPlantillaHC',
                                name: 'PLANTILLA'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptMx'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptExa'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptRem'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Actividad',
                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                id: 'sysActividadHC',
                                name: 'PLANTILLA'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Empresa',
                                id: 'sysEmpresaHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'IPS',
                                id: 'sysIPSHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuarioHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Profesional',
                                id: 'sysProfesionalHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Paciente',
                                id: 'sysIdPacienteHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Apertura',
                                id: 'sysAperturaHC'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Cliente',
                                id: 'sysClienteHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdClienteHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdPlanHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdSubPlanHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdContratoHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Edad',
                                id: 'sysEdadPacHC'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Profesional',
                                id: 'sysProfesionalAgendaHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoDetalle',
                                id: 'sysConsecutivoDetalleHC'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'CAS',
                                        id: 'sysCASHC'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysFechaHC',
                                        value: 'Fecha: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysFechaHC'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysHoraHC',
                                        value: 'Hora: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysHoraHC'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysLegalizacionHC',
                                        value: 'Legalización: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysLegalizaHC'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Paciente',
                                value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                id: 'sysPacienteHC'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroHC'
                                    },
                                    {
                                        html: 'Fecha Nac:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysFechaNac'
                                    },
                                    {
                                        html: 'Edad:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 350,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEdadHC'
                                    }
                                ]
                            },
                            {
                                html: '<hr>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Tipo Afiliado',
                                        id: 'sysTipoAfiliadoHC'
                                    },
                                    {
                                        html: 'Rango:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 30,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRangoAfiliadoHC'
                                    },
                                    {
                                        html: 'Cuota Moderadora:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'sysCMAfiliadoHC',
                                        readOnly: true
                                    },
                                    {
                                        html: '% Copagos:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "%",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 3,
                                        allowBlank: false,
                                        id: 'sysPorCopagoAfiliadoHC',
                                        readOnly: true
                                    }
                                ]
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysFacturarPacienteHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysFacturarParticularHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysRecaudoAutomaticoParticularesHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysFacturarCopagosHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysMaxCopagoHC'
                            },
                            {
                                html: '<hr>',
                                style: 'background:transparent;',
                                border: false
                            }
                        ]
                    },
                    {
                        xtype: 'tabpanel',
                        //anchor: '100%',
                        width: 970,
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolucion',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                width: 120,
                                                fieldLabel: 'Fecha Ingreso',
                                                name: 'Fecha Ingreso',
                                                allowBlank: true,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                //id: 'fecIngreso'
                                                id: 'strIngreso'
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'Fecha Ultimo Control',
                                                emptyText: '(dia/mes/año)',
                                                readOnly: true,
                                                width: 120,
                                                allowBlank: true,
                                                //id: 'fecUltimoControl'
                                                id: 'strUltimoControl'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Afiliado',
                                                        name: 'Tipo de Afiliado',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: stTipoAfiliadoOdo,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strTipoAfiliadoHC',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    Ext.getCmp('sysTipoAfiliadoHC').setValue(cmb.getValue());
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        html: 'Tipo de Atencion'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Tipo de Atencion',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: stTipoAtencionOdo,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strTipoAtencionHC'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO CONSULTA',
                                                        name: 'MOTIVO CONSULTA',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Telefonos',
                                                        name: 'Telefonos',
                                                        allowBlank: false,
                                                        id: 'strTelefonosHC'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 86,
                                                                allowBlank: false,
                                                                fieldLabel: 'Ocupacion',
                                                                name: 'Ocupacion',
                                                                id: 'strOcupacionHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysOcupacionHCNom').getValue() === null || Ext.getCmp('sysOcupacionHCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('strOcupacionHC').getValue() !== "" && Ext.getCmp('strOcupacionHC').getValue() !== null){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('strOcupacionHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 615,
                                                                height: 22,
                                                                id: 'sysOcupacionHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Ocupacion',
                                                                id: 'btnSearchOcupacionHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarciuo('strOcupacionHC','sysOcupacionHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Etnia',
                                                        name: 'Etnia',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreEtnia4505',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intEtniaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Escolaridad',
                                                        name: 'Escolaridad',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreEscolaridad4505',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intEscolaridadHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Fluorosis Dental',
                                                        name: 'Paciente con Fluorosis Dental',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: stFluorosisDental,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intIdentificacionRiesgoFluorosisDental'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Patologicos',
                                                        name: 'Patologicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOPatologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOPatologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Farmacologicos',
                                                        name: 'Farmacologicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOFarmacologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOFarmacologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Toxicologicos',
                                                        name: 'Toxicologicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOToxicologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOToxicologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Alergicos',
                                                        name: 'Alergicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOAlergicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOAlergicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 3,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'HTA',
                                                                        name: 'HTA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOHTA'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'VIH',
                                                                        name: 'VIH',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOVIH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Diabetes',
                                                                        name: 'Diabetes',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSODiabetes'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros',
                                                        name: 'Otros',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOOtros',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOOtros').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ANTECEDENTES FAMILIARES',
                                                        name: 'ANTECEDENTES FAMILIARES',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memAntecedentesFamiliares'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES ODONTOLOGICOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 2,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 180,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Cirugias Incluso Orales',
                                                                        name: 'Cirugias Incluso Orales',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCxOral'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Exodoncias',
                                                                        name: 'Exodoncias',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolExodoncias'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Enfermedades Orales',
                                                                        name: 'Enfermedades Orales',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolEnfermedadesOrales'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 500,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                   {
                                                                        xtype: 'textarea',
                                                                        anchor: '100%',
                                                                        width: 480,
                                                                        fieldLabel: 'Otras Patologias o Antecedentes Odontologicos',
                                                                        name: 'Otras Patologias o Antecedentes Odontologicos',
                                                                        height: 50,            
                                                                        allowBlank: true,
                                                                        id: 'memAnteOdontologicos'
                                                                    },
                                                                    {
                                                                        xtype: 'textarea',
                                                                        anchor: '100%',
                                                                        width: 480,
                                                                        fieldLabel: 'Observaciones',
                                                                        name: 'Observaciones',
                                                                        height: 50,            
                                                                        allowBlank: true,
                                                                        id: 'memObservaciones'
                                                                    } 
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Habitos Asociados a Cavidad Oral',
                                                        name: 'Habitos Asociados a Cavidad Oral',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memHabitosAsociados'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Examen Estomatologico',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 6,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Estructura',
                                                                width: 180,
                                                                height: 150, 
                                                                labelSeparator: ' ',
                                                                labelWidth: 160,
                                                                labelStyle: 'text-align:right;',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Labio Inferior',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma001'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Labio Superior',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma002'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Comisuras',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma003'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Mucosa Oral',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma004'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Alterado',
                                                                labelWidth: 1,
                                                                width: 80,
                                                                height: 150,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Labio Inferior',
                                                                        value: 'true',
                                                                        width: 30,
                                                                        id: 'bolAlteradoExaEstomatologico_1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Labio Superior',
                                                                        value: 'true',
                                                                        width: 30,
                                                                        id: 'bolAlteradoExaEstomatologico_2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Comisuras',
                                                                        value: 'true',
                                                                        width: 30,
                                                                        id: 'bolAlteradoExaEstomatologico_3'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Mucosa Oral',
                                                                        value: 'true',
                                                                        width: 30,
                                                                        id: 'bolAlteradoExaEstomatologico_4'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Estructura',
                                                                width: 180,
                                                                height: 150,
                                                                labelSeparator: ' ',
                                                                labelStyle: 'text-align:right;',
                                                                labelWidth: 160,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Surcos Yugales',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma005'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Frenillos',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma006'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Orofaringe',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma007'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Paladar',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma008'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Alterado',
                                                                labelWidth: 1,
                                                                height: 150,
                                                                width: 80,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Surcos Yugales',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoExaEstomatologico_5'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Frenillos',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoExaEstomatologico_6'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Orofaringe',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoExaEstomatologico_7'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Paladar',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoExaEstomatologico_8'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Estructura',
                                                                width: 180,
                                                                height: 150,
                                                                labelSeparator: ' ',
                                                                labelStyle: 'text-align:right;',
                                                                labelWidth: 160,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Glandulas Salivales',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma009'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Piso de Boca',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma010'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Dorso de Lengua',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma011'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Vientre de Lengua',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma012'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Alterado',
                                                                labelWidth: 1,
                                                                width: 80,
                                                                height: 150,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Glandulas Salivales',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoExaEstomatologico_9'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Piso de Boca',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoExaEstomatologico_10'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Dorso de Lengua',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoExaEstomatologico_11'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Vientre de Lengua',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoExaEstomatologico_12'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memExaEstomatologicoObservaciones'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Articulacion Temporo-Mandibular',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 4,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Estructura',
                                                                width: 180,
                                                                height: 150,
                                                                labelSeparator: ' ',
                                                                labelStyle: 'text-align:right;',
                                                                labelWidth: 160,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Ruidos',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma013'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Desviacion',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma014'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Cambio de Volumen',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma015'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Bloqueo Mandibular',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma016'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Alterado',
                                                                labelWidth: 1,
                                                                width: 80,
                                                                height: 150,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Ruidos',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoArtMandibular_1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Desviacion',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoArtMandibular_2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Cambio de Volumen',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoArtMandibular_3'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Bloqueo Mandibular',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoArtMandibular_4'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Estructura',
                                                                width: 180,
                                                                height: 150,
                                                                labelSeparator: ' ',
                                                                labelStyle: 'text-align:right;',
                                                                labelWidth: 160,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Limitacion Apertura',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma017'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Dolor Articular',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma018'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Dolor Muscular',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma019'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Alterado',
                                                                labelWidth: 1,
                                                                width: 80,
                                                                height: 150,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Limitacion Apertura',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoArtMandibular_5'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Dolor Articular',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoArtMandibular_6'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Dolor Muscular',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolAlteradoArtMandibular_7'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memArtMandibularObservaciones'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Indice COPS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Cariados',
                                                                fieldLabel: 'Dientes Cariados',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intIndice_1'
                                                            },
                                                            {
                                                                html: 'Dientes Obturados'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Obturados',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intIndice_2'
                                                            },
                                                            {
                                                                html: 'Dientes Exfoliados'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Exfoliados',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intIndice_3'
                                                            },
                                                            {
                                                                html: 'Dientes Sanos'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Sanos',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intIndice_4'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Protesis',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Presenta Protesis',
                                                                fieldLabel: 'Presenta Protesis',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strProtesis_1',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() === "NO"){
                                                                            Ext.getCmp('strProtesis_2').allowBlank = true;
                                                                            Ext.getCmp('strProtesis_2').setValue(null);
                                                                            Ext.getCmp('strProtesis_2').disable();
                                                                            Ext.getCmp('strProtesis_2').clearInvalid();
                                                                            Ext.getCmp('strProtesis_3').allowBlank = true;
                                                                            Ext.getCmp('strProtesis_3').setValue(null);
                                                                            Ext.getCmp('strProtesis_3').disable();
                                                                            Ext.getCmp('strProtesis_3').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strProtesis_2').enable();
                                                                            Ext.getCmp('strProtesis_2').allowBlank = false;
                                                                            Ext.getCmp('strProtesis_3').enable();
                                                                            Ext.getCmp('strProtesis_3').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Tipo Protesis'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Tipo Protesis',
                                                                width: 150,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strProtesis_2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Descripcion',
                                                        fieldLabel: 'Descripcion',
                                                        width: 350,
                                                        allowBlank: true,
                                                        disabled: true,
                                                        id: 'strProtesis_3'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Higiene Oral',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 2,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Higiene Oral',
                                                                        fieldLabel: 'Higiene Oral',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stHigiene,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strHigieneOral_1'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Frecuencia Cepillado',
                                                                        fieldLabel: 'Frecuencia Cepillado',
                                                                        emptyText: 'Veces al Dia', 
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 100,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        value: 0,
                                                                        id: 'intHigieneOral_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Grado de Riesgo',
                                                                        fieldLabel: 'Grado de Riesgo',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strHigieneOral_3'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Usa Seda Dental',
                                                                        fieldLabel: 'Usa Seda Dental',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolHigieneOral_4'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Pigmentacion',
                                                                        fieldLabel: 'Pigmentacion',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolHigieneOral_5'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 600,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'Superficies con Placa',
                                                                                fieldLabel: 'Superficies con Placa',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                value: 0,
                                                                                id: 'intHigieneOral_6'
                                                                            },
                                                                            {
                                                                                html: 'Porcentaje Placa'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'Porcentaje Placa',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                value: 0,
                                                                                id: 'intHigieneOral_7'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'textarea',
                                                                        width: 300,
                                                                        fieldLabel: 'Observaciones',
                                                                        name: 'Observaciones',
                                                                        height: 80,            
                                                                        allowBlank: true,
                                                                        id: 'memHigieneOral_8'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Examen Pulpar',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Cuellos Sensibles',
                                                                fieldLabel: 'Cuellos Sensibles',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolExamenPulpar_1'
                                                            },
                                                            {
                                                                html: 'Abscesos'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Abscesos',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolExamenPulpar_2'
                                                            },
                                                            {
                                                                html: 'Exposicion Pulpar'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Exposicion Pulpar',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolExamenPulpar_3'
                                                            },
                                                            {
                                                                html: 'Cambio de Color'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Cambio de Color',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolExamenPulpar_4'
                                                            },
                                                            {
                                                                html: 'Fistula'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Fistula',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolExamenPulpar_6'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 480,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memExamenPulpar_5'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Tejidos Dentarios y Oclusion',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Supernumerarios',
                                                                fieldLabel: 'Supernumerarios',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTejidosDentarios_1'
                                                            },
                                                            {
                                                                html: 'Decoloracion'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Decoloracion',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTejidosDentarios_2'
                                                            },
                                                            {
                                                                html: 'Descalsificacion'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Descalcificacion',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTejidosDentarios_3'
                                                            },
                                                            {
                                                                html: 'Facetas de Desgaste'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Facetas de Desgaste',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTejidosDentarios_4'
                                                            },
                                                            {
                                                                html: 'Abracion'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Abrasion',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTejidosDentarios_5'
                                                            },
                                                            {
                                                                html: 'Erosion'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Erosion',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTejidosDentarios_A5'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memTejidosDentarios_6'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Alteraciones Periodontales',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Sangrado',
                                                                fieldLabel: 'Sangrado',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_1'
                                                            },
                                                            {
                                                                html: 'Exudado'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Exudado',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_2'
                                                            },
                                                            {
                                                                html: 'Supuracion'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Supuracion',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_3'
                                                            },
                                                            {
                                                                html: 'Calculos'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Calculos',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_4'
                                                            },
                                                            {
                                                                html: 'Inflamacion'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Inflamacion',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_5'
                                                            },
                                                            {
                                                                html: 'Retracciones'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Retracciones',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_6'
                                                            },
                                                            {
                                                                html: 'Presencia Bolsas'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Presencia Bolsas',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_7'
                                                            },
                                                            {
                                                                html: 'Movilidad Dental'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Movilidad Dental',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_8'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memAlteracionesPeriodontales_9'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'Tipo Oclusion',
                                                name: 'Tipo Oclusion',
                                                height: 60,            
                                                allowBlank: true,
                                                id: 'memTipoOclusion'
                                            },
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'Lectura Radiografica',
                                                name: 'Lectura Radiografica',
                                                height: 60,            
                                                allowBlank: true,
                                                id: 'memLecturaRx'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Tipo Paciente',
                                                fieldLabel: 'Tipo Paciente',
                                                width: 300,
                                                allowBlank: false,
                                                store: stTipoPaciente,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "PACIENTE INICIO TRATAMIENTO",
                                                id: 'strTipoPaciente'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Diagnosticos',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Articular',
                                                        name: 'Diagnostico - Articular',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoArticular'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Pulpar',
                                                        name: 'Diagnostico - Pulpar',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoPulpar'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Periodontal',
                                                        name: 'Diagnostico - Periodontal',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoPeriodontal'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Dental',
                                                        name: 'Diagnostico - Dental',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoDental'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - CyD',
                                                        name: 'Diagnostico - CyD',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoCyD'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Tejidos Blandos',
                                                        name: 'Diagnostico - Tejidos Blandos',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoTejidosBlandos'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Otros',
                                                        name: 'Diagnostico - Otros',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsEvolucion',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() === null || Ext.getCmp('fecDesdeIncapacidad').getValue() === ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'))
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Carta Dental Inicial (LEY 38/93)',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaCartaDentalInicial',
                                items: [
                                    xCartaDental
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Diagrama Control de Placa Bacteriana',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaDiagramaControlPlaca',
                                items: [
                                    xControlPlaca
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Actividades Realizadas',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaActividades',
                                items: [
                                    xActividadesRealizdas
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Asignar Proxima Cita',
                                autoHeight: true,
                                autoScroll: true,
                                //width: 921,
                                anchor: '99%',
                                frame: true,
                                border: false,
                                id: 'fichaProximaCita',
                                items: [
                                    xAsignarProximaCita
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Registro de Alertas',
                                height: 380,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaAlertas',
                                items: [
                                    xAlertasxPaciente
                                ]
                            },
                            /*{
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                layout: 'form',
                                items: [
                                    xConsentimientosInformados
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Notificacion Eventos Adversos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEventosAdversos',
                                layout: 'form',
                                items: [
                                    xEventosAdversos
                                ]
                            },*/
                            {
                                xtype: 'panel',
                                title: 'Guias de Manejo / Recomendaciones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaGuiasManejo',
                                layout: 'form',
                                items: [
                                    xGuiasAtencion
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        if(parseInt(Ext.getCmp('sysYaAsignoCitaHC').getValue()) === 1){
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Esta seguro que desea cerrar la ventana?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn=="yes"){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                        Ext.getCmp('winConvencionesOdontograma').close();
                                                        Ext.getCmp('winViewOdontogramas').close();
                                                        Ext.getCmp('winHCOdontologia001').close();
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'eOfiClinic',
                                                msg: 'Para poder cerrar la historia clinica debe realizar la asignacion de la proxima cita.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn=="yes"){
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winConvencionesOdontograma').close();
                                                    Ext.getCmp('winViewOdontogramas').close();
                                                    Ext.getCmp('winHCOdontologia001').close();
                                                }
                                            }
                                        });
                                    }
                                }
                                /*click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winConvencionesOdontograma').close();
                                                    Ext.getCmp('winViewOdontogramas').close();
                                                    Ext.getCmp('winHCOdontologia001').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winConvencionesOdontograma').close();
                                                    Ext.getCmp('winViewOdontogramas').close();
                                                    Ext.getCmp('winHCOdontologia001').close();
                                                }
                                            }
                                        });
                                    }
                                }*/
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosOdontologiaInicial();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosOdontologiaInicial();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Ajax.request({
                        url: '../../controlador/estudios/controlador_estudios.php',
                        params:{
                            task: 'BUSCAR_PARAMETROS_COBRO',
                            pCAS: myCAS
                        },
                        success: function(response,options)
                        {
                            var el = Ext.get('response'); // get the LOG
                            var Respuesta = response.responseText;
                            var Contenido = Respuesta.split('^');
                            if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                Ext.getCmp('sysTipoAfiliadoHC').setValue(null);
                                Ext.getCmp('strTipoAfiliadoHC').setValue(null);
                                Ext.getCmp('sysRangoAfiliadoHC').setValue(null);
                                Ext.getCmp('sysCMAfiliadoHC').setValue(0);
                                Ext.getCmp('sysPorCopagoAfiliadoHC').setValue(0);
                                Ext.getCmp('sysFacturarPacienteHC').setValue(0);
                                Ext.getCmp('sysFacturarParticularHC').setValue(0);
                                Ext.getCmp('sysRecaudoAutomaticoParticularesHC').setValue(0);
                                Ext.getCmp('sysFacturarCopagosHC').setValue(0);
                                Ext.getCmp('sysMaxCopagoHC').setValue(0);
                            } else {
                                switch(Contenido[0]){
                                    case "B":
                                        Ext.getCmp('sysTipoAfiliadoHC').setValue("BENEFICIARIO");
                                        Ext.getCmp('strTipoAfiliadoHC').setValue("BENEFICIARIO");
                                        break;
                                    case "C":
                                        Ext.getCmp('sysTipoAfiliadoHC').setValue("COTIZANTE");
                                        Ext.getCmp('strTipoAfiliadoHC').setValue("COTIZANTE");
                                        break;
                                    default:
                                        switch(Contenido[9]){
                                            case "B":
                                                Ext.getCmp('sysTipoAfiliadoHC').setValue("BENEFICIARIO");
                                                Ext.getCmp('strTipoAfiliadoHC').setValue("BENEFICIARIO");
                                                break;
                                            case "C":
                                                Ext.getCmp('sysTipoAfiliadoHC').setValue("COTIZANTE");
                                                Ext.getCmp('strTipoAfiliadoHC').setValue("COTIZANTE");
                                                break;
                                            default:
                                                Ext.getCmp('sysTipoAfiliadoHC').setValue("");
                                                Ext.getCmp('strTipoAfiliadoHC').setValue("");
                                                break;
                                        }
                                        break;
                                }
                                Ext.getCmp('sysRangoAfiliadoHC').setValue(Contenido[1]);
                                Ext.getCmp('sysCMAfiliadoHC').setValue(Contenido[7]);
                                Ext.getCmp('sysPorCopagoAfiliadoHC').setValue(Contenido[2]);
                                Ext.getCmp('sysFacturarPacienteHC').setValue(Contenido[3]);
                                Ext.getCmp('sysFacturarParticularHC').setValue(Contenido[4]);
                                Ext.getCmp('sysRecaudoAutomaticoParticularesHC').setValue(Contenido[5]);
                                Ext.getCmp('sysFacturarCopagosHC').setValue(Contenido[6]);
                                Ext.getCmp('sysMaxCopagoHC').setValue(Contenido[8]);
                            }
                        },
                        failure: function(response,options){
                            var el = Ext.get('response');
                            Ext.getCmp('sysTipoAfiliadoHC').setValue(null);
                            Ext.getCmp('sysRangoAfiliadoHC').setValue(null);
                            Ext.getCmp('sysCMAfiliadoHC').setValue(0);
                            Ext.getCmp('sysPorCopagoAfiliadoHC').setValue(0);
                            Ext.getCmp('sysFacturarPacienteHC').setValue(0);
                            Ext.getCmp('sysFacturarParticularHC').setValue(0);
                            Ext.getCmp('sysRecaudoAutomaticoParticularesHC').setValue(0);
                            Ext.getCmp('sysFacturarCopagosHC').setValue(0);
                            Ext.getCmp('sysMaxCopagoHC').setValue(0);
                        },
                        scope:this 
                    });
                    Ext.Msg.hide();
                    if(paramOpcion === "Nuevo"){ 
                        var frm = Ext.getCmp('frmHC').getForm();
                        frm.doAction('load', {
                            url: '../../controlador/asistencial/evolucionhc2014.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarOdontologia'
                            },
                            success:function(form, action) {
                                var frm = Ext.getCmp('frmHC').getForm();
                                frm.doAction('load', {
                                    url: '../../controlador/asistencial/evolucionhc2014.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarFactoresRiesgo4505'
                                    },
                                    success:function(form, action) {
                                        
                                    }
                                });
                            }
                        });
                        //Predefinir Comportamiento Campos
                        if(Ext.getCmp('sysFechaHC').getValue() !== null || Ext.getCmp('sysFechaHC').getValue() !== 0){
                           calculoEdadPacienteMeses();
                        }
                    }
                    //Cargar Guias de Atencion
                    Ext.getCmp('gridGuiasAtencion').store.load({
                        params: {
                            pPlantilla: Ext.getCmp('sysIdCodPlantillaHC').getValue()
                        }
                    });
                }
            }
        });
        winHCOdontologia001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosOdontologiaInicial(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2014.php',
            params:{
                task: 'ODONTOLOGIA_GUARDAR',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                
                //ANTECEDENTES
                pTelefonos: Ext.getCmp('strTelefonosHC').getValue(),
                //pFechaIngreso: Ext.getCmp('fecIngreso').getValue(),
                pFechaIngreso: Ext.getCmp('strIngreso').getValue(),
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pHTA: Ext.getCmp('bolANTPERSOHTA').getValue(),
                pDiabetes: Ext.getCmp('bolANTPERSODiabetes').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pAntOtros: Ext.getCmp('memANTPERSOOtros').getValue(),
                pGuardarSignos: "SI",
                
                //ODONTOLOGIA
                pCxOral : Ext.getCmp('bolCxOral').getValue(),
                pExodoncias : Ext.getCmp('bolExodoncias').getValue(),
                pEnfermedadesOrales : Ext.getCmp('bolEnfermedadesOrales').getValue(),
                pObservaciones : Ext.getCmp('memObservaciones').getValue(),
                pHabitosAsociados : Ext.getCmp('memHabitosAsociados').getValue(),
                pAlteradoExaEstomatologico_1 : Ext.getCmp('bolAlteradoExaEstomatologico_1').getValue(),
                pAlteradoExaEstomatologico_2 : Ext.getCmp('bolAlteradoExaEstomatologico_2').getValue(),
                pAlteradoExaEstomatologico_3 : Ext.getCmp('bolAlteradoExaEstomatologico_3').getValue(),
                pAlteradoExaEstomatologico_4 : Ext.getCmp('bolAlteradoExaEstomatologico_4').getValue(),
                pAlteradoExaEstomatologico_5 : Ext.getCmp('bolAlteradoExaEstomatologico_5').getValue(),
                pAlteradoExaEstomatologico_6 : Ext.getCmp('bolAlteradoExaEstomatologico_6').getValue(),
                pAlteradoExaEstomatologico_7 : Ext.getCmp('bolAlteradoExaEstomatologico_7').getValue(),
                pAlteradoExaEstomatologico_8 : Ext.getCmp('bolAlteradoExaEstomatologico_8').getValue(),
                pAlteradoExaEstomatologico_9 : Ext.getCmp('bolAlteradoExaEstomatologico_9').getValue(),
                pAlteradoExaEstomatologico_10 : Ext.getCmp('bolAlteradoExaEstomatologico_10').getValue(),
                pAlteradoExaEstomatologico_11 : Ext.getCmp('bolAlteradoExaEstomatologico_11').getValue(),
                pAlteradoExaEstomatologico_12 : Ext.getCmp('bolAlteradoExaEstomatologico_12').getValue(),
                pExaEstomatologicoObservaciones : Ext.getCmp('memExaEstomatologicoObservaciones').getValue(),
                pAlteradoArtMandibular_1 : Ext.getCmp('bolAlteradoArtMandibular_1').getValue(),
                pAlteradoArtMandibular_2 : Ext.getCmp('bolAlteradoArtMandibular_2').getValue(),
                pAlteradoArtMandibular_3 : Ext.getCmp('bolAlteradoArtMandibular_3').getValue(),
                pAlteradoArtMandibular_4 : Ext.getCmp('bolAlteradoArtMandibular_4').getValue(),
                pAlteradoArtMandibular_5 : Ext.getCmp('bolAlteradoArtMandibular_5').getValue(),
                pAlteradoArtMandibular_6 : Ext.getCmp('bolAlteradoArtMandibular_6').getValue(),
                pAlteradoArtMandibular_7 : Ext.getCmp('bolAlteradoArtMandibular_7').getValue(),
                pArtMandibularObservaciones : Ext.getCmp('memArtMandibularObservaciones').getValue(),
                pIndice_1 : Ext.getCmp('intIndice_1').getValue(),
                pIndice_2 : Ext.getCmp('intIndice_2').getValue(),
                pIndice_3 : Ext.getCmp('intIndice_3').getValue(),
                pIndice_4 : Ext.getCmp('intIndice_4').getValue(),
                pProtesis_1 : Ext.getCmp('strProtesis_1').getValue(),
                pProtesis_2 : Ext.getCmp('strProtesis_2').getValue(),
                pProtesis_3 : Ext.getCmp('strProtesis_3').getValue(),
                pHigieneOral_1 : Ext.getCmp('strHigieneOral_1').getValue(),
                pHigieneOral_2 : Ext.getCmp('intHigieneOral_2').getValue(),
                pHigieneOral_3 : Ext.getCmp('strHigieneOral_3').getValue(),
                pHigieneOral_4 : Ext.getCmp('bolHigieneOral_4').getValue(),
                pHigieneOral_5 : Ext.getCmp('bolHigieneOral_5').getValue(),
                pHigieneOral_6 : Ext.getCmp('intHigieneOral_6').getValue(),
                pHigieneOral_7 : Ext.getCmp('intHigieneOral_7').getValue(),
                pHigieneOral_8 : Ext.getCmp('memHigieneOral_8').getValue(),
                pExamenPulpar_1 : Ext.getCmp('bolExamenPulpar_1').getValue(),
                pExamenPulpar_2 : Ext.getCmp('bolExamenPulpar_2').getValue(),
                pExamenPulpar_3 : Ext.getCmp('bolExamenPulpar_3').getValue(),
                pExamenPulpar_4 : Ext.getCmp('bolExamenPulpar_4').getValue(),
                pExamenPulpar_6 : Ext.getCmp('bolExamenPulpar_6').getValue(),
                pExamenPulpar_5 : Ext.getCmp('memExamenPulpar_5').getValue(),
                pTejidosDentarios_1 : Ext.getCmp('bolTejidosDentarios_1').getValue(),
                pTejidosDentarios_2 : Ext.getCmp('bolTejidosDentarios_2').getValue(),
                pTejidosDentarios_3 : Ext.getCmp('bolTejidosDentarios_3').getValue(),
                pTejidosDentarios_4 : Ext.getCmp('bolTejidosDentarios_4').getValue(),
                pTejidosDentarios_5 : Ext.getCmp('bolTejidosDentarios_5').getValue(),
                pTejidosDentarios_A5 : Ext.getCmp('bolTejidosDentarios_A5').getValue(),
                pTejidosDentarios_6 : Ext.getCmp('memTejidosDentarios_6').getValue(),
                pAlteracionesPeriodontales_1 : Ext.getCmp('bolAlteracionesPeriodontales_1').getValue(),
                pAlteracionesPeriodontales_2 : Ext.getCmp('bolAlteracionesPeriodontales_2').getValue(),
                pAlteracionesPeriodontales_3 : Ext.getCmp('bolAlteracionesPeriodontales_3').getValue(),
                pAlteracionesPeriodontales_4 : Ext.getCmp('bolAlteracionesPeriodontales_4').getValue(),
                pAlteracionesPeriodontales_5 : Ext.getCmp('bolAlteracionesPeriodontales_5').getValue(),
                pAlteracionesPeriodontales_6 : Ext.getCmp('bolAlteracionesPeriodontales_6').getValue(),
                pAlteracionesPeriodontales_7 : Ext.getCmp('bolAlteracionesPeriodontales_7').getValue(),
                pAlteracionesPeriodontales_8 : Ext.getCmp('bolAlteracionesPeriodontales_8').getValue(),
                pAlteracionesPeriodontales_9 : Ext.getCmp('memAlteracionesPeriodontales_9').getValue(),
                pTipoOclusion : Ext.getCmp('memTipoOclusion').getValue(),
                pLecturaRx : Ext.getCmp('memLecturaRx').getValue(),
                pTipoPaciente : Ext.getCmp('strTipoPaciente').getValue(),
                pDiagnosticoArticular : Ext.getCmp('memDiagnosticoArticular').getValue(),
                pDiagnosticoPulpar : Ext.getCmp('memDiagnosticoPulpar').getValue(),
                pDiagnosticoPeriodontal : Ext.getCmp('memDiagnosticoPeriodontal').getValue(),
                pDiagnosticoDental : Ext.getCmp('memDiagnosticoDental').getValue(),
                pDiagnosticoCyD : Ext.getCmp('memDiagnosticoCyD').getValue(),
                pDiagnosticoTejidosBlandos : Ext.getCmp('memDiagnosticoTejidosBlandos').getValue(),
                pDiagnosticoOtros : Ext.getCmp('memDiagnosticoOtros').getValue(),
                pTipoAfiliado: Ext.getCmp('strTipoAfiliadoHC').getValue(),
                pTipoAtencion: Ext.getCmp('strTipoAtencionHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosOdontologiaInicial(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2014.php',
            params:{
                task: 'ODONTOLOGIA_MODIFICAR',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pGuardarSignos: "SI",
                
                //ANTECEDENTES
                pTelefonos: Ext.getCmp('strTelefonosHC').getValue(),
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pHTA: Ext.getCmp('bolANTPERSOHTA').getValue(),
                pDiabetes: Ext.getCmp('bolANTPERSODiabetes').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pAntOtros: Ext.getCmp('memANTPERSOOtros').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                
                //ODONTOLOGIA
                //pFechaIngreso: Ext.getCmp('fecIngreso').getValue(),
                pFechaIngreso: Ext.getCmp('strIngreso').getValue(),
                pCxOral : Ext.getCmp('bolCxOral').getValue(),
                pExodoncias : Ext.getCmp('bolExodoncias').getValue(),
                pEnfermedadesOrales : Ext.getCmp('bolEnfermedadesOrales').getValue(),
                pObservaciones : Ext.getCmp('memObservaciones').getValue(),
                pHabitosAsociados : Ext.getCmp('memHabitosAsociados').getValue(),
                pAlteradoExaEstomatologico_1 : Ext.getCmp('bolAlteradoExaEstomatologico_1').getValue(),
                pAlteradoExaEstomatologico_2 : Ext.getCmp('bolAlteradoExaEstomatologico_2').getValue(),
                pAlteradoExaEstomatologico_3 : Ext.getCmp('bolAlteradoExaEstomatologico_3').getValue(),
                pAlteradoExaEstomatologico_4 : Ext.getCmp('bolAlteradoExaEstomatologico_4').getValue(),
                pAlteradoExaEstomatologico_5 : Ext.getCmp('bolAlteradoExaEstomatologico_5').getValue(),
                pAlteradoExaEstomatologico_6 : Ext.getCmp('bolAlteradoExaEstomatologico_6').getValue(),
                pAlteradoExaEstomatologico_7 : Ext.getCmp('bolAlteradoExaEstomatologico_7').getValue(),
                pAlteradoExaEstomatologico_8 : Ext.getCmp('bolAlteradoExaEstomatologico_8').getValue(),
                pAlteradoExaEstomatologico_9 : Ext.getCmp('bolAlteradoExaEstomatologico_9').getValue(),
                pAlteradoExaEstomatologico_10 : Ext.getCmp('bolAlteradoExaEstomatologico_10').getValue(),
                pAlteradoExaEstomatologico_11 : Ext.getCmp('bolAlteradoExaEstomatologico_11').getValue(),
                pAlteradoExaEstomatologico_12 : Ext.getCmp('bolAlteradoExaEstomatologico_12').getValue(),
                pExaEstomatologicoObservaciones : Ext.getCmp('memExaEstomatologicoObservaciones').getValue(),
                pAlteradoArtMandibular_1 : Ext.getCmp('bolAlteradoArtMandibular_1').getValue(),
                pAlteradoArtMandibular_2 : Ext.getCmp('bolAlteradoArtMandibular_2').getValue(),
                pAlteradoArtMandibular_3 : Ext.getCmp('bolAlteradoArtMandibular_3').getValue(),
                pAlteradoArtMandibular_4 : Ext.getCmp('bolAlteradoArtMandibular_4').getValue(),
                pAlteradoArtMandibular_5 : Ext.getCmp('bolAlteradoArtMandibular_5').getValue(),
                pAlteradoArtMandibular_6 : Ext.getCmp('bolAlteradoArtMandibular_6').getValue(),
                pAlteradoArtMandibular_7 : Ext.getCmp('bolAlteradoArtMandibular_7').getValue(),
                pArtMandibularObservaciones : Ext.getCmp('memArtMandibularObservaciones').getValue(),
                pIndice_1 : Ext.getCmp('intIndice_1').getValue(),
                pIndice_2 : Ext.getCmp('intIndice_2').getValue(),
                pIndice_3 : Ext.getCmp('intIndice_3').getValue(),
                pIndice_4 : Ext.getCmp('intIndice_4').getValue(),
                pProtesis_1 : Ext.getCmp('strProtesis_1').getValue(),
                pProtesis_2 : Ext.getCmp('strProtesis_2').getValue(),
                pProtesis_3 : Ext.getCmp('strProtesis_3').getValue(),
                pHigieneOral_1 : Ext.getCmp('strHigieneOral_1').getValue(),
                pHigieneOral_2 : Ext.getCmp('intHigieneOral_2').getValue(),
                pHigieneOral_3 : Ext.getCmp('strHigieneOral_3').getValue(),
                pHigieneOral_4 : Ext.getCmp('bolHigieneOral_4').getValue(),
                pHigieneOral_5 : Ext.getCmp('bolHigieneOral_5').getValue(),
                pHigieneOral_6 : Ext.getCmp('intHigieneOral_6').getValue(),
                pHigieneOral_7 : Ext.getCmp('intHigieneOral_7').getValue(),
                pHigieneOral_8 : Ext.getCmp('memHigieneOral_8').getValue(),
                pExamenPulpar_1 : Ext.getCmp('bolExamenPulpar_1').getValue(),
                pExamenPulpar_2 : Ext.getCmp('bolExamenPulpar_2').getValue(),
                pExamenPulpar_3 : Ext.getCmp('bolExamenPulpar_3').getValue(),
                pExamenPulpar_4 : Ext.getCmp('bolExamenPulpar_4').getValue(),
                pExamenPulpar_6 : Ext.getCmp('bolExamenPulpar_6').getValue(),
                pExamenPulpar_5 : Ext.getCmp('memExamenPulpar_5').getValue(),
                pTejidosDentarios_1 : Ext.getCmp('bolTejidosDentarios_1').getValue(),
                pTejidosDentarios_2 : Ext.getCmp('bolTejidosDentarios_2').getValue(),
                pTejidosDentarios_3 : Ext.getCmp('bolTejidosDentarios_3').getValue(),
                pTejidosDentarios_4 : Ext.getCmp('bolTejidosDentarios_4').getValue(),
                pTejidosDentarios_5 : Ext.getCmp('bolTejidosDentarios_5').getValue(),
                pTejidosDentarios_A5 : Ext.getCmp('bolTejidosDentarios_A5').getValue(),
                pTejidosDentarios_6 : Ext.getCmp('memTejidosDentarios_6').getValue(),
                pAlteracionesPeriodontales_1 : Ext.getCmp('bolAlteracionesPeriodontales_1').getValue(),
                pAlteracionesPeriodontales_2 : Ext.getCmp('bolAlteracionesPeriodontales_2').getValue(),
                pAlteracionesPeriodontales_3 : Ext.getCmp('bolAlteracionesPeriodontales_3').getValue(),
                pAlteracionesPeriodontales_4 : Ext.getCmp('bolAlteracionesPeriodontales_4').getValue(),
                pAlteracionesPeriodontales_5 : Ext.getCmp('bolAlteracionesPeriodontales_5').getValue(),
                pAlteracionesPeriodontales_6 : Ext.getCmp('bolAlteracionesPeriodontales_6').getValue(),
                pAlteracionesPeriodontales_7 : Ext.getCmp('bolAlteracionesPeriodontales_7').getValue(),
                pAlteracionesPeriodontales_8 : Ext.getCmp('bolAlteracionesPeriodontales_8').getValue(),
                pAlteracionesPeriodontales_9 : Ext.getCmp('memAlteracionesPeriodontales_9').getValue(),
                pTipoOclusion : Ext.getCmp('memTipoOclusion').getValue(),
                pLecturaRx : Ext.getCmp('memLecturaRx').getValue(),
                pTipoPaciente : Ext.getCmp('strTipoPaciente').getValue(),
                pDiagnosticoArticular : Ext.getCmp('memDiagnosticoArticular').getValue(),
                pDiagnosticoPulpar : Ext.getCmp('memDiagnosticoPulpar').getValue(),
                pDiagnosticoPeriodontal : Ext.getCmp('memDiagnosticoPeriodontal').getValue(),
                pDiagnosticoDental : Ext.getCmp('memDiagnosticoDental').getValue(),
                pDiagnosticoCyD : Ext.getCmp('memDiagnosticoCyD').getValue(),
                pDiagnosticoTejidosBlandos : Ext.getCmp('memDiagnosticoTejidosBlandos').getValue(),
                pDiagnosticoOtros : Ext.getCmp('memDiagnosticoOtros').getValue(),
                pTipoAfiliado: Ext.getCmp('strTipoAfiliadoHC').getValue(),
                pTipoAtencion: Ext.getCmp('strTipoAtencionHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}


function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}