/*
* @category    Formulario Modelo Plantilla HC Programas Especiales (HTA - Diabetes Mellitus - Nefroproteccion)
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCProgramasEspeciales001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Programas Especiales (HTA - Diabetes Mellitus - Nefroproteccion) ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCProgEsp01',
    initComponent: function() {
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        var fsRevisionxSistemas = new fsRevisionxSistemasUi();
        var fsAntecedentesPersonales = new fsAntecedentesPersonalesUi();
        var fsAntecedentesFamiliares = new fsAntecedentesFamiliaresUi();
        var pnProgramasEspeciales = new pnProgramasEspecialesUi();
        var fsExamenFisico = new fsExamenFisicoUi();
        
        //NUEVO 2014
        //Consentimientos Informados
        var xConsentimientosInformados = new GridConsentimientosInformadosUi();
        //Consentimientos Informados
        var xEventosAdversos = new GridEventosAdversosUi();
        //KardexProgramas
        var xKardexProgramas = new GridKardexxPacUi();
        //Guias Atencion
        var xGuiasAtencion = new GridGuiasAtencionUi();
        //Fichas de Notificacion
        var xFichasNotificacion = new GridFichasNotificacionUi();
        //Docuentos Anexos
        var xDocumentosAnexos = new GridDocumentosAnexosUi();
        //Reporte Ordenamientos
        var xReporteOrdenamientos = new GridReporteOrdenamientosUi();
        Ext.getCmp('gridReporteParaclinicos').store.setBaseParam('pPaciente', wPaciente);
        Ext.getCmp('gridReporteParaclinicos').store.load();
        
        //Reporte Paraclinicos
        //var stReporteParaclinicos = new StoreGridReporteParaclinicos();
        //stReporteParaclinicos.load({
        //    params: {
        //        pPaciente: wPaciente
        //    }
        //});
        //
        //Alertas Medicas
        var xAlertasxPaciente = new AlertasxPaciente001Ui();
        Ext.getCmp('gridAlertasPacientes').store.baseParams = {
            task: 'LISTAR_ALERTAS',
            pPaciente: wPaciente,
            pIPS: ID_IPS
        };
        Ext.getCmp('gridAlertasPacientes').store.load({
            params: {
                pPaciente: wPaciente
            }
        });
        var xGridVacunacion = new GridVacunacionUi();
        var xGridActividadesAdicionales = new GridActividadesAdicionalesUi();
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    task: 'MX_IPS_BASICA',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var xSolNOPOS = new SolNOPOS001Ui();
        Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.load({
            params: {
                task: 'LISTAR_NOPOS',
                pPaciente: myPaciente
            }
        });
        
        var dataRiesgoPsicosocial01 = [
            [1,'Intenso'],
            [0,'Ausente']
        ];
        var stRiesgoPsicosocial01 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stRiesgoPsicosocial01.loadData(dataRiesgoPsicosocial01);    
        
        var dataRiesgoPsicosocial02 = [
            [1,'Nunca'],
            [0,'Casi Siempre'],
            [0,'A Veces']
        ];
        var stRiesgoPsicosocial02 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stRiesgoPsicosocial02.loadData(dataRiesgoPsicosocial02);    
        
        var xVerResumenDxxPaciente = new pnResumenDxxPaciente01();
        
        //Asignar Proxima Cita
        if (parseInt(wAsignarProximaCita) === 0){
            var xAsignarProximaCita = new fsAsignarProximaCita001Ui();
        }else{
            var xAsignarProximaCita = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        // Solicitud Examenes x Programa
        var xSolicitudExamenesxPrograma = new SolExaIPSxPROG201501Ui();
        Ext.getCmp('gridSolServiciosxPrograma').store.load({
            params: {
                pCAS: wCAS
            }
        });
        
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaAsignoCitaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysYaAsignoCitaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysSolicitaCitologia'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysSolicitaMamografia'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysSolicitaBaciloscopia'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaOrdenamientosHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            /*{
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },*/
                            {
                                xtype: 'combo',
                                fieldLabel: 'Genero',
                                width: 120,
                                name: 'cbGenero',
                                allowBlank: false,
                                store: stGeneroPacHC,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                emptyText: 'Seleccione Genero....',
                                forceSelection: true,
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                //xtype: 'textfield',
                                xtype: 'datefield',
                                width: 110,
                                allowBlank: true,
                                //readOnly: true,
                                id: 'sysFechaNacMod',
                                listeners: {
                                    change : function(f,pNew, pOld){
                                        if(pNew !== null && pNew !== ""){
                                            var fechaconsulta = Ext.getCmp('sysFechaHC').getValue().split("-");
                                            Ext.getCmp('sysEdadHC').setValue(MostrarEdadCompleta(fechaconsulta[2] + "/" + fechaconsulta[1] + "/" + fechaconsulta[0],Ext.getCmp('sysFechaNacMod').getValue().format('Y/m/d')));
                                            Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFechaNacMod').getValue().format('d/m/Y'));
                                        }
                                    }
                                }
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            },
                            {
                                xtype: 'button',
                                tooltip: 'Actuaizar Datos del Paciente',
                                iconCls: 'btnGuardar',
                                listeners: {
                                    click: function(){
                                        if(parseInt(Ext.getCmp('sysIdPacienteHC').getValue()) !== 0 && parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) !== 1 && Ext.getCmp('sysGeneroHC').getValue() !== "" && Ext.getCmp('sysGeneroHC').getValue() !== null && Ext.getCmp('sysFechaNac').getValue() !== "" && Ext.getCmp('sysFechaNac').getValue() !== null){
                                            Ext.Msg.show({
                                            title: 'Guardar Pacientes',
                                            msg: 'Esta seguro que desea modificar los datos del paciente?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    Ext.Ajax.request({
                                                        waitMsg: 'Por favor Espere...',
                                                        url: '../../controlador/asistencial/ipsbasica/evolucionhc201601.php',
                                                        params: {
                                                            task: 'UPDATE_DATAPAC',
                                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                                            pGenero: Ext.getCmp('sysGeneroHC').getValue(),
                                                            pFecNac: Ext.getCmp('sysFechaNacMod').getValue().format('Y-m-d')
                                                        },
                                                        success: function(response){
                                                            var result=eval(response.responseText);
                                                            switch(result){
                                                                case 1:
                                                                    CargueDefaultxPrograma("GESTANTES");
                                                                    Ext.MessageBox.show({
                                                                        title: 'Guardar',
                                                                        msg: 'Se actualizo la informacion del paciente.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.INFO
                                                                    });
                                                                    break;

                                                                default:
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'ocurrio un error al guardar los datos del paciente',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                    break;
                                                            }
                                                        },
                                                        failure: function(response){
                                                            var result = response.responseText;
                                                            Ext.MessageBox.show({
                                                                title: 'Error Base Datos',
                                                                msg: 'ocurrio un error al guardar los datos del paciente',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                    });
                                                }
                                            }
                                        });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No se puede modificar los datos del paciente porque los datos de fecha de nacimiento y genero son obligatorio y/o ya se guardo la historia clinica',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    /*{
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        //xtype: 'tabpanel',
                        xtype: 'multirowtabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHCProgEsp01',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'Acompañante - Responsable',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Vive Solo',
                                                        name: 'Vive Solo',
                                                        width: 60,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strViveSolo'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Acompañante',
                                                                name: 'Acompañante',
                                                                width: 350,
                                                                allowBlank: false,
                                                                id: 'strAcompanante'
                                                            },
                                                            {
                                                                html: '   Parentesco:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Parentezco',
                                                                width: 322,
                                                                allowBlank: true,
                                                                store: stParentesco,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strParentescoAcompanante'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Responsable',
                                                        name: 'Responsable',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strResponsable'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Direccion',
                                                                name: 'Direccion',
                                                                width: 350,
                                                                allowBlank: true,
                                                                id: 'strDireccionResponsable'
                                                            },
                                                            {
                                                                html: 'Telefono'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Telefono',
                                                                width: 340,
                                                                allowBlank: true,
                                                                id: 'strTelefonoResponsable'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            fsRevisionxSistemas,
                                            fsAntecedentesPersonales,
                                            fsAntecedentesFamiliares,
                                            fsExamenFisico,
                                            pnProgramasEspeciales,
                                            /*{
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },*/
                                            {
                                                xtype: 'fieldset',
                                                title: 'FORMULACION POST-FECHA',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Realizar Formulacion para',
                                                        name: 'Realizar Formulacion para',
                                                        width: 250,
                                                        allowBlank: true,
                                                        store: stMesesFormulacion,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 1,
                                                        id: 'sysFormulacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION PROXIMA CITA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable Proxima Cita',
                                                                name: 'Fecha Probable Proxima Cita',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecPROXCITACita'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPROXCITAProfesionalAtiende'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observacion',
                                                        name: 'Observacion',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memPROXCITAObservacion'
                                                    }
                                                ]
                                            },
                                            //Solicitud Examens por Programa
                                            xSolicitudExamenesxPrograma,
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                html: '<hr>'
                                            },
                                            xVerResumenDxxPaciente,
                                            {
                                                html: '<hr>'
                                            },
                                            fsDiagnosticosConsulta,
                                            {
                                                xtype: 'fieldset',
                                                title: 'SOLICITUD DE MEDICAMENTOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    xSolMX
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SOLICITUD DE SERVICIOS Y/O EXAMENES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    xSolEXA
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SOLICITUD DE REMISIONES REF/CONTRA REF.',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    xSolREM
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Asignar Proxima Cita',
                                autoHeight: true,
                                autoScroll: true,
                                //width: 921,
                                anchor: '99%',
                                frame: true,
                                border: false,
                                id: 'fichaProximaCita',
                                items: [
                                    xAsignarProximaCita
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Alertas',
                                height: 380,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaAlertas',
                                items: [
                                    xAlertasxPaciente
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ver Documentos Anexos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaDocumentosAnexos',
                                layout: 'form',
                                items: [
                                    xDocumentosAnexos
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Reporte de Resultados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaParaclinicos',
                                layout: 'form',
                                items: [
                                    xReporteOrdenamientos
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud NO POS',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaNOPOS',
                                items: [
                                    xSolNOPOS
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Vacunacion',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaVacunacion',
                                layout: 'form',
                                items: [
                                    xGridVacunacion
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Guias de Manejo',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaGuiasManejo',
                                layout: 'form',
                                items: [
                                    xGuiasAtencion
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Fichas de Notificacion',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaFichasNotificacion',
                                layout: 'form',
                                items: [
                                    xFichasNotificacion
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                layout: 'form',
                                items: [
                                    xConsentimientosInformados
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Notificacion Eventos Adversos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEventosAdversos',
                                layout: 'form',
                                items: [
                                    xEventosAdversos
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCProgEsp01').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCProgEsp01').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Informacion Adicional',
                            iconCls: 'btnVerHC',
                            listeners:{
                                click : function(){ 
                                    verInfoActividadesxPaciente(Ext.getCmp('sysIdPacienteHC').getValue(),Ext.getCmp('sysPacienteHC').getValue() + " - Genero: " + Ext.getCmp('sysGeneroHC').getValue() + " - Edad: " + Ext.getCmp('sysEdadHC').getValue());
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosProgEsp01();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosProgEsp01();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Deshabilitar botones solicitud de examenes
                    //Ext.getCmp('btnImportarUltimaExamen').disable();
                    //Ext.getCmp('btnAddExaEvolucion').disable();
                    //Ext.getCmp('btnDelExaEvolucion').disable();
                    ////////////////////////////////////////////
                    if(paramOpcion === "Nuevo"){ 
                        var frm = Ext.getCmp('frmHCProgEsp01').getForm();
                        frm.doAction('load', {
                            url: '../../controlador/asistencial/ipsbasica/evolucionhc201601.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesPaciente'
                            },
                            failure: function(response,options){
                                importarcronicos('frmHCProgEsp01', myCAS, Ext.getCmp('sysIdPacienteHC').getValue(),"CRONICOS");
                            },
                            success:function(form, action) {
                                importarcronicos('frmHCProgEsp01', myCAS, Ext.getCmp('sysIdPacienteHC').getValue(),"CRONICOS");
                            }
                        });
                    }else{
                        CargueDefaultxPrograma("CRONICOS");
                        Ext.getCmp('sysYaAsignoCitaHC').setValue(wAsignarProximaCita);
                    }
                    /*
                    if(Ext.getCmp('bolPROESPMetasCifras').getValue() == "SI"){
                        Ext.getCmp('intPROESPCumplidosCifras').allowBlank = false;
                    }
                    if(Ext.getCmp('bolPROESPMetasGlicemia').getValue() == "SI"){
                        Ext.getCmp('intPROESPCumplidosGlicemia').allowBlank = false;
                    }
                    if(Ext.getCmp('bolPROESPMetasHbA1').getValue() == "SI"){
                        Ext.getCmp('intPROESPCumplidosHbA1').allowBlank = false;
                    }
                    if(Ext.getCmp('bolPROESPMetasTrigliceridos').getValue() == "SI"){
                        Ext.getCmp('intPROESPCumplidosTrigliceridos').allowBlank = false;
                    }
                    if(Ext.getCmp('bolPROESPMetasLDL').getValue() == "SI"){
                        Ext.getCmp('intPROESPCumplidosLDL').allowBlank = false;
                    }
                    if(Ext.getCmp('bolPROESPMetasMicroalbuminuria').getValue() == "SI"){
                        Ext.getCmp('intPROESPCumplidosMicroalbuminuria').allowBlank = false;
                    }
                    if(Ext.getCmp('bolPROESPMetasHDL').getValue() == "SI"){
                        Ext.getCmp('intPROESPCumplidosHDL').allowBlank = false;
                    }
                    if(Ext.getCmp('bolPROESPMetasIMC').getValue() == "SI"){
                        Ext.getCmp('intPROESPCumplidosIMC').allowBlank = false;
                    }
                    if(Ext.getCmp('bolPROESPMetasPerimetroCintura').getValue() == "SI"){
                        Ext.getCmp('intPROESPCumplidospPerimetroCintura').allowBlank = false;
                    }
                    if(Ext.getCmp('bolPROESPMetasManejoEstres').getValue() == "SI"){
                        Ext.getCmp('intPROESPCumplidosEstres').allowBlank = false;
                    }
                    */
                    Ext.getCmp('gridAlertasPacientes').store.baseParams = {
                        task: 'LISTAR_ALERTAS',
                        pPaciente: myPaciente,
                        pIPS: ID_IPS
                    };
                    //Cargar Guias de Atencion
                    Ext.getCmp('gridGuiasAtencion').store.load({
                        params: {
                            pPlantilla: Ext.getCmp('sysIdCodPlantillaHC').getValue()
                        }
                    });
                    //Cargar Documentos Anexos
                    Ext.getCmp('gridDocumentosAnexos').store.baseParams = {
                        task: 'verDocumentosAnexosHC',
                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                    };
                    Ext.getCmp('gridDocumentosAnexos').store.load();
                    Ext.getCmp('sysFechaNacMod').setValue(Ext.getCmp('sysFechaNac').getValue());
                    /*
                    //Ocultar todo 4505
                    Ext.getCmp('fsIdentificacionRiesgo').setVisible(false);
                    Ext.getCmp('strOcupacionHC').setVisible(false);
                    Ext.getCmp('strOcupacionHC').allowBlank = true;
                    Ext.getCmp('sysOcupacionHCNom').setVisible(false);
                    Ext.getCmp('sysOcupacionHCNom').allowBlank = true;
                    Ext.getCmp('btnSearchOcupacionHC').setVisible(false);
                    Ext.getCmp('intEtniaHC').setVisible(false);
                    Ext.getCmp('intEtniaHC').allowBlank = true;
                    Ext.getCmp('intEscolaridadHC').setVisible(false);
                    Ext.getCmp('intEscolaridadHC').allowBlank = true;
                    Ext.getCmp('intIdentificacionRiesgoGestacion').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoGestacion').allowBlank = true;
                    Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').allowBlank = true;
                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').allowBlank = true;
                    
                    Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').allowBlank = true;
                    
                    Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').allowBlank = true;
                    
                    Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').allowBlank = true;
                    
                    Ext.getCmp('intIdentificacionRiesgoLepra').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoLepra').allowBlank = true;
                    
                    Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').allowBlank = true;
                    
                    Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').allowBlank = true;
                    
                    Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').allowBlank = true;
                    
                    Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').allowBlank = true;
                    
                    Ext.getCmp('intIdentificacionRiesgoFluorosisDental').setVisible(false);
                    Ext.getCmp('intIdentificacionRiesgoFluorosisDental').allowBlank = true;
                    */
                }
            }
        });
        winHCProgramasEspeciales001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosProgEsp01(){
    var frm = Ext.getCmp('frmHCProgEsp01').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc201501.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                pAsesoriaPreTestVIH4505: Ext.getCmp('strAsesoriaPreTestVIH').getValue(),
                pAsesoriaPostTestVIH4505: Ext.getCmp('strAsesoriaPostTestVIH').getValue(),
                
                //SIGNOS VITALES
                pGuardarSignos: "SI",
                pTASIS: Ext.getCmp('intEXAFISTASentadoSistolica').getValue(),
                pTADIAS: Ext.getCmp('intEXAFISTASentadoDiastolica').getValue(),
                pTensionArterialSistolicaPie: Ext.getCmp('intEXAFISTAdePieSistolica').getValue(),
                pTensionArterialDiastolicaPie: Ext.getCmp('intEXAFISTAdePieDiastolica').getValue(),
                pTalla: Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso: Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC: Ext.getCmp('intEXAFISIMC').getValue(),
                pIMCClasifica: Ext.getCmp('strEXAFISIMCClasificacon').getValue(),
                pPerimetroAbdominal: Ext.getCmp('strEXAFISPA').getValue(),
                pTE: Ext.getCmp('intEXAFISTemp').getValue(),
                pFC: Ext.getCmp('intEXAFISFC').getValue(),
                pFR: Ext.getCmp('intEXAFISFR').getValue(),
                
                //ANTECEDENTES 201508
                pAcompanante: Ext.getCmp('strAcompanante').getValue(),
                pParentescoAcompanante: Ext.getCmp('strParentescoAcompanante').getValue(),
                pResponsable: Ext.getCmp('strResponsable').getValue(),
                pResponsableDireccion: Ext.getCmp('strDireccionResponsable').getValue(),
                pResponsableTelefono: Ext.getCmp('strTelefonoResponsable').getValue(),
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pBiopsicosociales: Ext.getCmp('memANTPERSOBiopsicosociales').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCancer: Ext.getCmp('bolANTPERSOCancer').getValue(),
                pMamografia: Ext.getCmp('strANTGINECOMamografia').getValue(),
                pFecMamografia: Ext.getCmp('fecANTGINECOMamografia').getValue(),
                pResMamografia: Ext.getCmp('strANTGINECOMamografiaRes').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pCesarea: Ext.getCmp('intANTGINECOPC').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquiaPreg').getValue(),
                pMenarquiaDes: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFucPregunta: Ext.getCmp('strANTGINECOFuc').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pInicioActividad: Ext.getCmp('strANTGINECOInicioActividadSexual').getValue(),
                pCompanerosActividad: Ext.getCmp('strANTGINECONroCompanerosSexual').getValue(),
                pETS: Ext.getCmp('strANTGINECOETS').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pFamiliaresDiabetes: Ext.getCmp('strAntecedentesFamiliaresDiabetes').getValue(),
                pFamiliaresHTA: Ext.getCmp('strAntecedentesFamiliaresHTA').getValue(),
                pFamiliaresDislipidemia: Ext.getCmp('strAntecedentesFamiliaresDislipidemia').getValue(),
                pFamiliaresECCV: Ext.getCmp('strAntecedentesFamiliaresEnfermedadesCardioCerebroVasculares').getValue(),
                pFamiliaresCACervix: Ext.getCmp('strAntecedentesFamiliaresCACervix').getValue(),
                pFamiliaresCAProstata: Ext.getCmp('strAntecedentesFamiliaresCAProstata').getValue(),
                pFamiliaresCASeno: Ext.getCmp('strAntecedentesFamiliaresCASeno').getValue(),
                pFamiliaresCAEstomago: Ext.getCmp('strAntecedentesFamiliaresCAEstomago').getValue(),
                pFamiliaresCAColorrectal: Ext.getCmp('strAntecedentesFamiliaresCAColorrectal').getValue(),
                pGuardarAntecedentes: "SI",
                //FIN ANTECEDENTES 201508
                
                //PROGRAMA CRONICOS
                pProgramasEspecialesFechaIngreso : Ext.getCmp('fecPROGESPEIngreso').getValue(),
                pProgramasEspecialesViaCaptacion : Ext.getCmp('strPROGESPEViaCaptacion').getValue(),
                pProgramasEspecialesHTA : Ext.getCmp('strPROGESPEDxHTA').getValue(),
                pProgramasEspecialesHTATipoDx : Ext.getCmp('strPROGESPETipoDxHTA').getValue(),
                pProgramasEspecialesHTARiesgo : Ext.getCmp('strPROGESPENivelRiesgoHTA').getValue(),
                pProgramasEspecialesHTAMesDx : Ext.getCmp('intPROGESPEDxHTAMes').getValue(),
                pProgramasEspecialesHTAAnioDx : Ext.getCmp('intPROGESPEDxHTAAno').getValue(),
                pProgramasEspecialesHTAEstadio : Ext.getCmp('strPROGESPEDxHTAEstadio').getValue(),
                pProgramasEspecialesDM : Ext.getCmp('strPROGESPEDxDM').getValue(),
                pProgramasEspecialesDMTipoDx : Ext.getCmp('strPROGESPETipoDxDM').getValue(),
                pProgramasEspecialesDMRiesgo : Ext.getCmp('strPROGESPENivelRiesgoDM').getValue(),
                pProgramasEspecialesDMMesDx : Ext.getCmp('intPROGESPEDxDMMes').getValue(),
                pProgramasEspecialesDMAnioDx : Ext.getCmp('intPROGESPEDxDMAno').getValue(),
                pProgramasEspecialesTipoDM : Ext.getCmp('strPROGESPETipoDM').getValue(),
                pProgramasEspecialesNefro : Ext.getCmp('strPROGESPEDxNefroProteccion').getValue(),
                pProgramasEspecialesNefroTipoDx : Ext.getCmp('strPROGESPETipoDxNefroProteccion').getValue(),
                pProgramasEspecialesNefroRiesgo : Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').getValue(),
                pProgramasEspecialesNefroMesDx : Ext.getCmp('intPROGESPEDxNefroProteccionMes').getValue(),
                pProgramasEspecialesNefroAniosDx : Ext.getCmp('intPROGESPEDxNefroProteccionAno').getValue(),
                pProgramasEspecialesNefroEstadio : Ext.getCmp('strPROGESPEEstadioNefroProteccion').getValue(),
                pProgramasEspecialesMetasCifras : Ext.getCmp('bolPROESPMetasCifras').getValue(),
                pProgramasEspecialesMetasGlicemia : Ext.getCmp('bolPROESPMetasGlicemia').getValue(),
                pProgramasEspecialesMetasHbA1 : Ext.getCmp('bolPROESPMetasHbA1').getValue(),
                pProgramasEspecialesMetasTrigliceridos : Ext.getCmp('bolPROESPMetasTrigliceridos').getValue(),
                pProgramasEspecialesMetasLDL : Ext.getCmp('bolPROESPMetasLDL').getValue(),
                pProgramasEspecialesMetasHDL : Ext.getCmp('bolPROESPMetasHDL').getValue(),
                pProgramasEspecialesMetasMicroalbuminuria : Ext.getCmp('bolPROESPMetasMicroalbuminuria').getValue(),
                pProgramasEspecialesMetasIMC : Ext.getCmp('bolPROESPMetasIMC').getValue(),
                pProgramasEspecialesMetasPerimetroCintura : Ext.getCmp('bolPROESPMetasPerimetroCintura').getValue(),
                pProgramasEspecialesMetasManejoEstres : Ext.getCmp('bolPROESPMetasManejoEstres').getValue(),
                pProgramasEspecialesMetasCumplidas : Ext.getCmp('intPROGESPENumCumplimientoMetas').getValue(),
                pProgramasEspecialesIngresoUroanalisisFec : Ext.getCmp('fecPROGESPEParcialorina').getValue(),
                pProgramasEspecialesIngresoUroanalisisRes : Ext.getCmp('strPROGESPEParcialorinaRes').getValue(),
                pProgramasEspecialesIngresoColesterolTotalFec : Ext.getCmp('fecPROGESPEColesterolTotal').getValue(),
                pProgramasEspecialesIngresoColesterolTotalRes : Ext.getCmp('strPROGESPEColesterolTotalRes').getValue(),
                pProgramasEspecialesIngresoHDLFec : Ext.getCmp('fecPROGESPEColesterolHDL').getValue(),
                pProgramasEspecialesIngresoHDLRes : Ext.getCmp('strPROGESPEColesterolHDLRes').getValue(),
                pProgramasEspecialesIngresoLDLFec : Ext.getCmp('fecPROGESPEColesterolLDL').getValue(),
                pProgramasEspecialesIngresoLDLRes : Ext.getCmp('strPROGESPEColesterolLDLRes').getValue(),
                pProgramasEspecialesIngresoTrigliceridosFec : Ext.getCmp('fecPROGESPETrigliceridos').getValue(),
                pProgramasEspecialesIngresoTrigliceridosRes : Ext.getCmp('strPROGESPETrigliceridosRes').getValue(),
                pProgramasEspecialesIngresoHemoGlicosiladaFec : Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').getValue(),
                pProgramasEspecialesIngresoHemoGlicosiladaRes : Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').getValue(),
                pProgramasEspecialesIngresoGlicemiaFec : Ext.getCmp('fecPROGESPEGlicemia').getValue(),
                pProgramasEspecialesIngresoGlicemiaRes : Ext.getCmp('strPROGESPEGlicemiaRes').getValue(),
                pProgramasEspecialesIngresoMicroalbuminuriaFec : Ext.getCmp('fecPROGESPEMicroAlbuminuria').getValue(),
                pProgramasEspecialesIngresoMicroalbuminuriaRes : Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').getValue(),
                pProgramasEspecialesIngresoCreatininaFec : Ext.getCmp('fecPROGESPECreatinina').getValue(),
                pProgramasEspecialesIngresoCreatininaRes : Ext.getCmp('strPROGESPECreatininaRes').getValue(),
                pProgramasEspecialesIngresoTFG : Ext.getCmp('intPROGESPETFGIngreso').getValue(),
                pProgramasEspecialesIngresoTFGEstadio : Ext.getCmp('strPROGESPETFGIngresoCalsifica').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisFec : Ext.getCmp('fecPROGESPESeguimientoParcialorina').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisRes : Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalFec : Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalRes : Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').getValue(),
                pProgramasEspecialesSeguimientoHDLFec : Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').getValue(),
                pProgramasEspecialesSeguimientoHDLRes : Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').getValue(),
                pProgramasEspecialesSeguimientoLDLFec : Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').getValue(),
                pProgramasEspecialesSeguimientoLDLRes : Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosFec : Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosRes : Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaFec : Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaRes : Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaFec : Ext.getCmp('fecPROGESPESeguimientoGlicemia').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaRes : Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaFec : Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaRes : Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').getValue(),
                pProgramasEspecialesSeguimientoCreatininaFec : Ext.getCmp('fecPROGESPESeguimientoCreatinina').getValue(),
                pProgramasEspecialesSeguimientoCreatininaRes : Ext.getCmp('strPROGESPESeguimientoCreatininaRes').getValue(),
                pProgramasEspecialesSeguimientoTFG : Ext.getCmp('strPROGESPETFGSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTFGEstadio : Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').getValue(),
                
                pProgramasEspecialesTipoInsulina : Ext.getCmp('strPROGESPETipoDMInsulina').getValue(),
                pProgramasEspecialesIngresoProteinasFec : Ext.getCmp('fecPROGESPEProteinas').getValue(),
                pProgramasEspecialesIngresoProteinasRes : Ext.getCmp('strPROGESPEProteinasRes').getValue(),
                pProgramasEspecialesIngresoEcografiaFec : Ext.getCmp('fecPROGESPEEcografiaRenal').getValue(),
                pProgramasEspecialesIngresoEcografiaRes : Ext.getCmp('strPROGESPEEcografiaRenalRes').getValue(),
                pProgramasEspecialesIngresoTalla : Ext.getCmp('intTallaIngreso').getValue(),
                pProgramasEspecialesIngresoPeso : Ext.getCmp('intPesoIngreso').getValue(),
                pProgramasEspecialesIngresoTASistolica : Ext.getCmp('intTASistolicaIngreso').getValue(),
                pProgramasEspecialesIngresoTADiastolica : Ext.getCmp('intTADiastolicaIngreso').getValue(),
                pProgramasEspecialesIngresoIMC : Ext.getCmp('intIMCIngreso').getValue(),
                pProgramasEspecialesIngresoPerimetroAbdominal : Ext.getCmp('strPAIngreso').getValue(),
                pProgramasEspecialesSeguimientoRiesgoHTA : Ext.getCmp('strPROGESPENivelRiesgoHTASeguimiento').getValue(),
                pProgramasEspecialesSeguimientoRiesgoDM : Ext.getCmp('strPROGESPENivelRiesgoDMSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTipoDM : Ext.getCmp('strPROGESPETipoDMSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTipoInsulina : Ext.getCmp('strPROGESPETipoDMInsulinaSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoRiesgoNefro : Ext.getCmp('strPROGESPENivelRiesgoNefroProteccionSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoEstadioNefro : Ext.getCmp('strPROGESPEEstadioNefroProteccionSeguimiento').getValue(),
                pProgramasEspecialesComplicacionesCardiovascular : Ext.getCmp('strAmbulatorioComplicacionCardiovascular').getValue(),
                pProgramasEspecialesComplicacionesCardiovascularMes : Ext.getCmp('strAmbulatorioComplicacionCardiovascularMes').getValue(),
                pProgramasEspecialesComplicacionesCardiovascularAnio : Ext.getCmp('strAmbulatorioComplicacionCardiovascularAño').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascular : Ext.getCmp('strAmbulatorioComplicacionCerebrovascular').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascularMes : Ext.getCmp('strAmbulatorioComplicacionCerebrovascularMes').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascularAnio : Ext.getCmp('strAmbulatorioComplicacionCerebrovascularAño').getValue(),
                pProgramasEspecialesComplicacionesPieDiabetico : Ext.getCmp('strAmbulatorioComplicacionPieDiabetico').getValue(),
                pProgramasEspecialesComplicacionesPieDiabeticoMes : Ext.getCmp('strAmbulatorioComplicacionPieDiabeticoMes').getValue(),
                pProgramasEspecialesComplicacionesPieDiabeticoAnio : Ext.getCmp('strAmbulatorioComplicacionPieDiabeticoAño').getValue(),
                pProgramasEspecialesComplicacionesRetinopatia : Ext.getCmp('strAmbulatorioComplicacionRetinopatia').getValue(),
                pProgramasEspecialesComplicacionesRetinopatiaMes : Ext.getCmp('strAmbulatorioComplicacionRetinopatiaMes').getValue(),
                pProgramasEspecialesComplicacionesRetinopatiaAnio : Ext.getCmp('strAmbulatorioComplicacionRetinopatiaAño').getValue(),
                pProgramasEspecialesComplicacionesVasculares : Ext.getCmp('strAmbulatorioComplicacionVascularesPerifericas').getValue(),
                pProgramasEspecialesComplicacionesVascularesMes : Ext.getCmp('strAmbulatorioComplicacionVascularesPerifericasMes').getValue(),
                pProgramasEspecialesComplicacionesVascularesAnio : Ext.getCmp('strAmbulatorioComplicacionVascularesPerifericasAño').getValue(),
                pProgramasEspecialesComplicacionesERC : Ext.getCmp('strAmbulatorioComplicacionEnfermedadRenalCronica').getValue(),
                pProgramasEspecialesComplicacionesERCMes : Ext.getCmp('strAmbulatorioComplicacionEnfermedadRenalCronicaMes').getValue(),
                pProgramasEspecialesComplicacionesERCAnio : Ext.getCmp('strAmbulatorioComplicacionEnfermedadRenalCronicaAño').getValue(),
                pProgramasEspecialesComplicacionesOtro : Ext.getCmp('strAmbulatorioComplicacionOtroEvento').getValue(),
                pProgramasEspecialesComplicacionesOtroMes : Ext.getCmp('strAmbulatorioComplicacionOtroEventoMes').getValue(),
                pProgramasEspecialesComplicacionesOtroAnio : Ext.getCmp('strAmbulatorioComplicacionOtroEventoAño').getValue(),
                pProgramasEspecialesComplicacionesSindromeMetabolico : Ext.getCmp('strAmbulatorioComplicacionSindromeMetabolico').getValue(),
                pProgramasEspecialesComplicacionesSindromeMetabolicoMes : Ext.getCmp('strAmbulatorioComplicacionSindromeMetabolicoMes').getValue(),
                pProgramasEspecialesComplicacionesSindromeMetabolicoAnio : Ext.getCmp('strAmbulatorioComplicacionSindromeMetabolicoAño').getValue(),
                pProgramasEspecialesComplicacionesFallaCardiaca : Ext.getCmp('strAmbulatorioComplicacionFallaCardiaca').getValue(),
                pProgramasEspecialesComplicacionesFallaCardiacaMes : Ext.getCmp('strAmbulatorioComplicacionFallaCardiacaMes').getValue(),
                pProgramasEspecialesComplicacionesFallaCardiacaAnio : Ext.getCmp('strAmbulatorioComplicacionFallaCardiacaAño').getValue(),
                pProgramasEspecialesComplicacionesEPOC : Ext.getCmp('strAmbulatorioComplicacionEPOC').getValue(),
                pProgramasEspecialesComplicacionesEPOCMes : Ext.getCmp('strAmbulatorioComplicacionEPOCMes').getValue(),
                pProgramasEspecialesComplicacionesEPOCAnio : Ext.getCmp('strAmbulatorioComplicacionEPOCAño').getValue(),
                pProgramasEspecialesComplicacionesArtritis : Ext.getCmp('strAmbulatorioComplicacionArtritis').getValue(),
                pProgramasEspecialesComplicacionesArtritisMes : Ext.getCmp('strAmbulatorioComplicacionArtritisMes').getValue(),
                pProgramasEspecialesComplicacionesArtritisAnio : Ext.getCmp('strAmbulatorioComplicacionArtritisAño').getValue(),
                pProgramasEspecialesRiesgoCardioVascular : Ext.getCmp('intRiesgoCardioVascular').getValue(),
                pProgramasEspecialesRiesgoCardioVascularClasificacion : Ext.getCmp('strClasificacionRiesgoCardioVascular').getValue(),
                pProgramasEspecialesMetodoPlanificacion : Ext.getCmp('strMetodoPlanifica').getValue(),
                pProgramasEspecialesViveSolo : Ext.getCmp('strViveSolo').getValue(),
                pProgramasEspecialesAcompanante : Ext.getCmp('strAcompanante').getValue(),
                pProgramasEspecialesParentescoAcompanante : Ext.getCmp('strParentescoAcompanante').getValue(),
                pProgramasEspecialesComplicacionesHospCardioVascular : Ext.getCmp('strHospitalariaComplicacionCardiovascular').getValue(),
                pProgramasEspecialesComplicacionesHospCardioVascularMes : Ext.getCmp('strHospitalariaComplicacionCardiovascularMes').getValue(),
                pProgramasEspecialesComplicacionesHospCardioVascularAnio : Ext.getCmp('strHospitalariaComplicacionCardiovascularAño').getValue(),
                pProgramasEspecialesComplicacionesHospCerebroVascular : Ext.getCmp('strHospitalariaComplicacionCerebrovascular').getValue(),
                pProgramasEspecialesComplicacionesHospCerebroVascularMes : Ext.getCmp('strHospitalariaComplicacionCerebrovascularMes').getValue(),
                pProgramasEspecialesComplicacionesHospCerebroVascularAnio : Ext.getCmp('strHospitalariaComplicacionCerebrovascularAño').getValue(),
                pProgramasEspecialesComplicacionesHospRetinopatia : Ext.getCmp('strHospitalariaComplicacionRetinopatia').getValue(),
                pProgramasEspecialesComplicacionesHospRetinopatiaMes : Ext.getCmp('strHospitalariaComplicacionRetinopatiaMes').getValue(),
                pProgramasEspecialesComplicacionesHospRetinopatiaAnio : Ext.getCmp('strHospitalariaComplicacionRetinopatiaAño').getValue(),
                pProgramasEspecialesComplicacionesHospERC : Ext.getCmp('strHospitalariaComplicacionEnfermedadRenalCronica').getValue(),
                pProgramasEspecialesComplicacionesHospERCMes : Ext.getCmp('strHospitalariaComplicacionEnfermedadRenalCronicaMes').getValue(),
                pProgramasEspecialesComplicacionesHospERCAnio : Ext.getCmp('strHospitalariaComplicacionEnfermedadRenalCronicaAño').getValue(),
                pProgramasEspecialesComplicacionesHospGastro : Ext.getCmp('strHospitalariaComplicacionGastroIntestinales').getValue(),
                pProgramasEspecialesComplicacionesHospGastroMes : Ext.getCmp('strHospitalariaComplicacionGastroIntestinalesMes').getValue(),
                pProgramasEspecialesComplicacionesHospGastroAnio : Ext.getCmp('strHospitalariaComplicacionGastroIntestinalesAño').getValue(),
                pProgramasEspecialesComplicacionesHospOtro : Ext.getCmp('strHospitalariaComplicacionOtroEvento').getValue(),
                pProgramasEspecialesComplicacionesHospOtroMes : Ext.getCmp('strHospitalariaComplicacionOtroEventoMes').getValue(),
                pProgramasEspecialesComplicacionesHospOtroAnio : Ext.getCmp('strHospitalariaComplicacionOtroEventoAño').getValue(),
                pProgramasEspecialesProgramaActual : Ext.getCmp('strProgramaCronicos').getValue(),
                pGuardarCronicos: "SI",
                pSolicitarCitologia: Ext.getCmp('sysSolicitaCitologia').getValue(),
                pSolicitarMamografia: Ext.getCmp('sysSolicitaMamografia').getValue(),
                pSolicitarBaciloscopia: Ext.getCmp('sysSolicitaBaciloscopia').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        if(parseInt(Ext.getCmp('sysYaOrdenamientosHC').getValue()) === 0){
                            //solicitarOrdenamientosProgramaCronicos();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosProgEsp01(){
    var frm = Ext.getCmp('frmHCProgEsp01').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc201501.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                pAsesoriaPreTestVIH4505: Ext.getCmp('strAsesoriaPreTestVIH').getValue(),
                pAsesoriaPostTestVIH4505: Ext.getCmp('strAsesoriaPostTestVIH').getValue(),
                
                //SIGNOS VITALES
                pGuardarSignos: "SI",
                pTASIS: Ext.getCmp('intEXAFISTASentadoSistolica').getValue(),
                pTADIAS: Ext.getCmp('intEXAFISTASentadoDiastolica').getValue(),
                pTensionArterialSistolicaPie: Ext.getCmp('intEXAFISTAdePieSistolica').getValue(),
                pTensionArterialDiastolicaPie: Ext.getCmp('intEXAFISTAdePieDiastolica').getValue(),
                pTalla: Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso: Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC: Ext.getCmp('intEXAFISIMC').getValue(),
                pIMCClasifica: Ext.getCmp('strEXAFISIMCClasificacon').getValue(),
                pPerimetroAbdominal: Ext.getCmp('strEXAFISPA').getValue(),
                pTE: Ext.getCmp('intEXAFISTemp').getValue(),
                pFC: Ext.getCmp('intEXAFISFC').getValue(),
                pFR: Ext.getCmp('intEXAFISFR').getValue(),
                
                //ANTECEDENTES 201508
                pAcompanante: Ext.getCmp('strAcompanante').getValue(),
                pParentescoAcompanante: Ext.getCmp('strParentescoAcompanante').getValue(),
                pResponsable: Ext.getCmp('strResponsable').getValue(),
                pResponsableDireccion: Ext.getCmp('strDireccionResponsable').getValue(),
                pResponsableTelefono: Ext.getCmp('strTelefonoResponsable').getValue(),
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pBiopsicosociales: Ext.getCmp('memANTPERSOBiopsicosociales').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCancer: Ext.getCmp('bolANTPERSOCancer').getValue(),
                pMamografia: Ext.getCmp('strANTGINECOMamografia').getValue(),
                pFecMamografia: Ext.getCmp('fecANTGINECOMamografia').getValue(),
                pResMamografia: Ext.getCmp('strANTGINECOMamografiaRes').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pCesarea: Ext.getCmp('intANTGINECOPC').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquiaPreg').getValue(),
                pMenarquiaDes: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFucPregunta: Ext.getCmp('strANTGINECOFuc').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pInicioActividad: Ext.getCmp('strANTGINECOInicioActividadSexual').getValue(),
                pCompanerosActividad: Ext.getCmp('strANTGINECONroCompanerosSexual').getValue(),
                pETS: Ext.getCmp('strANTGINECOETS').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pFamiliaresDiabetes: Ext.getCmp('strAntecedentesFamiliaresDiabetes').getValue(),
                pFamiliaresHTA: Ext.getCmp('strAntecedentesFamiliaresHTA').getValue(),
                pFamiliaresDislipidemia: Ext.getCmp('strAntecedentesFamiliaresDislipidemia').getValue(),
                pFamiliaresECCV: Ext.getCmp('strAntecedentesFamiliaresEnfermedadesCardioCerebroVasculares').getValue(),
                pFamiliaresCACervix: Ext.getCmp('strAntecedentesFamiliaresCACervix').getValue(),
                pFamiliaresCAProstata: Ext.getCmp('strAntecedentesFamiliaresCAProstata').getValue(),
                pFamiliaresCASeno: Ext.getCmp('strAntecedentesFamiliaresCASeno').getValue(),
                pFamiliaresCAEstomago: Ext.getCmp('strAntecedentesFamiliaresCAEstomago').getValue(),
                pFamiliaresCAColorrectal: Ext.getCmp('strAntecedentesFamiliaresCAColorrectal').getValue(),
                pGuardarAntecedentes: "SI",
                //FIN ANTECEDENTES 201508
                
                //PROGRAMA CRONICOS
                pProgramasEspecialesFechaIngreso : Ext.getCmp('fecPROGESPEIngreso').getValue(),
                pProgramasEspecialesViaCaptacion : Ext.getCmp('strPROGESPEViaCaptacion').getValue(),
                pProgramasEspecialesHTA : Ext.getCmp('strPROGESPEDxHTA').getValue(),
                pProgramasEspecialesHTATipoDx : Ext.getCmp('strPROGESPETipoDxHTA').getValue(),
                pProgramasEspecialesHTARiesgo : Ext.getCmp('strPROGESPENivelRiesgoHTA').getValue(),
                pProgramasEspecialesHTAMesDx : Ext.getCmp('intPROGESPEDxHTAMes').getValue(),
                pProgramasEspecialesHTAAnioDx : Ext.getCmp('intPROGESPEDxHTAAno').getValue(),
                pProgramasEspecialesHTAEstadio : Ext.getCmp('strPROGESPEDxHTAEstadio').getValue(),
                pProgramasEspecialesDM : Ext.getCmp('strPROGESPEDxDM').getValue(),
                pProgramasEspecialesDMTipoDx : Ext.getCmp('strPROGESPETipoDxDM').getValue(),
                pProgramasEspecialesDMRiesgo : Ext.getCmp('strPROGESPENivelRiesgoDM').getValue(),
                pProgramasEspecialesDMMesDx : Ext.getCmp('intPROGESPEDxDMMes').getValue(),
                pProgramasEspecialesDMAnioDx : Ext.getCmp('intPROGESPEDxDMAno').getValue(),
                pProgramasEspecialesTipoDM : Ext.getCmp('strPROGESPETipoDM').getValue(),
                pProgramasEspecialesNefro : Ext.getCmp('strPROGESPEDxNefroProteccion').getValue(),
                pProgramasEspecialesNefroTipoDx : Ext.getCmp('strPROGESPETipoDxNefroProteccion').getValue(),
                pProgramasEspecialesNefroRiesgo : Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').getValue(),
                pProgramasEspecialesNefroMesDx : Ext.getCmp('intPROGESPEDxNefroProteccionMes').getValue(),
                pProgramasEspecialesNefroAniosDx : Ext.getCmp('intPROGESPEDxNefroProteccionAno').getValue(),
                pProgramasEspecialesNefroEstadio : Ext.getCmp('strPROGESPEEstadioNefroProteccion').getValue(),
                pProgramasEspecialesMetasCifras : Ext.getCmp('bolPROESPMetasCifras').getValue(),
                pProgramasEspecialesMetasGlicemia : Ext.getCmp('bolPROESPMetasGlicemia').getValue(),
                pProgramasEspecialesMetasHbA1 : Ext.getCmp('bolPROESPMetasHbA1').getValue(),
                pProgramasEspecialesMetasTrigliceridos : Ext.getCmp('bolPROESPMetasTrigliceridos').getValue(),
                pProgramasEspecialesMetasLDL : Ext.getCmp('bolPROESPMetasLDL').getValue(),
                pProgramasEspecialesMetasHDL : Ext.getCmp('bolPROESPMetasHDL').getValue(),
                pProgramasEspecialesMetasMicroalbuminuria : Ext.getCmp('bolPROESPMetasMicroalbuminuria').getValue(),
                pProgramasEspecialesMetasIMC : Ext.getCmp('bolPROESPMetasIMC').getValue(),
                pProgramasEspecialesMetasPerimetroCintura : Ext.getCmp('bolPROESPMetasPerimetroCintura').getValue(),
                pProgramasEspecialesMetasManejoEstres : Ext.getCmp('bolPROESPMetasManejoEstres').getValue(),
                pProgramasEspecialesMetasCumplidas : Ext.getCmp('intPROGESPENumCumplimientoMetas').getValue(),
                pProgramasEspecialesIngresoUroanalisisFec : Ext.getCmp('fecPROGESPEParcialorina').getValue(),
                pProgramasEspecialesIngresoUroanalisisRes : Ext.getCmp('strPROGESPEParcialorinaRes').getValue(),
                pProgramasEspecialesIngresoColesterolTotalFec : Ext.getCmp('fecPROGESPEColesterolTotal').getValue(),
                pProgramasEspecialesIngresoColesterolTotalRes : Ext.getCmp('strPROGESPEColesterolTotalRes').getValue(),
                pProgramasEspecialesIngresoHDLFec : Ext.getCmp('fecPROGESPEColesterolHDL').getValue(),
                pProgramasEspecialesIngresoHDLRes : Ext.getCmp('strPROGESPEColesterolHDLRes').getValue(),
                pProgramasEspecialesIngresoLDLFec : Ext.getCmp('fecPROGESPEColesterolLDL').getValue(),
                pProgramasEspecialesIngresoLDLRes : Ext.getCmp('strPROGESPEColesterolLDLRes').getValue(),
                pProgramasEspecialesIngresoTrigliceridosFec : Ext.getCmp('fecPROGESPETrigliceridos').getValue(),
                pProgramasEspecialesIngresoTrigliceridosRes : Ext.getCmp('strPROGESPETrigliceridosRes').getValue(),
                pProgramasEspecialesIngresoHemoGlicosiladaFec : Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').getValue(),
                pProgramasEspecialesIngresoHemoGlicosiladaRes : Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').getValue(),
                pProgramasEspecialesIngresoGlicemiaFec : Ext.getCmp('fecPROGESPEGlicemia').getValue(),
                pProgramasEspecialesIngresoGlicemiaRes : Ext.getCmp('strPROGESPEGlicemiaRes').getValue(),
                pProgramasEspecialesIngresoMicroalbuminuriaFec : Ext.getCmp('fecPROGESPEMicroAlbuminuria').getValue(),
                pProgramasEspecialesIngresoMicroalbuminuriaRes : Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').getValue(),
                pProgramasEspecialesIngresoCreatininaFec : Ext.getCmp('fecPROGESPECreatinina').getValue(),
                pProgramasEspecialesIngresoCreatininaRes : Ext.getCmp('strPROGESPECreatininaRes').getValue(),
                pProgramasEspecialesIngresoTFG : Ext.getCmp('intPROGESPETFGIngreso').getValue(),
                pProgramasEspecialesIngresoTFGEstadio : Ext.getCmp('strPROGESPETFGIngresoCalsifica').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisFec : Ext.getCmp('fecPROGESPESeguimientoParcialorina').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisRes : Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalFec : Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalRes : Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').getValue(),
                pProgramasEspecialesSeguimientoHDLFec : Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').getValue(),
                pProgramasEspecialesSeguimientoHDLRes : Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').getValue(),
                pProgramasEspecialesSeguimientoLDLFec : Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').getValue(),
                pProgramasEspecialesSeguimientoLDLRes : Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosFec : Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosRes : Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaFec : Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaRes : Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaFec : Ext.getCmp('fecPROGESPESeguimientoGlicemia').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaRes : Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaFec : Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaRes : Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').getValue(),
                pProgramasEspecialesSeguimientoCreatininaFec : Ext.getCmp('fecPROGESPESeguimientoCreatinina').getValue(),
                pProgramasEspecialesSeguimientoCreatininaRes : Ext.getCmp('strPROGESPESeguimientoCreatininaRes').getValue(),
                pProgramasEspecialesSeguimientoTFG : Ext.getCmp('strPROGESPETFGSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTFGEstadio : Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').getValue(),
                
                pProgramasEspecialesTipoInsulina : Ext.getCmp('strPROGESPETipoDMInsulina').getValue(),
                pProgramasEspecialesIngresoProteinasFec : Ext.getCmp('fecPROGESPEProteinas').getValue(),
                pProgramasEspecialesIngresoProteinasRes : Ext.getCmp('strPROGESPEProteinasRes').getValue(),
                pProgramasEspecialesIngresoEcografiaFec : Ext.getCmp('fecPROGESPEEcografiaRenal').getValue(),
                pProgramasEspecialesIngresoEcografiaRes : Ext.getCmp('strPROGESPEEcografiaRenalRes').getValue(),
                pProgramasEspecialesIngresoTalla : Ext.getCmp('intTallaIngreso').getValue(),
                pProgramasEspecialesIngresoPeso : Ext.getCmp('intPesoIngreso').getValue(),
                pProgramasEspecialesIngresoTASistolica : Ext.getCmp('intTASistolicaIngreso').getValue(),
                pProgramasEspecialesIngresoTADiastolica : Ext.getCmp('intTADiastolicaIngreso').getValue(),
                pProgramasEspecialesIngresoIMC : Ext.getCmp('intIMCIngreso').getValue(),
                pProgramasEspecialesIngresoPerimetroAbdominal : Ext.getCmp('strPAIngreso').getValue(),
                pProgramasEspecialesSeguimientoRiesgoHTA : Ext.getCmp('strPROGESPENivelRiesgoHTASeguimiento').getValue(),
                pProgramasEspecialesSeguimientoRiesgoDM : Ext.getCmp('strPROGESPENivelRiesgoDMSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTipoDM : Ext.getCmp('strPROGESPETipoDMSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTipoInsulina : Ext.getCmp('strPROGESPETipoDMInsulinaSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoRiesgoNefro : Ext.getCmp('strPROGESPENivelRiesgoNefroProteccionSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoEstadioNefro : Ext.getCmp('strPROGESPEEstadioNefroProteccionSeguimiento').getValue(),
                pProgramasEspecialesComplicacionesCardiovascular : Ext.getCmp('strAmbulatorioComplicacionCardiovascular').getValue(),
                pProgramasEspecialesComplicacionesCardiovascularMes : Ext.getCmp('strAmbulatorioComplicacionCardiovascularMes').getValue(),
                pProgramasEspecialesComplicacionesCardiovascularAnio : Ext.getCmp('strAmbulatorioComplicacionCardiovascularAño').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascular : Ext.getCmp('strAmbulatorioComplicacionCerebrovascular').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascularMes : Ext.getCmp('strAmbulatorioComplicacionCerebrovascularMes').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascularAnio : Ext.getCmp('strAmbulatorioComplicacionCerebrovascularAño').getValue(),
                pProgramasEspecialesComplicacionesPieDiabetico : Ext.getCmp('strAmbulatorioComplicacionPieDiabetico').getValue(),
                pProgramasEspecialesComplicacionesPieDiabeticoMes : Ext.getCmp('strAmbulatorioComplicacionPieDiabeticoMes').getValue(),
                pProgramasEspecialesComplicacionesPieDiabeticoAnio : Ext.getCmp('strAmbulatorioComplicacionPieDiabeticoAño').getValue(),
                pProgramasEspecialesComplicacionesRetinopatia : Ext.getCmp('strAmbulatorioComplicacionRetinopatia').getValue(),
                pProgramasEspecialesComplicacionesRetinopatiaMes : Ext.getCmp('strAmbulatorioComplicacionRetinopatiaMes').getValue(),
                pProgramasEspecialesComplicacionesRetinopatiaAnio : Ext.getCmp('strAmbulatorioComplicacionRetinopatiaAño').getValue(),
                pProgramasEspecialesComplicacionesVasculares : Ext.getCmp('strAmbulatorioComplicacionVascularesPerifericas').getValue(),
                pProgramasEspecialesComplicacionesVascularesMes : Ext.getCmp('strAmbulatorioComplicacionVascularesPerifericasMes').getValue(),
                pProgramasEspecialesComplicacionesVascularesAnio : Ext.getCmp('strAmbulatorioComplicacionVascularesPerifericasAño').getValue(),
                pProgramasEspecialesComplicacionesERC : Ext.getCmp('strAmbulatorioComplicacionEnfermedadRenalCronica').getValue(),
                pProgramasEspecialesComplicacionesERCMes : Ext.getCmp('strAmbulatorioComplicacionEnfermedadRenalCronicaMes').getValue(),
                pProgramasEspecialesComplicacionesERCAnio : Ext.getCmp('strAmbulatorioComplicacionEnfermedadRenalCronicaAño').getValue(),
                pProgramasEspecialesComplicacionesOtro : Ext.getCmp('strAmbulatorioComplicacionOtroEvento').getValue(),
                pProgramasEspecialesComplicacionesOtroMes : Ext.getCmp('strAmbulatorioComplicacionOtroEventoMes').getValue(),
                pProgramasEspecialesComplicacionesOtroAnio : Ext.getCmp('strAmbulatorioComplicacionOtroEventoAño').getValue(),
                pProgramasEspecialesComplicacionesSindromeMetabolico : Ext.getCmp('strAmbulatorioComplicacionSindromeMetabolico').getValue(),
                pProgramasEspecialesComplicacionesSindromeMetabolicoMes : Ext.getCmp('strAmbulatorioComplicacionSindromeMetabolicoMes').getValue(),
                pProgramasEspecialesComplicacionesSindromeMetabolicoAnio : Ext.getCmp('strAmbulatorioComplicacionSindromeMetabolicoAño').getValue(),
                pProgramasEspecialesComplicacionesFallaCardiaca : Ext.getCmp('strAmbulatorioComplicacionFallaCardiaca').getValue(),
                pProgramasEspecialesComplicacionesFallaCardiacaMes : Ext.getCmp('strAmbulatorioComplicacionFallaCardiacaMes').getValue(),
                pProgramasEspecialesComplicacionesFallaCardiacaAnio : Ext.getCmp('strAmbulatorioComplicacionFallaCardiacaAño').getValue(),
                pProgramasEspecialesComplicacionesEPOC : Ext.getCmp('strAmbulatorioComplicacionEPOC').getValue(),
                pProgramasEspecialesComplicacionesEPOCMes : Ext.getCmp('strAmbulatorioComplicacionEPOCMes').getValue(),
                pProgramasEspecialesComplicacionesEPOCAnio : Ext.getCmp('strAmbulatorioComplicacionEPOCAño').getValue(),
                pProgramasEspecialesComplicacionesArtritis : Ext.getCmp('strAmbulatorioComplicacionArtritis').getValue(),
                pProgramasEspecialesComplicacionesArtritisMes : Ext.getCmp('strAmbulatorioComplicacionArtritisMes').getValue(),
                pProgramasEspecialesComplicacionesArtritisAnio : Ext.getCmp('strAmbulatorioComplicacionArtritisAño').getValue(),
                pProgramasEspecialesRiesgoCardioVascular : Ext.getCmp('intRiesgoCardioVascular').getValue(),
                pProgramasEspecialesRiesgoCardioVascularClasificacion : Ext.getCmp('strClasificacionRiesgoCardioVascular').getValue(),
                pProgramasEspecialesMetodoPlanificacion : Ext.getCmp('strMetodoPlanifica').getValue(),
                pProgramasEspecialesViveSolo : Ext.getCmp('strViveSolo').getValue(),
                pProgramasEspecialesAcompanante : Ext.getCmp('strAcompanante').getValue(),
                pProgramasEspecialesParentescoAcompanante : Ext.getCmp('strParentescoAcompanante').getValue(),
                pProgramasEspecialesComplicacionesHospCardioVascular : Ext.getCmp('strHospitalariaComplicacionCardiovascular').getValue(),
                pProgramasEspecialesComplicacionesHospCardioVascularMes : Ext.getCmp('strHospitalariaComplicacionCardiovascularMes').getValue(),
                pProgramasEspecialesComplicacionesHospCardioVascularAnio : Ext.getCmp('strHospitalariaComplicacionCardiovascularAño').getValue(),
                pProgramasEspecialesComplicacionesHospCerebroVascular : Ext.getCmp('strHospitalariaComplicacionCerebrovascular').getValue(),
                pProgramasEspecialesComplicacionesHospCerebroVascularMes : Ext.getCmp('strHospitalariaComplicacionCerebrovascularMes').getValue(),
                pProgramasEspecialesComplicacionesHospCerebroVascularAnio : Ext.getCmp('strHospitalariaComplicacionCerebrovascularAño').getValue(),
                pProgramasEspecialesComplicacionesHospRetinopatia : Ext.getCmp('strHospitalariaComplicacionRetinopatia').getValue(),
                pProgramasEspecialesComplicacionesHospRetinopatiaMes : Ext.getCmp('strHospitalariaComplicacionRetinopatiaMes').getValue(),
                pProgramasEspecialesComplicacionesHospRetinopatiaAnio : Ext.getCmp('strHospitalariaComplicacionRetinopatiaAño').getValue(),
                pProgramasEspecialesComplicacionesHospERC : Ext.getCmp('strHospitalariaComplicacionEnfermedadRenalCronica').getValue(),
                pProgramasEspecialesComplicacionesHospERCMes : Ext.getCmp('strHospitalariaComplicacionEnfermedadRenalCronicaMes').getValue(),
                pProgramasEspecialesComplicacionesHospERCAnio : Ext.getCmp('strHospitalariaComplicacionEnfermedadRenalCronicaAño').getValue(),
                pProgramasEspecialesComplicacionesHospGastro : Ext.getCmp('strHospitalariaComplicacionGastroIntestinales').getValue(),
                pProgramasEspecialesComplicacionesHospGastroMes : Ext.getCmp('strHospitalariaComplicacionGastroIntestinalesMes').getValue(),
                pProgramasEspecialesComplicacionesHospGastroAnio : Ext.getCmp('strHospitalariaComplicacionGastroIntestinalesAño').getValue(),
                pProgramasEspecialesComplicacionesHospOtro : Ext.getCmp('strHospitalariaComplicacionOtroEvento').getValue(),
                pProgramasEspecialesComplicacionesHospOtroMes : Ext.getCmp('strHospitalariaComplicacionOtroEventoMes').getValue(),
                pProgramasEspecialesComplicacionesHospOtroAnio : Ext.getCmp('strHospitalariaComplicacionOtroEventoAño').getValue(),
                pProgramasEspecialesProgramaActual : Ext.getCmp('strProgramaCronicos').getValue(),
                pGuardarCronicos: "SI",
                pSolicitarCitologia: Ext.getCmp('sysSolicitaCitologia').getValue(),
                pSolicitarMamografia: Ext.getCmp('sysSolicitaMamografia').getValue(),
                pSolicitarBaciloscopia: Ext.getCmp('sysSolicitaBaciloscopia').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        if(parseInt(Ext.getCmp('sysYaOrdenamientosHC').getValue()) === 0){
                            //solicitarOrdenamientosProgramaCronicos();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}

function solicitarOrdenamientosProgramaCronicos(){
    var wTask = "";
    /*//if(parseInt(Ext.getCmp('sysYaOrdenamientosHC').getValue()) === 0){
        if(Ext.getCmp('strPROGESPEIngreso').getValue() === "SI"){
            wTask = "CRONICOS_PRIMERA_VEZ";
        }else{
            wTask = "CRONICOS_CONTROL";
        }
        Ext.Ajax.request({
            url: '../../controlador/asistencial/controlador_programas.php',
            params:{
                task: wTask,
                pTipo: "E",
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()   
            },
            success: function(response,options)
            {
                var el = Ext.get('response'); // get the LOG
                var Respuesta = response.responseText;
                var Contenido = Respuesta.split('^');
                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                    Ext.MessageBox.show({
                        title: 'OfiClinic',
                        msg: 'Error al cargar los registros de solicitud de paraclinicos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    Ext.getCmp('sysYaOrdenamientosHC').setValue(0);
                } else {
                    Ext.getCmp('gridExamenesHC').store.reload();
                    Ext.MessageBox.show({
                        title: 'OfiClinic',
                        msg: 'Se genero la solicitud de paraclinicos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                    Ext.getCmp('sysYaOrdenamientosHC').setValue(1);
                }
            },
            failure: function(response,options){
                Ext.MessageBox.show({
                    title: 'OfiClinic - Base Datos',
                    msg: 'Error al cargar los registros de solicitud de paraclinicos',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
                Ext.getCmp('sysYaOrdenamientosHC').setValue(0);
            },
            scope:this
        });
    //}
    */
}