/*
* @category    Formulario Modelo Historia Clinica Endodoncia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCOdontologia004Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Historia Clinica Endodoncia ::.',
    width: 1010,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCOdontologia004',
    initComponent: function() {
        
                   
        var fsAntecedentesPersonales = new fsAntecedentesPersonalesUi();
        var fsAntecedentesFamiliares = new fsAntecedentesFamiliaresUi();
        
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        Ext.util.Format.Currency = function(v){
            return FormatoMoneda(v);
        };
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX !== "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA !== "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM !== "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        function DescripcionNotasEvolucion(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr>';
            mostrarHC += '<tr><td>';
            switch(store.data.Ambito){
                case "1":
                    mostrarHC += 'Ambito: 1 - Ambulatorio';
                    break;
                case "2":
                    mostrarHC += 'Ambito: 2 - Hospitalario';
                    break;
                case "3":
                    mostrarHC += 'Ambito: 3 - Urgencias';
                    break;
                default:
                    break;
            }
            mostrarHC += '</td></tr>';
            mostrarHC += '<tr><td>';
            switch(store.data.Finalidad){
                case "1":
                    mostrarHC += 'Finalidad: 1 - Diagnostico';
                    break;
                case "2":
                    mostrarHC += 'Finalidad: 2 - Terapeutico';
                    break;
                case "3":
                    mostrarHC += 'Finalidad: 3 - Proteccion Especifica';
                    break;
                case "4":
                    mostrarHC += 'Finalidad: 4 - Deteccion Temprana de Enfermedad General';
                    break;
                case "5":
                    mostrarHC += 'Finalidad: 5 - Deteccion Temprana de Enfermedad Profesional';
                    break;
                default:
                    break;
            }
            mostrarHC += '</td></tr>';
            mostrarHC += '</table>';
            return mostrarHC;
        }
        
        
        var stGridDienteActividadesRealizadas = new StoreGridDienteActividadesRealizadas();
        stGridDienteActividadesRealizadas.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridDienteActividadesProxCita = new StoreGridDienteActividadesProxCita();
        stGridDienteActividadesProxCita.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridDienteActividadesProxCitaDetalle = new StoreGridDienteActividadesProxCitaDetalle();
        stGridDienteActividadesProxCitaDetalle.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridOdontogramasxPaciente = new StoreGridOdontogramasxPaciente();
        stGridOdontogramasxPaciente.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        
        function VerInfoOdontograma(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('Profesional') + '</br>Tipo Odontograma:' + record.get('TipoOdontograma') + '</br>Tipo Denticion:' + record.get('TipoDenticion');
        }
        
        function VerInfoProxCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return 'CAS: ' + record.get('CAS') + '</br>' + record.get('Profesional') + '</br>Fecha:' + record.get('FechaAtencion');
        }
                
        var OdontogramaInical = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/frm/odontograma/odontograma002.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS,
                scripts:true,
                scope:this
            },
            id:'OdontogramaInical',
            height: 480,
            autoScroll:true,
            closable:false
        });
        
        //Store Locales
        var dataTipoDenticion = [
            ['TEMPORAL'],
            ['PERMANENTE'],
            ['MIXTA']
        ];
        var stTipoDenticion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoDenticion.loadData(dataTipoDenticion);
        
        var dataHigiene = [
            ['BUENO'],
            ['REGULAR'],
            ['MALO']
        ];
        var stHigiene = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stHigiene.loadData(dataHigiene);
        
        var dataRiesgo = [
            ['ALTO'],
            ['MEDIO'],
            ['BAJO']
        ];
        var stRiesgo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRiesgo.loadData(dataRiesgo);  
        
        
        var dataTipoPaciente = [
            ['PACIENTE INICIO TRATAMIENTO'],
            ['PACIENTE INICIO TRATAMIENTO Y CONTROLADO']
        ];
        var stTipoPaciente = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoPaciente.loadData(dataTipoPaciente);        
        
        var dataSintomatologiaIntensidad = [
            ['LEVE'],
            ['MODERADO'],
            ['SEVERO']
        ];
        var stSintomatologiaIntensidad = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaIntensidad.loadData(dataSintomatologiaIntensidad);
                
        var dataSintomatologiaDuracion = [
            ['CORTO'],
            ['MEDIANO'],
            ['LARGO']
        ];
        var stSintomatologiaDuracion = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaDuracion.loadData(dataSintomatologiaDuracion);
        
        var dataSintomatologiaLocalizacion = [
            ['LOCALIZADO'],
            ['IRRADIADO']
        ];
        var stSintomatologiaLocalizacion = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaLocalizacion.loadData(dataSintomatologiaLocalizacion);
        
        var dataSintomatologiaEstimulo = [
            ['PROVOCADO'],
            ['ESPONTANEO']
        ];
        var stSintomatologiaEstimulo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaEstimulo.loadData(dataSintomatologiaEstimulo);
        
        var dataSintomatologiaTipoEstimulo = [
            ['CALOR (+ / -)'],
            ['FRIO (+ / -)']
        ];
        var stSintomatologiaTipoEstimulo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaTipoEstimulo.loadData(dataSintomatologiaTipoEstimulo);
        
        var dataSintomatologiaPositivoNegativo = [
            ['POSITIVO'],
            ['NEGATIVO']
        ];
        var stSintomatologiaPositivoNegativo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaPositivoNegativo.loadData(dataSintomatologiaPositivoNegativo);
        
        var ConvencionesOdontograma = new winConvencionesOdontogramaUi();
        var ViewOdontogramas = new winViewOdontogramasUi();
        
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                width: 1000,
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'panel',
                        title: 'Datos Basicos',
                        autoHeight: true,
                        autoScroll: true,
                        width: 921,
                        frame: true,
                        border: false,
                        id: 'fichaIdentifica',
                        layout: 'form',
                        items:[
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysIdCodPlantillaHC'
                            },
                             {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                value: 1,
                                id: 'sysUsaGridSalida'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                value: 0,
                                id: 'sysYaGuardoHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysPlantillaHC',
                                name: 'PLANTILLA'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptMx'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptExa'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptRem'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Actividad',
                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                id: 'sysActividadHC',
                                name: 'PLANTILLA'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Empresa',
                                id: 'sysEmpresaHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'IPS',
                                id: 'sysIPSHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuarioHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Profesional',
                                id: 'sysProfesionalHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Paciente',
                                id: 'sysIdPacienteHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Apertura',
                                id: 'sysAperturaHC'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Cliente',
                                id: 'sysClienteHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdClienteHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdPlanHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdSubPlanHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdContratoHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Edad',
                                id: 'sysEdadPacHC'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Profesional',
                                id: 'sysProfesionalAgendaHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoDetalle',
                                id: 'sysConsecutivoDetalleHC'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'CAS',
                                        id: 'sysCASHC'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysFechaHC',
                                        value: 'Fecha: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysFechaHC'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysHoraHC',
                                        value: 'Hora: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysHoraHC'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysLegalizacionHC',
                                        value: 'Legalización: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysLegalizaHC'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Paciente',
                                value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                id: 'sysPacienteHC'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroHC'
                                    },
                                    {
                                        html: 'Fecha Nac:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysFechaNac'
                                    },
                                    {
                                        html: 'Edad:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 350,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEdadHC'
                                    }
                                ]
                            },
                            {
                                html: '<hr>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Tipo Afiliado',
                                        id: 'sysTipoAfiliadoHC'
                                    },
                                    {
                                        html: 'Rango:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 30,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRangoAfiliadoHC'
                                    },
                                    {
                                        html: 'Cuota Moderadora:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'sysCMAfiliadoHC',
                                        readOnly: true
                                    },
                                    {
                                        html: '% Copagos:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "%",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 3,
                                        allowBlank: false,
                                        id: 'sysPorCopagoAfiliadoHC',
                                        readOnly: true
                                    }
                                ]
                            },
                            {
                                html: '<hr>',
                                style: 'background:transparent;',
                                border: false
                            }
                        ]
                    },
                    {
                        xtype: 'tabpanel',
                        width: 970,
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolucion',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO CONSULTA',
                                                        name: 'MOTIVO CONSULTA',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            fsAntecedentesPersonales,
                                            fsAntecedentesFamiliares,
                                            {
                                                xtype: 'combo',
                                                name: 'Tipo Paciente',
                                                fieldLabel: 'Tipo Paciente',
                                                width: 300,
                                                allowBlank: false,
                                                store: stTipoPaciente,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "PACIENTE EN CONTROL",
                                                id: 'strTipoPaciente'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '99%',
                                                fieldLabel: 'DIENTE Y/O ZONA',
                                                name: 'DIENTE Y/O ZONA',
                                                allowBlank: false,
                                                id: 'strDienteZona'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '1. Descripción de Historia de dolor y/o Trauma : ¿Qué?¿Cómo?¿Cuándo?¿Dónde?¿Por qué?',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'DESCRIPCION DE HIISTORIA DE DOLOR',
                                                        name: 'DESCRIPCION DE HIISTORIA DE DOLOR',
                                                        grow: true,
                                                        allowBlank: false,
                                                        id: 'memHistoriaDolor'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '2. Sintomatología actual',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Intensidad',
                                                                name: 'Intensidad',
                                                                allowBlank: false,
                                                                store: stSintomatologiaIntensidad,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Intensidad'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_IntensidadH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Duración',
                                                                name: 'Duración',
                                                                allowBlank: false,
                                                                store: stSintomatologiaDuracion,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Duracion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_DuracionH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Localización',
                                                                name: 'Localización',
                                                                allowBlank: false,
                                                                store: stSintomatologiaLocalizacion,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Localizacion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_LocalizacionH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Categoría del Estimulo',
                                                                name: 'Categoría del Estimulo',
                                                                allowBlank: false,
                                                                store: stSintomatologiaEstimulo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_CategoriaEstimulo'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_CategoriaEstimuloH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Tipo de Estímulo',
                                                                name: 'Tipo de Estimulo',
                                                                allowBlank: false,
                                                                store: stSintomatologiaTipoEstimulo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_TipoEstimulo'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_TipoEstimuloH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Percusión',
                                                                name: 'Percusión',
                                                                allowBlank: false,
                                                                store: stSintomatologiaPositivoNegativo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Percusion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_PercusionH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Palpación',
                                                                name: 'Palpación',
                                                                allowBlank: false,
                                                                store: stSintomatologiaPositivoNegativo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Palpacion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_PalpacionH'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '3. Examen Clínico del Diente',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '1. Caries',
                                                                        name: '1. Caries',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_Caries',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 1. Caries",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_CariesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '2. Pérdida del tejido dental',
                                                                        name: '2. Pérdida del tejido dental',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_PerdidaTejido',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 2. Pérdida del tejido dental",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_PerdidaTejidoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '3. Cambio de Color',
                                                                        name: '3. Cambio de Color',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_CambioColor',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_CambioColorH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '4. Edema Intraoral',
                                                                        name: '4. Edema Intraoral',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_EdemaIntraoral',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_EdemaIntraoralH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '5. Edema Extraoral',
                                                                        name: '5. Edema Extraoral',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_EdemaExtraoral',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_EdemaExtaoralH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '6. Tracto Sinusal (fístula)',
                                                                        name: '6. Tracto Sinusal (fístula)',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_TractoSinusal',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_TractoSinusalH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '7. Compromiso Endo-Periodontal',
                                                                        name: '7. Compromiso Endo-Periodontal',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_CompromisoEndoPeriodontal',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_CompromisoEndoPeriodontalH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '8. Sondaje (presencia de bolsa)',
                                                                        name: '8. Sondaje (presencia de bolsa)',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_Sondaje',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_SondajeH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '9. Movilidad',
                                                                        name: '9. Movilidad',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_Movilidad',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_MovilidadH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '4. Evaluación Radiográfica',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'EVALUACION RADIOGRAFICA',
                                                        name: 'EVALUACION RADIOGRAFICA',
                                                        grow: true,
                                                        allowBlank: false,
                                                        id: 'memEvaluacionRadiografica'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() === null || Ext.getCmp('fecDesdeIncapacidad').getValue() === ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'));
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y');
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y');
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (Ext.getCmp('sysYaGuardoHC').getValue() === 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue() === null || Ext.getCmp('sysDiagPpalHCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() !== "" && Ext.getCmp('sysDiagPpalHC').getValue() !== null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue === null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() !== "" && Ext.getCmp('sysDiagRel1HC').getValue() !== null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue === null || Ext.getCmp('sysDiagRel2HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() !== "" && Ext.getCmp('sysDiagRel2HC').getValue() !== null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue === null || Ext.getCmp('sysDiagRel3HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() !== "" && Ext.getCmp('sysDiagRel3HC').getValue() !== null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Carta Dental Inicial (LEY 38/93)',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaCartaDentalInicial',
                                tbar:{
                                    items: [
                                        {
                                            html: 'Tipo Denticion:'
                                        },
                                        {
                                            xtype: 'combo',
                                            width: 110,
                                            allowBlank: true,
                                            store: stTipoDenticion,
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'sysBtnTipoDenticion'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Crear Odontograma',
                                            iconCls: 'btnDiente',
                                            id: 'btnCrearOdontograma',
                                            listeners:{
                                                click : function(){
                                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0){
                                                        Ext.Msg.show({
                                                            title: 'eOfiClinic',
                                                            msg: 'Debe guardar la evolucion antes de gererar el odontograma',
                                                            buttons: Ext.Msg.OK,
                                                            icon: Ext.Msg.ERROR
                                                        });
                                                    }else{
                                                        if(Ext.getCmp('sysBtnTipoDenticion').getValue() === "" || Ext.getCmp('sysBtnTipoDenticion').getValue() === null){
                                                            Ext.Msg.show({
                                                                title: 'eOfiClinic',
                                                                msg: 'Debe seleccionar el tipo de denticion',
                                                                buttons: Ext.Msg.OK,
                                                                icon: Ext.Msg.ERROR
                                                            });
                                                        }else{
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/odontograma/controlador_odontograma.php',
                                                                params:{
                                                                    task: 'OBTENER_ULTIMO_ODONTOGRAMA',
                                                                    pPaciente: wPaciente
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                        Ext.MessageBox.show({
                                                                            title: 'eOfiClinic',
                                                                            msg: 'Ocurrio un error al validar el odontograma del paciente.',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    } else {
                                                                        var idOdontograma = parseInt(Contenido[0]);
                                                                        var tipoOdontograma = "Inicial";
                                                                        if(idOdontograma !== 0){
                                                                            tipoOdontograma = "Control";
                                                                        }
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/odontograma/controlador_odontograma.php',
                                                                            params:{
                                                                                task: 'CREAR_ODONTOGRAMA',
                                                                                pPaciente: wPaciente,
                                                                                pIdOdontograma: idOdontograma,
                                                                                pTipoOdontograma: tipoOdontograma,
                                                                                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                                                                                pProfesional:  Ext.getCmp('sysProfesionalHC').getValue(),
                                                                                pCAS: wCAS,
                                                                                pCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                                                                                pTipoDenticion: Ext.getCmp('sysBtnTipoDenticion').getValue(),
                                                                                pUsuario: ID_USUARIO
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'eOfiClinic',
                                                                                        msg: 'Ocurrio un error al crear el odontograma del paciente.',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                } else {
                                                                                    Ext.getCmp('gridOdontogramasxPaciente').store.reload();
                                                                                    var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                                                    updater.setDefaultUrl('../../../app/frm/odontograma/odontograma002.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS + '&pOdontograma=0');
                                                                                    updater.refresh();
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                Ext.MessageBox.show({
                                                                                    title: 'eOfiClinic',
                                                                                    msg: 'No podemos crear el odontograma y/o No se pudo establecer conexión con el servidor',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                            },
                                                                            scope:this 
                                                                        });
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error Conexión',
                                                                        msg: 'No podemos crear el odontograma y/o No se pudo establecer conexión con el servidor',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                },
                                                                scope:this 
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Ver Convenciones Odontograma',
                                            iconCls: 'btnDiente',
                                            listeners:{
                                                click : function(){
                                                    Ext.getCmp('winConvencionesOdontograma').show();
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                items: [
                                    {
                                        xtype: 'panel',
                                        border: false, 
                                        autoHeight: true,
                                        layout: {
                                            columns: 2,
                                            type: 'table'
                                        },
                                        items:[
                                            {
                                                xtype: 'panel',
                                                //title: 'Odontogramas',
                                                //autoHeight: true,
                                                autoScroll: true,
                                                width: 250,
                                                height: 470,
                                                frame: true,
                                                border: false,
                                                tbar:{
                                                    items: [
                                                        {
                                                            xtype: 'button',
                                                            text: 'Editar',
                                                            iconCls: 'btnEditRow',
                                                            id: 'btnEditOdontograma',
                                                            listeners:{
                                                                click : function(){
                                                                    if(Ext.getCmp('gridOdontogramasxPaciente').selModel.getCount() === 1){
                                                                        var selections = Ext.getCmp('gridOdontogramasxPaciente').selModel.getSelections();
                                                                        if(selections[0].json.CAS === wCAS){
                                                                            var oGridOdontograma = new GridEditOdontogramaUi();
                                                                            Ext.getCmp('gridEditOdontogramaHC').title = "CAS: " + selections[0].json.CAS + " Fecha: " + selections[0].json.FecReporte + " -Denticion: " + selections[0].json.TipoDenticion;
                                                                            Ext.getCmp('sysIdOdontogramaItemOdontograma').setValue(selections[0].json.IdConsecutivoOdontograma);
                                                                            Ext.getCmp('sysTipoDenticionItemOdontograma').setValue(selections[0].json.TipoDenticion);
                                                                            Ext.getCmp('gridEditOdontogramaHC').store.load({
                                                                                params: {
                                                                                    task: 'LOAD_DETALLEODONTOGRAMA',
                                                                                    pOdontograma: Ext.getCmp('sysIdOdontogramaItemOdontograma').getValue()
                                                                                }
                                                                            });
                                                                            oGridOdontograma.show();
                                                                        }else{
                                                                            Ext.MessageBox.show({
                                                                            title: 'Odontograma',
                                                                            msg: 'Este Odontograma no se puede editar en estos momentos, porque pertenece a otra atencion ya realizada',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                        }
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'Debe seleccionar un registro',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        }
                                                    ]
                                                },
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        layout: 'fit',
                                                        id: 'gridOdontogramasxPaciente',
                                                        store: stGridOdontogramasxPaciente,
                                                        anchor: "100%",
                                                        height: 390,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Id',
                                                                sortable: false,
                                                                width: 100,
                                                                hidden: true,
                                                                hideable: false,
                                                                dataIndex: 'CAS',
                                                                id: 'CAS'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Fecha',
                                                                sortable: true,
                                                                width: 205,
                                                                dataIndex: 'FecReporte',
                                                                renderer: VerInfoOdontograma,
                                                                id: 'FecReporte'
                                                            }
                                                        ]),
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        listeners:{
                                                            rowclick : function(grid, fila, e){
                                                                var selections = grid.selModel.getSelections();
                                                                var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                                updater.setDefaultUrl('../../../app/frm/odontograma/odontograma002.php?pPaciente=' + wPaciente + '&pCAS=' + selections[0].json.CAS + '&pOdontograma=' + selections[0].json.IdConsecutivoOdontograma);
                                                                updater.refresh();
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 700,
                                                height: 470,
                                                items: [
                                                    OdontogramaInical
                                                ]
                                            }
                                        ]
                                    }//,
                                    /*{
                                        xtype: 'panel',
                                        layout: 'form',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP',
                                                        fieldLabel: 'COP',
                                                        id: 'intCOPOdontograma'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCOPM',
                                                        value: 'COP Modificado: '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP Modificado',
                                                        id: 'intCOPOdontogramaModificado'
                                                    }
                                                ]
                                            }
                                        ]
                                    }*/
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Actividades Realizadas',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaActividades',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        id: 'IdOdontogramaUltimo'
                                    },
                                    {
                                        xtype: 'grid',
                                        layout: 'fit',
                                        id: 'gridDientesActividadesRealizadas',
                                        store: stGridDienteActividadesRealizadas,
                                        anchor: "100%",
                                        height: 470,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoDientesActividad',
                                                id: 'IdConsecutivoDientesActividad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha',
                                                sortable: true,
                                                width: 110,
                                                dataIndex: 'FechaAtencion',
                                                id: 'FechaAtencion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Profesional',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'Profesional',
                                                id: 'Profesional'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Diente',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Diente',
                                                id: 'Diente'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Superficie',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Superficie',
                                                id: 'Superficie'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Procedimiento/Actividad',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'DesProced',
                                                renderer: DescripcionGrid,
                                                id: 'DesProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Notas Evolución',
                                                sortable: false,
                                                width: 270,
                                                dataIndex: 'NotasEvolucion',
                                                renderer: DescripcionNotasEvolucion,
                                                id: 'NotasEvolucion'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                        {
                                            xtype: 'toolbar',
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Adicionar Registro',
                                                    iconCls: 'btnAddRow',
                                                    id: 'btnAddActividadDiente',
                                                    listeners: {
                                                        click : function() {
                                                            if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                                                var winAddDienteActividadRealizada = new winAddDienteActividadRealizadaUi();
                                                                Ext.getCmp('intPacienteDienteActividad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                Ext.getCmp('intCASDienteActividad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                Ext.getCmp('intNroDienteDienteActividad').store.load({
                                                                    params: {
                                                                        pTipo: "MIXTA"
                                                                    }
                                                                });
                                                                //Ext.getCmp('intProfesionalDienteActividad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                Ext.getCmp('intIdProcedDienteActividad').store.load({
                                                                    params: {
                                                                        pServicio: "%ODONTOLO%",
                                                                        pCAS: myCAS
                                                                    }
                                                                });
                                                                winAddDienteActividadRealizada.show();
                                                            }else{
                                                                Ext.Msg.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'Usted No ha Guardado la Historia',
                                                                    buttons: Ext.Msg.OK,
                                                                    icon: Ext.Msg.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Eliminar Registro',
                                                    iconCls: 'btnDelRow',
                                                    id: 'btnDelActividadDiente',
                                                    listeners: {
                                                        click : function() {
                                                            if(parseInt(Ext.getCmp('gridDientesActividadesRealizadas').selModel.getCount()) === 1){
                                                                var selections = Ext.getCmp('gridDientesActividadesRealizadas').selModel.getSelections();
                                                                if(selections[0].json.CAS === Ext.getCmp('sysCASHC').getValue()){
                                                                    Ext.Msg.show({
                                                                        title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                                        msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                                        buttons: Ext.Msg.YESNO,
                                                                        icon: Ext.Msg.QUESTION,
                                                                        fn: function(btn)
                                                                        {
                                                                            if(btn === "yes")
                                                                            {
                                                                                fnEliminarRegistrosEndo("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_ACTIVIDAD", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesRealizadas');
                                                                            }
                                                                        }
                                                                    });
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Odontograma',
                                                    iconCls: 'btnDiente',
                                                    listeners:{
                                                        click : function(){
                                                            /*var RecordOdontogramaIni = Ext.getCmp('gridOdontogramasxPaciente').store.getAt(0); 
                                                            Ext.getCmp('IdOdontogramaUltimo').setValue(RecordOdontogramaIni.get('IdConsecutivoOdontograma'));
                                                            Ext.getCmp('IdOdontogramaViewOdontogramas').setValue(RecordOdontogramaIni.get('IdConsecutivoOdontograma'));
                                                            Ext.getCmp('winViewOdontogramas').show();*/
                                                            window.open ("../../controlador/asistencial/imprimirodontograma.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pEvolucion=0" + "&pConsecutivoDetalle=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Odontograma");
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Ver Convenciones',
                                                    iconCls: 'btnDiente',
                                                    listeners:{
                                                        click : function(){
                                                            Ext.getCmp('winConvencionesOdontograma').show();
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Actividades Proxima Cita',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                layout: 'form',
                                id: 'fichaActividadesProximaCita',
                                items: [
                                    {
                                        xtype: 'panel',
                                        border: false, 
                                        autoHeight: true,
                                        layout: {
                                            columns: 2,
                                            type: 'table'
                                        },
                                        items:[
                                            {
                                                xtype: 'panel',
                                                title: 'Atenciones',
                                                //autoHeight: true,
                                                autoScroll: true,
                                                width: 250,
                                                height: 420,
                                                frame: true,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        layout: 'fit',
                                                        id: 'gridAtencionesProximaCitaxPaciente',
                                                        store: stGridDienteActividadesProxCita,
                                                        anchor: "100%",
                                                        height: 375,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Id',
                                                                sortable: false,
                                                                width: 100,
                                                                hidden: true,
                                                                hideable: false,
                                                                dataIndex: 'CAS',
                                                                id: 'CASProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Fecha',
                                                                sortable: true,
                                                                width: 205,
                                                                dataIndex: 'FecReporte',
                                                                renderer: VerInfoProxCita,
                                                                id: 'FecReporteProxCita'
                                                            }
                                                        ]),
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        listeners:{
                                                            rowclick : function(grid, fila, e){
                                                                var selections = grid.selModel.getSelections();
                                                                stGridDienteActividadesProxCitaDetalle.load({
                                                                    params: {
                                                                        pPaciente: wPaciente,
                                                                        pCAS: selections[0].json.CAS
                                                                    },
                                                                    callback: function(){
                                                                        var SubtotalProxCita = 0;
                                                                        var CopagosProxCita = 0;
                                                                        Ext.getCmp('gridDientesActividadesProximaCitaDetalle').store.each(function(record){
                                                                            SubtotalProxCita = SubtotalProxCita + (parseInt(record.get('Cantidad')) * parseInt(record.get('VlrActividad')));
                                                                            CopagosProxCita = CopagosProxCita + parseInt(record.get('VlrCopago'));
                                                                        });
                                                                        Ext.getCmp('sysSubTotProxCita').setValue(SubtotalProxCita);
                                                                        Ext.getCmp('sysCOPProxCita').setValue(CopagosProxCita);
                                                                    }
                                                                });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 700,
                                                height: 420,
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        layout: 'fit',
                                                        id: 'gridDientesActividadesProximaCitaDetalle',
                                                        store: stGridDienteActividadesProxCitaDetalle,
                                                        anchor: "100%",
                                                        height: 415,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Id',
                                                                sortable: false,
                                                                width: 1,
                                                                hidden: true,
                                                                hideable: false,
                                                                dataIndex: 'IdConsecutivoDientesProxCita',
                                                                id: 'IdConsecutivoDientesProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Diente',
                                                                sortable: true,
                                                                width: 60,
                                                                dataIndex: 'Diente',
                                                                id: 'DienteProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Superficie',
                                                                sortable: true,
                                                                width: 70,
                                                                dataIndex: 'Superficie',
                                                                id: 'SuperficieProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Procedimiento/Actividad',
                                                                sortable: true,
                                                                width: 350,
                                                                dataIndex: 'DesProced',
                                                                renderer: DescripcionGrid,
                                                                id: 'DesProcedProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Copago',
                                                                sortable: false,
                                                                width: 120,
                                                                renderer:  Ext.util.Format.Currency,
                                                                dataIndex: 'VlrCopago',
                                                                id: 'VlrCopagoProxCita'
                                                            }
                                                        ]),
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                                        iconCls:'icon-grid',
                                                        //view: new Ext.grid.GroupingView(),
                                                        tbar:
                                                        {
                                                            xtype: 'toolbar',
                                                            items: [
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Adicionar Registro',
                                                                    iconCls: 'btnAddRow',
                                                                    id: 'btnAddProxCitaDiente',
                                                                    listeners: {
                                                                        click : function() {
                                                                            if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                                                                var winAddDienteActividadProxCita = new winAddDienteActividadProxCitaUi();
                                                                                Ext.getCmp('intPacienteDienteProxCita').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                                Ext.getCmp('intCASDienteProxCita').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                                Ext.getCmp('sysTipoAfiliadoDienteProxCita').setValue(Ext.getCmp('sysTipoAfiliadoHC').getValue());
                                                                                Ext.getCmp('sysPorCopagoDienteProxCita').setValue(Ext.getCmp('sysPorCopagoAfiliadoHC').getValue());
                                                                                
                                                                                Ext.getCmp('intNroDienteDienteProxCita').store.load({
                                                                                    params: {
                                                                                        pTipo: "MIXTA"
                                                                                    }
                                                                                });
                                                                                Ext.getCmp('intIdProcedDienteProxCita').store.load({
                                                                                    params: {
                                                                                        pServicio: "%ODONTOLO%",
                                                                                        pCAS: myCAS
                                                                                    }
                                                                                });
                                                                                winAddDienteActividadProxCita.show();
                                                                            }else{
                                                                                Ext.Msg.show({
                                                                                    title: 'eOfiClinic',
                                                                                    msg: 'Usted No ha Guardado la Historia',
                                                                                    buttons: Ext.Msg.OK,
                                                                                    icon: Ext.Msg.ERROR
                                                                                });
                                                                            }
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Eliminar Registro',
                                                                    iconCls: 'btnDelRow',
                                                                    id: 'btnDelProxCitaDiente',
                                                                    listeners: {
                                                                        click : function() {
                                                                            if(parseInt(Ext.getCmp('gridDientesActividadesProximaCitaDetalle').selModel.getCount()) === 1){
                                                                                var selections = Ext.getCmp('gridDientesActividadesProximaCitaDetalle').selModel.getSelections();
                                                                                if(selections[0].json.CAS === Ext.getCmp('sysCASHC').getValue()){
                                                                                    Ext.Msg.show({
                                                                                        title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                                                        msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                                                        buttons: Ext.Msg.YESNO,
                                                                                        icon: Ext.Msg.QUESTION,
                                                                                        fn: function(btn){
                                                                                            if(btn === "yes"){
                                                                                                fnEliminarRegistrosEndo("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_PROXIMACITA", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesProximaCitaDetalle');
                                                                                            }
                                                                                        }
                                                                                    });
                                                                                }else{
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'Error',
                                                                                        msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                }
                                                                            }else{
                                                                                Ext.MessageBox.show({
                                                                                    title: 'Error',
                                                                                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                            }
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                }
                                                            ]
                                                        }
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        frame: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SubTotal:'
                                            },
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                style: 'background-color:#69F; font-size: 13px; font-weight: bold; text-align:right;',
                                                allowBlank: true,
                                                readOnly: true,
                                                width: 150,
                                                value: 0,
                                                id: 'sysSubTotProxCita'
                                            },
                                            {
                                                html: ' &nbsp;&nbsp;&nbsp;&nbsp;Copagos a Pagar:'
                                            },
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                style: 'background-color:#69F; font-size: 13px; font-weight: bold; text-align:right;',
                                                allowBlank: true,
                                                readOnly: true,
                                                width: 150,
                                                value: 0,
                                                id: 'sysCOPProxCita'
                                            }
                                        ]
                                    } //Valorizacion
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() === 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCOdontologia004').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCOdontologia004').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    fnGuardarRegistrosEndodoncia();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnModificarRegistrosEndodoncia();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Ajax.request({
                        url: '../../controlador/estudios/controlador_estudios.php',
                        params:{
                            task: 'BUSCAR_PARAMETROS_COBRO',
                            pCAS: myCAS
                        },
                        success: function(response,options)
                        {
                            var el = Ext.get('response'); // get the LOG
                            var Respuesta = response.responseText;
                            var Contenido = Respuesta.split('^');
                            if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                Ext.getCmp('sysTipoAfiliadoHC').setValue(null);
                                Ext.getCmp('sysRangoAfiliadoHC').setValue(null);
                                Ext.getCmp('sysCMAfiliadoHC').setValue(0);
                                Ext.getCmp('sysPorCopagoAfiliadoHC').setValue(0);
                                Ext.getCmp('sysFacturarPacienteHC').setValue(0);
                                Ext.getCmp('sysFacturarParticularHC').setValue(0);
                                Ext.getCmp('sysRecaudoAutomaticoParticularesHC').setValue(0);
                                Ext.getCmp('sysFacturarCopagosHC').setValue(0);
                                Ext.getCmp('sysMaxCopagoHC').setValue(0);
                            } else {
                                switch(Contenido[0]){
                                    case "B":
                                        Ext.getCmp('sysTipoAfiliadoHC').setValue("BENEFICIARIO");
                                        break;
                                    case "C":
                                        Ext.getCmp('sysTipoAfiliadoHC').setValue("COTIZANTE");
                                        break;
                                    default:
                                        switch(Contenido[9]){
                                            case "B":
                                                Ext.getCmp('sysTipoAfiliadoHC').setValue("BENEFICIARIO");
                                                break;
                                            case "C":
                                                Ext.getCmp('sysTipoAfiliadoHC').setValue("COTIZANTE");
                                                break;
                                            default:
                                                Ext.getCmp('sysTipoAfiliadoHC').setValue("");
                                                break;
                                        }
                                        break;
                                }
                                Ext.getCmp('sysRangoAfiliadoHC').setValue(Contenido[1]);
                                Ext.getCmp('sysCMAfiliadoHC').setValue(Contenido[7]);
                                Ext.getCmp('sysPorCopagoAfiliadoHC').setValue(Contenido[2]);
                                Ext.getCmp('sysFacturarPacienteHC').setValue(Contenido[3]);
                                Ext.getCmp('sysFacturarParticularHC').setValue(Contenido[4]);
                                Ext.getCmp('sysRecaudoAutomaticoParticularesHC').setValue(Contenido[5]);
                                Ext.getCmp('sysFacturarCopagosHC').setValue(Contenido[6]);
                                Ext.getCmp('sysMaxCopagoHC').setValue(Contenido[8]);
                            }
                        },
                        failure: function(response,options){
                            var el = Ext.get('response');
                            Ext.getCmp('sysTipoAfiliadoHC').setValue(null);
                            Ext.getCmp('sysRangoAfiliadoHC').setValue(null);
                            Ext.getCmp('sysCMAfiliadoHC').setValue(0);
                            Ext.getCmp('sysPorCopagoAfiliadoHC').setValue(0);
                            Ext.getCmp('sysFacturarPacienteHC').setValue(0);
                            Ext.getCmp('sysFacturarParticularHC').setValue(0);
                            Ext.getCmp('sysRecaudoAutomaticoParticularesHC').setValue(0);
                            Ext.getCmp('sysFacturarCopagosHC').setValue(0);
                            Ext.getCmp('sysMaxCopagoHC').setValue(0);
                        },
                        scope:this 
                    });
                    Ext.Msg.hide();
                    if(paramOpcion === "Nuevo"){ 
                        var frm = Ext.getCmp('frmHC').getForm();
                        frm.doAction('load', {
                            url: '../../controlador/asistencial/evolucionhc2014.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesPersonalesOfiClinic002'
                            },
                            success:function(form, action) {
                                var frm = Ext.getCmp('frmHC').getForm();
                                frm.doAction('load', {
                                    url: '../../controlador/asistencial/evolucionhc2014.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarFactoresRiesgo4505'
                                    },
                                    success:function(form, action) {
                                        var frm = Ext.getCmp('frmHC').getForm();
                                        frm.doAction('load', {
                                            url: '../../controlador/asistencial/evolucionhc2013.php',
                                            waitMsg: 'Cargando Información...',
                                            params:{
                                                pCAS: myCAS,
                                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                                task: 'ImportarVariablesAntropometricas'
                                            },
                                            success:function(form, action) {
                                                //
                                            }
                                        });
                                    }
                                });
                            }
                        });
                        //Predefinir Comportamiento Campos
                        if(Ext.getCmp('sysFechaHC').getValue() !== null || Ext.getCmp('sysFechaHC').getValue() !== 0){
                           calculoEdadPacienteMeses();
                        }
                        //EVALUA ANTECEDENTES GINOECO-OBSTETrICOS
                        if(Ext.getCmp('sysGeneroHC').getValue() === "MASCULINO" || MesesCumplidos <= 96 || MesesCumplidos >= 661){
                            Ext.getCmp('fsANTGINECO').setVisible(false);
                        }else{
                            Ext.getCmp('fsANTGINECO').setVisible(true);
                        }
                        
                        //HC MEDICINA INTERNA CAMPOS NO OBLIGATORIOS

                        Ext.getCmp('memANTPERSOPatologicos').allowBlank = true;
                        Ext.getCmp('memANTPERSOFarmacologicos').allowBlank = true;
                        Ext.getCmp('memANTPERSOQuirurgicos').allowBlank = true;
                        Ext.getCmp('memANTPERSOTraumatologicos').allowBlank = true;
                        Ext.getCmp('memANTPERSOToxicologicos').allowBlank = true;
                        Ext.getCmp('memANTPERSOAlergicos').allowBlank = true;
                        Ext.getCmp('intANTGINECOG').allowBlank = true;
                        Ext.getCmp('intANTGINECOP').allowBlank = true;
                        Ext.getCmp('intANTGINECOPV').allowBlank = true;
                        Ext.getCmp('intANTGINECOPC').allowBlank = true;
                        Ext.getCmp('intANTGINECOA').allowBlank = true;
                        Ext.getCmp('intANTGINECOVivos').allowBlank = true;
                        Ext.getCmp('intANTGINECOMuertos').allowBlank = true;
                        Ext.getCmp('strANTGINECOLactanciaHoy').allowBlank = true;
                        Ext.getCmp('strANTGINECOLactanciaPasado').allowBlank = true;
                        Ext.getCmp('strANTGONECOTiempoLactancia').allowBlank = true;
                        Ext.getCmp('strANTGINECOFum_1').allowBlank = true;
                        Ext.getCmp('strANTGINECOMenarquia').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFum').allowBlank = true;
                        Ext.getCmp('strANTGINECOFum_1').allowBlank = true;
                        Ext.getCmp('strANTGINECOMenarquia').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFum').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFup').allowBlank = true;
                        Ext.getCmp('strANTGINECOFuc').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFuc').allowBlank = true;
                        Ext.getCmp('strANTGINECOFucRes').allowBlank = true;
                        Ext.getCmp('strANTGINECOMetodoPlanifica').allowBlank = true;
                        Ext.getCmp('strANTGINECOCiclosMestruales').allowBlank = true;
                        Ext.getCmp('strANTGINECOActividadSexual').allowBlank = true;
                        Ext.getCmp('strANTGINECOPatologiaEmbarazo').allowBlank = true;
                        Ext.getCmp('strANTGINECOMenopausia').allowBlank = true;
                        Ext.getCmp('memAntecedentesFamiliares').allowBlank = true;

                        //IDENTIFICACION DEL RIESGO FILTROS
                        if(Ext.getCmp('sysGeneroHC').getValue()==="FEMENINO" && MesesCumplidos >= 121){
                            Ext.getCmp('intIdentificacionRiesgoGestacion').setValue(2);
                            Ext.getCmp('intIdentificacionRiesgoGestacion').enable();
                        }else{
                            Ext.getCmp('intIdentificacionRiesgoGestacion').setValue(0);
                            Ext.getCmp('intIdentificacionRiesgoGestacion').disable();
                            Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').setValue(0);
                            Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').disable();
                        }
                        if(Ext.getCmp('sysGeneroHC').getValue()==="FEMENINO" || MesesCumplidos <= 216){
                            Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').setValue(3);
                            Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').enable();
                        }else{
                            Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').setValue(0);
                            Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').disable();
                        }
                        if(MesesCumplidos <= 36){
                            Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').setValue(2);
                            Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').enable();
                        }else{
                            Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').setValue(0);
                            Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').disable();
                        }

                        //FUM MAYOR A 14 ANOS
                        if(Ext.getCmp('sysGeneroHC').getValue() === "FEMENINO" && MesesCumplidos >= 120 && MesesCumplidos <= 599){
                            Ext.getCmp('strANTGINECOFum_1').setValue (""); 
                            //Ext.getCmp('strANTGINECOFum_1').allowBlank = false;
                            //Ext.getCmp('fecANTGINECOFum').allowBlank = false;
                        }else{
                            Ext.getCmp('strANTGINECOFum_1').setValue ("NO"); 
                            //Ext.getCmp('strANTGINECOFum_1').allowBlank = true;
                            //Ext.getCmp('fecANTGINECOFum').allowBlank = true;
                        }
                        
                        Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').disable();
                        Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').disable();
                        Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').disable();
                        Ext.getCmp('intIdentificacionRiesgoLepra').disable();
                        Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').disable();

                    }
                }
            }
        });
        winHCOdontologia004Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosEndodoncia(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2014.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                
                //ANTECEDENTES
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pHTA: Ext.getCmp('bolANTPERSOHTA').getValue(),
                pDiabetes: Ext.getCmp('bolANTPERSODiabetes').getValue(),
                pNefropatias: Ext.getCmp('bolANTPERSONefropatias').getValue(),
                pInfertilidad: Ext.getCmp('bolANTPERSOInfertilidad').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCardiopatias: Ext.getCmp('bolANTPERSOCardiopatias').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pLactanciaHoy: Ext.getCmp('strANTGINECOLactanciaHoy').getValue(),
                pLactanciaPasado: Ext.getCmp('strANTGINECOLactanciaPasado').getValue(),
                pTiempoLactancia: Ext.getCmp('strANTGONECOTiempoLactancia').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pCiclosMeuales: Ext.getCmp('strANTGINECOCiclosMestruales').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pGuardarAntecedentes: "SI"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosEndodoncia(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2014.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                
                //ANTECEDENTES
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pHTA: Ext.getCmp('bolANTPERSOHTA').getValue(),
                pDiabetes: Ext.getCmp('bolANTPERSODiabetes').getValue(),
                pNefropatias: Ext.getCmp('bolANTPERSONefropatias').getValue(),
                pInfertilidad: Ext.getCmp('bolANTPERSOInfertilidad').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCardiopatias: Ext.getCmp('bolANTPERSOCardiopatias').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pLactanciaHoy: Ext.getCmp('strANTGINECOLactanciaHoy').getValue(),
                pLactanciaPasado: Ext.getCmp('strANTGINECOLactanciaPasado').getValue(),
                pTiempoLactancia: Ext.getCmp('strANTGONECOTiempoLactancia').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pCiclosMeuales: Ext.getCmp('strANTGINECOCiclosMestruales').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pGuardarAntecedentes: "SI"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnEliminarRegistrosEndo(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}


function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}