/*
* @category    Fieldset PrimeraInfancia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsAnexoVALEUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'VALE',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    labelWidth: 150,
    titleCollapse: true,
    padding: 0,
    id: 'fsVALE',
    initComponent: function() {
        
        this.tbar = [
            {
                xtype: 'button',
                text: 'VALE',
                iconCls: 'btnEvolucionar1',
                listeners:{
                    click : function(){
                        alert("Error al tratar de abrir la ruta '../../../rias/anexos/vale.js'");
                    }
                }
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'EAD-3',
                iconCls: 'btnEvolucionar1',
                listeners:{
                    click : function(){
                        alert("Error al tratar de abrir la ruta '../../../rias/anexos/ead3.js'");
                    }
                }
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Test MChat',
                iconCls: 'btnEvolucionar1',
                listeners:{
                    click : function(){
                        alert("Error al tratar de abrir la ruta '../../../rias/anexos/mchat.js'");
                    }
                }
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Familiograma',
                iconCls: 'btnEvolucionar1',
                listeners:{
                    click : function(){
                        alert("Error al tratar de abrir la ruta '../../../rias/anexos/familiograma.js'");
                    }
                }
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Apgar',
                iconCls: 'btnEvolucionar1',
                listeners:{
                    click : function(){
                        alert("Error al tratar de abrir la ruta '../../../rias/anexos/apgar.js'");
                    }
                }
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Ecomapa',
                iconCls: 'btnEvolucionar1',
                listeners:{
                    click : function(){
                        alert("Error al tratar de abrir la ruta '../../../rias/anexos/ecomapa.js'");
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        this.items = [
            {
                html: '<br>'
            },
            {
                xtype: 'fieldset',
                title: 'VALE',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'No se Realiza',
                        name: 'PRIMERA INFANCIA - VALE - NO SE REALIZA',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202NoRealiza,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strVALENoSeRealiza',
                        listeners: {
                            change: function( t, newValue, oldValue ){
                                if(newValue === "" || newValue === null){
                                    Ext.getCmp('fecAnexoVALE63').setValue(null);
                                    Ext.getCmp('strAnexoVALE40').setValue(null);
                                }else{
                                    if(newValue === "No se tiene el dato"){
                                        Ext.getCmp('fecAnexoVALE63').setValue("01/01/1800");
                                        Ext.getCmp('strAnexoVALE40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una tradición"){
                                        Ext.getCmp('fecAnexoVALE63').setValue("01/01/1805");
                                        Ext.getCmp('strAnexoVALE40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una condición de salud registrar"){
                                        Ext.getCmp('fecAnexoVALE63').setValue("01/01/1810");
                                        Ext.getCmp('strAnexoVALE40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una negación del usuario"){
                                        Ext.getCmp('fecAnexoVALE63').setValue("01/01/1825");
                                        Ext.getCmp('strAnexoVALE40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por otras razones"){
                                        Ext.getCmp('fecAnexoVALE63').setValue("01/01/1835");
                                        Ext.getCmp('strAnexoVALE40').setValue("21 - Riesgo no evaluado");
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'datefield',
                        fieldLabel: 'Fecha Valoracion',
                        name: 'PRIMERA INFANCIA - VALE - FECHA VALORACION',
                        width: 110,
                        allowBlank: true,
                        //value: new Date().format('d/m/Y'),
                        disabledDates: '',
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecAnexoVALE63',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strVALENoSeRealiza').setValue(null);
                                    Ext.getCmp('fecAnexoVALE63').setValue(localStorage.getItem('fecVALE'));
                                    Ext.getCmp('strAnexoVALE40').setValue(localStorage.getItem('resVALE'));
                                });
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Resultado',
                        name: 'PRIMERA INFANCIA - VALE - RESULTADO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202VALE,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAnexoVALE40',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strVALENoSeRealiza').setValue(null);
                                    Ext.getCmp('fecAnexoVALE63').setValue(localStorage.getItem('fecVALE'));
                                    Ext.getCmp('strAnexoVALE40').setValue(localStorage.getItem('resVALE'));
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Observaciones',
                        name: 'PRIMERA INFANCIA - VALE - OBSERVACIONES',
                        anchor: '100%',
                        allowBlank: true,
                        id: 'memAnexoVALE'
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    /*var MyDate = new Date();
                    MyDate.setDate(MyDate.getDate() - 360);
                    Ext.getCmp('fecPrimeraInfanciaValoracion').setMinValue(MyDate.format("d/m/Y"));
                    Ext.getCmp('fecPrimeraInfanciaValoracion').setMaxValue(new Date().format("d/m/Y"));*/
                }
            }
        });
        fsRES202PrimeraInfanciaUi.superclass.initComponent.call(this);
    }
});
