<?php

/**
 * @version     $Id: view.html.php 19014 2012-11-28 04:48:56Z thailv $
 * @package     JSNUniform
 * @subpackage  View
 * @author      JoomlaShine Team <support@joomlashine.com>
 * @copyright   Copyright (C) 2016 JoomlaShine.com. All Rights Reserved.
 * @license     GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.joomlashine.com
 * Technical Support:  Feedback - http://www.joomlashine.com/contact-us/get-support.html
 */
defined('_JEXEC') or die('Restricted access');


// import Joomla view library
jimport('joomla.application.component.view');

/**
 * View class for a list of Form.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_uniform
 * @since       1.5
 */
class JSNUniformViewForm extends JSNBaseView
{

	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  mixed  A string if successful, otherwise a JError object.
	 *
	 * @see     fetch()
	 * @since   11.1
	 */
	function display($tpl = null)
	{
		// Assign data to the view
		$this->_input = JFactory::getApplication()->input;
		$formId = $this->_input->get('form_id');
		$this->_state = $this->get('State');
		$this->_formId = $formId?$formId:$this->_state->get('form.id');

		$this->_formName = md5(date("Y-m-d H:i:s") . $this->_formId);

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode('<br />', $errors));
			return false;
		}

		$this->_prepareDocument();
		// Display the view
		parent::display($tpl);
	}

	/**
	 * Prepares the document.
	 *
	 * @return  void.
	 */	
	protected function _prepareDocument()
	{
		$doc	 	= JFactory::getDocument();
		$app     	= JFactory::getApplication();
		$menus   	= $app->getMenu();
		$menu 	 	= $menus->getActive();
		
		if ($menu)
		{
			$params 	= $menu->params;

			if ($params->get('menu-meta_description'))
			{
				$doc->setDescription($params->get('menu-meta_description'));
			}

			if ($params->get('menu-meta_keywords'))
			{
				$doc->setMetadata('keywords', $params->get('menu-meta_keywords'));
			}

			if ($params->get('robots'))
			{
				$doc->setMetadata('robots', $params->get('robots'));
			}
		}

	}

}
