<?php

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );


$doc = JFactory::getDocument();
$doc->addStyleSheet('modules/mod_bdthemes_google_map/css/google_map-style.css');
$doc->addScript('http://maps.google.com/maps/api/js?sensor=true');
$doc->addScript('modules/mod_bdthemes_google_map/js/gmaps.js');

if ($params->get('map_border') and $params->get('map_border_style') and $params->get('map_border_color')) {
  $map_border = ($params->get('map_border')) ? "border: " . $params->get('map_border') . ";" : "";
  $map_border_style = ($params->get('map_border_style')) ? " border-style: " . $params->get('map_border_style') . ";" : "";
  $map_border_color = ($params->get('map_border_color')) ? " border-color: " . $params->get('map_border_color') . ";" : "";
}

$map_height = ($params->get('map_height')) ? " height: " . $params->get('map_height', 400) . "px;" : "";

if ($params->get('infobox')) {
$infobox = 'infoWindow: { content: "<p>'.$params->get('infobox').'</p>" }';
}

$unique_id = "gmap_" . rand(9, 9999);
 

?>

<div id="<?php echo $unique_id;?>" class="bdt_google_map" style="<?php echo $map_border . $map_border_style . $map_border_color . $map_height; ?>"></div>


<script type="text/javascript">
    var map;
    jQuery(document).ready(function(){


    <?php if (!$params->get('static_map')) : ?>
          map = new GMaps({
            el: '#<?php echo $unique_id;?>',
            lat: <?php echo $params->get('lat');?>,
            lng: <?php echo $params->get('lng');?>,
            zoomControl : <?php echo $params->get('zoomControl');?>,
            zoom: <?php echo $params->get('zoom');?>,
            
            zoomControlOpt: {
                style : '<?php echo $params->get('zoomControlStyle') ?>',
                position: 'TOP_LEFT'
            
                
            },
            panControl : <?php echo $params->get('panControl');?>,
            streetViewControl : <?php echo $params->get('streetViewControl');?>
            });

          <?php if ($params->get('map_location_marker')=="true") : ?>
    	      map.addMarker({
    			  lat: <?php echo $params->get('lat');?>,
    			  lng: <?php echo $params->get('lng');?>,
    			   <?php echo $infobox ?>
    			});
          <?php endif; ?>

      <?php endif; ?>

      <?php if ($params->get('static_map')) : ?>
          url = GMaps.staticMapURL({
            size: [<?php echo $params->get('map_width'); ?>, <?php echo $params->get('map_height') - intval($params->get('map_border') * 2); ?>],
           lat: <?php echo $params->get('lat');?>,
            lng: <?php echo $params->get('lng');?>,
            markers: [
              { lat: <?php echo $params->get('lat');?>, lng: <?php echo $params->get('lng');?>}
            ]
          });

          jQuery('<img/>').attr('src', url)
            .appendTo('#<?php echo $unique_id;?>');
      <?php endif; ?>

    });
  </script>