<?php

/**
* Image Carousel - main PHP file
* @package Joomla!
* @Copyright (C) 2009-2012 Gavick.com
* @ All rights reserved
* @ Joomla! is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @ version $Revision: GK4 1.0 $
**/

// no direct access
defined('_JEXEC') or die;
// Image class loading
require_once (dirname(__FILE__).DS.'class.image.php');

class BDT_single_row_Controller {
	// configuration array
	private $config;
	// module info
	private $module;
	// constructor
	function __construct($module, $config) {
		// init the style config
		$this->config = $config;
		// init the module info
		$this->module = $module;
		// check the module images
		$this->checkImages();
		// generate the view
		$this->generateView();
	}
	// check the images
	function checkImages() {
		// if the thumbnail generation is enabled
		if($this->config['generate_thumbnails'] == 1) {
			// basic images params		
			$img_width = $this->config['config']->single_row->single_row_image_width;
			$img_height = $this->config['config']->single_row->single_row_image_height;
			$quality = $this->config['config']->single_row->single_row_quality;
			// check the slides
			foreach($this->config['image_show_data'] as $slide) {
				$stretch = ($slide->stretch == 'nostretch') ? false : true;
				$imageSize = new BDT_single_row_Image ();
				$imageSize->createThumbnail($slide->image, $this->config, $img_width, $img_height,"#000000", $stretch, $quality);	
			}
		}
	}
	
	// generate view
	function generateView() {
		// generate the head section
		$document = JFactory::getDocument();
		$uri = JURI::getInstance();
		// get the head data
		$headData = $document->getHeadData();


		for ($i = 0; $i < count($scripts); $i++) {
		    if (stripos($scripts[$i], 'owl.carousel.min.js') !== false) {
		        $scriptFound = true;
		    }
		}
		if (!$scriptFound) {
			
			$document->addStyleSheet($uri->root().'modules/mod_bdthemes_image_carousel/styles/'.$this->config['styles'].'/style/owl.carousel.css');
			$document->addStyleSheet($uri->root().'modules/mod_bdthemes_image_carousel/styles/'.$this->config['styles'].'/style/owl.theme.css');
			$document->addStyleSheet($uri->root().'modules/mod_bdthemes_image_carousel/styles/'.$this->config['styles'].'/style/owl.transitions.css');
			$document->addScript($uri->root().'modules/mod_bdthemes_image_carousel/styles/'.$this->config['styles'].'/js/owl.carousel.min.js');
		}

		$width = $this->config['config']->single_row->single_row_image_width;
		$height = $this->config['config']->single_row->single_row_image_height;
		
		// load view
		require(dirname(__FILE__).DS.'view.php');
	}
}

// EOF