<?php

/**
* Testimonials - main PHP file
* @package Joomla!
* @Copyright (C) 2009-2012 Gavick.com
* @ All rights reserved
* @ Joomla! is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @ version $Revision: GK4 1.0 $
**/

// no direct access
defined('_JEXEC') or die;
// Image class loading
require_once (dirname(__FILE__).DS.'class.image.php');
// Model class loading
require_once (dirname(__FILE__).DS.'model.php');

class BDT_bdt_testimonials_Controller {
	// configuration array
	private $config;
	// module info
	private $module;
	// article data
	private $articles;
    private $articlesK2;
	// constructor
	function __construct($module, $config) {
		// init the style config
		$this->config = $config;
		// init the module info
		$this->module = $module;
		// init the articles array
		$this->articles = array();
        $this->articlesK2 = array();
		// check the module images
		$this->checkImages();
		// get the articles data
		$this->getArticleData();
		// generate the view
		$this->generateView();
	}
	// check the images
	function checkImages() {
		// if the thumbnail generation is enabled
		if($this->config['generate_thumbnails'] == 1) {
			// basic images params		
			$img_width = $this->config['config']->bdt_testimonials->bdt_testimonials_image_width;
			$img_height = $this->config['config']->bdt_testimonials->bdt_testimonials_image_height;
			$quality = $this->config['config']->bdt_testimonials->bdt_testimonials_quality;
			// check the slides
			foreach($this->config['image_show_data'] as $slide) {
				$stretch = ($slide->stretch == 'nostretch') ? false : true;
				$imageSize = new BDT_testimonials_Image ();
				$imageSize->createThumbnail($slide->image, $this->config, $img_width, $img_height,"#000000", $stretch, $quality);	
			}
		}
	}
	// get the articles data
	function getArticleData() {
		// create the array
		$ids = array();
        $idsK2 = array();
		// generate the content of the array
		foreach($this->config['image_show_data'] as $slide) {
			if($slide->type == 'article') {
				array_push($ids, $slide->art_id);
			}
            if($slide->type == 'k2') {
				array_push($idsK2, $slide->artK2_id);
			}
		}
		// get the data
		if(count($idsK2) > 0) {
			$this->articlesK2 = BDT_bdt_testimonials_Model::getDataK2($idsK2);
		}
		if(count($ids) > 0) {
			$this->articles = BDT_bdt_testimonials_Model::getData($ids);
		}
	}
	// generate view
	function generateView() {
		// generate the head section
		$document = JFactory::getDocument();
		$uri = JURI::getInstance();
		// get the head data
		$headData = $document->getHeadData();

		$scripts = array_keys($document->_scripts);
		$scriptFound = false;
		for ($i = 0; $i < count($scripts); $i++) {
		    if (stripos($scripts[$i], 'owl.carousel.min.js') !== false) {
		        $scriptFound = true;
		    }
		}
		if (!$scriptFound) {
			$document->addScript($uri->root().'modules/mod_bdthemes_testimonials/styles/'.$this->config['styles'].'/js/owl.carousel.min.js');
			$document->addStyleSheet($uri->root().'modules/mod_bdthemes_testimonials/styles/'.$this->config['styles'].'/style/owl.carousel.css');
			$document->addStyleSheet($uri->root().'modules/mod_bdthemes_testimonials/styles/'.$this->config['styles'].'/style/owl.transitions.css');
			
		}
			$document->addStyleSheet($uri->root().'modules/mod_bdthemes_testimonials/styles/'.$this->config['styles'].'/style/owl.theme.css');

		
		$width = $this->config['config']->bdt_testimonials->bdt_testimonials_image_width;
		$height = $this->config['config']->bdt_testimonials->bdt_testimonials_image_height;
		// load view
		require(dirname(__FILE__).DS.'view.php');
	}
}

// EOF