<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  Editors-xtd.image
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * Editor SHortcode Ultimate button
 *
 * @package     Joomla.Plugin
 * @subpackage  Editors-xtd.image
 * @since       1.5
 */
class PlgButtonShortcode_Ultimate extends JPlugin
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 * @since  3.1
	 */
	protected $autoloadLanguage = true;

	/**
	 * Display the button.
	 *
	 * @param   string   $name    The name of the button to display.
	 * @param   string   $asset   The name of the asset being edited.
	 * @param   integer  $author  The id of the author owning the asset being edited.
	 *
	 * @return  array    A two element array of (imageName, textToInsert) or false if not authorised.
	 */
	public function onDisplay($name, $asset, $author)
	{
		$js = 'function jSelectShortcode(text) {
		            if(document.getElementById(\'jform_articletext\') != null) {
		                jInsertEditorText(text, \'jform_articletext\');
		            }
		            if(document.getElementById(\'text\') != null) {
		                jInsertEditorText(text, \'text\');
		            }
		            if(document.getElementById(\'jform_description\') != null) {
		                jInsertEditorText(text, \'jform_description\');
		            }
		            if(document.getElementById(\'jform_content\') != null) {
		                jInsertEditorText(text, \'jform_content\');
		            }
		            SqueezeBox.close();  
		        }';
		$doc = JFactory::getDocument();
		$doc->addScriptDeclaration($js);

		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		$extension = $app->input->get('option');

		$version = new JVersion();
		$image_path = JURI::root(true) . '/plugins/editors-xtd/rokbox/assets/images/';

		if ($asset == '')
		{
			$asset = $extension;
		}

		if (	$user->authorise('core.edit', $asset)
			||	$user->authorise('core.create', $asset)
			||	(count($user->getAuthorisedCategories($asset, 'core.create')) > 0)
			||	($user->authorise('core.edit.own', $asset) && $author == $user->id)
			||	(count($user->getAuthorisedCategories($extension, 'core.edit')) > 0)
			||	(count($user->getAuthorisedCategories($extension, 'core.edit.own')) > 0 && $author == $user->id))
		{
			$link = 'index.php?option=com_bdthemes_shortcodes&amp;view=config&amp;tmpl=component&amp;e_name=' . $name . '&amp;asset=' . $asset . '&amp;author=' . $author;
			JHtml::_('behavior.modal');
			$button = new JObject;
			$button->modal = true;
			$button->class = 'btn';
			$button->link = $link;
			$button->text = JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_INSERT_SHORTCODE');
			$button->name = 'apply';
			$button->options = "{handler: 'iframe', size: {x: 850, y: 620}}";

			return $button;
		}
		else
		{
			return false;
		}
	}
}
