<?php

/**
 * BDThemes Shortcodes 
 *
 * @package		Joomla
 * @subpackage	BDThemes Schortcodes
 * @copyright Copyright (C) 2011 BDThemes Ltd. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @author BDThemes
 * @author url http://themeforest.net/user/bdtheme
 */
// No direct access.
defined('_JEXEC') or die;

// Import Joomla core library
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');
jimport('joomla.plugin.plugin');

$bdt_su_uri = JUri::root() . 'plugins/system/bdthemes_shortcodes';
define('BDT_SU_ROOT', dirname(__FILE__));
define('BDT_SU_CONFIG', dirname(__FILE__).'/config');
define('BDT_SU_URI', $bdt_su_uri);
define('BDT_SU_IMG', BDT_SU_URI.'/images/');

require_once BDT_SU_ROOT . '/config/inc/tools.php';
require_once BDT_SU_ROOT . '/config/inc/wp_override.php';
require_once BDT_SU_ROOT . '/helper/shortcodes.php';
require_once BDT_SU_ROOT . '/helper/addshortcodes.php';

$lang = JFactory::getLanguage(); 
$lang->load('plg_system_bdthemes_shortcodes.sys', JPATH_ADMINISTRATOR);

class plgSystemBdthemes_Shortcodes extends JPlugin {

  var $document = NULL;
  var $baseurl = NULL;

  public function __construct(&$subject, $config) {
      parent::__construct($subject, $config);

      $this->document = JFactory::getDocument();
      $this->baseurl = str_replace("/administrator", "", JURI::base());
      $app = JFactory::getApplication();
      $input = $app->input;
      if ($app->isAdmin() && $input->get("option") == "com_plugins" && @$_POST["jform"]["element"] == "bdthemes_shortcodes" && $input->get("task") == "plugin.apply") {
        $file_s = BDT_SU_ROOT . "/css/custom.css";
        file_put_contents($file_s, @$_POST['jform']['params']['css']);
      }
  }

  // Function on after render
  public function onAfterRender() {
    $runmode = $this->params->get('runmode', 0);
    $app = JFactory::getApplication();

    // Only enable shortcodes in fontend & work with buffer of page
    if ($app->isSite()) {
      $page = JResponse::GetBody();
      if ($runmode == 1) {
      	$page = JResponse::GetBody();
      	$page = do_shortcode($page);
      	JResponse::SetBody($page);
      }
    }
  }

  // Do BBCode replacements on the whole page
  public function onContentPrepare($context, &$article, &$params, $limitstart) {
    //error_reporting(E_ALL ^ E_NOTICE); // 
    //print_r($article->text);
    $article->text = wpautop($article->text);
    $article->text = shortcode_unautop($article->text);
    $article->text = do_shortcode($article->text);
  }

  /**
   * 
   * return if current joomla version is joomla 3
   */
  public static function isJoomla3() {
    if (defined("JVERSION")) {
      $version = JVERSION;
      $version = (int) $version;
      return($version == 3);
    }

    if (class_exists("JVersion")) {
      $jversion = new JVersion;
      $version = $jversion->getShortVersion();
      $version = (int) $version;
      return($version == 3);
    }
    return(!defined("DS"));
  }

  // Add media
  public function onBeforeRender() {
    $app = JFactory::getApplication();
    if ($app->isSite()) {
		if ($this->params->get('font-awesome')=='local') {
			$this->document->addStyleSheet( BDT_SU_URI . '/css/font-awesome.css');
		}
		elseif ($this->params->get('font-awesome')=='cdn') {
			$this->document->addStyleSheet('http://netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.min.css');
		}
		if ($this->isJoomla3()) {
			if ($this->params->get('jquery-admin')=='local') {
				$this->document->addScript('media/jui/js/jquery.min.js');
			}
		}
		else {
			$this->document->addScript( BDT_SU_URI . '/js/jquery.js');
		}
	}
	if ($app->isAdmin()) {
		if ($this->params->get('font-awesome-admin')=='local') {
			$this->document->addStyleSheet( BDT_SU_URI . '/css/font-awesome.css');
		}
		elseif ($this->params->get('font-awesome-admin')=='cdn') {
			$this->document->addStyleSheet('http://netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.min.css');
		}
		if ($this->isJoomla3()) {
			if ($this->params->get('jquery-admin')=='local') {
				$this->document->addScript('media/jui/js/jquery.min.js');
			}
		}
		else {
			$this->document->addScript( BDT_SU_URI . '/js/jquery.js');
		}
    }
  }
}
