<?php

/**
 * Shortcode Generator
 */
class Su_Generator {

	 /**
	  * Constructor
	  */
	 function __construct() {
	  
	 }

	 /**
	  * Generator button
	  */
	public static function button($args = array()) {
		// Check access
		if (!self::access_check())
		return;
		// Prepare args
		$args = wp_parse_args($args, array(
		  'target' => 'content',
		  'text' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_INSERT_SORTCODE'),
		  'class' => 'button',
		  'icon' => plugins_url('assets/images/icon.png', SU_PLUGIN_FILE),
		  'echo' => true,
		  'shortcode' => false
		  ));
		// Prepare icon
		if ($args['icon'])
		$args['icon'] = '<img src="' . $args['icon'] . '" /> ';
		// Print button
		$button = '<a href="javascript:void(0);" class="su-generator-button ' . $args['class'] . '" title="' . $args['text'] . '" data-target="' . $args['target'] . '" data-mfp-src="#su-generator" data-shortcode="' . (string) $args['shortcode'] . '">' . $args['icon'] . $args['text'] . '</a>';
		// Show generator popup
		add_action('wp_footer', array(__CLASS__, 'popup'));
		add_action('admin_footer', array(__CLASS__, 'popup'));
		// Request assets
		wp_enqueue_media();
		su_query_asset('css', array('simpleslider', 'farbtastic', 'magnific-popup', 'font-awesome', 'su-generator'));
		su_query_asset('js', array('jquery', 'jquery-ui-core', 'jquery-ui-widget', 'jquery-ui-mouse', 'simpleslider', 'farbtastic', 'magnific-popup', 'su-generator'));
		// Print/return result
		if ($args['echo'])
		echo $button;
		return $button;
	}

	/**
	* Cache reset
	*/
	public static function reset() {
		// Clear popup cache
		delete_transient('su/generator/popup');
		// Clear shortcodes settings cache
		foreach (array_keys((array) Su_Data::shortcodes()) as $shortcode)
		delete_transient('su/generator/settings/' . $shortcode);
	}

	/**
	* Generator popup form
	*/
	public static function popup() {
		// Get cache
		$output = get_transient('su/generator/popup');
		if ($output && SU_ENABLE_CACHE)
		echo $output;
		// Cache not found
		else {
		ob_start();
		?>
		<div id="su-generator-wrap" style="display:none">
		<div id="su-generator">
		 <div id="su-generator-header">
		  <input type="text" name="su_generator_search" id="su-generator-search" value="" placeholder="Search for shortcodes" />
		  <div id="su-generator-filter">
		  	<strong><?php JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FILTER_DESC'); ?></strong>
				<?php 
					foreach ((array) Su_Data::groups() as $group => $label)
					echo '<a href="#" data-filter="' . $group . '">' . $label . '</a>';
				?>
		  </div>
		  <div id="su-generator-choices" class="su-generator-clearfix">
		   <?php
		   // Choices loop
		   foreach ((array) Su_Data::shortcodes() as $name => $shortcode) {
				$icon = ( isset($shortcode['icon']) ) ? $shortcode['icon'] : 'puzzle-piece';
				$shortcode['name'] = ( isset($shortcode['name']) ) ? $shortcode['name'] : $name;
				echo '<span data-name="' . $shortcode['name'] . '" data-shortcode="' . $name . '" title="' . esc_attr($shortcode['desc']) . '" data-desc="' . esc_attr($shortcode['desc']) . '" data-group="' . $shortcode['group'] . '">' . Su_Tools::icon($icon) . $shortcode['name'] . '</span>' . "\n";
		   }
		   ?>
		  </div>
		 </div>
		 <div id="su-generator-settings"></div>
		 <input type="hidden" name="su-generator-selected" id="su-generator-selected" value="<?php echo plugins_url('', SU_PLUGIN_FILE); ?>" />
		 <input type="hidden" name="su-generator-url" id="su-generator-url" value="<?php echo plugins_url('', SU_PLUGIN_FILE); ?>" />
		 <input type="hidden" name="su-compatibility-mode-prefix" id="su-compatibility-mode-prefix" value="<?php echo su_compatibility_mode_prefix(); ?>" />
		 <div id="su-generator-result" style="display:none"></div>
		</div>
		</div>
		<?php
		$output = ob_get_contents();
		set_transient('su/generator/popup', $output, 2 * DAY_IN_SECONDS);
		ob_end_clean();
		echo $output;
		}
	}

	/**
	* Process AJAX request
	*/
	public static function settings() { {
	   // Request queried shortcode
	   $shortcode = Su_Data::shortcodes(( $_REQUEST['shortcode']));

	   // Prepare skip-if-default option
	   // Prepare actions
	   $actions = apply_filters('su/generator/actions', array(
	       'insert' => '<a href="javascript:void(0);" class="btn btn-primary su-generator-insert"><i class="fa fa-check"></i> ' . JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_INSERT_SORTCODE') . '</a>',
	       'preview' => '<a href="javascript:void(0);" class="btn su-generator-toggle-preview"><i class="fa fa-eye"></i> ' . JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIVE_PREVIEW') . '</a>'
		   )); 
	   // Shortcode header
	   $return = '<div id="su-generator-breadcrumbs">';
	   $return .= apply_filters('su/generator/breadcrumbs', '<a href="javascript:void(0);" class="su-generator-home" title="' . JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALL_SHORTCODE_DESC') . '">' .JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALL_SHORTCODE') .
		   '</a> &rarr; <span>' . $shortcode['name'] . '</span> <small class="alignright">' . $shortcode['desc'] . '</small><div class="su-generator-clear"></div>');
	   $return .= '</div>';
	   // Shortcode has atts
	   if (count($shortcode['atts']) && $shortcode['atts']) {
	    // Loop through shortcode parameters
	    foreach ($shortcode['atts'] as $attr_name => $attr_info) {
	     // Prepare default value
	     $default = (string) ( isset($attr_info['default']) ) ? $attr_info['default'] : '';
	     $attr_info['name'] = (isset($attr_info['name'])) ? $attr_info['name'] : $attr_name;
	     $return .= '<div class="su-generator-attr-container' . @$skip . '" data-default="' . htmlentities($default) . '">'; // change esc_attr to htmlentities
	     $return .= '<h5>' . $attr_info['name'] . '</h5>';
	     // Create field types
	     if (!isset($attr_info['type']) && isset($attr_info['values']) && is_array($attr_info['values']) && count($attr_info['values']))
	      $attr_info['type'] = 'select';
	     elseif (!isset($attr_info['type']))
	      $attr_info['type'] = 'text';
	     if (is_callable(array('Su_Generator_Views', $attr_info['type'])))
	      $return .= call_user_func(array('Su_Generator_Views', $attr_info['type']), $attr_name, $attr_info);
	     elseif (isset($attr_info['callback']) && is_callable($attr_info['callback']))
	      $return .= call_user_func($attr_info['callback'], $attr_name, $attr_info);
	     if (isset($attr_info['desc']))
	      $return .= '<div class="su-generator-attr-desc">' . str_replace(array('<b%value>', '<b_>'), '<b class="su-generator-set-value" title="' . JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ATTR_DESC') . '">', $attr_info['desc']) . '</div>';
	     $return .= '</div>';
	    }
	   }
	   // Single shortcode (not closed)
	   if ($shortcode['type'] == 'single')
	    $return .= '<input type="hidden" name="su-generator-content" id="su-generator-content" value="false" />';
	   // Wrapping shortcode
	   else
	    $return .= '<div class="su-generator-attr-container"><h5>' . JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTENT') . '</h5><textarea name="su-generator-content" id="su-generator-content" rows="5">' . ( str_replace(array('%prefix_', '__'), null, $shortcode['content']) ) . '</textarea></div>';
	   $return .= '<div id="su-generator-preview"></div>';
	   $return .= '<div class="su-generator-actions su-generator-clearfix">' . implode(' ', array_values($actions)) . '</div>';
	   echo $return;
	  }
	  exit;
	 }

 /**
  * Process AJAX request and generate preview HTML
  */
	public static function preview() {
		// Check authentication
		self::access();
		// Output results
		//		do_action( 'su/generator/preview/before' );
		echo '<h5>' . JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PREVIEW') . '</h5>';
		//   echo '<hr />' . stripslashes( $_POST['shortcode'] ) . '<hr />'; // Uncomment for debug
		$sortcode= do_shortcode( str_replace( '\"', '"', $_POST['shortcode'] ) );
		$sortcode = wpautop($sortcode);
		$sortcode = shortcode_unautop($sortcode);
		$sortcode = do_shortcode($sortcode);
		echo $sortcode;

		echo '<div style="clear:both"></div>';
		die();
	}

	public static function access() {

	}

	public static function access_check() {

	}

	public static function ajax_get_icons() {
		self::access();
		die(Su_Tools::icons());
	}

	public static function ajax_get_terms() {
		self::access();
		$args = array();
		if (isset($_REQUEST['tax']))
		$args['options'] = (array) Su_Tools::get_terms(sanitize_key($_REQUEST['tax']));
		if (isset($_REQUEST['class']))
		$args['class'] = (string) sanitize_key($_REQUEST['class']);
		if (isset($_REQUEST['multiple']))
		$args['multiple'] = (bool) sanitize_key($_REQUEST['multiple']);
		if (isset($_REQUEST['size']))
		$args['size'] = (int) sanitize_key($_REQUEST['size']);
		if (isset($_REQUEST['noselect']))
		$args['noselect'] = (bool) sanitize_key($_REQUEST['noselect']);
		die(Su_Tools::select($args));
	}

	public static function ajax_get_taxonomies() {
		self::access();
		$args = array();
		$args['options'] = Su_Tools::get_taxonomies();
		die(Su_Tools::select($args));
	}

	public static function presets($actions) {
		ob_start();
		?>
			<div class="su-generator-presets alignright" data-shortcode="<?php echo sanitize_key($_REQUEST['shortcode']); ?>">
				<a href="javascript:void(0);" class="button button-large su-gp-button"><i class="fa fa-bars"></i> <?php _e('Presets', 'su'); ?></a>
				<div class="su-gp-popup">
					<div class="su-gp-head">
						<a href="javascript:void(0);" class="button button-small button-primary su-gp-new"><?php _e('Save current settings as preset', 'su'); ?></a>
					</div>
					<div class="su-gp-list">
						<?php self::presets_list(); ?>
					</div>
				</div>
			</div>
			<?php
			$actions['presets'] = ob_get_contents();
		ob_end_clean();
		return $actions;
	}

	public static function presets_list($shortcode = false) {
		// Shortcode isn't specified, try to get it from $_REQUEST
		if (!$shortcode)
		$shortcode = $_REQUEST['shortcode'];
		// Shortcode name is still doesn't exists, exit
		if (!$shortcode)
		return;
		// Shortcode has been specified, sanitize it
		$shortcode = sanitize_key($shortcode);
		// Get presets
		$presets = get_option('su_presets_' . $shortcode);
		// Presets has been found
		if (is_array($presets) && count($presets)) {
		// Print the presets
		foreach ($presets as $preset) {
		echo '<span data-id="' . $preset['id'] . '"><em>' . stripslashes($preset['name']) . '</em> <i class="fa fa-times"></i></span>';
		}
		// Hide default text
		echo sprintf('<b style="display:none">%s</b>', Jtext::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PRESETS_NOT_FOUND'));
		}
		// Presets doesn't found
		else
		echo sprintf('<b>%s</b>', Jtext::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PRESETS_NOT_FOUND'));
	}

	public static function ajax_add_preset() {
		self::access();
		// Check incoming data
		if (empty($_POST['id']))
		return;
		if (empty($_POST['name']))
		return;
		if (empty($_POST['settings']))
		return;
		if (empty($_POST['shortcode']))
		return;
		// Clean-up incoming data
		$id = sanitize_key($_POST['id']);
		$name = sanitize_text_field($_POST['name']);
		$settings = ( is_array($_POST['settings']) ) ? stripslashes_deep($_POST['settings']) : array();
		$shortcode = sanitize_key($_POST['shortcode']);
		// Prepare option name
		$option = 'su_presets_' . $shortcode;
		// Get the existing presets
		$current = get_option($option);
		// Create array with new preset
		$new = array(
		  'id' => $id,
		  'name' => $name,
		  'settings' => $settings
		);
		// Add new array to the option value
		if (!is_array($current))
		$current = array();
		$current[$id] = $new;
		// Save updated option
		update_option($option, $current);
		// Clear cache
		delete_transient('su/generator/settings/' . $shortcode);
	}

	public static function ajax_remove_preset() {
		self::access();
		// Check incoming data
		if (empty($_POST['id']))
		return;
		if (empty($_POST['shortcode']))
		return;
		// Clean-up incoming data
		$id = sanitize_key($_POST['id']);
		$shortcode = sanitize_key($_POST['shortcode']);
		// Prepare option name
		$option = 'su_presets_' . $shortcode;
		// Get the existing presets
		$current = get_option($option);
		// Check that preset is exists
		if (!is_array($current) || empty($current[$id]))
		return;
		// Remove preset
		unset($current[$id]);
		// Save updated option
		update_option($option, $current);
		// Clear cache
		delete_transient('su/generator/settings/' . $shortcode);
	}

	public static function ajax_get_preset() {
		self::access();
		// Check incoming data
		if (empty($_GET['id']))
		return;
		if (empty($_GET['shortcode']))
		return;
		// Clean-up incoming data
		$id = sanitize_key($_GET['id']);
		$shortcode = sanitize_key($_GET['shortcode']);
		// Default data
		$data = array();
		// Get the existing presets
		$presets = get_option('su_presets_' . $shortcode);
		// Check that preset is exists
		if (is_array($presets) && isset($presets[$id]['settings']))
		$data = $presets[$id]['settings'];
		// Print results
		die(json_encode($data));
	}

}

new Su_Generator;

class Shortcodes_Ultimate_Generator extends Su_Generator {

 function __construct() {
  parent::__construct();
 }

}
