<?php

$com_path = JPATH_SITE . '/components/com_content/';
require_once $com_path . 'router.php';
require_once $com_path . 'helpers/route.php';

JModelLegacy::addIncludePath($com_path . '/models', 'ContentModel');

function su_parse_csv($file) {
    $csv_lines = file($file);
    if (is_array($csv_lines)) {
        $cnt = count($csv_lines);
        for ($i = 0; $i < $cnt; $i++) {
            $line = $csv_lines[$i];
            $line = trim($line);
            $first_char = true;
            $col_num = 0;
            $length = strlen($line);
            for ($b = 0; $b < $length; $b++) {
                if ($skip_char != true) {
                    $process = true;
                    if ($first_char == true) {
                        if ($line[$b] == '"') {
                            $terminator = '";';
                            $process = false;
                        } else
                            $terminator = ';';
                        $first_char = false;
                    }
                    if ($line[$b] == '"') {
                        $next_char = $line[$b + 1];
                        if ($next_char == '"')
                            $skip_char = true;
                        elseif ($next_char == ';') {
                            if ($terminator == '";') {
                                $first_char = true;
                                $process = false;
                                $skip_char = true;
                            }
                        }
                    }
                    if ($process == true) {
                        if ($line[$b] == ';') {
                            if ($terminator == ';') {
                                $first_char = true;
                                $process = false;
                            }
                        }
                    }
                    if ($process == true)
                        $column .= $line[$b];
                    if ($b == ( $length - 1 ))
                        $first_char = true;
                    if ($first_char == true) {
                        $values[$i][$col_num] = $column;
                        $column = '';
                        $col_num++;
                    }
                } else
                    $skip_char = false;
            }
        }
    }
    $return = '<table><tr>';
    foreach ($values[0] as $value)
        $return .= '<th>' . $value . '</th>';
    $return .= '</tr>';
    array_shift($values);
    foreach ($values as $rows) {
        $return .= '<tr>';
        foreach ($rows as $col) {
            $return .= '<td>' . $col . '</td>';
        }
        $return .= '</tr>';
    }
    $return .= '</table>';
    return $return;
}

/**
 * Color shift a hex value by a specific percentage factor
 *
 * @param string  $supplied_hex Any valid hex value. Short forms e.g. #333 accepted.
 * @param string  $shift_method How to shift the value e.g( +,up,lighter,>)
 * @param integer $percentage   Percentage in range of [0-100] to shift provided hex value by
 *
 * @return string shifted hex value
 * @version 1.0 2008-03-28
 */
function su_hex_shift($supplied_hex, $shift_method, $percentage = 50) {
    $shifted_hex_value = null;
    $valid_shift_option = false;
    $current_set = 1;
    $RGB_values = array();
    $valid_shift_up_args = array('up', '+', 'lighter', '>');
    $valid_shift_down_args = array('down', '-', 'darker', '<');
    $shift_method = strtolower(trim($shift_method));
    // Check Factor
    if (!is_numeric($percentage) || ( $percentage = (int) $percentage ) < 0 || $percentage > 100
    )
        trigger_error("Invalid factor", E_USER_NOTICE);
    // Check shift method
    foreach (array($valid_shift_down_args, $valid_shift_up_args) as $options) {
        foreach ($options as $method) {
            if ($method == $shift_method) {
                $valid_shift_option = !$valid_shift_option;
                $shift_method = ( $current_set === 1 ) ? '+' : '-';
                break 2;
            }
        }
        ++$current_set;
    }
    if (!$valid_shift_option)
        trigger_error("Invalid shift method", E_USER_NOTICE);
    // Check Hex string
    switch (strlen($supplied_hex = ( str_replace('#', '', trim($supplied_hex)) ))) {
        case 3:
            if (preg_match('/^([0-9a-f])([0-9a-f])([0-9a-f])/i', $supplied_hex)) {
                $supplied_hex = preg_replace('/^([0-9a-f])([0-9a-f])([0-9a-f])/i', '\\1\\1\\2\\2\\3\\3', $supplied_hex);
            } else {
                trigger_error("Invalid hex color value", E_USER_NOTICE);
            }
            break;
        case 6:
            if (!preg_match('/^[0-9a-f]{2}[0-9a-f]{2}[0-9a-f]{2}$/i', $supplied_hex)) {
                trigger_error("Invalid hex color value", E_USER_NOTICE);
            }
            break;
        default:
            trigger_error("Invalid hex color length", E_USER_NOTICE);
    }
    // Start shifting
    $RGB_values['R'] = hexdec($supplied_hex{0} . $supplied_hex{1});
    $RGB_values['G'] = hexdec($supplied_hex{2} . $supplied_hex{3});
    $RGB_values['B'] = hexdec($supplied_hex{4} . $supplied_hex{5});
    foreach ($RGB_values as $c => $v) {
        switch ($shift_method) {
            case '-':
                $amount = round(( ( 255 - $v ) / 100 ) * $percentage) + $v;
                break;
            case '+':
                $amount = $v - round(( $v / 100 ) * $percentage);
                break;
            default:
                trigger_error("Oops. Unexpected shift method", E_USER_NOTICE);
        }
        $shifted_hex_value .= $current_value = ( strlen($decimal_to_hex = dechex($amount)) < 2 ) ?
                '0' . $decimal_to_hex : $decimal_to_hex;
    }
    return '#' . $shifted_hex_value;
}

/**
 * Apply all custom formatting options of plugin
 */
function su_apply_formatting() {
    // Enable shortcodes in text widgets
    add_filter('widget_text', 'do_shortcode');
    // Enable shortcodes in category descriptions
    add_filter('category_description', 'do_shortcode');
    // Enable custom formatting
    if (get_option('su_option_custom-formatting') === 'on') {
        // Apply custom formatter function
        add_filter('the_content', 'su_clean_shortcodes');
    }
}

/**
 * Custom formatter function
 *
 * @param string  $content
 *
 * @return string Formatted content with clean shortcodes content
 */
function su_clean_shortcodes($content) {
    $p = su_cmpt();
    $array = array(
        '<p>[' => '[',
        ']</p>' => ']',
        ']<br />' => ']'
    );
    $content = strtr($content, $array);
    return $content;
}

/**
 * Custom do_shortcode function for nested shortcodes
 *
 * @param string  $content Shortcode content
 * @param string  $pre     First shortcode letter
 *
 * @return string Formatted content
 */
function su_do_shortcode($content, $pre) {
    if (strpos($content, '[_') !== false)
        $content = preg_replace('@(\[_*)_(' . $pre . '|/)@', "$1$2", $content);
    return do_shortcode($content);
}

/**
 * Shortcode names prefix in compatibility mode
 *
 * @return string Special prefix
 */
function su_compatibility_mode_prefix() {
    return null;
    return get_option('su_option_prefix');
}

/**
 * Shortcut for su_compatibility_mode_prefix()
 */
function su_cmpt() {
    return su_compatibility_mode_prefix();
}

/**
 * Extra CSS class helper
 *
 * @param array   $atts Shortcode attributes
 *
 * @return string
 */
function su_ecssc($atts) {
    return ( $atts['class'] ) ? ' ' . trim($atts['class']) : '';
}

function su_image_resize($url, $width = NULL, $height = NULL, $crop = true, $retina = false) {
	//if gd library doesn't exists - output normal image without resizing.
    if(function_exists("gd_info") == false){
         $image_array = array(
        'url' => $url,
        'width' => $width,
        'height' => $height,
        'type' => ''
    );
    return $image_array;
    }
                        
    $thumb_folder = 'images/shortcode/';
    if(!is_dir(JPATH_SITE .'/'. $thumb_folder)){
        mkdir(JPATH_SITE .'/'. $thumb_folder,0777);
    }
    
    $fileExtension = strrchr($url, ".");
 
    $thumb_width = $width;
    $thumb_height = $height;
    
    list ($owidth, $oheight, $type) = getimagesize($url);
    switch ($type) {
        case IMAGETYPE_GIF :
            $image = imagecreatefromgif($url);
            break;
        case IMAGETYPE_JPEG :
            $image = imagecreatefromjpeg($url);
            break;
        case IMAGETYPE_PNG :
            $image = imagecreatefrompng($url);
            break;
        default :
            throw new InvalidArgumentException("Image type $type not supported");
    }

    $original_aspect = $owidth / $oheight;
    $thumb_aspect = $thumb_width / $thumb_height;

    if($crop){
    $thumb_path = basename($url, $fileExtension) . '-' . $width . 'x' . $height . $fileExtension; // $file is set to "index";
    $thumb_path = JPATH_SITE .'/'. $thumb_folder . $thumb_path;
    if ($original_aspect >= $thumb_aspect) {
        // If image is wider than thumbnail (in aspect ratio sense)
        $new_height = $thumb_height;
        $new_width = $owidth / ($oheight / $thumb_height);
    } else {
        // If the thumbnail is wider than the image
        $new_width = $thumb_width;
        $new_height = $oheight / ($owidth / $thumb_width);
    }
        $thumb = imagecreatetruecolor($thumb_width, $thumb_height);
// Resize and crop
    imagecopyresampled($thumb, $image, 0 - ($new_width - $thumb_width) / 2, // Center the image horizontally
            0 - ($new_height - $thumb_height) / 2, // Center the image vertically
            0, 0, $new_width, $new_height, $owidth, $oheight);
    }else{
       $new_width = $thumb_width;
       $new_height = (int) ( 1/ $original_aspect * $new_width);
       $thumb_path = basename($url, $fileExtension) . '-' . $new_width . 'x' . $new_height . $fileExtension; // $file is set to "index";
       $thumb_path = JPATH_SITE .'/'. $thumb_folder . $thumb_path;
       $thumb = imagecreatetruecolor($new_width, $new_height);
       // Resize and crop
        imagecopyresampled($thumb, $image, 0 , // Center the image horizontally
            0 , // Center the image vertically
            0, 0, $new_width, $new_height, $owidth, $oheight);
    }
    switch ($type) {
        case IMAGETYPE_GIF :
            imagegif($thumb, $thumb_path, 80);
            break;
        case IMAGETYPE_JPEG :
            imagejpeg($thumb, $thumb_path, 80);
            break;
        case IMAGETYPE_PNG :
            imagepng($thumb, $thumb_path, 80);
            break;
        default :
            throw new InvalidArgumentException("Image type $type not supported");
    }
        $thumb_url = $thumb_folder.basename($thumb_path, $fileExtension).$fileExtension; // $file is set to "index";

    $image_array = array(
        'url' => $thumb_url,
        'width' => $thumb_width,
        'height' => $thumb_height,
        'type' => $fileExtension
    );
    return $image_array;
}

// /**
//  *  Deletes the resized images when the original image is deleted from the Wordpress Media Library.
//  *
//  *  @author Matthew Ruddy
//  */
// function su_delete_resized_images($post_id) {

//     // Get attachment image metadata
//     $metadata = wp_get_attachment_metadata($post_id);
//     if (!$metadata)
//         return;

//     // Do some bailing if we cannot continue
//     if (!isset($metadata['file']) || !isset($metadata['image_meta']['resized_images']))
//         return;
//     $pathinfo = pathinfo($metadata['file']);
//     $resized_images = $metadata['image_meta']['resized_images'];

//     // Get Wordpress uploads directory (and bail if it doesn't exist)
//     $wp_upload_dir = wp_upload_dir();
//     $upload_dir = $wp_upload_dir['basedir'];
//     if (!is_dir($upload_dir))
//         return;

//     // Delete the resized images
//     foreach ($resized_images as $dims) {

//         // Get the resized images filename
//         $file = $upload_dir . '/' . $pathinfo['dirname'] . '/' . $pathinfo['filename'] . '-' . $dims . '.' . $pathinfo['extension'];

//         // Delete the resized image
//         @unlink($file);
//     }
// }

//add_action( 'delete_attachment', 'su_delete_resized_images' );

class Su_Tools {

    public static function select($args) {
        $args = wp_parse_args($args, array(
            'id' => '',
            'name' => '',
            'class' => '',
            'multiple' => '',
            'size' => '',
            'disabled' => '',
            'selected' => '',
            'none' => '',
            'options' => array(),
            'style' => '',
            'format' => 'keyval', // keyval/idtext
            'noselect' => '' // return options without <select> tag
        ));
        $options = array();
        if (!is_array($args['options']))
            $args['options'] = array();
        if ($args['id'])
            $args['id'] = ' id="' . $args['id'] . '"';
        if ($args['name'])
            $args['name'] = ' name="' . $args['name'] . '"';
        if ($args['class'])
            $args['class'] = ' class="' . $args['class'] . '"';
        if ($args['style'])
            $args['style'] = ' style="' . esc_attr($args['style']) . '"';
        if ($args['multiple'])
            $args['multiple'] = ' multiple="multiple"';
        if ($args['disabled'])
            $args['disabled'] = ' disabled="disabled"';
        if ($args['size'])
            $args['size'] = ' size="' . $args['size'] . '"';
        if ($args['none'] && $args['format'] === 'keyval')
            $args['options'][0] = $args['none'];
        if ($args['none'] && $args['format'] === 'idtext')
            array_unshift($args['options'], array('id' => '0', 'text' => $args['none']));
        if ($args['format'] === 'keyval')
            foreach ($args['options'] as $id => $text) {
                $options[] = '<option value="' . (string) $id . '">' . (string) $text . '</option>';
            } elseif ($args['format'] === 'idtext')
            foreach ($args['options'] as $option) {
                if (isset($option['id']) && isset($option['text']))
                    $options[] = '<option value="' . (string) $option['id'] . '">' . (string) $option['text'] . '</option>';
            }
        $options = implode('', $options);
        $options = str_replace('value="' . $args['selected'] . '"', 'value="' . $args['selected'] . '" selected="selected"', $options);
        return ( $args['noselect'] ) ? $options : '<select' . $args['id'] . $args['name'] . $args['class'] . $args['multiple'] . $args['size'] . $args['disabled'] . $args['style'] . '>' . $options . '</select>';
    }

    public static function get_categories() {
        $cats = array();
        foreach ((array) get_terms('category', array('hide_empty' => false)) as $cat)
            $cats[$cat->slug] = $cat->name;
        return $cats;
    }

    public static function get_types() {
        $types = array();
        foreach ((array) get_post_types('', 'objects') as $cpt => $cpt_data)
            $types[$cpt] = $cpt_data->label;
        return $types;
    }

    public static function get_users() {
        $users = array();
        foreach ((array) get_users() as $user)
            $users[$user->ID] = $user->data->display_name;
        return $users;
    }

    public static function get_taxonomies() {
        $taxes = array();
        foreach ((array) get_taxonomies('', 'objects') as $tax)
            $taxes[$tax->name] = $tax->label;
        return $taxes;
    }

    public static function getOptions() {
        $options = array();
        $published = array(1);
        $extension = 'com_content';
        // Let's get the id for the current item, either category or content item.
        $jinput = JFactory::getApplication()->input;
        // Load the category options for a given extension.

        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
                ->select('a.id, a.title, a.level, a.published')
                ->from('#__categories AS a')
                ->join('LEFT', $db->quoteName('#__categories') . ' AS b ON a.lft > b.lft AND a.rgt < b.rgt');

        $query->where('(a.extension = ' . $db->quote($extension) . ' )');

        // Filter on the published state

        $query->where('a.published IN (' . implode(',', $published) . ')');

        $query->order('a.lft ASC');
        $db->setQuery($query);
        $row = $db->loadObject();
        // Get the options.

        try {
            $options = $db->loadObjectList();
        } catch (RuntimeException $e) {
            JError::raiseWarning(500, $e->getMessage);
        }

        // Merge any additional options in the XML definition.
        return $options;
    }

    public static function get_category($type, $option) {
        return self::getOptions();
    }

    public static function get_terms($tax = 'category', $key = 'id') {
        $terms = array();
        if ($key === 'id') {
            foreach (self::get_category($tax, array('hide_empty' => false)) as $term) {
                $terms[$term->id] = $term->title;
            }
        } elseif ($key === 'slug') {
            foreach ((array) get_terms($tax, array('hide_empty' => false)) as $term) {
                $terms[$term->slug] = $term->name;
            }
        }
        return $terms;
    }

    public static function getArticles($categoryId) {
        $published = '';
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);

        // Select the required fields from the table.
        $query->select('a.*');
        $query->from('#__content AS a');

        // Join over the language
        $query->select('l.title AS language_title')
                ->join('LEFT', $db->quoteName('#__languages') . ' AS l ON l.lang_code = a.language');

        // Join over the users for the checked out user.
        $query->select('uc.name AS editor')
                ->join('LEFT', '#__users AS uc ON uc.id=a.checked_out');

        // Join over the asset groups.
        $query->select('ag.title AS access_level')
                ->join('LEFT', '#__viewlevels AS ag ON ag.id = a.access');

        // Join over the categories.
        $query->select('c.title AS category_title')
                ->join('LEFT', '#__categories AS c ON c.id = a.catid');

        // Join over the users for the author.
        $query->select('ua.name AS author_name')
                ->join('LEFT', '#__users AS ua ON ua.id = a.created_by');

        // Join over the associations.
        if (JLanguageAssociations::isEnabled()) {
            $query->select('COUNT(asso2.id)>1 as association')
                    ->join('LEFT', '#__associations AS asso ON asso.id = a.id AND asso.context=' . $db->quote('com_content.item'))
                    ->join('LEFT', '#__associations AS asso2 ON asso2.key = asso.key')
                    ->group('a.id');
        }


        // Filter by published state
        if (is_numeric($published)) {
            $query->where('a.state = ' . (int) $published);
        } elseif ($published === '') {
            $query->where('(a.state = 0 OR a.state = 1)');
        }

        // Filter by a single or group of categories.
        $baselevel = 1;

        if (is_numeric($categoryId)) {
            $cat_tbl = JTable::getInstance('Category', 'JTable');
            $cat_tbl->load($categoryId);
            $rgt = $cat_tbl->rgt;
            $lft = $cat_tbl->lft;
            $baselevel = (int) $cat_tbl->level;
            $query->where('c.lft >= ' . (int) $lft)
                    ->where('c.rgt <= ' . (int) $rgt);
        } elseif (is_array($categoryId)) {
            JArrayHelper::toInteger($categoryId);
            $categoryId = implode(',', $categoryId);
            $query->where('a.catid IN (' . $categoryId . ')');
        }
        $db->setQuery($query);
        return $db->loadObjectList();
    }

    public static function get_slides($args) {
        $args = wp_parse_args($args, array(
            'source' => 'none',
            'limit' => 20,
            'gallery' => null,
            'type' => '',
            'link' => 'none'
        ));

        // Get deprecated galleries if needed
        if ($args['gallery'] !== null || ( $args['source'] === 'none' && get_option('su_option_galleries-432') ))
            return self::get_slides_432($args);
        // Prepare empty array for slides
        $slides = array();
        // Loop through source types
        foreach (array('media', 'posts', 'category', 'taxonomy') as $type)
            if (strpos(trim($args['source']), $type . ':') === 0) {
                $args['source'] = array(
                    'type' => $type,
                    'val' => (string) trim(str_replace(array($type . ':', ' '), '', $args['source']), ',')
                );
                break;
            }
        // Source: media
        if ($args['source']['type'] === 'media') {
            $images = (array) explode(',', $args['source']['val']);
            foreach ($images as $post) {

                $slide = array(
                    'image' => $post,
                    'link' => $post,
                    'url' => $post,
                    'title' => ''
                );
                if ($args['link'] === 'image') {
                    $slide['link'] = $slide['image'];
                }
                $slides[] = $slide;
            }
            return $slides;
        }
        //end trung truong
        // Source is not parsed correctly, return empty array
        if (!is_array($args['source']))
            return $slides;
        // Default posts query
        $query = array('posts_per_page' => $args['limit']);

        // Source: posts
        if ($args['source']['type'] === 'posts') {
            if ($args['source']['val'] !== 'recent') {
                $query['post__in'] = (array) explode(',', $args['source']['val']);
                $query['orderby'] = 'post__in';
            }
        }
        // Source: category
        elseif ($args['source']['type'] === 'category') {
            $catid = (array) explode(',', $args['source']['val']);
            $results = self::getArticles($catid);
        }
        // Source: taxonomy
        elseif ($args['source']['type'] === 'taxonomy') {
            // Parse taxonomy name and terms ids
            $args['source']['val'] = explode('/', $args['source']['val']);
            // Taxonomy parsed incorrectly, return empty array
            if (!is_array($args['source']['val']) || count($args['source']['val']) !== 2)
                return $slides;
            $query['tax_query'] = array(
                array(
                    'taxonomy' => $args['source']['val'][0],
                    'field' => 'id',
                    'terms' => (array) explode(',', $args['source']['val'][1])
                )
            );
        }

        // Loop through posts
        if (is_array($results))
            foreach ($results as $post) {
                // Get post thumbnail ID
                $thumb = ( $args['source']['type'] === 'media' ) ? $post->id : get_post_thumbnail_id($post);
                // Thumbnail isn't set, go to next post
                if ((!$thumb))
                    continue;
                $slide = array(
                    'image' => ($thumb),
                    'link' => get_post_image($post),
//            'url' => get_post_image($post),
                    'title' => ($post->title)
                );
                if ($args['link'] === 'image')
                    $slide['link'] = $slide['image'];
//	elseif ($args['link'] === 'post')
//	  $slide['link'] = get_permalink($post->ID);
                elseif ($args['link'] === 'attachment')
                    $slide['link'] = get_attachment_link($thumb);
                $slides[] = $slide;
            }
        // Return slides
        return $slides;
    }

    public static function get_slides_432($args) {
        $args = wp_parse_args($args, array(
            'gallery' => 1
        ));
        $slides = array();
        $args['gallery'] = ( $args['gallery'] === null ) ? 0 : $args['gallery'] - 1;
        $galleries = get_option('su_option_galleries-432');
        // No galleries found
        if (!is_array($galleries))
            return $slides;
        // If galleries found loop through them
        if (isset($galleries[$args['gallery']]))
            $slides = $galleries[$args['gallery']]['items'];
        // Return slides
        return $slides;
    }

    public static function example() {
        // Check authentication
        self::access();
        // Check incoming data
        if (!isset($_REQUEST['code']) || !isset($_REQUEST['id']))
            return;
        // Check for cache
        $output = get_transient('su/examples/render/' . sanitize_key($_REQUEST['id']));
        if ($output && SU_ENABLE_CACHE)
            echo $output;
        // Cache not found
        else {
            ob_start();
            // Prepare data
            $code = file_get_contents(sanitize_text_field($_REQUEST['code']));
            // Check for code
            if (!$code)
                die('<p class="su-examples-error">' . __('Example code does not found, please check it later', 'su') . '</p>');
            // Clean-up the code
            $code = str_replace(array("\t", '%su_'), array('  ', su_cmpt()), $code);
            // Split code
            $chunks = explode('-----', $code);
            // Show snippets
            do_action('su/examples/preview/before');
            foreach ($chunks as $chunk) {
                // Clean-up new lines
                $chunk = trim($chunk, "\n\r");
                // Calc textarea rows
                $rows = substr_count($chunk, "\n");
                $rows = ( $rows < 4 ) ? '4' : (string) ( $rows + 1 );
                $rows = ( $rows > 20 ) ? '20' : (string) ( $rows + 1 );
                echo wpautop(do_shortcode($chunk));
                echo '<div style="clear:both"></div>';
                echo '<div class="su-examples-code"><span class="su-examples-get-code button"><i class="fa fa-code"></i>&nbsp;&nbsp;' . __('Get the code', 'su') . '</span><textarea rows="' . $rows . '">' . esc_textarea($chunk) . '</textarea></div>';
            }
            do_action('su/examples/preview/after');
            $output = ob_get_contents();
            ob_end_clean();
            set_transient('su/examples/render/' . sanitize_key($_REQUEST['id']), $output);
            echo $output;
        }
        die();
    }

    public static function reset_examples() {
        foreach ((array) Su_Data::examples() as $example)
            foreach ((array) $example['items'] as $item)
                delete_transient('su/examples/render/' . $item['id']);
    }

    public static function do_attr($value) {
        return do_shortcode(str_replace(array('{', '}'), array('[', ']'), $value));
    }

    public static function icon($src = 'file') {
        return ( strpos($src, '/') !== false ) ? '<img src="' . $src . '" alt="" />' : '<i class="fa fa-' . $src . '"></i>';
    }

    public static function get_icon($args) {
        $args = wp_parse_args($args, array(
            'icon' => '',
            'size' => '',
            'color' => '',
            'style' => ''
        ));
        // Check for icon param
        if (!$args['icon'])
            return;
        // Add trailing ; to the style param
        if ($args['style'])
            $args['style'] = rtrim($args['style'], ';') . ';';
        // Font Awesome icon
        if (strpos($args['icon'], 'icon:') !== false) {
            // Add size
            if ($args['size'])
                $args['style'] .= 'font-size:' . $args['size'] . 'px;';
            // Add color
            if ($args['color'])
                $args['style'] .= 'color:' . $args['color'] . ';';
            // Query font-awesome stylesheet
            su_query_asset('css', 'font-awesome');
            // Return icon
            return '<i class="fa fa-' . trim(str_replace('icon:', '', $args['icon'])) . '" style="' . $args['style'] . '"></i>';
        }
        // Image icon
        elseif (strpos($args['icon'], '/') !== false) {
            // Add size
            if ($args['size'])
                $args['style'] .= 'width:' . $args['size'] . 'px;height:' . $args['size'] . 'px;';
            // Return icon
            return '<img src="' . $args['icon'] . '" alt="" style="' . $args['style'] . '" />';
        }
        // Icon is not detected
        return false;
    }

    public static function icons() {
        $icons = array();
        if (is_callable(array('Su_Data', 'icons')))
            foreach ((array) Su_Data::icons() as $icon) {
                $icons[] = '<i class="fa fa-' . $icon . '" title="' . $icon . '"></i>';
            }
        return implode('', $icons);
    }

    public static function access() {
        if (!self::access_check())
            wp_die(__('Access denied', 'su'));
    }

    public static function access_check() {
        return current_user_can('edit_posts');
    }

}

new Su_Tools;

/**
 * Shortcut for Su_Tools::decode_shortcode()
 */
function su_scattr($value) {
    return Su_Tools::do_attr($value);
}

/**
 * Shortcut for Su_Tools::get_icon()
 */
function su_get_icon($args) {
    return Su_Tools::get_icon($args);
}
