CREATE TABLE IF NOT EXISTS `#__bwg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `preview_image` mediumtext NOT NULL,
  `random_preview_image` mediumtext NOT NULL,
  `order` bigint(20) NOT NULL,
  `author` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `#__bwg_album_gallery` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `album_id` bigint(20) NOT NULL,
  `is_album` tinyint(1) NOT NULL,
  `alb_gal_id` bigint(20) NOT NULL,
  `order` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;




CREATE TABLE IF NOT EXISTS `#__bwg_gallery` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `page_link` mediumtext NOT NULL,
  `preview_image` mediumtext NOT NULL,
  `random_preview_image` mediumtext NOT NULL,
  `order` bigint(20) NOT NULL,
  `author` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `#__bwg_image` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `gallery_id` bigint(20) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `image_url` mediumtext NOT NULL,
  `thumb_url` mediumtext NOT NULL,
  `description` mediumtext NOT NULL,
  `alt` mediumtext NOT NULL,
  `date` varchar(128) NOT NULL,
  `size` varchar(128) NOT NULL,
  `filetype` varchar(128) NOT NULL,
  `resolution` varchar(128) NOT NULL,
  `author` bigint(20) NOT NULL,
  `order` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `comment_count` bigint(20) NOT NULL,
  `avg_rating` float NOT NULL,
  `rate_count` bigint(20) NOT NULL,
  `hit_count` bigint(20) NOT NULL,
  `redirect_url` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `#__bwg_image_comment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL,
  `date` varchar(64) NOT NULL,
  `comment` mediumtext NOT NULL,
  `url` mediumtext NOT NULL,
  `mail` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `#__bwg_image_rate` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_id` bigint(20) NOT NULL,
  `rate` float NOT NULL,
  `ip` varchar(64) NOT NULL,
  `date` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `#__bwg_image_tag` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) NOT NULL,
  `image_id` bigint(20) NOT NULL,
  `gallery_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=77 ;



CREATE TABLE IF NOT EXISTS `#__bwg_option` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `images_directory` mediumtext NOT NULL,
  `masonry` varchar(255) NOT NULL,
  `image_column_number` int(4) NOT NULL,
  `images_per_page` int(4) NOT NULL,
  `thumb_width` int(4) NOT NULL,
  `thumb_height` int(4) NOT NULL,
  `upload_thumb_width` int(4) NOT NULL,
  `upload_thumb_height` int(4) NOT NULL,
  `image_enable_page` tinyint(1) NOT NULL,
  `image_title_show_hover` varchar(20) NOT NULL,
  `album_column_number` int(4) NOT NULL,
  `albums_per_page` int(4) NOT NULL,
  `album_title_show_hover` varchar(255) NOT NULL,
  `album_thumb_width` int(4) NOT NULL,
  `album_thumb_height` int(4) NOT NULL,
  `album_enable_page` tinyint(1) NOT NULL,
  `extended_album_height` int(4) NOT NULL,
  `extended_album_description_enable` tinyint(1) NOT NULL,
  `image_browser_width` int(4) NOT NULL,
  `image_browser_title_enable` tinyint(1) NOT NULL,
  `image_browser_description_enable` tinyint(1) NOT NULL,
  `blog_style_width` int(4) NOT NULL,
  `blog_style_title_enable` tinyint(1) NOT NULL,
  `blog_style_images_per_page` int(4) NOT NULL,
  `blog_style_enable_page` tinyint(1) NOT NULL,
  `slideshow_type` varchar(255) NOT NULL,
  `slideshow_interval` int(4) NOT NULL,
  `slideshow_width` int(4) NOT NULL,
  `slideshow_height` int(4) NOT NULL,
  `slideshow_enable_autoplay` tinyint(1) NOT NULL,
  `slideshow_enable_shuffle` tinyint(1) NOT NULL,
  `slideshow_enable_ctrl` tinyint(1) NOT NULL,
  `slideshow_enable_filmstrip` tinyint(1) NOT NULL,
  `slideshow_filmstrip_height` int(4) NOT NULL,
  `slideshow_enable_title` tinyint(1) NOT NULL,
  `slideshow_title_position` varchar(255) NOT NULL,
  `slideshow_enable_description` tinyint(1) NOT NULL,
  `slideshow_description_position` varchar(255) NOT NULL,
  `slideshow_enable_music` tinyint(1) NOT NULL,
  `slideshow_audio_url` varchar(255) NOT NULL,
  `popup_width` int(4) NOT NULL,
  `popup_height` int(4) NOT NULL,
  `popup_type` varchar(255) NOT NULL,
  `popup_interval` int(4) NOT NULL,
  `popup_enable_filmstrip` tinyint(1) NOT NULL,
  `popup_filmstrip_height` int(4) NOT NULL,
  `popup_enable_ctrl_btn` tinyint(1) NOT NULL,
  `popup_enable_fullscreen` tinyint(1) NOT NULL,
  `popup_enable_info` tinyint(1) NOT NULL,
  `popup_info_always_show` tinyint(1) NOT NULL,
  `popup_enable_rate` tinyint(1) NOT NULL,
  `popup_enable_comment` tinyint(1) NOT NULL,
  `popup_enable_email` tinyint(1) NOT NULL,
  `popup_enable_captcha` tinyint(1) NOT NULL,
  `popup_enable_download` tinyint(1) NOT NULL,
  `popup_enable_fullsize_image` tinyint(1) NOT NULL,
  `popup_enable_facebook` tinyint(1) NOT NULL,
  `popup_enable_twitter` tinyint(1) NOT NULL,
  `popup_enable_google` tinyint(1) NOT NULL,
  `watermark_type` varchar(255) NOT NULL,
  `watermark_position` varchar(255) NOT NULL,
  `watermark_width` int(4) NOT NULL,
  `watermark_height` int(4) NOT NULL,
  `watermark_url` mediumtext NOT NULL,
  `watermark_text` mediumtext NOT NULL,
  `watermark_link` mediumtext NOT NULL,
  `watermark_font_size` int(4) NOT NULL,
  `watermark_font` varchar(255) NOT NULL,
  `watermark_color` varchar(255) NOT NULL,
  `watermark_opacity` int(4) NOT NULL,
  `built_in_watermark_type` varchar(255) NOT NULL,
  `built_in_watermark_position` varchar(255) NOT NULL,
  `built_in_watermark_size` int(4) NOT NULL,
  `built_in_watermark_url` mediumtext NOT NULL,
  `built_in_watermark_text` mediumtext NOT NULL,
  `built_in_watermark_font_size` int(4) NOT NULL,
  `built_in_watermark_font` varchar(255) NOT NULL,
  `built_in_watermark_color` varchar(255) NOT NULL,
  `built_in_watermark_opacity` int(4) NOT NULL,
  `image_right_click` tinyint(1) NOT NULL,
  `popup_fullscreen` tinyint(1) NOT NULL,
  `gallery_role` tinyint(1) NOT NULL,
  `album_role` tinyint(1) NOT NULL,
  `image_role` tinyint(1) NOT NULL,
  `popup_autoplay` tinyint(1) NOT NULL,
  `album_view_type` varchar(16) NOT NULL,
  `popup_enable_pinterest` tinyint(1) NOT NULL,
  `popup_enable_tumblr` tinyint(1) NOT NULL,
  `show_search_box` tinyint(1) NOT NULL,
  `search_box_width` int(4) NOT NULL,
  `preload_images` tinyint(1) NOT NULL,
  `preload_images_count` int(11) NOT NULL,
  `thumb_click_action` varchar(16) NOT NULL,
  `thumb_link_target` tinyint(1) NOT NULL,
  `comment_moderation` tinyint(1) NOT NULL,
  `popup_hit_counter` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `#__bwg_option`
--

INSERT INTO `#__bwg_option` (`id`, `images_directory`, `masonry`, `image_column_number`, `images_per_page`, `thumb_width`, `thumb_height`, `upload_thumb_width`, `upload_thumb_height`, `image_enable_page`, `image_title_show_hover`, `album_column_number`, `albums_per_page`, `album_title_show_hover`, `album_thumb_width`, `album_thumb_height`, `album_enable_page`, `extended_album_height`, `extended_album_description_enable`, `image_browser_width`, `image_browser_title_enable`, `image_browser_description_enable`, `blog_style_width`, `blog_style_title_enable`, `blog_style_images_per_page`, `blog_style_enable_page`, `slideshow_type`, `slideshow_interval`, `slideshow_width`, `slideshow_height`, `slideshow_enable_autoplay`, `slideshow_enable_shuffle`, `slideshow_enable_ctrl`, `slideshow_enable_filmstrip`, `slideshow_filmstrip_height`, `slideshow_enable_title`, `slideshow_title_position`, `slideshow_enable_description`, `slideshow_description_position`, `slideshow_enable_music`, `slideshow_audio_url`, `popup_width`, `popup_height`, `popup_type`, `popup_interval`, `popup_enable_filmstrip`, `popup_filmstrip_height`, `popup_enable_ctrl_btn`, `popup_enable_fullscreen`, `popup_enable_info`, `popup_info_always_show`, `popup_enable_rate`, `popup_enable_comment`, `popup_enable_email`, `popup_enable_captcha`, `popup_enable_download`, `popup_enable_fullsize_image`, `popup_enable_facebook`, `popup_enable_twitter`, `popup_enable_google`, `watermark_type`, `watermark_position`, `watermark_width`, `watermark_height`, `watermark_url`, `watermark_text`, `watermark_link`, `watermark_font_size`, `watermark_font`, `watermark_color`, `watermark_opacity`, `built_in_watermark_type`, `built_in_watermark_position`, `built_in_watermark_size`, `built_in_watermark_url`, `built_in_watermark_text`, `built_in_watermark_font_size`, `built_in_watermark_font`, `built_in_watermark_color`, `built_in_watermark_opacity`, `image_right_click`, `popup_fullscreen`, `gallery_role`, `album_role`, `image_role`, `popup_autoplay`, `album_view_type`, `popup_enable_pinterest`, `popup_enable_tumblr`, `show_search_box`, `search_box_width`, `preload_images`, `preload_images_count`, `thumb_click_action`, `thumb_link_target`, `comment_moderation`, `popup_hit_counter`) VALUES
(1, 'media', 'vertical', 5, 30, 180, 90, 300, 300, 1, 'none', 5, 30, 'hover', 120, 90, 1, 150, 1, 800, 1, 1, 800, 1, 5, 1, 'fade', 5, 800, 500, 0, 0, 1, 1, 90, 0, 'top-right', 0, 'bottom-right', 0, '', 800, 500, 'fade', 5, 1, 70, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 'none', 'bottom-left', 90, 90, 'components/com_gallery_wd/images/watermark.png', 'https://web-dorado.com', 'https://web-dorado.com', 20, 'Arial', 'FFFFFF', 30, 'none', 'middle-center', 15, 'components/com_gallery_wd/images/watermark.png', 'https://web-dorado.com', 20, 'arial.ttf', 'FFFFFF', 30, 0, 0, 0, 0, 0, 0, 'thumbnail', 0, 0, 0, 180, 1, 10, 'open_lightbox', 1, 0, 0);



CREATE TABLE IF NOT EXISTS `#__bwg_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `slug` varchar(100) NOT NULL,
  `count` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;




CREATE TABLE IF NOT EXISTS `#__bwg_theme` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `thumb_margin` int(4) NOT NULL,
  `thumb_padding` int(4) NOT NULL,
  `thumb_border_radius` varchar(128) NOT NULL,
  `thumb_border_width` int(4) NOT NULL,
  `thumb_border_style` varchar(128) NOT NULL,
  `thumb_border_color` varchar(128) NOT NULL,
  `thumb_bg_color` varchar(128) NOT NULL,
  `thumbs_bg_color` varchar(128) NOT NULL,
  `thumb_bg_transparent` int(4) NOT NULL,
  `thumb_box_shadow` varchar(128) NOT NULL,
  `thumb_transparent` int(4) NOT NULL,
  `thumb_align` varchar(128) NOT NULL,
  `thumb_hover_effect` varchar(128) NOT NULL,
  `thumb_hover_effect_value` varchar(128) NOT NULL,
  `thumb_transition` tinyint(1) NOT NULL,
  `thumb_title_font_color` varchar(64) NOT NULL,
  `thumb_title_font_style` varchar(64) NOT NULL,
  `thumb_title_pos` varchar(8) NOT NULL,
  `thumb_title_font_size` int(4) NOT NULL,
  `thumb_title_font_weight` varchar(64) NOT NULL,
  `thumb_title_margin` varchar(64) NOT NULL,
  `thumb_title_shadow` varchar(64) NOT NULL,
  `page_nav_position` varchar(64) NOT NULL,
  `page_nav_align` varchar(64) NOT NULL,
  `page_nav_number` tinyint(1) NOT NULL,
  `page_nav_font_size` int(4) NOT NULL,
  `page_nav_font_style` varchar(64) NOT NULL,
  `page_nav_font_color` varchar(64) NOT NULL,
  `page_nav_font_weight` varchar(64) NOT NULL,
  `page_nav_border_width` int(4) NOT NULL,
  `page_nav_border_style` varchar(64) NOT NULL,
  `page_nav_border_color` varchar(64) NOT NULL,
  `page_nav_border_radius` varchar(128) NOT NULL,
  `page_nav_margin` varchar(128) NOT NULL,
  `page_nav_padding` varchar(128) NOT NULL,
  `page_nav_button_bg_color` varchar(64) NOT NULL,
  `page_nav_button_bg_transparent` int(4) NOT NULL,
  `page_nav_box_shadow` varchar(128) NOT NULL,
  `page_nav_button_transition` tinyint(1) NOT NULL,
  `page_nav_button_text` tinyint(1) NOT NULL,
  `lightbox_overlay_bg_color` varchar(64) NOT NULL,
  `lightbox_overlay_bg_transparent` int(4) NOT NULL,
  `lightbox_bg_color` varchar(64) NOT NULL,
  `lightbox_ctrl_btn_pos` varchar(64) NOT NULL,
  `lightbox_ctrl_btn_align` varchar(64) NOT NULL,
  `lightbox_ctrl_btn_height` int(4) NOT NULL,
  `lightbox_ctrl_btn_margin_top` int(4) NOT NULL,
  `lightbox_ctrl_btn_margin_left` int(4) NOT NULL,
  `lightbox_ctrl_btn_transparent` int(4) NOT NULL,
  `lightbox_ctrl_btn_color` varchar(64) NOT NULL,
  `lightbox_toggle_btn_height` int(4) NOT NULL,
  `lightbox_toggle_btn_width` int(4) NOT NULL,
  `lightbox_ctrl_cont_bg_color` varchar(64) NOT NULL,
  `lightbox_ctrl_cont_transparent` int(4) NOT NULL,
  `lightbox_ctrl_cont_border_radius` int(4) NOT NULL,
  `lightbox_close_btn_transparent` int(4) NOT NULL,
  `lightbox_close_btn_bg_color` varchar(64) NOT NULL,
  `lightbox_close_btn_border_width` int(4) NOT NULL,
  `lightbox_close_btn_border_radius` varchar(128) NOT NULL,
  `lightbox_close_btn_border_style` varchar(128) NOT NULL,
  `lightbox_close_btn_border_color` varchar(64) NOT NULL,
  `lightbox_close_btn_box_shadow` varchar(128) NOT NULL,
  `lightbox_close_btn_color` varchar(64) NOT NULL,
  `lightbox_close_btn_size` int(4) NOT NULL,
  `lightbox_close_btn_width` int(4) NOT NULL,
  `lightbox_close_btn_height` int(4) NOT NULL,
  `lightbox_close_btn_top` varchar(64) NOT NULL,
  `lightbox_close_btn_right` varchar(64) NOT NULL,
  `lightbox_close_btn_full_color` varchar(64) NOT NULL,
  `lightbox_rl_btn_bg_color` varchar(64) NOT NULL,
  `lightbox_rl_btn_transparent` int(4) NOT NULL,
  `lightbox_rl_btn_border_radius` varchar(64) NOT NULL,
  `lightbox_rl_btn_border_width` int(4) NOT NULL,
  `lightbox_rl_btn_border_style` varchar(64) NOT NULL,
  `lightbox_rl_btn_border_color` varchar(64) NOT NULL,
  `lightbox_rl_btn_box_shadow` varchar(128) NOT NULL,
  `lightbox_rl_btn_color` varchar(64) NOT NULL,
  `lightbox_rl_btn_height` int(4) NOT NULL,
  `lightbox_rl_btn_width` int(4) NOT NULL,
  `lightbox_rl_btn_size` int(4) NOT NULL,
  `lightbox_close_rl_btn_hover_color` varchar(64) NOT NULL,
  `lightbox_comment_pos` varchar(64) NOT NULL,
  `lightbox_comment_width` int(4) NOT NULL,
  `lightbox_comment_bg_color` varchar(64) NOT NULL,
  `lightbox_comment_font_color` varchar(64) NOT NULL,
  `lightbox_comment_font_style` varchar(64) NOT NULL,
  `lightbox_comment_font_size` int(4) NOT NULL,
  `lightbox_comment_button_bg_color` varchar(64) NOT NULL,
  `lightbox_comment_button_border_color` varchar(64) NOT NULL,
  `lightbox_comment_button_border_width` int(4) NOT NULL,
  `lightbox_comment_button_border_style` varchar(64) NOT NULL,
  `lightbox_comment_button_border_radius` varchar(64) NOT NULL,
  `lightbox_comment_button_padding` varchar(64) NOT NULL,
  `lightbox_comment_input_bg_color` varchar(64) NOT NULL,
  `lightbox_comment_input_border_color` varchar(64) NOT NULL,
  `lightbox_comment_input_border_width` int(4) NOT NULL,
  `lightbox_comment_input_border_style` varchar(64) NOT NULL,
  `lightbox_comment_input_border_radius` varchar(64) NOT NULL,
  `lightbox_comment_input_padding` varchar(64) NOT NULL,
  `lightbox_comment_separator_width` int(4) NOT NULL,
  `lightbox_comment_separator_style` varchar(64) NOT NULL,
  `lightbox_comment_separator_color` varchar(64) NOT NULL,
  `lightbox_comment_author_font_size` int(4) NOT NULL,
  `lightbox_comment_date_font_size` int(4) NOT NULL,
  `lightbox_comment_body_font_size` int(4) NOT NULL,
  `lightbox_comment_share_button_color` varchar(64) NOT NULL,
  `lightbox_filmstrip_pos` varchar(64) NOT NULL,
  `lightbox_filmstrip_rl_bg_color` varchar(64) NOT NULL,
  `lightbox_filmstrip_rl_btn_size` int(4) NOT NULL,
  `lightbox_filmstrip_rl_btn_color` varchar(64) NOT NULL,
  `lightbox_filmstrip_thumb_margin` varchar(64) NOT NULL,
  `lightbox_filmstrip_thumb_border_width` int(4) NOT NULL,
  `lightbox_filmstrip_thumb_border_style` varchar(64) NOT NULL,
  `lightbox_filmstrip_thumb_border_color` varchar(64) NOT NULL,
  `lightbox_filmstrip_thumb_border_radius` varchar(64) NOT NULL,
  `lightbox_filmstrip_thumb_deactive_transparent` int(4) NOT NULL,
  `lightbox_filmstrip_thumb_active_border_width` int(4) NOT NULL,
  `lightbox_filmstrip_thumb_active_border_color` varchar(64) NOT NULL,
  `lightbox_rl_btn_style` varchar(64) NOT NULL,
  `album_compact_back_font_color` varchar(64) NOT NULL,
  `album_compact_back_font_style` varchar(64) NOT NULL,
  `album_compact_back_font_size` int(4) NOT NULL,
  `album_compact_back_font_weight` varchar(64) NOT NULL,
  `album_compact_back_padding` varchar(64) NOT NULL,
  `album_compact_title_font_color` varchar(64) NOT NULL,
  `album_compact_title_font_style` varchar(64) NOT NULL,
  `album_compact_thumb_title_pos` varchar(8) NOT NULL,
  `album_compact_title_font_size` int(4) NOT NULL,
  `album_compact_title_font_weight` varchar(64) NOT NULL,
  `album_compact_title_margin` varchar(64) NOT NULL,
  `album_compact_title_shadow` varchar(64) NOT NULL,
  `album_compact_thumb_margin` int(4) NOT NULL,
  `album_compact_thumb_padding` int(4) NOT NULL,
  `album_compact_thumb_border_radius` varchar(128) NOT NULL,
  `album_compact_thumb_border_width` int(4) NOT NULL,
  `album_compact_thumb_border_style` varchar(128) NOT NULL,
  `album_compact_thumb_border_color` varchar(128) NOT NULL,
  `album_compact_thumb_bg_color` varchar(128) NOT NULL,
  `album_compact_thumbs_bg_color` varchar(128) NOT NULL,
  `album_compact_thumb_bg_transparent` int(4) NOT NULL,
  `album_compact_thumb_box_shadow` varchar(128) NOT NULL,
  `album_compact_thumb_transparent` int(4) NOT NULL,
  `album_compact_thumb_align` varchar(128) NOT NULL,
  `album_compact_thumb_hover_effect` varchar(128) NOT NULL,
  `album_compact_thumb_hover_effect_value` varchar(128) NOT NULL,
  `album_compact_thumb_transition` tinyint(1) NOT NULL,
  `album_extended_thumb_margin` int(4) NOT NULL,
  `album_extended_thumb_padding` int(4) NOT NULL,
  `album_extended_thumb_border_radius` varchar(128) NOT NULL,
  `album_extended_thumb_border_width` int(4) NOT NULL,
  `album_extended_thumb_border_style` varchar(128) NOT NULL,
  `album_extended_thumb_border_color` varchar(128) NOT NULL,
  `album_extended_thumb_bg_color` varchar(128) NOT NULL,
  `album_extended_thumbs_bg_color` varchar(128) NOT NULL,
  `album_extended_thumb_bg_transparent` int(4) NOT NULL,
  `album_extended_thumb_box_shadow` varchar(128) NOT NULL,
  `album_extended_thumb_transparent` int(4) NOT NULL,
  `album_extended_thumb_align` varchar(128) NOT NULL,
  `album_extended_thumb_hover_effect` varchar(128) NOT NULL,
  `album_extended_thumb_hover_effect_value` varchar(128) NOT NULL,
  `album_extended_thumb_transition` tinyint(1) NOT NULL,
  `album_extended_back_font_color` varchar(64) NOT NULL,
  `album_extended_back_font_style` varchar(64) NOT NULL,
  `album_extended_back_font_size` int(4) NOT NULL,
  `album_extended_back_font_weight` varchar(64) NOT NULL,
  `album_extended_back_padding` varchar(64) NOT NULL,
  `album_extended_div_bg_color` varchar(64) NOT NULL,
  `album_extended_div_bg_transparent` int(4) NOT NULL,
  `album_extended_div_border_radius` varchar(64) NOT NULL,
  `album_extended_div_margin` varchar(64) NOT NULL,
  `album_extended_div_padding` int(4) NOT NULL,
  `album_extended_div_separator_width` int(4) NOT NULL,
  `album_extended_div_separator_style` varchar(64) NOT NULL,
  `album_extended_div_separator_color` varchar(64) NOT NULL,
  `album_extended_thumb_div_bg_color` varchar(64) NOT NULL,
  `album_extended_thumb_div_border_radius` varchar(64) NOT NULL,
  `album_extended_thumb_div_border_width` int(4) NOT NULL,
  `album_extended_thumb_div_border_style` varchar(64) NOT NULL,
  `album_extended_thumb_div_border_color` varchar(64) NOT NULL,
  `album_extended_thumb_div_padding` varchar(64) NOT NULL,
  `album_extended_text_div_bg_color` varchar(64) NOT NULL,
  `album_extended_text_div_border_radius` varchar(64) NOT NULL,
  `album_extended_text_div_border_width` int(4) NOT NULL,
  `album_extended_text_div_border_style` varchar(64) NOT NULL,
  `album_extended_text_div_border_color` varchar(64) NOT NULL,
  `album_extended_text_div_padding` varchar(64) NOT NULL,
  `album_extended_title_span_border_width` int(4) NOT NULL,
  `album_extended_title_span_border_style` varchar(64) NOT NULL,
  `album_extended_title_span_border_color` varchar(64) NOT NULL,
  `album_extended_title_font_color` varchar(64) NOT NULL,
  `album_extended_title_font_style` varchar(64) NOT NULL,
  `album_extended_title_font_size` int(4) NOT NULL,
  `album_extended_title_font_weight` varchar(64) NOT NULL,
  `album_extended_title_margin_bottom` int(4) NOT NULL,
  `album_extended_title_padding` varchar(64) NOT NULL,
  `album_extended_desc_span_border_width` int(4) NOT NULL,
  `album_extended_desc_span_border_style` varchar(64) NOT NULL,
  `album_extended_desc_span_border_color` varchar(64) NOT NULL,
  `album_extended_desc_font_color` varchar(64) NOT NULL,
  `album_extended_desc_font_style` varchar(64) NOT NULL,
  `album_extended_desc_font_size` int(4) NOT NULL,
  `album_extended_desc_font_weight` varchar(64) NOT NULL,
  `album_extended_desc_padding` varchar(64) NOT NULL,
  `album_extended_desc_more_color` varchar(64) NOT NULL,
  `album_extended_desc_more_size` int(4) NOT NULL,
  `masonry_thumb_padding` int(4) NOT NULL,
  `masonry_thumb_border_radius` varchar(128) NOT NULL,
  `masonry_thumb_border_width` int(4) NOT NULL,
  `masonry_thumb_border_style` varchar(128) NOT NULL,
  `masonry_thumb_border_color` varchar(128) NOT NULL,
  `masonry_thumbs_bg_color` varchar(128) NOT NULL,
  `masonry_thumb_bg_transparent` int(4) NOT NULL,
  `masonry_thumb_transparent` int(4) NOT NULL,
  `masonry_thumb_align` varchar(128) NOT NULL,
  `masonry_thumb_hover_effect` varchar(128) NOT NULL,
  `masonry_thumb_hover_effect_value` varchar(128) NOT NULL,
  `masonry_thumb_transition` tinyint(1) NOT NULL,
  `slideshow_cont_bg_color` varchar(64) NOT NULL,
  `slideshow_close_btn_transparent` int(4) NOT NULL,
  `slideshow_rl_btn_bg_color` varchar(64) NOT NULL,
  `slideshow_rl_btn_border_radius` varchar(64) NOT NULL,
  `slideshow_rl_btn_border_width` int(4) NOT NULL,
  `slideshow_rl_btn_border_style` varchar(64) NOT NULL,
  `slideshow_rl_btn_border_color` varchar(64) NOT NULL,
  `slideshow_rl_btn_box_shadow` varchar(128) NOT NULL,
  `slideshow_rl_btn_color` varchar(64) NOT NULL,
  `slideshow_rl_btn_height` int(4) NOT NULL,
  `slideshow_rl_btn_size` int(4) NOT NULL,
  `slideshow_rl_btn_width` int(4) NOT NULL,
  `slideshow_close_rl_btn_hover_color` varchar(64) NOT NULL,
  `slideshow_filmstrip_pos` varchar(64) NOT NULL,
  `slideshow_filmstrip_thumb_border_width` int(4) NOT NULL,
  `slideshow_filmstrip_thumb_border_style` varchar(64) NOT NULL,
  `slideshow_filmstrip_thumb_border_color` varchar(64) NOT NULL,
  `slideshow_filmstrip_thumb_border_radius` varchar(64) NOT NULL,
  `slideshow_filmstrip_thumb_margin` varchar(64) NOT NULL,
  `slideshow_filmstrip_thumb_active_border_width` int(4) NOT NULL,
  `slideshow_filmstrip_thumb_active_border_color` varchar(64) NOT NULL,
  `slideshow_filmstrip_thumb_deactive_transparent` int(4) NOT NULL,
  `slideshow_filmstrip_rl_bg_color` varchar(64) NOT NULL,
  `slideshow_filmstrip_rl_btn_color` varchar(64) NOT NULL,
  `slideshow_filmstrip_rl_btn_size` int(4) NOT NULL,
  `slideshow_title_font_size` int(4) NOT NULL,
  `slideshow_title_font` varchar(64) NOT NULL,
  `slideshow_title_color` varchar(64) NOT NULL,
  `slideshow_title_opacity` int(4) NOT NULL,
  `slideshow_title_border_radius` varchar(64) NOT NULL,
  `slideshow_title_background_color` varchar(64) NOT NULL,
  `slideshow_title_padding` varchar(64) NOT NULL,
  `slideshow_description_font_size` int(4) NOT NULL,
  `slideshow_description_font` varchar(64) NOT NULL,
  `slideshow_description_color` varchar(64) NOT NULL,
  `slideshow_description_opacity` int(4) NOT NULL,
  `slideshow_description_border_radius` varchar(64) NOT NULL,
  `slideshow_description_background_color` varchar(64) NOT NULL,
  `slideshow_description_padding` varchar(64) NOT NULL,
  `slideshow_dots_width` int(4) NOT NULL,
  `slideshow_dots_height` int(4) NOT NULL,
  `slideshow_dots_border_radius` varchar(64) NOT NULL,
  `slideshow_dots_background_color` varchar(64) NOT NULL,
  `slideshow_dots_margin` int(4) NOT NULL,
  `slideshow_dots_active_background_color` varchar(64) NOT NULL,
  `slideshow_dots_active_border_width` int(4) NOT NULL,
  `slideshow_dots_active_border_color` varchar(64) NOT NULL,
  `slideshow_play_pause_btn_size` int(4) NOT NULL,
  `slideshow_rl_btn_style` varchar(64) NOT NULL,
  `blog_style_margin` varchar(128) NOT NULL,
  `blog_style_padding` varchar(128) NOT NULL,
  `blog_style_border_radius` varchar(128) NOT NULL,
  `blog_style_border_width` int(4) NOT NULL,
  `blog_style_border_style` varchar(128) NOT NULL,
  `blog_style_border_color` varchar(128) NOT NULL,
  `blog_style_bg_color` varchar(128) NOT NULL,
  `blog_style_box_shadow` varchar(128) NOT NULL,
  `blog_style_transparent` int(4) NOT NULL,
  `blog_style_align` varchar(128) NOT NULL,
  `blog_style_share_buttons_bg_color` varchar(128) NOT NULL,
  `blog_style_share_buttons_margin` varchar(128) NOT NULL,
  `blog_style_share_buttons_border_radius` varchar(128) NOT NULL,
  `blog_style_share_buttons_border_width` int(4) NOT NULL,
  `blog_style_share_buttons_border_style` varchar(128) NOT NULL,
  `blog_style_share_buttons_border_color` varchar(128) NOT NULL,
  `blog_style_share_buttons_align` varchar(128) NOT NULL,
  `blog_style_img_font_size` int(4) NOT NULL,
  `blog_style_img_font_family` varchar(128) NOT NULL,
  `blog_style_img_font_color` varchar(128) NOT NULL,
  `blog_style_share_buttons_color` varchar(128) NOT NULL,
  `blog_style_share_buttons_bg_transparent` int(4) NOT NULL,
  `blog_style_share_buttons_font_size` int(4) NOT NULL,
  `image_browser_margin` varchar(128) NOT NULL,
  `image_browser_padding` varchar(128) NOT NULL,
  `image_browser_border_radius` varchar(128) NOT NULL,
  `image_browser_border_width` int(4) NOT NULL,
  `image_browser_border_style` varchar(128) NOT NULL,
  `image_browser_border_color` varchar(128) NOT NULL,
  `image_browser_bg_color` varchar(128) NOT NULL,
  `image_browser_box_shadow` varchar(128) NOT NULL,
  `image_browser_transparent` int(4) NOT NULL,
  `image_browser_align` varchar(128) NOT NULL,
  `image_browser_image_description_margin` varchar(128) NOT NULL,
  `image_browser_image_description_padding` varchar(128) NOT NULL,
  `image_browser_image_description_border_radius` varchar(128) NOT NULL,
  `image_browser_image_description_border_width` int(4) NOT NULL,
  `image_browser_image_description_border_style` varchar(128) NOT NULL,
  `image_browser_image_description_border_color` varchar(128) NOT NULL,
  `image_browser_image_description_bg_color` varchar(128) NOT NULL,
  `image_browser_image_description_align` varchar(128) NOT NULL,
  `image_browser_img_font_size` int(4) NOT NULL,
  `image_browser_img_font_family` varchar(128) NOT NULL,
  `image_browser_img_font_color` varchar(128) NOT NULL,
  `image_browser_full_padding` varchar(128) NOT NULL,
  `image_browser_full_border_radius` varchar(128) NOT NULL,
  `image_browser_full_border_width` int(4) NOT NULL,
  `image_browser_full_border_style` varchar(128) NOT NULL,
  `image_browser_full_border_color` varchar(128) NOT NULL,
  `image_browser_full_bg_color` varchar(128) NOT NULL,
  `image_browser_full_transparent` int(4) NOT NULL,
  `lightbox_info_pos` varchar(8) NOT NULL,
  `lightbox_info_align` varchar(8) NOT NULL,
  `lightbox_info_bg_color` varchar(8) NOT NULL,
  `lightbox_info_bg_transparent` int(4) NOT NULL,
  `lightbox_info_border_width` int(4) NOT NULL,
  `lightbox_info_border_style` varchar(32) NOT NULL,
  `lightbox_info_border_color` varchar(8) NOT NULL,
  `lightbox_info_border_radius` varchar(32) NOT NULL,
  `lightbox_info_padding` varchar(32) NOT NULL,
  `lightbox_info_margin` varchar(32) NOT NULL,
  `lightbox_title_color` varchar(8) NOT NULL,
  `lightbox_title_font_style` varchar(16) NOT NULL,
  `lightbox_title_font_weight` varchar(16) NOT NULL,
  `lightbox_title_font_size` int(4) NOT NULL,
  `lightbox_description_color` varchar(8) NOT NULL,
  `lightbox_description_font_style` varchar(16) NOT NULL,
  `lightbox_description_font_weight` varchar(8) NOT NULL,
  `lightbox_description_font_size` int(4) NOT NULL,
  `lightbox_rate_pos` varchar(8) NOT NULL,
  `lightbox_rate_align` varchar(32) NOT NULL,
  `lightbox_rate_icon` varchar(16) NOT NULL,
  `lightbox_rate_color` varchar(8) NOT NULL,
  `lightbox_rate_size` int(4) NOT NULL,
  `lightbox_rate_stars_count` int(4) NOT NULL,
  `lightbox_rate_padding` varchar(32) NOT NULL,
  `lightbox_rate_hover_color` varchar(8) NOT NULL,
  `lightbox_hit_pos` varchar(8) NOT NULL,
  `lightbox_hit_align` varchar(8) NOT NULL,
  `lightbox_hit_bg_color` varchar(8) NOT NULL,
  `lightbox_hit_bg_transparent` int(4) NOT NULL,
  `lightbox_hit_border_width` int(4) NOT NULL,
  `lightbox_hit_border_style` varchar(16) NOT NULL,
  `lightbox_hit_border_color` varchar(8) NOT NULL,
  `lightbox_hit_border_radius` varchar(32) NOT NULL,
  `lightbox_hit_padding` varchar(32) NOT NULL,
  `lightbox_hit_margin` varchar(32) NOT NULL,
  `lightbox_hit_color` varchar(8) NOT NULL,
  `lightbox_hit_font_style` varchar(16) NOT NULL,
  `lightbox_hit_font_weight` varchar(8) NOT NULL,
  `lightbox_hit_font_size` int(4) NOT NULL,
  `default_theme` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `#__bwg_theme`
--

INSERT INTO `#__bwg_theme` (`id`, `name`, `thumb_margin`, `thumb_padding`, `thumb_border_radius`, `thumb_border_width`, `thumb_border_style`, `thumb_border_color`, `thumb_bg_color`, `thumbs_bg_color`, `thumb_bg_transparent`, `thumb_box_shadow`, `thumb_transparent`, `thumb_align`, `thumb_hover_effect`, `thumb_hover_effect_value`, `thumb_transition`, `thumb_title_font_color`, `thumb_title_font_style`, `thumb_title_pos`, `thumb_title_font_size`, `thumb_title_font_weight`, `thumb_title_margin`, `thumb_title_shadow`, `page_nav_position`, `page_nav_align`, `page_nav_number`, `page_nav_font_size`, `page_nav_font_style`, `page_nav_font_color`, `page_nav_font_weight`, `page_nav_border_width`, `page_nav_border_style`, `page_nav_border_color`, `page_nav_border_radius`, `page_nav_margin`, `page_nav_padding`, `page_nav_button_bg_color`, `page_nav_button_bg_transparent`, `page_nav_box_shadow`, `page_nav_button_transition`, `page_nav_button_text`, `lightbox_overlay_bg_color`, `lightbox_overlay_bg_transparent`, `lightbox_bg_color`, `lightbox_ctrl_btn_pos`, `lightbox_ctrl_btn_align`, `lightbox_ctrl_btn_height`, `lightbox_ctrl_btn_margin_top`, `lightbox_ctrl_btn_margin_left`, `lightbox_ctrl_btn_transparent`, `lightbox_ctrl_btn_color`, `lightbox_toggle_btn_height`, `lightbox_toggle_btn_width`, `lightbox_ctrl_cont_bg_color`, `lightbox_ctrl_cont_transparent`, `lightbox_ctrl_cont_border_radius`, `lightbox_close_btn_transparent`, `lightbox_close_btn_bg_color`, `lightbox_close_btn_border_width`, `lightbox_close_btn_border_radius`, `lightbox_close_btn_border_style`, `lightbox_close_btn_border_color`, `lightbox_close_btn_box_shadow`, `lightbox_close_btn_color`, `lightbox_close_btn_size`, `lightbox_close_btn_width`, `lightbox_close_btn_height`, `lightbox_close_btn_top`, `lightbox_close_btn_right`, `lightbox_close_btn_full_color`, `lightbox_rl_btn_bg_color`, `lightbox_rl_btn_transparent`, `lightbox_rl_btn_border_radius`, `lightbox_rl_btn_border_width`, `lightbox_rl_btn_border_style`, `lightbox_rl_btn_border_color`, `lightbox_rl_btn_box_shadow`, `lightbox_rl_btn_color`, `lightbox_rl_btn_height`, `lightbox_rl_btn_width`, `lightbox_rl_btn_size`, `lightbox_close_rl_btn_hover_color`, `lightbox_comment_pos`, `lightbox_comment_width`, `lightbox_comment_bg_color`, `lightbox_comment_font_color`, `lightbox_comment_font_style`, `lightbox_comment_font_size`, `lightbox_comment_button_bg_color`, `lightbox_comment_button_border_color`, `lightbox_comment_button_border_width`, `lightbox_comment_button_border_style`, `lightbox_comment_button_border_radius`, `lightbox_comment_button_padding`, `lightbox_comment_input_bg_color`, `lightbox_comment_input_border_color`, `lightbox_comment_input_border_width`, `lightbox_comment_input_border_style`, `lightbox_comment_input_border_radius`, `lightbox_comment_input_padding`, `lightbox_comment_separator_width`, `lightbox_comment_separator_style`, `lightbox_comment_separator_color`, `lightbox_comment_author_font_size`, `lightbox_comment_date_font_size`, `lightbox_comment_body_font_size`, `lightbox_comment_share_button_color`, `lightbox_filmstrip_pos`, `lightbox_filmstrip_rl_bg_color`, `lightbox_filmstrip_rl_btn_size`, `lightbox_filmstrip_rl_btn_color`, `lightbox_filmstrip_thumb_margin`, `lightbox_filmstrip_thumb_border_width`, `lightbox_filmstrip_thumb_border_style`, `lightbox_filmstrip_thumb_border_color`, `lightbox_filmstrip_thumb_border_radius`, `lightbox_filmstrip_thumb_deactive_transparent`, `lightbox_filmstrip_thumb_active_border_width`, `lightbox_filmstrip_thumb_active_border_color`, `lightbox_rl_btn_style`, `album_compact_back_font_color`, `album_compact_back_font_style`, `album_compact_back_font_size`, `album_compact_back_font_weight`, `album_compact_back_padding`, `album_compact_title_font_color`, `album_compact_title_font_style`, `album_compact_thumb_title_pos`, `album_compact_title_font_size`, `album_compact_title_font_weight`, `album_compact_title_margin`, `album_compact_title_shadow`, `album_compact_thumb_margin`, `album_compact_thumb_padding`, `album_compact_thumb_border_radius`, `album_compact_thumb_border_width`, `album_compact_thumb_border_style`, `album_compact_thumb_border_color`, `album_compact_thumb_bg_color`, `album_compact_thumbs_bg_color`, `album_compact_thumb_bg_transparent`, `album_compact_thumb_box_shadow`, `album_compact_thumb_transparent`, `album_compact_thumb_align`, `album_compact_thumb_hover_effect`, `album_compact_thumb_hover_effect_value`, `album_compact_thumb_transition`, `album_extended_thumb_margin`, `album_extended_thumb_padding`, `album_extended_thumb_border_radius`, `album_extended_thumb_border_width`, `album_extended_thumb_border_style`, `album_extended_thumb_border_color`, `album_extended_thumb_bg_color`, `album_extended_thumbs_bg_color`, `album_extended_thumb_bg_transparent`, `album_extended_thumb_box_shadow`, `album_extended_thumb_transparent`, `album_extended_thumb_align`, `album_extended_thumb_hover_effect`, `album_extended_thumb_hover_effect_value`, `album_extended_thumb_transition`, `album_extended_back_font_color`, `album_extended_back_font_style`, `album_extended_back_font_size`, `album_extended_back_font_weight`, `album_extended_back_padding`, `album_extended_div_bg_color`, `album_extended_div_bg_transparent`, `album_extended_div_border_radius`, `album_extended_div_margin`, `album_extended_div_padding`, `album_extended_div_separator_width`, `album_extended_div_separator_style`, `album_extended_div_separator_color`, `album_extended_thumb_div_bg_color`, `album_extended_thumb_div_border_radius`, `album_extended_thumb_div_border_width`, `album_extended_thumb_div_border_style`, `album_extended_thumb_div_border_color`, `album_extended_thumb_div_padding`, `album_extended_text_div_bg_color`, `album_extended_text_div_border_radius`, `album_extended_text_div_border_width`, `album_extended_text_div_border_style`, `album_extended_text_div_border_color`, `album_extended_text_div_padding`, `album_extended_title_span_border_width`, `album_extended_title_span_border_style`, `album_extended_title_span_border_color`, `album_extended_title_font_color`, `album_extended_title_font_style`, `album_extended_title_font_size`, `album_extended_title_font_weight`, `album_extended_title_margin_bottom`, `album_extended_title_padding`, `album_extended_desc_span_border_width`, `album_extended_desc_span_border_style`, `album_extended_desc_span_border_color`, `album_extended_desc_font_color`, `album_extended_desc_font_style`, `album_extended_desc_font_size`, `album_extended_desc_font_weight`, `album_extended_desc_padding`, `album_extended_desc_more_color`, `album_extended_desc_more_size`, `masonry_thumb_padding`, `masonry_thumb_border_radius`, `masonry_thumb_border_width`, `masonry_thumb_border_style`, `masonry_thumb_border_color`, `masonry_thumbs_bg_color`, `masonry_thumb_bg_transparent`, `masonry_thumb_transparent`, `masonry_thumb_align`, `masonry_thumb_hover_effect`, `masonry_thumb_hover_effect_value`, `masonry_thumb_transition`, `slideshow_cont_bg_color`, `slideshow_close_btn_transparent`, `slideshow_rl_btn_bg_color`, `slideshow_rl_btn_border_radius`, `slideshow_rl_btn_border_width`, `slideshow_rl_btn_border_style`, `slideshow_rl_btn_border_color`, `slideshow_rl_btn_box_shadow`, `slideshow_rl_btn_color`, `slideshow_rl_btn_height`, `slideshow_rl_btn_size`, `slideshow_rl_btn_width`, `slideshow_close_rl_btn_hover_color`, `slideshow_filmstrip_pos`, `slideshow_filmstrip_thumb_border_width`, `slideshow_filmstrip_thumb_border_style`, `slideshow_filmstrip_thumb_border_color`, `slideshow_filmstrip_thumb_border_radius`, `slideshow_filmstrip_thumb_margin`, `slideshow_filmstrip_thumb_active_border_width`, `slideshow_filmstrip_thumb_active_border_color`, `slideshow_filmstrip_thumb_deactive_transparent`, `slideshow_filmstrip_rl_bg_color`, `slideshow_filmstrip_rl_btn_color`, `slideshow_filmstrip_rl_btn_size`, `slideshow_title_font_size`, `slideshow_title_font`, `slideshow_title_color`, `slideshow_title_opacity`, `slideshow_title_border_radius`, `slideshow_title_background_color`, `slideshow_title_padding`, `slideshow_description_font_size`, `slideshow_description_font`, `slideshow_description_color`, `slideshow_description_opacity`, `slideshow_description_border_radius`, `slideshow_description_background_color`, `slideshow_description_padding`, `slideshow_dots_width`, `slideshow_dots_height`, `slideshow_dots_border_radius`, `slideshow_dots_background_color`, `slideshow_dots_margin`, `slideshow_dots_active_background_color`, `slideshow_dots_active_border_width`, `slideshow_dots_active_border_color`, `slideshow_play_pause_btn_size`, `slideshow_rl_btn_style`, `blog_style_margin`, `blog_style_padding`, `blog_style_border_radius`, `blog_style_border_width`, `blog_style_border_style`, `blog_style_border_color`, `blog_style_bg_color`, `blog_style_box_shadow`, `blog_style_transparent`, `blog_style_align`, `blog_style_share_buttons_bg_color`, `blog_style_share_buttons_margin`, `blog_style_share_buttons_border_radius`, `blog_style_share_buttons_border_width`, `blog_style_share_buttons_border_style`, `blog_style_share_buttons_border_color`, `blog_style_share_buttons_align`, `blog_style_img_font_size`, `blog_style_img_font_family`, `blog_style_img_font_color`, `blog_style_share_buttons_color`, `blog_style_share_buttons_bg_transparent`, `blog_style_share_buttons_font_size`, `image_browser_margin`, `image_browser_padding`, `image_browser_border_radius`, `image_browser_border_width`, `image_browser_border_style`, `image_browser_border_color`, `image_browser_bg_color`, `image_browser_box_shadow`, `image_browser_transparent`, `image_browser_align`, `image_browser_image_description_margin`, `image_browser_image_description_padding`, `image_browser_image_description_border_radius`, `image_browser_image_description_border_width`, `image_browser_image_description_border_style`, `image_browser_image_description_border_color`, `image_browser_image_description_bg_color`, `image_browser_image_description_align`, `image_browser_img_font_size`, `image_browser_img_font_family`, `image_browser_img_font_color`, `image_browser_full_padding`, `image_browser_full_border_radius`, `image_browser_full_border_width`, `image_browser_full_border_style`, `image_browser_full_border_color`, `image_browser_full_bg_color`, `image_browser_full_transparent`, `lightbox_info_pos`, `lightbox_info_align`, `lightbox_info_bg_color`, `lightbox_info_bg_transparent`, `lightbox_info_border_width`, `lightbox_info_border_style`, `lightbox_info_border_color`, `lightbox_info_border_radius`, `lightbox_info_padding`, `lightbox_info_margin`, `lightbox_title_color`, `lightbox_title_font_style`, `lightbox_title_font_weight`, `lightbox_title_font_size`, `lightbox_description_color`, `lightbox_description_font_style`, `lightbox_description_font_weight`, `lightbox_description_font_size`, `lightbox_rate_pos`, `lightbox_rate_align`, `lightbox_rate_icon`, `lightbox_rate_color`, `lightbox_rate_size`, `lightbox_rate_stars_count`, `lightbox_rate_padding`, `lightbox_rate_hover_color`, `lightbox_hit_pos`, `lightbox_hit_align`, `lightbox_hit_bg_color`, `lightbox_hit_bg_transparent`, `lightbox_hit_border_width`, `lightbox_hit_border_style`, `lightbox_hit_border_color`, `lightbox_hit_border_radius`, `lightbox_hit_padding`, `lightbox_hit_margin`, `lightbox_hit_color`, `lightbox_hit_font_style`, `lightbox_hit_font_weight`, `lightbox_hit_font_size`, `default_theme`) VALUES
(1, 'Theme 1', 4, 0, '0', 0, 'none', 'CCCCCC', 'FFFFFF', 'FFFFFF', 0, '0px 0px 0px #888888', 100, 'center', 'scale', '1.1', 1, 'CCCCCC', 'segoe ui', 'bottom', 16, 'bold', '2px', '0px 0px 0px #888888', 'bottom', 'center', 0, 12, 'segoe ui', '666666', 'bold', 1, 'solid', 'E3E3E3', '0', '0', '3px 6px', 'FFFFFF', 100, '0', 1, 0, '000000', 70, '000000', 'bottom', 'center', 20, 10, 7, 100, 'FFFFFF', 14, 100, '000000', 65, 4, 100, '000000', 2, '16px', 'none', 'FFFFFF', '0', 'FFFFFF', 10, 20, 20, '-10', '-10', 'FFFFFF', '000000', 80, '20px', 0, 'none', 'FFFFFF', '', 'FFFFFF', 40, 40, 20, 'CCCCCC', 'left', 400, '000000', 'CCCCCC', 'segoe ui', 12, '616161', '666666', 1, 'none', '3px', '3px 10px', '333333', '666666', 1, 'none', '0', '2px', 1, 'solid', '383838', 14, 10, 12, 'CCCCCC', 'top', '3B3B3B', 20, 'FFFFFF', '0 1px', 1, 'solid', '000000', '0', 80, 0, 'FFFFFF', 'fa-chevron', '000000', 'segoe ui', 16, 'bold', '0', 'CCCCCC', 'segoe ui', 'bottom', 16, 'bold', '2px', '0px 0px 0px #888888', 4, 0, '0', 0, 'none', 'CCCCCC', 'FFFFFF', 'FFFFFF', 0, '0px 0px 0px #888888', 100, 'center', 'scale', '1.1', 0, 2, 0, '0', 0, 'none', 'CCCCCC', 'FFFFFF', 'FFFFFF', 0, '', 100, 'left', 'scale', '1.1', 0, '000000', 'segoe ui', 20, 'bold', '0', 'FFFFFF', 0, '0 0 0 0', '0 0 5px 0', 10, 1, 'solid', 'E0E0E0', 'FFFFFF', '0', 1, 'solid', 'E8E8E8', '5px', 'FFFFFF', '0', 1, 'solid', 'E8E8E8', '5px', 1, 'none', 'CCCCCC', '000000', 'segoe ui', 16, 'bold', 2, '2px', 1, 'none', 'CCCCCC', '000000', 'segoe ui', 14, 'normal', '2px', 'F2D22E', 12, 4, '0', 0, 'none', 'CCCCCC', 'FFFFFF', 0, 100, 'center', 'scale', '1.1', 0, '000000', 100, '000000', '20px', 0, 'none', 'FFFFFF', '0px 0px 0px #000000', 'FFFFFF', 40, 20, 40, 'CCCCCC', 'top', 1, 'solid', '000000', '0', '0 1px', 0, 'FFFFFF', 80, '3B3B3B', 'FFFFFF', 20, 16, 'segoe ui', 'FFFFFF', 70, '5px', '000000', '0 0 0 0', 14, 'segoe ui', 'FFFFFF', 70, '0', '000000', '5px 10px 5px 10px', 12, 12, '5px', 'F2D22E', 3, 'FFFFFF', 1, '000000', 60, 'fa-chevron', '2px', '0', '0', 1, 'solid', 'F5F5F5', 'FFFFFF', '', 80, 'center', 'FFFFFF', '5px auto 10px auto', '0', 0, 'none', '000000', 'right', 16, 'segoe ui', '000000', 'B3AFAF', 0, 20, '2px auto', '4px', '0', 1, 'none', 'F5F5F5', 'EBEBEB', '', 80, 'center', '0px 5px 0px 5px', '8px 8px 8px 8px', '0', 1, 'none', 'FFFFFF', 'EBEBEB', 'center', 15, 'segoe ui', '000000', '4px', '0', 2, 'none', 'F7F7F7', 'F5F5F5', 90, 'top', 'right', '000000', 70, 1, 'none', '000000', '5px', '5px', '15px', 'FFFFFF', 'segoe ui', 'bold', 18, 'FFFFFF', 'segoe ui', 'normal', 14, 'bottom', 'right', 'star', 'F9D062', 20, 5, '15px', 'F7B50E', 'bottom', 'left', '000000', 70, 1, 'none', '000000', '5px', '5px', '0 5px', 'FFFFFF', 'segoe ui', 'normal', 14, 1),
(2, 'Theme 2', 4, 4, '0', 5, 'none', 'FFFFFF', 'E8E8E8', 'FFFFFF', 0, '0px 0px 0px #888888', 100, 'center', 'rotate', '2deg', 1, 'CCCCCC', 'segoe ui', 'bottom', 16, 'bold', '5px', '', 'bottom', 'center', 0, 12, 'segoe ui', '666666', 'bold', 1, 'none', 'E3E3E3', '0', '0', '3px 6px', 'FCFCFC', 100, '0', 1, 0, '000000', 70, '000000', 'bottom', 'center', 20, 10, 7, 80, 'FFFFFF', 14, 100, '000000', 80, 4, 95, '000000', 0, '16px', 'none', 'FFFFFF', '', 'FFFFFF', 10, 20, 20, '-10', '-10', 'FFFFFF', '000000', 80, '20px', 2, 'none', 'FFFFFF', '', 'FFFFFF', 40, 40, 20, 'FFFFFF', 'left', 400, '000000', 'CCCCCC', 'arial', 12, '333333', '666666', 1, 'none', '3px', '3px 10px', '333333', '666666', 1, 'none', '0', '3px', 1, 'solid', '2B2B2B', 14, 10, 12, 'FFFFFF', 'top', '2B2B2B', 20, 'FFFFFF', '0 1px', 1, 'none', '000000', '0', 80, 0, 'FFFFFF', 'fa-chevron', '000000', 'segoe ui', 14, 'normal', '0', 'CCCCCC', 'segoe ui', 'bottom', 16, 'bold', '5px', '', 4, 4, '0', 1, 'none', '000000', 'E8E8E8', 'FFFFFF', 100, '', 100, 'center', 'rotate', '2deg', 1, 2, 4, '0', 4, 'none', 'E8E8E8', 'E8E8E8', 'FFFFFF', 100, '', 100, 'left', 'rotate', '2deg', 0, '000000', 'segoe ui', 16, 'bold', '0', 'FFFFFF', 0, '0', '0 0 5px 0', 10, 1, 'none', 'CCCCCC', 'FFFFFF', '0', 0, 'none', 'CCCCCC', '0', 'FFFFFF', '0', 1, 'none', 'CCCCCC', '5px', 1, 'none', 'CCCCCC', '000000', 'segoe ui', 16, 'bold', 2, '2px', 1, 'none', 'CCCCCC', '000000', 'segoe ui', 14, 'normal', '2px', 'FFC933', 12, 4, '2px', 1, 'none', 'CCCCCC', 'FFFFFF', 0, 80, 'center', 'rotate', '2deg', 0, '000000', 100, '000000', '20px', 0, 'none', 'FFFFFF', '', 'FFFFFF', 40, 20, 40, 'DBDBDB', 'bottom', 1, 'none', '000000', '0', '0 1px', 0, 'FFFFFF', 80, '303030', 'FFFFFF', 20, 16, 'segoe ui', 'FFFFFF', 70, '5px', '000000', '5px 10px 5px 10px', 14, 'segoe ui', 'FFFFFF', 70, '0', '000000', '5px 10px 5px 10px', 10, 10, '10px', '292929', 1, '292929', 2, 'FFC933', 60, 'fa-chevron', '2px', '4px', '0', 1, 'none', 'CCCCCC', 'E8E8E8', '', 70, 'center', 'FFFFFF', '5px auto 10px auto', '0', 0, 'none', '000000', 'right', 16, 'segoe ui', '000000', 'A1A1A1', 0, 20, '2px auto', '4px', '2px', 1, 'none', 'E8E8E8', 'E8E8E8', '', 80, 'center', '24px 0px 0px 0px', '8px 8px 8px 8px', '0', 1, 'none', 'FFFFFF', 'E8E8E8', 'center', 14, 'segoe ui', '000000', '4px', '0', 1, 'solid', 'EDEDED', 'FFFFFF', 90, 'top', 'right', '000000', 70, 1, 'none', '000000', '5px', '5px', '15px', 'FFFFFF', 'segoe ui', 'bold', 18, 'FFFFFF', 'segoe ui', 'normal', 14, 'bottom', 'right', 'star', 'F9D062', 20, 5, '15px', 'F7B50E', 'bottom', 'left', '000000', 70, 1, 'none', '000000', '5px', '5px', '0 5px', 'FFFFFF', 'segoe ui', 'normal', 14, 0);



