<?php
	/**
	* @package		BDT Twitter Widget
	* @copyright	Web Design Services. All rights reserved. All rights reserved.
	* @license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
	*/

	// no direct access
	defined('_JEXEC') or die;

	require_once dirname(__FILE__).'/lib/twitteroauth/twitteroauth.php';
	require_once dirname(__FILE__).'/lib/twitter-text/Autolink.php';
	require_once dirname(__FILE__).'/lib/twitter-text/Extractor.php';
	require_once dirname(__FILE__).'/lib/twitter-text/HitHighlighter.php';
 if(!class_exists('modBdtTwitterModuleHelper',false)) {
	class modBdtTwitterModuleHelper
	{
		private $data;
		private $cacheFile;

		public function __construct() {
			$this->cacheFile = dirname(__FILE__) . '/cache';
		}

		public function getData($params) {
			$twitterConnection = new TwitterOAuth(
				trim($params->get('consumer_key', '')), // Consumer Key
				trim($params->get('consumer_secret', '')), // Consumer secret
				trim($params->get('access_token', '')), // Access token
				trim($params->get('access_secret', ''))	// Access token secret
			);

			if($params->get('type', 1)) {
				$twitterData = $twitterConnection->get(
					'statuses/user_timeline',
					array(
						'screen_name' => trim($params->get('username', 'twitter')),
						'count' => trim($params->get('count', 5)),
					)
				);
			}
			else {
				$twitterData = $twitterConnection->get(
					'search/tweets',
					array(
						'q' => trim($params->get('query', '')),
						'count' => trim($params->get('count', 5)),
					)
				);
				if(!isset($twitterData->errors))
					$twitterData = $twitterData->statuses;
			}

			// if there are no errors
			if(!isset($twitterData->errors)) {
				$tweets = array();
				if (is_array($twitterData)) {
				foreach($twitterData as $tweet) {
					$tweetDetails = new stdClass();
					$tweetDetails->text = Twitter_Autolink::create($tweet->text)->setNoFollow(false)->addLinks();
					$tweetDetails->time = $this->getTime($tweet->created_at);
					$tweetDetails->id = $tweet->id_str;
					$tweetDetails->screenName = $tweet->user->screen_name;
					$tweetDetails->displayName = $tweet->user->name;
					$tweetDetails->profileImage = $tweet->user->profile_image_url_https;

					$tweets[] = $tweetDetails;
				}
				}
				$data = new stdClass();
				$data->tweets = $tweets;

				$this->data = $data;
				//$this->setCache();

				return $data;
			}
			else {
				//return $this->getCache();
			}
		}
		
		public function addStyles($params) {
			$styles = '';

			if($params->get('width', '')) {
				$styles .= '#bdt-container {width: ' . intval($params->get('width', '')) . 'px;}';
			}
			if($params->get('height', '')) {
				$styles .= '#bdt {height: ' . intval($params->get('height', '')) . 'px; overflow: auto;}';
			}
			

			$doc =& JFactory::getDocument();
			$scripts = array_keys($doc->_scripts);
			$scriptFound = false;
			for ($i = 0; $i < count($scripts); $i++) {
			    if (stripos($scripts[$i], 'owl.carousel.min.js') !== false) {
			        $scriptFound = true;
			    }
			}
			if (!$scriptFound) {
			    $doc->addScript('modules/mod_bdttwitter_module/js/owl.carousel.min.js');
				$doc->addStyleSheet('modules/mod_bdttwitter_module/css/owl.carousel.css');
				$doc->addStyleSheet('modules/mod_bdttwitter_module/css/owl.transitions.css');
			}

			$doc->addStyleSheet('modules/mod_bdttwitter_module/css/bdttwittermodule.css');	

		}

		// parse time in a twitter style
		private function getTime($date)
		{
			$timediff = time() - strtotime($date);
			if($timediff < 60)
				return $timediff . 's';
			else if($timediff < 3600)
				return intval(date('i', $timediff)) . 'm';
			else if($timediff < 86400)
				return round($timediff/60/60) . 'h';
			else
				return JHTML::_('date', $date, 'M d');
		}
	}
}