<?php

/**
 * Class for managing plugin data
 */
class Su_Data {

	/**
	 * Constructor
	 */
	function __construct() {}

	/**
	 * Shortcode groups
	 */
	public static function groups() {
		return array(
			 'all' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALL'), 
			 'content' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTENT'), 
			 'box' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BOX'), 
			 "media" => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MEDIA'),
			 'gallery' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GALLERY'),
			 'other' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_OTHER')	     
		 );
	}

	/**
	 * Border styles
	 */
	public static function borders() {
		return array(
			'none'   => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NONE'),
			'solid'  => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SOLID'),
			'dotted' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DOTTED'),
			'dashed' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DASHED'),
			'double' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DOUBLE'),
			'groove' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GROOVE'),
			'ridge'  => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIDGE')
		);
	}

	/**
	 * Font-Awesome icons
	 */
	public static function icons() {
		return apply_filters( 'su/data/icons', array( 'glass', 'music', 'search', 'envelope-o', 'heart', 'star', 'star-o', 'user', 'film', 'th-large', 'th', 'th-list', 'check', 'times', 'search-plus', 'search-minus', 'power-off', 'signal', 'cog', 'trash-o', 'home', 'file-o', 'clock-o', 'road', 'download', 'arrow-circle-o-down', 'arrow-circle-o-up', 'inbox', 'play-circle-o', 'repeat', 'refresh', 'list-alt', 'lock', 'flag', 'headphones', 'volume-off', 'volume-down', 'volume-up', 'qrcode', 'barcode', 'tag', 'tags', 'book', 'bookmark', 'print', 'camera', 'font', 'bold', 'italic', 'text-height', 'text-width', 'align-left', 'align-center', 'align-right', 'align-justify', 'list', 'outdent', 'indent', 'video-camera', 'picture-o', 'pencil', 'map-marker', 'adjust', 'tint', 'pencil-square-o', 'share-square-o', 'check-square-o', 'arrows', 'step-backward', 'fast-backward', 'backward', 'play', 'pause', 'stop', 'forward', 'fast-forward', 'step-forward', 'eject', 'chevron-left', 'chevron-right', 'plus-circle', 'minus-circle', 'times-circle', 'check-circle', 'question-circle', 'info-circle', 'crosshairs', 'times-circle-o', 'check-circle-o', 'ban', 'arrow-left', 'arrow-right', 'arrow-up', 'arrow-down', 'share', 'expand', 'compress', 'plus', 'minus', 'asterisk', 'exclamation-circle', 'gift', 'leaf', 'fire', 'eye', 'eye-slash', 'exclamation-triangle', 'plane', 'calendar', 'random', 'comment', 'magnet', 'chevron-up', 'chevron-down', 'retweet', 'shopping-cart', 'folder', 'folder-open', 'arrows-v', 'arrows-h', 'bar-chart-o', 'twitter-square', 'facebook-square', 'camera-retro', 'key', 'cogs', 'comments', 'thumbs-o-up', 'thumbs-o-down', 'star-half', 'heart-o', 'sign-out', 'linkedin-square', 'thumb-tack', 'external-link', 'sign-in', 'trophy', 'github-square', 'upload', 'lemon-o', 'phone', 'square-o', 'bookmark-o', 'phone-square', 'twitter', 'facebook', 'github', 'unlock', 'credit-card', 'rss', 'hdd-o', 'bullhorn', 'bell', 'certificate', 'hand-o-right', 'hand-o-left', 'hand-o-up', 'hand-o-down', 'arrow-circle-left', 'arrow-circle-right', 'arrow-circle-up', 'arrow-circle-down', 'globe', 'wrench', 'tasks', 'filter', 'briefcase', 'arrows-alt', 'users', 'link', 'cloud', 'flask', 'scissors', 'files-o', 'paperclip', 'floppy-o', 'square', 'bars', 'list-ul', 'list-ol', 'strikethrough', 'underline', 'table', 'magic', 'truck', 'pinterest', 'pinterest-square', 'google-plus-square', 'google-plus', 'money', 'caret-down', 'caret-up', 'caret-left', 'caret-right', 'columns', 'sort', 'sort-asc', 'sort-desc', 'envelope', 'linkedin', 'undo', 'gavel', 'tachometer', 'comment-o', 'comments-o', 'bolt', 'sitemap', 'umbrella', 'clipboard', 'lightbulb-o', 'exchange', 'cloud-download', 'cloud-upload', 'user-md', 'stethoscope', 'suitcase', 'bell-o', 'coffee', 'cutlery', 'file-text-o', 'building-o', 'hospital-o', 'ambulance', 'medkit', 'fighter-jet', 'beer', 'h-square', 'plus-square', 'angle-double-left', 'angle-double-right', 'angle-double-up', 'angle-double-down', 'angle-left', 'angle-right', 'angle-up', 'angle-down', 'desktop', 'laptop', 'tablet', 'mobile', 'circle-o', 'quote-left', 'quote-right', 'spinner', 'circle', 'reply', 'github-alt', 'folder-o', 'folder-open-o', 'smile-o', 'frown-o', 'meh-o', 'gamepad', 'keyboard-o', 'flag-o', 'flag-checkered', 'terminal', 'code', 'reply-all', 'mail-reply-all', 'star-half-o', 'location-arrow', 'crop', 'code-fork', 'chain-broken', 'question', 'info', 'exclamation', 'superscript', 'subscript', 'eraser', 'puzzle-piece', 'microphone', 'microphone-slash', 'shield', 'calendar-o', 'fire-extinguisher', 'rocket', 'maxcdn', 'chevron-circle-left', 'chevron-circle-right', 'chevron-circle-up', 'chevron-circle-down', 'html5', 'css3', 'anchor', 'unlock-alt', 'bullseye', 'ellipsis-h', 'ellipsis-v', 'rss-square', 'play-circle', 'ticket', 'minus-square', 'minus-square-o', 'level-up', 'level-down', 'check-square', 'pencil-square', 'external-link-square', 'share-square', 'compass', 'caret-square-o-down', 'caret-square-o-up', 'caret-square-o-right', 'eur', 'gbp', 'usd', 'inr', 'jpy', 'rub', 'krw', 'btc', 'file', 'file-text', 'sort-alpha-asc', 'sort-alpha-desc', 'sort-amount-asc', 'sort-amount-desc', 'sort-numeric-asc', 'sort-numeric-desc', 'thumbs-up', 'thumbs-down', 'youtube-square', 'youtube', 'xing', 'xing-square', 'youtube-play', 'dropbox', 'stack-overflow', 'instagram', 'flickr', 'adn', 'bitbucket', 'bitbucket-square', 'tumblr', 'tumblr-square', 'long-arrow-down', 'long-arrow-up', 'long-arrow-left', 'long-arrow-right', 'apple', 'windows', 'android', 'linux', 'dribbble', 'skype', 'foursquare', 'trello', 'female', 'male', 'gittip', 'sun-o', 'moon-o', 'archive', 'bug', 'vk', 'weibo', 'renren', 'pagelines', 'stack-exchange', 'arrow-circle-o-right', 'arrow-circle-o-left', 'caret-square-o-left', 'dot-circle-o', 'wheelchair', 'vimeo-square', 'try', 'plus-square-o' ) );
	}

	/**
	 * Animate.css animations
	 */
	public static function animations() {
		return apply_filters( 'su/data/animations', array( 'flash', 'bounce', 'shake', 'tada', 'swing', 'wobble', 'pulse', 'flip', 'flipInX', 'flipOutX', 'flipInY', 'flipOutY', 'fadeIn', 'fadeInUp', 'fadeInDown', 'fadeInLeft', 'fadeInRight', 'fadeInUpBig', 'fadeInDownBig', 'fadeInLeftBig', 'fadeInRightBig', 'fadeOut', 'fadeOutUp', 'fadeOutDown', 'fadeOutLeft', 'fadeOutRight', 'fadeOutUpBig', 'fadeOutDownBig', 'fadeOutLeftBig', 'fadeOutRightBig', 'slideInDown', 'slideInLeft', 'slideInRight', 'slideOutUp', 'slideOutLeft', 'slideOutRight', 'bounceIn', 'bounceInDown', 'bounceInUp', 'bounceInLeft', 'bounceInRight', 'bounceOut', 'bounceOutDown', 'bounceOutUp', 'bounceOutLeft', 'bounceOutRight', 'rotateIn', 'rotateInDownLeft', 'rotateInDownRight', 'rotateInUpLeft', 'rotateInUpRight', 'rotateOut', 'rotateOutDownLeft', 'rotateOutDownRight', 'rotateOutUpLeft', 'rotateOutUpRight', 'lightSpeedIn', 'lightSpeedOut', 'hinge', 'rollIn', 'rollOut' ) );
	}


	

	/**
	 * Shortcodes
	 */
	public static function shortcodes( $shortcode = false ) {
		$shortcodes = apply_filters( 'su/data/shortcodes', array(
				
				// accordion
				'accordion' => array(
					'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ACCORDION'),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'class' => array(
							'default' => '',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => sprintf('%s', "[%prefix_spoiler]Content[/%prefix_spoiler]\n[%prefix_spoiler]Content[/%prefix_spoiler]\n[%prefix_spoiler]Content[/%prefix_spoiler]"),
					'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ACCORDION_DESC'),
					'icon' => 'list'
				),				
				// animate
				'animate' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ANIMATE'),
					'type' => 'wrap',
					'group' => 'other',
					'atts' => array(
						'type' => array(
							'type' => 'select',
							'values' => array_combine( self::animations(), self::animations() ),
							'default' => 'bounceIn',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TYPE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TYPE_DESC')
						),
						'duration' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 20,
							'step' => 0.5,
							'default' => 1,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DURATION'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DURATION_DESC')
						),
						'delay' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 20,
							'step' => 0.5,
							'default' => 0,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DELAY'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DELAY_DESC')
						),
						'inline' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_INLINE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_INLINE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'Animated content',
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ANIMATE_DESC'),
					'icon' => 'bolt'
				),
				// audio
				'audio' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUDIO'),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							//'type' => 'upload',
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUDIO_URL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUDIO_URL_DESC')
						),
						'width' => array(
							'values' => array(),
							'default' => '100%',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUDIO_WIDTH_DESC')
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY_DESC')
						),
						'loop' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LOOP'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LOOP_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUDIO_DESC'),
					'icon' => 'play-circle'
				),
				// box
				'box' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BOX'),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'title' => array(
							'values' => array( ),
							'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BOX_TITLE_DEFAULT'),
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'soft' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SOFT'),
								'glass' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GLASS'),
								'bubbles' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUBBLES'),
								'noise' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NOISE')
							),
							'default' => 'default',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC')
						),
						'box_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#333333',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'title_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#FFFFFF',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR_DESC')
						),
						'radius' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 20,
							'step' => 1,
							'default' => 3,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'Box content',
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BOX_DESC'),
					'icon' => 'list-alt'
				),
				// button
				'button' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON'),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'url' => array(
							'values' => array( ),
							'default' => get_option( 'Home' ),
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'target' => array(
							'type' => 'select',
							'values' => array(
								'self' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SELF'),
								'blank' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BLANK')
							),
							'default' => 'self',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TARGET'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TARGET_DESC')
						),
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'flat' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT'),
								'soft' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SOFT'),
								'glass' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GLASS'),
								'bubbles' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUBBLES'),
								'noise' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NOISE'),
								'stroked' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STROKED'),
								'3d' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_3D')
							),
							'default' => 'default',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC')
						),
						'background' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#2D89EF',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#FFFFFF',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'size' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 20,
							'step' => 1,
							'default' => 3,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE_DESC')
						),
						'wide' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDE'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDE_DESC')
						),
						'center' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER_DESC')
						),
						'radius' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 50,
							'step' => 1,
							'default' => 3,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS_DESC')
						),
						'icon' => array(
							'type' => 'icon',
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'icon_color' => array(
							'type' => 'color',
							'default' => '#FFFFFF',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR_DESC')
						),
						'text_shadow' => array(
							'type' => 'shadow',
							'default' => 'none',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW_DESC')
						),
						'desc' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DESCRIPTION'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DESCRIPTION_DESC')
						),
						'onclick' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ONCLICK'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ONCLICK_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						) 
					),
					'content' => 'Button text',
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_DESC'),
					'icon' => 'heart'
				),
				// calltoaction
				'calltoaction' => array(
					'content'  => 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit.',
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CALLTOACTION'),
					'type'     => 'wrap',
					'group'    => 'extra content',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CALLTOACTION_DESC'),
					'icon'     => 'pencil',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'calltoaction' ),
					'atts' => array(						
						'title' => array(
							'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DEFAULT'),
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),			
						'title_color' => array(
							'type'    => 'color',
							'default' => '#ffffff',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_COLOR_DESC')
						),						
						'button_text' => array(
							'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_TEXT_DEFAULT'),
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_TEXT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_TEXT_DESC')
						),
						'button_link' => array(
							'default' => '#',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_LINK'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_LINK_DESC')
						),
						'target' => array(
							'type' => 'select',
							'values' => array(
								'self' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SELF'),
								'blank' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BLANK')
							),
							'default' => 'self',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TARGET'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TARGET_DESC')
						),			
						'button_color' => array(
							'type'    => 'color',
							'default' => '#444',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_COLOR_DESC')
						),
						'button_background' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#DDDDDD',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_BACKGROUND'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_BACKGROUND_DESC')
						),			
						'color' => array(
							'type'    => 'color',
							'default' => '#DDD',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'background' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#444444',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),				
						'radius' => array(
							'type'    => 'slider',
							'default' => '0',
							'min'     => '0',
							'max'     => '100',
							'step'    => '1',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS_DESC')
						),				
						'button_radius' => array(
							'type'    => 'slider',
							'default' => '0',
							'min'     => '0',
							'max'     => '100',
							'step'    => '1',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_RADIUS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_RADIUS_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),
				// content_slide
				'content_slide' => array(
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTENT_SLIDE'),
					'type'     => 'wrap',
					'group'    => 'extra gallery',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTENT_SLIDE_DESC'),
					'icon'     => 'desktop',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'content_slide' ),
					'atts'     => array(
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),
				// content_slider
				'content_slider' => array(
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTENT_SLIDER'),
					'type'     => 'wrap',
					'group'    => 'extra gallery',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTENT_SLIDER_DESC'),
					'icon'     => 'desktop',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'content_slider' ),
					'atts'     => array(
						'style' => array(
							'type'    => 'select',
							'default' => 'default',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC'),
							'values'   => array(
								'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'dark'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DARK'),
								'light'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHT')
							)
						),
						'effect' => array(
							'type'    => 'select',
							'default' => 'slide',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_EFFECT'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_EFFECT_DESC'),
							'values'   => array(
								'slide'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SLIDE'),
								'fade'      => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FADE'),
								'fadeUp'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FADE_UP'),
								'backSlide' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACK_SLIDE'),
								'goDown'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GO_DOWN')
							)
						),
						'arrows' => array(
							'type'    => 'select',
							'default' => 'yes',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ARROW'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ARROW_DESC'),
							'values'   => array(
								'no'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NEVER'),
								'hover' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HOVER'),
								'yes'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALWAYS')
							)
						),
						'pages' => array(
							'type'    => 'select',
							'default' => 'no',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHOW_PAGES'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHOW_PAGES_DESC'),
							'values'   => array(
								'no'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NEVER'),
								'hover' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HOVER'),
								'yes'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALWAYS')
							)
						),
						'autoplay' => array(
							'type'    => 'slider',
							'default' => '5',
							'min'     => '0',
							'max'     => '60',
							'step'    => '0.5',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY_DESC')
						),
						'speed' => array(
							'type'    => 'slider',
							'default' => '0.5',
							'min'     => '0',
							'max'     => '10',
							'step'    => '0.1',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPEED'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPEED_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => sprintf( '[__content_slide] %1$s [/__content_slide]%2$s[__content_slide] %1$s [/__content_slide]%2$s[__content_slide] %1$s [/__content_slide]', 'Slide content', "\n" )
				),
				// column
				'column' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLUMN'),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'size' => array(
							'type' => 'select',
							'values' => array(
								'1/1' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FULL_WIDTH'),
								'1/2' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ONE_HALF'),
								'1/3' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ONE_THIRD'),
								'2/3' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TWO_THIRD'),
								'1/4' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ONE_FOURTH'),
								'3/4' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_THREE_FOURTH'),
								'1/5' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ONE_FIFTH'),
								'2/5' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TWO_FIFTH'),
								'3/5' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_THREE_FIFTH'),
								'4/5' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FOUR_FIFTH'),
								'1/6' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ONE_SIXTH'),
								'5/6' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FIVE_SIXTH')
							),
							'default' => '1/2',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE_DESC')
						),
						'center' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'Column content',
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLUMN_DESC'),
					'icon' => 'columns'
				),
				// counter
				'counter' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNTER'),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'count_start' => array(
							'default' => '0',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNT_START'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNT_START_DESC')
						),
						'count_end' => array(
							'default' => '5000',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNT_END'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNT_END_DESC')
						),
						'counter_refresh_interval' => array(
							'default' => '50',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNTER_REFRESH_INTERVAL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNTER_REFRESH_INTERVAL_DESC')
						),
						'counter_speed' => array(
							'default' => '5000',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNTER_SPEED'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNTER_SPEED_DESC')
						),	
						'count_color' => array(
							'type'    => 'color',
							'default' => '#444444',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNT_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNT_COLOR_DESC')
						),
						'count_size' => array(
							'type'    => 'slider',
							'default' => '32',
							'min'     => '5',
							'max'     => '100',
							'step'    => '5',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNT_SIZE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNT_SIZE_DESC')
						),
						'text_color' => array(
							'type'    => 'color',
							'default' => '#666666',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR_DESC')
						),
						'text_size' => array(
							'type'    => 'slider',
							'default' => '14',
							'min'     => '4',
							'max'     => '100',
							'step'    => '2',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_SIZE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_SIZE_DESC')
						),					
						'border' => array(
							'type'    => 'border',
							'default' => '0px solid #DDD',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_DESC')
						),
						'background' => array(
							'type'    => 'color',
							'default' => '#FFFFFF',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'counter content',
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COUNTER_DESC'),
					'icon' => 'sort-numeric-asc'
				),
				// document
				'document' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DOCUMENT'),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							//							'type' => 'upload',
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DOCUMENT_URL_DESC')
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VIEWER_WIDTH_DESC')
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VIEWER_HEIGHT_DESC')
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DOCUMENT_DESC'),
					'icon' => 'file-text'
				),
				// divider
				'divider' => array(
					'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DIVIDER'),
					'type' => 'single',
					'group' => 'content',
					'atts' => array(
						'top' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TOP'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TOP_DESC')
						),
						'text' => array(
							'values' => array( ),
							'default' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_DEFAULT'),
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT')
						),
						'margin_top' => array(
							'type'    => 'slider',
							'default' => '10',
							'min'     => '0',
							'max'     => '200',
							'step'    => '5',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MARGIN_TOP'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MARGIN_TOP_DESC')
						),
						'margin_bottom' => array(
							'type'    => 'slider',
							'default' => '10',
							'min'     => '0',
							'max'     => '200',
							'step'    => '5',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MARGIN_BOTTOM'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MARGIN_BOTTOM_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DIVIDER_DESC'),
					'icon' => 'ellipsis-h'
				),
				// dropcap
				'dropcap' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DROPCAP'),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'flat' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT'),
								'light' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHT'),
								'simple' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIMPLE')
							),
							'default' => 'default',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC')
						),
						'size' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 5,
							'step' => 1,
							'default' => 3,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'D',
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DROPCAP_DESC'),
					'icon' => 'bold'
				),
				// dummy_image
				'dummy_image' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DUMMY_IMAGE'),
					'type' => 'single',
					'group' => 'content',
					'atts' => array(
						'width' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 1600,
							'step' => 10,
							'default' => 500,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH_DESC')
						),
						'height' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 1600,
							'step' => 10,
							'default' => 300,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT_DESC')
						),
						'theme' => array(
							'type' => 'select',
							'values' => array(
								'any'       => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ANY'),
								'abstract'  => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ABSTRACT'),
								'animals'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ANIMALS'),
								'business'  => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUSINESS'),
								'cats'      => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CATS'),
								'city'      => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CITY'),
								'food'      => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FOOD'),
								'nightlife' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NIGHT_LIFE'),
								'fashion'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FASHION'),
								'people'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PEOPLE'),
								'nature'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NATURE'),
								'sports'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPORTS'),
								'technics'  => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TECHNICS'),
								'transport' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TRANSPORT')
							),
							'default' => 'any',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_THEME'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_THEME_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DUMMY_IMAGE_DESC'),
					'icon' => 'picture-o'
				),
				// dummy_text
				'dummy_text' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DUMMY_TEXT'),
					'type' => 'single',
					'group' => 'content',
					'atts' => array(
						'what' => array(
							'type' => 'select',
							'values' => array(
								'paras' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PARAS'),
								'words' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WORDS'),
								'bytes' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BYTES'),
							),
							'default' => 'paras',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WHAT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WHAT_DESC')
						),
						'amount' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 100,
							'step' => 1,
							'default' => 1,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AMOUNT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AMOUNT_DESC')
						),
						'cache' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CACHE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CACHE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DUMMY_TEXT_DESC'),
					'icon' => 'text-height'
				),
				// flickr
				'flickr' => array(
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLICKR'),
					'type'     => 'single',
					'group'    => 'extra content',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLICKR_DESC'),
					'icon'     => 'pencil',
					'atts' => array(						
						'id' => array(
							'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ID_DEFAULT'),
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ID'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ID_DESC')
						),	
						'limit' => array(
							'type'    => 'slider',
							'default' => '9',
							'min'     => '0',
							'max'     => '100',
							'step'    => '1',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIMIT'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIMIT_DESC')
						),	
						'lightbox' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHTBOX'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHTBOX_DESC')
						),					
						'radius' => array(
							'type'    => 'slider',
							'default' => '0',
							'min'     => '0',
							'max'     => '100',
							'step'    => '1',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS_DESC')
						),	
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),
				// flip_box
				'flip_box' => array(
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLIP_BOX'),
					'type'     => 'wrap',
					'group'    => 'extra content',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLIP_BOX_DESC'),
					'icon'     => 'pencil',
					'atts'     => array(	
						'animation_style' => array(
							'type' => 'select',
							'values' => array(
								'horizontal_flip_left' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HORIZONTAL_FLIP_LEFT'),
								'horizontal_flip_right' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HORIZONTAL_FLIP_RIGHT'),
								'vertical_flip_top' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VERTICAL_FLIP_TOP'),
								'vertical_flip_bottom' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VERTICAL_FLIP_BOTTOM'),
								'flip_left' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLIP_LEFT'),
								'flip_right' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLIP_RIGHT'),
								'flip_top' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLIP_TOP'),
								'flip_bottom' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLIP_BOTTOM')
							),
							'default' => 'horizontal_flip_left',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ANIMATION_STYLE'),
							'desc' => sprintf( '%s.', JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ANIMATION_STYLE_DESC') )
						),
						'background' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#ffffff',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#444',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'border' => array(
							'type'    => 'border',
							'default' => '3px solid #cccccc',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_DESC')
						),
						'shadow' => array(
							'type'    => 'shadow',
							'default' => '0 0 0 #444444',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW_DESC')
						),
						'radius' => array(
							'type'    => 'slider',
							'min'     => 0,
							'max'     => 300,
							'step'    => 1,
							'default' => 0,
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS_DESC')
						),
						'text_align' => array(
							'type'    => 'select',
							'default' => 'center',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN_DESC'),
							'values'  => array(
								'left'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LEFT'),
								'center' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER'),
								'right'  => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIGHT')
							)
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content'  => sprintf( "[flip_front] Front Box Content [/flip_front]\n[flip_back] Back Box Content [/flip_back]")
				),
				// frame
				'frame' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FRAME'),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'align' => array(
							'type' => 'select',
							'values' => array(
								'left' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LEFT'),
								'center' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER'),
								'right' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIGHT')
							),
							'default' => 'left',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => '<img src="http://lorempixel.com/g/400/200/" />',
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FRAME_DESC'),
					'icon' => 'picture-o'
				),				
				// custom_gallery
				'custom_gallery' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CUSTOM_GALLERY'),
					'type' => 'single',
					'group' => 'gallery',
					'atts' => array(
						'source' => array(
							'type'    => 'image_source',
							'default' => 'none',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SOURCE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SOURCE_DESC')
						),
						'limit' => array(
							'type' => 'slider',
							'min' => -1,
							'max' => 100,
							'step' => 1,
							'default' => 20,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIMIT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIMIT_DESC')
						),
                        'link' => array(
							'type' => 'select',
							'values' => array(
								'none'       => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NONE'),
								'image'      => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_IMAGE'),
								'lightbox'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHTBOX'),
								'custom'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CUSTOM'),
								'attachment' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ATTACHMENT')
							),
							'default' => 'none',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LINK'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LINK_DESC')
						),
						'target' => array(
							'type' => 'select',
							'values' => array(
								'self' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SELF'),
								'blank' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BLANK')
							),
							'default' => 'self',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TARGET'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TARGET_DESC')
						),
						'width' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 1600,
							'step' => 10,
							'default' => 90,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH_DESC')
						),
						'height' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 1600,
							'step' => 10,
							'default' => 90,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT_DESC')
						),
						'title' => array(
							'type' => 'select',
							'values' => array(
								'never' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NEVER'),
								'hover' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HOVER'),
								'always' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALWAYS')
							),
							'default' => 'hover',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GALLERY_TITLE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GALLERY_TITLE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CUSTOM_GALLERY_DESC'),
					'icon' => 'picture-o'
				),
				// gmap
				'gmap' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ADDRESS_GMAP'),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MAP_WIDTH_DESC')
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MAP_HEIGHT_DESC')
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE_DESC')
						),
						'address' => array(
							'values' => array( ),
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ADDRESS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ADDRESS_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ADDRESS_GMAP_DESC'),
					'icon' => 'globe'
				),
				// gmap_advanced
				'gmap_advanced' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ADDRESS_GMAP_ADVANCED'),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MAP_WIDTH_DESC')
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MAP_HEIGHT_DESC')
						),
						'border' => array(
							'type'    => 'border',
							'default' => '0px solid #cccccc',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_DESC')
						),
						'lat' => array(
							'default' => '24.824874643579022',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GMAP_LAT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GMAP_LAT_DESC')
						),
						'lng' => array(
							'default' => '89.38262999446634',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GMAP_LNG'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GMAP_LNG_DESC')
						),
						'zoom' => array(
							'type' => 'slider',
							'min' => 1,
							'max' => 20,
							'step' => 1,
							'default' => 16,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MAP_ZOOM'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MAP_ZOOM_DESC')
						),
						'zoom_control' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ZOOM_CONRTOL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ZOOM_CONRTOL_DESC')
						),
						'zoom_control_style' => array(
							'type' => 'select',
							'values' => array(
								'SMALL' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MAP_ZOOM_CONTROL_SMALL'),
								'LARGE' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MAP_ZOOM_CONTROL_LARGE')
							),
							'default' => 'SMALL',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MAP_ZOOM_CONTROL_STYLE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MAP_ZOOM_CONTROL_STYLE_DESC')
						),
						'pan_control' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PAN_CONTROL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PAN_CONTROL_DESC')
						),
						'street_view_control' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STREET_VIEW_CONTROL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STREET_VIEW_CONTROL_DESC')
						),
						'map_location_marker' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LOCATION_MARKER'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LOCATION_MARKER_DESC')
						),
						'address' => array(
							'values' => array( ),
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ADDRESS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ADDRESS_DESC')
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ADDRESS_GMAP_ADVANCED_DESC'),
					'icon' => 'globe'
				),
				// heading
				'heading' => array(
					'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEADING'),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'modern-1-dark' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_1_DARK'),
								'modern-1-light' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_1_LIGHT'),
								'modern-1-blue' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_1_BLUE'),
								'modern-1-orange' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_1_ORANGE'),
								'modern-1-violet' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_1_VIOLET'),

								'modern-2-dark' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_2_DARK'),
								'modern-2-light' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_2_LIGHT'),
								'modern-2-blue' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_2_BLUE'),
								'modern-2-orange' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_2_ORANGE'),
								'modern-2-violet' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_2_VIOLET'),

								'line-dark' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LINE_DARK'),
								'line-light' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LINE_LIGHT'),
								'line-blue' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LINE_BLUE'),
								'line-orange' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LINE_ORANGE'),
								'line-violet' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LINE_VIOLET'),

								'dotted-line-dark' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DOTTED_LINE_DARK'),
								'dotted-line-light' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DOTTED_LINE_LIGHT'),
								'dotted-line-blue' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DOTTED_LINE_BLUE'),
								'dotted-line-orange' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DOTTED_LINE_ORANGE'),
								'dotted-line-violet' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DOTTED_LINE_VIOLET'),

								'flat-dark' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_DARK'),
								'flat-light' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_LIGHT'),
								'flat-blue' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_BLUE'),
								'flat-green' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_GREEN')
							),
							'default' => 'default',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'),
							'desc' => sprintf( '%s. ', JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC'))
						),
						'heading' => array(
							'type' => 'select',
							'values' => array(
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6'
							),
							'default' => 'h3',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEADING_TAG'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEADING_TAG_DESC')
						),
						'color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#666',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR'), 
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR_DESC')
						),
						'size' => array(
							'type' => 'slider',
							'min' => 7,
							'max' => 48,
							'step' => 1,
							'default' => 16,
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE_DESC')
						),
						'align' => array(
							'type' => 'select',
							'values' => array(
								'left' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LEFT'),
								'center' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER'),
								'right' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIGHT')
							),
							'default' => 'center',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN_DESC')
						),
						'margin' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 200,
							'step' => 10,
							'default' => 20,
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MARGIN'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MARGIN_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'Your heading text here',
					'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEADING_DESC'),
					'icon' => 'h-square'
				),
				// highlight
				'highlight' => array(
					'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HIGHLIGHT'),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'background' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#DDFF99',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#000000',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR'), 
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'Highlighted text',
					'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HIGHLIGHT_DESC'),
					'icon' => 'pencil'
				),
				// icon
				'icon' => array(
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON'),
					'type'     => 'single',
					'group'    => 'extra content media',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_HEADING_DESC'),
					'icon'     => 'rocket',
					'atts'     => array(
						'icon' => array(
							'type'    => 'icon',
							'default' => 'icon: heart',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'background' => array(
							'type'    => 'color',
							'default' => '#eeeeee',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'size' => array(
							'type'    => 'slider',
							'default' => '32',
							'min'     => '4',
							'max'     => '256',
							'step'    => '4',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE_DESC')
						),
						'radius' => array(
							'type'    => 'slider',
							'default' => '256',
							'min'     => '0',
							'max'     => '256',
							'step'    => '4',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS_DESC')
						),
						'shape_size' => array(
							'type'    => 'slider',
							'default' => '10',
							'min'     => '0',
							'max'     => '256',
							'step'    => '1',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHAPE_SIZE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHAPE_SIZE_DESC')
						),
						'border' => array(
							'type'    => 'border',
							'default' => '0px solid #444444',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_DESC')
						),
						'margin' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MARGIN'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MARGIN_DESC')
						),
						'url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
				),
				// icon_list_item
				'icon_list_item' => array(
					'content'  => __( 'Content', 'su' ),
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_LIST'),
					'type'     => 'wrap',
					'group'    => 'extra content',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_LIST_DESC'),
					'icon'     => 'pencil',
					'atts'     => array(
						'title' => array(
							'default' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'background' => array(
							'type' => 'color',
							'default' => 'transparent',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'icon' => array(
							'type'    => 'icon',
							'default' => 'icon: heart',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'icon_color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR_DESC')
						),
						'icon_size' => array(
							'type'    => 'slider',
							'min' => 10,
							'max' => 320,
							'step' => 1,
							'default' => 24,
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE_DESC')
						),
						'icon_border' => array(
							'type'    => 'border',
							'default' => '3px solid #cccccc',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_DESC')
						),
						'icon_shadow' => array(
							'type'    => 'shadow',
							'default' => '0 0 0 #444444',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW_DESC')
						),
						'icon_radius' => array(
							'type'    => 'slider',
							'min'     => 0,
							'max'     => 300,
							'step'    => 1,
							'default' => 0,
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS_DESC')
						),
						'text_align' => array(
							'type'    => 'select',
							'default' => 'center',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN_DESC'),
							'values'  => array(
								'left'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LEFT'),
								'top' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TOP'),
								'right'  => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIGHT')
							)
						),						
						'connector' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONNECTOR'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONNECTOR_DESC')
						),						
						'description_gap' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DESCRIPTION_GAP'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DESCRIPTION_GAP_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),
				// label
				'label' => array(
					'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LABEL'),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'type' => array(
							'type' => 'select',
							'values' => array(
								'default' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'success' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SUCCESS'),
								'warning' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WARNING'),
								'important' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_IMPORTANT'),
								'black' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BLACK'),
								'info' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_INFO')
							),
							'default' => 'default',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TYPE'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TYPE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'Label',
					'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LABEL_DESC'),
					'icon' => 'tag'
				),
				// lightbox
				'lightbox' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHTBOX'),
					'type' => 'wrap',
					'group' => 'gallery',
					'atts' => array(
						'type' => array(
							'type' => 'select',
							'values' => array(
								'iframe' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_IFRAME'),
								'image' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_IMAGE'),
								'inline' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_INLINE')
							),
							'default' => 'iframe',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TYPE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TYPE_DESC')
						),
						'src' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHTBOX_SOURCE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHTBOX_SOURCE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHTBOX_DESC'),
					'content' => '[%prefix_button] Click Here to Watch the Video [/%prefix_button]',
					'icon' => 'external-link'
				),
				// list
				'list' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIST'),
					'type' => 'wrap',
					'group' => 'content',
					'atts' => array(
						'icon' => array(
							'type' => 'icon',
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON'),
						    'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'icon_color' => array(
							'type' => 'color',
							'default' => '#333333',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => sprintf("<ul>\n<li>List item</li>\n<li>List item</li>\n<li>List item</li>\n</ul>"),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIST_DESC'),
					'icon' => 'list-ol'
				),
				// member
				'member' => array(
					'content'  => 'Type here some info about this team member',
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MEMBER'),
					'type'     => 'wrap',
					'group'    => 'extra box content',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MEMBER_DESC'),
					'icon'     => 'users',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'member' ),
					'atts'     => array(
						'background' => array(
							'type' => 'color',
							'default' => '#ffffff',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'color' => array(
							'type' => 'color',
							'default' => '#333333',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'border' => array(
							'type'    => 'border',
							'default' => '1px solid #cccccc',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_DESC')
						),
						'shadow' => array(
							'type'    => 'shadow',
							'default' => '0 1px 2px #eeeeee',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW_DESC')
						),
						'radius' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 60,
							'step' => 1,
							'default' => 0,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS_DESC')
						),
						'text_align' => array(
							'type'    => 'select',
							'default' => 'left',
							'values'  => array(
								'left' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LEFT'),
								'center' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER'),
								'right' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIGHT')
							),
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN_DESC')
						),
						'photo' => array(
							'type' => 'upload',
							'default' => 'http://lorempixel.com/400/300/business/',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PHOTO'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PHOTO_DESC')
						),
						'name' => array(
							'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NAME_DEFAULT'),
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NAME'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NAME_DESC')
						),
						'role' => array(
							'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ROLE_DEFAULT'),
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ROLE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ROLE_DESC')
						),
						'icon_1' => array(
							'type'    => 'icon',
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_1'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'icon_1_url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_1_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'icon_1_color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_1_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR_DESC')
						),
						'icon_1_title' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_1_TITLE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'icon_2' => array(
							'type'    => 'icon',
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_2'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'icon_2_url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_2_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'icon_2_color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_2_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR_DESC')
						),
						'icon_2_title' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_2_TITLE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'icon_3' => array(
							'type'    => 'icon',
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_3'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'icon_3_url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_3_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'icon_3_color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_3_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR_DESC')
						),
						'icon_3_title' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_3_TITLE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'icon_4' => array(
							'type'    => 'icon',
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_4'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'icon_4_url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_4_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'icon_4_color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_4_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR_DESC')
						),
						'icon_4_title' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_4_TITLE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'icon_5' => array(
							'type'    => 'icon',
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_5'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'icon_5_url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_5_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'icon_5_color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_5_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR_DESC')
						),
						'icon_5_title' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_5_TITLE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'icon_6' => array(
							'type'    => 'icon',
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_6'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'icon_6_url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_6_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'icon_6_color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_6_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR_DESC')
						),
						'icon_6_title' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_6_TITLE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),
				// note
				'note' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NOTE'),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'note_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#fffceb',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'text_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#e28327',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR_DESC')
						),
						'border' => array(
							'type'    => 'border',
							'default' => '1px solid #F3C1B6',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_DESC')
						),
						'radius' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 20,
							'step' => 1,
							'default' => 3,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS_DESC')
						),
						'icon' => array(
							'type' => 'icon',
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'icon_color' => array(
							'type' => 'color',
							'values' => array( ),
							'default' => '#FFFFFF',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NOTE_DESC'),
					'content' => 'Note text',
					'icon' => 'list-alt'
				),
				// panel
				'panel' => array(
					'content'  => 'Panel content',
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PANEL'),
					'type'     => 'wrap',
					'group'    => 'extra box',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PANEL_DESC'),
					'icon'     => 'pencil-square-o',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'panel' ),
					'atts'     => array(
						'background' => array(
							'type' => 'color',
							'default' => '#ffffff',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'color' => array(
							'type' => 'color',
							'default' => '#333333',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'border' => array(
							'type'    => 'border',
							'default' => '1px solid #cccccc',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_DESC')
						),
						'shadow' => array(
							'type'    => 'shadow',
							'default' => '0px 1px 2px #eeeeee',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW_DESC')
						),
						'radius' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 60,
							'step' => 1,
							'default' => 0,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS_DESC')
						),
						'text_align' => array(
							'type'    => 'select',
							'default' => 'left',
							'values' => array(
								'left' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LEFT'),
								'center' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER'),
								'right' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIGHT')
							),
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN_DESC')
						),
						'url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),
				// photo_panel
				'photo_panel' => array(
					'content'  => 'Panel content',
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PHOTO_PANEL'),
					'type'     => 'wrap',
					'group'    => 'extra box',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PHOTO_PANEL_DESC'),
					'icon'     => 'pencil-square-o',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'photo_panel' ),
					'atts'     => array(
						'background' => array(
							'type' => 'color',
							'default' => '#ffffff',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'color' => array(
							'type' => 'color',
							'default' => '#333333',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'border' => array(
							'type'    => 'border',
							'default' => '1px solid #cccccc',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_DESC')
						),
						'shadow' => array(
							'type'    => 'shadow',
							'default' => '0 1px 2px #eeeeee',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW_DESC')
						),
						'radius' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 60,
							'step' => 1,
							'default' => 0,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RADIUS_DESC')
						),
						'text_align' => array(
							'type'    => 'select',
							'default' => 'left',
							'values' => array(
								'left' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LEFT'),
								'center' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER'),
								'right' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIGHT')
							),
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN_DESC')
						),
						'photo' => array(
							'type' => 'upload',
							'default' => 'http://lorempixel.com/400/300/food/',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PHOTO'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PHOTO_DESC')
						),
						'url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),
				// plan
				'plan' => array(
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAN'),
					'type'     => 'wrap',
					'group'    => 'extra box',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAN_DESC'),
					'icon'     => 'table',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'plan' ),
					'atts'     => array(
						'name' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NAME'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NAME_DESC')
						),
						'price' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PRICE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PRICE_DESC')
						),
						'before' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BEFORE_PRICE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BEFORE_PRICE_DESC')
						),
						'after' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AFTER_PRICE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AFTER_PRICE_DESC')
						),
						'period' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PERIOD'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PERIOD_DESC')
						),
						'featured' => array(
							'type'    => 'bool',
							'default' => 'no',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FEATURED'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FEATURED_DESC')
						),
						'background' => array(
							'type'    => 'color',
							'default' => '#f9f9f9',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR_DESC')
						),
						'border' => array(
							'type'    => 'color',
							'default' => '#eeeeee',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_COLOR_DESC')
						),
						'shadow' => array(
							'type'    => 'shadow',
							'default' => '0px 0px 25px #eeeeee',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW_DESC')
						),
						'icon' => array(
							'type'    => 'icon',
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'icon_color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_COLOR_DESC')
						),
						'icon_size' => array(
							'type'    => 'slider',
							'min'     => 8,
							'max'     => 256,
							'step'    => 8,
							'default' => 48,
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_SIZE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_SIZE_DESC')
						),
						'btn_url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'btn_target' => array(
							'type'    => 'select',
							'default' => 'self',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_TARGET'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TARGET_DESC'),
							'values'   => array(
								'self' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SELF'),
								'blank' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BLANK')
							)
						),
						'btn_text' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_TEXT'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_TEXT_DESC')
						),
						'btn_background' => array(
							'type'    => 'color',
							'default' => '#999999',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_BACKGROUND'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'btn_color' => array(
							'type'    => 'color',
							'default' => '#ffffff',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BUTTON_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => sprintf( "<ul>\n<li>%s</li>\n<li>%s</li>\n<li>%s</li>\n</ul>", 'Option 1', 'Option 2', 'Option 3' )
				),
				// pricing_table
				'pricing_table' => array(
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PRICING_TABLE'),
					'type'     => 'wrap',
					'group'    => 'extra box',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PRICING_TABLE_DESC'),
					'icon'     => 'table',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'pricing_table' ),
					'atts'     => array(
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
                    'content' => sprintf('%s',"[%prefix_plan name='test 1' price='10' before='$' period='weekly' featured='yes' background='#f9f9f9' color='#500707' border='#faf675' shadow='0px 0px 25px #eeeeee' icon='icon: camera' icon_color='#333333' icon_size='48' btn_target='self' btn_background='#999999' btn_color='#ffffff']\n<ul>\n<li>Option 1</li>\n<li>Option 2</li>\n<li>Option 3</li>\n</ul>\n[/%prefix_plan]\n[%prefix_plan name='test 2' price='10' before='$' period='weekly' featured='yes' background='#f9f9f9' color='#500707' border='#faf675' shadow='0px 0px 25px #eeeeee' icon='icon: camera' icon_color='#333333' icon_size='48' btn_target='self' btn_background='#999999' btn_color='#ffffff']\n<ul>\n<li>Option 1</li>\n<li>Option 2</li>\n<li>Option 3</li>\n</ul>\n[/%prefix_plan]")
				),
				// progress_pie
				'progress_pie' => array(
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PROGRESS_PIE'),
					'type'     => 'single',
					'group'    => 'extra other',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PROGRESS_PIE_DESC'),
					'icon'     => 'star-half-o',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'progress_pie' ),
					'atts'     => array(
						'percent' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 100,
							'step' => 1,
							'default' => 75,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PERCENT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PERCENT_DESC')
						),
						'text' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_DESC')
						),
						'before' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BEFORE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BEFORE_DESC')
						),
						'after' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AFTER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AFTER_DESC')
						),
						'size' => array(
							'type' => 'slider',
							'min' => 20,
							'max' => 1200,
							'step' => 20,
							'default' => 200,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE_DESC')
						),
						'pie_width' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 100,
							'step' => 5,
							'default' => 30,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH_DESC')
						),
						'text_size' => array(
							'type' => 'slider',
							'min' => 10,
							'max' => 120,
							'step' => 5,
							'default' => 40,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_SIZE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_SIZE_DESC')
						),
						'align' => array(
							'type' => 'select',
							'values' => array(
								'none'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NONE'),
								'left'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LEFT'),
								'center' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER'),
								'right'  => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIGHT'),
							),
							'default' => 'center',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN_DESC')
						),
						'pie_color' => array(
							'type' => 'color',
							'default' => '#f0f0f0',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'fill_color' => array(
							'type' => 'color',
							'default' => '#97daed',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FILL_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FILL_COLOR_DESC')
						),
						'text_color' => array(
							'type' => 'color',
							'default' => '#cccccc',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),
				// progress_bar
				'progress_bar' => array(
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PROGRESS_BAR'),
					'type'     => 'single',
					'group'    => 'extra other',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PROGRESS_BAR_DESC'),
					'icon'     => 'star-half-o',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'progress_bar' ),
					'atts'     => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'fancy'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FANCY'),
								'thin'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_THIN')
							),
							'default' => 'default',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC')
						),
						'percent' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 100,
							'step' => 1,
							'default' => 75,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PERCENT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PERCENT_DESC')
						),
						'text' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_DESC')
						),
						'bar_color' => array(
							'type' => 'color',
							'default' => '#f0f0f0',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COLOR_DESC')
						),
						'fill_color' => array(
							'type' => 'color',
							'default' => '#97daed',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FILL_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FILL_COLOR_DESC')
						),
						'text_color' => array(
							'type' => 'color',
							'default' => '#555555',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),
				// pullquote
				'pullquote' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PULLQUOTE'),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'align' => array(
							'type' => 'select',
							'values' => array(
								'left' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LEFT'),
								'right' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIGHT')
							),
							'default' => 'left',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'Pullquote',
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PULLQUOTE_DESC'),
					'icon' => 'quote-left'
				),
				// quote
				'quote' => array(
					'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_QUOTE'),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'carbon' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CARBON'),
								'sharp' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHARP'),
								'grid' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GRID'),
								'wood' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WOOD'),
								'fabric' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FABRIC'),
								'modern-dark' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_DARK'),
								'modern-light' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_LIGHT'),
								'modern-Blue' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_BLUE'),
								'modern-violet' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_VIOLET'),
								'modern-orange' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_ORANGE'),
								'flat-dark' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_DARK'),
								'flat-light' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_LIGHT'),
								'flat-blue' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_BLUE'),
								'flat-green' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_GREEN')
							),
							'default' => 'default',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'),
							'desc' => sprintf( '%s. ', JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC') )
						),
						'cite' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CITE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CITE_DESC')
						),
						'url' => array(
							'values' => array( ),
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'Quote',
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_QUOTE_DESC'),
					'icon' => 'quote-right'
				),
				// row
				'row' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ROW'),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => sprintf('%s',"[%prefix_column size=\"1/3\"]Content[/%prefix_column]\n[%prefix_column size=\"1/3\"]Content[/%prefix_column]\n[%prefix_column size=\"1/3\"]Content[/%prefix_column]"),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ROW_DESC'),
					'icon' => 'columns'
				),
				// screenr
				'screenr' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SCREENR'),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SCREENR_URL_DESC')
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYER_WIDTH_DESC')
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYER_HEIGHT_DESC')
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SCREENR_DESC'),
					'icon' => 'youtube-play'
				),
				// section
				'section' => array(
					'content'  => 'Section content',
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SECTION'),
					'type'     => 'wrap',
					'group'    => 'extra box',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SECTION_DESC'),
					'icon'     => 'arrows-alt',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'section' ),
					'atts'     => array(
						'background' => array(
							'type'    => 'color',
							'default' => '#ffffff',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BACKGROUND_DESC')
						),
						'image' => array(
							'type' => 'upload',
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_IMAGE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_IMAGE_DESC' )
						),
						'parallax' => array(
							'type'    => 'bool',
							'default' => 'yes',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PARALLAX'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PARALLAX_DESC')
						),
						'speed' => array(
							'type'    => 'slider',
							'min'     => 1,
							'max'     => 12,
							'step'    => 1,
							'default' => 10,
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPEED'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPEED_DESC')
						),
						'max_width' => array(
							'type'    => 'slider',
							'min'     => 0,
							'max'     => 1600,
							'step'    => 10,
							'default' => 960,
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH_DESC')
						),
						'margin' => array(
							'default' => '0px 0px 0px 0px',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MARGIN'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MARGIN_DESC')
						),
						'padding' => array(
							'default' => '30px 0px 30px 0px',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PADDING'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PADDING_DESC')
						),
						'border' => array(
							'type'    => 'border',
							'default' => '1px solid #cccccc',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_DESC')
						),
						'color' => array(
							'type'    => 'color',
							'default' => '#333333',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TEXT_COLOR_DESC')
						),
						'text_align' => array(
							'type'    => 'select',
							'default' => 'left',
							'values'  => array(
								'left'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LEFT'),
								'center' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CENTER'),
								'right'  => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIGHT')
							),
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALIGN_DESC')
						),
						'text_shadow' => array(
							'type'    => 'shadow',
							'default' => '0 1px 10px #ffffff',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW_DESC')
						),
						'url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),
				// shadow
				'shadow' => array(
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW'),
					'type'     => 'wrap',
					'group'    => 'extra other',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW_HEADING_DESC'),
					'icon'     => 'moon-o',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'shadow' ),
					'content'  => '[panel]<img src="http://lorempixel.com/g/800/300/" alt="" />[/panel]',
					'atts'     => array(
						'style' => array(
							'type'    => 'select',
							'default' => 'default',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC'),
							'values'   => array(
								'default'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'left'       => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LEFT_CORNER'),
								'right'      => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RIGHT_CORNER'),
								'horizontal' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HORIZONTAL'),
								'vertical'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VERTICAL'),
								'bottom'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BOTTOM'),
								'simple'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIMPLE')
							)
						),
						'inline' => array(
							'type'    => 'bool',
							'default' => 'no',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_INLINE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_INLINE_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),
				// spacer
				'spacer' => array(
					'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPACER'),
					'type' => 'single',
					'group' => 'content other',
					'atts' => array(
						'size' => array(
							'type' => 'slider',
							'min' => 0,
							'max' => 800,
							'step' => 10,
							'default' => 20,
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPACER_DESC'),
					'icon' => 'arrows-v'
				),
				// splash
				'splash' => array(
					'content'  => 'Splash screen content',
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPLASH'),
					'type'     => 'wrap',
					'group'    => 'other',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPLASH_DESC'),
					'icon'     => 'bullhorn',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'splash' ),
					'atts' => array(
						'style' => array(
							'type'    => 'select',
							'default' => 'dark',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC'),
							'values'   => array(
								'dark'               => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DARK'),
								'dark-boxed'         => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DARK_BOXED'),
								'light'              => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHT'),
								'light-boxed'        => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHT_BOXED'),
								'blue-boxed'         => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BLUE_BOXED'),
								'light-boxed-blue'   => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHT_BOXED_BLUE'),
								'light-boxed-green'  => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHT_BOXED_GREEN'),
								'light-boxed-orange' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHT_BOXED_ORANGE'),
								'maintenance'        => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MAINTENANCE')
							)
						),
						'width' => array(
							'type'    => 'slider',
							'min'     => 100,
							'max'     => 1600,
							'step'    => 20,
							'default' => 480,
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH_DESC')
						),
						'opacity' => array(
							'type'    => 'slider',
							'min'     => 0,
							'max'     => 100,
							'step'    => 5,
							'default' => 80,
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_OPACITY'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_OPACITY_DESC')
						),
						'onclick' => array(
							'type'    => 'select',
							'default' => 'close-bg',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ONCLICK'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ONCLICK_DESC'),
							'values'  => array(
								'none'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NONE'),
								'close'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLOSE'),
								'close-bg' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLOSE_BG'),
								'url'      => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL')
							)
						),
						'url' => array(
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC'),
							'default' => '#'
						),
						'delay' => array(
							'type'    => 'slider',
							'min'     => 0,
							'max'     => 120,
							'step'    => 1,
							'default' => 0,
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DELAY'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DELAY_DESC')
						),
						'esc' => array(
							'type'    => 'bool',
							'default' => 'yes',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ESC'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ESC_DESC')
						),
						'close' => array(
							'type'    => 'bool',
							'default' => 'yes',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLOSE'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLOSE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					)
				),				
				// spoiler
				'spoiler' => array(
					'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPOILER'),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'title' => array(
							'default' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPOILER_TITLE_DEFAULT'),
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE'), 
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'open' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_OPEN'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_OPEN_DESC')
						),
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'fancy' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FANCY'),
								'simple' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIMPLE'),
								'carbon' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CARBON'),
								'sharp' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHARP'),
								'grid' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GRID'),
								'wood' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WOOD'),
								'fabric' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FABRIC'),
								'modern-dark' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_DARK'),
								'modern-light' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_LIGHT'),
								'modern-violet' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_VIOLET'),
								'modern-orange' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_ORANGE'),
								'glass-dark' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GLASS_DARK'),
								'glass-light' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GLASS_LIGHT'),
								'glass-blue' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GLASS_BLUE'),
								'glass-green' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GLASS_GREEN'),
								'glass-gold' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GLASS_GOLD')
							),
							'default' => 'default',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'),
							'desc' => sprintf( '%s.', JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC'))
						),
						'icon' => array(
							'type' => 'select',
							'values' => array(
								'plus'           => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLUS'),
								'plus-circle'    => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLUS_CIRCLE'),
								'plus-square-1'  => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLUS_SQUARE_1'),
								'plus-square-2'  => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLUS_SQUARE_2'),
								'arrow'          => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ARROW'),
								'arrow-circle-1' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ARROW_CIRCLE_1'),
								'arrow-circle-2' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ARROW_CIRCLE_2'),
								'chevron'        => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CHEVRON'),
								'chevron-circle' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CHEVRON_CIRCLE'),
								'caret'          => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CARET'),
								'caret-square'   => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CARET_SQUARE'),
								'folder-1'       => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FOLDER_1'),
								'folder-2'       => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FOLDER_2')
							),
							'default' => 'plus',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'anchor' => array(
							'default' => '',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ANCHOR'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ICON_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'Hidden content',
					'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SPOILER_DESC'),
					'icon' => 'list-ul'
				),
				// tab
				'tab' => array(
					'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TAB'),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'title' => array(
							'default' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'disabled' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DISABLE'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DISABLE_DESC')
						),
						'anchor' => array(
							'default' => '',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ANCHOR'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ANCHOR_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'Tab content',
					'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TAB_DESC'),
					'icon' => 'list-alt'
				),
				// tabs
				'tabs' => array(
					'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TABS'),
					'type' => 'wrap',
					'group' => 'box',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'carbon' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CARBON'),
								'sharp' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHARP'),
								'grid' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GRID'),
								'wood' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WOOD'),
								'fabric' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FABRIC'),
								'modern-dark' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_DARK'),
								'modern-light' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_LIGHT'),
								'modern-violet' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_VIOLET'),
								'modern-orange' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODERN_ORANGE'),
								'flat-dark' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_DARK'),
								'flat-light' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_LIGHT'),
								'flat-blue' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_BLUE'),
								'flat-green' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FLAT_GREEN')
							),
							'default' => 'default',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'),
							'desc' => sprintf( '%s.', JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC') )
						),
						'active' => array(
							'type' => 'number',
							'min' => 1,
							'max' => 100,
							'step' => 1,
							'default' => 1,
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ACTIVE_TAB'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ACTIVE_TAB_DESC')
						),
						'vertical' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VERTICAL'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VERTICAL_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => sprintf ('%s',"[%prefix_tab title=\"Title 1\"]Content 1[/%prefix_tab]\n[%prefix_tab title=\"Title 2\"]Content 2[/%prefix_tab]\n[%prefix_tab title=\"Title 3\"]Content 3[/%prefix_tab]"),
					'desc' => JText::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TABS_DESC'),
					'icon' => 'list-alt'
				),
				// table
				'table' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TABLE'),
					'type' => 'mixed',
					'group' => 'content',
					'atts' => array(
						'url' => array(
							//							'type' => 'upload',
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TABLE_DESC'),
					'content' => sprintf("<table>\n<tr>\n\t<td>Table</td>\n\t<td>Table</td>\n</tr>\n<tr>\n\t<td>Table</td>\n\t<td>Table</td>\n</tr>\n</table>"),
					'icon' => 'table'
				),
				// testimonial
				'testimonial' => array(
					'name'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TESTIMONIAL'),
					'type'     => 'wrap',
					'group'    => 'extra box',
					'desc'     => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TESTIMONIAL_DESC'),
					'icon'     => 'comments-o',
					'function' => array( 'Shortcodes_Ultimate_Extra_Shortcodes', 'testimonial' ),
					'atts'     => array(
						'name' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NAME'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NAME_DESC')
						),
						'photo' => array(
							'type'    => 'upload',
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PHOTO'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PHOTO_DESC')
						),
						'company' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COMPANY'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COMPANY_DESC')
						),
						'url' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COMPANY_URL'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_COMPANY_URL_DESC')
						),
						'target' => array(
							'type'    => 'select',
							'default' => 'blank',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TARGET'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TARGET_DESC'),
							'values'   => array(
								'self' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SELF'),
								'blank' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BLANK')
							)
						),
						'border' => array(
							'type'    => 'bool',
							'default' => 'yes',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BORDER_DESC')
						),
						'class' => array(
							'default' => '',
							'name'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc'    => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'content' => 'Testimonial text'
				),
				// tooltip
				'tooltip' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TOOLTIP'),
					'type' => 'wrap',
					'group' => 'other',
					'atts' => array(
						'style' => array(
							'type' => 'select',
							'values' => array(
								'light' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHT'),
								'dark' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DARK'),
								'yellow' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_YELLOW'),
								'green' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_GREEN'),
								'red' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RED'),
								'blue' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BLUE'),
								'youtube' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_YOUTUBE'),
								'tipsy' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TIPSY'),
								'bootstrap' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BOOTSTRAP'),
								'jtools' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_JTOOLS'),
								'tipped' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TIPPED'),
								'cluetip' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLUETIP'),
							),
							'default' => 'yellow',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_STYLE_DESC')
						),
						'position' => array(
							'type' => 'select',
							'values' => array(
								'north' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_NORTH'),
								'south' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SOUTH'),
								'west' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WEST'),
								'east' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_EAST')
							),
							'default' => 'top',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_POSITION'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_POSITION_DESC')
						),
						'shadow' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHADOW_DESC')
						),
						'rounded' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ROUND'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ROUND_DESC')
						),
						'size' => array(
							'type' => 'select',
							'values' => array(
								'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DEFAULT'),
								'1' => 1,
								'2' => 2,
								'3' => 3,
								'4' => 4,
								'5' => 5,
								'6' => 6,
							),
							'default' => 'default',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SIZE_DESC')
						),
						'title' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'content' => array(
							'default' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTENT_DEFAULT'),
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTENT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTENT_DESC')
						),
						'behavior' => array(
							'type' => 'select',
							'values' => array(
								'hover' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HOVER'),
								'click' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ONCLICK'),
								'always' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_ALWAYS')
							),
							'default' => 'hover',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BEHAVIOR'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_BEHAVIOR_DESC')
						),
						'close' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLOSE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLOSE_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TOOLTIP_DESC'),
					'content' => '[%prefix_button] Hover me to open tooltip [/%prefix_button]',
					'icon' => 'comment-o'
				),
				// video
				'video' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VIDEO'),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							//							'type' => 'upload',
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VIDEO_URL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VIDEO_URL_DESC')
						),
						'poster' => array(
							'type' => 'upload',
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_POSTER'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_POSTER_DESC')
						),
						'title' => array(
							'values' => array( ),
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_TITLE_DESC')
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYER_WIDTH_DESC')
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 300,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYER_HEIGHT_DESC')
						),
						'controls' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTROLS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTROLS_DESC')
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY_DESC')
						),
						'loop' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LOOP'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LOOP_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VIDEO_DESC'),
					'icon' => 'play-circle'
				),
				// vimeo
				'vimeo' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VIMEO'),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'values' => array( ),
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'), 
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VIMEO_URL_DESC')
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYER_WIDTH_DESC')
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYER_HEIGHT_DESC')
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE_DESC')
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_VIMEO_DESC'),
					'icon' => 'youtube-play'
				),
				// youtube
				'youtube' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_YOUTUBE'),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'values' => array( ),
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_YOUTUBE_URL_DESC')
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYER_WIDTH_DESC')
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYER_HEIGHT_DESC')
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE_DESC')
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_YOUTUBE_DESC'),
					'icon' => 'youtube-play'
				),
				// youtube_advanced
				'youtube_advanced' => array(
					'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_YOUTUBE_ADVANCED'),
					'type' => 'single',
					'group' => 'media',
					'atts' => array(
						'url' => array(
							'values' => array( ),
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_URL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_YOUTUBE_URL_DESC')
						),
						'playlist' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYLIST'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYLIST_DESC')
						),
						'width' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 600,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_WIDTH'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYER_WIDTH_DESC')
						),
						'height' => array(
							'type' => 'slider',
							'min' => 200,
							'max' => 1600,
							'step' => 20,
							'default' => 400,
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_HEIGHT'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_PLAYER_HEIGHT_DESC')
						),
						'responsive' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_RESPONSIVE_DESC')
						),
						'controls' => array(
							'type' => 'select',
							'values' => array(
								'no' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTROLS_NO'),
								'yes' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTROLS_YES'),
								'alt' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTROLS_ALT')
							),
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTROLS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CONTROLS_DESC')
						),
						'autohide' => array(
							'type' => 'select',
							'values' => array(
								'no' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOHIDE_NO'),
								'yes' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOHIDE_YES'),
								'alt' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOHIDE_ALT')
							),
							'default' => 'alt',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOHIDE'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOHIDE_DESC')
						),
						'showinfo' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHOWINFO'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_SHOWINFO_DESC')
						),
						'autoplay' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_AUTOPLAY_DESC')
						),
						'loop' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LOOP'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LOOP_DESC')
						),
						'rel' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_REL'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_REL_DESC')
						),
						'fs' => array(
							'type' => 'bool',
							'default' => 'yes',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_FS_DESC')
						),
						'modestbranding' => array(
							'type' => 'bool',
							'default' => 'no',
							'name' => 'modestbranding',
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_MODESTBRANDING_DESC')
						),
						'theme' => array(
							'type' => 'select',
							'values' => array(
								'dark' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_DARK'),
								'light' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_LIGHT')
							),
							'default' => 'dark',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_THEME'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_THEME_DESC')
						),
						'class' => array(
							'default' => '',
							'name' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS'),
							'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_CLASS_DESC')
						)
					),
					'desc' => JTEXT::_('PLG_SYSTEM_BDTHEMES_SHORTCODES_YOUTUBE_ADVANCED_DESC'),
					'icon' => 'youtube-play'
				),

			));
		// Return result       
        if($shortcode){
            return $shortcodes[$shortcode];
        }
        else{
			return $shortcodes;
        }
	}
}

class Shortcodes_Ultimate_Data extends Su_Data {
	function __construct() {
		parent::__construct();
	}
}