<?php

//error_reporting(E_ALL);

if (!defined('TEMPLATEURL')) {
    define('TEMPLATEURL', '/templates');
}

require_once dirname( __FILE__ ) . '/assets.php';

function image_media($image) {
    if (strpos($image, 'http://') === false && strpos($image, 'https://') === false) {
        return JUri::root() . $image;
    } else {
        return $image;
    }
}

/*  heading - -------------------------------------------------------- */
if (function_exists('heading')) {
    add_shortcode('heading', 'heading');
}

function heading($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'style' => 'default',
        'size' => 13,
        'align' => 'center',
        'margin' => '20',
        'heading' => 'h3',
        'color' => '',
        'class' => ''
            ), $atts, 'heading');
    su_query_asset('/css', 'su-heading');
    $heading_style = 'style="';
    $heading_style .= 'font-size: ' . intVal($atts['size']) . 'px;';
    $heading_style .= ($atts['color']) ? ' color: ' . $atts['color'] . ';' : '';
     $heading_style .= '"';

    return '<div class="su-heading su-heading-style-' . $atts['style'] . ' su-heading-align-' . $atts['align'] . su_ecssc($atts) . '" style="margin-bottom:' . $atts['margin'] . 'px"><'.$atts['heading'].' class="su-heading-inner" '.$heading_style.'>' . do_shortcode($content) . '</'.$atts['heading'].'></div>';
}

/* end heading - -------------------------------------------------------- */

/* drop cap - ------------------------------------------------------------ */
if (function_exists('dropcap')) {
    add_shortcode('dropcap', 'dropcap');
}

function dropcap($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'style' => 'default',
        'size' => 3,
        'class' => ''
            ), $atts, 'dropcap');
    // Calculate font-size
    if ($atts['style']=='simple') {
        $em = ($atts['size'] * 0.5) + 2 . 'em';
    }else {
        $em = $atts['size'] * 0.5 . 'em';
    }
    su_query_asset('/css', 'su-content-shortcodes');
    return '<span class="su-dropcap su-dropcap-style-' . $atts['style'] . su_ecssc($atts) . '" style="font-size:' . $em . '">' . do_shortcode($content) . '</span>';
}

/* /dropcat - ------------------------------------------------------------ */

/* button - ------------------------------------------------------------ */
if (function_exists('button')) {
    add_shortcode('button', 'button');
}

function button($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'url' => get_option('home'),
        'link' => null, // 3.x
        'target' => 'self',
        'style' => 'default',
        'background' => '#2D89EF',
        'color' => '#FFFFFF',
        'dark' => null, // 3.x
        'size' => 3,
        'wide' => 'no',
        'center' => 'no',
        'radius' => 'auto',
        'icon' => false,
        'icon_color' => '#FFFFFF',
        'ts_color' => null, // Dep. 4.3.2
        'ts_pos' => null, // Dep. 4.3.2
        'text_shadow' => 'none',
        'desc' => '',
        'onclick' => '',
        'class' => ''
            ), $atts, 'button');

    if ($atts['link'] !== null)
        $atts['url'] = $atts['link'];
    if ($atts['dark'] !== null) {
        $atts['background'] = $atts['color'];
        $atts['color'] = ( $atts['dark'] ) ? '#000' : '#fff';
    }
    if (is_numeric($atts['style']))
        $atts['style'] = str_replace(array('1', '2', '3', '4', '5'), array('default', 'glass', 'bubbles', 'noise', 'stroked'), $atts['style']); // 3.x





        
// Prepare vars
    $a_css = array();
    $span_css = array();
    $img_css = array();
    $small_css = array();
    $radius = '0px';
    $before = $after = '';
    // Text shadow values
    $shadows = array(
        'none' => '0 0',
        'top' => '0 -1px',
        'right' => '1px 0',
        'bottom' => '0 1px',
        'left' => '-1px 0',
        'top-right' => '1px -1px',
        'top-left' => '-1px -1px',
        'bottom-right' => '1px 1px',
        'bottom-left' => '-1px 1px'
    );
    // Common styles for button
    $styles = array(
        'size' => round(( $atts['size'] + 7 ) * 1.3),
        'ts_color' => ( $atts['ts_color'] === 'light' ) ? su_hex_shift($atts['background'], 'lighter', 50) : su_hex_shift($atts['background'], 'darker', 40),
        'ts_pos' => ( $atts['ts_pos'] !== null ) ? $shadows[$atts['ts_pos']] : $shadows['none']
    );
    // Calculate border-radius
    if ($atts['radius'] == 'auto')
        $radius = round($atts['size'] + 2) . 'px';
    elseif ($atts['radius'] == 'round')
        $radius = round(( ( $atts['size'] * 2 ) + 2 ) * 2 + $styles['size']) . 'px';
    elseif (is_numeric($atts['radius']))
        $radius = intval($atts['radius']) . 'px';
    // CSS rules for <a> tag
    $a_rules = array(
        'color' => $atts['color'],
        'background-color' => $atts['background'],
        'border-color' => su_hex_shift($atts['background'], 'darker', 20),
        'border-radius' => $radius,
        '-moz-border-radius' => $radius,
        '-webkit-border-radius' => $radius
    );
    // CSS rules for <span> tag
    $span_rules = array(
        'color' => $atts['color'],
        'padding' => ( $atts['icon'] ) ? round(( $atts['size'] ) / 2 + 4) . 'px ' . round($atts['size'] * 2 + 10) . 'px' : '4px ' . round($atts['size'] * 2 + 10) . 'px',
        'font-size' => $styles['size'] . 'px',
        'line-height' => ( $atts['icon'] ) ? round($styles['size'] * 1.5) . 'px' : round($styles['size'] * 2) . 'px',
        'border-color' => su_hex_shift($atts['background'], 'lighter', 30),
        'border-radius' => $radius,
        '-moz-border-radius' => $radius,
        '-webkit-border-radius' => $radius,
        'text-shadow' => $styles['ts_pos'] . ' 1px ' . $styles['ts_color'],
        '-moz-text-shadow' => $styles['ts_pos'] . ' 1px ' . $styles['ts_color'],
        '-webkit-text-shadow' => $styles['ts_pos'] . ' 1px ' . $styles['ts_color']
    );
    // Apply new text-shadow value
    if ($atts['ts_color'] === null && $atts['ts_pos'] === null) {
        $span_rules['text-shadow'] = $atts['text_shadow'];
        $span_rules['-moz-text-shadow'] = $atts['text_shadow'];
        $span_rules['-webkit-text-shadow'] = $atts['text_shadow'];
    }
    // CSS rules for <img> tag
    $img_rules = array(
        'width' => round($styles['size'] * 1.5) . 'px',
        'height' => round($styles['size'] * 1.5) . 'px'
    );
    // CSS rules for <small> tag
    $small_rules = array(
        'padding-bottom' => round(( $atts['size'] ) / 2 + 4) . 'px',
        'color' => $atts['color']
    );
    // Create style attr value for <a> tag
    foreach ($a_rules as $a_rule => $a_value)
        $a_css[] = $a_rule . ':' . $a_value;
    // Create style attr value for <span> tag
    foreach ($span_rules as $span_rule => $span_value)
        $span_css[] = $span_rule . ':' . $span_value;
    // Create style attr value for <img> tag
    foreach ($img_rules as $img_rule => $img_value)
        $img_css[] = $img_rule . ':' . $img_value;
    // Create style attr value for <img> tag
    foreach ($small_rules as $small_rule => $small_value)
        $small_css[] = $small_rule . ':' . $small_value;
    // Prepare button classes
    $classes = array('su-button', 'su-button-style-' . $atts['style']);
    // Additional classes
    if ($atts['class'])
        $classes[] = $atts['class']
;    // Wide class
    if ($atts['wide'] === 'yes')
        $classes[] = 'su-button-wide';
    // Prepare icon
    if ($atts['icon']) {
        if (strpos($atts['icon'], 'icon:') !== false) {
            $icon = '<i class="fa fa-' . trim(str_replace('icon:', '', $atts['icon'])) . '" style="font-size:' . $styles['size'] . 'px;color:' . $atts['icon_color'] . '"></i>';
            
        } else
            $icon = '<img src="' . image_media($atts['icon']) . '" alt="' . esc_attr($content) . '" style="' . implode($img_css, ';') . '" />';
    } else
        $icon = '';
    // Prepare <small> with description
    $desc = ( $atts['desc'] ) ? '<small style="' . implode($small_css, ';') . '">' . su_scattr($atts['desc']) . '</small>' : '';
    // Wrap with div if button centered
    if ($atts['center'] === 'yes') {
        $before .= '<div class="su-button-center">';
        $after .= '</div>';
    }
    // Replace icon marker in content,
    // add float-icon class to rearrange margins
    if (strpos($content, '%icon%') !== false) {
        $content = str_replace('%icon%', $icon, $content);
        $classes[] = 'su-button-float-icon';
    }
    // Button text has no icon marker, append icon to begin of the text
    else
        $content = $icon . ' ' . $content;
    // Prepare onclick action
    $atts['onclick'] = ( $atts['onclick'] ) ? ' onClick="' . $atts['onclick'] . '"' : '';
    su_query_asset('/css', 'su-button');
    return $before . '<a href="' . su_scattr($atts['url']) . '" class="' . implode($classes, ' ') . '" style="' . implode($a_css, ';') . '" target="_' . $atts['target'] . '"' . $atts['onclick'] . '><span style="' . implode($span_css, ';') . '">' . do_shortcode($content) . $desc . '</span></a>' . $after;
}

/* /button - ------------------------------------------------------------ */

/* frame - ------------------------------------------------------------ */

if (function_exists('frame')) {
    add_shortcode('frame', 'frame');
}

function frame($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'style' => 'default',
        'align' => 'left',
        'class' => ''
            ), $atts, 'frame');
    su_query_asset('/css', 'su-content-shortcodes');
    su_query_asset('/js', 'su-other-shortcodes');
    return '<span class="su-frame su-frame-align-' . $atts['align'] . ' su-frame-style-' . $atts['style'] . su_ecssc($atts) . '"><span class="su-frame-inner">' . do_shortcode($content) . '</span></span><div class="clear clearfix"></div>';
}

/* /frame - ------------------------------------------------------------ */


/* row - ------------------------------------------------------------ */
if (function_exists('row')) {
    add_shortcode('row', 'row');
}

function row($atts = null, $content = null) {
    $atts = shortcode_atts(array('class' => ''), $atts);
    return '<div class="su-row' . su_ecssc($atts) . '">' . su_do_shortcode($content, 'r') . '</div>';
}

/* /row - ------------------------------------------------------------ */

/* box - ------------------------------------------------------------ */
if (function_exists('box')) {
    add_shortcode('box', 'box');
}

function box($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'title' => __('This is box title', 'su'),
        'style' => 'default',
        'box_color' => '#333333',
        'title_color' => '#FFFFFF',
        'color' => null, // 3.x
        'radius' => '3',
        'class' => ''
            ), $atts, 'box');
    if ($atts['color'] !== null)
        $atts['box_color'] = $atts['color'];
    // Prepare border-radius
    $radius = ( $atts['radius'] != '0' ) ? 'border-radius:' . $atts['radius'] . 'px;-moz-border-radius:' . $atts['radius'] . 'px;-webkit-border-radius:' . $atts['radius'] . 'px;' : '';
    $title_radius = ( $atts['radius'] != '0' ) ? $atts['radius'] - 1 : '';
    $title_radius = ( $title_radius ) ? '-webkit-border-top-left-radius:' . $title_radius . 'px;-webkit-border-top-right-radius:' . $title_radius . 'px;-moz-border-radius-topleft:' . $title_radius . 'px;-moz-border-radius-topright:' . $title_radius . 'px;border-top-left-radius:' . $title_radius . 'px;border-top-right-radius:' . $title_radius . 'px;' : '';
    su_query_asset('/css', 'su-box-shortcodes');
    // Return result
    return '<div class="su-box su-box-style-' . $atts['style'] . su_ecssc($atts) . '" style="border-color:' . su_hex_shift($atts['box_color'], 'darker', 20) . ';' . $radius . '"><div class="su-box-title" style="background-color:' . $atts['box_color'] . ';color:' . $atts['title_color'] . ';' . $title_radius . '">' . su_scattr($atts['title']) . '</div><div class="su-box-content su-clearfix">' . su_do_shortcode($content, 'b') . '</div></div>';
}

/* /box- ------------------------------------------------------------ */

/* note - ------------------------------------------------------------ */
if (function_exists('note')) {
    add_shortcode('note', 'note');
}

function note($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'note_color' => '#FFFF66',
        'text_color' => '#333333',
        'icon'       =>'',
        'icon_color' =>'',
        'border'     => '',
        'radius'     => '3',
        'class'      => ''
            ), $atts, 'note');

    if ($atts['text_color'] !== null)
        $atts['text_color'] = 'color: ' . $atts['text_color'] . ';';

    if ($atts['note_color'] !== null)
        $atts['note_color'] = 'background: ' . $atts['note_color'] . ';';

    if ($atts['icon']) {
        if (strpos($atts['icon'], 'icon:') !== false) {
            $atts['icon'] = '<i class="note-icon fa fa-' . trim(str_replace('icon:', '', $atts['icon'])) . '" style="color:'. $atts['icon_color'].'"></i>';
            
        } else
            $atts['icon'] = '<img src="' . image_media($atts['icon']) . '" alt="" />';
    }

    if ($atts['border'] !== null)
        $atts['border'] = 'border: ' . $atts['border'] . ';';

    // Prepare border-radius
    $atts['radius'] = ( $atts['radius'] != '0' ) ? 'border-radius:' . $atts['radius'] . 'px;-moz-border-radius:' . $atts['radius'] . 'px;-webkit-border-radius:' . $atts['radius'] . 'px;' : '';

    su_query_asset('/css', 'su-box-shortcodes');

    return '<div class="su-note' . su_ecssc($atts) . '" style="' . $atts['border'] . $atts['radius'] . '"><div class="su-note-inner su-clearfix" style="' .$atts['text_color'] .$atts['note_color']. $atts['radius'] . '">'.$atts['icon'].' ' . su_do_shortcode($content, 'n') . '</div></div>';
}

/* note - ------------------------------------------------------------ */

/* column - trung  ------------------------------------------------------------ */
if (function_exists('column')) {
    add_shortcode('column', 'column');
}

function column($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'size' => '1/2',
        'center' => 'no',
        'last' => null,
        'class' => ''
            ), $atts, 'column');
    if ($atts['last'] !== null && $atts['last'] == '1')
        $atts['class'] .= ' su-column-last';
    if ($atts['center'] === 'yes')
        $atts['class'] .= ' su-column-centered';
    su_query_asset('/css', 'su-box-shortcodes');
    return '<div class="su-column su-column-size-' . str_replace('/', '-', $atts['size']) . su_ecssc($atts) . '"><div class="su-column-inner su-clearfix">' . su_do_shortcode($content, 'c') . '</div></div>';
}

/* /column - ------------------------------------------------------------ */


/* Hightlight ------------------------------------------------------------ */
if (function_exists('highlight')) {
    add_shortcode('highlight', 'highlight');
}

function highlight($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'background' => '#ddff99',
        'bg' => null, // 3.x
        'color' => '#000000',
        'class' => ''
            ), $atts, 'highlight');
    if ($atts['bg'] !== null)
        $atts['background'] = $atts['bg'];
    su_query_asset('/css', 'su-content-shortcodes');
    return '<span class="su-highlight' . su_ecssc($atts) . '" style="background:' . $atts['background'] . ';color:' . $atts['color'] . '">&nbsp;' . do_shortcode($content) . '&nbsp;</span>';
}

/* Hightlight - ------------------------------------------------------------ */

/* /tool tip - -------------------------------------------------- */
if (function_exists('tooltip')) {
    add_shortcode('tooltip', 'tooltip');
}

function tooltip($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'style' => 'yellow',
        'position' => 'north',
        'shadow' => 'no',
        'rounded' => 'no',
        'size' => 'default',
        'title' => '',
        'content' => __('Tooltip text', 'su'),
        'behavior' => 'hover',
        'close' => 'no',
        'class' => ''
            ), $atts, 'tooltip');
    // Prepare style
    $atts['style'] = ( in_array($atts['style'], array('light', 'dark', 'green', 'red', 'blue', 'youtube', 'tipsy', 'bootstrap', 'jtools', 'tipped', 'cluetip')) ) ? $atts['style'] : 'plain';
    // Position
    $atts['position'] = str_replace(array('top', 'right', 'bottom', 'left'), array('north', 'east', 'south', 'west'), $atts['position']);
    $position = array(
        'my' => str_replace(array('north', 'east', 'south', 'west'), array('bottom center', 'center left', 'top center', 'center right'), $atts['position']),
        'at' => str_replace(array('north', 'east', 'south', 'west'), array('top center', 'center right', 'bottom center', 'center left'), $atts['position'])
    );
    // Prepare classes
    $classes = array('su-qtip qtip-' . $atts['style']);
    $classes[] = 'su-qtip-size-' . $atts['size'];
    if ($atts['shadow'] === 'yes')
        $classes[] = 'qtip-shadow';
    if ($atts['rounded'] === 'yes')
        $classes[] = 'qtip-rounded';
    // Query assets
    su_query_asset('/css', 'su-qtip');
    su_query_asset('/css', 'su-other-shortcodes');
    su_query_asset('/js', 'su-qtip');
    su_query_asset('/js', 'su-other-shortcodes');
    return '<span class="su-tooltip' . su_ecssc($atts) . '" data-close="' . $atts['close'] . '" data-behavior="' . $atts['behavior'] . '" data-my="' . $position['my'] . '" data-at="' . $position['at'] . '" data-classes="' . implode(' ', $classes) . '" data-title="' . $atts['title'] .
            '" title="' . ( $atts['content'] ) . '">' . do_shortcode($content) . '</span>';
}

/* /tool tip - -------------------------------------------------- */

/* private - ------------------------------------------------------------ */

function su_private($atts = null, $content = null) {
    $atts = shortcode_atts(array('class' => ''), $atts, 'private');
    su_query_asset('/css', 'su-other-shortcodes');
    return ( current_user_can('publish_posts') ) ? '<div class="su-private' . su_ecssc($atts) . '"><div class="su-private-shell">' . do_shortcode($content) . '</div></div>' : '';
}

/* /private - ------------------------------------------------------------ */

/* media - ------------------------------------------------------------ */
if (function_exists('media')) {
    add_shortcode('media', 'media');
}

function media($atts = null, $content = null) {
    // Check YouTube video
    if (strpos($atts['url'], 'youtu') !== false)
        return Su_Shortcodes::youtube($atts);
    // Check Vimeo video
    elseif (strpos($atts['url'], 'vimeo') !== false)
        return Su_Shortcodes::vimeo($atts);
    // Image
    else
        return '<img src="' . image_media($atts['url']) . '" width="' . $atts['width'] . '" height="' . $atts['height'] . '" style="max-width:100%" />';
}

/* /media - ------------------------------------------------------------ */

/* youtube - ------------------------------------------------------------ */
if (function_exists('youtube')) {
    add_shortcode('youtube', 'youtube');
}

function youtube($atts = null, $content = null) {
    // Prepare data
    $return = array();
    $atts = shortcode_atts(array(
        'url' => false,
        'width' => 600,
        'height' => 400,
        'autoplay' => 'no',
        'responsive' => 'yes',
        'class' => ''
            ), $atts, 'youtube');
    if (!$atts['url'])
        return '<p class="su-error">YouTube: ' . __('please specify correct url', 'su') . '</p>';
    $atts['url'] = su_scattr($atts['url']);
    $id = ( preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $atts['url'], $match) ) ? $match[1] : false;
    // Check that url is specified
    if (!$id)
        return '<p class="su-error">YouTube: ' . __('please specify correct url', 'su') . '</p>';
    // Prepare autoplay
    $autoplay = ( $atts['autoplay'] === 'yes' ) ? '?autoplay=1' : '';
    // Create player
    $return[] = '<div class="su-youtube su-responsive-media-' . $atts['responsive'] . su_ecssc($atts) . '">';
    $return[] = '<iframe width="' . $atts['width'] . '" height="' . $atts['height'] . '" src="http://www.youtube.com/embed/' . $id . $autoplay . '" frameborder="0" allowfullscreen="true"></iframe>';
    $return[] = '</div>';
    su_query_asset('/css', 'su-media-shortcodes');
    // Return result
    return implode('', $return);
}

/* /youtube - ------------------------------------------------------------ */

/* youtube_advanced - ------------------------------------------------------------ */
if (function_exists('youtube_advanced')) {
    add_shortcode('youtube_advanced', 'youtube_advanced');
}

function youtube_advanced($atts = null, $content = null) {
    // Prepare data
    $return = array();
    $params = array();
    $atts = shortcode_atts(array(
        'url' => false,
        'width' => 600,
        'height' => 400,
        'autohide' => 'alt',
        'autoplay' => 'no',
        'controls' => 'yes',
        'fs' => 'yes',
        'loop' => 'no',
        'modestbranding' => 'no',
        'playlist' => '',
        'rel' => 'yes',
        'showinfo' => 'yes',
        'theme' => 'dark',
        'responsive' => 'yes',
        'class' => ''
            ), $atts, 'youtube_advanced');
    if (!$atts['url'])
        return '<p class="su-error">YouTube: ' . __('please specify correct url', 'su') . '</p>';
    $atts['url'] = su_scattr($atts['url']);
    $id = ( preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $atts['url'], $match) ) ? $match[1] : false;
    // Check that url is specified
    if (!$id)
        return '<p class="su-error">YouTube: ' . __('please specify correct url', 'su') . '</p>';
    // Prepare params
    foreach (array('autohide', 'autoplay', 'controls', 'fs', 'loop', 'modestbranding', 'playlist', 'rel', 'showinfo', 'theme') as $param)
        $params[$param] = str_replace(array('no', 'yes', 'alt'), array('0', '1', '2'), $atts[$param]);
    // Correct loop
    if ($params['loop'] === '1' && $params['playlist'] === '')
        $params['playlist'] = $id;
    // Prepare player parameters
    $params = http_build_query($params);
    // Create player
    $return[] = '<div class="su-youtube su-responsive-media-' . $atts['responsive'] . su_ecssc($atts) . '">';
    $return[] = '<iframe width="' . $atts['width'] . '" height="' . $atts['height'] . '" src="http://www.youtube.com/embed/' . $id . '?' . $params . '" frameborder="0" allowfullscreen="true"></iframe>';
    $return[] = '</div>';
    su_query_asset('/css', 'su-media-shortcodes');
    // Return result
    return implode('', $return);
}

/* /youtube_advanced - ------------------------------------------------------------ */

/* vimeo - ------------------------------------------------------------ */
if (function_exists('vimeo')) {
    add_shortcode('vimeo', 'vimeo');
}

function vimeo($atts = null, $content = null) {
    // Prepare data
    $return = array();
    $atts = shortcode_atts(array(
        'url' => false,
        'width' => 600,
        'height' => 400,
        'autoplay' => 'no',
        'responsive' => 'yes',
        'class' => ''
            ), $atts, 'vimeo');
    if (!$atts['url'])
        return '<p class="su-error">Vimeo: ' . __('please specify correct url', 'su') . '</p>';
    $atts['url'] = su_scattr($atts['url']);
    $id = ( preg_match('~(?:<iframe [^>]*src=")?(?:https?:\/\/(?:[\w]+\.)*vimeo\.com(?:[\/\w]*\/videos?)?\/([0-9]+)[^\s]*)"?(?:[^>]*></iframe>)?(?:<p>.*</p>)?~ix', $atts['url'], $match) ) ? $match[1] : false;
    // Check that url is specified
    if (!$id)
        return '<p class="su-error">Vimeo: ' . __('please specify correct url', 'su') . '</p>';
    // Prepare autoplay
    $autoplay = ( $atts['autoplay'] === 'yes' ) ? '&amp;autoplay=1' : '';
    // Create player
    $return[] = '<div class="su-vimeo su-responsive-media-' . $atts['responsive'] . su_ecssc($atts) . '">';
    $return[] = '<iframe width="' . $atts['width'] . '" height="' . $atts['height'] .
            '" src="http://player.vimeo.com/video/' . $id . '?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff' .
            $autoplay . '" frameborder="0" allowfullscreen="true"></iframe>';
    $return[] = '</div>';
    su_query_asset('/css', 'su-media-shortcodes');
    // Return result
    return implode('', $return);
}

/* /vimeo - ------------------------------------------------------------ */

/* screenr - ------------------------------------------------------------ */
if (function_exists('screenr')) {
    add_shortcode('screenr', 'screenr');
}

function screenr($atts = null, $content = null) {
    // Prepare data
    $return = array();
    $atts = shortcode_atts(array(
        'url' => false,
        'width' => 600,
        'height' => 400,
        'responsive' => 'yes',
        'class' => ''
            ), $atts, 'screenr');
    if (!$atts['url'])
        return '<p class="su-error">Screenr: ' . __('please specify correct url', 'su') . '</p>';
    $atts['url'] = su_scattr($atts['url']);
    $id = ( preg_match('~(?:<iframe [^>]*src=")?(?:https?:\/\/(?:[\w]+\.)*screenr\.com(?:[\/\w]*\/videos?)?\/([a-zA-Z0-9]+)[^\s]*)"?(?:[^>]*></iframe>)?(?:<p>.*</p>)?~ix', $atts['url'], $match) ) ? $match[1] : false;
    // Check that url is specified
    if (!$id)
        return '<p class="su-error">Screenr: ' . __('please specify correct url', 'su') . '</p>';
    // Create player
    $return[] = '<div class="su-screenr su-responsive-media-' . $atts['responsive'] . su_ecssc($atts) . '">';
    $return[] = '<iframe width="' . $atts['width'] . '" height="' . $atts['height'] .
            '" src="http://screenr.com/embed/' . $id . '" frameborder="0" allowfullscreen="true"></iframe>';
    $return[] = '</div>';
    su_query_asset('/css', 'su-media-shortcodes');
    // Return result
    return implode('', $return);
}

/* /screenr - ------------------------------------------------------------ */

/* audio - ------------------------------------------------------------ */
if (function_exists('audio')) {
    add_shortcode('audio', 'audio');
}

function audio($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'url' => false,
        'width' => 'auto',
        'title' => '',
        'autoplay' => 'no',
        'loop' => 'no',
        'class' => ''
            ), $atts, 'audio');
    if (!$atts['url'])
        return '<p class="su-error">Audio: ' . __('please specify correct url', 'su') . '</p>';
    $atts['url'] = su_scattr($atts['url']);
    // Generate unique ID
    $id = uniqid('su_audio_player_');
    // Prepare width
    $width = ( $atts['width'] !== 'auto' ) ? 'max-width:' . $atts['width'] : '';
    // Check that url is specified
    if (!$atts['url'])
        return '<p class="su-error">Audio: ' . __('please specify correct url', 'su') . '</p>';
    su_query_asset('/css', 'su-players-shortcodes');
    su_query_asset('/js', 'su-jplayer');
    su_query_asset('/js', 'su-players-shortcodes');
    // Create player
    return '<div class="su-audio' . su_ecssc($atts) . '" data-id="' . $id . '" data-audio="' . $atts['url'] . '" data-swf="' . (BDT_SU_URI . '/other/Jplayer.swf') . '" data-autoplay="' . $atts['autoplay'] . '" data-loop="' . $atts['loop'] . '" style="' . $width . '">
                <div id="' . $id . '" class="jp-jplayer"></div><div id="' . $id . '_container" class="jp-audio">
                    <div class="jp-type-single">
                        <div class="jp-gui jp-interface">
                            <div class="jp-controls">
                                <span class="jp-play"></span>
                                <span class="jp-pause"></span>
                                <span class="jp-stop"></span>
                                <span class="jp-mute"></span>
                                <span class="jp-unmute"></span>
                                <span class="jp-volume-max"></span>
                            </div>
                            <div class="jp-progress">
                                <div class="jp-seek-bar">
                                    <div class="jp-play-bar"></div>
                                </div>
                            </div>
                            <div class="jp-volume-bar">
                                <div class="jp-volume-bar-value"></div>
                            </div>
                            <div class="jp-current-time"></div>
                            <div class="jp-duration"></div>
                        </div>
                        <div class="jp-title">' . $atts['title'] . '</div>
                    </div>
                </div>
            </div>';
}

/* /audio - ------------------------------------------------------------ */

/* video - ------------------------------------------------------------ */
if (function_exists('video')) {
    add_shortcode('video', 'video');
}

function video($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'url' => false,
        'poster' => false,
        'title' => '',
        'width' => 600,
        'height' => 300,
        'controls' => 'yes',
        'autoplay' => 'no',
        'loop' => 'no',
        'class' => ''
            ), $atts, 'video');
    if (!$atts['url'])
        return '<p class="su-error">Video: ' . __('please specify correct url', 'su') . '</p>';
    $atts['url'] = su_scattr($atts['url']);
    // Generate unique ID
    $id = uniqid('su_video_player_');
    // Check that url is specified
    if (!$atts['url'])
        return '<p class="su-error">Video: ' . __('please specify correct url', 'su') . '</p>';
    // Prepare title
    $title = ( $atts['title'] ) ? '<div class="jp-title">' . $atts['title'] . '</div>' : '';
    su_query_asset('/css', 'su-players-shortcodes');
    su_query_asset('/js', 'su-jplayer');
    su_query_asset('/js', 'su-players-shortcodes');
    // Create player
    return '<div style="width:' . $atts['width'] . 'px">
                <div id="' . $id . '" class="su-video jp-video su-video-controls-' . $atts['controls'] . su_ecssc($atts) . '" data-id="' . $id . '" data-video="' . $atts['url'] . '" data-swf="' . (BDT_SU_URI.'/other/Jplayer.swf') . '" data-autoplay="' . $atts['autoplay'] . '" data-loop="' . $atts['loop'] . '" data-poster="' . $atts['poster'] . '">
                    <div id="' . $id . '_player" class="jp-jplayer" style="width:' . $atts['width'] . 'px;height:' . $atts['height'] . 'px"></div>' 
                        . $title . '
                    <div class="jp-start jp-play"></div>
                    <div class="jp-gui">
                        <div class="jp-interface">
                            <div class="jp-progress">
                                <div class="jp-seek-bar">
                                    <div class="jp-play-bar"></div>
                                </div>
                            </div>
                        <div class="jp-current-time"></div>
                        <div class="jp-duration"></div>
                        <div class="jp-controls-holder">
                            <span class="jp-play"></span>
                            <span class="jp-pause"></span>
                            <span class="jp-mute"></span>
                            <span class="jp-unmute"></span>
                            <span class="jp-full-screen"></span>
                            <span class="jp-restore-screen"></span>
                            <div class="jp-volume-bar">
                                <div class="jp-volume-bar-value"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>';
}

/* /video - ------------------------------------------------------------ */

/* table - ------------------------------------------------------------ */
if (function_exists('table')) {
    add_shortcode('table', 'table');
}

function table($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'url' => false,
        'class' => ''
            ), $atts, 'table');
    $return = '<div class="su-table' . su_ecssc($atts) . '">';
    $return .= ( $atts['url'] ) ? su_parse_csv($atts['url']) : do_shortcode($content);
    $return .= '</div>';
    su_query_asset('/css', 'su-content-shortcodes');
    su_query_asset('/js', 'su-other-shortcodes');
    return $return;
}

/* /table - ------------------------------------------------------------ */

/* subpages - ------------------------------------------------------------ */
if (function_exists('subpages')) {
    add_shortcode('subpages', 'subpages');
}

function subpages($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'depth' => 1,
        'p' => false,
        'class' => ''
            ), $atts, 'subpages');
    global $post;
    $child_of = ( $atts['p'] ) ? $atts['p'] : get_the_ID();
    $return = wp_list_pages(array(
        'title_li' => '',
        'echo' => 0,
        'child_of' => $child_of,
        'depth' => $atts['depth']
    ));
    return ( $return ) ? '<ul class="su-subpages' . su_ecssc($atts) . '">' . $return . '</ul>' : false;
}

/* /subpages - ------------------------------------------------------------ */

/* siblings - ------------------------------------------------------------ */
if (function_exists('siblings')) {
    add_shortcode('siblings', 'siblings');
}

function siblings($atts = null, $content = null) {
    $atts = shortcode_atts(array('depth' => 1, 'class' => ''), $atts, 'siblings');
    global $post;
    $return = wp_list_pages(array('title_li' => '',
        'echo' => 0,
        'child_of' => $post->post_parent,
        'depth' => $atts['depth'],
        'exclude' => $post->ID));
    return ( $return ) ? '<ul class="su-siblings' . su_ecssc($atts) . '">' . $return . '</ul>' : false;
}

/* siblings - ------------------------------------------------------------ */

/* document - ------------------------------------------------------------ */
if (function_exists('document')) {
    add_shortcode('document', 'document');
}

function document($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'url' => '',
        'file' => null, // 3.x
        'width' => 600,
        'height' => 400,
        'responsive' => 'yes',
        'class' => ''
            ), $atts, 'document');
    if ($atts['file'] !== null)
        $atts['url'] = $atts['file'];
    su_query_asset('/css', 'su-media-shortcodes');
    return '<div class="su-document su-responsive-media-' . $atts['responsive'] . '"><iframe src="http://docs.google.com/viewer?embedded=true&url=' . $atts['url'] . '" width="' . $atts['width'] . '" height="' . $atts['height'] . '" class="su-document' . su_ecssc($atts) . '"></iframe></div>';
}

/* /document - ------------------------------------------------------------ */

/* gmap - ------------------------------------------------------------ */
if (function_exists('gmap')) {
    add_shortcode('gmap', 'gmap');
}

function gmap($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'width' => 600,
        'height' => 400,
        'responsive' => 'yes',
        'address' => 'New York',
        'class' => ''
            ), $atts, 'gmap');
    su_query_asset('/css', 'su-media-shortcodes');
    return '<div class="su-gmap su-responsive-media-' . $atts['responsive'] . su_ecssc($atts) . '"><iframe width="' . $atts['width'] . '" height="' . $atts['height'] . '" src="http://maps.google.com/maps?q=' . urlencode(su_scattr($atts['address'])) . '&amp;output=embed"></iframe></div>';
}

/* /gmap - ------------------------------------------------------------ */




/* gmap_advanced - ------------------------------------------------------------ */
if (function_exists('gmap_advanced')) {
    add_shortcode('gmap_advanced', 'gmap_advanced');
}

function gmap_advanced($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'width' => 600,
        'height' => 400,
        'border' => '',
        'lat' => '',
        'lng' => '',
        'zoom' => '16',        
        'responsive' => '',
        'pan_control' => '',
        'street_view_control' => '',
        'map_location_marker' => '',
        'address' => 'Bangladesh',
        'zoom_control' => '1',
        'zoom_control_style' => '',
        'class' => ''
            ), $atts, 'gmap');
    su_query_asset('/js', 'su-gmaps');

    $atts['zoom_control'] = ($atts['zoom_control']=='yes') ? "true" : 'false';

    $atts['pan_control'] = ($atts['pan_control']=='yes') ? "true" : 'false';
    $atts['street_view_control'] = ($atts['street_view_control']=='yes') ? "true" : 'false';


    if ($atts['address'] && $atts['map_location_marker']) {
        $atts['address'] = 'infoWindow: { content: "<p>'.$atts['address'].'</p>" }';
    }else {$atts['address'] ='';} 
    


    if($atts['map_location_marker']=='yes') {
        $atts['map_location_marker'] = 'map.addMarker({ lat: '.$atts['lat'].', lng: '.$atts['lng'].','.$atts['address'] .'});';
    }else {$atts['map_location_marker'] = '';}
   


    $atts['width'] = ($atts['responsive']=='yes') ? "auto;" : $atts['width'].'px;' ;

    $unique_id = "gmap_" . rand(9, 9999);

    $atts['zoom_control_style'] = ($atts['zoom_control_style']) ? "zoomControlOpt: {
                style : '".($atts['zoom_control_style'])."',
                position: 'TOP_LEFT'  
            },": "";

    if (@$_REQUEST["action"] == 'su_generator_preview') {
        return __( 'This shortcode doesn\'t work in live preview. Please insert it into editor and preview on the site.', 'su' );
    }

    return '
    <div style="width:'.$atts['width'].'height:'.$atts['height'].'px;border:'.$atts['border'].';" id="'. $unique_id .'" class="su_gmap_advanced"></div>
        
        <script type="text/javascript"> 
            var map;
            jQuery(document).ready(function(){

                map = new GMaps({
                    el: '.$unique_id.',
                    lat: '. $atts['lat'].',
                    lng: '. $atts['lng'].',
                    zoomControl : '. $atts['zoom_control'].',
                    zoom: '. $atts['zoom'].',
                    '.$atts['zoom_control_style']. '
                    panControl : '.$atts['pan_control'] .',
                    streetViewControl: '.$atts['street_view_control'].'
                });

                '.$atts['map_location_marker'].'
            });

        </script>

        
        ';


}




/* slider - ------------------------------------------------------------ */
if (function_exists('slider')) {
    add_shortcode('slider', 'slider');
}

function slider($atts = null, $content = null) {
    $return = '';
    $atts = shortcode_atts(array(
        'source' => 'none',
        'limit' => 20,
        'gallery' => null, // Dep. 4.3.2
        'link' => 'none',
        'target' => 'self',
        'width' => 600,
        'height' => 300,
        'responsive' => 'yes',
        'title' => 'yes',
        'centered' => 'yes',
        'arrows' => 'yes',
        'pages' => 'yes',
        'mousewheel' => 'yes',
        'autoplay' => 3000,
        'speed' => 600,
        'class' => ''
            ), $atts, 'slider');
    // Get slides
    $slides = (array) Su_Tools::get_slides($atts);
    // Loop slides
    if (count($slides)) {
        // Prepare unique ID
        $id = uniqid('su_slider_');
        // Links target
        $target = ( $atts['target'] === 'yes' || $atts['target'] === 'blank' ) ? ' target="_blank"' : '';
        // Centered class
        $centered = ( $atts['centered'] === 'yes' ) ? ' su-slider-centered' : '';
        // Wheel control
        $mousewheel = ( $atts['mousewheel'] === 'yes' ) ? 'true' : 'false';
        // Prepare width and height
        $size = ( $atts['responsive'] === 'yes' ) ? 'width:100%' : 'width:' . intval($atts['width']) . 'px;height:' . intval($atts['height']) . 'px';
        // Open slider
        $return .= '<div id="' . $id . '" class="su-slider' . $centered . ' su-slider-pages-' . $atts['pages'] . ' su-slider-responsive-' . $atts['responsive'] . su_ecssc($atts) . '" style="' . $size . '" data-autoplay="' . $atts['autoplay'] . '" data-speed="' . $atts['speed'] . '" data-mousewheel="' . $mousewheel . '"><div class="su-slider-slides">';
        // Create slides
        foreach ($slides as $slide) {
            // Crop the image
//      $image = su_image_resize($slide['image'], $atts['width'], $atts['height']);
            $image = $slide['image'];
            // Prepare slide title
            $title = ( $atts['title'] === 'yes' && $slide['title'] ) ? '<span class="su-slider-slide-title">' . stripslashes($slide['title']) . '</span>' : '';
            // Open slide
            $return .= '<div class="su-slider-slide">';
            // Slide content with link
            if ($slide['link'])
                $return .= '<a href="' . $slide['link'] . '"' . $target . '><img src="' . image_media($image['url']) . '" alt="' . esc_attr($slide['title']) . '" />' . $title . '</a>';
            // Slide content without link
            else
                $return .= '<a><img src="' . image_media($image['url']) . '" alt="' . esc_attr($slide['title']) . '" />' . $title . '</a>';
            // Close slide
            $return .= '</div>';
        }
        // Close slides
        $return .= '</div>';
        // Open nav section
        $return .= '<div class="su-slider-nav">';
        // Append direction nav
        if ($atts['arrows'] === 'yes'
        )
            $return .= '<div class="su-slider-direction"><span class="su-slider-prev"></span><span class="su-slider-next"></span></div>';
        // Append pagination nav
        $return .= '<div class="su-slider-pagination"></div>';
        // Close nav section
        $return .= '</div>';
        // Close slider
        $return .= '</div>';
        su_query_asset('/css', 'su-galleries-shortcodes');
        su_query_asset('/js', 'swiper');
        su_query_asset('/js', 'su-galleries-shortcodes');
    }
    // Slides not found
    else
        $return = '<p class="su-error">Slider: ' . __('images not found', 'su') . '</p>';
    return $return;
}

/* /slider - ------------------------------------------------------------ */

/* carousel - ------------------------------------------------------------ */
if (function_exists('carousel')) {
    add_shortcode('carousel', 'carousel');
}

function carousel($atts = null, $content = null) {
    $return = '';
    $atts = shortcode_atts(array(
        'source' => 'none',
        'limit' => 20,
        'gallery' => null, // Dep. 4.3.2
        'link' => 'none',
        'target' => 'self',
        'width' => 600,
        'height' => 100,
        'responsive' => 'yes',
        'items' => 3,
        'scroll' => 1,
        'title' => 'yes',
        'centered' => 'yes',
        'arrows' => 'yes',
        'pages' => 'no',
        'mousewheel' => 'yes',
        'autoplay' => 3000,
        'speed' => 600,
        'class' => ''
            ), $atts, 'carousel');
    // Get slides
    $slides = (array) Su_Tools::get_slides($atts);
    // Loop slides
    if (count($slides)) {
        // Prepare unique ID
        $id = uniqid('su_carousel_');
        // Links target
        $target = ( $atts['target'] === 'yes' || $atts['target'] === 'blank' ) ? ' target="_blank"' : '';
        // Centered class
        $centered = ( $atts['centered'] === 'yes' ) ? ' su-carousel-centered' : '';
        // Wheel control
        $mousewheel = ( $atts['mousewheel'] === 'yes' ) ? 'true' : 'false';
        // Prepare width and height
        $size = ( $atts['responsive'] === 'yes' ) ? 'width:100%' : 'width:' . intval($atts['width']) . 'px;height:' . intval($atts['height']) . 'px';
        // Open slider
        $return .= '<div id="' . $id . '" class="su-carousel' . $centered . ' su-carousel-pages-' . $atts['pages'] . ' su-carousel-responsive-' . $atts['responsive'] . su_ecssc($atts) . '" style="' . $size . '" data-autoplay="' . $atts['autoplay'] . '" data-speed="' . $atts['speed'] . '" data-mousewheel="' . $mousewheel . '" data-items="' . $atts['items'] . '" data-scroll="' . $atts['scroll'] . '"><div class="su-carousel-slides">';
        // Create slides
        foreach ((array) $slides as $slide) {
            // Crop the image
            $image = su_image_resize($slide['image'], round($atts['width'] / $atts['items']), $atts['height']);
            // Prepare slide title
            $title = ( $atts['title'] === 'yes' && $slide['title'] ) ? '<span class="su-carousel-slide-title">' . stripslashes($slide['title']) . '</span>' : '';
            // Open slide
            $return .= '<div class="su-carousel-slide">';
            // Slide content with link
            if ($slide['link'])
                $return .= '<a href="' . $slide['link'] . '"' . $target . '><img src="' . image_media($image['url']) . '" alt="' . esc_attr($slide['title']) . '" />' . $title . '</a>';
            // Slide content without link
            else
                $return .= '<a><img src="' . image_media($image['url']) . '" alt="' . esc_attr($slide['title']) . '" />' . $title . '</a>';
            // Close slide
            $return .= '</div>';
        }
        // Close slides
        $return .= '</div>';
        // Open nav section
        $return .= '<div class="su-carousel-nav">';
        // Append direction nav
        if ($atts['arrows'] === 'yes'
        )
            $return .= '<div class="su-carousel-direction"><span class="su-carousel-prev"></span><span class="su-carousel-next"></span></div>';
        // Append pagination nav
        $return .= '<div class="su-carousel-pagination"></div>';
        // Close nav section
        $return .= '</div>';
        // Close slider
        $return .= '</div>';
        su_query_asset('/css', 'su-galleries-shortcodes');
        su_query_asset('/js', 'swiper');
        su_query_asset('/js', 'su-galleries-shortcodes');
    }
    // Slides not found
    else
        $return = '<p class="su-error">Carousel: ' . __('images not found', 'su') . '</p>';
    return $return;
}

/* /carousel - ------------------------------------------------------------ */

/* custom_gallery - ------------------------------------------------------------ */
if (function_exists('custom_gallery')) {
    add_shortcode('custom_gallery', 'custom_gallery');
}

function custom_gallery($atts = null, $content = null) {
  $return = '';
  $atts = shortcode_atts(array(
      'source' => 'none',
      'limit' => 20,
      'gallery' => null, // Dep. 4.4.0
      'link' => 'none',
      'width' => 90,
      'height' => 90,
      'title' => 'hover',
      'target' => 'self',
      'class' => ''
      ), $atts, 'custom_gallery');
  $slides = (array) Su_Tools::get_slides($atts);
  // Loop slides
  if (count($slides)) {
    // Prepare links target
    $atts['target'] = ( $atts['target'] === 'yes' || $atts['target'] === 'blank' ) ? ' target="_blank"' : '';
    // Add lightbox class
    if ($atts['link'] === 'lightbox')
      $atts['class'] .= ' su-lightbox-gallery';
    // Open gallery
    $return = '<div class="su-custom-gallery su-custom-gallery-title-' . $atts['title'] . su_ecssc($atts) . '">';
    // Create slides
    foreach ($slides as $slide) {
      // Crop image
      $image = su_image_resize(image_media($slide['image']), $atts['width'], $atts['height']);
      // Prepare slide title
      $title = ( $slide['title'] ) ? '<span class="su-custom-gallery-title">' . stripslashes($slide['title']) . '</span>' : '';
      // Open slide
      $return .= '<div class="su-custom-gallery-slide ">';
      // Slide content with link
      if ($slide['link'])
    $return .= '<a  href="' . image_media($slide['link']) . '"' . $atts['target'] . '><img src="' . image_media($image['url']) . '" alt="' . esc_attr($slide['title']) . '" width="' . $atts['width'] . '" height="' . $atts['height'] . '" />' . $title . '</a>';
      // Slide content without link
      else
    $return .= '<a><img src="' . image_media($image['url']) . '" alt="' . esc_attr($slide['title']) . '" width="' . $atts['width'] . '" height="' . $atts['height'] . '" />' . $title . '</a>';
      // Close slide
      $return .= '</div>';
    }
    // Clear floats
    $return .= '<div class="su-clear"></div>';
    // Close gallery
    $return .= '</div>';
    // Add lightbox assets
    if ($atts['link'] === 'lightbox') {
      su_query_asset('/css', 'su-magnific-popup');
      su_query_asset('/js', 'su-magnific-popup');
      su_query_asset('/js', 'su-galleries-shortcodes');
    }
    su_query_asset('/css', 'su-galleries-shortcodes');
  }
  // Slides not found
  else
    $return = '<p class="su-error">Custom gallery: ' . __('Images not found', 'su') . '</p>';
  return $return;
}

/* /custom_gallery - ------------------------------------------------------------ */

/* dummy_text - ------------------------------------------------------------ */
if (function_exists('dummy_text')) {
    add_shortcode('dummy_text', 'dummy_text');
}

function dummy_text($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'amount' => 1,
        'what' => 'paras',
        'cache' => 'yes',
        'class' => ''
            ), $atts, 'dummy_text');

    $xml = simplexml_load_file('http://www.lipsum.com/feed/xml?amount=' . $atts['amount'] . '&what=' . $atts['what'] . '&start=0');
//    echo 'http://www.lipsum.com/feed/xml?amount=' . $atts['amount'] . '&what=' . $atts['what'] . '&start=0';exit;
    $return = '<div class="su-dummy-text' . su_ecssc($atts) . '">' . wpautop(str_replace("\n", "\n\n", $xml->lipsum)) . '</div>';
//    set_transient($transient, $return, 60 * 60 * 24 * 30);
    return $return;
}

/* /dummy_text - ------------------------------------------------------------ */

/* dummy_image - ------------------------------------------------------------ */
if (function_exists('dummy_image')) {
    add_shortcode('dummy_image', 'dummy_image');
}

function dummy_image($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'width' => 500,
        'height' => 300,
        'theme' => 'any',
        'class' => ''
            ), $atts, 'dummy_image');
    $url = 'http://lorempixel.com/' . $atts['width'] . '/' . $atts['height'] . '/';
    if ($atts['theme'] !== 'any')
        $url .= $atts['theme'] . '/' . rand(0, 10) . '/';
    return '<img src="' . $url . '" alt="' . __('Dummy image', 'su') . '" width="' . $atts['width'] . '" height="' . $atts['height'] . '" class="su-dummy-image' . su_ecssc($atts) . '" />';
}

/* /dummy_image - ------------------------------------------------------------ */

/* animate - ------------------------------------------------------------ */

if (function_exists('animate')) {
    add_shortcode('animate', 'animate');
}

function animate($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'type' => 'bounceIn',
        'duration' => 1,
        'delay' => 0,
        'inline' => 'no',
        'class' => ''
            ), $atts, 'animate');
    $tag = ( $atts['inline'] === 'yes' ) ? 'span' : 'div';
    $style = array(
        'duration' => array(),
        'delay' => array()
    );
    foreach (array('-webkit-', '-moz-', '-ms-', '-o-', '') as $vendor) {
        $style['duration'][] = $vendor . 'animation-duration:' . $atts['duration'] . 's';
        $style['delay'][] = $vendor . 'animation-delay:' . $atts['delay'] . 's';
    }
    $return = '<' . $tag . ' class="su-animate ' . $atts['type'] . su_ecssc($atts) . '" style="visibility:hidden;' . implode(';', $style['duration']) . ';' . implode(';', $style['delay']) . '" data-animation="' . $atts['type'] . '">' . do_shortcode($content) . '</' . $tag . '>';
    su_query_asset('/css', 'su-animate');
    su_query_asset('/js', 'su-inview');
    su_query_asset('/js', 'su-other-shortcodes');
    return $return;
}

/* /animate - ------------------------------------------------------------ */

/* spacer - ------------------------------------------------------------ */

if (function_exists('spacer')) {
    add_shortcode('spacer', 'spacer');
}

function spacer($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'size' => '20',
        'class' => ''
            ), $atts, 'spacer');
    su_query_asset('/css', 'su-content-shortcodes');
    return '<div class="su-spacer' . su_ecssc($atts) . '" style="height:' . (string) $atts['size'] . 'px"></div>';
}

/* /spacer - ------------------------------------------------------------ */


/* spoiler - ------------------------------------------------------------ */

if (function_exists('spoiler')) {
    add_shortcode('spoiler', 'spoiler');
}

function spoiler($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'title' => __('Spoiler title', 'su'),
        'open' => 'no',
        'style' => 'default',
        'icon' => 'plus',
        'anchor' => '',
        'class' => ''
            ), $atts, 'spoiler');
    $atts['style'] = str_replace(array('1', '2'), array('default', 'fancy'), $atts['style']);
    $atts['anchor'] = ( $atts['anchor'] ) ? ' data-anchor="' . str_replace(' ', '', trim(sanitize_text_field($atts['anchor']))) . '"' : '';
    if ($atts['open'] !== 'yes')
        $atts['class'] .= ' su-spoiler-closed';
    su_query_asset('/css', 'su-font-awesome');
    su_query_asset('/css', 'su-spoiler');
    su_query_asset('/css', 'su-box-shortcodes');
    su_query_asset('/js', 'su-other-shortcodes');
    return '<div class="su-spoiler su-spoiler-style-' . $atts['style'] . ' su-spoiler-icon-' . $atts['icon'] . su_ecssc($atts) . '"' . $atts['anchor'] . '><div class="su-spoiler-title"><span class="su-spoiler-icon"></span>' . su_scattr($atts['title']) . '</div><div class="su-spoiler-content su-clearfix">' . su_do_shortcode($content, 's') . '</div></div>';
}

/* /spoiler - ------------------------------------------------------------ */

/* label - ------------------------------------------------------------ */
if (function_exists('label')) {
    add_shortcode('label', 'label');
}

function label($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'type' => 'default',
        'style' => null, // 3.x
        'class' => ''
            ), $atts, 'label');
    if ($atts['style'] !== null)
        $atts['type'] = $atts['style'];
    su_query_asset('/css', 'su-content-shortcodes');
    return '<span class="su-label su-label-type-' . $atts['type'] . su_ecssc($atts) . '">' . do_shortcode($content) . '</span>';
}

/* /label - ------------------------------------------------------------ */

/* quote ------------------------------ */
if (function_exists('quote')) {
    add_shortcode('quote', 'quote');
}

function quote($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'style' => 'default',
        'cite' => false,
        'url' => false,
        'class' => ''
            ), $atts, 'quote');
    $cite_link = ( $atts['url'] && $atts['cite'] ) ? '<a href="' . $atts['url'] . '" target="_blank">' . $atts['cite'] . '</a>' : $atts['cite'];
    $cite = ( $atts['cite'] ) ? '<span class="su-quote-cite">' . $cite_link . '</span>' : '';
    $cite_class = ( $atts['cite'] ) ? ' su-quote-has-cite' : '';
    su_query_asset('/css', 'su-box-shortcodes');
    su_query_asset('/css', 'su-quote');
    return '<div class="su-quote su-quote-style-' . $atts['style'] . $cite_class . su_ecssc($atts) . '"><div class="su-quote-inner su-clearfix">' . do_shortcode($content) . su_scattr($cite) . '</div></div>';
}

/* end quote ----------------------------- */

/* divider --------------------- ------------------ */
if (function_exists('divider')) {
    add_shortcode('divider', 'divider');
}

function divider($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'top' => 'yes',
        'text' => __('Go to top', 'su'),
        'margin_top' => '',
        'margin_bottom' => '',
        'margin_left' => '',
        'margin_right' => '',
        'class' => ''
            ), $atts, 'divider');

    $top = ( $atts['top'] === 'yes' ) ? '<a href="#">' . su_scattr($atts['text']) . '</a>' : '';

    su_query_asset('/css', 'su-content-shortcodes');

    $margin = '';
    
    if (($atts['margin_top']) or ($atts['margin_right']) or ($atts['margin_bottom']) or ($atts['margin_left'])) {
        $margin = 'margin: ';
        $margin .= ($atts['margin_top']) ? $atts['margin_top'].'px ' : '0';
        $margin .= ($atts['margin_right']) ? $atts['margin_right'] . 'px ' : '0 ';
        $margin .= ($atts['margin_bottom']) ? $atts['margin_bottom'].'px ' : '0';
        $margin .= ($atts['margin_left']) ? $atts['margin_left'] . 'px;' : '0;';
    }

    return '<div class="su-divider' . su_ecssc($atts) . '" style="'.$margin.'">' . $top . '</div>';
}

/* end divider --------------------- ------------------ */

/* pull pullquote ------------ -------------------- */
if (function_exists('pullquote')) {
    add_shortcode('pullquote', 'pullquote');
}

function pullquote($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'align' => 'left',
        'class' => ''
            ), $atts, 'pullquote');
    su_query_asset('/css', 'su-box-shortcodes');
    return '<div class="su-pullquote su-pullquote-align-' . $atts['align'] . su_ecssc($atts) . '">' . do_shortcode($content) . '</div>';
}

/* end pullquote ------------ -------------------- */

/* accordion ------------ -------------------- */
if (function_exists('accordion')) {
    add_shortcode('accordion', 'accordion');
}

function accordion($atts = null, $content = null) {
    $atts = shortcode_atts(array('class' => ''), $atts, 'accordion');
    return '<div class="su-accordion' . su_ecssc($atts) . '">' . do_shortcode($content) . '</div>';
}

/* end accordion ------------ -------------------- */

/* Get Shortcode UnAutop ------------------------------------------------------------ */
if (!function_exists("bdt_get_shortcode_unautop")) {

    function bdt_get_shortcode_unautop($content) {
        $content = do_shortcode(shortcode_unautop($content));
        $content = preg_replace('#^<\/p>|^<br\s?\/?>|<p>$|<p>\s*(&nbsp;)?\s*<\/p>#', '', $content);
        return $content;
    }

}


/* Dividers / Spacers / Rulers ------------------------------------------------------------ */

if (!function_exists('sc_divider')) {

    function sc_divider($atts, $content = null, $sc_name = '') {
        extract(shortcode_atts(array('size' => '', 'colored' => 'false'), $atts));
        $colored = ($colored == 'true') ? 'colored' : '';
        return bdt_get_shortcode_unautop("<span class='{$sc_name} {$size} {$colored}'></span>");
    }

}

if (function_exists('sc_divider')) {
    add_shortcode('hr', 'sc_divider');
}


if (!function_exists('sc_span')) {

    function sc_span($atts, $content = null, $sc_name = '') {
        extract(shortcode_atts(array('class' => ''), $atts));
        return "<span class='$class'>" . do_shortcode($content) . "</span>";
    }

}

if (function_exists('sc_span')) {
    add_shortcode('span', 'sc_span');
}






/* added by for list */
if (function_exists('su_list')) {
    add_shortcode('list', 'su_list');
}

function su_list($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'icon' => 'icon: star',
        'icon_color' => '#333',
        'style' => null,
        'class' => ''
            ), $atts, 'list');
    if (strpos($atts['icon'], 'icon:') !== false) {
        $atts['icon'] = '<i class="fa fa-' . trim(str_replace('icon:', '', $atts['icon'])) . '" style="color:' . $atts['icon_color'] . '"></i>';
        
    } else
        $atts['icon'] = '<img src="' . image_media($atts['icon']) . '" alt="" />';
    su_query_asset('/css', 'su-content-shortcodes');
    return '<div class="su-list su-list-style-' . $atts['style'] . su_ecssc($atts) . '">' . str_replace('<li>', '<li>' . $atts['icon'] . ' ', su_do_shortcode($content, 'l')) . '</div>';
}

/* end added by for list */

/* --------------light box------------------ */
/* added by for light box */
if (function_exists('lightbox')) {
    add_shortcode('lightbox', 'lightbox');
}

function lightbox($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'src' => false,
        'type' => 'iframe',
        'class' => ''
            ), $atts, 'lightbox');
    if (!$atts['src'])
        return '<p class="su-error">Lightbox: ' . __('please specify correct source', 'su') . '</p>';
    su_query_asset('/css', 'magnific-popup');
    su_query_asset('/js', 'su-magnific-popup');
    su_query_asset('/js', 'su-other-shortcodes');
    return '<span class="su-lightbox' . su_ecssc($atts) . '" data-mfp-src="' . su_scattr($atts['src']) . '" data-mfp-type="' . $atts['type'] . '">' . do_shortcode($content) . '</span>';
}

/* end added by for lightbox */


/* added by for dummy_image */
if (function_exists('dummy_image')) {
    add_shortcode('dummy_image', 'dummy_image');
}


if (function_exists('tabs')) {
    add_shortcode('tabs', 'tabs');
}
$GLOBALS['tabs'] = array();
$GLOBALS['tab_count'] = 0;

function tabs($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'active' => 1,
        'vertical' => 'no',
        'style' => 'default', // 3.x
        'class' => ''
            ), $atts, 'tabs');
    if ($atts['style'] === '3')
        $atts['vertical'] = 'yes';
    do_shortcode($content);
    $return = '';
    $tabs = $panes = array();
    if (is_array($GLOBALS['tabs'])) {
        if ($GLOBALS['tab_count'] < $atts['active'])
            $atts['active'] = $GLOBALS['tab_count'];
        foreach ($GLOBALS['tabs'] as $tab) {
            $tabs[] = '<span class="' . su_ecssc($tab) . $tab['disabled'] . '"' . $tab['anchor'] . '>' . su_scattr($tab['title']) . '</span>';
            $panes[] = '<div class="su-tabs-pane su-clearfix' . su_ecssc($tab) . '">' . $tab['content'] . '</div>';
        }
        $atts['vertical'] = ( $atts['vertical'] === 'yes' ) ? ' su-tabs-vertical' : '';
        $return = '<div class="su-tabs su-tabs-style-' . $atts['style'] . $atts['vertical'] . su_ecssc($atts) . '" data-active="' . (string) $atts['active'] . '"><div class="su-tabs-nav">' . implode('', $tabs) . '</div><div class="su-tabs-panes">' . implode("\n", $panes) . '</div></div>';
    }
    // Reset tabs
    $GLOBALS['tabs'] = array();
    $GLOBALS['tab_count'] = 0;
    su_query_asset('/css', 'su-box-shortcodes');
    su_query_asset('/css', 'su-tabs');
    su_query_asset('/js', 'su-other-shortcodes');
    return $return;
}

if (function_exists('tab')) {
    add_shortcode('tab', 'tab');
}

function tab($atts = null, $content = null) {
    $atts = shortcode_atts(array(
        'title' => __('Tab title', 'su'),
        'disabled' => 'no',
        'anchor' => '',
        'class' => ''
            )
            , $atts, 'tab');
    $x = $GLOBALS['tab_count'];
    $tabs = $GLOBALS['tabs'];
    $GLOBALS['tabs'][$x] = array(
        'title' => $atts['title'],
        'content' => do_shortcode($content),
        'disabled' => ( $atts['disabled'] === 'yes' ) ? ' su-tabs-disabled' : '',
        'anchor' => ( $atts['anchor'] ) ? ' data-anchor="' . str_replace(' ', '', trim(sanitize_text_field($atts['anchor']))) . '"' : '',
        'class' => $atts['class']
    );
    $GLOBALS['tab_count'] ++;
    su_query_asset('/js', 'su-other-shortcodes');

//		do_action( 'su/shortcode/tab', $atts );
}

/* ------------------------------------------------------------------------------ */
/* ------------------------------- EXTRA SHORTCODE ------------------------------ */
/* ------------------------------------------------------------------------------ */


/* ------------------------------- Splash ----------------------------------------------- */
if (!function_exists('splash')) {

    function splash($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'style' => 'dark',
            'width' => 480,
            'opacity' => 80,
            'onclick' => 'close-bg',
            'url' => 'http://www.bdthemes.com',
            'delay' => 0,
            'esc' => 'yes',
            'close' => 'yes',
            'class' => ''
                ), $atts, 'splash');

        $atts['opacity'] = (!is_numeric($atts['opacity']) || $atts['opacity'] > 100 || $atts['opacity'] < 0 ) ? 0.8 : $atts['opacity'] / 100;
        su_query_asset('/css', 'magnific-popup');
        su_query_asset('/css', 'su-splash');
        su_query_asset('/js', 'su-magnific-popup');
        su_query_asset('/js', 'su-extra');

        if (@$_REQUEST["action"] == 'su_generator_preview') 
        	return __( 'This shortcode doesn\'t work in live preview. Please insert it into editor and preview on the site.', 'su' );

        return '<div class="su-splash" data-esc="' . $atts['esc'] . '" data-close="' . $atts['close'] . '" data-onclick="' . $atts['onclick'] . '" data-url="' . $atts['url'] . '" data-opacity="' . (string) $atts['opacity'] . '" data-width="' . $atts['width'] . '" data-style="su-splash-style-' . $atts['style'] . '" data-delay="' . (string) $atts['delay'] . '"><div class="su-splash-screen su-content-wrap' . su_ecssc($atts) . '">' . do_shortcode($content) . '</div></div>';
    }

}

if (function_exists('splash')) {
    add_shortcode('splash', 'splash');
}


/* ------------------------------- panel ----------------------------------------------- */
if (!function_exists('panel')) {

    function panel($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'background' => '#ffffff',
            'color' => '#333333',
            'shadow' => '',
            'border' => '1px solid #cccccc',
            'radius' => '0',
            'text_align' => 'left',
            'url' => '',
            'class' => ''
                ), $atts, 'panel');

        if ($atts['url']) {
            $atts['class'] .= ' su-panel-clickable';
            su_query_asset('/js', 'su-extra');
        }
        su_query_asset('/css', 'su-panel');
        $return = '<div class="su-panel' . su_ecssc($atts) . '" data-url="' . $atts['url'] . '" style="background-color:' . $atts['background'] . ';color:' . $atts['color'] . ';border-radius:' . $atts['radius'] . 'px;-moz-border-radius:' . $atts['radius'] . 'px;-webkit-border-radius:' . $atts['radius'] . 'px;box-shadow:' . $atts['shadow'] . ';-moz-box-shadow:' . $atts['shadow'] . ';-webkit-box-shadow:' . $atts['shadow'] . ';border:' . $atts['border'] . '"><div class="su-panel-content su-content-wrap" style="text-align:' . $atts['text_align'] . '">' . do_shortcode($content) . '</div></div>';
        return $return;
    }

}

if (function_exists('panel')) {
    add_shortcode('panel', 'panel');
}



/* ------------------------------- photo_panel ----------------------------------------------- */
if (!function_exists('photo_panel')) {

    function photo_panel($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'background' => '#ffffff',
            'color' => '#333333',
            'shadow' => '0 1px 2px #eeeeee',
            'border' => '1px solid #cccccc',
            'radius' => '0',
            'text_align' => 'left',
            'photo' => 'http://lorempixel.com/400/300/food/' . rand(0, 10) . '/',
            'url' => '',
            'class' => ''
                ), $atts, 'photo_panel');
        if ($atts['url']) {
            $atts['class'] .= ' su-panel-clickable';
            su_query_asset('/js', 'su-extra');
        }
        su_query_asset('/css', 'su-photo-panel');
        $image_radius = $atts['radius'] - $atts['border'];
        $return = '<div class="su-photo-panel' . su_ecssc($atts) . '" data-url="' . $atts['url'] . '" style="background-color:' . $atts['background'] . ';color:' . $atts['color'] . ';border-radius:' . $atts['radius'] . 'px;-moz-border-radius:' . $atts['radius'] . 'px;-webkit-border-radius:' . $atts['radius'] . 'px;box-shadow:' . $atts['shadow'] . ';-moz-box-shadow:' . $atts['shadow'] . ';-webkit-box-shadow:' . $atts['shadow'] . ';border:' . $atts['border'] . '"><div class="su-photo-panel-head"><img src="' . image_media($atts['photo']) . '" alt="" style="-webkit-border-top-left-radius:' . $image_radius . 'px;-webkit-border-top-right-radius:' . $image_radius . 'px;-moz-border-radius-topleft:' . $image_radius . 'px;-moz-border-radius-topright:' . $image_radius . 'px;border-top-left-radius:' . $image_radius . 'px;border-top-right-radius:' . $image_radius . 'px;" /></div><div class="su-photo-panel-content su-content-wrap" style="text-align:' . $atts['text_align'] . '">' . do_shortcode($content) . '</div></div>';
        return $return;
    }

}

if (function_exists('photo_panel')) {
    add_shortcode('photo_panel', 'photo_panel');
}




/* ------------------------------- icon_panel ----------------------------------------------- */
if (!function_exists('icon_panel')) {

    function icon_panel($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'background' => '#ffffff',
            'color' => '#333333',
            'shadow' => '0 1px 2px #eeeeee',
            'border' => '1px solid #cccccc',
            'radius' => '0',
            'text_align' => 'center',
            'icon' => 'icon: heart',
            'icon_color' => '#333333',
            'icon_size' => 24,
            'url' => '',
            'class' => ''
                ), $atts, 'icon_panel');
        if ($atts['url']) {
            $atts['class'] .= ' su-panel-clickable';
            su_query_asset('/js', 'su-extra');
        }
        if (strpos($atts['icon'], 'icon:') !== false) {
            $atts['icon'] = '<i class="fa fa-' . trim(str_replace('icon:', '', $atts['icon'])) . '" style="font-size:' . $atts['icon_size'] . 'px;color:' . $atts['icon_color'] . '"></i>';
            
        } else
            $atts['icon'] = '<img src="' . image_media($atts['icon']) . '" style="width:' . $atts['icon_size'] . 'px" alt="" />';
        su_query_asset('/css', 'su-extra');
        $return = '<div class="su-icon-panel' . su_ecssc($atts) . '" data-url="' . $atts['url'] . '" style="background-color:' . $atts['background'] . ';color:' . $atts['color'] . ';border-radius:' . $atts['radius'] . 'px;-moz-border-radius:' . $atts['radius'] . 'px;-webkit-border-radius:' . $atts['radius'] . 'px;box-shadow:' . $atts['shadow'] . ';-moz-box-shadow:' . $atts['shadow'] . ';-webkit-box-shadow:' . $atts['shadow'] . ';border:' . $atts['border'] . '"><div class="su-icon-panel-head">' . $atts['icon'] . '</div><div class="su-icon-panel-content su-content-wrap" style="text-align:' . $atts['text_align'] . '">' . do_shortcode($content) . '</div></div>';
        return $return;
    }

}

if (function_exists('icon_panel')) {
    add_shortcode('icon_panel', 'icon_panel');
}



/* ------------------------------- progress_pie ----------------------------------------------- */
if (!function_exists('progress_pie')) {

    function progress_pie($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'percent' => 75,
            'text' => '',
            'before' => '',
            'after' => '',
            'size' => 200,
            'pie_width' => 30,
            'text_size' => 40,
            'align' => 'center',
            'pie_color' => '#f0f0f0',
            'fill_color' => '#97daed',
            'text_color' => '#cccccc',
            'class' => ''
                ), $atts, 'progress_pie');
        su_query_asset('/css', 'su-progress-pie');
        su_query_asset('/js', 'su-chart');
        su_query_asset('/js', 'su-extra');
        if (!$atts['text'])
            $atts['text'] = $atts['percent'];
        $return = '<div class="su-progress-pie su-progress-pie-align-' . $atts['align'] . su_ecssc($atts) . '" style="width:' . $atts['size'] . 'px;height:' . $atts['size'] . 'px" data-percent="' . $atts['percent'] . '" data-size="' . $atts['size'] . '" data-pie_width="' . $atts['pie_width'] . '" data-pie_color="' . $atts['pie_color'] . '" data-fill_color="' . $atts['fill_color'] . '"><canvas width="' . $atts['size'] . '" height="' . $atts['size'] . '"></canvas><div style="color:' . $atts['text_color'] . ';line-height:' . $atts['size'] . 'px;font-size:' . $atts['text_size'] . 'px"><span class="su-progress-pie-before">' . $atts['before'] . '</span><span class="su-progress-pie-text">' . $atts['text'] . '</span><span class="su-progress-pie-after">' . $atts['after'] . '</span></div></div>';
        return $return;
    }

}

if (function_exists('progress_pie')) {
    add_shortcode('progress_pie', 'progress_pie');
}



/* ------------------------------- progress_bar ----------------------------------------------- */
if (!function_exists('progress_bar')) {

    function progress_bar($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'style' => 'default',
            'percent' => 75,
            'text' => '',
            'bar_color' => '#f0f0f0',
            'fill_color' => '#97daed',
            'text_color' => '#555555',
            'class' => ''
                ), $atts, 'progress_bar');
        su_query_asset('/css', 'su-progress-bar');
        su_query_asset('/js', 'su-inview');
        su_query_asset('/js', 'su-extra');
        if (!$atts['text'])
            $atts['text'] = $atts['percent'];
        $return = '<div class="su-progress-bar su-progress-bar-style-' . $atts['style'] . su_ecssc($atts) . '" style="background-color:' . $atts['bar_color'] . ';border-color:' . su_hex_shift($atts['bar_color'], 'darker', 10) . '" data-percent="' . $atts['percent'] . '"><span style="width:0;background-color:' . $atts['fill_color'] . ';color:' . $atts['text_color'] . '"><span>' . $atts['text'] . '</span></span></div>';
        return $return;
    }
}

if (function_exists('progress_bar')) {
    add_shortcode('progress_bar', 'progress_bar');
}


/* ------------------------------- member ----------------------------------------------- */
if (!function_exists('member')) {

    function member($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'background' => '#ffffff',
            'color' => '#333333',
            'shadow' => '0 1px 2px #eee',
            'border' => '1px solid #ccc',
            'radius' => '0',
            'text_align' => 'left',
            'photo' => 'http://lorempixel.com/400/300/business/' . rand(0, 10) . '/',
            'name' => __('John Doe', 'su'),
            'role' => __('Designer', 'su'),
            'icon_1' => '',
            'icon_1_url' => '',
            'icon_1_color' => '#333',
            'icon_1_title' => '',
            'icon_2' => '',
            'icon_2_url' => '',
            'icon_2_color' => '#333',
            'icon_2_title' => '',
            'icon_3' => '',
            'icon_3_url' => '',
            'icon_3_color' => '#333',
            'icon_3_title' => '',
            'icon_4' => '',
            'icon_4_url' => '',
            'icon_4_color' => '#333',
            'icon_4_title' => '',
            'icon_5' => '',
            'icon_5_url' => '',
            'icon_5_color' => '#333',
            'icon_5_title' => '',
            'icon_6' => '',
            'icon_6_url' => '',
            'icon_6_color' => '#333',
            'icon_6_title' => '',
            'url' => '',
            'class' => ''
                ), $atts, 'member');
        if ($atts['url']) {
            $atts['class'] .= ' su-panel-clickable';
            su_query_asset('/js', 'su-extra');
        }
        su_query_asset('/css', 'su-membar');
        $icons = array();
        for ($i = 1; $i <= 6; $i++) {
            if (!$atts['icon_' . $i] || !$atts['icon_' . $i . '_url'])
                continue;
            if (strpos($atts['icon_' . $i], 'icon:') !== false) {
                $icon = '<i class="fa fa-' . trim(str_replace('icon:', '', $atts['icon_' . $i])) . '" style="color:' . $atts['icon_' . $i . '_color'] . '"></i>';
                
            } else
                $icon = '<img src="' . image_media($atts['icon_' . $i]) . '" width="16" height="16" alt="" />';
            $icons[] = '<a href="' . $atts['icon_' . $i . '_url'] . '" title="' . $atts['icon_' . $i . '_title'] . '" class="su-memeber-icon" target="_blank">' . $icon . '</a>';
        }
        $icons = ( count($icons) ) ? '<div class="su-member-icons" style="text-align:' . $atts['text_align'] . ';border-top:' . $atts['border'] . '">' . implode('', $icons) . '</div>' : '';
        return '<div class="su-member' . su_ecssc($atts) . '" data-url="' . $atts['url'] . '" style="background-color:' . $atts['background'] . ';color:' . $atts['color'] . ';border-radius:' . $atts['radius'] . 'px;-moz-border-radius:' . $atts['radius'] . 'px;-webkit-border-radius:' . $atts['radius'] . 'px;box-shadow:' . $atts['shadow'] . ';-moz-box-shadow:' . $atts['shadow'] . ';-webkit-box-shadow:' . $atts['shadow'] . ';border:' . $atts['border'] . '"><div class="su-member-photo"><img src="' . image_media($atts['photo']) . '" alt="" style="-webkit-border-top-left-radius:' . $atts['radius'] . 'px;-webkit-border-top-right-radius:' . $atts['radius'] . 'px;-moz-border-radius-topleft:' . $atts['radius'] . 'px;-moz-border-radius-topright:' . $atts['radius'] . 'px;border-top-left-radius:' . $atts['radius'] . 'px;border-top-right-radius:' . $atts['radius'] . 'px;" /></div><div class="su-member-info" style="text-align:' . $atts['text_align'] . '"><span class="su-member-name">' . $atts['name'] . '</span><span class="su-member-role">' . $atts['role'] . '</span><div class="su-member-desc su-content-wrap">' . do_shortcode($content) . '</div></div>' . $icons . '</div>';
    }

}

if (function_exists('member')) {
    add_shortcode('member', 'member');
}


/* ------------------------------- section ----------------------------------------------- */
if (!function_exists('section')) {

    function section($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'background' => '#ffffff',
            'image' => '',
            'repeat' => 'repeat',
            'parallax' => 'yes',
            'speed' => '10',
            'max_width' => '960',
            'margin' => '0px 0px 0px 0px',
            'padding' => '30px 0px 30px 0px',
            'border' => '1px solid #cccccc',
            'color' => '#333333',
            'text_align' => 'left',
            'text_shadow' => '0 1px 10px #ffffff',
            'url' => '',
            'class' => ''
                ), $atts, 'section');
        // Make section clickable
        if ($atts['url']) {
            $atts['class'] .= ' su-panel-clickable';
            su_query_asset('/js', 'su-extra');
        }
        // Prepare background property
        $background = ( $atts['image'] )
                // With background image
                ? sprintf('%s %s url(\'%s\') repeat %s', $atts['background'], '50% 0', $atts['image'], ( $atts['parallax'] === 'yes' ) ? 'fixed' : 'scroll' )
                // Only background color
                : $atts['background'];
        // Query parallax script and add special class
        if ($atts['image'] && $atts['parallax'] === 'yes') {
            su_query_asset('/js', 'su-extra');
            $atts['class'] .= ' su-section-parallax';
        }
        // Query stylesheet
        su_query_asset('/css', 'su-section');
        // Output
        return '<div class="su-section' . su_ecssc($atts) . '" data-url="' . $atts['url'] . '" data-speed="' . $atts['speed'] . '" style="background:' . $background . ';margin:' . $atts['margin'] . ';padding:' . $atts['padding'] . ';border-top:' . $atts['border'] . ';border-bottom:' . $atts['border'] . '"><div class="su-section-content su-content-wrap" style="max-width:' . $atts['max_width'] . 'px;text-align:' . $atts['text_align'] . ';color:' . $atts['color'] . ';-webkit-text-shadow:' . $atts['text_shadow'] . ';-moz-text-shadow:' . $atts['text_shadow'] . ';text-shadow:' . $atts['text_shadow'] . '">' . do_shortcode($content) . '</div></div>';
    }

}

if (function_exists('section')) {
    add_shortcode('section', 'section');
}



/* ------------------------------- pricing_table ----------------------------------------------- */
$GLOBALS['plans'] = null;
$GLOBALS['count_plans'] = 0;
if (!function_exists('pricing_table')) {

    function pricing_table($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'class' => ''
                ), $atts, 'pricing_table');

        // Prepare global static variable self::$plans
        do_shortcode($content);
        // Prepare local function variables
        $plans = array();
        $count = $GLOBALS['count_plans'];
        if (is_array($GLOBALS['plans'])) {
            // Render plans
            foreach ($GLOBALS['plans'] as $plan) {
                $plans[] = _plan($plan['atts'], $plan['content']);
            }
            // Return result
            $return = '<div class="su-pricing-table su-clearfix su-pricing-table-size-' . $count . su_ecssc($atts) . '">' . implode('', $plans) . '</div>';
        }
        $GLOBALS['plans'] = null;
        $GLOBALS['count_plans'] = 0;
        return $return;
    }

}

if (function_exists('pricing_table')) {
    add_shortcode('pricing_table', 'pricing_table');
}


/* ------------------------------- _plan ----------------------------------------------- */
if (!function_exists('_plan')) {

    function _plan($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'name' => '',
            'price' => '',
            'before' => '',
            'after' => '',
            'period' => '',
            'featured' => 'no',
            'background' => '#f9f9f9',
            'color' => '#333333',
            'border' => '#eeeeee',
            'shadow' => '0px 0px 25px #eeeeee',
            'icon' => '',
            'icon_color' => '#333333',
            'icon_size' => '48',
            'btn_url' => '',
            'btn_target' => 'self',
            'btn_text' => '',
            'btn_background' => '#999999',
            'btn_color' => '#ffffff',
            'class' => ''
                ), $atts, 'plan');
        // Prepare icon
        if ($atts['icon']) {
            if (strpos($atts['icon'], 'icon:') !== false) {
                $atts['icon'] = '<div class="su-plan-icon">' . $atts['icon'] = '<i class="fa fa-' . trim(str_replace('icon:', '', $atts['icon'])) . '" style="font-size:' . $atts['icon_size'] . 'px;color:' . $atts['icon_color'] . '"></i>' . '</div>';
                
            } else {
                $atts['icon'] = '<div class="su-plan-icon">' . '<img style="max-width: 95%" src="' . image_media($atts['icon']) . '" alt="" />' . '</div>';
            }
        }
        // Prepare markup
        if ($atts['before'])
            $atts['before'] = '<span class="su-plan-price-before">' . $atts['before'] . '</span>';
        if ($atts['after'])
            $atts['after'] = '<span class="su-plan-price-after">' . $atts['after'] . '</span>';
        if ($atts['period'])
            $atts['period'] = '<div class="su-plan-period">' . $atts['period'] . '</div>';
        // Add featured class
        if ($atts['featured'] === 'yes')
            $atts['class'] .= ' su-plan-featured';
        // Prepare box-shadow style
        $atts['shadow'] = ( $atts['featured'] === 'yes' ) ? ';-webkit-box-shadow:' . $atts['shadow'] . ';-moz-box-shadow:' . $atts['shadow'] . ';box-shadow:' . $atts['shadow'] : '';
        // Query stylesheet and scripts
        su_query_asset('/css', 'su-pricing-table');
        su_query_asset('/js', 'su-extra');
        // Clean-up options list
        $content = trim(strip_tags(do_shortcode($content), '<br><ul><li><a><b><strong><i><em><span>'));
        // Prepare button markup
        $button = ( $atts['btn_text'] && $atts['btn_url'] ) ? '<a href="' . $atts['btn_url'] . '" class="su-plan-button" style="background-color:' . $atts['btn_background'] . ';color:' . $atts['btn_color'] . ';border:2px solid ' . $atts['btn_background'] . '" target="_' . $atts['btn_target'] . '">' . $atts['btn_text'] . '</a>' : '';
        // Prepare footer markup
        $footer = ( $button ) ? '<div class="su-plan-footer" style="background-color:' . $atts['background'] . ';color:' . $atts['btn_background'] . ';border-color:' . su_hex_shift($atts['border'], 'lighter', 40) . '">' . $button . '</div>' : '';
        // Return result
        $return = '<div class="su-plan' . su_ecssc($atts) . '" style="border-color:' . $atts['border'] . $atts['shadow'] . '">'
                . '<div class="su-plan-head" style="background-color:' . $atts['background'] . ';color:' . $atts['color'] . ';border-color:' . su_hex_shift($atts['border'], 'lighter', 40) . '"><div class="su-plan-name">' . $atts['name'] . '</div>'
                . '<div class="su-plan-price">' . $atts['before'] . '<span class="su-plan-price-value">' . $atts['price'] . '</span>' . $atts['after'] . '</div>'
                . $atts['period'] . $atts['icon'] . '</div><div class="su-plan-options">' . $content . '</div>' . $footer . '</div>';

        return $return;
    }

}

if (function_exists('_plan')) {
    add_shortcode('_plan', '_plan');
}

/* ------------------------------- plan ----------------------------------------------- */
if (!function_exists('plan')) {

    function plan($atts = null, $content = null) {
        // Render single pricing plan in preview mode
        //if ( did_action( 'su/generator/preview/before' ) ) 

        $return = _plan($atts, $content);
        // Add new plan to the pricing table
        $plans = $GLOBALS['plans'];
        $x = $GLOBALS['count_plans'];
        $plans[$x] = array('atts' => $atts, 'content' => $content);
        $GLOBALS['plans'] = $plans;
        $GLOBALS['count_plans'] ++;
        return $return;
    }

}

if (function_exists('plan')) {
    add_shortcode('plan', 'plan');
}


/* ------------------------------- testimonial ----------------------------------------------- */
if (!function_exists('testimonial')) {

    function testimonial($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'name' => '',
            'photo' => '',
            'company' => '',
            'url' => '',
            'target' => 'blank',
            'border' => 'yes',
            'class' => ''
                ), $atts, 'testimonial');
        // Query stylesheet
        su_query_asset('/css', 'su-testimonial');
        // Add photo
        if ($atts['photo']) {
            // Add class
            $atts['class'] .= ' su-testimonial-has-photo';
            // Add markup
            $atts['photo'] = '<img src="' . image_media($atts['photo']) . '" alt="' . esc_attr($atts['name']) . '" class="su-testimonial-photo" width="40" height="40" />';
        }
        // Prepare company name
        if ($atts['company']) {
            // Add hyperlink
            $atts['company'] = ( $atts['url'] )
                    // Company name with hyperlink
                    ? '<a href="' . $atts['url'] . '" class="su-testimonial-company" target="_' . $atts['target'] . '">' . $atts['company'] . '</a>'
                    // Company name without link
                    : '<span class="su-testimonial-company">' . $atts['company'] . '</span>';
            // Add hyphen
            if ($atts['name'])
                $atts['company'] = ', ' . $atts['company'];
        }
        // Add border class
        if ($atts['border'] === 'yes')
            $atts['class'] .= ' su-testimonial-bordered';
        // Return result
        return '<div class="su-testimonial' . su_ecssc($atts) . '"><div class="su-testimonial-text su-content-wrap">' . do_shortcode($content) . '</div><div class="su-testimonial-cite"><span class="su-testimonial-name">' . $atts['name'] . '</span>' . $atts['company'] . '</div>' . $atts['photo'] . '</div>';
    }

}

if (function_exists('testimonial')) {
    add_shortcode('testimonial', 'testimonial');
}




/* ------------------------------- icon ----------------------------------------------- */
if (!function_exists('icon')) {

    function icon($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'icon' => '',
            'background' => '#eeeeee',
            'color' => '#333333',
            'size' => '32',
            'shape_size' => '16',
            'radius' => '256',
            'border' => '',
            'margin' => '',
            'url' => '',
            'target' => 'blank',
            'class' => ''
                ), $atts, 'icon');
        // Query stylesheet
        su_query_asset('/css', 'su-icon');
        // Prepare URL
        if (!$atts['url']) {
            // Add class
            $atts['class'] .= ' su-icon-no-url';
            // Change URL
            $atts['url'] = 'javascript:;';
        }
        // <img> icon
        if (strpos($atts['icon'], '/') !== false) {
            $atts['icon'] = '<img src="' . image_media($atts['icon']) . '" alt="" width="' . $atts['size'] . '" height="' . $atts['size'] . '" style="width:' . $atts['size'] . 'px;height:' . $atts['size'] . 'px;background:' . $atts['background'] . ';-webkit-border-radius:' . $atts['radius'] . 'px;-moz-border-radius:' . $atts['radius'] . 'px;border: '. $atts['border'].';border-radius:' . $atts['radius'] . 'px;padding:' . $atts['shape_size'] . 'px" />';
        }
        // Font-Awesome icon
        else if (strpos($atts['icon'], 'icon:') !== false) {
            $atts['icon'] = '<i class="fa fa-' . trim(str_replace('icon:', '', $atts['icon'])) . '" style="font-size:' . $atts['size'] . 'px;line-height:' . $atts['size'] . 'px;background:' . $atts['background'] . ';color:' . $atts['color'] . ';-webkit-border-radius:' . $atts['radius'] . 'px;-moz-border-radius:' . $atts['radius'] . 'px;border: '. $atts['border'].';border-radius:' . $atts['radius'] . 'px;padding:' . $atts['shape_size'] . 'px"></i>';
            
        }
        // Prepare text
        if ($content)
            $content = '<span class="su-icon-text">' . $content . '</span>';
        // Return result
        return '<a href="' . $atts['url'] . '" class="su-icon' . su_ecssc($atts) . '" style="margin:' . $atts['margin'] . '" target="_' . $atts['target'] . '">' . $atts['icon'] . do_shortcode($content) . '</a>';
    }

}

if (function_exists('icon')) {
    add_shortcode('icon', 'icon');
}





/* ------------------------------- content_slider ----------------------------------------------- */
if (!function_exists('content_slider')) {

    function content_slider($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'style' => 'default',
            'effect' => 'slide',
            'arrows' => 'yes',
            'pages' => 'no',
            'autoplay' => '5',
            'speed' => '0.5',
            'class' => ''
                ), $atts, 'content_slider');
        // Query assets
        su_query_asset('/css', 'su-owl-carousel');
        su_query_asset('/css', 'su-owl-carousel-transitions');
        su_query_asset('/css', 'su-su-content-slider');
        su_query_asset('/js', 'su-owl.carousel.min');
        su_query_asset('/js', 'su-extra');
        // Prepare autoplay value
        $atts['autoplay'] = $atts['autoplay'] * 1000;
        // Prepare speed value
        $atts['speed'] = $atts['speed'] * 1000;
        // Prepare effect value
        if ($atts['effect'] === 'slide')
            $atts['effect'] = 'false';
        // Return markup
        return '<div id="' . uniqid('su_content_slider_') . '" class="su-content-slider su-content-slider-arrows-' . $atts['arrows'] . ' su-content-slider-pages-' . $atts['pages'] . ' su-content-slider-style-' . $atts['style'] . su_ecssc($atts) . '" data-effect="' . $atts['effect'] . '" data-autoplay="' . $atts['autoplay'] . '" data-speed="' . $atts['speed'] . '">' . do_shortcode($content) . '</div>';
    }

}

if (function_exists('content_slider')) {
    add_shortcode('content_slider', 'content_slider');
}




/* ------------------------------- content_slide ----------------------------------------------- */
if (!function_exists('content_slide')) {

    function content_slide($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'class' => ''
                ), $atts, 'content_slide');
        return '<div class="su-content-slide su-clearfix su-content-wrap' . su_ecssc($atts) . '">' . do_shortcode($content) . '</div>';
    }

}

if (function_exists('content_slide')) {
    add_shortcode('content_slide', 'content_slide');
}




/* ------------------------------- shadow ----------------------------------------------- */
if (!function_exists('shadow')) {

    function shadow($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'style' => 'default',
            'inline' => 'no',
            'class' => ''
                ), $atts, 'shadow');
        su_query_asset('/css', 'su-shadow');
        return '<div class="su-shadow-wrap su-content-wrap su-shadow-inline-' . $atts['inline'] . su_ecssc($atts) . '"><div class="su-shadow su-shadow-style-' . $atts['style'] . '">' . do_shortcode($content) . '</div></div>';
    }

}

if (function_exists('shadow')) {
    add_shortcode('shadow', 'shadow');
}





/* ------------------------------- calltoaction ----------------------------------------------- */

if (!function_exists('calltoaction')) {

    function calltoaction($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'title' => '',
            'title_color' => '#FFFFFF',
            'button_text' => 'Purchase',
            'button_link' => '#',
            'target' => 'self',
            'color' => '#FFFFFF',
            'background' => '#2D89EF',
            'button_color' => '#FFFFFF',
            'button_background' => '#2D89EF',
            'radius' => '0',
            'button_radius' => '0',
            'desc' => '',
            'class' => ''
                ), $atts, 'calltoaction');

        su_query_asset('/css', 'su-call-to-action');

        $title = ($atts['title']) ? "<h3 style='color: ".$atts['title_color']."'>" . $atts['title'] . "</h3>" : '';
        $target = ( $atts['target'] === 'yes' || $atts['target'] === 'blank' ) ? ' target="_blank"' : '';

        $return = "<section class='call-to-action".su_ecssc($atts)."' style='background-color:" . $atts['background'] . "; border-radius:" . $atts['radius'] . "px;" . " '>";

        $return.= "<a style='border-radius:" . $atts['button_radius'] . "px;color:" . $atts['button_color'] . ";background:" . $atts['button_background'] . ";' class='cta-dbtn " . $atts['class'] . " hidden-phone' target='" . $target . "' href='" . $atts['button_link'] . "'>" . $atts['button_text'] . "</a>";

        $return.= "<div class='cta-content'>" . $title ."<div style='color:" . $atts['color'] . " '>". do_shortcode($content) . '</div></div>';

        $return.= "<a style='border-radius:" . $atts['button_radius'] . "px;color:" . $atts['button_color'] . ";background:" . $atts['button_background'] . ";' class='cta-dbtn " . $atts['class'] . " visible-phone' target='" . $target . "' href='" . $atts['button_link'] . "'>" . $atts['button_text'] . "</a>";

        $return.= '<div class="clear"></div></section>';

        return $return;
    }

}

if (function_exists('calltoaction')) {
    add_shortcode('calltoaction', 'calltoaction');
}



/* ------------------------------- flickr ----------------------------------------------- */


if (!function_exists('flickr')) {

    function flickr($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'id' => '95572727@N00',
            'limit' => '9',
            'lightbox' => '',
            'radius' => 'auto',
            'class' => ''
                ), $atts, 'flickr');

        $rounded = ($atts['radius']) ? 'border-radius: ' . $atts['radius'] . 'px;' : '';

        $style = 'style="' . $rounded . '"';

        $image = ($atts['lightbox'] == 'yes') ? '<a class="su-lightbox" data-mfp-type="image" href="{{image_b}}" title="{{title}}"' . $style . '> ' : '';
        $image .= '<img ' . $style . ' src="{{image_s}}" alt="{{title}}" />';
        $image .= ($atts['lightbox'] == 'yes') ? '</a> ' : '';

        $unique_id = uniqid("flickr_");

        if ($atts['lightbox'] == 'yes') {
            $atts['class'] .= ' su-lightbox-gallery';
            su_query_asset('/js', 'su-galleries-shortcodes');
            su_query_asset('/css', 'su-galleries-shortcodes');
            su_query_asset('/css', 'su-magnific-popup');
            su_query_asset('/js', 'su-magnific-popup');
            su_query_asset('/js', 'su-other-shortcodes');
        }
        su_query_asset('/css', 'su-flickr');
        su_query_asset('/js', 'su-flickr');

        $return = "<ul id='".$unique_id."' class='flickrfeed".su_ecssc($atts)."'></ul> <div class='clear'></div>";

        echo "<script type='text/javascript'> 
              jQuery(document).ready(function() {
                      jQuery('#".$unique_id."').jflickrfeed({ 
                        limit: " . $atts['limit'] . ", qstrings: { 
                          id: '" . $atts['id'] . "'}, 
                          itemTemplate: '<li>" . addslashes($image) . "</li>' });
                    });
              </script> ";
   
        return $return;
    }

}

if (function_exists('flickr')) {
    add_shortcode('flickr', 'flickr');
}






/* ------------------------------- flip_box ----------------------------------------------- */
if (!function_exists('flip_box')) {
  function flip_box( $atts = null, $content = null ) {
    $atts = shortcode_atts( array(
        'animation_style'       => 'horizontal_flip_left',
        'background'=> '',
        'color'=> '',
        'border'      => 'none',
        'shadow'      => 'none',
        'radius'      => 'none',
        'text_align'      => 'none',
        'class'      => ''
      ), $atts, 'flip_box' );


    $GLOBALS['flip_box_atts'] = $atts; 

    su_query_asset( '/css', 'su-flip-box' );

    $return = '
        <div class="flip-box-wrap' . $atts['class'] . '"><div class="su-flip-box '.$atts['animation_style'].'">
            '.do_shortcode($content).'<div style="clear:both;height:0"></div>
        </div></div>';

    return $return;
  }
}



if (function_exists('flip_box')) {
    add_shortcode('flip_box', 'flip_box');
}



/* ------------------------------- flip_front ----------------------------------------------- */
if (!function_exists('flip_front')) {

    function flip_front($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'background' => '',
            'color'      => '',
            'border'     => '',
            'shadow'     => '',
            'radius'     => '',
            'text_align' => '',
            'class'      => ''
                ), $atts, 'flip_front');

        $atts['background'] = ($atts['background']) ? $atts['background'] : $GLOBALS['flip_box_atts']['background'];
        $atts['color'] = ($atts['color']) ? $atts['color'] : $GLOBALS['flip_box_atts']['color'];
        $atts['border'] = ($atts['border']) ? $atts['border'] : $GLOBALS['flip_box_atts']['border'];
        $atts['radius'] = ($atts['radius']) ? $atts['radius'] : $GLOBALS['flip_box_atts']['radius'];
        $atts['shadow'] = ($atts['shadow']) ? $atts['shadow'] : $GLOBALS['flip_box_atts']['shadow'];
        $atts['text_align'] = ($atts['text_align']) ? $atts['text_align'] : $GLOBALS['flip_box_atts']['text_align'];

        return '<div class="front-flip_box"
                    style="background-color:' . $atts['background']. ';
                    color:' . $atts['color'] .';
                    border:' . $atts['border'] .';
                    box-shadow:'.$atts['shadow'].';
                    border-radius:'.$atts['radius'].'px;
                    text-align:'.$atts['text_align'].';
                    ' . su_ecssc($atts) . '">' . do_shortcode($content) . '</div>';
    }

}

if (function_exists('flip_front')) {
    add_shortcode('flip_front', 'flip_front');
}

/* ------------------------------- flip_back ----------------------------------------------- */
if (!function_exists('flip_back')) {

    function flip_back($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'background' => '',
            'color'      => '',
            'border'     => '',
            'shadow'     => '',
            'radius'     => '',
            'text_align' => '',
            'class'      => ''
                ), $atts, 'flip_back');

        $atts['background'] = ($atts['background']) ? $atts['background'] : $GLOBALS['flip_box_atts']['background'];
        $atts['color'] = ($atts['color']) ? $atts['color'] : $GLOBALS['flip_box_atts']['color'];
        $atts['border'] = ($atts['border']) ? $atts['border'] : $GLOBALS['flip_box_atts']['border'];
        $atts['radius'] = ($atts['radius']) ? $atts['radius'] : $GLOBALS['flip_box_atts']['radius'];
        $atts['shadow'] = ($atts['shadow']) ? $atts['shadow'] : $GLOBALS['flip_box_atts']['shadow'];
        $atts['text_align'] = ($atts['text_align']) ? $atts['text_align'] : $GLOBALS['flip_box_atts']['text_align'];

        return '<div class="back-flip_box"
                   style="background-color:' . $atts['background']. ';
                   color:' . $atts['color'] .';
                   border:' . $atts['border'] .';
                   box-shadow:'.$atts['shadow'].';
                   border-radius:'.$atts['radius'].'px;
                   text-align:'.$atts['text_align'].';
                        ' . su_ecssc($atts) . '">' . do_shortcode($content) . '</div>';
    }

}

if (function_exists('flip_back')) {
    add_shortcode('flip_back', 'flip_back');
}





/* ------------------------------- icon_list_item ----------------------------------------------- */
if (!function_exists('icon_list_item')) {

    function icon_list_item($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'title' => 'icon list item title',
            'color' => '#333333',
            'background' => 'transparent',
            'icon' => 'icon: heart',
            'icon_color' => '#333333',
            'icon_size' => 24,
            'icon_border' => '',
            'icon_shadow' => '0 0 0 #444444',
            'icon_radius' => '50',
            'text_align'  => '',
            'connector'  => '',
            'description_gap'  => '',
            'class' => ''
                ), $atts, 'icon_list_item');

        if (strpos($atts['icon'], 'icon:') !== false) {
            $atts['icon'] = '<i class="list-img-icon fa fa-' . trim(str_replace('icon:', '', $atts['icon'])) . '" style="font-size:' . $atts['icon_size'] . 'px;color:' . $atts['icon_color'] . '"></i>';
            
        } else
            $atts['icon'] = '<img class="list-img-icon"src="'.image_media($atts['icon']).'" style="width:'.$atts['icon_size'].'px" alt="" />';




        if ($atts['text_align'] == 'right') {
            if (($atts['background']=='transparent' || $atts['background']=='') && ($atts['icon_border']=='' || substr($atts['icon_border'],0,1) =='0')) {
                $description_margin = 'margin-right: '.(($atts['icon_size'])+15).'px;'; 
            }
            else {
                $description_margin = 'margin-right: '.(($atts['icon_size']*2)+25+($atts['icon_border']*2)).'px;';
            }
            
        }elseif ($atts['text_align'] == 'left') {
            if (($atts['background']=='transparent' || $atts['background']=='') && ($atts['icon_border']=='' || substr($atts['icon_border'],0,1) =='0')) {
                $description_margin = 'margin-left: '.(($atts['icon_size'])+15).'px;';
            }
            else {
                $description_margin = 'margin-left: '.(($atts['icon_size']*2)+25+($atts['icon_border']*2)).'px;'; 
            }
        }else {$description_margin="";}


        $padding = '';
        if (($atts['background']=='transparent' || $atts['background']=='') && ($atts['icon_border']=='' || substr($atts['icon_border'],0,1) =='0')) {
            $padding = 'padding: 0;';
        }else {
            $padding = 'padding:' . ( round($atts['icon_size'] / 2) ) . 'px;';
        }
        
        if ($atts['text_align'] == 'top') {$atts['description_gap'] = 'no';}

        $description_gap = '';
        if ($atts['description_gap'] == 'yes') {
            $atts['connector'] = 'no';
            if (($atts['background']=='transparent' || $atts['background']=='') && ($atts['icon_border']=='' || substr($atts['icon_border'],0,1) =='0')) {
                $description_gap = 'height: '. ($atts['icon_size']) .'px; margin-bottom: 0;';
            }else {
                $description_gap = 'height: '. (($atts['icon_size']*2) + ($atts['icon_border']*2 )) .'px; margin-bottom: 0;';
            }
        }

        $atts['description_gap'] = ($atts['description_gap']=='yes') ? 'description-gap' : '' ;
        
        $icon_list_connector = ($atts['connector']=="yes" && ($atts['text_align'] == 'right'||$atts['text_align'] == 'left')) ? 'icon_list_connector' : '' ;
        su_query_asset('/css', 'su-icon-list');
        $has_connector = ($atts['connector'] == 'yes') ? ' has-connector ':'';

        $return = '
            <div class="su-icon-list su-'. $atts['text_align'] .$has_connector.'">
            <div class="icon_list_item'.' '. $atts['description_gap'].' '. su_ecssc($atts) . '"style="color:' . $atts['color'] .'">
                <div class="icon_list_wrapper '. $icon_list_connector .'">
                    <div class="icon_list_icon" 
                        style="color:' . $atts['icon_color'] . ';
                            background:' . $atts['background'] . ';
                            font-size:' . $atts['icon_size'] . 'px;
                            width:' . $atts['icon_size'] . 'px;
                            height:' . $atts['icon_size'] . 'px;
                            '. $padding .'
                            border:' . $atts['icon_border'] . ';
                            box-shadow:' . $atts['icon_shadow'] . ';
                            border-radius:' . $atts['icon_radius'] . 'px;">' 

                        . $atts['icon'] . '
                    </div>
                </div>

                <div class="icon_description" style="'.$description_margin.'">
                    <h3 style="'.$description_gap.'">'.$atts['title'].'</h3>
                    <p class="icon_description_text" style="color:' . $atts['color'] . '">'
                     . do_shortcode($content) . 
                    '</p>
                </div>                

                <div style="clear:both;height:0"></div>
            </div>
            </div>';

        return $return;
    }

}

if (function_exists('icon_list_item')) {
    add_shortcode('icon_list_item', 'icon_list_item');
}



/* ------------------------------- counter ----------------------------------------------- */
if (!function_exists('counter')) {

    function counter($atts = null, $content = null) {
        $atts = shortcode_atts(array(
            'count_start' => '1',
            'count_end' => '5000',
            'counter_refresh_interval' => '50',
            'counter_speed' => '5000',
            'count_color' => '#333',
            'count_size' => '50',
            'text_color' => '',
            'text_size' => '',
            'border' => '',
            'background' => '',
            'class' => ''
                ), $atts, 'counter');

        su_query_asset('/js', 'su-jquery.countTo');
        su_query_asset('/css', 'su-other-shortcodes');

        $uniqe_id = 'counter_'.rand(9, 9999);

        return '<div 
                class="counter-wrapper counter-block counter-top'. su_ecssc($atts) . '" 
                id="'. $uniqe_id .'"
                style="border:'.$atts['border'].'; background-color: '.$atts['background'].'">
                    <div class="counter-desc">
                        <div align="center" 
                            class="counter-number" 
                            style="color: '.$atts['count_color'].';
                                font-size: '.$atts['count_size'].'px;" 
                            data-from="'.$atts['count_start'].'" 
                            data-to="'.$atts['count_end'].'" 
                            data-refresh-interval="'.$atts['counter_refresh_interval'].'" 
                            data-speed="'.$atts['counter_speed'].'">
                        </div>
                        <div align="center" 
                            class="counter-text" 
                            style="color: '.$atts['text_color'].'; 
                                font-size: '.$atts['text_size'].'px;">
                                '. do_shortcode($content) . '
                        </div> 
                        
                    </div>
                </div>';
    }

}

if (function_exists('counter')) {
    add_shortcode('counter', 'counter');
}


