jQuery(document).ready(function ($) {
	// Splash screen
	$('.su-splash').each(function () {
		var $splash = $(this),
			data = $splash.data(),
			$screen = $splash.children('.su-splash-screen');
		// Remove empty P's
		$screen.find('p:empty').remove();
		// Open popup with delay
		window.setTimeout(function () {
			// Create popup
			$.magnificPopup.open({
				closeOnBgClick: data.onclick === 'close-bg',
				closeBtnInside: true,
				showCloseBtn: data.close === 'yes',
				enableEscapeKey: data.esc === 'yes',
				callbacks: {
					beforeOpen: function () {
						// Add style class
						$('body').addClass(data.style);
					},
					open: function () {
						// Set window width
						$screen.css('max-width', data.width + 'px');
						// Set bg opacity
						$('.mfp-bg').css('opacity', data.opacity);
						// Set action for click
						$('body').on('mousedown.su', function (e) {
							// Go to url
							if (data.onclick === 'url') {
								var tag = e.target.nodeName.toLowerCase();
								if (tag === 'button' || tag === 'a') return;
								else window.location.href = data.url;
							}
							// Close screen
							else if (data.onclick === 'close') $.magnificPopup.close();
						});
					},
					close: function () {
						// Remove all styles
						$('.mfp-bg').attr('style', '');
						// Remove style class
						$('body').removeClass(data.style);
						// Remove click action
						$('body').unbind('mousedown.su');
					}
				},
				items: {
					src: $screen.remove()
				},
				type: 'inline'
			}, 0);
		}, parseInt(data.delay) * 1000 + 10);
	});

	// Photo/Icon panel
	$('body:not(.su-extra-loaded)').on('click', '.su-panel-clickable', function (e) {
		document.location.href = $(this).data('url');
	});

	// Progress pie
	$('.su-progress-pie').each(function () {
		// Prepare data
		var $pie = $(this),
			$canvas = $pie.children('canvas'),
			$text = $pie.children('div'),
			$data = $pie.data(),
			context = $canvas.get(0).getContext('2d'),
			chart, data = [],
			options = {};
		// Chart data
		data = [{
			value: $data.percent,
			color: $data.fill_color
		}, {
			value: 100 - $data.percent,
			color: $data.pie_color
		}];
		// Chart options
		options.segmentShowStroke = false;
		options.animationEasing = 'easeOutQuart';
		options.percentageInnerCutout = 100 - $data.pie_width;
		// Create chart
		chart = new Chart(context).Doughnut(data, options);
	});

	// Progress bar
	$('.su-progress-bar').on('inview', function () {
		var $this = $(this),
			$span = $this.children('span'),
			percent = $this.data('percent');
		$span.animate({
			width: percent + '%'
		}, percent * 12);
	});

	// Section with parallax
	var $window = $(window);
	$('.su-section-parallax').each(function () {
		var $this = $(this);
		$(window).on('scroll touchmove', function () {
			var yPos = -($window.scrollTop() / $this.data('speed'));
			var coords = '50% ' + yPos + 'px';
			$this.css({
				backgroundPosition: coords
			});
		});
	});

	// Content slider
	$('.su-content-slider').each(function () {
		var $slider = $(this),
			$panels = $slider.children('div'),
			data = $slider.data(),
			autoplay;
		// Remove unwanted br's
		$slider.children(':not(.su-content-slide)').remove();
		// Apply Owl Carousel
		$slider.owlCarousel({
			autoPlay: (data.autoplay > 0) ? data.autoplay : false,
			stopOnHover: true,
			navigation: true,
			paginationSpeed: data.speed,
			goToFirstSpeed: data.speed,
			singleItem: true,
			autoHeight: true,
			transitionStyle: data.effect,
			navigationText: ['', '']
		});
		// Adjust slide height on click
		$slider.on('click', '.su-content-slide', function (e) {
			window.setTimeout(function () {
				$slider.data('owlCarousel').autoHeight();
			}, 300);
		});
		// Stop slider on click
		$slider.on('click', function (e) {
			$slider.trigger('owl.stop');
		});
	});

	$('body').addClass('su-extra-loaded');
});